/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.examples.complex.sales;

import net.sf.dynamicreports.examples.Templates;
import net.sf.dynamicreports.examples.complex.sales.SalesData;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.chart.AbstractCategoryChartSerieBuilder;
import net.sf.dynamicreports.report.builder.chart.Bar3DChartBuilder;
import net.sf.dynamicreports.report.builder.chart.CategoryChartSerieBuilder;
import net.sf.dynamicreports.report.builder.chart.PieChartBuilder;
import net.sf.dynamicreports.report.builder.chart.TimeSeriesChartBuilder;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.PercentageColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.group.ColumnGroupBuilder;
import net.sf.dynamicreports.report.builder.group.GroupBuilder;
import net.sf.dynamicreports.report.builder.style.FontBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.builder.subtotal.AggregationSubtotalBuilder;
import net.sf.dynamicreports.report.builder.subtotal.PercentageSubtotalBuilder;
import net.sf.dynamicreports.report.builder.subtotal.SubtotalBuilder;
import net.sf.dynamicreports.report.constant.Orientation;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIValueFormatter;
import net.sf.dynamicreports.report.exception.DRException;

public class SalesDesign {
    private SalesData data = new SalesData();

    public JasperReportBuilder build() throws DRException {
        JasperReportBuilder report = DynamicReports.report();
        FontBuilder boldFont = DynamicReports.stl.fontArialBold();
        TextColumnBuilder stateColumn = DynamicReports.col.column("State", "state", (DRIDataType)DynamicReports.type.stringType());
        TextColumnBuilder itemColumn = (TextColumnBuilder)DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType()).setPrintRepeatedDetailValues(Boolean.valueOf(false));
        TextColumnBuilder orderDateColumn = DynamicReports.col.column("Order date", "orderdate", (DRIDataType)DynamicReports.type.dateType());
        TextColumnBuilder quantityColumn = DynamicReports.col.column("Quantity", "quantity", (DRIDataType)DynamicReports.type.integerType());
        TextColumnBuilder unitPriceColumn = DynamicReports.col.column("Unit price", "unitprice", (DRIDataType)Templates.currencyType);
        TextColumnBuilder priceColumn = (TextColumnBuilder)((TextColumnBuilder)unitPriceColumn.multiply(quantityColumn).setTitle("Price")).setDataType((DRIDataType)Templates.currencyType);
        PercentageColumnBuilder pricePercColumn = DynamicReports.col.percentageColumn("Price %", (ValueColumnBuilder)priceColumn);
        ColumnGroupBuilder stateGroup = DynamicReports.grp.group((ValueColumnBuilder)stateColumn);
        AggregationSubtotalBuilder priceAvg = (AggregationSubtotalBuilder)DynamicReports.sbt.avg((ValueColumnBuilder)priceColumn).setValueFormatter((DRIValueFormatter)Templates.createCurrencyValueFormatter("avg = "));
        AggregationSubtotalBuilder unitPriceSum = (AggregationSubtotalBuilder)((AggregationSubtotalBuilder)DynamicReports.sbt.sum((ValueColumnBuilder)unitPriceColumn).setLabel("Total:")).setLabelStyle((ReportStyleBuilder)Templates.boldStyle);
        AggregationSubtotalBuilder priceSum = (AggregationSubtotalBuilder)((AggregationSubtotalBuilder)DynamicReports.sbt.sum((ValueColumnBuilder)priceColumn).setLabel("")).setLabelStyle((ReportStyleBuilder)Templates.boldStyle);
        Bar3DChartBuilder itemChart = (Bar3DChartBuilder)((Bar3DChartBuilder)((Bar3DChartBuilder)((Bar3DChartBuilder)((Bar3DChartBuilder)DynamicReports.cht.bar3DChart().setTitle("Sales by item")).setTitleFont(boldFont)).setOrientation(Orientation.HORIZONTAL)).setCategory((ValueColumnBuilder)itemColumn)).addSerie(new AbstractCategoryChartSerieBuilder[]{DynamicReports.cht.serie((ValueColumnBuilder)unitPriceColumn), DynamicReports.cht.serie((ValueColumnBuilder)priceColumn)});
        TimeSeriesChartBuilder dateChart = (TimeSeriesChartBuilder)((TimeSeriesChartBuilder)((TimeSeriesChartBuilder)((TimeSeriesChartBuilder)((TimeSeriesChartBuilder)DynamicReports.cht.timeSeriesChart().setTitle("Sales by date")).setTitleFont(boldFont)).setFixedHeight(Integer.valueOf(150))).setTimePeriod((ValueColumnBuilder)orderDateColumn)).addSerie(new CategoryChartSerieBuilder[]{DynamicReports.cht.serie((ValueColumnBuilder)unitPriceColumn), DynamicReports.cht.serie((ValueColumnBuilder)priceColumn)});
        PieChartBuilder stateChart = (PieChartBuilder)((PieChartBuilder)((PieChartBuilder)((PieChartBuilder)((PieChartBuilder)((PieChartBuilder)DynamicReports.cht.pieChart().setTitle("Sales by state")).setTitleFont(boldFont)).setFixedHeight(Integer.valueOf(100))).setShowLegend(Boolean.valueOf(false))).setKey((ValueColumnBuilder)stateColumn)).addSerie(new CategoryChartSerieBuilder[]{DynamicReports.cht.serie((ValueColumnBuilder)priceColumn)});
        ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)report.setTemplate(Templates.reportTemplate)).columns(new ColumnBuilder[]{stateColumn, itemColumn, orderDateColumn, quantityColumn, unitPriceColumn, priceColumn, pricePercColumn})).groupBy(new GroupBuilder[]{stateGroup})).subtotalsAtFirstGroupFooter(new SubtotalBuilder[]{DynamicReports.sbt.sum((ValueColumnBuilder)unitPriceColumn), DynamicReports.sbt.sum((ValueColumnBuilder)priceColumn)})).subtotalsOfPercentageAtGroupFooter((GroupBuilder)stateGroup, new PercentageSubtotalBuilder[]{(PercentageSubtotalBuilder)DynamicReports.sbt.percentage((ValueColumnBuilder)priceColumn).setShowInColumn((ColumnBuilder)pricePercColumn)})).subtotalsAtSummary(new SubtotalBuilder[]{unitPriceSum, priceSum, priceAvg})).title(new ComponentBuilder[]{Templates.createTitleComponent("Sales"), DynamicReports.cmp.horizontalList(new ComponentBuilder[]{itemChart, DynamicReports.cmp.verticalList(new ComponentBuilder[]{dateChart, stateChart})}), DynamicReports.cmp.verticalGap(10)})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.data.createDataSource());
        return report;
    }

    public static void main(String[] args) {
        SalesDesign design = new SalesDesign();
        try {
            JasperReportBuilder report = design.build();
            report.show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }
}

