/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.examples.crosstab;

import java.math.BigDecimal;
import java.util.List;
import net.sf.dynamicreports.examples.Templates;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.crosstab.CrosstabBuilder;
import net.sf.dynamicreports.report.builder.crosstab.CrosstabColumnGroupBuilder;
import net.sf.dynamicreports.report.builder.crosstab.CrosstabMeasureBuilder;
import net.sf.dynamicreports.report.builder.crosstab.CrosstabRowGroupBuilder;
import net.sf.dynamicreports.report.builder.expression.AbstractComplexExpression;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.constant.Calculation;
import net.sf.dynamicreports.report.constant.PageOrientation;
import net.sf.dynamicreports.report.constant.PageType;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class CustomPercentageCrosstabReport {
    public CustomPercentageCrosstabReport() {
        this.build();
    }

    private void build() {
        CrosstabRowGroupBuilder rowGroup = (CrosstabRowGroupBuilder)DynamicReports.ctab.rowGroup("state", String.class).setTotalHeader("Total for state");
        CrosstabColumnGroupBuilder columnGroup = DynamicReports.ctab.columnGroup("item", String.class);
        FieldBuilder quantityField = DynamicReports.field((String)"unitprice", BigDecimal.class);
        CrosstabMeasureBuilder unitPriceMeasure = DynamicReports.ctab.measure("Unit price", quantityField, Calculation.SUM);
        CrosstabMeasureBuilder percentageMeasure = DynamicReports.ctab.measure("%", (DRIExpression)new PercentageExpression(unitPriceMeasure, columnGroup));
        percentageMeasure.setDataType((DRIDataType)DynamicReports.type.doubleType());
        CrosstabBuilder crosstab = DynamicReports.ctab.crosstab().headerCell(new ComponentBuilder[]{DynamicReports.cmp.text("State / Item").setStyle((ReportStyleBuilder)Templates.boldCenteredStyle)}).rowGroups(new CrosstabRowGroupBuilder[]{rowGroup}).columnGroups(new CrosstabColumnGroupBuilder[]{columnGroup}).measures(new CrosstabMeasureBuilder[]{unitPriceMeasure, percentageMeasure});
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setPageFormat(PageType.A4, PageOrientation.LANDSCAPE)).setTemplate(Templates.reportTemplate)).title(new ComponentBuilder[]{Templates.createTitleComponent("CustomPercentageCrosstab")})).summary(new ComponentBuilder[]{crosstab})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"state", "item", "unitprice"});
        dataSource.add(new Object[]{"New York", "Notebook", new BigDecimal(500)});
        dataSource.add(new Object[]{"New York", "DVD", new BigDecimal(30)});
        dataSource.add(new Object[]{"New York", "DVD", new BigDecimal(45.6)});
        dataSource.add(new Object[]{"New York", "DVD", new BigDecimal(36)});
        dataSource.add(new Object[]{"New York", "DVD", new BigDecimal(41)});
        dataSource.add(new Object[]{"New York", "Book", new BigDecimal(11)});
        dataSource.add(new Object[]{"New York", "Book", new BigDecimal(9)});
        dataSource.add(new Object[]{"New York", "Book", new BigDecimal(14.8)});
        dataSource.add(new Object[]{"Washington", "Notebook", new BigDecimal(610)});
        dataSource.add(new Object[]{"Washington", "DVD", new BigDecimal(40)});
        dataSource.add(new Object[]{"Washington", "DVD", new BigDecimal(35)});
        dataSource.add(new Object[]{"Washington", "DVD", new BigDecimal(46.4)});
        dataSource.add(new Object[]{"Washington", "DVD", new BigDecimal(42)});
        dataSource.add(new Object[]{"Washington", "Book", new BigDecimal(12)});
        dataSource.add(new Object[]{"Washington", "Book", new BigDecimal(8)});
        dataSource.add(new Object[]{"Washington", "Book", new BigDecimal(14)});
        dataSource.add(new Object[]{"Washington", "Book", new BigDecimal(10)});
        dataSource.add(new Object[]{"Florida", "Notebook", new BigDecimal(460.7)});
        dataSource.add(new Object[]{"Florida", "DVD", new BigDecimal(49)});
        dataSource.add(new Object[]{"Florida", "DVD", new BigDecimal(32)});
        dataSource.add(new Object[]{"Florida", "DVD", new BigDecimal(47)});
        dataSource.add(new Object[]{"Florida", "Book", new BigDecimal(11)});
        dataSource.add(new Object[]{"Florida", "Book", new BigDecimal(6.1)});
        dataSource.add(new Object[]{"Florida", "Book", new BigDecimal(16)});
        dataSource.add(new Object[]{"Florida", "Book", new BigDecimal(18)});
        return dataSource;
    }

    public static void main(String[] args) {
        new CustomPercentageCrosstabReport();
    }

    private class PercentageExpression
    extends AbstractComplexExpression<BigDecimal> {
        private static final long serialVersionUID = 1L;

        private PercentageExpression(CrosstabMeasureBuilder<BigDecimal> unitPriceMeasure, CrosstabColumnGroupBuilder<String> columnGroup) {
            this.addExpression(unitPriceMeasure);
            this.addExpression((DRIExpression)DynamicReports.exp.crosstabValue(unitPriceMeasure, columnGroup));
        }

        public BigDecimal evaluate(List<?> values, ReportParameters reportParameters) {
            BigDecimal unitPrice = (BigDecimal)values.get(0);
            BigDecimal unitPriceTotal = (BigDecimal)values.get(1);
            return unitPrice.divide(unitPriceTotal, 4, 4).multiply(new BigDecimal(100));
        }
    }
}

