/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.examples.crosstab;

import java.math.BigDecimal;
import net.sf.dynamicreports.examples.Templates;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.base.expression.AbstractSimpleExpression;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.crosstab.CrosstabBuilder;
import net.sf.dynamicreports.report.builder.crosstab.CrosstabColumnGroupBuilder;
import net.sf.dynamicreports.report.builder.crosstab.CrosstabMeasureBuilder;
import net.sf.dynamicreports.report.builder.crosstab.CrosstabRowGroupBuilder;
import net.sf.dynamicreports.report.builder.crosstab.CrosstabVariableBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.constant.Calculation;
import net.sf.dynamicreports.report.constant.PageOrientation;
import net.sf.dynamicreports.report.constant.PageType;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.DRIValue;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class MeasureExpressionCrosstabReport {
    private CrosstabMeasureBuilder<Integer> quantityMeasure;
    private CrosstabVariableBuilder<BigDecimal> unitPriceVariable;
    private CrosstabVariableBuilder<BigDecimal> priceVariable;

    public MeasureExpressionCrosstabReport() {
        this.build();
    }

    private void build() {
        CrosstabRowGroupBuilder rowGroup = (CrosstabRowGroupBuilder)DynamicReports.ctab.rowGroup("state", String.class).setTotalHeader("Total for state");
        CrosstabColumnGroupBuilder columnGroup = DynamicReports.ctab.columnGroup("item", String.class);
        this.unitPriceVariable = DynamicReports.ctab.variable("unitprice", BigDecimal.class, Calculation.SUM);
        this.priceVariable = DynamicReports.ctab.variable((DRIExpression)new PriceExpression(), Calculation.SUM);
        this.quantityMeasure = DynamicReports.ctab.measure("Quantity", "quantity", Integer.class, Calculation.SUM);
        CrosstabMeasureBuilder priceMeasure1 = DynamicReports.ctab.measure("Price1", (DRIExpression)new PriceMeasure1Expression());
        priceMeasure1.setDataType((DRIDataType)DynamicReports.type.bigDecimalType());
        CrosstabMeasureBuilder priceMeasure2 = DynamicReports.ctab.measure("Price2", (DRIExpression)new PriceMeasure2Expression());
        priceMeasure2.setDataType((DRIDataType)DynamicReports.type.bigDecimalType());
        CrosstabBuilder crosstab = DynamicReports.ctab.crosstab().headerCell(new ComponentBuilder[]{DynamicReports.cmp.text("State / Item").setStyle((ReportStyleBuilder)Templates.boldCenteredStyle)}).setCellWidth(Integer.valueOf(180)).rowGroups(new CrosstabRowGroupBuilder[]{rowGroup}).columnGroups(new CrosstabColumnGroupBuilder[]{columnGroup}).variables(new CrosstabVariableBuilder[]{this.unitPriceVariable, this.priceVariable}).measures(new CrosstabMeasureBuilder[]{this.quantityMeasure, priceMeasure1, priceMeasure2});
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setPageFormat(PageType.A4, PageOrientation.LANDSCAPE)).setTemplate(Templates.reportTemplate)).title(new ComponentBuilder[]{Templates.createTitleComponent("MeasureExpressionCrosstab"), DynamicReports.cmp.text("Price1 = SUM(quantity) * SUM(unitPrice)").setStyle((ReportStyleBuilder)Templates.boldStyle), DynamicReports.cmp.text("Price2 = SUM(quantity * unitPrice)").setStyle((ReportStyleBuilder)Templates.boldStyle)})).summary(new ComponentBuilder[]{crosstab})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"state", "item", "quantity", "unitprice"});
        dataSource.add(new Object[]{"New York", "Notebook", 1, new BigDecimal(500)});
        dataSource.add(new Object[]{"New York", "DVD", 5, new BigDecimal(30)});
        dataSource.add(new Object[]{"New York", "DVD", 2, new BigDecimal(45)});
        dataSource.add(new Object[]{"New York", "DVD", 4, new BigDecimal(36)});
        dataSource.add(new Object[]{"New York", "DVD", 5, new BigDecimal(41)});
        dataSource.add(new Object[]{"New York", "Book", 2, new BigDecimal(11)});
        dataSource.add(new Object[]{"New York", "Book", 8, new BigDecimal(9)});
        dataSource.add(new Object[]{"New York", "Book", 6, new BigDecimal(14)});
        dataSource.add(new Object[]{"Washington", "Notebook", 1, new BigDecimal(610)});
        dataSource.add(new Object[]{"Washington", "DVD", 4, new BigDecimal(40)});
        dataSource.add(new Object[]{"Washington", "DVD", 6, new BigDecimal(35)});
        dataSource.add(new Object[]{"Washington", "DVD", 3, new BigDecimal(46)});
        dataSource.add(new Object[]{"Washington", "DVD", 2, new BigDecimal(42)});
        dataSource.add(new Object[]{"Washington", "Book", 3, new BigDecimal(12)});
        dataSource.add(new Object[]{"Washington", "Book", 9, new BigDecimal(8)});
        dataSource.add(new Object[]{"Washington", "Book", 4, new BigDecimal(14)});
        dataSource.add(new Object[]{"Washington", "Book", 5, new BigDecimal(10)});
        dataSource.add(new Object[]{"Florida", "Notebook", 1, new BigDecimal(460)});
        dataSource.add(new Object[]{"Florida", "DVD", 3, new BigDecimal(49)});
        dataSource.add(new Object[]{"Florida", "DVD", 4, new BigDecimal(32)});
        dataSource.add(new Object[]{"Florida", "DVD", 2, new BigDecimal(47)});
        dataSource.add(new Object[]{"Florida", "Book", 4, new BigDecimal(11)});
        dataSource.add(new Object[]{"Florida", "Book", 8, new BigDecimal(6)});
        dataSource.add(new Object[]{"Florida", "Book", 6, new BigDecimal(16)});
        dataSource.add(new Object[]{"Florida", "Book", 3, new BigDecimal(18)});
        return dataSource;
    }

    public static void main(String[] args) {
        new MeasureExpressionCrosstabReport();
    }

    private class PriceExpression
    extends AbstractSimpleExpression<BigDecimal> {
        private static final long serialVersionUID = 1L;

        private PriceExpression() {
        }

        public BigDecimal evaluate(ReportParameters reportParameters) {
            Integer quantity = (Integer)reportParameters.getValue("quantity");
            BigDecimal unitPrice = (BigDecimal)reportParameters.getValue("unitprice");
            return unitPrice.multiply(new BigDecimal(quantity));
        }
    }

    private class PriceMeasure1Expression
    extends AbstractSimpleExpression<BigDecimal> {
        private static final long serialVersionUID = 1L;

        private PriceMeasure1Expression() {
        }

        public BigDecimal evaluate(ReportParameters reportParameters) {
            Integer quantity = (Integer)reportParameters.getValue((DRIValue)MeasureExpressionCrosstabReport.this.quantityMeasure);
            BigDecimal unitPrice = (BigDecimal)reportParameters.getValue((DRIValue)MeasureExpressionCrosstabReport.this.unitPriceVariable);
            return unitPrice.multiply(new BigDecimal(quantity));
        }
    }

    private class PriceMeasure2Expression
    extends AbstractSimpleExpression<BigDecimal> {
        private static final long serialVersionUID = 1L;

        private PriceMeasure2Expression() {
        }

        public BigDecimal evaluate(ReportParameters reportParameters) {
            return (BigDecimal)reportParameters.getValue((DRIValue)MeasureExpressionCrosstabReport.this.priceVariable);
        }
    }
}

