/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.examples.crosstab;

import java.math.BigDecimal;
import net.sf.dynamicreports.examples.Templates;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.crosstab.CrosstabBuilder;
import net.sf.dynamicreports.report.builder.crosstab.CrosstabColumnGroupBuilder;
import net.sf.dynamicreports.report.builder.crosstab.CrosstabMeasureBuilder;
import net.sf.dynamicreports.report.builder.crosstab.CrosstabRowGroupBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.constant.Calculation;
import net.sf.dynamicreports.report.constant.CrosstabPercentageType;
import net.sf.dynamicreports.report.constant.PageOrientation;
import net.sf.dynamicreports.report.constant.PageType;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class PercentageCrosstabReport {
    public PercentageCrosstabReport() {
        this.build();
    }

    private void build() {
        CrosstabRowGroupBuilder rowGroup = (CrosstabRowGroupBuilder)DynamicReports.ctab.rowGroup("state", String.class).setTotalHeader("Total for state");
        CrosstabColumnGroupBuilder columnGroup = DynamicReports.ctab.columnGroup("item", String.class);
        FieldBuilder unitPriceField = DynamicReports.field((String)"unitprice", BigDecimal.class);
        CrosstabBuilder crosstab = DynamicReports.ctab.crosstab().headerCell(new ComponentBuilder[]{DynamicReports.cmp.text("State / Item").setStyle((ReportStyleBuilder)Templates.boldCenteredStyle)}).rowGroups(new CrosstabRowGroupBuilder[]{rowGroup}).columnGroups(new CrosstabColumnGroupBuilder[]{columnGroup}).measures(new CrosstabMeasureBuilder[]{DynamicReports.ctab.measure("Unit price", unitPriceField, Calculation.SUM), DynamicReports.ctab.measure("%", unitPriceField, Calculation.SUM).setPercentageType(CrosstabPercentageType.GRAND_TOTAL)});
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setPageFormat(PageType.A4, PageOrientation.LANDSCAPE)).setTemplate(Templates.reportTemplate)).title(new ComponentBuilder[]{Templates.createTitleComponent("PercentageCrosstab")})).summary(new ComponentBuilder[]{crosstab})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"state", "item", "unitprice"});
        dataSource.add(new Object[]{"New York", "Notebook", new BigDecimal(500)});
        dataSource.add(new Object[]{"New York", "DVD", new BigDecimal(30)});
        dataSource.add(new Object[]{"New York", "DVD", new BigDecimal(45.6)});
        dataSource.add(new Object[]{"New York", "DVD", new BigDecimal(36)});
        dataSource.add(new Object[]{"New York", "DVD", new BigDecimal(41)});
        dataSource.add(new Object[]{"New York", "Book", new BigDecimal(11)});
        dataSource.add(new Object[]{"New York", "Book", new BigDecimal(9)});
        dataSource.add(new Object[]{"New York", "Book", new BigDecimal(14.8)});
        dataSource.add(new Object[]{"Washington", "Notebook", new BigDecimal(610)});
        dataSource.add(new Object[]{"Washington", "DVD", new BigDecimal(40)});
        dataSource.add(new Object[]{"Washington", "DVD", new BigDecimal(35)});
        dataSource.add(new Object[]{"Washington", "DVD", new BigDecimal(46.4)});
        dataSource.add(new Object[]{"Washington", "DVD", new BigDecimal(42)});
        dataSource.add(new Object[]{"Washington", "Book", new BigDecimal(12)});
        dataSource.add(new Object[]{"Washington", "Book", new BigDecimal(8)});
        dataSource.add(new Object[]{"Washington", "Book", new BigDecimal(14)});
        dataSource.add(new Object[]{"Washington", "Book", new BigDecimal(10)});
        dataSource.add(new Object[]{"Florida", "Notebook", new BigDecimal(460.7)});
        dataSource.add(new Object[]{"Florida", "DVD", new BigDecimal(49)});
        dataSource.add(new Object[]{"Florida", "DVD", new BigDecimal(32)});
        dataSource.add(new Object[]{"Florida", "DVD", new BigDecimal(47)});
        dataSource.add(new Object[]{"Florida", "Book", new BigDecimal(11)});
        dataSource.add(new Object[]{"Florida", "Book", new BigDecimal(6.1)});
        dataSource.add(new Object[]{"Florida", "Book", new BigDecimal(16)});
        dataSource.add(new Object[]{"Florida", "Book", new BigDecimal(18)});
        return dataSource;
    }

    public static void main(String[] args) {
        new PercentageCrosstabReport();
    }
}

