/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.examples.crosstab;

import java.awt.Color;
import java.math.BigDecimal;
import net.sf.dynamicreports.examples.Templates;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.crosstab.CrosstabBuilder;
import net.sf.dynamicreports.report.builder.crosstab.CrosstabColumnGroupBuilder;
import net.sf.dynamicreports.report.builder.crosstab.CrosstabMeasureBuilder;
import net.sf.dynamicreports.report.builder.crosstab.CrosstabRowGroupBuilder;
import net.sf.dynamicreports.report.builder.style.ConditionalStyleBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.builder.style.StyleBuilder;
import net.sf.dynamicreports.report.constant.Calculation;
import net.sf.dynamicreports.report.constant.PageOrientation;
import net.sf.dynamicreports.report.constant.PageType;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.DRIValue;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class StyleCrosstabReport {
    public StyleCrosstabReport() {
        this.build();
    }

    private void build() {
        CrosstabRowGroupBuilder rowGroup = (CrosstabRowGroupBuilder)DynamicReports.ctab.rowGroup("state", String.class).setTotalHeader("Total for state");
        CrosstabColumnGroupBuilder columnGroup = DynamicReports.ctab.columnGroup("item", String.class);
        CrosstabMeasureBuilder quantityMeasure = DynamicReports.ctab.measure("Quantity", "quantity", Integer.class, Calculation.SUM);
        CrosstabMeasureBuilder unitPriceMeasure = DynamicReports.ctab.measure("Unit price", "unitprice", BigDecimal.class, Calculation.SUM);
        ConditionalStyleBuilder condition1 = (ConditionalStyleBuilder)((ConditionalStyleBuilder)DynamicReports.stl.conditionalStyle((DRIExpression)DynamicReports.cnd.greater((DRIValue)unitPriceMeasure, (Number)600)).setBackgroundColor(new Color(210, 255, 210))).setBorder(DynamicReports.stl.pen1Point());
        ConditionalStyleBuilder condition2 = (ConditionalStyleBuilder)((ConditionalStyleBuilder)DynamicReports.stl.conditionalStyle((DRIExpression)DynamicReports.cnd.smaller((DRIValue)unitPriceMeasure, (Number)150)).setBackgroundColor(new Color(255, 210, 210))).setBorder(DynamicReports.stl.pen1Point());
        StyleBuilder unitPriceStyle = (StyleBuilder)DynamicReports.stl.style().conditionalStyles(new ConditionalStyleBuilder[]{condition1, condition2}).setBorder(DynamicReports.stl.pen1Point());
        StyleBuilder totalCellStyle = (StyleBuilder)((StyleBuilder)DynamicReports.stl.style().setBackgroundColor(new Color(200, 200, 255))).setBorder(DynamicReports.stl.pen1Point());
        unitPriceMeasure.setStyle((ReportStyleBuilder)unitPriceStyle).setStyle((ReportStyleBuilder)totalCellStyle, rowGroup).setStyle((ReportStyleBuilder)totalCellStyle, rowGroup, columnGroup);
        quantityMeasure.setStyle((ReportStyleBuilder)totalCellStyle, rowGroup).setStyle((ReportStyleBuilder)totalCellStyle, rowGroup, columnGroup);
        CrosstabBuilder crosstab = DynamicReports.ctab.crosstab().headerCell(new ComponentBuilder[]{DynamicReports.cmp.text("State / Item").setStyle((ReportStyleBuilder)Templates.boldCenteredStyle)}).rowGroups(new CrosstabRowGroupBuilder[]{rowGroup}).columnGroups(new CrosstabColumnGroupBuilder[]{columnGroup}).measures(new CrosstabMeasureBuilder[]{quantityMeasure, unitPriceMeasure});
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setPageFormat(PageType.A4, PageOrientation.LANDSCAPE)).setTemplate(Templates.reportTemplate)).title(new ComponentBuilder[]{Templates.createTitleComponent("StyleCrosstab")})).summary(new ComponentBuilder[]{crosstab})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"state", "item", "quantity", "unitprice"});
        dataSource.add(new Object[]{"New York", "Notebook", 1, new BigDecimal(500)});
        dataSource.add(new Object[]{"New York", "DVD", 5, new BigDecimal(30)});
        dataSource.add(new Object[]{"New York", "DVD", 2, new BigDecimal(45)});
        dataSource.add(new Object[]{"New York", "DVD", 4, new BigDecimal(36)});
        dataSource.add(new Object[]{"New York", "DVD", 5, new BigDecimal(41)});
        dataSource.add(new Object[]{"New York", "Book", 2, new BigDecimal(11)});
        dataSource.add(new Object[]{"New York", "Book", 8, new BigDecimal(9)});
        dataSource.add(new Object[]{"New York", "Book", 6, new BigDecimal(14)});
        dataSource.add(new Object[]{"Washington", "Notebook", 1, new BigDecimal(610)});
        dataSource.add(new Object[]{"Washington", "DVD", 4, new BigDecimal(40)});
        dataSource.add(new Object[]{"Washington", "DVD", 6, new BigDecimal(35)});
        dataSource.add(new Object[]{"Washington", "DVD", 3, new BigDecimal(46)});
        dataSource.add(new Object[]{"Washington", "DVD", 2, new BigDecimal(42)});
        dataSource.add(new Object[]{"Washington", "Book", 3, new BigDecimal(12)});
        dataSource.add(new Object[]{"Washington", "Book", 9, new BigDecimal(8)});
        dataSource.add(new Object[]{"Washington", "Book", 4, new BigDecimal(14)});
        dataSource.add(new Object[]{"Washington", "Book", 5, new BigDecimal(10)});
        dataSource.add(new Object[]{"Florida", "Notebook", 1, new BigDecimal(460)});
        dataSource.add(new Object[]{"Florida", "DVD", 3, new BigDecimal(49)});
        dataSource.add(new Object[]{"Florida", "DVD", 4, new BigDecimal(32)});
        dataSource.add(new Object[]{"Florida", "DVD", 2, new BigDecimal(47)});
        dataSource.add(new Object[]{"Florida", "Book", 4, new BigDecimal(11)});
        dataSource.add(new Object[]{"Florida", "Book", 8, new BigDecimal(6)});
        dataSource.add(new Object[]{"Florida", "Book", 6, new BigDecimal(16)});
        dataSource.add(new Object[]{"Florida", "Book", 3, new BigDecimal(18)});
        return dataSource;
    }

    public static void main(String[] args) {
        new StyleCrosstabReport();
    }
}

