/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.examples.datasource;

import java.math.BigDecimal;
import net.sf.dynamicreports.examples.Templates;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.chart.AbstractCategoryChartSerieBuilder;
import net.sf.dynamicreports.report.builder.chart.BarChartBuilder;
import net.sf.dynamicreports.report.builder.chart.CategoryChartSerieBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.crosstab.CrosstabBuilder;
import net.sf.dynamicreports.report.builder.crosstab.CrosstabColumnGroupBuilder;
import net.sf.dynamicreports.report.builder.crosstab.CrosstabMeasureBuilder;
import net.sf.dynamicreports.report.builder.crosstab.CrosstabRowGroupBuilder;
import net.sf.dynamicreports.report.builder.style.FontBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.constant.Calculation;
import net.sf.dynamicreports.report.constant.PageOrientation;
import net.sf.dynamicreports.report.constant.PageType;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class SubDatasourceReport {
    public SubDatasourceReport() {
        this.build();
    }

    private void build() {
        FontBuilder boldFont = DynamicReports.stl.fontArialBold().setFontSize(Integer.valueOf(12));
        FieldBuilder itemField = DynamicReports.field((String)"item", (DRIDataType)DynamicReports.type.stringType());
        FieldBuilder quantityField = DynamicReports.field((String)"quantity", (DRIDataType)DynamicReports.type.integerType());
        FieldBuilder unitPriceField = DynamicReports.field((String)"unitprice", (DRIDataType)DynamicReports.type.bigDecimalType());
        CategoryChartSerieBuilder quantitySerie = (CategoryChartSerieBuilder)DynamicReports.cht.serie(quantityField).setLabel("Quantity");
        CategoryChartSerieBuilder unitPriceSerie = (CategoryChartSerieBuilder)DynamicReports.cht.serie(unitPriceField).setLabel("Unit price");
        BarChartBuilder chart1 = (BarChartBuilder)((BarChartBuilder)((BarChartBuilder)((BarChartBuilder)((BarChartBuilder)DynamicReports.cht.barChart().setDataSource(this.createDataSource1())).setTitle("SubDatasource 1")).setTitleFont(boldFont)).setCategory(itemField)).series(new AbstractCategoryChartSerieBuilder[]{quantitySerie, unitPriceSerie});
        BarChartBuilder chart2 = (BarChartBuilder)((BarChartBuilder)((BarChartBuilder)((BarChartBuilder)((BarChartBuilder)DynamicReports.cht.barChart().setDataSource(this.createDataSource2())).setTitle("SubDatasource 2")).setTitleFont(boldFont)).setCategory(itemField)).series(new AbstractCategoryChartSerieBuilder[]{quantitySerie, unitPriceSerie});
        CrosstabRowGroupBuilder rowGroup = (CrosstabRowGroupBuilder)DynamicReports.ctab.rowGroup("state", String.class).setTotalHeader("Total for state");
        CrosstabColumnGroupBuilder columnGroup = DynamicReports.ctab.columnGroup("item", String.class);
        CrosstabBuilder crosstab = DynamicReports.ctab.crosstab().setDataSource(this.createDataSource3()).headerCell(new ComponentBuilder[]{DynamicReports.cmp.text("State / Item").setStyle((ReportStyleBuilder)Templates.boldCenteredStyle)}).rowGroups(new CrosstabRowGroupBuilder[]{rowGroup}).columnGroups(new CrosstabColumnGroupBuilder[]{columnGroup}).measures(new CrosstabMeasureBuilder[]{DynamicReports.ctab.measure("Quantity", "quantity", Integer.class, Calculation.SUM), DynamicReports.ctab.measure("Unit price", "unitprice", BigDecimal.class, Calculation.SUM)});
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setPageFormat(PageType.A4, PageOrientation.LANDSCAPE)).setTemplate(Templates.reportTemplate)).title(new ComponentBuilder[]{Templates.createTitleComponent("SubDatasource"), DynamicReports.cmp.horizontalList(new ComponentBuilder[]{chart1, chart2}), DynamicReports.cmp.text("SubDatasource 3").setStyle((ReportStyleBuilder)Templates.bold12CenteredStyle), crosstab})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource1() {
        DRDataSource dataSource = new DRDataSource(new String[]{"item", "quantity", "unitprice"});
        dataSource.add(new Object[]{"Book", 170, new BigDecimal(100)});
        dataSource.add(new Object[]{"Notebook", 90, new BigDecimal(450)});
        dataSource.add(new Object[]{"PDA", 120, new BigDecimal(250)});
        return dataSource;
    }

    private JRDataSource createDataSource2() {
        DRDataSource dataSource = new DRDataSource(new String[]{"item", "quantity", "unitprice"});
        dataSource.add(new Object[]{"Book", 100, new BigDecimal(120)});
        dataSource.add(new Object[]{"Notebook", 190, new BigDecimal(350)});
        dataSource.add(new Object[]{"PDA", 800, new BigDecimal(290)});
        return dataSource;
    }

    private JRDataSource createDataSource3() {
        DRDataSource dataSource = new DRDataSource(new String[]{"state", "item", "quantity", "unitprice"});
        dataSource.add(new Object[]{"New York", "Notebook", 1, new BigDecimal(500)});
        dataSource.add(new Object[]{"New York", "DVD", 5, new BigDecimal(30)});
        dataSource.add(new Object[]{"New York", "DVD", 2, new BigDecimal(45)});
        dataSource.add(new Object[]{"New York", "DVD", 4, new BigDecimal(36)});
        dataSource.add(new Object[]{"New York", "DVD", 5, new BigDecimal(41)});
        dataSource.add(new Object[]{"New York", "Book", 2, new BigDecimal(11)});
        dataSource.add(new Object[]{"New York", "Book", 8, new BigDecimal(9)});
        dataSource.add(new Object[]{"New York", "Book", 6, new BigDecimal(14)});
        dataSource.add(new Object[]{"Washington", "Notebook", 1, new BigDecimal(610)});
        dataSource.add(new Object[]{"Washington", "DVD", 4, new BigDecimal(40)});
        dataSource.add(new Object[]{"Washington", "DVD", 6, new BigDecimal(35)});
        dataSource.add(new Object[]{"Washington", "DVD", 3, new BigDecimal(46)});
        dataSource.add(new Object[]{"Washington", "DVD", 2, new BigDecimal(42)});
        dataSource.add(new Object[]{"Washington", "Book", 3, new BigDecimal(12)});
        dataSource.add(new Object[]{"Washington", "Book", 9, new BigDecimal(8)});
        dataSource.add(new Object[]{"Washington", "Book", 4, new BigDecimal(14)});
        dataSource.add(new Object[]{"Washington", "Book", 5, new BigDecimal(10)});
        dataSource.add(new Object[]{"Florida", "Notebook", 1, new BigDecimal(460)});
        dataSource.add(new Object[]{"Florida", "DVD", 3, new BigDecimal(49)});
        dataSource.add(new Object[]{"Florida", "DVD", 4, new BigDecimal(32)});
        dataSource.add(new Object[]{"Florida", "DVD", 2, new BigDecimal(47)});
        dataSource.add(new Object[]{"Florida", "Book", 4, new BigDecimal(11)});
        dataSource.add(new Object[]{"Florida", "Book", 8, new BigDecimal(6)});
        dataSource.add(new Object[]{"Florida", "Book", 6, new BigDecimal(16)});
        dataSource.add(new Object[]{"Florida", "Book", 3, new BigDecimal(18)});
        return dataSource;
    }

    public static void main(String[] args) {
        new SubDatasourceReport();
    }
}

