/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.examples.expression;

import java.math.BigDecimal;
import net.sf.dynamicreports.examples.Templates;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.base.expression.AbstractValueFormatter;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIValueFormatter;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class ValueFormatterReport {
    public ValueFormatterReport() {
        this.build();
    }

    private void build() {
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).fields(new FieldBuilder[]{DynamicReports.field((String)"unitprice", BigDecimal.class)})).columns(new ColumnBuilder[]{DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType()), DynamicReports.col.column("Quantity", "quantity", (DRIDataType)DynamicReports.type.integerType()), DynamicReports.col.column("Unit price", "unitprice", (DRIDataType)DynamicReports.type.bigDecimalType()).setValueFormatter((DRIValueFormatter)new ValueFormatter())})).title(new ComponentBuilder[]{Templates.createTitleComponent("ValueFormatter")})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"item", "quantity", "unitprice"});
        dataSource.add(new Object[]{"Book", 20, new BigDecimal(10)});
        return dataSource;
    }

    public static void main(String[] args) {
        new ValueFormatterReport();
    }

    private static class ValueFormatter
    extends AbstractValueFormatter<String, Number> {
        private static final long serialVersionUID = 1L;

        private ValueFormatter() {
        }

        public String format(Number value, ReportParameters reportParameters) {
            return String.valueOf(DynamicReports.type.bigDecimalType().valueToString(value, reportParameters.getLocale())) + " EUR";
        }
    }
}

