/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.examples.gettingstarted;

import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.component.HorizontalListBuilder;
import net.sf.dynamicreports.report.builder.component.TextFieldBuilder;
import net.sf.dynamicreports.report.builder.component.VerticalListBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.builder.style.StyleBuilder;
import net.sf.dynamicreports.report.constant.HorizontalAlignment;
import net.sf.dynamicreports.report.exception.DRException;

public class ContainerReport {
    private StyleBuilder boldCenteredStyle;
    private StyleBuilder borderedStyle;

    public ContainerReport() {
        this.build();
    }

    private void build() {
        this.boldCenteredStyle = (StyleBuilder)((StyleBuilder)DynamicReports.stl.style().bold()).setHorizontalAlignment(HorizontalAlignment.CENTER);
        this.borderedStyle = DynamicReports.stl.style(DynamicReports.stl.pen1Point());
        try {
            ((JasperReportBuilder)DynamicReports.report().title(new ComponentBuilder[]{this.createTextField("Horizontal list (contains 10 textfields)"), this.createHorizontalList(), DynamicReports.cmp.verticalGap(20), this.createTextField("Multi row horizontal list (contains 10 textfields)"), this.createMultiRowHorizontalList(), DynamicReports.cmp.verticalGap(20), this.createTextField("Horizontal flow list (contains 9 textfields)"), this.createHorizontalFlowList(), DynamicReports.cmp.verticalGap(20), this.createTextField("Vertical list (contains 4 textfields)"), this.createVerticalList(), DynamicReports.cmp.verticalGap(20), this.createTextField("Nested list (contains 1 horizontal and 3 vertical lists)"), this.createNestedList()})).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private TextFieldBuilder<String> createTextField(String label) {
        return (TextFieldBuilder)DynamicReports.cmp.text(label).setStyle((ReportStyleBuilder)this.boldCenteredStyle);
    }

    private ComponentBuilder<?, ?> createHorizontalList() {
        HorizontalListBuilder horizontalList = DynamicReports.cmp.horizontalList();
        int i = 0;
        while (i < 10) {
            horizontalList.add(new ComponentBuilder[]{DynamicReports.cmp.text("").setStyle((ReportStyleBuilder)this.borderedStyle)});
            ++i;
        }
        return horizontalList;
    }

    private ComponentBuilder<?, ?> createMultiRowHorizontalList() {
        HorizontalListBuilder horizontalList = DynamicReports.cmp.horizontalList();
        int i = 0;
        while (i < 3) {
            horizontalList.add(new ComponentBuilder[]{DynamicReports.cmp.text("").setStyle((ReportStyleBuilder)this.borderedStyle)});
            ++i;
        }
        horizontalList.newRow();
        i = 0;
        while (i < 7) {
            horizontalList.add(new ComponentBuilder[]{DynamicReports.cmp.text("").setStyle((ReportStyleBuilder)this.borderedStyle)});
            ++i;
        }
        return horizontalList;
    }

    private ComponentBuilder<?, ?> createHorizontalFlowList() {
        HorizontalListBuilder horizontalList = DynamicReports.cmp.horizontalFlowList();
        int i = 0;
        while (i < 9) {
            horizontalList.add(new ComponentBuilder[]{DynamicReports.cmp.text("").setStyle((ReportStyleBuilder)this.borderedStyle)});
            ++i;
        }
        return horizontalList;
    }

    private ComponentBuilder<?, ?> createVerticalList() {
        VerticalListBuilder verticalList = DynamicReports.cmp.verticalList();
        int i = 0;
        while (i < 4) {
            verticalList.add(new ComponentBuilder[]{DynamicReports.cmp.text("").setStyle((ReportStyleBuilder)this.borderedStyle)});
            ++i;
        }
        return verticalList;
    }

    private ComponentBuilder<?, ?> createNestedList() {
        HorizontalListBuilder horizontalList = DynamicReports.cmp.horizontalList();
        int i = 0;
        while (i < 3) {
            horizontalList.add(new ComponentBuilder[]{this.createVerticalList()});
            ++i;
        }
        return horizontalList;
    }

    public static void main(String[] args) {
        new ContainerReport();
    }
}

