/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.examples.gettingstarted;

import java.awt.Color;
import java.math.BigDecimal;
import net.sf.dynamicreports.examples.Templates;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.chart.AbstractCategoryChartSerieBuilder;
import net.sf.dynamicreports.report.builder.chart.Bar3DChartBuilder;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.PercentageColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.component.FillerBuilder;
import net.sf.dynamicreports.report.builder.component.TextFieldBuilder;
import net.sf.dynamicreports.report.builder.datatype.BigDecimalType;
import net.sf.dynamicreports.report.builder.grid.ColumnGridComponentBuilder;
import net.sf.dynamicreports.report.builder.group.ColumnGroupBuilder;
import net.sf.dynamicreports.report.builder.group.GroupBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.builder.style.StyleBuilder;
import net.sf.dynamicreports.report.builder.subtotal.SubtotalBuilder;
import net.sf.dynamicreports.report.constant.HorizontalAlignment;
import net.sf.dynamicreports.report.constant.VerticalAlignment;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class SimpleReport_Step10 {
    public SimpleReport_Step10() {
        this.build();
    }

    private void build() {
        CurrencyType currencyType = new CurrencyType();
        StyleBuilder boldStyle = (StyleBuilder)DynamicReports.stl.style().bold();
        StyleBuilder boldCenteredStyle = (StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)boldStyle).setHorizontalAlignment(HorizontalAlignment.CENTER);
        StyleBuilder columnTitleStyle = (StyleBuilder)((StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)boldCenteredStyle).setBorder(DynamicReports.stl.pen1Point())).setBackgroundColor(Color.LIGHT_GRAY);
        StyleBuilder titleStyle = (StyleBuilder)((StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)boldCenteredStyle).setVerticalAlignment(VerticalAlignment.MIDDLE)).setFontSize(Integer.valueOf(15));
        TextColumnBuilder itemColumn = (TextColumnBuilder)DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType()).setStyle((ReportStyleBuilder)boldStyle);
        TextColumnBuilder quantityColumn = DynamicReports.col.column("Quantity", "quantity", (DRIDataType)DynamicReports.type.integerType());
        TextColumnBuilder unitPriceColumn = DynamicReports.col.column("Unit price", "unitprice", (DRIDataType)currencyType);
        TextColumnBuilder priceColumn = (TextColumnBuilder)((TextColumnBuilder)unitPriceColumn.multiply(quantityColumn).setTitle("Price")).setDataType((DRIDataType)currencyType);
        PercentageColumnBuilder pricePercColumn = DynamicReports.col.percentageColumn("Price %", (ValueColumnBuilder)priceColumn);
        TextColumnBuilder rowNumberColumn = (TextColumnBuilder)((TextColumnBuilder)DynamicReports.col.reportRowNumberColumn("No.").setFixedColumns(Integer.valueOf(2))).setHorizontalAlignment(HorizontalAlignment.CENTER);
        Bar3DChartBuilder itemChart = (Bar3DChartBuilder)((Bar3DChartBuilder)((Bar3DChartBuilder)DynamicReports.cht.bar3DChart().setTitle("Sales by item")).setCategory((ValueColumnBuilder)itemColumn)).addSerie(new AbstractCategoryChartSerieBuilder[]{DynamicReports.cht.serie((ValueColumnBuilder)unitPriceColumn), DynamicReports.cht.serie((ValueColumnBuilder)priceColumn)});
        Bar3DChartBuilder itemChart2 = (Bar3DChartBuilder)((Bar3DChartBuilder)((Bar3DChartBuilder)((Bar3DChartBuilder)DynamicReports.cht.bar3DChart().setTitle("Sales by item")).setCategory((ValueColumnBuilder)itemColumn)).setUseSeriesAsCategory(Boolean.valueOf(true))).addSerie(new AbstractCategoryChartSerieBuilder[]{DynamicReports.cht.serie((ValueColumnBuilder)unitPriceColumn), DynamicReports.cht.serie((ValueColumnBuilder)priceColumn)});
        ColumnGroupBuilder itemGroup = DynamicReports.grp.group((ValueColumnBuilder)itemColumn);
        itemGroup.setPrintSubtotalsWhenExpression((DRIExpression)DynamicReports.exp.printWhenGroupHasMoreThanOneRow((GroupBuilder)itemGroup));
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setColumnTitleStyle((ReportStyleBuilder)columnTitleStyle)).setSubtotalStyle((ReportStyleBuilder)boldStyle)).highlightDetailEvenRows()).columns(new ColumnBuilder[]{rowNumberColumn, itemColumn, quantityColumn, unitPriceColumn, priceColumn, pricePercColumn})).columnGrid(new ColumnGridComponentBuilder[]{rowNumberColumn, quantityColumn, unitPriceColumn, DynamicReports.grid.verticalColumnGridList(new ColumnGridComponentBuilder[]{priceColumn, pricePercColumn})})).groupBy(new GroupBuilder[]{itemGroup})).subtotalsAtSummary(new SubtotalBuilder[]{DynamicReports.sbt.sum((ValueColumnBuilder)unitPriceColumn), DynamicReports.sbt.sum((ValueColumnBuilder)priceColumn)})).subtotalsAtFirstGroupFooter(new SubtotalBuilder[]{DynamicReports.sbt.sum((ValueColumnBuilder)unitPriceColumn), DynamicReports.sbt.sum((ValueColumnBuilder)priceColumn)})).title(new ComponentBuilder[]{DynamicReports.cmp.horizontalList().add(new ComponentBuilder[]{DynamicReports.cmp.image(Templates.class.getResource("images/dynamicreports.png")).setFixedDimension(Integer.valueOf(80), Integer.valueOf(80)), ((TextFieldBuilder)DynamicReports.cmp.text("DynamicReports").setStyle((ReportStyleBuilder)titleStyle)).setHorizontalAlignment(HorizontalAlignment.LEFT), ((TextFieldBuilder)DynamicReports.cmp.text("Getting started").setStyle((ReportStyleBuilder)titleStyle)).setHorizontalAlignment(HorizontalAlignment.RIGHT)}).newRow().add(new ComponentBuilder[]{((FillerBuilder)DynamicReports.cmp.filler().setStyle((ReportStyleBuilder)DynamicReports.stl.style().setTopBorder(DynamicReports.stl.pen2Point()))).setFixedHeight(Integer.valueOf(10))})})).pageFooter(new ComponentBuilder[]{DynamicReports.cmp.pageXofY().setStyle((ReportStyleBuilder)boldCenteredStyle)})).summary(new ComponentBuilder[]{DynamicReports.cmp.horizontalList(new ComponentBuilder[]{itemChart, itemChart2})})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"item", "quantity", "unitprice"});
        dataSource.add(new Object[]{"Notebook", 1, new BigDecimal(500)});
        dataSource.add(new Object[]{"DVD", 5, new BigDecimal(30)});
        dataSource.add(new Object[]{"DVD", 1, new BigDecimal(28)});
        dataSource.add(new Object[]{"DVD", 5, new BigDecimal(32)});
        dataSource.add(new Object[]{"Book", 3, new BigDecimal(11)});
        dataSource.add(new Object[]{"Book", 1, new BigDecimal(15)});
        dataSource.add(new Object[]{"Book", 5, new BigDecimal(10)});
        dataSource.add(new Object[]{"Book", 8, new BigDecimal(9)});
        return dataSource;
    }

    public static void main(String[] args) {
        new SimpleReport_Step10();
    }

    private class CurrencyType
    extends BigDecimalType {
        private static final long serialVersionUID = 1L;

        private CurrencyType() {
        }

        public String getPattern() {
            return "$ #,###.00";
        }
    }
}

