/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.examples.group;

import java.math.BigDecimal;
import net.sf.dynamicreports.examples.Templates;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.base.expression.AbstractSimpleExpression;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.group.CustomGroupBuilder;
import net.sf.dynamicreports.report.builder.group.GroupBuilder;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class CustomGroupReport {
    public CustomGroupReport() {
        this.build();
    }

    private void build() {
        CustomGroupBuilder yearGroup = DynamicReports.grp.group((DRIExpression)new YearExpression());
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).columns(new ColumnBuilder[]{DynamicReports.col.column("Order date", "orderdate", (DRIDataType)DynamicReports.type.stringType()), DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType()), DynamicReports.col.column("Quantity", "quantity", (DRIDataType)DynamicReports.type.integerType()), DynamicReports.col.column("Unit price", "unitprice", (DRIDataType)DynamicReports.type.bigDecimalType())})).groupBy(new GroupBuilder[]{yearGroup})).title(new ComponentBuilder[]{Templates.createTitleComponent("CustomGroup")})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"orderdate", "item", "quantity", "unitprice"});
        dataSource.add(new Object[]{"2009-11-01", "DVD", 5, new BigDecimal(30)});
        dataSource.add(new Object[]{"2009-11-01", "Book", 3, new BigDecimal(11)});
        dataSource.add(new Object[]{"2009-12-01", "DVD", 1, new BigDecimal(28)});
        dataSource.add(new Object[]{"2009-12-01", "Book", 1, new BigDecimal(15)});
        dataSource.add(new Object[]{"2010-01-01", "DVD", 4, new BigDecimal(32)});
        dataSource.add(new Object[]{"2010-01-01", "Book", 2, new BigDecimal(15)});
        dataSource.add(new Object[]{"2010-02-01", "DVD", 3, new BigDecimal(25)});
        dataSource.add(new Object[]{"2010-02-01", "Book", 5, new BigDecimal(12)});
        return dataSource;
    }

    public static void main(String[] args) {
        new CustomGroupReport();
    }

    private class YearExpression
    extends AbstractSimpleExpression<String> {
        private static final long serialVersionUID = 1L;

        private YearExpression() {
        }

        public String evaluate(ReportParameters reportParameters) {
            String orderDate = (String)reportParameters.getValue("orderdate");
            return orderDate.split("-")[0];
        }
    }
}

