/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.examples.group;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import net.sf.dynamicreports.examples.Templates;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.group.ColumnGroupBuilder;
import net.sf.dynamicreports.report.builder.group.GroupBuilder;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class DateGroupReport {
    public DateGroupReport() {
        this.build();
    }

    private void build() {
        TextColumnBuilder yearColumn = DynamicReports.col.column("Order year", "orderdate", (DRIDataType)DynamicReports.type.dateYearType());
        TextColumnBuilder monthColumn = DynamicReports.col.column("Order month", "orderdate", (DRIDataType)DynamicReports.type.dateMonthType());
        ColumnGroupBuilder yearGroup = (ColumnGroupBuilder)DynamicReports.grp.group((ValueColumnBuilder)yearColumn).groupByDataType();
        ColumnGroupBuilder monthGroup = (ColumnGroupBuilder)DynamicReports.grp.group((ValueColumnBuilder)monthColumn).groupByDataType();
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).columns(new ColumnBuilder[]{yearColumn, monthColumn, DynamicReports.col.column("Order date", "orderdate", (DRIDataType)DynamicReports.type.dateType()), DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType()), DynamicReports.col.column("Quantity", "quantity", (DRIDataType)DynamicReports.type.integerType()), DynamicReports.col.column("Unit price", "unitprice", (DRIDataType)DynamicReports.type.bigDecimalType())})).groupBy(new GroupBuilder[]{yearGroup, monthGroup})).title(new ComponentBuilder[]{Templates.createTitleComponent("DateGroup")})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"orderdate", "item", "quantity", "unitprice"});
        dataSource.add(new Object[]{this.toDate(2009, 11, 1), "DVD", 5, new BigDecimal(30)});
        dataSource.add(new Object[]{this.toDate(2009, 11, 1), "Book", 3, new BigDecimal(11)});
        dataSource.add(new Object[]{this.toDate(2009, 12, 1), "DVD", 1, new BigDecimal(28)});
        dataSource.add(new Object[]{this.toDate(2009, 12, 1), "Book", 1, new BigDecimal(15)});
        dataSource.add(new Object[]{this.toDate(2010, 1, 1), "DVD", 4, new BigDecimal(32)});
        dataSource.add(new Object[]{this.toDate(2010, 1, 1), "Book", 2, new BigDecimal(15)});
        dataSource.add(new Object[]{this.toDate(2010, 2, 1), "DVD", 3, new BigDecimal(25)});
        dataSource.add(new Object[]{this.toDate(2010, 2, 1), "Book", 5, new BigDecimal(12)});
        return dataSource;
    }

    private Date toDate(int year, int month, int day) {
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(2, month - 1);
        c.set(5, day);
        return c.getTime();
    }

    public static void main(String[] args) {
        new DateGroupReport();
    }
}

