/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.examples.group;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import net.sf.dynamicreports.examples.Templates;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.base.expression.AbstractSimpleExpression;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.group.CustomGroupBuilder;
import net.sf.dynamicreports.report.builder.group.GroupBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.builder.subtotal.SubtotalBuilder;
import net.sf.dynamicreports.report.constant.Calculation;
import net.sf.dynamicreports.report.constant.GroupHeaderLayout;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class GroupLayoutReport {
    public GroupLayoutReport() {
        this.build();
    }

    private void build() {
        TextColumnBuilder yearColumn = DynamicReports.col.column("Order year", (DRIExpression)DynamicReports.exp.text(""));
        TextColumnBuilder orderDateColumn = DynamicReports.col.column("Order date", "orderdate", (DRIDataType)DynamicReports.type.dateType());
        TextColumnBuilder itemColumn = DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType());
        TextColumnBuilder quantityColumn = DynamicReports.col.column("Quantity", "quantity", (DRIDataType)DynamicReports.type.integerType());
        TextColumnBuilder unitPriceColumn = DynamicReports.col.column("Unit price", "unitprice", (DRIDataType)DynamicReports.type.bigDecimalType());
        CustomGroupBuilder yearGroup = (CustomGroupBuilder)((CustomGroupBuilder)((CustomGroupBuilder)DynamicReports.grp.group((DRIExpression)new YearExpression()).groupByDataType()).setHeaderLayout(GroupHeaderLayout.EMPTY)).setPadding(Integer.valueOf(0));
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).setSubtotalStyle((ReportStyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)Templates.boldStyle))).fields(new FieldBuilder[]{DynamicReports.field((String)"orderdate", (DRIDataType)DynamicReports.type.dateYearType())})).columns(new ColumnBuilder[]{yearColumn, orderDateColumn, itemColumn, quantityColumn, unitPriceColumn})).groupBy(new GroupBuilder[]{yearGroup})).subtotalsAtGroupHeader((GroupBuilder)yearGroup, new SubtotalBuilder[]{DynamicReports.sbt.first((DRIExpression)new YearExpression(), (ColumnBuilder)yearColumn), DynamicReports.sbt.sum((ValueColumnBuilder)quantityColumn), DynamicReports.sbt.sum((ValueColumnBuilder)unitPriceColumn)})).subtotalsAtSummary(new SubtotalBuilder[]{DynamicReports.sbt.aggregate((DRIExpression)DynamicReports.exp.text("Total"), (ColumnBuilder)yearColumn, Calculation.NOTHING), DynamicReports.sbt.sum((ValueColumnBuilder)quantityColumn), DynamicReports.sbt.sum((ValueColumnBuilder)unitPriceColumn)})).title(new ComponentBuilder[]{Templates.createTitleComponent("GroupLayout")})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"orderdate", "item", "quantity", "unitprice"});
        dataSource.add(new Object[]{this.toDate(2009, 11, 1), "DVD", 5, new BigDecimal(30)});
        dataSource.add(new Object[]{this.toDate(2009, 11, 1), "Book", 3, new BigDecimal(11)});
        dataSource.add(new Object[]{this.toDate(2009, 12, 1), "DVD", 1, new BigDecimal(28)});
        dataSource.add(new Object[]{this.toDate(2009, 12, 1), "Book", 1, new BigDecimal(15)});
        dataSource.add(new Object[]{this.toDate(2010, 1, 1), "DVD", 4, new BigDecimal(32)});
        dataSource.add(new Object[]{this.toDate(2010, 1, 1), "Book", 2, new BigDecimal(15)});
        dataSource.add(new Object[]{this.toDate(2010, 2, 1), "DVD", 3, new BigDecimal(25)});
        dataSource.add(new Object[]{this.toDate(2010, 2, 1), "Book", 5, new BigDecimal(10)});
        return dataSource;
    }

    private Date toDate(int year, int month, int day) {
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(2, month - 1);
        c.set(5, day);
        return c.getTime();
    }

    public static void main(String[] args) {
        new GroupLayoutReport();
    }

    private class YearExpression
    extends AbstractSimpleExpression<String> {
        private static final long serialVersionUID = 1L;

        private YearExpression() {
        }

        public String evaluate(ReportParameters reportParameters) {
            return DynamicReports.type.dateYearType().valueToString("orderdate", reportParameters);
        }
    }
}

