/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.examples.miscellaneous;

import java.math.BigDecimal;
import net.sf.dynamicreports.examples.Templates;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.base.expression.AbstractSimpleExpression;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.component.TextFieldBuilder;
import net.sf.dynamicreports.report.builder.component.VerticalListBuilder;
import net.sf.dynamicreports.report.builder.group.ColumnGroupBuilder;
import net.sf.dynamicreports.report.builder.group.GroupBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.constant.GroupHeaderLayout;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class PrintWhenExpressionReport {
    public PrintWhenExpressionReport() {
        this.build();
    }

    private void build() {
        TextColumnBuilder itemColumn = DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType());
        ColumnGroupBuilder itemGroup = (ColumnGroupBuilder)DynamicReports.grp.group("itemGroup", (ValueColumnBuilder)itemColumn).setHeaderLayout(GroupHeaderLayout.EMPTY);
        TextFieldBuilder groupHeader = (TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)DynamicReports.cmp.text((DRIExpression)new GroupHeaderExpression()).setStyle((ReportStyleBuilder)Templates.groupStyle)).setPrintWhenExpression((DRIExpression)new PrintGroupHeaderExpression())).removeLineWhenBlank();
        VerticalListBuilder oddPageHeader = (VerticalListBuilder)((VerticalListBuilder)DynamicReports.cmp.verticalList().add(new ComponentBuilder[]{DynamicReports.cmp.text("Odd page header").setStyle((ReportStyleBuilder)Templates.bold12CenteredStyle), DynamicReports.cmp.line()}).setPrintWhenExpression((DRIExpression)new PrintInOddPageExpression())).removeLineWhenBlank();
        VerticalListBuilder evenPageHeader = (VerticalListBuilder)((VerticalListBuilder)DynamicReports.cmp.verticalList().add(new ComponentBuilder[]{DynamicReports.cmp.line(), DynamicReports.cmp.text("Even page header").setStyle((ReportStyleBuilder)Templates.bold12CenteredStyle), DynamicReports.cmp.line()}).setPrintWhenExpression((DRIExpression)new PrintInEvenPageExpression())).removeLineWhenBlank();
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).setPageColumnsPerPage(Integer.valueOf(2))).setPageColumnSpace(Integer.valueOf(5))).columns(new ColumnBuilder[]{itemColumn, DynamicReports.col.column("Quantity", "quantity", (DRIDataType)DynamicReports.type.integerType()), DynamicReports.col.column("Unit price", "unitprice", (DRIDataType)DynamicReports.type.bigDecimalType())})).groupBy(new GroupBuilder[]{itemGroup})).title(new ComponentBuilder[]{Templates.createTitleComponent("PrintWhenExpression")})).detailHeader(new ComponentBuilder[]{DynamicReports.cmp.columnBreak().setPrintWhenExpression((DRIExpression)new PrintGroupHeaderColumnBreakExpression()), groupHeader})).pageHeader(new ComponentBuilder[]{oddPageHeader, evenPageHeader, DynamicReports.cmp.verticalGap(10)})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"item", "quantity", "unitprice"});
        int i = 0;
        while (i < 50) {
            dataSource.add(new Object[]{"DVD", (int)(Math.random() * 10.0) + 1, new BigDecimal(Math.random() * 100.0 + 1.0)});
            ++i;
        }
        i = 0;
        while (i < 50) {
            dataSource.add(new Object[]{"Book", (int)(Math.random() * 10.0) + 1, new BigDecimal(Math.random() * 100.0 + 1.0)});
            ++i;
        }
        return dataSource;
    }

    public static void main(String[] args) {
        new PrintWhenExpressionReport();
    }

    public class GroupHeaderExpression
    extends AbstractSimpleExpression<String> {
        private static final long serialVersionUID = 10000L;

        public String evaluate(ReportParameters reportParameters) {
            return (String)reportParameters.getValue("item");
        }
    }

    public class PrintGroupHeaderColumnBreakExpression
    extends AbstractSimpleExpression<Boolean> {
        private static final long serialVersionUID = 10000L;

        public Boolean evaluate(ReportParameters reportParameters) {
            if (reportParameters.getColumnRowNumber() == 1 && reportParameters.getGroupCount("itemGroup") != 1) {
                return true;
            }
            return false;
        }
    }

    public class PrintGroupHeaderExpression
    extends AbstractSimpleExpression<Boolean> {
        private static final long serialVersionUID = 10000L;

        public Boolean evaluate(ReportParameters reportParameters) {
            if (reportParameters.getColumnRowNumber() != 1 && reportParameters.getGroupCount("itemGroup") != 1) {
                return false;
            }
            return true;
        }
    }

    public class PrintInEvenPageExpression
    extends AbstractSimpleExpression<Boolean> {
        private static final long serialVersionUID = 10000L;

        public Boolean evaluate(ReportParameters reportParameters) {
            if (reportParameters.getPageNumber().doubleValue() % 2.0 == 0.0) {
                return true;
            }
            return false;
        }
    }

    public class PrintInOddPageExpression
    extends AbstractSimpleExpression<Boolean> {
        private static final long serialVersionUID = 10000L;

        public Boolean evaluate(ReportParameters reportParameters) {
            if (reportParameters.getPageNumber().doubleValue() % 2.0 != 0.0) {
                return true;
            }
            return false;
        }
    }
}

