/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.examples.miscellaneous;

import java.util.HashMap;
import java.util.Map;
import net.sf.dynamicreports.examples.Templates;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.base.AbstractScriptlet;
import net.sf.dynamicreports.report.base.expression.AbstractSimpleExpression;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.group.CustomGroupBuilder;
import net.sf.dynamicreports.report.builder.group.GroupBuilder;
import net.sf.dynamicreports.report.builder.subtotal.CustomSubtotalBuilder;
import net.sf.dynamicreports.report.builder.subtotal.SubtotalBuilder;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.DRIScriptlet;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;
import org.apache.commons.lang3.StringUtils;

public class ScriptletReport {
    private Map<String, Integer> itemsCount;

    public ScriptletReport() {
        this.build();
    }

    private void build() {
        this.itemsCount = new HashMap<String, Integer>();
        TextColumnBuilder itemColumn = DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType());
        CustomSubtotalBuilder itemSbt = DynamicReports.sbt.customValue((DRIExpression)new ItemSubtotal(), (ColumnBuilder)itemColumn);
        CustomGroupBuilder group = DynamicReports.grp.group("country", String.class);
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).scriptlets(new DRIScriptlet[]{new ReportScriptlet()})).columns(new ColumnBuilder[]{itemColumn})).groupBy(new GroupBuilder[]{group})).subtotalsAtGroupFooter((GroupBuilder)group, new SubtotalBuilder[]{itemSbt})).title(new ComponentBuilder[]{Templates.createTitleComponent("Scriptlet")})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"country", "item"});
        dataSource.add(new Object[]{"USA", "Book"});
        dataSource.add(new Object[]{"USA", "DVD"});
        dataSource.add(new Object[]{"USA", "Book"});
        dataSource.add(new Object[]{"USA", "Book"});
        dataSource.add(new Object[]{"USA", "DVD"});
        dataSource.add(new Object[]{"USA", "Book"});
        dataSource.add(new Object[]{"USA", "DVD"});
        dataSource.add(new Object[]{"Canada", "Book"});
        dataSource.add(new Object[]{"Canada", "Book"});
        dataSource.add(new Object[]{"Canada", "DVD"});
        dataSource.add(new Object[]{"Canada", "Book"});
        dataSource.add(new Object[]{"Canada", "DVD"});
        dataSource.add(new Object[]{"Canada", "Phone"});
        return dataSource;
    }

    public static void main(String[] args) {
        new ScriptletReport();
    }

    private class ItemSubtotal
    extends AbstractSimpleExpression<String> {
        private static final long serialVersionUID = 1L;

        private ItemSubtotal() {
        }

        public String evaluate(ReportParameters reportParameters) {
            String result = "";
            for (String item : ScriptletReport.this.itemsCount.keySet()) {
                result = String.valueOf(result) + item + " = " + ScriptletReport.this.itemsCount.get(item) + "\n";
            }
            return StringUtils.removeEnd((String)result, (String)"\n");
        }
    }

    private class ReportScriptlet
    extends AbstractScriptlet {
        private ReportScriptlet() {
        }

        public void afterDetailEval(ReportParameters reportParameters) {
            super.afterDetailEval(reportParameters);
            String item = (String)reportParameters.getValue("item");
            Integer count = ScriptletReport.this.itemsCount.containsKey(item) ? (Integer)ScriptletReport.this.itemsCount.get(item) : Integer.valueOf(0);
            count = count + 1;
            ScriptletReport.this.itemsCount.put(item, count);
        }

        public void afterGroupInit(String groupName, ReportParameters reportParameters) {
            super.afterGroupInit(groupName, reportParameters);
            ScriptletReport.this.itemsCount.clear();
        }
    }
}

