/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.examples.miscellaneous;

import java.math.BigDecimal;
import java.util.List;
import net.sf.dynamicreports.examples.Templates;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.base.expression.AbstractSimpleExpression;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.VariableBuilder;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.expression.AbstractComplexExpression;
import net.sf.dynamicreports.report.constant.Calculation;
import net.sf.dynamicreports.report.constant.Evaluation;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class VariableReport {
    public VariableReport() {
        this.build();
    }

    private void build() {
        TextColumnBuilder itemColumn = DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType());
        TextColumnBuilder quantityColumn = DynamicReports.col.column("Quantity", "quantity", (DRIDataType)DynamicReports.type.integerType());
        TextColumnBuilder unitPriceColumn = DynamicReports.col.column("Unit price", "unitprice", (DRIDataType)DynamicReports.type.bigDecimalType());
        VariableBuilder itemCount = DynamicReports.variable((ValueColumnBuilder)itemColumn, (Calculation)Calculation.COUNT);
        VariableBuilder quantitySum = DynamicReports.variable((String)"quantitySum", (ValueColumnBuilder)quantityColumn, (Calculation)Calculation.SUM);
        VariableBuilder priceSum = DynamicReports.variable((DRIExpression)new PriceExpression((TextColumnBuilder<Integer>)quantityColumn, (TextColumnBuilder<BigDecimal>)unitPriceColumn), (Calculation)Calculation.SUM);
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).variables(new VariableBuilder[]{quantitySum})).columns(new ColumnBuilder[]{itemColumn, quantityColumn, unitPriceColumn})).title(new ComponentBuilder[]{Templates.createTitleComponent("Variable"), DynamicReports.cmp.horizontalList(new ComponentBuilder[]{DynamicReports.cmp.text("Item count =").setFixedWidth(Integer.valueOf(80)), DynamicReports.cmp.text(itemCount)}), DynamicReports.cmp.text((DRIExpression)new QuantitySumTextExpression()).setEvaluationTime(Evaluation.REPORT), DynamicReports.cmp.text((DRIExpression)new UnitPriceSumTextExpression((TextColumnBuilder<BigDecimal>)unitPriceColumn)), DynamicReports.cmp.horizontalList(new ComponentBuilder[]{DynamicReports.cmp.text("SUM(quantity * unit price) =").setFixedWidth(Integer.valueOf(150)), DynamicReports.cmp.text(priceSum).setPattern("#,###.00")})})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"item", "quantity", "unitprice"});
        int i = 0;
        while (i < 30) {
            dataSource.add(new Object[]{"Book", (int)(Math.random() * 10.0) + 1, new BigDecimal(Math.random() * 100.0 + 1.0)});
            ++i;
        }
        return dataSource;
    }

    public static void main(String[] args) {
        new VariableReport();
    }

    private class PriceExpression
    extends AbstractSimpleExpression<BigDecimal> {
        private static final long serialVersionUID = 1L;
        private TextColumnBuilder<Integer> quantityColumn;
        private TextColumnBuilder<BigDecimal> unitPriceColumn;

        public PriceExpression(TextColumnBuilder<Integer> quantityColumn, TextColumnBuilder<BigDecimal> unitPriceColumn) {
            this.quantityColumn = quantityColumn;
            this.unitPriceColumn = unitPriceColumn;
        }

        public BigDecimal evaluate(ReportParameters reportParameters) {
            Integer quantity = (Integer)reportParameters.getValue(this.quantityColumn);
            BigDecimal unitPrice = (BigDecimal)reportParameters.getValue(this.unitPriceColumn);
            return unitPrice.multiply(new BigDecimal(quantity));
        }
    }

    private class QuantitySumTextExpression
    extends AbstractSimpleExpression<String> {
        private static final long serialVersionUID = 1L;

        private QuantitySumTextExpression() {
        }

        public String evaluate(ReportParameters reportParameters) {
            Integer quantitySum = (Integer)reportParameters.getValue("quantitySum");
            return "Quantity sum = " + quantitySum;
        }
    }

    private class UnitPriceSumTextExpression
    extends AbstractComplexExpression<String> {
        private static final long serialVersionUID = 1L;

        public UnitPriceSumTextExpression(TextColumnBuilder<BigDecimal> unitPriceColumn) {
            this.addExpression(DynamicReports.variable(unitPriceColumn, (Calculation)Calculation.SUM));
        }

        public String evaluate(List<?> values, ReportParameters reportParameters) {
            BigDecimal unitPriceSum = (BigDecimal)values.get(0);
            return "Unit price sum = " + DynamicReports.type.bigDecimalType().valueToString((Number)unitPriceSum, reportParameters.getLocale());
        }
    }
}

