/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.examples.style;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import net.sf.dynamicreports.examples.Templates;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.builder.style.TemplateStyleListBuilder;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class TemplateStyleFileReport {
    public TemplateStyleFileReport() {
        this.build();
    }

    private void build() {
        TextColumnBuilder itemColumn = (TextColumnBuilder)DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType()).setStyle((ReportStyleBuilder)DynamicReports.stl.templateStyle("style1"));
        TextColumnBuilder orderDateColumn = (TextColumnBuilder)DynamicReports.col.column("Order date", "orderdate", (DRIDataType)DynamicReports.type.dateType()).setStyle((ReportStyleBuilder)DynamicReports.stl.templateStyle("style2"));
        TextColumnBuilder quantityColumn = DynamicReports.col.column("Quantity", "quantity", (DRIDataType)DynamicReports.type.integerType());
        TextColumnBuilder unitPriceColumn = DynamicReports.col.column("Unit price", "unitprice", (DRIDataType)DynamicReports.type.bigDecimalType());
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().templateStyles(new TemplateStyleListBuilder[]{DynamicReports.stl.loadStyles(TemplateStyleFileReport.class.getResource("TemplateStyles.jrtx"))})).setColumnStyle((ReportStyleBuilder)DynamicReports.stl.templateStyle("columnStyle"))).setColumnTitleStyle((ReportStyleBuilder)DynamicReports.stl.templateStyle("columnTitleStyle"))).columns(new ColumnBuilder[]{itemColumn, orderDateColumn, quantityColumn, unitPriceColumn})).title(new ComponentBuilder[]{Templates.createTitleComponent("TemplateStyleFile")})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"item", "orderdate", "quantity", "unitprice"});
        dataSource.add(new Object[]{"DVD", this.toDate(2010, 1, 1), 5, new BigDecimal(30)});
        dataSource.add(new Object[]{"DVD", this.toDate(2010, 1, 3), 1, new BigDecimal(28)});
        dataSource.add(new Object[]{"DVD", this.toDate(2010, 1, 19), 5, new BigDecimal(32)});
        dataSource.add(new Object[]{"Book", this.toDate(2010, 1, 5), 3, new BigDecimal(11)});
        dataSource.add(new Object[]{"Book", this.toDate(2010, 1, 11), 1, new BigDecimal(15)});
        dataSource.add(new Object[]{"Book", this.toDate(2010, 1, 15), 5, new BigDecimal(10)});
        dataSource.add(new Object[]{"Book", this.toDate(2010, 1, 20), 8, new BigDecimal(9)});
        return dataSource;
    }

    private Date toDate(int year, int month, int day) {
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(2, month - 1);
        c.set(5, day);
        return c.getTime();
    }

    public static void main(String[] args) {
        new TemplateStyleFileReport();
    }
}

