/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.examples.subtotal;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import net.sf.dynamicreports.examples.Templates;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.subtotal.AggregationSubtotalBuilder;
import net.sf.dynamicreports.report.builder.subtotal.SubtotalBuilder;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class AggregationSubtotalReport {
    public AggregationSubtotalReport() {
        this.build();
    }

    private void build() {
        TextColumnBuilder itemColumn = DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType());
        TextColumnBuilder orderDateColumn = DynamicReports.col.column("Order Date", "orderdate", (DRIDataType)DynamicReports.type.dateType());
        TextColumnBuilder quantityColumn = DynamicReports.col.column("Quantity", "quantity", (DRIDataType)DynamicReports.type.integerType());
        TextColumnBuilder unitPriceColumn = DynamicReports.col.column("Unit price", "unitprice", (DRIDataType)DynamicReports.type.bigDecimalType());
        AggregationSubtotalBuilder itemCount = (AggregationSubtotalBuilder)DynamicReports.sbt.count((ValueColumnBuilder)itemColumn).setLabel("count");
        AggregationSubtotalBuilder itemDistCount = (AggregationSubtotalBuilder)DynamicReports.sbt.distinctCount((ValueColumnBuilder)itemColumn).setLabel("distinct count");
        AggregationSubtotalBuilder itemSum = (AggregationSubtotalBuilder)((AggregationSubtotalBuilder)DynamicReports.sbt.sum((ValueColumnBuilder)unitPriceColumn).setLabel("unit price sum")).setShowInColumn((ColumnBuilder)itemColumn);
        AggregationSubtotalBuilder orderDateCount = (AggregationSubtotalBuilder)DynamicReports.sbt.count((ValueColumnBuilder)orderDateColumn).setLabel("count");
        AggregationSubtotalBuilder orderDateDistCount = (AggregationSubtotalBuilder)DynamicReports.sbt.distinctCount((ValueColumnBuilder)orderDateColumn).setLabel("distinct count");
        AggregationSubtotalBuilder orderDateMin = (AggregationSubtotalBuilder)DynamicReports.sbt.min((ValueColumnBuilder)orderDateColumn).setLabel("min value");
        AggregationSubtotalBuilder orderDateMax = (AggregationSubtotalBuilder)DynamicReports.sbt.max((ValueColumnBuilder)orderDateColumn).setLabel("max value");
        AggregationSubtotalBuilder quantitySum = (AggregationSubtotalBuilder)DynamicReports.sbt.sum((ValueColumnBuilder)quantityColumn).setLabel("sum");
        AggregationSubtotalBuilder quantityAvg = (AggregationSubtotalBuilder)DynamicReports.sbt.avg((ValueColumnBuilder)quantityColumn).setLabel("avg");
        AggregationSubtotalBuilder quantityCount = (AggregationSubtotalBuilder)DynamicReports.sbt.count((ValueColumnBuilder)quantityColumn).setLabel("count");
        AggregationSubtotalBuilder quantityDistCount = (AggregationSubtotalBuilder)DynamicReports.sbt.distinctCount((ValueColumnBuilder)quantityColumn).setLabel("distinct count");
        AggregationSubtotalBuilder quantityMin = (AggregationSubtotalBuilder)DynamicReports.sbt.min((ValueColumnBuilder)quantityColumn).setLabel("min value");
        AggregationSubtotalBuilder quantityMax = (AggregationSubtotalBuilder)DynamicReports.sbt.max((ValueColumnBuilder)quantityColumn).setLabel("max value");
        AggregationSubtotalBuilder unitPriceSum = (AggregationSubtotalBuilder)DynamicReports.sbt.sum((ValueColumnBuilder)unitPriceColumn).setLabel("sum");
        AggregationSubtotalBuilder unitPriceAvg = (AggregationSubtotalBuilder)DynamicReports.sbt.avg((ValueColumnBuilder)unitPriceColumn).setLabel("avg");
        AggregationSubtotalBuilder unitPriceCount = (AggregationSubtotalBuilder)DynamicReports.sbt.count((ValueColumnBuilder)unitPriceColumn).setLabel("count");
        AggregationSubtotalBuilder unitPriceDistCount = (AggregationSubtotalBuilder)DynamicReports.sbt.distinctCount((ValueColumnBuilder)unitPriceColumn).setLabel("distinct count");
        AggregationSubtotalBuilder unitPriceFirst = (AggregationSubtotalBuilder)DynamicReports.sbt.first((ValueColumnBuilder)unitPriceColumn).setLabel("first value");
        AggregationSubtotalBuilder unitPriceStdDev = (AggregationSubtotalBuilder)DynamicReports.sbt.stdDev((ValueColumnBuilder)unitPriceColumn).setLabel("standard deviation");
        AggregationSubtotalBuilder unitPriceVar = (AggregationSubtotalBuilder)DynamicReports.sbt.var((ValueColumnBuilder)unitPriceColumn).setLabel("variance");
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).columns(new ColumnBuilder[]{itemColumn, orderDateColumn, quantityColumn, unitPriceColumn})).subtotalsAtSummary(new SubtotalBuilder[]{itemSum, itemCount, itemDistCount, orderDateCount, orderDateDistCount, orderDateMin, orderDateMax, quantitySum, quantityAvg, quantityCount, quantityDistCount, quantityMin, quantityMax, unitPriceSum, unitPriceAvg, unitPriceCount, unitPriceDistCount, unitPriceFirst, unitPriceStdDev, unitPriceVar})).title(new ComponentBuilder[]{Templates.createTitleComponent("AggregationSubtotal")})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"item", "orderdate", "quantity", "unitprice"});
        dataSource.add(new Object[]{"Book", this.toDate(2010, 1, 1), 3, new BigDecimal(11)});
        dataSource.add(new Object[]{"Book", this.toDate(2010, 2, 1), 1, new BigDecimal(15)});
        dataSource.add(new Object[]{"Book", this.toDate(2010, 2, 1), 3, new BigDecimal(10)});
        dataSource.add(new Object[]{"Book", this.toDate(2010, 4, 1), 8, new BigDecimal(9)});
        return dataSource;
    }

    private Date toDate(int year, int month, int day) {
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(2, month - 1);
        c.set(5, day);
        return c.getTime();
    }

    public static void main(String[] args) {
        new AggregationSubtotalReport();
    }
}

