/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.examples.subtotal;

import java.awt.Color;
import java.math.BigDecimal;
import net.sf.dynamicreports.examples.Templates;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.group.ColumnGroupBuilder;
import net.sf.dynamicreports.report.builder.group.GroupBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.builder.style.StyleBuilder;
import net.sf.dynamicreports.report.builder.subtotal.PercentageSubtotalBuilder;
import net.sf.dynamicreports.report.constant.PercentageTotalType;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class PercentageSubtotalReport {
    public PercentageSubtotalReport() {
        this.build();
    }

    private void build() {
        TextColumnBuilder countryColumn = DynamicReports.col.column("Country", "country", (DRIDataType)DynamicReports.type.stringType());
        TextColumnBuilder itemColumn = DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType());
        TextColumnBuilder priceColumn = DynamicReports.col.column("Price", "price", (DRIDataType)DynamicReports.type.bigDecimalType());
        ColumnGroupBuilder countryGroup = DynamicReports.grp.group((ValueColumnBuilder)countryColumn);
        ColumnGroupBuilder itemGroup = DynamicReports.grp.group((ValueColumnBuilder)itemColumn);
        StyleBuilder countryLabelStyle = (StyleBuilder)DynamicReports.stl.style().setForegroundColor(Color.RED);
        StyleBuilder countryStyle = (StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)countryLabelStyle).setTopBorder(DynamicReports.stl.pen1Point());
        StyleBuilder itemInCountryLabelStyle = (StyleBuilder)DynamicReports.stl.style().setForegroundColor(Color.GREEN);
        StyleBuilder itemInCountryStyle = (StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)itemInCountryLabelStyle).setTopBorder(DynamicReports.stl.pen1Point());
        StyleBuilder itemLabelStyle = (StyleBuilder)DynamicReports.stl.style().setForegroundColor(Color.BLUE);
        StyleBuilder itemStyle = (StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)itemLabelStyle).setTopBorder(DynamicReports.stl.pen1Point());
        PercentageSubtotalBuilder countryPercentage = (PercentageSubtotalBuilder)((PercentageSubtotalBuilder)((PercentageSubtotalBuilder)DynamicReports.sbt.percentage((ValueColumnBuilder)priceColumn).setLabel("country price [%]")).setLabelStyle((ReportStyleBuilder)countryLabelStyle)).setStyle((ReportStyleBuilder)countryStyle);
        PercentageSubtotalBuilder itemInCountryPercentage = (PercentageSubtotalBuilder)((PercentageSubtotalBuilder)((PercentageSubtotalBuilder)DynamicReports.sbt.percentage((ValueColumnBuilder)priceColumn).setLabel("item in country price[%]")).setLabelStyle((ReportStyleBuilder)itemInCountryLabelStyle)).setStyle((ReportStyleBuilder)itemInCountryStyle);
        PercentageSubtotalBuilder itemPercentage = ((PercentageSubtotalBuilder)((PercentageSubtotalBuilder)((PercentageSubtotalBuilder)DynamicReports.sbt.percentage((ValueColumnBuilder)priceColumn).setLabel("item price[%]")).setLabelStyle((ReportStyleBuilder)itemLabelStyle)).setStyle((ReportStyleBuilder)itemStyle)).setTotalType(PercentageTotalType.REPORT);
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).columns(new ColumnBuilder[]{countryColumn, itemColumn, priceColumn})).groupBy(new GroupBuilder[]{countryGroup, itemGroup})).subtotalsOfPercentageAtGroupFooter((GroupBuilder)countryGroup, new PercentageSubtotalBuilder[]{countryPercentage})).subtotalsOfPercentageAtGroupFooter((GroupBuilder)itemGroup, new PercentageSubtotalBuilder[]{itemInCountryPercentage, itemPercentage})).title(new ComponentBuilder[]{Templates.createTitleComponent("PercentageSubtotal")})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"country", "item", "price"});
        dataSource.add(new Object[]{"USA", "Book", new BigDecimal(10)});
        dataSource.add(new Object[]{"USA", "Book", new BigDecimal(10)});
        dataSource.add(new Object[]{"USA", "Notebook", new BigDecimal(20)});
        dataSource.add(new Object[]{"USA", "Notebook", new BigDecimal(20)});
        dataSource.add(new Object[]{"Canada", "Book", new BigDecimal(15)});
        dataSource.add(new Object[]{"Canada", "Book", new BigDecimal(15)});
        dataSource.add(new Object[]{"Canada", "Notebook", new BigDecimal(30)});
        dataSource.add(new Object[]{"Canada", "Notebook", new BigDecimal(30)});
        return dataSource;
    }

    public static void main(String[] args) {
        new PercentageSubtotalReport();
    }
}

