/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.examples.subtotal;

import java.math.BigDecimal;
import net.sf.dynamicreports.examples.Templates;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.base.expression.AbstractSimpleExpression;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.VariableBuilder;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.subtotal.CustomSubtotalBuilder;
import net.sf.dynamicreports.report.builder.subtotal.SubtotalBuilder;
import net.sf.dynamicreports.report.constant.Calculation;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.DRIValue;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class VariableSubtotalReport {
    private VariableBuilder<Integer> quantitySum;
    private VariableBuilder<BigDecimal> priceSum;

    public VariableSubtotalReport() {
        this.build();
    }

    private void build() {
        this.quantitySum = DynamicReports.variable((String)"quantity", Integer.class, (Calculation)Calculation.SUM);
        this.priceSum = DynamicReports.variable((String)"price", BigDecimal.class, (Calculation)Calculation.SUM);
        TextColumnBuilder itemColumn = DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType());
        CustomSubtotalBuilder unitPriceSbt = (CustomSubtotalBuilder)((CustomSubtotalBuilder)DynamicReports.sbt.customValue((DRIExpression)new UnitPriceSubtotal(), (ColumnBuilder)itemColumn).setLabel("sum(price) / sum(quantity)")).setDataType((DRIDataType)DynamicReports.type.bigDecimalType());
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).variables(new VariableBuilder[]{this.quantitySum, this.priceSum})).columns(new ColumnBuilder[]{itemColumn})).subtotalsAtSummary(new SubtotalBuilder[]{unitPriceSbt})).title(new ComponentBuilder[]{Templates.createTitleComponent("VariableSubtotal")})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"item", "quantity", "price"});
        dataSource.add(new Object[]{"Book", 3, new BigDecimal(11)});
        dataSource.add(new Object[]{"Book", 1, new BigDecimal(15)});
        dataSource.add(new Object[]{"Book", 3, new BigDecimal(10)});
        dataSource.add(new Object[]{"Book", 8, new BigDecimal(9)});
        return dataSource;
    }

    public static void main(String[] args) {
        new VariableSubtotalReport();
    }

    private class UnitPriceSubtotal
    extends AbstractSimpleExpression<BigDecimal> {
        private static final long serialVersionUID = 1L;

        private UnitPriceSubtotal() {
        }

        public BigDecimal evaluate(ReportParameters reportParameters) {
            Integer quantitySumValue = (Integer)reportParameters.getValue((DRIValue)VariableSubtotalReport.this.quantitySum);
            BigDecimal priceSumValue = (BigDecimal)reportParameters.getValue((DRIValue)VariableSubtotalReport.this.priceSum);
            return priceSumValue.divide(new BigDecimal(quantitySumValue), 2, 4);
        }
    }
}

