/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.examples.tableofcontents;

import java.awt.Color;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import net.sf.dynamicreports.examples.Templates;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.component.VerticalListBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.builder.style.StyleBuilder;
import net.sf.dynamicreports.report.builder.tableofcontents.TableOfContentsCustomizer;
import net.sf.dynamicreports.report.constant.HorizontalAlignment;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.DRITableOfContentsCustomizer;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class CustomTableOfContentsReport {
    public CustomTableOfContentsReport() {
        this.build();
    }

    private void build() {
        TextColumnBuilder countryColumn = DynamicReports.col.column("Country", "country", (DRIDataType)DynamicReports.type.stringType());
        TextColumnBuilder itemColumn = DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType());
        StyleBuilder titleTocStyle = (StyleBuilder)((StyleBuilder)((StyleBuilder)((StyleBuilder)DynamicReports.stl.style().setForegroundColor(Color.BLUE)).setFontSize(Integer.valueOf(18))).bold()).setHorizontalAlignment(HorizontalAlignment.CENTER);
        StyleBuilder headingToc0Style = (StyleBuilder)((StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)Templates.rootStyle).setFontSize(Integer.valueOf(12))).bold();
        StyleBuilder headingToc1Style = (StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)Templates.rootStyle).italic();
        CustomTableOfContentsCustomizer tableOfContentsCustomizer = new CustomTableOfContentsCustomizer();
        tableOfContentsCustomizer.setTitleStyle((ReportStyleBuilder)titleTocStyle);
        tableOfContentsCustomizer.setHeadingStyle(0, (ReportStyleBuilder)headingToc0Style);
        tableOfContentsCustomizer.setHeadingStyle(1, (ReportStyleBuilder)headingToc1Style);
        tableOfContentsCustomizer.setTextFixedWidth(100);
        tableOfContentsCustomizer.setPageIndexFixedWidth(30);
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).tableOfContents((DRITableOfContentsCustomizer)tableOfContentsCustomizer)).columns(new ColumnBuilder[]{countryColumn, itemColumn, DynamicReports.col.column("Order date", "orderdate", (DRIDataType)DynamicReports.type.dateType()), DynamicReports.col.column("Quantity", "quantity", (DRIDataType)DynamicReports.type.integerType()), DynamicReports.col.column("Unit price", "unitprice", (DRIDataType)DynamicReports.type.bigDecimalType())})).groupBy(new ValueColumnBuilder[]{countryColumn, itemColumn})).title(new ComponentBuilder[]{Templates.createTitleComponent("CustomTableOfContents")})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        String[] countries = new String[]{"USA", "Canada", "Mexico"};
        String[] items = new String[]{"Book", "Notebook", "PDA"};
        DRDataSource dataSource = new DRDataSource(new String[]{"country", "item", "orderdate", "quantity", "unitprice"});
        String[] stringArray = countries;
        int n = countries.length;
        int n2 = 0;
        while (n2 < n) {
            String country = stringArray[n2];
            String[] stringArray2 = items;
            int n3 = items.length;
            int n4 = 0;
            while (n4 < n3) {
                String item = stringArray2[n4];
                int i = 0;
                while (i < 8) {
                    dataSource.add(new Object[]{country, item, this.toDate(2010, 1, (int)(Math.random() * 10.0) + 1), (int)(Math.random() * 10.0) + 1, new BigDecimal(Math.random() * 100.0 + 1.0)});
                    ++i;
                }
                ++n4;
            }
            ++n2;
        }
        return dataSource;
    }

    private Date toDate(int year, int month, int day) {
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(2, month - 1);
        c.set(5, day);
        return c.getTime();
    }

    public static void main(String[] args) {
        new CustomTableOfContentsReport();
    }

    private class CustomTableOfContentsCustomizer
    extends TableOfContentsCustomizer {
        private static final long serialVersionUID = 1L;

        private CustomTableOfContentsCustomizer() {
        }

        protected ComponentBuilder<?, ?> title() {
            VerticalListBuilder verticalList = DynamicReports.cmp.verticalList();
            verticalList.add(new ComponentBuilder[]{DynamicReports.cmp.line()});
            verticalList.add(new ComponentBuilder[]{super.title()});
            verticalList.add(new ComponentBuilder[]{DynamicReports.cmp.line()});
            return verticalList;
        }

        protected ComponentBuilder<?, ?> headingComponent(int level) {
            if (level == 0) {
                VerticalListBuilder verticalList = DynamicReports.cmp.verticalList();
                verticalList.add(new ComponentBuilder[]{super.headingComponent(level)});
                verticalList.add(new ComponentBuilder[]{DynamicReports.cmp.line()});
                return verticalList;
            }
            return super.headingComponent(level);
        }
    }
}

