/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.helper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class ConsoleUtil {
    public static void printPrompt(String prompt) {
        System.out.println(prompt + " ");
        System.out.flush();
    }

    public static String readString() throws IOException {
        InputStreamReader input = new InputStreamReader(System.in);
        BufferedReader reader = new BufferedReader(input);
        String rs = reader.readLine();
        if (rs == null) {
            rs = "";
        }
        return rs.trim();
    }

    public static String readString(String prompt) throws IOException {
        ConsoleUtil.printPrompt(prompt);
        return ConsoleUtil.readString();
    }

    public static int readInt(String prompt) throws IOException {
        while (true) {
            ConsoleUtil.printPrompt(prompt);
            try {
                return Integer.valueOf(ConsoleUtil.readString().trim());
            }
            catch (NumberFormatException e) {
                System.out.println("Not an integer. Please try again!");
                continue;
            }
            break;
        }
    }

    public static double readDouble(String prompt) throws IOException {
        while (true) {
            ConsoleUtil.printPrompt(prompt);
            try {
                return Double.valueOf(ConsoleUtil.readString().trim());
            }
            catch (NumberFormatException e) {
                System.out.println("Not a floating point number. Please try again!");
                continue;
            }
            break;
        }
    }
}

