/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.helper;

import com.ebay.sdk.util.XPathUtil;
import com.ebay.sdk.util.XmlUtil;
import com.ebay.soap.eBLBaseComponents.SiteCodeType;
import java.io.InputStream;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class eBayDetailsHelper {
    static eBayDetailsHelper _helper = new eBayDetailsHelper();
    static Hashtable<SiteCodeType, Document> _eBayDetails = new Hashtable();
    private static String NAME_TEXT = "Name/text()";
    private static String EBAY_DETAILS = "com/ebay/sdk/helper/policy/ebaydetails";
    private static String DETAIL_PATH = "//eBay/Details/Detail";
    private static String DESCRIPTION = "Description";
    private static String VALUE = "Value";

    public static eBayDetailsHelper getInstance() {
        return _helper;
    }

    private eBayDetailsHelper() {
    }

    private Document getResource(SiteCodeType sideId) {
        Document doc = null;
        try {
            String source = EBAY_DETAILS + "_" + sideId.value().toLowerCase() + ".xml";
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            InputStream is = loader.getResourceAsStream(source);
            doc = XmlUtil.createDom((InputStream)is);
            is.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return doc;
    }

    public Document geteBayDetailsDocument(SiteCodeType siteId) {
        Document doc = _eBayDetails.get(siteId);
        if (doc == null && (doc = this.getResource(siteId)) != null) {
            _eBayDetails.put(siteId, doc);
        }
        return doc;
    }

    public Hashtable getDetailEntryMapWithIntValue(SiteCodeType siteId, String detailName) {
        Hashtable<Integer, String> ht = new Hashtable<Integer, String>();
        try {
            NodeList list = this.getDetailNodeList(siteId, detailName);
            if (list != null) {
                NodeList childList = list.item(0).getChildNodes();
                int len = childList.getLength();
                for (int i = 0; i < len; ++i) {
                    Node node = childList.item(i);
                    if (node.getNodeType() != 1) continue;
                    Node valNode = XPathUtil.selectSingleNode((String)VALUE, (Node)node);
                    Node desNode = XPathUtil.selectSingleNode((String)DESCRIPTION, (Node)node);
                    if (valNode == null || desNode == null) continue;
                    Integer value = new Integer(valNode.getFirstChild().getNodeValue());
                    String des = desNode.getFirstChild().getNodeValue();
                    ht.put(value, des);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return ht;
    }

    public Hashtable getDetailEntryMapWithStringValue(SiteCodeType siteId, String detailName) {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        try {
            NodeList list = this.getDetailNodeList(siteId, detailName);
            if (list != null) {
                NodeList childList = list.item(0).getChildNodes();
                int len = childList.getLength();
                for (int i = 0; i < len; ++i) {
                    Node node = childList.item(i);
                    if (node.getNodeType() != 1) continue;
                    Node valNode = XPathUtil.selectSingleNode((String)VALUE, (Node)node);
                    Node desNode = XPathUtil.selectSingleNode((String)DESCRIPTION, (Node)node);
                    if (valNode == null || desNode == null) continue;
                    String value = valNode.getFirstChild().getNodeValue();
                    String des = desNode.getFirstChild().getNodeValue();
                    ht.put(value, des);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return ht;
    }

    private NodeList getDetailNodeList(SiteCodeType siteId, String detailName) {
        Document ctxNode = this.geteBayDetailsDocument(siteId);
        NodeList list = null;
        String xpath = DETAIL_PATH + "[" + NAME_TEXT + "='" + detailName + "']";
        try {
            list = XPathUtil.selectNodes((String)xpath, (Node)ctxNode);
        }
        catch (Exception e) {
            // empty catch block
        }
        return list;
    }
}

