/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.helper;

import com.ebay.sdk.ApiContext;
import com.ebay.sdk.SdkException;
import com.ebay.sdk.call.GeteBayDetailsCall;
import com.ebay.soap.eBLBaseComponents.BuyerPaymentMethodCodeType;
import com.ebay.soap.eBLBaseComponents.CountryCodeType;
import com.ebay.soap.eBLBaseComponents.CountryDetailsType;
import com.ebay.soap.eBLBaseComponents.CurrencyCodeType;
import com.ebay.soap.eBLBaseComponents.CurrencyDetailsType;
import com.ebay.soap.eBLBaseComponents.DetailLevelCodeType;
import com.ebay.soap.eBLBaseComponents.DetailNameCodeType;
import com.ebay.soap.eBLBaseComponents.DispatchTimeMaxDetailsType;
import com.ebay.soap.eBLBaseComponents.GeteBayDetailsResponseType;
import com.ebay.soap.eBLBaseComponents.PaymentOptionDetailsType;
import com.ebay.soap.eBLBaseComponents.RegionDetailsType;
import com.ebay.soap.eBLBaseComponents.ShippingLocationDetailsType;
import com.ebay.soap.eBLBaseComponents.ShippingServiceDetailsType;
import com.ebay.soap.eBLBaseComponents.SiteCodeType;
import com.ebay.soap.eBLBaseComponents.SiteDetailsType;
import com.ebay.soap.eBLBaseComponents.TaxJurisdictionType;
import com.ebay.soap.eBLBaseComponents.TimeZoneDetailsType;
import com.ebay.soap.eBLBaseComponents.URLDetailsType;
import com.ebay.soap.eBLBaseComponents.URLTypeCodeType;
import java.util.HashMap;

public class eBayDetailsHelper1 {
    private static eBayDetailsHelper1 _helper;
    private ApiContext _apiContext;
    private SiteCodeType _site;
    private DetailNameCodeType[] _siteIndependentDetailNames = new DetailNameCodeType[]{DetailNameCodeType.COUNTRY_DETAILS, DetailNameCodeType.CURRENCY_DETAILS, DetailNameCodeType.DISPATCH_TIME_MAX_DETAILS, DetailNameCodeType.SHIPPING_LOCATION_DETAILS, DetailNameCodeType.SITE_DETAILS, DetailNameCodeType.TIME_ZONE_DETAILS};
    private DetailNameCodeType[] _siteRelatedDetailNames = new DetailNameCodeType[]{DetailNameCodeType.PAYMENT_OPTION_DETAILS, DetailNameCodeType.REGION_DETAILS, DetailNameCodeType.SHIPPING_SERVICE_DETAILS, DetailNameCodeType.TAX_JURISDICTION, DetailNameCodeType.URL_DETAILS};
    private static HashMap _SiteRelatedDetailsByName;
    private static HashMap _SiteRelatedDetailsMapsByName;
    private static HashMap _CountryDetailsByCountry;
    private CountryDetailsType[] _countryDetails = null;
    private static HashMap _CurrencyDetailsByCurrency;
    private CurrencyDetailsType[] _currencyDetails = null;
    private static HashMap _DispatchTimeMaxDetailsByDispatchTimeMax;
    private DispatchTimeMaxDetailsType[] _dispatchTimeMaxDetails = null;
    private static HashMap _ShippingLocationDetailsByShippingLocation;
    private ShippingLocationDetailsType[] _shippingLocationDetails = null;
    private static HashMap _SiteDetailsBySite;
    private SiteDetailsType[] _siteDetails = null;
    private static HashMap _TimeZoneDetails;
    private TimeZoneDetailsType[] _timeZoneDetails = null;
    private static HashMap _PaymentOptionDetailsMapsBySite;
    private static HashMap _PaymentOptionDetailsBySite;
    private static HashMap _RegionDetailsMapsBySite;
    private static HashMap _RegionDetailsBySite;
    private RegionDetailsType[] _regionDetails = null;
    private static HashMap _ShippingServiceDetailsMapsBySite;
    private static HashMap _ShippingServiceDetailsBySite;
    private ShippingServiceDetailsType[] _shippingServiceDetails = null;
    private static HashMap _TaxJurisdictionDetailsMapsBySite;
    private static HashMap _TaxJurisdictionDetailsBySite;
    private TaxJurisdictionType[] _taxJurisdictionDetails = null;
    private static HashMap _URLDetailsMapsBySite;
    private static HashMap _URLDetailsBySite;

    private eBayDetailsHelper1() {
    }

    public static eBayDetailsHelper1 getInstance(ApiContext context) throws SdkException, Exception {
        if (_helper == null) {
            _helper = new eBayDetailsHelper1(context);
        }
        return _helper;
    }

    private eBayDetailsHelper1(ApiContext context) throws SdkException, Exception {
        this._apiContext = context;
        this._site = this._apiContext.getSite();
        this.loadSiteIndependentDetails();
        this.initializeHashMaps();
        this.loadSiteRelatedDetailsForSite(this._site);
    }

    public PaymentOptionDetailsType[] getPaymentOptionDetailsForSite(SiteCodeType site) throws SdkException, Exception {
        HashMap detalisMap = (HashMap)_SiteRelatedDetailsByName.get(DetailNameCodeType.PAYMENT_OPTION_DETAILS);
        if (!detalisMap.containsKey(site)) {
            this.loadPaymentOptionsDetailsForSite(site);
        }
        return (PaymentOptionDetailsType[])detalisMap.get(site);
    }

    public PaymentOptionDetailsType getPaymentOptionDetailsBySiteAndPaymentMethod(SiteCodeType site, BuyerPaymentMethodCodeType paymentMethod) throws SdkException, Exception {
        HashMap detailsMap = (HashMap)_SiteRelatedDetailsMapsByName.get(DetailNameCodeType.PAYMENT_OPTION_DETAILS);
        if (!detailsMap.containsKey(site)) {
            this.loadPaymentOptionsDetailsForSite(site);
        }
        HashMap byPaymentMethodMap = (HashMap)detailsMap.get(site);
        return (PaymentOptionDetailsType)byPaymentMethodMap.get(paymentMethod);
    }

    private void loadPaymentOptionsDetailsForSite(GeteBayDetailsResponseType resp, SiteCodeType site) throws SdkException, Exception {
        PaymentOptionDetailsType[] details;
        if (resp == null) {
            DetailNameCodeType[] detailNames = new DetailNameCodeType[]{DetailNameCodeType.PAYMENT_OPTION_DETAILS};
            resp = this.makeApiCall(detailNames, site);
        }
        if ((details = resp.getPaymentOptionDetails()) != null) {
            _PaymentOptionDetailsBySite.put(site, details);
            HashMap<BuyerPaymentMethodCodeType, PaymentOptionDetailsType> detailsByPaymentMethodMap = new HashMap<BuyerPaymentMethodCodeType, PaymentOptionDetailsType>(details.length);
            for (int i = 0; i < details.length; ++i) {
                PaymentOptionDetailsType detail = details[i];
                detailsByPaymentMethodMap.put(detail.getPaymentOption(), detail);
            }
            _PaymentOptionDetailsMapsBySite.put(site, detailsByPaymentMethodMap);
        }
    }

    private void loadPaymentOptionsDetailsForSite(SiteCodeType site) throws SdkException, Exception {
        this.loadPaymentOptionsDetailsForSite(null, site);
    }

    public RegionDetailsType[] getRegionDetailsForSite(SiteCodeType site) throws SdkException, Exception {
        return null;
    }

    public RegionDetailsType getRegionDetailsBySiteAndRegionID(SiteCodeType site, String regionId) throws SdkException, Exception {
        return null;
    }

    public ShippingServiceDetailsType[] getShippingServiceDetailsForSite(SiteCodeType site) throws SdkException, Exception {
        return null;
    }

    public ShippingServiceDetailsType getShippingServiceDetailsBySiteAndShippingServiceID(SiteCodeType site, Integer shippingServiceID) throws SdkException, Exception {
        return null;
    }

    public TaxJurisdictionType[] getTaxJurisdictionDetailsForSite(SiteCodeType site) throws SdkException, Exception {
        return null;
    }

    public TaxJurisdictionType getTaxJurisdictionDetailsBySiteAndJurisdictionID(SiteCodeType site, String jurisdictionID) throws SdkException, Exception {
        return null;
    }

    public URLDetailsType[] getURLDetailsForSite(SiteCodeType site) throws SdkException, Exception {
        HashMap detalisMap = (HashMap)_SiteRelatedDetailsByName.get(DetailNameCodeType.URL_DETAILS);
        if (!detalisMap.containsKey(site)) {
            this.loadURLDetailsForSite(site);
        }
        return (URLDetailsType[])detalisMap.get(site);
    }

    public URLDetailsType getURLDetailsBySiteAndURLType(SiteCodeType site, URLTypeCodeType URLType) throws SdkException, Exception {
        HashMap detailsMap = (HashMap)_SiteRelatedDetailsMapsByName.get(DetailNameCodeType.URL_DETAILS);
        if (!detailsMap.containsKey(site)) {
            this.loadURLDetailsForSite(site);
        }
        HashMap byCodeTypeMap = (HashMap)detailsMap.get(site);
        return (URLDetailsType)byCodeTypeMap.get(URLType);
    }

    private void loadURLDetailsForSite(GeteBayDetailsResponseType resp, SiteCodeType site) throws SdkException, Exception {
        URLDetailsType[] urlDetails;
        if (resp == null) {
            DetailNameCodeType[] detailNames = new DetailNameCodeType[]{DetailNameCodeType.URL_DETAILS};
            resp = this.makeApiCall(detailNames, site);
        }
        if ((urlDetails = resp.getURLDetails()) != null) {
            _URLDetailsBySite.put(site, urlDetails);
            HashMap<URLTypeCodeType, URLDetailsType> detailsByURLTypeMap = new HashMap<URLTypeCodeType, URLDetailsType>(urlDetails.length);
            for (int i = 0; i < urlDetails.length; ++i) {
                URLDetailsType detail = urlDetails[i];
                detailsByURLTypeMap.put(detail.getURLType(), detail);
            }
            _URLDetailsMapsBySite.put(site, detailsByURLTypeMap);
        }
    }

    private void loadURLDetailsForSite(SiteCodeType site) throws SdkException, Exception {
        this.loadURLDetailsForSite(null, site);
    }

    private void loadSiteRelatedDetailsForSite(SiteCodeType site) throws SdkException, Exception {
        GeteBayDetailsResponseType resp = this.makeApiCall(this._siteRelatedDetailNames, site);
        this._taxJurisdictionDetails = resp.getTaxJurisdiction();
        this._shippingServiceDetails = resp.getShippingServiceDetails();
        this._regionDetails = resp.getRegionDetails();
        this.loadPaymentOptionsDetailsForSite(resp, site);
        this.loadURLDetailsForSite(resp, site);
        this.loadTaxJurisdictionDetailsForSite(resp, site);
        this.loadShippingServiceDetailsForSite(resp, site);
        this.loadRegionDetailsForSite(resp, site);
    }

    private void loadTaxJurisdictionDetailsForSite(GeteBayDetailsResponseType resp, SiteCodeType site) throws SdkException, Exception {
    }

    private void loadShippingServiceDetailsForSite(GeteBayDetailsResponseType resp, SiteCodeType site) throws SdkException, Exception {
    }

    private void loadRegionDetailsForSite(GeteBayDetailsResponseType resp, SiteCodeType site) throws SdkException, Exception {
    }

    private GeteBayDetailsResponseType makeApiCall(DetailNameCodeType[] detailNames, SiteCodeType site) throws SdkException, Exception {
        SiteCodeType savedSite = this._site;
        if (site != null) {
            this._apiContext.setSite(site);
        }
        GeteBayDetailsCall api = new GeteBayDetailsCall(this._apiContext);
        DetailLevelCodeType[] detailLevels = new DetailLevelCodeType[]{DetailLevelCodeType.RETURN_ALL};
        api.setDetailLevel(detailLevels);
        if (detailNames != null) {
            api.setDetailName(detailNames);
        }
        api.geteBayDetails();
        this._apiContext.setSite(savedSite);
        return api.getReturnedeBayDetails();
    }

    private void loadSiteIndependentDetails() throws SdkException, Exception {
        GeteBayDetailsResponseType resp = this.makeApiCall(this._siteIndependentDetailNames, null);
        this._countryDetails = resp.getCountryDetails();
        this.loadCountryDetails(this._countryDetails);
        this._currencyDetails = resp.getCurrencyDetails();
        this.loadCurrencyDetails(this._currencyDetails);
        this._dispatchTimeMaxDetails = resp.getDispatchTimeMaxDetails();
        this.loadDispatchTimeMaxDetails(this._dispatchTimeMaxDetails);
        this._shippingLocationDetails = resp.getShippingLocationDetails();
        this.loadShippingLocationDetails(this._shippingLocationDetails);
        this._siteDetails = resp.getSiteDetails();
        this.loadSiteDetails(this._siteDetails);
        this._timeZoneDetails = resp.getTimeZoneDetails();
        this.loadTimeZoneDetails(this._timeZoneDetails);
    }

    public CountryDetailsType getTimeZoneDetailsByZone(String zoneId) {
        return (CountryDetailsType)_TimeZoneDetails.get(zoneId);
    }

    public TimeZoneDetailsType[] getTimeZoneDetails() {
        return this._timeZoneDetails;
    }

    private void loadTimeZoneDetails(TimeZoneDetailsType[] details) {
        if (_TimeZoneDetails.isEmpty()) {
            for (int i = 0; i < details.length; ++i) {
                TimeZoneDetailsType detail = details[i];
                _TimeZoneDetails.put(detail.getTimeZoneID(), detail);
            }
        }
    }

    public ShippingLocationDetailsType loadShippingLocationDetailsByShippingLocation(String shippingLocation) {
        return (ShippingLocationDetailsType)_ShippingLocationDetailsByShippingLocation.get(shippingLocation);
    }

    public ShippingLocationDetailsType[] getShippingLocationDetails() {
        return this._shippingLocationDetails;
    }

    private void loadShippingLocationDetails(ShippingLocationDetailsType[] details) {
        if (_ShippingLocationDetailsByShippingLocation.isEmpty()) {
            for (int i = 0; i < details.length; ++i) {
                ShippingLocationDetailsType detail = details[i];
                _ShippingLocationDetailsByShippingLocation.put(detail.getShippingLocation(), detail);
            }
        }
    }

    public SiteDetailsType getSiteDetailsBySite(SiteCodeType site) {
        return (SiteDetailsType)_SiteDetailsBySite.get(site);
    }

    public SiteDetailsType[] getSiteDetails() {
        return this._siteDetails;
    }

    private void loadSiteDetails(SiteDetailsType[] details) {
        if (_SiteDetailsBySite.isEmpty()) {
            for (int i = 0; i < details.length; ++i) {
                SiteDetailsType site = details[i];
                _SiteDetailsBySite.put(site.getSite(), site);
            }
        }
    }

    public DispatchTimeMaxDetailsType getDispatchTimeMaxDetailsByDispatchTimeMax(Integer dispatchTimeMax) {
        return (DispatchTimeMaxDetailsType)_DispatchTimeMaxDetailsByDispatchTimeMax.get(dispatchTimeMax);
    }

    public DispatchTimeMaxDetailsType[] getDispatchTimeMaxDetails() {
        return this._dispatchTimeMaxDetails;
    }

    private void loadDispatchTimeMaxDetails(DispatchTimeMaxDetailsType[] details) {
        if (_DispatchTimeMaxDetailsByDispatchTimeMax.isEmpty()) {
            for (int i = 0; i < details.length; ++i) {
                DispatchTimeMaxDetailsType dispatch = details[i];
                _DispatchTimeMaxDetailsByDispatchTimeMax.put(dispatch.getDispatchTimeMax(), dispatch);
            }
        }
    }

    public CurrencyDetailsType getCurrencyDetailsByCurrencyCode(CurrencyCodeType currencyCode) {
        return (CurrencyDetailsType)_CurrencyDetailsByCurrency.get(currencyCode);
    }

    public CurrencyDetailsType[] getCurrencyDetails() {
        return this._currencyDetails;
    }

    private void loadCurrencyDetails(CurrencyDetailsType[] details) {
        if (_CurrencyDetailsByCurrency.isEmpty()) {
            for (int i = 0; i < details.length; ++i) {
                CurrencyDetailsType currency = details[i];
                _CurrencyDetailsByCurrency.put(currency.getCurrency(), currency);
            }
        }
    }

    public CountryDetailsType getCountryDetailsByCountryCode(CountryCodeType countryCode) {
        return (CountryDetailsType)_CountryDetailsByCountry.get(countryCode);
    }

    public CountryDetailsType[] getCountryDetails() {
        return this._countryDetails;
    }

    private void loadCountryDetails(CountryDetailsType[] details) {
        if (_CountryDetailsByCountry.isEmpty()) {
            for (int i = 0; i < details.length; ++i) {
                CountryDetailsType detail = details[i];
                _CountryDetailsByCountry.put(detail.getCountry(), detail);
            }
        }
    }

    private void initializeHashMaps() {
        _SiteRelatedDetailsByName.put(DetailNameCodeType.PAYMENT_OPTION_DETAILS, _PaymentOptionDetailsBySite);
        _SiteRelatedDetailsMapsByName.put(DetailNameCodeType.PAYMENT_OPTION_DETAILS, _PaymentOptionDetailsMapsBySite);
        _SiteRelatedDetailsByName.put(DetailNameCodeType.REGION_DETAILS, _RegionDetailsBySite);
        _SiteRelatedDetailsMapsByName.put(DetailNameCodeType.REGION_DETAILS, _RegionDetailsMapsBySite);
        _SiteRelatedDetailsByName.put(DetailNameCodeType.SHIPPING_SERVICE_DETAILS, _ShippingServiceDetailsBySite);
        _SiteRelatedDetailsMapsByName.put(DetailNameCodeType.SHIPPING_SERVICE_DETAILS, _ShippingServiceDetailsMapsBySite);
        _SiteRelatedDetailsByName.put(DetailNameCodeType.TAX_JURISDICTION, _TaxJurisdictionDetailsBySite);
        _SiteRelatedDetailsMapsByName.put(DetailNameCodeType.TAX_JURISDICTION, _TaxJurisdictionDetailsMapsBySite);
        _SiteRelatedDetailsByName.put(DetailNameCodeType.URL_DETAILS, _URLDetailsBySite);
        _SiteRelatedDetailsMapsByName.put(DetailNameCodeType.URL_DETAILS, _URLDetailsMapsBySite);
    }

    static {
        _SiteRelatedDetailsByName = new HashMap(5);
        _SiteRelatedDetailsMapsByName = new HashMap(5);
        _CountryDetailsByCountry = new HashMap();
        _CurrencyDetailsByCurrency = new HashMap();
        _DispatchTimeMaxDetailsByDispatchTimeMax = new HashMap();
        _ShippingLocationDetailsByShippingLocation = new HashMap();
        _SiteDetailsBySite = new HashMap();
        _TimeZoneDetails = new HashMap();
        _PaymentOptionDetailsMapsBySite = new HashMap();
        _PaymentOptionDetailsBySite = new HashMap();
        _RegionDetailsMapsBySite = new HashMap();
        _RegionDetailsBySite = new HashMap();
        _ShippingServiceDetailsMapsBySite = new HashMap();
        _ShippingServiceDetailsBySite = new HashMap();
        _TaxJurisdictionDetailsMapsBySite = new HashMap();
        _TaxJurisdictionDetailsBySite = new HashMap();
        _URLDetailsMapsBySite = new HashMap();
        _URLDetailsBySite = new HashMap();
    }
}

