/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.helper.ui;

import com.ebay.sdk.helper.ui.JIDCheckBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class ControlBuilder {
    static ControlBuilder _builder = new ControlBuilder();
    private static String CHECKBOX_SPACE = "      ";

    public static ControlBuilder getInstance() {
        return _builder;
    }

    private ControlBuilder() {
    }

    public JCheckBox[] buildCheckBoxControls(JPanel panel, ArrayList list, int colSize) {
        int size;
        JCheckBox[] arrCheckBox = null;
        int n = size = list != null ? list.size() : 0;
        if (size > 0) {
            arrCheckBox = new JCheckBox[size];
            for (int i = 0; i < size; ++i) {
                JCheckBox chkBox = new JCheckBox();
                chkBox.setText(list.get(i).toString() + CHECKBOX_SPACE);
                arrCheckBox[i] = chkBox;
                int row = i / colSize;
                int col = i % colSize;
                panel.add((Component)chkBox, new GridBagConstraints(col, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            }
        }
        return arrCheckBox;
    }

    public JCheckBox[] buildIDCheckBoxControls(JPanel panel, Hashtable map, int colSize) {
        JCheckBox[] arrCheckBox = null;
        int size = map.size();
        if (size > 0) {
            arrCheckBox = new JCheckBox[size];
            Enumeration keys = map.keys();
            int cnt = 0;
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                JIDCheckBox chkBox = new JIDCheckBox(key.toString(), map.get(key).toString() + CHECKBOX_SPACE);
                arrCheckBox[cnt] = chkBox;
                int row = cnt / colSize;
                int col = cnt % colSize;
                panel.add((Component)chkBox, new GridBagConstraints(col, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                ++cnt;
            }
        }
        return arrCheckBox;
    }
}

