/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.helper.ui;

import com.ebay.sdk.ApiAccount;
import com.ebay.sdk.ApiContext;
import com.ebay.sdk.ApiCredential;
import com.ebay.sdk.SdkException;
import com.ebay.sdk.TimeFilter;
import com.ebay.sdk.util.eBayUtil;
import com.ebay.soap.eBLBaseComponents.AmountType;
import com.ebay.soap.eBLBaseComponents.CurrencyCodeType;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.text.JTextComponent;

public class GuiUtil {
    public static void CenterComponent(Component frame) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public static void JListClearData(JList list) {
        list.setListData(new Object[0]);
    }

    public static void JListAddObject(JList list, Object item) {
        ListModel lm = list.getModel();
        Object[] newList = new Object[lm.getSize() + 1];
        for (int i = 0; i < lm.getSize(); ++i) {
            newList[i] = lm.getElementAt(i);
        }
        newList[lm.getSize()] = item;
        list.setListData(newList);
    }

    public static void JListRemoveSelectedObject(JList list) {
        Object sel = list.getSelectedValue();
        if (sel != null) {
            ListModel lm = list.getModel();
            Object[] newList = new Object[lm.getSize() - 1];
            int cur = 0;
            for (int i = 0; i < lm.getSize(); ++i) {
                if (lm.getElementAt(i) == sel) continue;
                newList[cur++] = lm.getElementAt(i);
            }
            list.setListData(newList);
        }
    }

    public static AmountType getMoneyField(JTextField tf) {
        Double dbl = new Double(tf.getText());
        AmountType at = new AmountType();
        at.setValue(dbl.doubleValue());
        at.setCurrencyID(CurrencyCodeType.USD);
        return at;
    }

    public static Calendar getCalendarFromField(JTextField txtField) throws ParseException {
        Calendar cal = null;
        if (txtField.getText().length() > 0) {
            Date dt = eBayUtil.fromAPITimeString((String)txtField.getText());
            cal = Calendar.getInstance();
            cal.setTime(dt);
        }
        return cal;
    }

    public static TimeFilter getTimeFilterFromFields(JTextField txtFrom, JTextField txtTo) throws ParseException {
        TimeFilter tf = null;
        if (txtFrom.getText().length() > 0 && txtTo.getText().length() > 0) {
            Calendar calFrom = GuiUtil.getCalendarFromField(txtFrom);
            Calendar calTo = GuiUtil.getCalendarFromField(txtTo);
            tf = new TimeFilter(calFrom, calTo);
        }
        return tf;
    }

    public static void setTimeFilterFields(int backDays, JTextField txtFrom, JTextField txtTo) {
        Calendar calTo = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        Date to = calTo.getTime();
        Calendar calFrom = (Calendar)calTo.clone();
        calFrom.add(5, -backDays);
        Date from = calFrom.getTime();
        String fromStr = eBayUtil.toAPITimeString((Date)from);
        String toStr = eBayUtil.toAPITimeString((Date)to);
        txtFrom.setText(fromStr);
        txtTo.setText(toStr);
    }

    public static boolean IsTextFieldEmpty(JTextField tf) {
        return tf.getText().length() == 0;
    }

    public static boolean AreAllTextFieldsFilled(JTextField[] tfs) {
        for (int i = 0; i < tfs.length; ++i) {
            if (!GuiUtil.IsTextFieldEmpty(tfs[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isFilledString(String s) {
        return s != null && s.length() > 0;
    }

    public static boolean isApiAccountFilled(ApiAccount ac) {
        String dev = ac.getDeveloper();
        String app = ac.getApplication();
        String cert = ac.getCertificate();
        return dev != null && dev.length() > 0 && app != null && app.length() > 0 && cert != null && cert.length() > 0;
    }

    public static boolean isApiContextFilled(ApiContext ctx, boolean checkEBayAccount) {
        ApiCredential ac = ctx.getApiCredential();
        if (ac == null) {
            return false;
        }
        if (!GuiUtil.isFilledString(ctx.getApiServerUrl())) {
            return false;
        }
        boolean hasToken = GuiUtil.isFilledString(ac.geteBayToken());
        if (!hasToken && !GuiUtil.isApiAccountFilled(ac.getApiAccount())) {
            return false;
        }
        if (checkEBayAccount) {
            return hasToken;
        }
        return true;
    }

    public static boolean isTextControlFilled(JTextComponent tc, String errorMessage) throws SdkException {
        boolean b;
        boolean bl = b = tc.getText().length() > 0;
        if (errorMessage != null && !b) {
            throw new SdkException(errorMessage);
        }
        return b;
    }
}

