/*
 * Decompiled with CFR 0.152.
 */
package pnp.stamps.api;

import StampsSDK.AccountInfo;
import StampsSDK.Address;
import StampsSDK.ArrayOfGuid;
import StampsSDK.ArrayOfRateV11;
import StampsSDK.Credentials;
import StampsSDK.ImageType;
import StampsSDK.MachineInfo;
import StampsSDK.PostageBalance;
import StampsSDK.PurchaseStatus;
import StampsSDK.RateV11;
import StampsSDK.SwsimV29;
import StampsSDK.SwsimV29Soap;
import java.math.BigDecimal;
import java.net.URL;
import javax.swing.JOptionPane;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.ws.Holder;
import pnp.services.datatypes.PreparedIndicium;
import pnp.services.util.ErrorsUtil;

public class StampsConnectionManager {
    private final String integrationID = "5795991c-a42f-4038-85c9-ca5dbc635b50";
    private final String wsdlTest = "https://swsim.testing.stamps.com/swsim/swsimv29.asmx?wsdl";
    private final String wsdlLive = "https://swsim.stamps.com/swsim/swsimv29.asmx?wsdl";
    private final SwsimV29 service;
    private final SwsimV29Soap call;
    private final boolean isLive;
    private static StampsConnectionManager _instance;
    private Holder<String> authenticator = new Holder();
    private String USERNAME;
    private String PASSWORD;
    private BigDecimal controlTotal = BigDecimal.ZERO;
    private String authenticationError;
    private String actualError;

    public boolean isIsLive() {
        return this.isLive;
    }

    public String getAuthenticationError() {
        return this.authenticationError;
    }

    public String getActualError() {
        return this.actualError;
    }

    public StampsConnectionManager() {
        this.isLive = true;
        URL wsdlLocation = null;
        try {
            wsdlLocation = this.isLive ? new URL("https://swsim.stamps.com/swsim/swsimv29.asmx?wsdl") : new URL("https://swsim.testing.stamps.com/swsim/swsimv29.asmx?wsdl");
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex, false);
        }
        if (wsdlLocation == null) {
            this.service = null;
            JOptionPane.showMessageDialog(null, "Please reload Gamut or contact support.");
        } else {
            this.service = new SwsimV29(wsdlLocation);
        }
        this.call = this.service.getSwsimV29Soap();
        this.USERNAME = "";
        this.PASSWORD = "";
        this.authenticationError = "Authentication Failed.";
        this.actualError = "Error";
    }

    public synchronized String authenticateUser(String userName, String password) {
        this.USERNAME = userName;
        this.PASSWORD = password;
        Credentials credentials = new Credentials();
        Holder lastLoginTime = new Holder();
        Holder clearCredential = new Holder();
        Holder loginBannerText = new Holder();
        Holder passwordExpired = new Holder();
        credentials.setIntegrationID("5795991c-a42f-4038-85c9-ca5dbc635b50");
        credentials.setUsername(userName);
        credentials.setPassword(password);
        try {
            this.call.authenticateUser(credentials, this.authenticator, lastLoginTime, clearCredential, loginBannerText, passwordExpired);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex, false);
            this.authenticationError = ex.getMessage();
            return null;
        }
        return (String)this.authenticator.value;
    }

    public synchronized AccountInfo getAccountInfo(boolean retry) {
        Holder accountInfo = new Holder();
        Holder address = new Holder();
        Holder customerEmail = new Holder();
        try {
            this.call.getAccountInfo(this.authenticator, null, accountInfo, address, customerEmail);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex, false);
            this.authenticateUser(this.USERNAME, this.PASSWORD);
            if (ex.getMessage().equalsIgnoreCase("Invalid conversation token.") && !retry) {
                return this.getAccountInfo(true);
            }
            this.actualError = ex.getMessage();
            return null;
        }
        this.controlTotal = ((AccountInfo)accountInfo.value).getPostageBalance().getControlTotal();
        return (AccountInfo)accountInfo.value;
    }

    public synchronized int purchasePostage(Float purchased, boolean retry) {
        BigDecimal purchaseAmount = new BigDecimal(purchased.floatValue());
        String integratorTxID = null;
        MachineInfo mi = null;
        Holder purchaseStatus = new Holder();
        Holder transactionID = new Holder();
        Holder postageBalance = new Holder();
        Holder rejectionReason = new Holder();
        Holder miRequired = new Holder();
        try {
            this.call.purchasePostage(null, this.authenticator, purchaseAmount, this.controlTotal, mi, integratorTxID, purchaseStatus, transactionID, postageBalance, rejectionReason, miRequired);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex, false);
            this.authenticateUser(this.USERNAME, this.PASSWORD);
            if (ex.getMessage().equalsIgnoreCase("Invalid conversation token.") && !retry) {
                return this.purchasePostage(purchased, true);
            }
            this.actualError = ex.getMessage();
            return -1;
        }
        this.controlTotal = ((PostageBalance)postageBalance.value).getControlTotal();
        return (Integer)transactionID.value;
    }

    public synchronized PurchaseStatus getPurchaseStatus(int transactionID, boolean retry) {
        Holder purchaseStatus = new Holder();
        Holder postageBalance = new Holder();
        Holder rejectionReason = new Holder();
        Holder miRequired = new Holder();
        try {
            this.call.getPurchaseStatus(null, this.authenticator, transactionID, purchaseStatus, postageBalance, rejectionReason, miRequired);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex, false);
            this.authenticateUser(this.USERNAME, this.PASSWORD);
            if (ex.getMessage().equalsIgnoreCase("Invalid conversation token.") && !retry) {
                return this.getPurchaseStatus(transactionID, true);
            }
            this.actualError = ex.getMessage();
            return null;
        }
        return (PurchaseStatus)purchaseStatus.value;
    }

    public Holder<Address> createHolderAddress(Address address) {
        Holder copyAddress = new Holder();
        copyAddress.value = new Address();
        if (address.getAddress1() == null) {
            address.setAddress1("");
        }
        if (address.getAddress2() == null) {
            address.setAddress2("");
        }
        if (address.getAddress3() == null) {
            address.setAddress3("");
        }
        if (address.getAddress1().length() > 50 || address.getAddress2().length() > 50 || address.getAddress3().length() > 50) {
            String allAdd = "";
            if ((allAdd = allAdd + address.getAddress1() + address.getAddress2() + address.getAddress3()).length() > 150) {
                allAdd = allAdd.substring(0, 149);
            }
            int divider = allAdd.length() / 3;
            address.setAddress1(allAdd.substring(divider * 0, divider * 1));
            address.setAddress2(allAdd.substring(divider * 1, divider * 2));
            address.setAddress3(allAdd.substring(divider * 2, divider * 3));
        }
        ((Address)copyAddress.value).setAddress1(address.getAddress1());
        ((Address)copyAddress.value).setAddress2(address.getAddress2());
        ((Address)copyAddress.value).setAddress3(address.getAddress3());
        ((Address)copyAddress.value).setCheckDigit(address.getCheckDigit());
        ((Address)copyAddress.value).setCity(address.getCity());
        ((Address)copyAddress.value).setCleanseHash(address.getCleanseHash());
        ((Address)copyAddress.value).setCompany(address.getCompany());
        ((Address)copyAddress.value).setCountry(address.getCountry());
        ((Address)copyAddress.value).setDPB(address.getDPB());
        ((Address)copyAddress.value).setDepartment(address.getDepartment());
        ((Address)copyAddress.value).setExtension(address.getExtension());
        ((Address)copyAddress.value).setFirstName(address.getFirstName());
        ((Address)copyAddress.value).setFullName(address.getFullName());
        ((Address)copyAddress.value).setLastName(address.getLastName());
        ((Address)copyAddress.value).setMiddleName(address.getMiddleName());
        ((Address)copyAddress.value).setNamePrefix(address.getNamePrefix());
        ((Address)copyAddress.value).setNameSuffix(address.getNameSuffix());
        ((Address)copyAddress.value).setOverrideHash(address.getOverrideHash());
        ((Address)copyAddress.value).setPhoneNumber(address.getPhoneNumber());
        ((Address)copyAddress.value).setPostalCode(address.getPostalCode());
        ((Address)copyAddress.value).setProvince(address.getProvince());
        ((Address)copyAddress.value).setState(address.getState());
        ((Address)copyAddress.value).setTitle(address.getTitle());
        ((Address)copyAddress.value).setUrbanization(address.getUrbanization());
        ((Address)copyAddress.value).setZIPCode(address.getZIPCode());
        ((Address)copyAddress.value).setZIPCodeAddOn(address.getZIPCodeAddOn());
        return copyAddress;
    }

    public synchronized Address cleanseAddress(Address address, boolean retry) {
        Holder<Address> heldAddress = this.createHolderAddress(address);
        Holder addressMatch = new Holder();
        Holder cityStateZipOK = new Holder();
        Holder residentialDeliveryIndicator = new Holder();
        Holder isPOBox = new Holder();
        Holder candidateAddresses = new Holder();
        Holder statusCodes = new Holder();
        try {
            this.call.cleanseAddress(this.authenticator, null, heldAddress, addressMatch, cityStateZipOK, residentialDeliveryIndicator, isPOBox, candidateAddresses, statusCodes);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex, false);
            this.authenticateUser(this.USERNAME, this.PASSWORD);
            if (ex.getMessage().equalsIgnoreCase("Invalid conversation token.") && !retry) {
                return this.cleanseAddress(address, true);
            }
            this.actualError = ex.getMessage();
            return null;
        }
        return (Address)heldAddress.value;
    }

    public synchronized ArrayOfRateV11 getRates(RateV11 rate, boolean retry) {
        Holder rates = new Holder();
        try {
            this.call.getRates(null, this.authenticator, rate, rates);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex, false);
            this.authenticateUser(this.USERNAME, this.PASSWORD);
            if (ex.getMessage().equalsIgnoreCase("Invalid conversation token.") && !retry) {
                return this.getRates(rate, true);
            }
            this.actualError = ex.getMessage();
            return null;
        }
        return (ArrayOfRateV11)rates.value;
    }

    public synchronized boolean cancelIndicium(String stampsTxID, boolean retry) {
        try {
            this.call.cancelIndicium(this.authenticator, null, stampsTxID, null);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex, false);
            this.authenticateUser(this.USERNAME, this.PASSWORD);
            if (ex.getMessage().equalsIgnoreCase("Invalid conversation token.") && !retry) {
                return this.cancelIndicium(stampsTxID, true);
            }
            this.actualError = ex.getMessage();
            return false;
        }
        return true;
    }

    public synchronized Holder<String> createIndicium(PreparedIndicium indicium, boolean retry) {
        try {
            this.call.createIndicium(null, this.authenticator, indicium.getIntegratorTxID(), indicium.getTrackingNumber(), indicium.getRate(), indicium.getFrom(), indicium.getTo(), indicium.getCustomerID(), indicium.getCustoms(), indicium.getSampleOnly(), indicium.getImageType(), indicium.getEltronPrinterDPIType(), indicium.getMemo(), indicium.getCostCodeId(), indicium.getRecipientEmail(), indicium.getDeliveryNotification(), indicium.getShipmentNotificationCC(), indicium.getShipmentNotificationCCToMain(), indicium.getShipmentNotificationFromCompany(), indicium.getShipmentNotificationCompanyInSubject(), indicium.getRotationDegrees(), indicium.getHorizontalOffset(), indicium.getVerticalOffset(), indicium.getPrintDensity(), indicium.getPrintMemo(), indicium.getPrintInstructions(), indicium.getRequestPostageHash(), indicium.getNonDeliveryOption(), indicium.getRedirectTo(), indicium.getOriginalPostageHash(), indicium.getReturnImageData(), indicium.getStampsTxID(), indicium.getUrl(), indicium.getPostageBalance(), indicium.getMac(), indicium.getPostageHash(), indicium.getImageData());
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex, false);
            this.authenticateUser(this.USERNAME, this.PASSWORD);
            if (ex.getMessage().equalsIgnoreCase("Invalid conversation token.") && !retry) {
                return this.createIndicium(indicium, true);
            }
            this.actualError = ex.getMessage();
            return null;
        }
        this.controlTotal = ((PostageBalance)indicium.getPostageBalance().value).getControlTotal();
        return indicium.getStampsTxID();
    }

    public synchronized String createScanForm(Address fromAddress, ArrayOfGuid stampsTxIDs, XMLGregorianCalendar shipDate, boolean printInstructions, boolean retry) {
        Holder scanFormId = new Holder();
        Holder url = new Holder();
        try {
            this.call.createScanForm(this.authenticator, null, stampsTxIDs, fromAddress, ImageType.AUTO, printInstructions, shipDate, scanFormId, url);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex, false);
            this.authenticateUser(this.USERNAME, this.PASSWORD);
            if (ex.getMessage().equalsIgnoreCase("Invalid conversation token.") && !retry) {
                return this.createScanForm(fromAddress, stampsTxIDs, shipDate, printInstructions, true);
            }
            this.actualError = ex.getMessage();
            return null;
        }
        return (String)url.value;
    }

    public static StampsConnectionManager getInstance() {
        if (null == _instance) {
            _instance = new StampsConnectionManager();
        }
        return _instance;
    }
}

