/*
 * Decompiled with CFR 0.152.
 */
package pnp.managers.financials;

import com.toedter.calendar.JDateChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import pnp.services.authenticationmanager.SubscriptionManager;
import pnp.services.compare.CompleteOrderComparator;
import pnp.services.compare.ExpenseComparator;
import pnp.services.constants.FrameConstants;
import pnp.services.datatypes.CompleteOrder;
import pnp.services.datatypes.Expense;
import pnp.services.datatypes.ExpenseReason;
import pnp.services.datatypes.InventoryElement;
import pnp.services.datatypes.OrderDetails;
import pnp.services.datatypes.SalesTax;
import pnp.services.listener.CompletedOrderListListener;
import pnp.services.listener.ExpensesListener;
import pnp.services.listener.GenericListener;
import pnp.services.listener.LoginListener;
import pnp.services.listenermanager.ListenerManager;
import pnp.services.preferencemanager.Preferences;
import pnp.services.util.ErrorsUtil;
import pnp.services.util.FeeProcessor;
import pnp.services.util.LookupServicesUtil;
import pnp.services.util.MathParser;
import pnp.services.util.SalesTaxRates;

@TopComponent.Description(preferredID="FinancialSnapshotTopComponent", persistenceType=1)
public final class FinancialSnapshotTopComponent
extends TopComponent
implements CompletedOrderListListener,
ExpensesListener,
LoginListener {
    private static FinancialSnapshotTopComponent instance;
    private long savedFrom;
    private long savedTo;
    private long savedSnapshot;
    private boolean companySelectionActive;
    private JButton DeleteButton;
    private JComboBox StateComboBox;
    private JButton TaxAcceptButton;
    private JTextField TaxField;
    private JButton addExpenseButton;
    private JButton addExpenseFilterButton;
    private JButton applyExpenseButton;
    private JButton applySalesButton;
    private JList availableExpenseFilterList;
    private JButton clearExpenseButton;
    private JButton clearSalesButton;
    private JLabel cogsLabel;
    private JTextField commentsTextField;
    private JComboBox companySelection;
    private JList currentExpenseFilterList;
    private JButton customizeExpenses;
    private JPanel dateRangePanel;
    private JButton deleteExpenseButton;
    private JButton detailedBreakdownRefreshButton;
    private JPanel detailedBreakdownTab;
    private JTable detailedBreakdownTable;
    private JLabel detailedDateRangeLabel;
    private JButton detailedReportButton;
    private JTextField expenseAmountTextField;
    private JComboBox expenseCompanyBox;
    private JDateChooser expenseDateChooser;
    private JLabel expenseLabel;
    private JComboBox expenseReasonComboBox;
    private JButton expenseSearchButton;
    private JTextField expenseSearchField;
    private JTable expenseTable;
    private JPanel financialSnapshotTab;
    private JDateChooser fromDateChooser;
    private JLabel grossSalesLabel;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane6;
    private JScrollPane jScrollPane7;
    private JScrollPane jScrollPane8;
    private JScrollPane jScrollPane9;
    private JTabbedPane jTabbedPane1;
    private JLabel marginLabel;
    private JLabel netOperatingProfitLabel;
    private JLabel netProfitLabel;
    private JLabel rangeLabel;
    private JButton refreshButton;
    private JButton removeExpenseFilterButton;
    private JTable salesTable;
    private JLabel salesTaxLabel;
    private JDateChooser snapshotDateChooser;
    private JTable snapshotHistoryTable;
    private JComboBox snapshotRangeComboBox;
    private JButton snapshotRefreshButton;
    private JTable taxTable;
    private JDateChooser toDateChooser;
    private JTable trendingTable;
    private int salesDateColumn = 0;
    private int salesItemIDColumn = 1;
    private int salesCustomerIDColumn = 2;
    private int salesStateColumn = 3;
    private int salesSalesPriceColumn = 4;
    private int salesWholesaleCostColumn = 5;
    private int salesSHPaidColumn = 6;
    private int salesSHCostColumn = 7;
    private int salesPayPalFeeColumn = 8;
    private int salesNetProfitColumn = 9;
    private int expenseCompanyColumn = 0;
    private int expenseDateColumn = 1;
    private int expenseAmountColumn = 2;
    private int expenseReasonColumn = 3;
    private int expenseCommentsColumn = 4;
    private int snapshotRangeColumn = 0;
    private int snapshotGrossSalesColumn = 1;
    private int snapshotExpensesColumn = 2;
    private int snapshotNetProfitColumn = 3;
    private int snapshotMarginColumn = 4;
    private int trendingItemIDColumn = 0;
    private int trendingQuantityColumn = 1;
    private int detailedAccountNameColumn = 0;
    private int detailedSiteIDColumn = 1;
    private int detailedGrossSalesColumn = 2;
    private int detailedCogsColumn = 3;
    private int detailedProfitColumn = 4;
    private boolean updatePending;
    private ArrayList<Integer> _salesOrderMapping;
    private ArrayList<Integer> _expenseMapping;
    private ArrayList<SalesTax> _taxList;
    private ArrayList<String> _stateNames;
    private HashMap<Integer, CompleteOrder> _completeOrders;
    private HashMap<Integer, Expense> _expenses;
    private HashMap<String, TrendObject> _trendMap;
    private HashMap<Integer, Integer> _updatedSalesOrders;
    private HashMap<Integer, Integer> _updatedExpenses;
    private HashMap<Integer, ExpenseReason> _expenseReasons;
    private HashMap<String, ExpenseReason> _expenseReasonsList;
    private ArrayList<Integer> _filteredList;
    private ArrayList<Taxes> _TaxesContainer;
    private double grossSales = 0.0;
    private double netProfit = 0.0;
    private double cogs = 0.0;
    private double salesTax = 0.0;
    private double expenses = 0.0;
    private SalesTableListener salesTableListener;
    private ExpenseTableListener expenseTableListener;
    private boolean disableListener = false;
    private boolean currentStatus = true;

    public FinancialSnapshotTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"CTL_FinancialSnapshotTopComponent"));
        this.setToolTipText(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"HINT_FinancialSnapshotTopComponent"));
        this.LoginToggle();
        this.init();
    }

    protected void componentShowing() {
        super.componentShowing();
        this.LoginToggle();
        if (SubscriptionManager.getInstance().isFinancialsActive()) {
            ListenerManager.getInstance().subscribe((GenericListener)this);
            this.completedOrderListUpdated();
            this.expenseListUpdated();
        }
    }

    protected void componentHidden() {
        super.componentHidden();
        if (SubscriptionManager.getInstance().isFinancialsActive()) {
            ListenerManager.getInstance().unsubscribe((GenericListener)this);
        }
    }

    private void instantiateVariables() {
        if (!SubscriptionManager.getInstance().getUserName().equals("admin")) {
            this.jTabbedPane1.remove(1);
        }
        this._salesOrderMapping = new ArrayList();
        this._expenseMapping = new ArrayList();
        this._completeOrders = new HashMap();
        this._expenses = new HashMap();
        this._trendMap = new HashMap();
        this._updatedSalesOrders = new HashMap();
        this._updatedExpenses = new HashMap();
        this._expenseReasons = new HashMap();
        this._expenseReasonsList = new HashMap();
        this._filteredList = new ArrayList();
        this._taxList = new ArrayList();
        this._TaxesContainer = new ArrayList();
        this._stateNames = new ArrayList();
        this.fromDateChooser.setDateFormatString("MM/dd/yy");
        this.snapshotDateChooser.setDateFormatString("MM/dd/yy");
        this.toDateChooser.setDateFormatString("MM/dd/yy");
        this.expenseDateChooser.setDateFormatString("MM/dd/yy");
        this.expenseDateChooser.getDateEditor().getUiComponent().addFocusListener(new DateFocusListener());
        Object[] reasons = LookupServicesUtil.getDBServices().getExpenseReasons();
        Arrays.sort(reasons);
        ((DefaultListModel)this.availableExpenseFilterList.getModel()).addElement("All");
        for (int i = 0; i < reasons.length; ++i) {
            this._expenseReasons.put(reasons[i].getExpenseReasonID(), (ExpenseReason)reasons[i]);
            this._expenseReasonsList.put(reasons[i].getReason(), (ExpenseReason)reasons[i]);
            this.expenseReasonComboBox.addItem(reasons[i].getReason());
            ((DefaultListModel)this.availableExpenseFilterList.getModel()).addElement(reasons[i].getReason());
        }
        ((DefaultListModel)this.availableExpenseFilterList.getModel()).addElement("Other");
        ExpenseReason Other = new ExpenseReason();
        Other.setReason("Other");
        Other.setExpenseReasonID(0);
        this._expenseReasons.put(Other.getExpenseReasonID(), Other);
        this._expenseReasonsList.put(Other.getReason(), Other);
        this.expenseReasonComboBox.addItem(Other.getReason());
        this.expenseReasonComboBox.setSelectedItem(Other.getReason());
    }

    private void createTables() {
        this.salesTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.salesDateColumn = this.salesTable.getColumnModel().getColumnIndex("Date");
        this.salesItemIDColumn = this.salesTable.getColumnModel().getColumnIndex("Item ID");
        this.salesCustomerIDColumn = this.salesTable.getColumnModel().getColumnIndex("Customer ID");
        this.salesStateColumn = this.salesTable.getColumnModel().getColumnIndex("State");
        this.salesSalesPriceColumn = this.salesTable.getColumnModel().getColumnIndex("Sales Price");
        this.salesWholesaleCostColumn = this.salesTable.getColumnModel().getColumnIndex("Wholesale Cost");
        this.salesSHPaidColumn = this.salesTable.getColumnModel().getColumnIndex("S/H Paid");
        this.salesSHCostColumn = this.salesTable.getColumnModel().getColumnIndex("S/H Cost");
        this.salesPayPalFeeColumn = this.salesTable.getColumnModel().getColumnIndex("PayPal Fee");
        this.salesNetProfitColumn = this.salesTable.getColumnModel().getColumnIndex("Net Profit");
        TableColumn col = this.salesTable.getColumnModel().getColumn(this.salesSalesPriceColumn);
        col.setCellEditor(new OrderDetailsTableCellEditor());
        col = this.salesTable.getColumnModel().getColumn(this.salesWholesaleCostColumn);
        col.setCellEditor(new OrderDetailsTableCellEditor());
        col = this.salesTable.getColumnModel().getColumn(this.salesSHPaidColumn);
        col.setCellEditor(new OrderDetailsTableCellEditor());
        col = this.salesTable.getColumnModel().getColumn(this.salesSHCostColumn);
        col.setCellEditor(new OrderDetailsTableCellEditor());
        col = this.salesTable.getColumnModel().getColumn(this.salesNetProfitColumn);
        col.setCellEditor(new OrderDetailsTableCellEditor());
        col = this.salesTable.getColumnModel().getColumn(this.salesPayPalFeeColumn);
        col.setCellEditor(new OrderDetailsTableCellEditor());
        this.expenseTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.expenseCompanyColumn = this.expenseTable.getColumnModel().getColumnIndex("Company Name");
        this.expenseDateColumn = this.expenseTable.getColumnModel().getColumnIndex("Date");
        this.expenseAmountColumn = this.expenseTable.getColumnModel().getColumnIndex("Amount");
        this.expenseReasonColumn = this.expenseTable.getColumnModel().getColumnIndex("Type");
        this.expenseCommentsColumn = this.expenseTable.getColumnModel().getColumnIndex("Comments");
        col = this.expenseTable.getColumnModel().getColumn(this.expenseAmountColumn);
        col.setCellEditor(new OrderDetailsTableCellEditor());
        this.snapshotHistoryTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.snapshotRangeColumn = this.snapshotHistoryTable.getColumnModel().getColumnIndex("Range");
        this.snapshotGrossSalesColumn = this.snapshotHistoryTable.getColumnModel().getColumnIndex("Gross Sales");
        this.snapshotExpensesColumn = this.snapshotHistoryTable.getColumnModel().getColumnIndex("Expenses");
        this.snapshotNetProfitColumn = this.snapshotHistoryTable.getColumnModel().getColumnIndex("Net Profit");
        this.snapshotMarginColumn = this.snapshotHistoryTable.getColumnModel().getColumnIndex("Margin");
        this.trendingTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.trendingItemIDColumn = this.trendingTable.getColumnModel().getColumnIndex("Item ID");
        this.trendingQuantityColumn = this.trendingTable.getColumnModel().getColumnIndex("Quantity Sold");
        for (int i = 0; i < this.salesTable.getColumnCount(); ++i) {
            this.salesTable.setDefaultRenderer(this.salesTable.getColumnClass(i), new CellColorRenderer());
        }
        this.salesTableListener = new SalesTableListener();
        this.expenseTableListener = new ExpenseTableListener();
        this.salesTable.getModel().addTableModelListener(this.salesTableListener);
        this.expenseTable.getModel().addTableModelListener(this.expenseTableListener);
        col = this.expenseTable.getColumnModel().getColumn(this.expenseReasonColumn);
        col.setCellEditor(new ExpensesComboBoxEditor(this._expenseReasonsList.keySet().toArray(new String[0])));
        col.setCellRenderer(new ExpensesComboBoxRenderer(this._expenseReasonsList.keySet().toArray(new String[0])));
        this.recreateComboBox();
    }

    private void doWork() {
        this.populateDates();
        this.populateSalesTax();
        this.updateSalesTax();
        this.updateExpenseTable();
        this.updateSalesTable();
        ListenerManager.getInstance().subscribe((GenericListener)this);
    }

    public void init() {
        this.instantiateVariables();
        this.createTables();
        this.doWork();
    }

    public void recreateComboBox() {
        this.companySelectionActive = false;
        TableColumn col = this.expenseTable.getColumnModel().getColumn(this.expenseCompanyColumn);
        col.setCellEditor(new ExpensesComboBoxEditor(Preferences.getInstance().getAccountPreferences().getCompanyMap().toArray(new String[0])));
        col.setCellRenderer(new ExpensesComboBoxRenderer(Preferences.getInstance().getAccountPreferences().getCompanyMap().toArray(new String[0])));
        this.expenseCompanyBox.removeAllItems();
        this.companySelection.removeAllItems();
        this.companySelection.addItem("All");
        for (String companyName : Preferences.getInstance().getAccountPreferences().getCompanyMap().toArray(new String[0])) {
            this.companySelection.addItem(companyName);
            this.expenseCompanyBox.addItem(companyName);
        }
        this.expenseCompanyBox.setSelectedItem(Preferences.getInstance().getAccountPreferences().getCompanyDefaultCompany());
        this.companySelectionActive = true;
    }

    private void populateDates() {
        Calendar cal = Calendar.getInstance();
        int day = cal.get(5);
        int month = cal.get(2) + 1;
        int year = cal.get(1);
        int endMonth = month;
        int endYear = year;
        int endDay = LookupServicesUtil.getDBServices().getAccountPreferences().getGenSalesPeriod() - 1;
        if (day < LookupServicesUtil.getDBServices().getAccountPreferences().getGenSalesPeriod()) {
            if (month != 1) {
                --month;
            }
        } else if (endMonth != 12) {
            ++endMonth;
        }
        endDay = endMonth == 12 && month == 12 ? 31 : LookupServicesUtil.getDBServices().getAccountPreferences().getGenSalesPeriod() - 1;
        day = endMonth != 1 ? LookupServicesUtil.getDBServices().getAccountPreferences().getGenSalesPeriod() : 1;
        try {
            SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
            java.sql.Date snapshotDate = new java.sql.Date(df.parse(cal.get(2) + 1 + "/" + cal.get(5) + "/" + cal.get(1)).getTime());
            this.snapshotDateChooser.setDate((Date)snapshotDate);
            java.sql.Date startDate = new java.sql.Date(df.parse(month + "/" + day + "/" + year).getTime());
            this.fromDateChooser.setDate((Date)startDate);
            java.sql.Date endDate = new java.sql.Date(df.parse(endMonth + "/" + endDay + "/" + endYear).getTime());
            this.toDateChooser.setDate((Date)endDate);
            long searchFrom = 0L;
            long searchTo = 0L;
            try {
                if (null != this.fromDateChooser.getDate()) {
                    searchFrom = this.fromDateChooser.getDate().getTime();
                }
                if (null != this.toDateChooser.getDate()) {
                    searchTo = this.toDateChooser.getDate().getTime();
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
            this.savedFrom = searchFrom;
            this.savedTo = searchTo;
            this.savedSnapshot = this.snapshotDateChooser.getDate().getTime();
            if (searchFrom != 0L && searchTo != 0L) {
                LookupServicesUtil.getDBServices().refreshCompletedOrders(searchFrom, searchTo);
                LookupServicesUtil.getDBServices().refreshExpenses(searchFrom, searchTo, this._filteredList, null);
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private int findIndex(String Abbreviation) {
        for (int i = 0; i < this._taxList.size(); ++i) {
            if (!this._taxList.get(i).getAbbreviation().equals(Abbreviation)) continue;
            return i;
        }
        return -1;
    }

    private void setTaxText(String Abbreviation) {
        if ((double)this._taxList.get(this.findIndex(Abbreviation)).getCost().floatValue() == 0.0) {
            this.TaxField.setText(String.format("%.3f", Float.valueOf(SalesTaxRates.getInstance().getDefaultTaxRate(Abbreviation) * 100.0f)));
            this.DeleteButton.setEnabled(false);
        } else {
            this.TaxField.setText(String.format("%.3f", Float.valueOf(this._taxList.get(this.findIndex(Abbreviation)).getCost().floatValue() * 100.0f)));
            this.DeleteButton.setEnabled(true);
        }
    }

    private void populateSalesTax() {
        this._taxList = LookupServicesUtil.getDBServices().getSalesTax();
        for (SalesTax newTax : this._taxList) {
            this._stateNames.add(newTax.getAbbreviation());
        }
        Object[] newArray = this._stateNames.toArray();
        Arrays.sort(newArray);
        String[] newStringArray = (String[])Arrays.copyOf(newArray, newArray.length, String[].class);
        this._stateNames = new ArrayList<String>(Arrays.asList(newStringArray));
        this.StateComboBox.setModel(new DefaultComboBoxModel<Object>(this._stateNames.toArray()));
        this.setTaxText((String)newArray[0]);
    }

    private void updateSalesTax() {
        DefaultTableModel tableModel = (DefaultTableModel)this.taxTable.getModel();
        tableModel.setRowCount(0);
        for (SalesTax newTax : this._taxList) {
            if (!newTax.isEnabled()) continue;
            Object[] row = new Object[tableModel.getColumnCount()];
            row[0] = newTax.getAbbreviation();
            row[1] = String.format("%.3f", Float.valueOf(newTax.getCost().floatValue() * 100.0f)) + "%";
            row[2] = newTax.getTotalSales();
            row[3] = Float.valueOf(newTax.getTotalTaxes());
            tableModel.addRow(row);
        }
    }

    private void initComponents() {
        this.jScrollPane5 = new JScrollPane();
        this.jPanel6 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.expenseTable = new JTable();
        this.jPanel5 = new JPanel();
        this.addExpenseButton = new JButton();
        this.jLabel19 = new JLabel();
        this.jLabel20 = new JLabel();
        this.expenseDateChooser = new JDateChooser();
        this.expenseAmountTextField = new JTextField();
        this.jLabel22 = new JLabel();
        this.jLabel23 = new JLabel();
        this.commentsTextField = new JTextField();
        this.expenseReasonComboBox = new JComboBox();
        this.expenseCompanyBox = new JComboBox();
        this.jLabel16 = new JLabel();
        this.applyExpenseButton = new JButton();
        this.clearExpenseButton = new JButton();
        this.deleteExpenseButton = new JButton();
        this.jPanel7 = new JPanel();
        this.jScrollPane6 = new JScrollPane();
        this.availableExpenseFilterList = new JList();
        this.addExpenseFilterButton = new JButton();
        this.removeExpenseFilterButton = new JButton();
        this.jScrollPane7 = new JScrollPane();
        this.currentExpenseFilterList = new JList();
        this.jLabel12 = new JLabel();
        this.customizeExpenses = new JButton();
        this.jPanel1 = new JPanel();
        this.expenseSearchField = new JTextField();
        this.expenseSearchButton = new JButton();
        this.jPanel3 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.salesTable = new JTable();
        this.applySalesButton = new JButton();
        this.clearSalesButton = new JButton();
        this.dateRangePanel = new JPanel();
        this.jLabel18 = new JLabel();
        this.jLabel21 = new JLabel();
        this.fromDateChooser = new JDateChooser();
        this.toDateChooser = new JDateChooser();
        this.refreshButton = new JButton();
        this.jPanel4 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.rangeLabel = new JLabel();
        this.grossSalesLabel = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel9 = new JLabel();
        this.salesTaxLabel = new JLabel();
        this.expenseLabel = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.netOperatingProfitLabel = new JLabel();
        this.marginLabel = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel10 = new JLabel();
        this.netProfitLabel = new JLabel();
        this.jLabel11 = new JLabel();
        this.cogsLabel = new JLabel();
        this.StateComboBox = new JComboBox();
        this.TaxField = new JTextField();
        this.TaxAcceptButton = new JButton();
        this.jScrollPane8 = new JScrollPane();
        this.taxTable = new JTable();
        this.DeleteButton = new JButton();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.trendingTable = new JTable();
        this.detailedReportButton = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.financialSnapshotTab = new JPanel();
        this.snapshotRangeComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.snapshotHistoryTable = new JTable();
        this.snapshotRefreshButton = new JButton();
        this.snapshotDateChooser = new JDateChooser();
        this.jLabel4 = new JLabel();
        this.detailedBreakdownTab = new JPanel();
        this.jPanel9 = new JPanel();
        this.jScrollPane9 = new JScrollPane();
        this.detailedBreakdownTable = new JTable();
        this.jLabel13 = new JLabel();
        this.detailedDateRangeLabel = new JLabel();
        this.detailedBreakdownRefreshButton = new JButton();
        this.jPanel8 = new JPanel();
        this.companySelection = new JComboBox();
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.jPanel2.border.title")));
        this.expenseTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}}, new String[]{"Company Name", "Date", "Amount", "Type", "Comments"}){
            Class[] types;
            {
                this.types = new Class[]{String.class, String.class, String.class, Object.class, String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.expenseTable.setColumnSelectionAllowed(true);
        this.expenseTable.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane4.setViewportView(this.expenseTable);
        this.expenseTable.getColumnModel().getSelectionModel().setSelectionMode(0);
        if (this.expenseTable.getColumnModel().getColumnCount() > 0) {
            this.expenseTable.getColumnModel().getColumn(0).setHeaderValue(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.expenseTable.columnModel.title4"));
            this.expenseTable.getColumnModel().getColumn(1).setHeaderValue(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.expenseTable.columnModel.title0"));
            this.expenseTable.getColumnModel().getColumn(2).setHeaderValue(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.expenseTable.columnModel.title1"));
            this.expenseTable.getColumnModel().getColumn(3).setHeaderValue(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.expenseTable.columnModel.title2"));
            this.expenseTable.getColumnModel().getColumn(4).setHeaderValue(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.expenseTable.columnModel.title3"));
        }
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.jPanel5.border.title")));
        Mnemonics.setLocalizedText((AbstractButton)this.addExpenseButton, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.addExpenseButton.text"));
        this.addExpenseButton.setEnabled(false);
        this.addExpenseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FinancialSnapshotTopComponent.this.addExpenseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel19, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.jLabel19.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel20, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.jLabel20.text"));
        this.expenseDateChooser.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                FinancialSnapshotTopComponent.this.expenseDateChooserFocusLost(evt);
            }

            @Override
            public void focusGained(FocusEvent evt) {
                FinancialSnapshotTopComponent.this.expenseDateChooserFocusGained(evt);
            }
        });
        this.expenseDateChooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FinancialSnapshotTopComponent.this.expenseDateChooserPropertyChange(evt);
            }
        });
        this.expenseDateChooser.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                FinancialSnapshotTopComponent.this.expenseDateChooserKeyTyped(evt);
            }
        });
        this.expenseAmountTextField.setText(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.expenseAmountTextField.text"));
        this.expenseAmountTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FinancialSnapshotTopComponent.this.expenseAmountTextFieldActionPerformed(evt);
            }
        });
        this.expenseAmountTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                FinancialSnapshotTopComponent.this.expenseAmountTextFieldFocusLost(evt);
            }
        });
        this.expenseAmountTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                FinancialSnapshotTopComponent.this.expenseAmountTextFieldKeyTyped(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel22, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.jLabel22.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel23, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.jLabel23.text"));
        this.commentsTextField.setText(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.commentsTextField.text"));
        this.commentsTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FinancialSnapshotTopComponent.this.commentsTextFieldActionPerformed(evt);
            }
        });
        this.commentsTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                FinancialSnapshotTopComponent.this.commentsTextFieldFocusLost(evt);
            }
        });
        this.expenseReasonComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FinancialSnapshotTopComponent.this.expenseReasonComboBoxActionPerformed(evt);
            }
        });
        this.expenseCompanyBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FinancialSnapshotTopComponent.this.expenseCompanyBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel16, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.jLabel16.text"));
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel19).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.expenseAmountTextField, -2, 86, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel20).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.expenseDateChooser, -2, 112, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel22).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.expenseReasonComboBox, -2, 90, -2).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel5Layout.createSequentialGroup().addGap(161, 161, 161).addComponent(this.addExpenseButton)).addGroup(jPanel5Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel16).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.expenseCompanyBox, -2, 90, -2).addGap(8, 8, 8).addComponent(this.jLabel23).addGap(18, 18, 18).addComponent(this.commentsTextField))).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.expenseDateChooser, -2, -1, -2).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel19).addComponent(this.jLabel20).addComponent(this.expenseAmountTextField, -2, -1, -2)).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel22).addComponent(this.jLabel23).addComponent(this.commentsTextField, -2, -1, -2).addComponent(this.expenseReasonComboBox, -2, -1, -2).addComponent(this.expenseCompanyBox, -2, -1, -2).addComponent(this.jLabel16))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addExpenseButton)));
        Mnemonics.setLocalizedText((AbstractButton)this.applyExpenseButton, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.applyExpenseButton.text"));
        this.applyExpenseButton.setEnabled(false);
        this.applyExpenseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FinancialSnapshotTopComponent.this.applyExpenseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.clearExpenseButton, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.clearExpenseButton.text"));
        this.clearExpenseButton.setEnabled(false);
        this.clearExpenseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FinancialSnapshotTopComponent.this.clearExpenseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.deleteExpenseButton, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.deleteExpenseButton.text"));
        this.deleteExpenseButton.setEnabled(false);
        this.deleteExpenseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FinancialSnapshotTopComponent.this.deleteExpenseButtonActionPerformed(evt);
            }
        });
        this.jPanel7.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.jPanel7.border.title")));
        this.availableExpenseFilterList.setModel(new DefaultListModel());
        this.availableExpenseFilterList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                FinancialSnapshotTopComponent.this.availableExpenseFilterListValueChanged(evt);
            }
        });
        this.jScrollPane6.setViewportView(this.availableExpenseFilterList);
        Mnemonics.setLocalizedText((AbstractButton)this.addExpenseFilterButton, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.addExpenseFilterButton.text"));
        this.addExpenseFilterButton.setEnabled(false);
        this.addExpenseFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FinancialSnapshotTopComponent.this.addExpenseFilterButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeExpenseFilterButton, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.removeExpenseFilterButton.text"));
        this.removeExpenseFilterButton.setEnabled(false);
        this.removeExpenseFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FinancialSnapshotTopComponent.this.removeExpenseFilterButtonActionPerformed(evt);
            }
        });
        this.currentExpenseFilterList.setModel(new DefaultListModel());
        this.currentExpenseFilterList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                FinancialSnapshotTopComponent.this.currentExpenseFilterListValueChanged(evt);
            }
        });
        this.jScrollPane7.setViewportView(this.currentExpenseFilterList);
        Mnemonics.setLocalizedText((JLabel)this.jLabel12, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.jLabel12.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.customizeExpenses, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.customizeExpenses.text"));
        this.customizeExpenses.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FinancialSnapshotTopComponent.this.customizeExpensesActionPerformed(evt);
            }
        });
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane6, -2, 109, -2).addComponent(this.jLabel12)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.removeExpenseFilterButton, -1, -1, Short.MAX_VALUE).addComponent(this.addExpenseFilterButton, -1, -1, Short.MAX_VALUE).addComponent(this.customizeExpenses, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane7, -1, 109, Short.MAX_VALUE).addContainerGap()));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.addExpenseFilterButton).addGap(8, 8, 8).addComponent(this.removeExpenseFilterButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.customizeExpenses).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel7Layout.createSequentialGroup().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane6, -1, 165, Short.MAX_VALUE)).addComponent(this.jScrollPane7)).addContainerGap()));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.jPanel1.border.title")));
        this.expenseSearchField.setText(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.expenseSearchField.text"));
        this.expenseSearchField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FinancialSnapshotTopComponent.this.expenseSearchFieldActionPerformed(evt);
            }
        });
        this.expenseSearchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                FinancialSnapshotTopComponent.this.expenseSearchFieldKeyReleased(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.expenseSearchButton, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.expenseSearchButton.text"));
        this.expenseSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FinancialSnapshotTopComponent.this.expenseSearchButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.expenseSearchField, -2, 237, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.expenseSearchButton).addGap(0, 0, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.expenseSearchField, -2, -1, -2).addComponent(this.expenseSearchButton)).addGap(0, 0, Short.MAX_VALUE)));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.clearExpenseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteExpenseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.applyExpenseButton).addGap(28, 28, 28)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jScrollPane4, -1, 508, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addComponent(this.jPanel7, -2, -1, -2)).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jScrollPane4, -2, 0, Short.MAX_VALUE).addComponent(this.jPanel7, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.clearExpenseButton).addComponent(this.deleteExpenseButton)).addComponent(this.applyExpenseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel5, -2, -1, -2).addContainerGap()));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.jPanel3.border.title")));
        this.salesTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null, null}}, new String[]{"Date", "Item ID", "Customer ID", "State", "Sales Price", "Wholesale Cost", "S/H Paid", "S/H Cost", "PayPal Fee", "Net Profit"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false, false, true, true, true, true, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.salesTable.setColumnSelectionAllowed(true);
        this.jScrollPane3.setViewportView(this.salesTable);
        this.salesTable.getColumnModel().getSelectionModel().setSelectionMode(0);
        if (this.salesTable.getColumnModel().getColumnCount() > 0) {
            this.salesTable.getColumnModel().getColumn(0).setHeaderValue(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.salesTable.columnModel.title0"));
            this.salesTable.getColumnModel().getColumn(1).setHeaderValue(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.salesTable.columnModel.title1"));
            this.salesTable.getColumnModel().getColumn(2).setHeaderValue(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.salesTable.columnModel.title2"));
            this.salesTable.getColumnModel().getColumn(3).setHeaderValue(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.salesTable.columnModel.title3"));
            this.salesTable.getColumnModel().getColumn(4).setHeaderValue(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.salesTable.columnModel.title4"));
            this.salesTable.getColumnModel().getColumn(5).setHeaderValue(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.salesTable.columnModel.title5"));
            this.salesTable.getColumnModel().getColumn(6).setHeaderValue(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.salesTable.columnModel.title6"));
            this.salesTable.getColumnModel().getColumn(7).setHeaderValue(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.salesTable.columnModel.title7"));
            this.salesTable.getColumnModel().getColumn(8).setHeaderValue(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.salesTable.columnModel.title8"));
            this.salesTable.getColumnModel().getColumn(9).setHeaderValue(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.salesTable.columnModel.title9"));
        }
        Mnemonics.setLocalizedText((AbstractButton)this.applySalesButton, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.applySalesButton.text"));
        this.applySalesButton.setEnabled(false);
        this.applySalesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FinancialSnapshotTopComponent.this.applySalesButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.clearSalesButton, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.clearSalesButton.text"));
        this.clearSalesButton.setEnabled(false);
        this.clearSalesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FinancialSnapshotTopComponent.this.clearSalesButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.clearSalesButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.applySalesButton)).addComponent(this.jScrollPane3))));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane3, -2, 0, Short.MAX_VALUE).addGap(3, 3, 3).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.clearSalesButton).addComponent(this.applySalesButton)).addContainerGap()));
        this.dateRangePanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.dateRangePanel.border.title")));
        this.jLabel18.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.jLabel18, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.jLabel18.text"));
        this.jLabel21.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.jLabel21, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.jLabel21.text"));
        this.fromDateChooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FinancialSnapshotTopComponent.this.fromDateChooserPropertyChange(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.refreshButton, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.refreshButton.text"));
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FinancialSnapshotTopComponent.this.refreshButtonActionPerformed(evt);
            }
        });
        GroupLayout dateRangePanelLayout = new GroupLayout(this.dateRangePanel);
        this.dateRangePanel.setLayout(dateRangePanelLayout);
        dateRangePanelLayout.setHorizontalGroup(dateRangePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dateRangePanelLayout.createSequentialGroup().addGroup(dateRangePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dateRangePanelLayout.createSequentialGroup().addComponent(this.jLabel18).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.fromDateChooser, -2, 112, -2)).addGroup(dateRangePanelLayout.createSequentialGroup().addComponent(this.jLabel21).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.toDateChooser, -2, 124, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.refreshButton))).addGap(2, 2, 2)));
        dateRangePanelLayout.linkSize(0, this.jLabel18, this.jLabel21);
        dateRangePanelLayout.linkSize(0, new Component[]{this.fromDateChooser, this.toDateChooser});
        dateRangePanelLayout.setVerticalGroup(dateRangePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dateRangePanelLayout.createSequentialGroup().addContainerGap().addGroup(dateRangePanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel18).addComponent((Component)this.fromDateChooser, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(dateRangePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel21).addGroup(dateRangePanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.refreshButton).addComponent((Component)this.toDateChooser, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.jLabel1.text"));
        this.jLabel3.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.jLabel3.text"));
        Mnemonics.setLocalizedText((JLabel)this.rangeLabel, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.rangeLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.grossSalesLabel, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.grossSalesLabel.text"));
        this.jLabel5.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.jLabel5.text"));
        this.jLabel9.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.jLabel9.text"));
        Mnemonics.setLocalizedText((JLabel)this.salesTaxLabel, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.salesTaxLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.expenseLabel, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.expenseLabel.text"));
        this.jLabel6.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.jLabel6.text"));
        this.jLabel7.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.jLabel7.text"));
        Mnemonics.setLocalizedText((JLabel)this.netOperatingProfitLabel, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.netOperatingProfitLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.marginLabel, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.marginLabel.text"));
        this.jLabel8.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.jLabel8.text"));
        this.jLabel10.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.jLabel10, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.jLabel10.text"));
        Mnemonics.setLocalizedText((JLabel)this.netProfitLabel, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.netProfitLabel.text"));
        this.jLabel11.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.jLabel11, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.jLabel11.text"));
        Mnemonics.setLocalizedText((JLabel)this.cogsLabel, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.cogsLabel.text"));
        this.StateComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.StateComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FinancialSnapshotTopComponent.this.StateComboBoxActionPerformed(evt);
            }
        });
        this.TaxField.setText(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.TaxField.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.TaxAcceptButton, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.TaxAcceptButton.text"));
        this.TaxAcceptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FinancialSnapshotTopComponent.this.TaxAcceptButtonActionPerformed(evt);
            }
        });
        this.taxTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"State", "Sales Tax Rate", "Taxable Sales", "Sales Tax"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.taxTable.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane8.setViewportView(this.taxTable);
        if (this.taxTable.getColumnModel().getColumnCount() > 0) {
            this.taxTable.getColumnModel().getColumn(0).setResizable(false);
            this.taxTable.getColumnModel().getColumn(0).setHeaderValue(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.taxTable.columnModel.title0"));
            this.taxTable.getColumnModel().getColumn(1).setResizable(false);
            this.taxTable.getColumnModel().getColumn(1).setHeaderValue(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.taxTable.columnModel.title1"));
            this.taxTable.getColumnModel().getColumn(2).setResizable(false);
            this.taxTable.getColumnModel().getColumn(2).setHeaderValue(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.taxTable.columnModel.title2_1"));
            this.taxTable.getColumnModel().getColumn(3).setResizable(false);
            this.taxTable.getColumnModel().getColumn(3).setHeaderValue(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.taxTable.columnModel.title3_1"));
        }
        Mnemonics.setLocalizedText((AbstractButton)this.DeleteButton, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.DeleteButton.text"));
        this.DeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FinancialSnapshotTopComponent.this.DeleteButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel14, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.jLabel14.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel15, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.jLabel15.text"));
        this.trendingTable.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"Item ID", "Quantity Sold"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane2.setViewportView(this.trendingTable);
        if (this.trendingTable.getColumnModel().getColumnCount() > 0) {
            this.trendingTable.getColumnModel().getColumn(0).setHeaderValue(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.trendingTable.columnModel.title0"));
            this.trendingTable.getColumnModel().getColumn(1).setHeaderValue(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.trendingTable.columnModel.title1"));
        }
        Mnemonics.setLocalizedText((AbstractButton)this.detailedReportButton, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.detailedReportButton.text"));
        this.detailedReportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FinancialSnapshotTopComponent.this.detailedReportButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rangeLabel)).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.grossSalesLabel)).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cogsLabel)).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.netProfitLabel)).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.salesTaxLabel)).addComponent(this.jLabel1).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.marginLabel, -2, 125, -2)).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.netOperatingProfitLabel)).addComponent(this.jScrollPane8, -2, 317, -2).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.expenseLabel)).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.StateComboBox, -2, 68, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.TaxField, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel14, -2, 18, -2).addGap(23, 23, 23).addComponent(this.TaxAcceptButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.DeleteButton))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jScrollPane2, -1, 151, Short.MAX_VALUE).addComponent(this.jLabel15).addComponent(this.detailedReportButton, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel4Layout.linkSize(0, this.jLabel10, this.jLabel11, this.jLabel3, this.jLabel5, this.jLabel6, this.jLabel7, this.jLabel8, this.jLabel9);
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel15).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.detailedReportButton)).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel1).addGap(12, 12, 12).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.rangeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.grossSalesLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.salesTaxLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.cogsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.netProfitLabel)).addGap(5, 5, 5).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.marginLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.expenseLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.netOperatingProfitLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.StateComboBox, -2, -1, -2).addComponent(this.TaxField, -2, -1, -2).addComponent(this.TaxAcceptButton).addComponent(this.DeleteButton).addComponent(this.jLabel14)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane8, -1, 145, Short.MAX_VALUE))).addContainerGap()));
        this.snapshotRangeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Quarterly", "Monthly"}));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.jLabel2.text"));
        this.snapshotHistoryTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}}, new String[]{"Range", "Gross Sales", "Expenses", "Net Profit", "Margin"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, true, false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane1.setViewportView(this.snapshotHistoryTable);
        Mnemonics.setLocalizedText((AbstractButton)this.snapshotRefreshButton, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.snapshotRefreshButton.text"));
        this.snapshotRefreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FinancialSnapshotTopComponent.this.snapshotRefreshButtonActionPerformed(evt);
            }
        });
        this.snapshotDateChooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FinancialSnapshotTopComponent.this.snapshotDateChooserPropertyChange(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.jLabel4.text"));
        GroupLayout financialSnapshotTabLayout = new GroupLayout(this.financialSnapshotTab);
        this.financialSnapshotTab.setLayout(financialSnapshotTabLayout);
        financialSnapshotTabLayout.setHorizontalGroup(financialSnapshotTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(financialSnapshotTabLayout.createSequentialGroup().addContainerGap().addGroup(financialSnapshotTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(GroupLayout.Alignment.TRAILING, financialSnapshotTabLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(financialSnapshotTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.snapshotRangeComboBox, -2, 115, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(financialSnapshotTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(financialSnapshotTabLayout.createSequentialGroup().addComponent((Component)this.snapshotDateChooser, -2, 112, -2).addGap(166, 166, 166).addComponent(this.snapshotRefreshButton)).addComponent(this.jLabel4)))).addContainerGap()));
        financialSnapshotTabLayout.setVerticalGroup(financialSnapshotTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(financialSnapshotTabLayout.createSequentialGroup().addGroup(financialSnapshotTabLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(financialSnapshotTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(financialSnapshotTabLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.snapshotRangeComboBox, -2, -1, -2).addComponent(this.snapshotRefreshButton)).addComponent((Component)this.snapshotDateChooser, -2, -1, -2)).addGap(9, 9, 9).addComponent(this.jScrollPane1, -1, 279, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.financialSnapshotTab.TabConstraints.tabTitle"), this.financialSnapshotTab);
        this.detailedBreakdownTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}}, new String[]{"Account Name", "Site ID", "Gross Sales", "COGS", "Profit"}));
        this.jScrollPane9.setViewportView(this.detailedBreakdownTable);
        if (this.detailedBreakdownTable.getColumnModel().getColumnCount() > 0) {
            this.detailedBreakdownTable.getColumnModel().getColumn(0).setHeaderValue(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.detailedBreakdownTable.columnModel.title0"));
            this.detailedBreakdownTable.getColumnModel().getColumn(1).setHeaderValue(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.detailedBreakdownTable.columnModel.title1"));
            this.detailedBreakdownTable.getColumnModel().getColumn(2).setHeaderValue(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.detailedBreakdownTable.columnModel.title2"));
            this.detailedBreakdownTable.getColumnModel().getColumn(3).setHeaderValue(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.detailedBreakdownTable.columnModel.title3"));
            this.detailedBreakdownTable.getColumnModel().getColumn(4).setHeaderValue(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.detailedBreakdownTable.columnModel.title5"));
        }
        GroupLayout jPanel9Layout = new GroupLayout(this.jPanel9);
        this.jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane9, GroupLayout.Alignment.TRAILING, -1, 469, Short.MAX_VALUE));
        jPanel9Layout.setVerticalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane9, -2, 280, -2).addContainerGap(-1, Short.MAX_VALUE)));
        Mnemonics.setLocalizedText((JLabel)this.jLabel13, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.jLabel13.text"));
        Mnemonics.setLocalizedText((JLabel)this.detailedDateRangeLabel, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.detailedDateRangeLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.detailedBreakdownRefreshButton, (String)NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.detailedBreakdownRefreshButton.text"));
        this.detailedBreakdownRefreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FinancialSnapshotTopComponent.this.detailedBreakdownRefreshButtonActionPerformed(evt);
            }
        });
        GroupLayout detailedBreakdownTabLayout = new GroupLayout(this.detailedBreakdownTab);
        this.detailedBreakdownTab.setLayout(detailedBreakdownTabLayout);
        detailedBreakdownTabLayout.setHorizontalGroup(detailedBreakdownTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(detailedBreakdownTabLayout.createSequentialGroup().addContainerGap().addGroup(detailedBreakdownTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel9, -1, -1, Short.MAX_VALUE).addGroup(detailedBreakdownTabLayout.createSequentialGroup().addComponent(this.detailedBreakdownRefreshButton).addGap(81, 81, 81).addComponent(this.jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.detailedDateRangeLabel, -2, 210, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        detailedBreakdownTabLayout.setVerticalGroup(detailedBreakdownTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(detailedBreakdownTabLayout.createSequentialGroup().addGap(8, 8, 8).addGroup(detailedBreakdownTabLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.detailedDateRangeLabel).addComponent(this.detailedBreakdownRefreshButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel9, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.detailedBreakdownTab.TabConstraints.tabTitle"), this.detailedBreakdownTab);
        this.jPanel8.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(FinancialSnapshotTopComponent.class, (String)"FinancialSnapshotTopComponent.jPanel8.border.title")));
        this.companySelection.setModel(new DefaultComboBoxModel<String>(new String[]{"All"}));
        this.companySelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FinancialSnapshotTopComponent.this.companySelectionActionPerformed(evt);
            }
        });
        GroupLayout jPanel8Layout = new GroupLayout(this.jPanel8);
        this.jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addComponent(this.companySelection, 0, 199, Short.MAX_VALUE).addContainerGap()));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addComponent(this.companySelection, -2, -1, -2).addContainerGap(40, Short.MAX_VALUE)));
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addComponent(this.dateRangePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel8, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel4, -2, -1, -2).addComponent(this.jTabbedPane1, -2, 494, -2)).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dateRangePanel, -2, -1, -2).addComponent(this.jPanel8, -2, -1, -2)).addGap(20, 20, 20).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -2, -1, -2).addComponent(this.jTabbedPane1, -2, 370, -2))));
        this.jScrollPane5.setViewportView(this.jPanel6);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jScrollPane5)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(7, 7, 7).addComponent(this.jScrollPane5)));
    }

    private void refreshExpenseReasons() {
        ((DefaultListModel)this.currentExpenseFilterList.getModel()).removeAllElements();
        ((DefaultListModel)this.availableExpenseFilterList.getModel()).removeAllElements();
        this._expenseReasons.clear();
        this._expenseReasonsList.clear();
        this.expenseReasonComboBox.removeAllItems();
        Object[] reasons = LookupServicesUtil.getDBServices().getExpenseReasons();
        Arrays.sort(reasons);
        ((DefaultListModel)this.availableExpenseFilterList.getModel()).addElement("All");
        for (int i = 0; i < reasons.length; ++i) {
            this._expenseReasons.put(reasons[i].getExpenseReasonID(), (ExpenseReason)reasons[i]);
            this._expenseReasonsList.put(reasons[i].getReason(), (ExpenseReason)reasons[i]);
            this.expenseReasonComboBox.addItem(reasons[i].getReason());
            ((DefaultListModel)this.availableExpenseFilterList.getModel()).addElement(reasons[i].getReason());
        }
        ((DefaultListModel)this.availableExpenseFilterList.getModel()).addElement("Other");
        ExpenseReason Other = new ExpenseReason();
        Other.setReason("Other");
        Other.setExpenseReasonID(0);
        this._expenseReasons.put(Other.getExpenseReasonID(), Other);
        this._expenseReasonsList.put(Other.getReason(), Other);
        this.expenseReasonComboBox.addItem(Other.getReason());
        this.expenseReasonComboBox.setSelectedItem(Other.getReason());
        TableColumn col = this.expenseTable.getColumnModel().getColumn(this.expenseReasonColumn);
        col.setCellEditor(new ExpensesComboBoxEditor(this._expenseReasonsList.keySet().toArray(new String[0])));
        col.setCellRenderer(new ExpensesComboBoxRenderer(this._expenseReasonsList.keySet().toArray(new String[0])));
        this.updateExpenseTable();
    }

    private void refreshButtonActionPerformed(ActionEvent evt) {
        long searchFrom = 0L;
        long searchTo = 0L;
        try {
            if (null != this.fromDateChooser.getDate()) {
                searchFrom = this.fromDateChooser.getDate().getTime();
            }
            if (null != this.toDateChooser.getDate()) {
                searchTo = this.toDateChooser.getDate().getTime();
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        if (searchFrom == 0L || searchTo == 0L) {
            JOptionPane.showMessageDialog(null, "Invalid date range. Using last accepted date to refresh data.");
            searchFrom = this.savedFrom;
            searchTo = this.savedTo;
        } else {
            this.savedFrom = searchFrom;
            this.savedTo = searchTo;
        }
        LookupServicesUtil.getDBServices().refreshCompletedOrders(searchFrom, searchTo);
        LookupServicesUtil.getDBServices().refreshExpenses(searchFrom, searchTo, this._filteredList, null);
    }

    private void fromDateChooserPropertyChange(PropertyChangeEvent evt) {
    }

    private void addExpenseButtonActionPerformed(ActionEvent evt) {
        if (this.validateExpense()) {
            Expense expense = new Expense();
            expense.setExpenseComment(this.commentsTextField.getText());
            String amountString = MathParser.isDollarAmount((String)this.expenseAmountTextField.getText());
            if (null != amountString) {
                expense.setExpenseCost(Float.valueOf(amountString).floatValue());
            }
            expense.setExpenseDate(new java.sql.Date(this.expenseDateChooser.getDate().getTime()));
            expense.setCompanyName(this.expenseCompanyBox.getSelectedItem().toString().trim());
            try {
                expense.setExpenseReasonID(this._expenseReasonsList.get((String)this.expenseReasonComboBox.getSelectedItem()).getExpenseReasonID());
                LookupServicesUtil.getDBServices().updateExpense(expense);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
                JOptionPane.showMessageDialog(null, "Please select a reason before adding expenses.");
            }
            this.commentsTextField.setText("");
            this.expenseReasonComboBox.setSelectedItem("Other");
            this.expenseAmountTextField.setText("");
            this.addExpenseButton.setEnabled(false);
        }
    }

    private void expenseAmountTextFieldActionPerformed(ActionEvent evt) {
        this.validateExpense();
    }

    private void commentsTextFieldActionPerformed(ActionEvent evt) {
        this.validateExpense();
    }

    private void expenseDateChooserPropertyChange(PropertyChangeEvent evt) {
        this.validateExpense();
    }

    private void expenseAmountTextFieldFocusLost(FocusEvent evt) {
        this.validateExpense();
    }

    private void expenseDateChooserFocusLost(FocusEvent evt) {
        this.validateExpense();
    }

    private void commentsTextFieldFocusLost(FocusEvent evt) {
        this.validateExpense();
    }

    private void applySalesButtonActionPerformed(ActionEvent evt) {
        this.updateSalesNeeded(false);
        Integer[] arr$ = this._updatedSalesOrders.keySet().toArray(new Integer[0]);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int orderID = arr$[i$];
            LookupServicesUtil.getDBServices().updateOrder(this._completeOrders.get(orderID));
        }
        this._updatedSalesOrders.clear();
        long searchFrom = 0L;
        long searchTo = 0L;
        try {
            if (null != this.fromDateChooser.getDate()) {
                searchFrom = this.fromDateChooser.getDate().getTime();
            }
            if (null != this.toDateChooser.getDate()) {
                searchTo = this.toDateChooser.getDate().getTime();
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        if (searchFrom == 0L || searchTo == 0L) {
            JOptionPane.showMessageDialog(null, "Invalid date range. Using last accepted date to refresh data.");
            searchFrom = this.savedFrom;
            searchTo = this.savedTo;
        } else {
            this.savedFrom = searchFrom;
            this.savedTo = searchTo;
        }
        LookupServicesUtil.getDBServices().refreshCompletedOrders(searchFrom, searchTo);
    }

    private void clearSalesButtonActionPerformed(ActionEvent evt) {
        this._updatedSalesOrders.clear();
        this.updateSalesNeeded(false);
        long searchFrom = 0L;
        long searchTo = 0L;
        try {
            if (null != this.fromDateChooser.getDate()) {
                searchFrom = this.fromDateChooser.getDate().getTime();
            }
            if (null != this.toDateChooser.getDate()) {
                searchTo = this.toDateChooser.getDate().getTime();
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        if (searchFrom == 0L || searchTo == 0L) {
            JOptionPane.showMessageDialog(null, "Invalid date range. Using last accepted date to refresh data.");
            searchFrom = this.savedFrom;
            searchTo = this.savedTo;
        } else {
            this.savedFrom = searchFrom;
            this.savedTo = searchTo;
        }
        LookupServicesUtil.getDBServices().refreshCompletedOrders(searchFrom, searchTo);
    }

    private void applyExpenseButtonActionPerformed(ActionEvent evt) {
        Integer[] arr$ = this._updatedExpenses.keySet().toArray(new Integer[0]);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int expenseID = arr$[i$];
            LookupServicesUtil.getDBServices().updateExpense(this._expenses.get(expenseID));
        }
        this._updatedExpenses.clear();
        long searchFrom = 0L;
        long searchTo = 0L;
        try {
            if (null != this.fromDateChooser.getDate()) {
                searchFrom = this.fromDateChooser.getDate().getTime();
            }
            if (null != this.toDateChooser.getDate()) {
                searchTo = this.toDateChooser.getDate().getTime();
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        this.updateExpensesNeeded(false);
        if (searchFrom == 0L || searchTo == 0L) {
            JOptionPane.showMessageDialog(null, "Invalid date range. Using last accepted date to refresh data.");
            searchFrom = this.savedFrom;
            searchTo = this.savedTo;
        } else {
            this.savedFrom = searchFrom;
            this.savedTo = searchTo;
        }
        LookupServicesUtil.getDBServices().refreshExpenses(searchFrom, searchTo, this._filteredList, null);
    }

    private void deleteExpenseButtonActionPerformed(ActionEvent evt) {
        int[] rows;
        this.disableListener(true);
        for (int row : rows = this.expenseTable.getSelectedRows()) {
            int expenseID = this._expenseMapping.get(row);
            Expense expense = this._expenses.get(expenseID);
            LookupServicesUtil.getDBServices().deleteExpense(expense);
        }
        this.disableListener(false);
        LookupServicesUtil.getDBServices().setRefresh(false);
        ListenerManager.getInstance().notify((GenericListener)ListenerManager.TRANSACTION_LISTENER);
    }

    private void clearExpenseButtonActionPerformed(ActionEvent evt) {
        this._updatedExpenses.clear();
        this.updateExpensesNeeded(false);
        long searchFrom = 0L;
        long searchTo = 0L;
        try {
            if (null != this.fromDateChooser.getDate()) {
                searchFrom = this.fromDateChooser.getDate().getTime();
            }
            if (null != this.toDateChooser.getDate()) {
                searchTo = this.toDateChooser.getDate().getTime();
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        if (searchFrom == 0L || searchTo == 0L) {
            JOptionPane.showMessageDialog(null, "Invalid date range. Using last accepted date to refresh data.");
            searchFrom = this.savedFrom;
            searchTo = this.savedTo;
        } else {
            this.savedFrom = searchFrom;
            this.savedTo = searchTo;
        }
        LookupServicesUtil.getDBServices().refreshExpenses(searchFrom, searchTo, this._filteredList, null);
    }

    private void snapshotRefreshButtonActionPerformed(ActionEvent evt) {
        this.snapshotRefreshButton.setEnabled(false);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    FinancialSnapshotTopComponent.this.updateSnapshotTable();
                }
                catch (Exception ex) {
                    ErrorsUtil.getInstance().logError(ex);
                }
                finally {
                    FinancialSnapshotTopComponent.this.snapshotRefreshButton.setEnabled(true);
                }
            }
        }).start();
    }

    private void snapshotDateChooserPropertyChange(PropertyChangeEvent evt) {
    }

    private void expenseReasonComboBoxActionPerformed(ActionEvent evt) {
        this.validateExpense();
    }

    private void availableExpenseFilterListValueChanged(ListSelectionEvent evt) {
        if (this.availableExpenseFilterList.isSelectionEmpty()) {
            this.addExpenseFilterButton.setEnabled(false);
        } else {
            this.addExpenseFilterButton.setEnabled(true);
        }
    }

    private void sortExpenses() {
        Object[] currentList = ((DefaultListModel)this.currentExpenseFilterList.getModel()).toArray();
        Object[] availableList = ((DefaultListModel)this.availableExpenseFilterList.getModel()).toArray();
        ((DefaultListModel)this.availableExpenseFilterList.getModel()).clear();
        ((DefaultListModel)this.currentExpenseFilterList.getModel()).clear();
        Arrays.sort(currentList);
        Arrays.sort(availableList);
        boolean allLocation = false;
        boolean otherLocation = false;
        for (Object obj : currentList) {
            if (!obj.toString().equalsIgnoreCase("All") && !obj.toString().equalsIgnoreCase("Other")) {
                ((DefaultListModel)this.currentExpenseFilterList.getModel()).addElement(obj);
                continue;
            }
            if (obj.toString().equalsIgnoreCase("All")) {
                allLocation = true;
                continue;
            }
            if (!obj.toString().equalsIgnoreCase("Other")) continue;
            otherLocation = true;
        }
        for (Object obj : availableList) {
            if (obj.toString().equalsIgnoreCase("All") || obj.toString().equalsIgnoreCase("Other")) continue;
            ((DefaultListModel)this.availableExpenseFilterList.getModel()).addElement(obj);
        }
        if (allLocation) {
            ((DefaultListModel)this.currentExpenseFilterList.getModel()).add(0, "All");
        } else {
            ((DefaultListModel)this.availableExpenseFilterList.getModel()).add(0, "All");
        }
        if (otherLocation) {
            ((DefaultListModel)this.currentExpenseFilterList.getModel()).add(((DefaultListModel)this.currentExpenseFilterList.getModel()).getSize(), "Other");
        } else {
            ((DefaultListModel)this.availableExpenseFilterList.getModel()).add(((DefaultListModel)this.availableExpenseFilterList.getModel()).getSize(), "Other");
        }
    }

    private void addExpenseFilterButtonActionPerformed(ActionEvent evt) {
        Object[] list = this.availableExpenseFilterList.getSelectedValues();
        for (int i = 0; i < list.length; ++i) {
            ((DefaultListModel)this.currentExpenseFilterList.getModel()).addElement(list[i]);
            ((DefaultListModel)this.availableExpenseFilterList.getModel()).removeElement(list[i]);
        }
        this.sortExpenses();
        if (list.length > 0) {
            this.refreshExpenses();
        }
    }

    private void removeExpenseFilterButtonActionPerformed(ActionEvent evt) {
        Object[] list = this.currentExpenseFilterList.getSelectedValues();
        for (int i = 0; i < list.length; ++i) {
            ((DefaultListModel)this.availableExpenseFilterList.getModel()).addElement(list[i]);
            ((DefaultListModel)this.currentExpenseFilterList.getModel()).removeElement(list[i]);
        }
        this.sortExpenses();
        if (list.length > 0) {
            this.refreshExpenses();
        }
    }

    private void currentExpenseFilterListValueChanged(ListSelectionEvent evt) {
        if (this.currentExpenseFilterList.isSelectionEmpty()) {
            this.removeExpenseFilterButton.setEnabled(false);
        } else {
            this.removeExpenseFilterButton.setEnabled(true);
        }
    }

    private void customizeExpensesActionPerformed(ActionEvent evt) {
        Preferences.getInstance().openTab(Preferences.Index.Expense);
        this.refreshExpenseReasons();
        this.refreshExpenses();
    }

    private void TaxAcceptButtonActionPerformed(ActionEvent evt) {
        String Abbreviation = (String)this.StateComboBox.getSelectedItem();
        try {
            Float Cost = Float.valueOf(Float.valueOf(this.TaxField.getText()).floatValue() / 100.0f);
            LookupServicesUtil.getDBServices().setSalesTax(Abbreviation, "", Cost);
            this._taxList.get(this.findIndex(Abbreviation)).setCost(Cost);
            this._taxList.get(this.findIndex(Abbreviation)).setEnabled((double)Cost.floatValue() != 0.0);
            this.DeleteButton.setEnabled((double)Cost.floatValue() != 0.0);
            this.updateSalesTax();
            this.updateSalesTable();
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private void StateComboBoxActionPerformed(ActionEvent evt) {
        this.setTaxText((String)this.StateComboBox.getSelectedItem());
    }

    private void detailedBreakdownRefreshButtonActionPerformed(ActionEvent evt) {
        HashMap<String, DetailedBreakdownItem> breakdownMap = new HashMap<String, DetailedBreakdownItem>();
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yy");
        this.detailedDateRangeLabel.setText(formatter.format(this.fromDateChooser.getDate()) + " - " + formatter.format(this.toDateChooser.getDate()));
        ArrayList orders = new ArrayList(LookupServicesUtil.getDBServices().getCompletedOrders().values());
        Collections.sort(orders, new CompleteOrderComparator(CompleteOrderComparator.ORDER_DATE));
        DefaultTableModel tableModel = (DefaultTableModel)this.detailedBreakdownTable.getModel();
        tableModel.setNumRows(0);
        String selectedCompany = "All";
        if (this.companySelection.getSelectedItem() != null) {
            selectedCompany = this.companySelection.getSelectedItem().toString();
        }
        for (CompleteOrder completeOrder : orders) {
            try {
                DetailedBreakdownItem tableEntry;
                if (!completeOrder.getOrder().getPaypalAccount().equalsIgnoreCase(selectedCompany) && !selectedCompany.equalsIgnoreCase("All")) continue;
                completeOrder.setRowStart(tableModel.getRowCount());
                boolean international = false;
                if (!(completeOrder.getOrder().getCustomer().getCustomerCountry().toLowerCase().equals("united states") || completeOrder.getOrder().getCustomer().getCustomerCountry().toLowerCase().equals("usa") || completeOrder.getOrder().getCustomer().getCustomerCountry().toLowerCase().equals("us"))) {
                    international = true;
                }
                double paypalfeeTotal = FeeProcessor.getPayPalFees((float)completeOrder.getOrder().getOrderTotal(), (float)completeOrder.getOrder().getShippingPaid(), (boolean)international);
                String accountNameTemp = "";
                String siteIDTemp = "";
                for (int j = 0; j < completeOrder.getOrderDetails().size(); ++j) {
                    if (!((OrderDetails)completeOrder.getOrderDetails().get(j)).getAccountName().isEmpty()) {
                        accountNameTemp = ((OrderDetails)completeOrder.getOrderDetails().get(j)).getAccountName().toLowerCase();
                    }
                    if (((OrderDetails)completeOrder.getOrderDetails().get(j)).getEbaySite().isEmpty()) continue;
                    siteIDTemp = ((OrderDetails)completeOrder.getOrderDetails().get(j)).getEbaySite().toLowerCase();
                }
                if (accountNameTemp.isEmpty() && accountNameTemp.isEmpty()) {
                    accountNameTemp = !((OrderDetails)completeOrder.getOrderDetails().get(0)).getOrderNumber().isEmpty() ? (((OrderDetails)completeOrder.getOrderDetails().get(0)).getOrderNumber().toLowerCase().contains("amazon") || completeOrder.getOrder().getCustomer().getCustomerUserName().toLowerCase().contains("amazon") ? "amazon" : (((OrderDetails)completeOrder.getOrderDetails().get(0)).getOrderNumber().toLowerCase().contains("ecrater") || ((OrderDetails)completeOrder.getOrderDetails().get(0)).getOrderNumber().toLowerCase().contains("e-crater") ? "ecrater" : (((OrderDetails)completeOrder.getOrderDetails().get(0)).getOrderNumber().toLowerCase().contains("website") ? "website" : "unknown"))) : (((OrderDetails)completeOrder.getOrderDetails().get(0)).getOrderNumber().toLowerCase().contains("amazon") || completeOrder.getOrder().getCustomer().getCustomerUserName().toLowerCase().contains("amazon") ? "amazon" : "unknown");
                }
                if (siteIDTemp.isEmpty()) {
                    if (breakdownMap.containsKey(accountNameTemp)) {
                        tableEntry = (DetailedBreakdownItem)breakdownMap.get(accountNameTemp);
                    } else {
                        tableEntry = new DetailedBreakdownItem();
                        tableEntry.setAccountName(accountNameTemp);
                        tableEntry.setSiteID(siteIDTemp);
                        breakdownMap.put(accountNameTemp, tableEntry);
                    }
                } else if (breakdownMap.containsKey(siteIDTemp + accountNameTemp)) {
                    tableEntry = (DetailedBreakdownItem)breakdownMap.get(siteIDTemp + accountNameTemp);
                } else {
                    tableEntry = new DetailedBreakdownItem();
                    tableEntry.setAccountName(accountNameTemp);
                    tableEntry.setSiteID(siteIDTemp);
                    breakdownMap.put(siteIDTemp + accountNameTemp, tableEntry);
                }
                tableEntry.setGrossSales(tableEntry.getGrossSales() + (double)completeOrder.getOrder().getOrderTotal() + (double)completeOrder.getOrder().getShippingPaid());
                double cogTemp = 0.0;
                for (int j = 0; j < completeOrder.getOrderDetails().size(); ++j) {
                    cogTemp += (double)((OrderDetails)completeOrder.getOrderDetails().get(j)).getItemCost();
                }
                cogTemp = cogTemp + paypalfeeTotal + (double)completeOrder.getOrder().getShippingCost();
                double sellingFee = 0.0;
                if (siteIDTemp.equals("france")) {
                    sellingFee = 0.08 * (double)completeOrder.getOrder().getOrderTotal();
                } else if (siteIDTemp.contains("uk")) {
                    sellingFee = 0.105 * (double)completeOrder.getOrder().getOrderTotal();
                } else if (siteIDTemp.equals("us")) {
                    sellingFee = 0.11 * (double)(completeOrder.getOrder().getOrderTotal() + completeOrder.getOrder().getShippingPaid());
                } else if (accountNameTemp.equals("ecrater")) {
                    sellingFee = 0.0;
                } else if (accountNameTemp.equals("amazon")) {
                    sellingFee = 0.0;
                } else if (accountNameTemp.equals("website")) {
                    sellingFee = 0.01 * (double)(completeOrder.getOrder().getOrderTotal() + completeOrder.getOrder().getShippingPaid());
                }
                tableEntry.setCogs(tableEntry.getCogs() + (cogTemp += sellingFee));
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        DetailedBreakdownItem[] entrySet = breakdownMap.values().toArray(new DetailedBreakdownItem[0]);
        for (int i = 0; i < entrySet.length; ++i) {
            Object[] row = new Object[tableModel.getColumnCount()];
            row[this.detailedAccountNameColumn] = entrySet[i].getAccountName();
            row[this.detailedSiteIDColumn] = entrySet[i].getSiteID();
            double temp = entrySet[i].getGrossSales();
            row[this.detailedGrossSalesColumn] = null != MathParser.isDollarAmount((String)String.valueOf(temp)) ? MathParser.isDollarAmount((String)String.valueOf(temp)) : Double.valueOf(entrySet[i].getGrossSales());
            temp = entrySet[i].getGrossSales();
            row[this.detailedGrossSalesColumn] = null != MathParser.isDollarAmount((String)String.valueOf(temp)) ? MathParser.isDollarAmount((String)String.valueOf(temp)) : Double.valueOf(entrySet[i].getGrossSales());
            temp = entrySet[i].getCogs();
            row[this.detailedCogsColumn] = null != MathParser.isDollarAmount((String)String.valueOf(temp)) ? MathParser.isDollarAmount((String)String.valueOf(temp)) : Double.valueOf(entrySet[i].getCogs());
            temp = entrySet[i].getGrossSales() - entrySet[i].getCogs();
            row[this.detailedProfitColumn] = null != MathParser.isDollarAmount((String)String.valueOf(temp)) ? MathParser.isDollarAmount((String)String.valueOf(temp)) : Double.valueOf(entrySet[i].getGrossSales() - entrySet[i].getCogs());
            tableModel.addRow(row);
        }
    }

    private void DeleteButtonActionPerformed(ActionEvent evt) {
        String Abbreviation = (String)this.StateComboBox.getSelectedItem();
        try {
            Float Cost = Float.valueOf(0.0f);
            LookupServicesUtil.getDBServices().setSalesTax(Abbreviation, "", Cost);
            this._taxList.get(this.findIndex(Abbreviation)).setCost(Cost);
            this._taxList.get(this.findIndex(Abbreviation)).setEnabled((double)Cost.floatValue() != 0.0);
            this.DeleteButton.setEnabled((double)Cost.floatValue() != 0.0);
            this.updateSalesTax();
            this.updateSalesTable();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void expenseAmountTextFieldKeyTyped(KeyEvent evt) {
        this.validateExpense();
    }

    private void expenseSearchFieldKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.refreshExpenses();
        }
    }

    private void expenseSearchFieldActionPerformed(ActionEvent evt) {
    }

    private void expenseSearchButtonActionPerformed(ActionEvent evt) {
        this.refreshExpenses();
    }

    private void expenseDateChooserFocusGained(FocusEvent evt) {
        this.validateExpense();
    }

    private void expenseDateChooserKeyTyped(KeyEvent evt) {
        this.validateExpense();
    }

    private void companySelectionActionPerformed(ActionEvent evt) {
        if (this.companySelectionActive) {
            this.updateSalesTable();
            this.updateExpenseTable();
            this.updateSalesTax();
            this.updateSnapshotTable();
            this.netOperatingProfitLabel.setText(String.valueOf(NumberFormat.getCurrencyInstance().format(this.netProfit - this.expenses)));
        }
    }

    private void expenseCompanyBoxActionPerformed(ActionEvent evt) {
        if (this.companySelectionActive) {
            this.validateExpense();
        }
    }

    private void detailedReportButtonActionPerformed(ActionEvent evt) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    FinancialSnapshotTopComponent.this.getDetailedItemsTrendingReport();
                }
                catch (Exception ex) {
                    ErrorsUtil.getInstance().logError(ex);
                }
            }
        }).start();
    }

    private void getDetailedItemsTrendingReport() {
        HashMap<String, Integer> quantityMap = new HashMap<String, Integer>();
        HashMap<String, Integer> quantityHeldMap = new HashMap<String, Integer>();
        HashMap<String, java.sql.Date> dateSoldMap = new HashMap<String, java.sql.Date>();
        ValueComparator valueComparator = new ValueComparator(quantityMap);
        TreeMap<String, Integer> sortedQuantityMap = new TreeMap<String, Integer>(valueComparator);
        Collection inventory = LookupServicesUtil.getDBServices().getInventoryList("", true, false, true, new String[0], false);
        HashMap allOrders = LookupServicesUtil.getDBServices().getOrders("", null, this.fromDateChooser.getDate().getTime(), this.toDateChooser.getDate().getTime(), "1000000");
        if (inventory != null) {
            for (ArrayList elementList : inventory) {
                for (InventoryElement element : elementList) {
                    element.setItem(LookupServicesUtil.getDBServices().getItem(element.getItemID()));
                    if (element.getItemQuantity() <= 0 || element.getItem() == null || element.getItem().isDropShipped()) continue;
                    if (!quantityHeldMap.containsKey(element.getItem().getItemID())) {
                        quantityHeldMap.put(element.getItem().getItemID(), 0);
                    }
                    quantityHeldMap.put(element.getItem().getItemID(), (Integer)quantityHeldMap.get(element.getItem().getItemID()) + element.getItemQuantity());
                }
            }
        }
        for (CompleteOrder completeOrder : allOrders.values()) {
            java.sql.Date dateSold = completeOrder.getOrder().getOrderDate();
            for (OrderDetails orderDetails : completeOrder.getOrderDetails()) {
                String itemID = orderDetails.getItemID();
                if (!quantityHeldMap.containsKey(itemID) || (Integer)quantityHeldMap.get(itemID) <= 0 || !orderDetails.isInhouse()) continue;
                if (!quantityMap.containsKey(itemID)) {
                    quantityMap.put(itemID, 0);
                }
                if (!dateSoldMap.containsKey(itemID)) {
                    dateSoldMap.put(itemID, dateSold);
                }
                quantityMap.put(itemID, quantityMap.get(itemID) + 1);
                if (!((java.sql.Date)dateSoldMap.get(itemID)).before(dateSold)) continue;
                dateSoldMap.put(itemID, dateSold);
            }
        }
        sortedQuantityMap.putAll(quantityMap);
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter("Items Trending.txt"));
            bufferedWriter.write("Date: \t" + this.fromDateChooser.getDate().toString() + "\t" + this.toDateChooser.getDate().toString());
            bufferedWriter.newLine();
            bufferedWriter.write("Item ID\tLast Sold On\tQuantity Sold");
            bufferedWriter.newLine();
            for (String ID : sortedQuantityMap.keySet()) {
                bufferedWriter.write(ID + "\t" + dateSoldMap.get(ID) + "\t" + quantityMap.get(ID));
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
            JOptionPane.showMessageDialog(null, "Detailed Trending Items Report has been created.");
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Failed to create Tending Items Report. Likely cause: File is currently open.");
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private boolean validateExpense() {
        boolean validExpense = true;
        if (null == MathParser.isDollarAmount((String)this.expenseAmountTextField.getText())) {
            this.expenseAmountTextField.setText("");
            validExpense = false;
        }
        if (null == this.expenseReasonComboBox.getSelectedItem()) {
            validExpense = false;
        }
        if (null == this.expenseDateChooser.getDate()) {
            validExpense = false;
        }
        if (null == this.expenseCompanyBox.getSelectedItem()) {
            validExpense = false;
        }
        if (validExpense && !this.applyExpenseButton.isEnabled()) {
            this.addExpenseButton.setEnabled(true);
        } else {
            this.addExpenseButton.setEnabled(false);
        }
        return validExpense;
    }

    public static synchronized FinancialSnapshotTopComponent findInstance() {
        if (instance == null) {
            instance = new FinancialSnapshotTopComponent();
        }
        return instance;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    Object readProperties(Properties p) {
        if (instance == null) {
            instance = this;
        }
        instance.readPropertiesImpl(p);
        return instance;
    }

    private void readPropertiesImpl(Properties p) {
        String version = p.getProperty("version");
    }

    public void completedOrderListUpdated() {
        if (!this.applySalesButton.isEnabled()) {
            this.updateSalesTable();
        }
        this.updateSalesTax();
        this.netOperatingProfitLabel.setText(String.valueOf(NumberFormat.getCurrencyInstance().format(this.netProfit - this.expenses)));
    }

    public void expenseListUpdated() {
        if (!this.applyExpenseButton.isEnabled()) {
            this.updateExpenseTable();
        }
        this.netOperatingProfitLabel.setText(String.valueOf(NumberFormat.getCurrencyInstance().format(this.netProfit - this.expenses)));
    }

    public void updateSalesTable() {
        this.disableListener(true);
        this.grossSales = 0.0;
        this.netProfit = 0.0;
        this.cogs = 0.0;
        this.salesTax = 0.0;
        for (SalesTax newTax : this._taxList) {
            newTax.setTotalSales(Float.valueOf(0.0f));
        }
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yy");
        try {
            if (this.fromDateChooser.getDate() == null || this.toDateChooser.getDate() == null) {
                this.rangeLabel.setText(formatter.format(new java.sql.Date(this.savedFrom)) + " - " + formatter.format(new java.sql.Date(this.savedTo)));
            } else {
                this.rangeLabel.setText(formatter.format(this.fromDateChooser.getDate()) + " - " + formatter.format(this.toDateChooser.getDate()));
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        ArrayList orders = new ArrayList(LookupServicesUtil.getDBServices().getCompletedOrders().values());
        Collections.sort(orders, new CompleteOrderComparator(CompleteOrderComparator.CUSTOMER_NAME));
        DefaultTableModel tableModel = (DefaultTableModel)this.salesTable.getModel();
        this._salesOrderMapping.clear();
        this._trendMap.clear();
        tableModel.setNumRows(0);
        String selectedCompany = "All";
        if (this.companySelection.getSelectedItem() != null) {
            selectedCompany = this.companySelection.getSelectedItem().toString();
        }
        for (CompleteOrder completeOrder : orders) {
            try {
                if (!completeOrder.getOrder().getPaypalAccount().equalsIgnoreCase(selectedCompany) && !selectedCompany.equalsIgnoreCase("All")) continue;
                completeOrder.setRowStart(tableModel.getRowCount());
                this._completeOrders.put(completeOrder.getOrder().getOrderID(), completeOrder);
                Object[] row = new Object[tableModel.getColumnCount()];
                row[this.salesCustomerIDColumn] = completeOrder.getOrder().getCustomer().getCustomerUserName();
                row[this.salesStateColumn] = completeOrder.getOrder().getCustomer().getCustomerState();
                String CustomerState = completeOrder.getOrder().getCustomer().getCustomerState();
                for (SalesTax newTax : this._taxList) {
                    if (!CustomerState.equals(newTax.getAbbreviation())) continue;
                    this.salesTax += (double)(completeOrder.getOrder().getOrderTotal() * newTax.getCost().floatValue());
                    newTax.setTotalSales(Float.valueOf(newTax.getTotalSales().floatValue() + completeOrder.getOrder().getOrderTotal()));
                }
                row[this.salesDateColumn] = completeOrder.getOrder().getOrderDate().toString();
                this.grossSales += (double)(completeOrder.getOrder().getOrderTotal() + completeOrder.getOrder().getShippingPaid());
                this.cogs += (double)completeOrder.getOrder().getShippingCost();
                row[this.salesSalesPriceColumn] = String.valueOf(NumberFormat.getCurrencyInstance().format(completeOrder.getOrder().getOrderTotal()));
                row[this.salesSHCostColumn] = String.valueOf(NumberFormat.getCurrencyInstance().format(completeOrder.getOrder().getShippingCost()));
                row[this.salesSHPaidColumn] = String.valueOf(NumberFormat.getCurrencyInstance().format(completeOrder.getOrder().getShippingPaid()));
                float wholesaleCost = 0.0f;
                boolean international = false;
                ArrayList orderDetails = completeOrder.getOrderDetails();
                for (OrderDetails orderDetail : orderDetails) {
                    this.cogs += (double)orderDetail.getItemCost();
                    wholesaleCost += orderDetail.getItemCost();
                }
                if (!(completeOrder.getOrder().getCustomer().getCustomerCountry().toLowerCase().equals("united states") || completeOrder.getOrder().getCustomer().getCustomerCountry().toLowerCase().equals("usa") || completeOrder.getOrder().getCustomer().getCustomerCountry().toLowerCase().equals("us"))) {
                    international = true;
                }
                float paypalfeeTotal = FeeProcessor.getPayPalFees((float)completeOrder.getOrder().getOrderTotal(), (float)completeOrder.getOrder().getShippingPaid(), (boolean)international);
                this.cogs += (double)paypalfeeTotal;
                row[this.salesPayPalFeeColumn] = String.valueOf(NumberFormat.getCurrencyInstance().format(paypalfeeTotal));
                row[this.salesNetProfitColumn] = String.valueOf(NumberFormat.getCurrencyInstance().format((double)completeOrder.getOrder().getOrderTotal() + (double)completeOrder.getOrder().getShippingPaid() - (double)paypalfeeTotal - (double)completeOrder.getOrder().getShippingCost() - (double)wholesaleCost));
                for (int j = 0; j < completeOrder.getOrderDetails().size(); ++j) {
                    TrendObject trendObject;
                    if (j != 0) {
                        row = new Object[tableModel.getColumnCount()];
                    }
                    row[this.salesItemIDColumn] = ((OrderDetails)completeOrder.getOrderDetails().get(j)).getItemID();
                    if (this._trendMap.containsKey(((OrderDetails)completeOrder.getOrderDetails().get(j)).getItemID())) {
                        trendObject = this._trendMap.get(((OrderDetails)completeOrder.getOrderDetails().get(j)).getItemID());
                        trendObject.setQuantity(trendObject.getQuantity() + 1);
                        this._trendMap.put(((OrderDetails)completeOrder.getOrderDetails().get(j)).getItemID(), trendObject);
                    } else {
                        trendObject = new TrendObject(((OrderDetails)completeOrder.getOrderDetails().get(j)).getItemID());
                        this._trendMap.put(((OrderDetails)completeOrder.getOrderDetails().get(j)).getItemID(), trendObject);
                    }
                    row[this.salesWholesaleCostColumn] = String.valueOf(NumberFormat.getCurrencyInstance().format(((OrderDetails)completeOrder.getOrderDetails().get(j)).getItemCost()));
                    tableModel.addRow(row);
                    this._salesOrderMapping.add(completeOrder.getOrder().getOrderID());
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        this.netProfit = this.grossSales - this.cogs;
        this.grossSalesLabel.setText(String.valueOf(NumberFormat.getCurrencyInstance().format(this.grossSales)));
        this.salesTaxLabel.setText(String.valueOf(NumberFormat.getCurrencyInstance().format(this.salesTax)));
        this.cogsLabel.setText(String.valueOf(NumberFormat.getCurrencyInstance().format(this.cogs)));
        this.netProfitLabel.setText(String.valueOf(NumberFormat.getCurrencyInstance().format(this.netProfit)));
        double margin = 0.0;
        if (this.grossSales != 0.0) {
            margin = this.netProfit / this.grossSales * 100.0;
        }
        String marginText = (int)margin + "%";
        this.marginLabel.setText(marginText);
        TrendObject[] trendingItems = this._trendMap.values().toArray(new TrendObject[0]);
        Arrays.sort(trendingItems, new TrendComparator());
        DefaultTableModel trendingTableModel = (DefaultTableModel)this.trendingTable.getModel();
        trendingTableModel.setNumRows(0);
        for (int i = 0; i < trendingItems.length; ++i) {
            Object[] row = new Object[trendingTableModel.getColumnCount()];
            row[this.trendingItemIDColumn] = trendingItems[i].productId;
            row[this.trendingQuantityColumn] = trendingItems[i].quantity;
            trendingTableModel.addRow(row);
        }
        this.disableListener(false);
    }

    public void updateSnapshotTable() {
        this.disableListener(true);
        Calendar calendar = Calendar.getInstance();
        if (this.snapshotDateChooser.getCalendar() == null) {
            JOptionPane.showMessageDialog(null, "Invalid date. Using last accepted date to refresh data.");
            calendar.setTime(new java.sql.Date(this.savedSnapshot));
        } else {
            calendar = this.snapshotDateChooser.getCalendar();
        }
        boolean quarterly = false;
        if (((String)this.snapshotRangeComboBox.getSelectedItem()).equals("Quarterly")) {
            quarterly = true;
        }
        int increment = 0;
        increment = quarterly ? 4 : 13;
        DefaultTableModel tableModel = (DefaultTableModel)this.snapshotHistoryTable.getModel();
        tableModel.setNumRows(0);
        if (!quarterly) {
            for (int period = 0; period < increment; ++period) {
                Calendar startDate;
                Calendar endDate;
                Calendar cal = (Calendar)calendar.clone();
                cal.add(2, period - increment + 1);
                if (cal.get(5) > LookupServicesUtil.getDBServices().getAccountPreferences().getGenSalesPeriod()) {
                    cal.add(2, 1);
                }
                if (cal.get(2) == 0) {
                    cal.add(2, -1);
                    endDate = (Calendar)cal.clone();
                    endDate.set(5, endDate.getActualMaximum(5));
                    startDate = (Calendar)cal.clone();
                    startDate.set(5, LookupServicesUtil.getDBServices().getAccountPreferences().getGenSalesPeriod());
                    if (endDate.getTimeInMillis() > startDate.getTimeInMillis()) {
                        this.updateExpenseRange(tableModel, startDate, endDate);
                    }
                    cal.add(2, 1);
                    endDate = (Calendar)cal.clone();
                    endDate.set(5, LookupServicesUtil.getDBServices().getAccountPreferences().getGenSalesPeriod() - 1);
                    startDate = (Calendar)cal.clone();
                    startDate.set(5, 1);
                } else {
                    endDate = (Calendar)cal.clone();
                    endDate.set(5, LookupServicesUtil.getDBServices().getAccountPreferences().getGenSalesPeriod() - 1);
                    cal.add(2, -1);
                    startDate = (Calendar)cal.clone();
                    startDate.set(5, LookupServicesUtil.getDBServices().getAccountPreferences().getGenSalesPeriod());
                }
                if (endDate.getTimeInMillis() <= startDate.getTimeInMillis()) continue;
                this.updateExpenseRange(tableModel, startDate, endDate);
            }
        } else {
            Calendar startDate = (Calendar)calendar.clone();
            startDate.add(1, -1);
            startDate.add(2, startDate.get(2) % 3 * -1);
            for (int i = 0; i <= increment; ++i) {
                startDate.set(5, 1);
                Calendar endDate = (Calendar)startDate.clone();
                endDate.add(2, 2);
                endDate.set(5, endDate.getActualMaximum(5));
                if (endDate.getTimeInMillis() > startDate.getTimeInMillis()) {
                    this.updateExpenseRange(tableModel, startDate, endDate);
                }
                startDate.add(2, 3);
            }
        }
        this.disableListener(false);
        this.snapshotRefreshButton.setEnabled(true);
    }

    private void updateExpenseRange(DefaultTableModel tableModel, Calendar startDate, Calendar endDate) {
        try {
            SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
            long searchFrom = startDate.getTimeInMillis();
            long searchTo = endDate.getTimeInMillis();
            String selectedCompany = null;
            if (this.companySelection.getSelectedItem() != null && !this.companySelection.getSelectedItem().toString().equalsIgnoreCase("All")) {
                selectedCompany = this.companySelection.getSelectedItem().toString();
            }
            CompleteOrder[] completeOrders = LookupServicesUtil.getDBServices().getSnapshotOrders(searchFrom, searchTo, selectedCompany);
            Expense[] expenseList = LookupServicesUtil.getDBServices().getSnapshotExpenses(searchFrom, searchTo, selectedCompany);
            this.addSnapshotRow(completeOrders, expenseList, tableModel, df.format(startDate.getTime()), df.format(endDate.getTime()));
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private void addSnapshotRow(CompleteOrder[] completeOrders, Expense[] expenseList, DefaultTableModel tableModel, String startDate, String endDate) {
        int i;
        float sales = 0.0f;
        float expenses = 0.0f;
        for (i = 0; i < completeOrders.length; ++i) {
            try {
                sales += completeOrders[i].getOrder().getOrderTotal() + completeOrders[i].getOrder().getShippingPaid();
                expenses += completeOrders[i].getOrder().getShippingCost();
                float wholesaleCost = 0.0f;
                boolean international = false;
                ArrayList orderDetails = completeOrders[i].getOrderDetails();
                for (OrderDetails orderDetail : orderDetails) {
                    expenses += orderDetail.getItemCost();
                    wholesaleCost += orderDetail.getItemCost();
                }
                if (!(completeOrders[i].getOrder().getCustomer().getCustomerCountry().toLowerCase().equals("united states") || completeOrders[i].getOrder().getCustomer().getCustomerCountry().toLowerCase().equals("usa") || completeOrders[i].getOrder().getCustomer().getCustomerCountry().toLowerCase().equals("us"))) {
                    international = true;
                }
                float paypalfeeTotal = FeeProcessor.getPayPalFees((float)completeOrders[i].getOrder().getOrderTotal(), (float)completeOrders[i].getOrder().getShippingPaid(), (boolean)international);
                expenses += paypalfeeTotal;
                continue;
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        for (i = 0; i < expenseList.length; ++i) {
            expenses += expenseList[i].getExpenseCost();
        }
        float profit = sales - expenses;
        double margin = 0.0;
        if (sales != 0.0f) {
            margin = profit / sales * 100.0f;
        }
        String marginText = (int)margin + "%";
        Object[] row = new Object[tableModel.getColumnCount()];
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yy");
        row[this.snapshotRangeColumn] = startDate + " - " + endDate;
        row[this.snapshotGrossSalesColumn] = String.valueOf(NumberFormat.getCurrencyInstance().format(sales));
        row[this.snapshotExpensesColumn] = String.valueOf(NumberFormat.getCurrencyInstance().format(expenses));
        row[this.snapshotNetProfitColumn] = String.valueOf(NumberFormat.getCurrencyInstance().format(profit));
        row[this.snapshotMarginColumn] = marginText;
        tableModel.addRow(row);
    }

    public void updateExpenseTable() {
        this.disableListener(true);
        this.expenses = 0.0;
        Expense[] expenseList = LookupServicesUtil.getDBServices().getExpenses();
        Arrays.sort(expenseList, new ExpenseComparator());
        DefaultTableModel tableModel = (DefaultTableModel)this.expenseTable.getModel();
        this._expenseMapping.clear();
        tableModel.setNumRows(0);
        String selectedCompany = "All";
        if (this.companySelection.getSelectedItem() != null) {
            selectedCompany = this.companySelection.getSelectedItem().toString();
        }
        for (int i = 0; i < expenseList.length; ++i) {
            if (!expenseList[i].getCompanyName().equalsIgnoreCase(selectedCompany) && !selectedCompany.equalsIgnoreCase("All")) continue;
            Object[] row = new Object[tableModel.getColumnCount()];
            this._expenses.put(expenseList[i].getExpenseID(), expenseList[i]);
            row[this.expenseCompanyColumn] = expenseList[i].getCompanyName();
            row[this.expenseDateColumn] = expenseList[i].getExpenseDate().toString();
            row[this.expenseAmountColumn] = String.valueOf(NumberFormat.getCurrencyInstance().format(expenseList[i].getExpenseCost()));
            this.expenses += (double)expenseList[i].getExpenseCost();
            row[this.expenseReasonColumn] = 0 != expenseList[i].getExpenseReasonID() ? this._expenseReasons.get(expenseList[i].getExpenseReasonID()).getReason() : "Other";
            row[this.expenseCommentsColumn] = expenseList[i].getExpenseComment();
            tableModel.addRow(row);
            this._expenseMapping.add(expenseList[i].getExpenseID());
        }
        this.expenseLabel.setText(String.valueOf(NumberFormat.getCurrencyInstance().format(this.expenses)));
        this.disableListener(false);
    }

    private void updateSalesNeeded(boolean dataChanged) {
        if (!this.applyExpenseButton.isEnabled()) {
            this.refreshButton.setEnabled(!dataChanged);
        }
        this.applySalesButton.setEnabled(dataChanged);
        this.clearSalesButton.setEnabled(dataChanged);
    }

    private void updateExpensesNeeded(boolean dataChanged) {
        if (!this.applySalesButton.isEnabled()) {
            this.refreshButton.setEnabled(!dataChanged);
        }
        this.deleteExpenseButton.setEnabled(!dataChanged);
        this.applyExpenseButton.setEnabled(dataChanged);
        this.clearExpenseButton.setEnabled(dataChanged);
        this.expenseSearchButton.setEnabled(!dataChanged);
        this.validateExpense();
    }

    public void disableListener(boolean disabled) {
        this.disableListener = disabled;
    }

    private void refreshExpenses() {
        long searchFrom = 0L;
        long searchTo = 0L;
        try {
            if (null != this.fromDateChooser.getDate()) {
                searchFrom = this.fromDateChooser.getDate().getTime();
            }
            if (null != this.toDateChooser.getDate()) {
                searchTo = this.toDateChooser.getDate().getTime();
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        this._filteredList.clear();
        for (int i = 0; i < this.currentExpenseFilterList.getModel().getSize(); ++i) {
            if (this.currentExpenseFilterList.getModel().getElementAt(i).equals("All")) {
                this._filteredList.clear();
                i = this.currentExpenseFilterList.getModel().getSize();
                continue;
            }
            this._filteredList.add(this._expenseReasonsList.get(this.currentExpenseFilterList.getModel().getElementAt(i).toString()).getExpenseReasonID());
        }
        if (searchFrom == 0L || searchTo == 0L) {
            JOptionPane.showMessageDialog(null, "Invalid date range. Using last accepted date to refresh data.");
            searchFrom = this.savedFrom;
            searchTo = this.savedTo;
        } else {
            this.savedFrom = searchFrom;
            this.savedTo = searchTo;
        }
        LookupServicesUtil.getDBServices().refreshExpenses(searchFrom, searchTo, this._filteredList, this.expenseSearchField.getText());
    }

    public void LoginToggle() {
        if (SubscriptionManager.getInstance().isFinancialsActive()) {
            if (!this.currentStatus) {
                this.currentStatus = true;
                this.enableAll();
            }
        } else if (this.currentStatus) {
            this.currentStatus = false;
            this.disableAll();
        }
    }

    private void disablePanel(JPanel jPanel) {
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            jPanel.getComponent(i).setEnabled(false);
        }
    }

    private void enablePanel(JPanel jPanel) {
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            jPanel.getComponent(i).setEnabled(true);
        }
    }

    private void enableAll() {
        this.enablePanel(this.financialSnapshotTab);
        this.enablePanel(this.jPanel2);
        this.enablePanel(this.jPanel3);
        this.enablePanel(this.jPanel4);
        this.enablePanel(this.jPanel5);
        this.enablePanel(this.jPanel6);
        this.enablePanel(this.jPanel7);
        this.enablePanel(this.dateRangePanel);
        this.salesTable.setEnabled(true);
        this.expenseTable.setEnabled(true);
        this.trendingTable.setEnabled(true);
        this.snapshotHistoryTable.setEnabled(true);
        this.availableExpenseFilterList.setEnabled(true);
        this.currentExpenseFilterList.setEnabled(true);
        this.expenseTable.setEnabled(true);
        this.clearExpenseButton.setEnabled(false);
        this.deleteExpenseButton.setEnabled(false);
        this.applyExpenseButton.setEnabled(false);
        this.addExpenseButton.setEnabled(false);
        this.addExpenseFilterButton.setEnabled(false);
        this.removeExpenseFilterButton.setEnabled(false);
        this.applySalesButton.setEnabled(false);
        this.expenseSearchField.setEnabled(true);
        this.expenseSearchButton.setEnabled(true);
        this.taxTable.setEnabled(true);
    }

    private void disableAll() {
        this.disablePanel(this.financialSnapshotTab);
        this.disablePanel(this.jPanel2);
        this.disablePanel(this.jPanel3);
        this.disablePanel(this.jPanel4);
        this.disablePanel(this.jPanel5);
        this.disablePanel(this.jPanel6);
        this.disablePanel(this.jPanel7);
        this.disablePanel(this.dateRangePanel);
        this.salesTable.setEnabled(false);
        this.expenseTable.setEnabled(false);
        this.trendingTable.setEnabled(false);
        this.snapshotHistoryTable.setEnabled(false);
        this.availableExpenseFilterList.setEnabled(false);
        this.currentExpenseFilterList.setEnabled(false);
        this.expenseTable.setEnabled(false);
        this.expenseSearchField.setEnabled(false);
        this.expenseSearchButton.setEnabled(false);
        this.taxTable.setEnabled(false);
    }

    private class Taxes {
        String Abbreviation;
        Float Cost;
        Float totalSales;

        public Taxes(Float Cost, String Abbreviation) {
            this.Cost = Cost;
            this.totalSales = Float.valueOf(0.0f);
            this.Abbreviation = Abbreviation;
        }

        public String getAbbreviation() {
            return this.Abbreviation;
        }

        public void setAbbreviation(String Abbreviation) {
            this.Abbreviation = Abbreviation;
        }

        public Float getCost() {
            return this.Cost;
        }

        public void setCost(Float Cost) {
            this.Cost = Cost;
        }

        public Float getTotalSales() {
            return this.totalSales;
        }

        public void setTotalSales(Float totalSales) {
            this.totalSales = totalSales;
        }

        public float getSalesTax() {
            return this.totalSales.floatValue() * this.Cost.floatValue();
        }
    }

    private class DetailedBreakdownItem {
        double grossSales = 0.0;
        double cogs = 0.0;
        String accountName;
        String siteID;

        public String getAccountName() {
            if (this.accountName.isEmpty()) {
                this.accountName = "unknown";
            }
            return this.accountName;
        }

        public void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        public double getCogs() {
            return this.cogs;
        }

        public void setCogs(double cogs) {
            this.cogs = cogs;
        }

        public double getGrossSales() {
            return this.grossSales;
        }

        public void setGrossSales(double grossSales) {
            this.grossSales = grossSales;
        }

        public String getSiteID() {
            return this.siteID;
        }

        public void setSiteID(String siteID) {
            this.siteID = siteID;
        }
    }

    private class ExpensesComboBoxRenderer
    extends JComboBox
    implements TableCellRenderer {
        public ExpensesComboBoxRenderer(String[] reasons) {
            super(reasons);
        }

        @Override
        public void updateUI() {
            super.updateUI();
        }

        @Override
        public void revalidate() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return new JLabel();
            }
            this.removeAllItems();
            this.addItem(value);
            this.setSelectedItem(value);
            return this;
        }
    }

    public class ExpensesComboBoxEditor
    extends DefaultCellEditor {
        public ExpensesComboBoxEditor(String[] items) {
            super(new JComboBox<String>(items));
        }
    }

    public class ExpenseTableListener
    implements TableModelListener {
        @Override
        public void tableChanged(TableModelEvent e) {
            int rowChanged = FinancialSnapshotTopComponent.this.expenseTable.getSelectedRow();
            if (!FinancialSnapshotTopComponent.this._expenseMapping.isEmpty() && !FinancialSnapshotTopComponent.this.disableListener) {
                FinancialSnapshotTopComponent.this.disableListener(true);
                FinancialSnapshotTopComponent.this._updatedExpenses.put(FinancialSnapshotTopComponent.this._expenseMapping.get(rowChanged), FinancialSnapshotTopComponent.this._expenseMapping.get(rowChanged));
                Expense expense = (Expense)FinancialSnapshotTopComponent.this._expenses.get(FinancialSnapshotTopComponent.this._expenseMapping.get(rowChanged));
                TableModel tableData = FinancialSnapshotTopComponent.this.expenseTable.getModel();
                boolean valid = true;
                if (e.getColumn() == FinancialSnapshotTopComponent.this.expenseAmountColumn) {
                    if (!((String)tableData.getValueAt(rowChanged, FinancialSnapshotTopComponent.this.expenseAmountColumn)).equals(String.valueOf(expense.getExpenseCost()))) {
                        if (((String)tableData.getValueAt(rowChanged, FinancialSnapshotTopComponent.this.expenseAmountColumn)).equals("")) {
                            tableData.setValueAt("0.00", rowChanged, FinancialSnapshotTopComponent.this.expenseAmountColumn);
                        }
                        String amount = (String)tableData.getValueAt(rowChanged, FinancialSnapshotTopComponent.this.expenseAmountColumn);
                        if (null != (amount = MathParser.isDollarAmount((String)amount))) {
                            expense.setExpenseCost(Float.valueOf(amount).floatValue());
                            tableData.setValueAt(amount, rowChanged, FinancialSnapshotTopComponent.this.expenseAmountColumn);
                        } else {
                            valid = false;
                        }
                    }
                } else if (e.getColumn() == FinancialSnapshotTopComponent.this.expenseReasonColumn) {
                    expense.setExpenseReasonID(((ExpenseReason)FinancialSnapshotTopComponent.this._expenseReasonsList.get(tableData.getValueAt(rowChanged, FinancialSnapshotTopComponent.this.expenseReasonColumn))).getExpenseReasonID());
                } else if (e.getColumn() == FinancialSnapshotTopComponent.this.expenseCommentsColumn) {
                    expense.setExpenseComment((String)tableData.getValueAt(rowChanged, FinancialSnapshotTopComponent.this.expenseCommentsColumn));
                } else if (e.getColumn() == FinancialSnapshotTopComponent.this.expenseCompanyColumn) {
                    expense.setCompanyName((String)tableData.getValueAt(rowChanged, FinancialSnapshotTopComponent.this.expenseCompanyColumn));
                } else if (e.getColumn() == FinancialSnapshotTopComponent.this.expenseDateColumn) {
                    String date = (String)tableData.getValueAt(rowChanged, FinancialSnapshotTopComponent.this.expenseDateColumn);
                    try {
                        java.sql.Date today;
                        if (date.contains("/") && date.length() == 8) {
                            SimpleDateFormat df = new SimpleDateFormat("MM/dd/yy");
                            today = new java.sql.Date(df.parse(date).getTime());
                        } else if (date.contains("/") && date.length() == 10) {
                            SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
                            today = new java.sql.Date(df.parse(date).getTime());
                        } else if (date.length() == 10) {
                            today = java.sql.Date.valueOf(date);
                        } else {
                            throw new Exception();
                        }
                        expense.setExpenseDate(today);
                    }
                    catch (Exception ex) {
                        ErrorsUtil.getInstance().logError(ex);
                        valid = false;
                    }
                }
                if (valid) {
                    FinancialSnapshotTopComponent.this.updateExpensesNeeded(true);
                }
                FinancialSnapshotTopComponent.this.disableListener(false);
            }
        }
    }

    public class SalesTableListener
    implements TableModelListener {
        @Override
        public void tableChanged(TableModelEvent e) {
            int rowChanged = e.getFirstRow();
            if (!FinancialSnapshotTopComponent.this._salesOrderMapping.isEmpty() && !FinancialSnapshotTopComponent.this.disableListener) {
                FinancialSnapshotTopComponent.this.disableListener(true);
                FinancialSnapshotTopComponent.this._updatedSalesOrders.put(FinancialSnapshotTopComponent.this._salesOrderMapping.get(rowChanged), FinancialSnapshotTopComponent.this._salesOrderMapping.get(rowChanged));
                CompleteOrder completeOrder = (CompleteOrder)FinancialSnapshotTopComponent.this._completeOrders.get(FinancialSnapshotTopComponent.this._salesOrderMapping.get(rowChanged));
                int offset = rowChanged - completeOrder.getRowStart();
                TableModel tableData = FinancialSnapshotTopComponent.this.salesTable.getModel();
                boolean valid = true;
                if (e.getColumn() == FinancialSnapshotTopComponent.this.salesSalesPriceColumn) {
                    if (!((String)tableData.getValueAt(rowChanged, FinancialSnapshotTopComponent.this.salesSalesPriceColumn)).equals(String.valueOf(completeOrder.getOrder().getOrderTotal()))) {
                        if (((String)tableData.getValueAt(rowChanged, FinancialSnapshotTopComponent.this.salesSalesPriceColumn)).equals("")) {
                            tableData.setValueAt("0.00", rowChanged, FinancialSnapshotTopComponent.this.salesSalesPriceColumn);
                        }
                        String amount = (String)tableData.getValueAt(rowChanged, FinancialSnapshotTopComponent.this.salesSalesPriceColumn);
                        if (null != (amount = MathParser.isDollarAmount((String)amount))) {
                            completeOrder.getOrder().setOrderTotal(Float.valueOf(amount).floatValue());
                            tableData.setValueAt(amount, rowChanged, FinancialSnapshotTopComponent.this.salesSalesPriceColumn);
                        } else {
                            valid = false;
                        }
                    }
                } else if (e.getColumn() == FinancialSnapshotTopComponent.this.salesWholesaleCostColumn) {
                    if (!((String)tableData.getValueAt(rowChanged, FinancialSnapshotTopComponent.this.salesWholesaleCostColumn)).equals(String.valueOf(((OrderDetails)completeOrder.getOrderDetails().get(offset)).getItemCost()))) {
                        if (((String)tableData.getValueAt(rowChanged, FinancialSnapshotTopComponent.this.salesWholesaleCostColumn)).equals("")) {
                            tableData.setValueAt("0.00", rowChanged, FinancialSnapshotTopComponent.this.salesWholesaleCostColumn);
                        }
                        String amount = (String)tableData.getValueAt(rowChanged, FinancialSnapshotTopComponent.this.salesWholesaleCostColumn);
                        if (null != (amount = MathParser.isDollarAmount((String)amount))) {
                            ((OrderDetails)completeOrder.getOrderDetails().get(offset)).setItemCost(Float.valueOf(amount).floatValue());
                            tableData.setValueAt(amount, rowChanged, FinancialSnapshotTopComponent.this.salesWholesaleCostColumn);
                        } else {
                            valid = false;
                        }
                    }
                } else if (e.getColumn() == FinancialSnapshotTopComponent.this.salesSHPaidColumn) {
                    if (!((String)tableData.getValueAt(rowChanged, FinancialSnapshotTopComponent.this.salesSHPaidColumn)).equals(String.valueOf(completeOrder.getOrder().getShippingPaid()))) {
                        if (((String)tableData.getValueAt(rowChanged, FinancialSnapshotTopComponent.this.salesSHPaidColumn)).equals("")) {
                            tableData.setValueAt("0.00", rowChanged, FinancialSnapshotTopComponent.this.salesSHPaidColumn);
                        }
                        String amount = (String)tableData.getValueAt(rowChanged, FinancialSnapshotTopComponent.this.salesSHPaidColumn);
                        if (null != (amount = MathParser.isDollarAmount((String)amount))) {
                            completeOrder.getOrder().setShippingPaid(Float.valueOf(amount).floatValue());
                            tableData.setValueAt(amount, rowChanged, FinancialSnapshotTopComponent.this.salesSHPaidColumn);
                        } else {
                            valid = false;
                        }
                    }
                } else if (e.getColumn() == FinancialSnapshotTopComponent.this.salesSHCostColumn && !((String)tableData.getValueAt(rowChanged, FinancialSnapshotTopComponent.this.salesSHCostColumn)).equals(String.valueOf(completeOrder.getOrder().getShippingCost()))) {
                    if (((String)tableData.getValueAt(rowChanged, FinancialSnapshotTopComponent.this.salesSHCostColumn)).equals("")) {
                        tableData.setValueAt("0.00", rowChanged, FinancialSnapshotTopComponent.this.salesSHCostColumn);
                    }
                    String amount = (String)tableData.getValueAt(rowChanged, FinancialSnapshotTopComponent.this.salesSHCostColumn);
                    if (null != (amount = MathParser.isDollarAmount((String)amount))) {
                        completeOrder.getOrder().setShippingCost(Float.valueOf(amount).floatValue());
                        tableData.setValueAt(amount, rowChanged, FinancialSnapshotTopComponent.this.salesSHCostColumn);
                    } else {
                        valid = false;
                    }
                }
                if (valid) {
                    FinancialSnapshotTopComponent.this.updateSalesNeeded(true);
                }
                FinancialSnapshotTopComponent.this.disableListener(false);
            }
        }
    }

    class OrderDetailsTableCellEditor
    extends DefaultCellEditor {
        JTextField jtf;

        public OrderDetailsTableCellEditor() {
            super(new JTextField());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Component c = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (c instanceof JTextField) {
                this.jtf = (JTextField)c;
                this.jtf.selectAll();
            }
            return c;
        }
    }

    private class TrendComparator
    implements Comparator {
        private TrendComparator() {
        }

        public int compare(Object o1, Object o2) {
            boolean returnValue = false;
            TrendObject trendObject1 = (TrendObject)o1;
            TrendObject trendObject2 = (TrendObject)o2;
            if (trendObject1.getQuantity() > trendObject2.getQuantity()) {
                return -1;
            }
            if (trendObject1.getQuantity() < trendObject2.getQuantity()) {
                return 1;
            }
            return 0;
        }
    }

    private class TrendObject {
        String productId;
        int quantity;

        public TrendObject(String productId) {
            this.productId = productId;
            this.quantity = 1;
        }

        public String getProductId() {
            return this.productId;
        }

        public void setProductId(String productId) {
            this.productId = productId;
        }

        public int getQuantity() {
            return this.quantity;
        }

        public void setQuantity(int quantity) {
            this.quantity = quantity;
        }
    }

    private class CellColorRenderer
    extends DefaultTableCellRenderer {
        private CellColorRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (table.equals(FinancialSnapshotTopComponent.this.salesTable)) {
                String formattedValue;
                if (column == FinancialSnapshotTopComponent.this.salesNetProfitColumn) {
                    formattedValue = MathParser.isDollarAmount((String)((String)value));
                    if (null != formattedValue) {
                        if (Double.valueOf(formattedValue) < 0.0) {
                            c.setForeground(Color.RED);
                        } else {
                            c.setForeground(new Color(0, 128, 0));
                        }
                    }
                } else if (column == FinancialSnapshotTopComponent.this.salesSalesPriceColumn || column == FinancialSnapshotTopComponent.this.salesWholesaleCostColumn || column == FinancialSnapshotTopComponent.this.salesSHCostColumn) {
                    formattedValue = MathParser.isDollarAmount((String)((String)value));
                    if (null != formattedValue) {
                        if (Double.valueOf(formattedValue) == 0.0) {
                            c.setForeground(Color.RED);
                        } else {
                            c.setForeground(Color.black);
                        }
                    }
                } else {
                    c.setForeground(Color.black);
                }
            } else if (table.equals(FinancialSnapshotTopComponent.this.expenseTable)) {
                if (column == FinancialSnapshotTopComponent.this.expenseAmountColumn) {
                    c.setForeground(Color.red);
                } else {
                    c.setForeground(Color.black);
                }
            } else if (table.equals(FinancialSnapshotTopComponent.this.trendingTable)) {
                c.setForeground(Color.black);
            } else if (table.equals(FinancialSnapshotTopComponent.this.snapshotHistoryTable)) {
                if (column == FinancialSnapshotTopComponent.this.snapshotGrossSalesColumn || column == FinancialSnapshotTopComponent.this.snapshotNetProfitColumn || column == FinancialSnapshotTopComponent.this.snapshotMarginColumn) {
                    c.setForeground(new Color(FrameConstants.CHANGED_CELL));
                } else if (column == FinancialSnapshotTopComponent.this.snapshotExpensesColumn) {
                    c.setForeground(Color.red);
                } else {
                    c.setForeground(Color.black);
                }
            }
            if (table.getSelectedColumn() == column && table.getSelectedRow() == row) {
                this.setBackground(Color.lightGray);
                return c;
            }
            for (int selectedRow : table.getSelectedRows()) {
                if (row != selectedRow) continue;
                this.setBackground(Color.gray);
                return c;
            }
            this.setBackground(Color.white);
            return c;
        }
    }

    class ValueComparator
    implements Comparator<String> {
        Map<String, Integer> base;

        public ValueComparator(Map<String, Integer> base) {
            this.base = base;
        }

        @Override
        public int compare(String a, String b) {
            if (this.base.get(a) >= this.base.get(b)) {
                return -1;
            }
            return 1;
        }
    }

    private class DateFocusListener
    implements FocusListener {
        private DateFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            FinancialSnapshotTopComponent.this.validateExpense();
        }

        @Override
        public void focusGained(FocusEvent e) {
            FinancialSnapshotTopComponent.this.validateExpense();
        }
    }
}

