/*
 * Decompiled with CFR 0.152.
 */
package pnp.managers.inventory;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.openide.util.NbBundle;
import pnp.services.compare.InventoryComparator;
import pnp.services.constants.FrameConstants;
import pnp.services.datatypes.Distributor;
import pnp.services.datatypes.InventoryElement;
import pnp.services.datatypes.Item;
import pnp.services.util.LookupServicesUtil;

public class InventorySelectionForm
extends JDialog
implements MouseListener {
    private JButton cancelButton;
    private JButton finishButton;
    private JLabel importItemLabel;
    private JTable inventorySelectionTable;
    private JLabel itemIdField;
    private JPanel jPanel1;
    private JScrollPane jScrollPane4;
    private HashMap<Integer, Distributor> _distributorList;
    private HashMap<Integer, InventoryElement> _inventoryElements;
    private ArrayList<Integer> _inventoryMapping;
    private HashMap<String, Distributor> _distributorStringList;
    private InventoryElement _selectedItem;
    private int inventoryItemIDColumn = 0;
    private int inventoryItemNameColumn = 1;
    private int inventoryQuantityColumn = 2;
    private int inventoryWholesalePriceColumn = 3;
    private int inventoryWeightColumn = 4;
    private int inventoryPackedWeightColumn = 5;
    private int inventoryLocationColumn = 6;
    private int inventoryDistributorColumn = 7;
    private int inventoryInhouseColumn = 8;
    private String _itemName;

    public InventorySelectionForm(Frame parent, boolean modal, String itemName) {
        super(parent, modal);
        this.initComponents();
        this._itemName = itemName;
        this.init();
    }

    private void init() {
        this.itemIdField.setText(this._itemName);
        this.inventoryItemIDColumn = this.inventorySelectionTable.getColumnModel().getColumnIndex("Item ID");
        this.inventoryItemNameColumn = this.inventorySelectionTable.getColumnModel().getColumnIndex("Item Name");
        this.inventoryQuantityColumn = this.inventorySelectionTable.getColumnModel().getColumnIndex("Quantity");
        this.inventoryWholesalePriceColumn = this.inventorySelectionTable.getColumnModel().getColumnIndex("Wholesale Price");
        this.inventoryWeightColumn = this.inventorySelectionTable.getColumnModel().getColumnIndex("Weight");
        this.inventoryPackedWeightColumn = this.inventorySelectionTable.getColumnModel().getColumnIndex("Packed Weight");
        this.inventoryLocationColumn = this.inventorySelectionTable.getColumnModel().getColumnIndex("Location");
        this.inventoryDistributorColumn = this.inventorySelectionTable.getColumnModel().getColumnIndex("Distributor");
        this.inventoryInhouseColumn = this.inventorySelectionTable.getColumnModel().getColumnIndex("Inventory");
        for (int i = 0; i < this.inventorySelectionTable.getColumnCount(); ++i) {
            this.inventorySelectionTable.setDefaultRenderer(this.inventorySelectionTable.getColumnClass(i), new CellColorRenderer());
        }
        TableColumn col = this.inventorySelectionTable.getColumnModel().getColumn(this.inventoryInhouseColumn);
        JCheckBox inhouseCheckBox = new JCheckBox();
        inhouseCheckBox.setHorizontalAlignment(0);
        col.setCellEditor(new DefaultCellEditor(inhouseCheckBox));
        col.setCellRenderer(new CheckBoxRenderer(false));
        this._selectedItem = null;
        this.finishButton.setEnabled(false);
        this.inventorySelectionTable.addMouseListener(this);
        this._distributorList = new HashMap();
        this._distributorStringList = new HashMap();
        this._inventoryMapping = new ArrayList();
        this._inventoryElements = new HashMap();
        Distributor[] distributors = LookupServicesUtil.getDBServices().getDistributors();
        for (int i = 0; i < distributors.length; ++i) {
            this._distributorStringList.put(distributors[i].getDistributorName(), distributors[i]);
            this._distributorList.put(distributors[i].getDistributorID(), distributors[i]);
        }
        this.updateInventoryList();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.finishButton = new JButton();
        this.cancelButton = new JButton();
        this.jScrollPane4 = new JScrollPane();
        this.inventorySelectionTable = new JTable();
        this.importItemLabel = new JLabel();
        this.itemIdField = new JLabel();
        this.setDefaultCloseOperation(2);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.jPanel1.border.title")));
        this.finishButton.setText(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.finishButton.text"));
        this.finishButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InventorySelectionForm.this.finishButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.cancelButton.text"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InventorySelectionForm.this.cancelButtonActionPerformed(evt);
            }
        });
        this.inventorySelectionTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}}, new String[]{"Item ID", "Item Name", "Quantity", "Wholesale Price", "Weight", "Packed Weight", "Location", "Distributor", "Inventory"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, Boolean.class};
                this.canEdit = new boolean[]{false, false, false, false, false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.inventorySelectionTable.setColumnSelectionAllowed(true);
        this.inventorySelectionTable.setSelectionMode(0);
        this.jScrollPane4.setViewportView(this.inventorySelectionTable);
        this.inventorySelectionTable.getColumnModel().getSelectionModel().setSelectionMode(0);
        this.inventorySelectionTable.getColumnModel().getColumn(0).setHeaderValue(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.inventorySelectionTable.columnModel.title0"));
        this.inventorySelectionTable.getColumnModel().getColumn(1).setHeaderValue(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.inventorySelectionTable.columnModel.title1"));
        this.inventorySelectionTable.getColumnModel().getColumn(2).setHeaderValue(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.inventorySelectionTable.columnModel.title2"));
        this.inventorySelectionTable.getColumnModel().getColumn(3).setHeaderValue(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.inventorySelectionTable.columnModel.title3"));
        this.inventorySelectionTable.getColumnModel().getColumn(4).setHeaderValue(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.inventorySelectionTable.columnModel.title4"));
        this.inventorySelectionTable.getColumnModel().getColumn(5).setHeaderValue(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.inventorySelectionTable.columnModel.title8"));
        this.inventorySelectionTable.getColumnModel().getColumn(6).setHeaderValue(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.inventorySelectionTable.columnModel.title5"));
        this.inventorySelectionTable.getColumnModel().getColumn(7).setHeaderValue(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.inventorySelectionTable.columnModel.title6"));
        this.inventorySelectionTable.getColumnModel().getColumn(8).setHeaderValue(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.inventorySelectionTable.columnModel.title7"));
        this.importItemLabel.setText(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.importItemLabel.text"));
        this.itemIdField.setText(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.itemIdField.text"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(867, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.importItemLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.itemIdField)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.finishButton))).addGap(6, 6, 6)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane4, -2, 832, -2).addContainerGap(217, Short.MAX_VALUE))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.importItemLabel).addComponent(this.itemIdField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 376, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.finishButton).addComponent(this.cancelButton))).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane4, -1, 413, Short.MAX_VALUE))));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void finishButtonActionPerformed(ActionEvent evt) {
        if (this.inventorySelectionTable.getSelectedRow() != -1) {
            this._selectedItem = this._inventoryElements.get(this._inventoryMapping.get(this.inventorySelectionTable.getSelectedRow()));
        }
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this._selectedItem = null;
        this.setVisible(false);
    }

    public InventoryElement getSelectedItem() {
        return this._selectedItem;
    }

    private void updateInventoryList() {
        Object[] row;
        Collection inventoryList = LookupServicesUtil.getDBServices().getInventoryList(this._itemName, false, false, false, new String[0], false);
        DefaultTableModel tableModel = (DefaultTableModel)this.inventorySelectionTable.getModel();
        tableModel.setNumRows(0);
        Iterator iter = inventoryList.iterator();
        ArrayList<InventoryElement> prunedList = new ArrayList<InventoryElement>();
        while (iter.hasNext()) {
            boolean found = false;
            ArrayList inventoryItem = (ArrayList)iter.next();
            row = new Object[tableModel.getColumnCount()];
            InventoryElement inventoryElement = new InventoryElement();
            for (int i = 1; i < inventoryItem.size(); ++i) {
                InventoryElement tempElement = (InventoryElement)inventoryItem.get(i);
                if (tempElement.getItemQuantity() <= 0) continue;
                if (found) {
                    if (!(tempElement.getItemCost() < inventoryElement.getItemCost())) continue;
                    inventoryElement = tempElement;
                    continue;
                }
                inventoryElement = tempElement;
                found = true;
            }
            if (!found) {
                inventoryElement = (InventoryElement)inventoryItem.get(0);
            }
            prunedList.add(inventoryElement);
        }
        InventoryElement[] sortedList = prunedList.toArray(new InventoryElement[0]);
        Arrays.sort(sortedList, new InventoryComparator(InventoryComparator.ITEM_ID));
        for (int i = 0; i < sortedList.length; ++i) {
            row = new Object[tableModel.getColumnCount()];
            this._inventoryElements.put(sortedList[i].getInventoryID(), sortedList[i]);
            row[this.inventoryItemIDColumn] = sortedList[i].getItemID();
            Item item = LookupServicesUtil.getDBServices().getItem(sortedList[i].getItemID());
            if (null != item) {
                row[this.inventoryItemNameColumn] = item.getItemName();
                row[this.inventoryWeightColumn] = String.valueOf(item.getItemWeight());
                row[this.inventoryPackedWeightColumn] = String.valueOf(item.getPackedWeight());
                row[this.inventoryLocationColumn] = item.getLocation();
                row[this.inventoryInhouseColumn] = !item.isDropShipped();
                row[this.inventoryDistributorColumn] = this._distributorList.containsKey(item.getDistributorID()) ? this._distributorList.get(item.getDistributorID()).getDistributorName() : "";
            }
            row[this.inventoryQuantityColumn] = String.valueOf(sortedList[i].getItemQuantity());
            row[this.inventoryWholesalePriceColumn] = String.valueOf(sortedList[i].getItemCost());
            tableModel.addRow(row);
            this._inventoryMapping.add(sortedList[i].getInventoryID());
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        if (this.inventorySelectionTable.getSelectedRow() != -1) {
            this.finishButton.setEnabled(true);
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    private class CellColorRenderer
    extends DefaultTableCellRenderer {
        private CellColorRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (table.getSelectedRow() == row) {
                this.setBackground(new Color(FrameConstants.SELECTED_ROW));
                return c;
            }
            if (row % 2 == 0) {
                this.setBackground(new Color(FrameConstants.ROW_COLOR_1));
            } else {
                this.setBackground(new Color(FrameConstants.ROW_COLOR_2));
            }
            return c;
        }
    }

    private class CheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public CheckBoxRenderer(boolean value) {
            super("", value);
        }

        @Override
        public void updateUI() {
            super.updateUI();
        }

        @Override
        public void revalidate() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setSelected(value != null && (Boolean)value != false);
            this.setHorizontalAlignment(0);
            if (table.getSelectedRow() == row) {
                this.setBackground(new Color(FrameConstants.SELECTED_ROW));
                return this;
            }
            if (row % 2 == 0) {
                this.setBackground(new Color(FrameConstants.ROW_COLOR_1));
            } else {
                this.setBackground(new Color(FrameConstants.ROW_COLOR_2));
            }
            return this;
        }
    }
}

