/*
 * Decompiled with CFR 0.152.
 */
package pnp.managers.inventory;

import com.ebay.marketplace.search.v1.services.SearchItem;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import pnp.services.datatypes.InventoryElement;
import pnp.services.table.FormattedXTable;
import pnp.services.util.ErrorsUtil;
import pnp.services.util.LookupServicesUtil;

public class ItemFinder
extends JDialog {
    private boolean refresh;
    private boolean match;
    private boolean cancelSearch;
    private HashMap<String, InventoryElement> _inventoryElements;
    private HashMap<String, TreeMap<Float, ArrayList<SearchItem>>> _resultList;
    private FormattedXTable formattedItemFinderTable;
    private JButton jButton1;
    private JTextField jTextField1;
    private JTextField jTextField2;

    public ItemFinder(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.init();
    }

    private void init() {
        this.cancelSearch = false;
        this._resultList = new HashMap();
        this.formattedItemFinderTable.init(new String[]{"Item SKU", "Item Title", "Item Price", "Beatable Gallery Picture", "Beatable Price", "Beatable Title", "Beatable URL"}, "ITEMFINDER", null);
        this.formattedItemFinderTable.getFormattedTable().setEnabled(false);
        this.formattedItemFinderTable.getFormattedTable().setSortable(false);
        this.createParsedList();
        this.createTable();
        this.formattedItemFinderTable.loadSavedSettings();
    }

    private void createTable() {
        this.refresh = false;
        this.match = false;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ItemFinder.this.refreshTable();
                }
                catch (Exception ex) {
                    ErrorsUtil.getInstance().logError(ex);
                }
            }
        }).start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ItemFinder.this.findMatches();
                }
                catch (Exception ex) {
                    ErrorsUtil.getInstance().logError(ex);
                }
            }
        }).start();
    }

    private void createParsedList() {
        this._inventoryElements = new HashMap();
        for (ArrayList elementList : LookupServicesUtil.getDBServices().getInventoryList()) {
            InventoryElement combinedElement = new InventoryElement();
            for (InventoryElement element : elementList) {
                if (element.getItem() != null) {
                    combinedElement.setItem(element.getItem());
                }
                combinedElement.setItemCost(element.getItemCost());
                combinedElement.setItemID(element.getItemID());
                combinedElement.setItemQuantity(combinedElement.getItemQuantity() + element.getItemQuantity());
            }
            this._inventoryElements.put(combinedElement.getItemID(), combinedElement);
        }
    }

    private void refreshTable() {
        this.formattedItemFinderTable.getTableModel().setRowCount(0);
        for (InventoryElement element : this._inventoryElements.values()) {
            Object[] row = new Object[this.formattedItemFinderTable.getTableModel().getColumnCount()];
            row[((Integer)this.formattedItemFinderTable.getReverseColumnMap().get((Object)"Item SKU")).intValue()] = element.getItemID();
            row[((Integer)this.formattedItemFinderTable.getReverseColumnMap().get((Object)"Item Title")).intValue()] = element.getItem().getItemName();
            row[((Integer)this.formattedItemFinderTable.getReverseColumnMap().get((Object)"Item Price")).intValue()] = Float.valueOf(element.getItemCost());
            this.formattedItemFinderTable.getTableModel().addRow(row);
        }
        this.refresh = true;
        this.enableTable();
    }

    private void findMatches() {
        int counter = 0;
        for (InventoryElement element : this._inventoryElements.values()) {
            if (this.cancelSearch) break;
            this._resultList.put(element.getItemID(), this.createHashMap(LookupServicesUtil.getEbayServices().findItem(element.getItem().getItemName(), Float.valueOf(element.getItemCost()), 50)));
            if (!this.fillCompetition(element.getItemID(), counter)) continue;
            ++counter;
        }
        this.match = true;
        this.enableTable();
    }

    private boolean fillCompetition(String item, int row) {
        if (this._resultList.containsKey(item)) {
            TreeMap<Float, ArrayList<SearchItem>> individualResults = this._resultList.get(item);
            Float higherPrice = individualResults.higherKey(Float.valueOf(this._inventoryElements.get(item).getItemCost() + 2.0f));
            if (higherPrice != null) {
                ArrayList<SearchItem> searchItems = individualResults.get(higherPrice);
                if (!searchItems.isEmpty()) {
                    SearchItem searchItem = searchItems.get(0);
                    this.formattedItemFinderTable.setValue((Object)searchItem.getGalleryURL(), row, "Beatable Gallery Picture");
                    this.formattedItemFinderTable.setValue((Object)higherPrice, row, "Beatable Price");
                    this.formattedItemFinderTable.setValue((Object)searchItem.getItemId(), row, "Beatable Title");
                    this.formattedItemFinderTable.setValue((Object)searchItem.getViewItemURL(), row, "Beatable URL");
                    return true;
                }
            } else {
                this.formattedItemFinderTable.getTableModel().removeRow(row);
            }
        }
        return false;
    }

    private TreeMap<Float, ArrayList<SearchItem>> createHashMap(ArrayList<SearchItem> searchResults) {
        TreeMap<Float, ArrayList<SearchItem>> hashedResults = new TreeMap<Float, ArrayList<SearchItem>>();
        for (SearchItem searchItem : searchResults) {
            Float price = Float.valueOf(0.0f);
            if (searchItem.getShippingInfo() != null && searchItem.getShippingInfo().getShippingServiceCost() != null) {
                price = Float.valueOf(price.floatValue() + (float)searchItem.getShippingInfo().getShippingServiceCost().getValue());
            }
            if (!((double)(price = Float.valueOf(price.floatValue() + (float)searchItem.getListingInfo().getBuyItNowPrice().getValue())).floatValue() > 0.01)) continue;
            if (!hashedResults.containsKey(price)) {
                hashedResults.put(price, new ArrayList());
            }
            hashedResults.get(price).add(searchItem);
        }
        return hashedResults;
    }

    private void enableTable() {
        if (this.refresh && this.match) {
            this.formattedItemFinderTable.getFormattedTable().setEnabled(true);
            this.formattedItemFinderTable.getFormattedTable().setSortable(true);
        } else {
            this.formattedItemFinderTable.getFormattedTable().setEnabled(false);
            this.formattedItemFinderTable.getFormattedTable().setSortable(false);
        }
    }

    public void setCancelSearch(boolean cancelSearch) {
        this.cancelSearch = cancelSearch;
    }

    private void initComponents() {
        this.formattedItemFinderTable = new FormattedXTable();
        this.jButton1 = new JButton();
        this.jTextField1 = new JTextField();
        this.jTextField2 = new JTextField();
        this.setDefaultCloseOperation(2);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(ItemFinder.class, (String)"ItemFinder.jButton1.text"));
        this.jTextField1.setText(NbBundle.getMessage(ItemFinder.class, (String)"ItemFinder.jTextField1.text"));
        this.jTextField2.setText(NbBundle.getMessage(ItemFinder.class, (String)"ItemFinder.jTextField2.text"));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.formattedItemFinderTable, GroupLayout.Alignment.TRAILING, -1, 922, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jTextField2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(20, 20, 20).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jTextField2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.formattedItemFinderTable, -1, 451, Short.MAX_VALUE)));
        this.pack();
    }
}

