/*
 * Decompiled with CFR 0.152.
 */
package pnp.managers.inventory;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import pnp.services.datatypes.Distributor;
import pnp.services.datatypes.InventoryElement;
import pnp.services.datatypes.Item;
import pnp.services.table.FormattedXTable;
import pnp.services.util.LookupServicesUtil;
import pnp.services.util.MathParser;

public class MassEditForm
extends JDialog {
    ArrayList<InventoryElement> elementList;
    private HashMap<Integer, Distributor> _distributorList;
    private JButton cancel;
    private JButton changeSelected;
    private FormattedXTable formattedMassEditTable;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JCheckBox locationActive;
    private JTextField locationBox;
    private JCheckBox packedWeightActive;
    private JTextField packedWeightBox;
    private JCheckBox priceActive;
    private JTextField priceBox;
    private JCheckBox weightActive;
    private JTextField weightBox;

    public MassEditForm(Frame parent, boolean modal, ArrayList<InventoryElement> elementList) {
        super(parent, modal);
        this.initComponents();
        this.elementList = elementList;
        this.init();
    }

    private void init() {
        this._distributorList = new HashMap();
        this.formattedMassEditTable.init(new String[]{"Item ID", "Reference ID", "Item Name", "Quantity", "Wholesale Price", "Weight", "Packed Weight", "Location", "Distributor", "Inventory", "Discontinued", "Stock Date"}, "MASSEDIT", null);
        Object[] distributors = this.refreshDistributors().keySet().toArray(new String[0]);
        Arrays.sort(distributors);
        this.formattedMassEditTable.createCheckBox("Inventory");
        this.formattedMassEditTable.createCheckBox("Discontinued");
        this.formattedMassEditTable.overwriteCellDefault("Distributor", (String[])distributors);
        this.formattedMassEditTable.getFormattedTable().setShowGrid(true);
        this.formattedMassEditTable.getFormattedTable().setEnabled(false);
        this.refreshTable();
        this.formattedMassEditTable.loadSavedSettings();
    }

    private void refreshTable() {
        for (InventoryElement element : this.elementList) {
            Object[] row = new Object[this.formattedMassEditTable.getTableModel().getColumnCount()];
            Item item = LookupServicesUtil.getDBServices().getItem(element.getItemID());
            element.setItem(item);
            row[((Integer)this.formattedMassEditTable.getReverseColumnMap().get((Object)"Item ID")).intValue()] = element.getItemID();
            if (null != item) {
                row[((Integer)this.formattedMassEditTable.getReverseColumnMap().get((Object)"Reference ID")).intValue()] = item.getDistributorProductID();
                row[((Integer)this.formattedMassEditTable.getReverseColumnMap().get((Object)"Item Name")).intValue()] = item.getItemName();
                row[((Integer)this.formattedMassEditTable.getReverseColumnMap().get((Object)"Weight")).intValue()] = String.valueOf(item.getItemWeight());
                row[((Integer)this.formattedMassEditTable.getReverseColumnMap().get((Object)"Packed Weight")).intValue()] = String.valueOf(item.getPackedWeight());
                row[((Integer)this.formattedMassEditTable.getReverseColumnMap().get((Object)"Location")).intValue()] = item.getLocation();
                row[((Integer)this.formattedMassEditTable.getReverseColumnMap().get((Object)"Inventory")).intValue()] = !item.isDropShipped();
                row[((Integer)this.formattedMassEditTable.getReverseColumnMap().get((Object)"Discontinued")).intValue()] = item.isDiscontinued();
                row[((Integer)this.formattedMassEditTable.getReverseColumnMap().get((Object)"Distributor")).intValue()] = this._distributorList.containsKey(item.getDistributorID()) ? this._distributorList.get(item.getDistributorID()).getDistributorName() : "";
            }
            if (null != element.getStockDate()) {
                row[((Integer)this.formattedMassEditTable.getReverseColumnMap().get((Object)"Stock Date")).intValue()] = element.getStockDate().toString();
            }
            row[((Integer)this.formattedMassEditTable.getReverseColumnMap().get((Object)"Quantity")).intValue()] = String.valueOf(element.getItemQuantity());
            row[((Integer)this.formattedMassEditTable.getReverseColumnMap().get((Object)"Wholesale Price")).intValue()] = String.valueOf(element.getItemCost());
            this.formattedMassEditTable.getTableModel().addRow(row);
        }
    }

    private HashMap<String, Distributor> refreshDistributors() {
        HashMap<String, Distributor> distributorList = new HashMap<String, Distributor>();
        for (Distributor distributor : LookupServicesUtil.getDBServices().getDistributors()) {
            distributorList.put(distributor.getDistributorName(), distributor);
            this._distributorList.put(distributor.getDistributorID(), distributor);
        }
        return distributorList;
    }

    private float createDollarAmount(Object value) {
        if ((value = MathParser.isDollarAmount((String)value.toString())) != null) {
            value = Double.parseDouble(value.toString());
        }
        if (value == null) {
            value = Float.valueOf(0.0f);
        }
        return Float.parseFloat(value.toString());
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.locationActive = new JCheckBox();
        this.locationBox = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.weightBox = new JTextField();
        this.weightActive = new JCheckBox();
        this.packedWeightActive = new JCheckBox();
        this.packedWeightBox = new JTextField();
        this.jLabel4 = new JLabel();
        this.jLabel3 = new JLabel();
        this.priceBox = new JTextField();
        this.priceActive = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.formattedMassEditTable = new FormattedXTable();
        this.jPanel4 = new JPanel();
        this.changeSelected = new JButton();
        this.cancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(MassEditForm.class, (String)"MassEditForm.jPanel1.border.title")));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(MassEditForm.class, (String)"MassEditForm.jPanel2.border.title")));
        Mnemonics.setLocalizedText((AbstractButton)this.locationActive, (String)NbBundle.getMessage(MassEditForm.class, (String)"MassEditForm.locationActive.text"));
        this.locationBox.setText(NbBundle.getMessage(MassEditForm.class, (String)"MassEditForm.locationBox.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(MassEditForm.class, (String)"MassEditForm.jLabel1.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(MassEditForm.class, (String)"MassEditForm.jLabel2.text"));
        this.weightBox.setText(NbBundle.getMessage(MassEditForm.class, (String)"MassEditForm.weightBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.weightActive, (String)NbBundle.getMessage(MassEditForm.class, (String)"MassEditForm.weightActive.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.packedWeightActive, (String)NbBundle.getMessage(MassEditForm.class, (String)"MassEditForm.packedWeightActive.text"));
        this.packedWeightBox.setText(NbBundle.getMessage(MassEditForm.class, (String)"MassEditForm.packedWeightBox.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(MassEditForm.class, (String)"MassEditForm.jLabel4.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(MassEditForm.class, (String)"MassEditForm.jLabel3.text"));
        this.priceBox.setText(NbBundle.getMessage(MassEditForm.class, (String)"MassEditForm.priceBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.priceActive, (String)NbBundle.getMessage(MassEditForm.class, (String)"MassEditForm.priceActive.text"));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.priceBox, -2, 71, -2).addComponent(this.locationBox, -2, 71, -2).addComponent(this.packedWeightBox, -2, 71, -2).addComponent(this.weightBox, -2, 71, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.locationActive).addComponent(this.weightActive).addComponent(this.packedWeightActive).addComponent(this.priceActive)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.locationBox, -2, -1, -2).addComponent(this.locationActive)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.weightBox, -2, -1, -2).addComponent(this.weightActive)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.packedWeightBox, -2, -1, -2).addComponent(this.packedWeightActive)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.priceBox, -2, -1, -2).addComponent(this.priceActive)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(MassEditForm.class, (String)"MassEditForm.jPanel3.border.title")));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent((Component)this.formattedMassEditTable, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap().addComponent((Component)this.formattedMassEditTable, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(MassEditForm.class, (String)"MassEditForm.jPanel4.border.title")));
        Mnemonics.setLocalizedText((AbstractButton)this.changeSelected, (String)NbBundle.getMessage(MassEditForm.class, (String)"MassEditForm.changeSelected.text"));
        this.changeSelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MassEditForm.this.changeSelectedActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cancel, (String)NbBundle.getMessage(MassEditForm.class, (String)"MassEditForm.cancel.text"));
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MassEditForm.this.cancelActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.changeSelected).addComponent(this.cancel)).addContainerGap(81, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.changeSelected).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancel).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 455, Short.MAX_VALUE).addComponent(this.jPanel4, -2, -1, -2))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void changeSelectedActionPerformed(ActionEvent evt) {
        String location = null;
        Float weight = Float.valueOf(-1.0f);
        Float packedWeight = Float.valueOf(-1.0f);
        Float price = Float.valueOf(-1.0f);
        boolean changed = false;
        String test = this.locationBox.getText();
        if (this.locationActive.isSelected() && this.locationBox.getText() != null && !this.locationBox.getText().isEmpty()) {
            location = this.locationBox.getText();
            changed = true;
        }
        if (this.weightActive.isSelected() && this.weightBox.getText() != null && !this.weightBox.getText().isEmpty()) {
            weight = Float.valueOf(this.createDollarAmount(this.weightBox.getText()));
            changed = true;
        }
        if (this.packedWeightActive.isSelected() && this.packedWeightBox.getText() != null && !this.packedWeightBox.getText().isEmpty()) {
            packedWeight = Float.valueOf(this.createDollarAmount(this.packedWeightBox.getText()));
            changed = true;
        }
        if (this.priceActive.isSelected() && this.priceBox.getText() != null && !this.priceBox.getText().isEmpty()) {
            price = Float.valueOf(this.createDollarAmount(this.priceBox.getText()));
            changed = true;
        }
        if (changed) {
            for (InventoryElement element : this.elementList) {
                if (location != null) {
                    element.getItem().setLocation(location);
                }
                if (weight.floatValue() >= 0.0f) {
                    element.getItem().setItemWeight(weight.floatValue());
                }
                if (packedWeight.floatValue() >= 0.0f) {
                    element.getItem().setPackedWeight(packedWeight.floatValue());
                }
                if (price.floatValue() >= 0.0f) {
                    element.setItemCost(price.floatValue());
                }
                LookupServicesUtil.getDBServices().setInventoryElement(element);
                LookupServicesUtil.getDBServices().setItem(element.getItem());
            }
            this.setVisible(false);
        } else {
            JOptionPane.showMessageDialog(null, "You must select at least one field to use for this edit. If you do not want to edit these items, please press cancel.");
        }
    }
}

