/*
 * Decompiled with CFR 0.152.
 */
package pnp.managers.inventory;

import com.toedter.calendar.JDateChooser;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.util.NbBundle;
import pnp.services.datatypes.Distributor;
import pnp.services.datatypes.InventoryElement;
import pnp.services.datatypes.Item;
import pnp.services.table.FormattedXTable;
import pnp.services.util.ErrorsUtil;
import pnp.services.util.GenericFunctions;
import pnp.services.util.LookupServicesUtil;
import pnp.services.util.MathParser;

public class ReorderForm
extends JDialog
implements ListSelectionListener {
    private HashMap<Integer, String> distNameList;
    private HashMap<String, HashMap<String, Integer>> improvedSalesHistory;
    private JCheckBox exactMatch;
    private JButton finishButton;
    private FormattedXTable formattedReorderTable;
    private FormattedXTable formattedSalesHistoryTable;
    private JDateChooser fromDateChooser;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JButton refreshButton;
    private JTextField stockQtyTextField;
    private JTextField stockSupplyTxtField;
    private JDateChooser toDateChooser;
    private JCheckBox wasSoldCheckBox;
    private HashMap<String, String> _remainingNumber;
    private HashMap<String, String> _restockNumber;
    private HashMap<String, String> _soldNumber;
    private boolean _disableListener = false;

    public ReorderForm(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.init();
    }

    private void createTables() {
        this.formattedReorderTable.init(new String[]{"Item ID", "Reference ID", "Item Name", "Sold", "Remaining", "Restock Amount", "Wholesale Cost", "Inventory", "Distributor"}, "ReorderForm", new String[]{"Distributor"});
        Distributor[] distributors = LookupServicesUtil.getDBServices().getDistributors();
        ArrayList<String> distList = new ArrayList<String>();
        this.distNameList = new HashMap();
        for (Distributor dist : distributors) {
            distList.add(dist.getDistributorName());
            this.distNameList.put(dist.getDistributorID(), dist.getDistributorName());
        }
        Object[] distString = distList.toArray(new String[0]);
        Arrays.sort(distString);
        this.formattedReorderTable.overwriteCellDefault("Distributor", (String[])distString);
        this.formattedReorderTable.createCheckBox("Inventory");
        this.formattedReorderTable.getFormattedTable().getSelectionModel().addListSelectionListener(this);
        this.formattedReorderTable.getFormattedTable().setEditable(false);
        this.formattedSalesHistoryTable.init(new String[]{"Item ID", "Sold"}, "SalesHistoryForm", null);
        this.formattedSalesHistoryTable.getFormattedTable().setEditable(false);
        this.formattedSalesHistoryTable.getFormattedTable().setShowGrid(true);
    }

    private void init() {
        this._remainingNumber = new HashMap();
        this._soldNumber = new HashMap();
        this._restockNumber = new HashMap();
        this.fromDateChooser.setDateFormatString("MM/dd/yy");
        this.toDateChooser.setDateFormatString("MM/dd/yy");
        Calendar cal = Calendar.getInstance();
        try {
            SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
            this.toDateChooser.setDate(cal.getTime());
            cal.add(2, -1);
            this.fromDateChooser.setDate(cal.getTime());
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        this.createTables();
        this.updateInventoryList();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jPanel3 = new JPanel();
        this.formattedSalesHistoryTable = new FormattedXTable();
        this.jPanel2 = new JPanel();
        this.fromDateChooser = new JDateChooser();
        this.jLabel18 = new JLabel();
        this.jLabel2 = new JLabel();
        this.toDateChooser = new JDateChooser();
        this.jLabel19 = new JLabel();
        this.stockQtyTextField = new JTextField();
        this.jLabel4 = new JLabel();
        this.stockSupplyTxtField = new JTextField();
        this.jLabel5 = new JLabel();
        this.refreshButton = new JButton();
        this.wasSoldCheckBox = new JCheckBox();
        this.exactMatch = new JCheckBox();
        this.formattedReorderTable = new FormattedXTable();
        this.finishButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ReorderForm.class, (String)"ReorderForm.jPanel1.border.title")));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(""));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ReorderForm.class, (String)"ReorderForm.jPanel3.border.title")));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent((Component)this.formattedSalesHistoryTable, -2, 239, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent((Component)this.formattedSalesHistoryTable, -1, 268, Short.MAX_VALUE).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ReorderForm.class, (String)"ReorderForm.jPanel2.border.title")));
        this.fromDateChooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ReorderForm.this.fromDateChooserPropertyChange(evt);
            }
        });
        this.jLabel18.setText(NbBundle.getMessage(ReorderForm.class, (String)"ReorderForm.jLabel18.text"));
        this.jLabel2.setText(NbBundle.getMessage(ReorderForm.class, (String)"ReorderForm.jLabel2.text"));
        this.toDateChooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ReorderForm.this.toDateChooserPropertyChange(evt);
            }
        });
        this.jLabel19.setText(NbBundle.getMessage(ReorderForm.class, (String)"ReorderForm.jLabel19.text"));
        this.stockQtyTextField.setText(NbBundle.getMessage(ReorderForm.class, (String)"ReorderForm.stockQtyTextField.text"));
        this.stockQtyTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReorderForm.this.stockQtyTextFieldActionPerformed(evt);
            }
        });
        this.stockQtyTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ReorderForm.this.stockQtyTextFieldFocusLost(evt);
            }
        });
        this.jLabel4.setText(NbBundle.getMessage(ReorderForm.class, (String)"ReorderForm.jLabel4.text"));
        this.stockSupplyTxtField.setText(NbBundle.getMessage(ReorderForm.class, (String)"ReorderForm.stockSupplyTxtField.text"));
        this.stockSupplyTxtField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReorderForm.this.stockSupplyTxtFieldActionPerformed(evt);
            }
        });
        this.stockSupplyTxtField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ReorderForm.this.stockSupplyTxtFieldFocusLost(evt);
            }
        });
        this.jLabel5.setText(NbBundle.getMessage(ReorderForm.class, (String)"ReorderForm.jLabel5.text"));
        this.refreshButton.setText(NbBundle.getMessage(ReorderForm.class, (String)"ReorderForm.refreshButton.text"));
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReorderForm.this.refreshButtonActionPerformed(evt);
            }
        });
        this.wasSoldCheckBox.setText(NbBundle.getMessage(ReorderForm.class, (String)"ReorderForm.wasSoldCheckBox.text"));
        this.wasSoldCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReorderForm.this.wasSoldCheckBoxActionPerformed(evt);
            }
        });
        this.exactMatch.setText(NbBundle.getMessage(ReorderForm.class, (String)"ReorderForm.exactMatch.text"));
        this.exactMatch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReorderForm.this.exactMatchActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.formattedReorderTable, -1, -1, Short.MAX_VALUE).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.exactMatch).addComponent(this.wasSoldCheckBox)).addGap(4, 4, 4).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.stockSupplyTxtField, -2, 69, -2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.refreshButton).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4, GroupLayout.Alignment.TRAILING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.stockQtyTextField, -2, 69, -2).addGap(21, 21, 21))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel18).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.fromDateChooser, -2, 112, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel19).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.toDateChooser, -2, 112, -2))))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel18).addComponent((Component)this.fromDateChooser, -2, -1, -2).addComponent(this.jLabel19).addComponent((Component)this.toDateChooser, -2, -1, -2))).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel4).addGap(6, 6, 6).addComponent(this.stockQtyTextField, -2, -1, -2)).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stockSupplyTxtField, -2, -1, -2))).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.wasSoldCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exactMatch))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.refreshButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.formattedReorderTable, -1, 416, Short.MAX_VALUE).addContainerGap()));
        this.finishButton.setText(NbBundle.getMessage(ReorderForm.class, (String)"ReorderForm.finishButton.text"));
        this.finishButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReorderForm.this.finishButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -2, -1, -2).addComponent(this.finishButton, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.finishButton))).addContainerGap()));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void finishButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void stockQtyTextFieldActionPerformed(ActionEvent evt) {
    }

    private void stockSupplyTxtFieldActionPerformed(ActionEvent evt) {
    }

    private void fromDateChooserPropertyChange(PropertyChangeEvent evt) {
    }

    private void toDateChooserPropertyChange(PropertyChangeEvent evt) {
    }

    private void stockQtyTextFieldFocusLost(FocusEvent evt) {
    }

    private void stockSupplyTxtFieldFocusLost(FocusEvent evt) {
    }

    private void refreshButtonActionPerformed(ActionEvent evt) {
        this.updateInventoryList();
    }

    private void wasSoldCheckBoxActionPerformed(ActionEvent evt) {
        this.updateInventoryList();
    }

    private void exactMatchActionPerformed(ActionEvent evt) {
        this.updateInventoryList();
    }

    private int getOrderAmount(String baseSKU, String itemID, boolean exactMatch, HashMap<String, HashMap<String, Integer>> salesHistory) {
        int orderAmount = 0;
        if (salesHistory != null && !itemID.isEmpty() && !baseSKU.isEmpty() && salesHistory.containsKey(baseSKU) && salesHistory.get(baseSKU).containsKey(itemID)) {
            orderAmount = salesHistory.get(baseSKU).get(itemID);
            if (!exactMatch && itemID.equalsIgnoreCase(baseSKU)) {
                orderAmount = 0;
                for (int individualAmount : salesHistory.get(baseSKU).values()) {
                    orderAmount += individualAmount;
                }
            }
        }
        return orderAmount;
    }

    private void updateInventoryList() {
        try {
            boolean updateList;
            String stockSupply = GenericFunctions.getInstance().prepareString(this.stockSupplyTxtField.getText());
            String stockQuantity = GenericFunctions.getInstance().prepareString(this.stockQtyTextField.getText());
            boolean bl = updateList = MathParser.isDouble((String)stockSupply) && MathParser.isInteger((String)stockQuantity) && null != this.fromDateChooser.getDate() && null != this.toDateChooser.getDate();
            if (updateList) {
                this._disableListener = true;
                double stockSupplyCount = Double.parseDouble(stockSupply);
                double stockQuantityCount = Double.parseDouble(stockQuantity);
                SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
                long searchTo = this.toDateChooser.getDate().getTime();
                long searchFrom = this.fromDateChooser.getDate().getTime();
                long numberOfDays = (searchTo - searchFrom) / 86400000L;
                double sampleMonths = (double)numberOfDays / 30.0;
                double multiplier = stockSupplyCount / sampleMonths;
                HashMap salesHistory = LookupServicesUtil.getDBServices().getReorderList(searchFrom, searchTo);
                this.improvedSalesHistory = new HashMap();
                for (String sku : salesHistory.keySet()) {
                    String baseSku = sku.split("_")[0];
                    if (!this.improvedSalesHistory.containsKey(baseSku)) {
                        this.improvedSalesHistory.put(baseSku, new HashMap());
                    }
                    this.improvedSalesHistory.get(baseSku).put(sku, (Integer)salesHistory.get(sku));
                }
                this.formattedReorderTable.getTableModel().setNumRows(0);
                for (ArrayList list : LookupServicesUtil.getDBServices().getInventoryList()) {
                    if (list.size() <= 0) continue;
                    InventoryElement element = (InventoryElement)list.get(0);
                    String itemID = GenericFunctions.getInstance().prepareString(element.getItemID());
                    String baseSKU = GenericFunctions.getInstance().prepareString(itemID.split("_")[0]);
                    Item item = LookupServicesUtil.getDBServices().getItem(itemID);
                    double orderAmount = this.getOrderAmount(baseSKU, itemID, this.exactMatch.isSelected(), this.improvedSalesHistory);
                    this._soldNumber.put(itemID, String.valueOf((int)orderAmount));
                    orderAmount *= multiplier;
                    if (orderAmount < stockQuantityCount) {
                        orderAmount = stockQuantityCount;
                    }
                    if ((orderAmount = (double)LookupServicesUtil.getDBServices().getItemQuantity(itemID, true) - orderAmount) < 0.0) {
                        this._restockNumber.put(itemID, String.valueOf((int)orderAmount * -1));
                    } else {
                        this._restockNumber.put(itemID, "0");
                    }
                    this._remainingNumber.put(itemID, String.valueOf(LookupServicesUtil.getDBServices().getItemQuantity(itemID, true)));
                    if (this.wasSoldCheckBox.isSelected() && !(Double.parseDouble(this._soldNumber.get(itemID)) > 0.0)) continue;
                    Object[] row = new Object[this.formattedReorderTable.getTableModel().getColumnCount()];
                    row[((Integer)this.formattedReorderTable.getReverseColumnMap().get((Object)"Wholesale Cost")).intValue()] = Float.valueOf(element.getItemCost());
                    row[((Integer)this.formattedReorderTable.getReverseColumnMap().get((Object)"Item ID")).intValue()] = itemID;
                    row[((Integer)this.formattedReorderTable.getReverseColumnMap().get((Object)"Item Name")).intValue()] = "";
                    row[((Integer)this.formattedReorderTable.getReverseColumnMap().get((Object)"Inventory")).intValue()] = false;
                    row[((Integer)this.formattedReorderTable.getReverseColumnMap().get((Object)"Reference ID")).intValue()] = "000000";
                    row[((Integer)this.formattedReorderTable.getReverseColumnMap().get((Object)"Distributor")).intValue()] = "NULL DIST";
                    if (null != item) {
                        row[((Integer)this.formattedReorderTable.getReverseColumnMap().get((Object)"Item Name")).intValue()] = item.getItemName();
                        row[((Integer)this.formattedReorderTable.getReverseColumnMap().get((Object)"Inventory")).intValue()] = !item.isDropShipped();
                        row[((Integer)this.formattedReorderTable.getReverseColumnMap().get((Object)"Reference ID")).intValue()] = item.getDistributorProductID();
                        if (this.distNameList.containsKey(item.getDistributorID())) {
                            row[((Integer)this.formattedReorderTable.getReverseColumnMap().get((Object)"Distributor")).intValue()] = this.distNameList.get(item.getDistributorID());
                        }
                    }
                    row[((Integer)this.formattedReorderTable.getReverseColumnMap().get((Object)"Sold")).intValue()] = this._soldNumber.get(itemID);
                    row[((Integer)this.formattedReorderTable.getReverseColumnMap().get((Object)"Restock Amount")).intValue()] = this._restockNumber.get(itemID);
                    row[((Integer)this.formattedReorderTable.getReverseColumnMap().get((Object)"Remaining")).intValue()] = this._remainingNumber.get(itemID);
                    if (!(Double.parseDouble(this._restockNumber.get(itemID)) > 0.0)) continue;
                    this.formattedReorderTable.getTableModel().addRow(row);
                }
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        this.formattedReorderTable.getFormattedTable().setSortOrder((Object)"Item ID", SortOrder.ASCENDING);
        this._disableListener = false;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!(this._disableListener || e != null && e.getValueIsAdjusting())) {
            this._disableListener = true;
            if (e == null) {
                this.formattedReorderTable.getFormattedTable().clearSelection();
            }
            this.handleValueChanged();
            this._disableListener = false;
        }
    }

    public void handleValueChanged() {
        try {
            if (this.formattedReorderTable.getFormattedTable().getSelectedRow() != -1) {
                this.formattedSalesHistoryTable.getTableModel().setNumRows(0);
                String itemID = GenericFunctions.getInstance().prepareString(this.formattedReorderTable.getValue(this.formattedReorderTable.getFormattedTable().getSelectedRow(), "Item ID"));
                String baseSKU = GenericFunctions.getInstance().prepareString(itemID.split("_")[0]);
                if (!baseSKU.isEmpty() && this.improvedSalesHistory != null && this.improvedSalesHistory.containsKey(baseSKU)) {
                    for (String sku : this.improvedSalesHistory.get(baseSKU).keySet()) {
                        int quantitySold = this.improvedSalesHistory.get(baseSKU).get(sku);
                        if (quantitySold <= 0) continue;
                        Object[] row = new Object[this.formattedSalesHistoryTable.getTableModel().getColumnCount()];
                        row[((Integer)this.formattedSalesHistoryTable.getReverseColumnMap().get((Object)"Item ID")).intValue()] = sku;
                        row[((Integer)this.formattedSalesHistoryTable.getReverseColumnMap().get((Object)"Sold")).intValue()] = quantitySold;
                        this.formattedSalesHistoryTable.getTableModel().addRow(row);
                    }
                }
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }
}

