/*
 * Decompiled with CFR 0.152.
 */
package pnp.managers.ordermanager;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.UUID;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import pnp.managers.ordermanager.InventorySelectionForm;
import pnp.services.authenticationmanager.SubscriptionManager;
import pnp.services.datatypes.CompleteOrder;
import pnp.services.datatypes.Customer;
import pnp.services.datatypes.InventoryElement;
import pnp.services.datatypes.Item;
import pnp.services.datatypes.Order;
import pnp.services.datatypes.OrderDetails;
import pnp.services.datatypes.OrderStatus;
import pnp.services.datatypes.ShippingMethod;
import pnp.services.listener.ClosingListener;
import pnp.services.listener.GenericListener;
import pnp.services.listenermanager.ListenerManager;
import pnp.services.preferencemanager.Preferences;
import pnp.services.table.FormattedXTable;
import pnp.services.util.ErrorsUtil;
import pnp.services.util.LookupServicesUtil;
import pnp.services.util.MathParser;

@TopComponent.Description(preferredID="CreateOrderTopComponent", persistenceType=1)
public final class CreateOrderTopComponent
extends TopComponent
implements ListSelectionListener,
TableModelListener,
ClosingListener {
    private static CreateOrderTopComponent instance;
    private JTextField defaultTextField;
    private boolean _disableListener;
    private HashMap<String, OrderStatus> _statusList;
    private HashMap<Integer, String> _itemIDSaved;
    private JButton addButton;
    private JTextField addressTextField;
    private JButton applyButton;
    private JButton checkEmailButton;
    private JButton checkUsernameButton;
    private JTextField cityTextField;
    private JComboBox companySelection;
    private JTextField countryTextField;
    private JButton deleteButton;
    private JTextField emailTextField;
    private FormattedXTable formattedCreateTable;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JScrollPane jScrollPane2;
    private JTextField nameTextField;
    private JTextArea orderCommentsTextArea;
    private JComboBox orderStatusComboBox;
    private JTextField shippingCostTextField;
    private JComboBox shippingMethodCombobox;
    private JTextField shippingPaidTextField;
    private JTextField stateTextField;
    private JTextField userNameTextField;
    private JTextField zipcodeTextField;

    public CreateOrderTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(CreateOrderTopComponent.class, (String)"CTL_CreateOrderTopComponent"));
        this.setToolTipText(NbBundle.getMessage(CreateOrderTopComponent.class, (String)"HINT_CreateOrderTopComponent"));
        this.init();
    }

    private void instantiateVariables() {
        this.stateTextField.setDocument(new JTextFieldLimit(32));
        this.userNameTextField.setDocument(new JTextFieldLimit(80));
        this.zipcodeTextField.setDocument(new JTextFieldLimit(12));
        this.nameTextField.setDocument(new JTextFieldLimit(255));
        this.emailTextField.setDocument(new JTextFieldLimit(80));
        this.cityTextField.setDocument(new JTextFieldLimit(80));
        this.countryTextField.setDocument(new JTextFieldLimit(32));
        this.addressTextField.setDocument(new JTextFieldLimit(255));
        this._itemIDSaved = new HashMap();
        this._statusList = new HashMap();
        this.defaultTextField = new JTextField();
        this._disableListener = false;
        ArrayList shippingMethodList = LookupServicesUtil.getDBServices().getAvaliableShippingMethods();
        this._statusList = LookupServicesUtil.getDBServices().getAvailableFilters();
        for (ShippingMethod shippingMethod : shippingMethodList) {
            this.shippingMethodCombobox.addItem(shippingMethod.getShippingMethodName());
        }
        this.shippingMethodCombobox.setSelectedIndex(0);
        for (OrderStatus status : this._statusList.values()) {
            this.orderStatusComboBox.addItem(status.getOrderStatusType());
        }
        this.orderStatusComboBox.setSelectedItem("New");
        this.recreateComboBox();
    }

    private void createTables() {
        this.formattedCreateTable.init(new String[]{"Ref. Number", "Item SKU", "Item Name", "Retail $", "Wholesale $", "Inventory"}, "CreateOrder", null);
        this.formattedCreateTable.getFormattedTable().setShowGrid(true);
        this.formattedCreateTable.createCheckBox("Inventory");
        this.formattedCreateTable.getTableModel().addTableModelListener(this);
        if (!SubscriptionManager.getInstance().isInventoryActive()) {
            this.formattedCreateTable.removeColumn("Inventory");
        }
        this.formattedCreateTable.getFormattedTable().getSelectionModel().addListSelectionListener(this);
    }

    public void recreateComboBox() {
        this.companySelection.removeAllItems();
        for (String companyName : Preferences.getInstance().getAccountPreferences().getCompanyMap().toArray(new String[0])) {
            this.companySelection.addItem(companyName);
        }
        this.companySelection.setSelectedItem(Preferences.getInstance().getAccountPreferences().getCompanyDefaultCompany());
    }

    private void doWork() {
        this.formattedCreateTable.loadSavedSettings();
        ListenerManager.getInstance().subscribe((GenericListener)this);
    }

    public void init() {
        this.instantiateVariables();
        this.createTables();
        this.doWork();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.userNameTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.emailTextField = new JTextField();
        this.nameTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.addressTextField = new JTextField();
        this.jLabel4 = new JLabel();
        this.cityTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.stateTextField = new JTextField();
        this.jLabel7 = new JLabel();
        this.countryTextField = new JTextField();
        this.jLabel8 = new JLabel();
        this.zipcodeTextField = new JTextField();
        this.checkUsernameButton = new JButton();
        this.checkEmailButton = new JButton();
        this.jPanel3 = new JPanel();
        this.formattedCreateTable = new FormattedXTable();
        this.addButton = new JButton();
        this.deleteButton = new JButton();
        this.applyButton = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.shippingCostTextField = new JTextField();
        this.shippingPaidTextField = new JTextField();
        this.jLabel11 = new JLabel();
        this.shippingMethodCombobox = new JComboBox();
        this.jPanel4 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.orderCommentsTextArea = new JTextArea();
        this.jPanel5 = new JPanel();
        this.orderStatusComboBox = new JComboBox();
        this.jPanel6 = new JPanel();
        this.companySelection = new JComboBox();
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(CreateOrderTopComponent.class, (String)"CreateOrderTopComponent.jPanel1.border.title")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(CreateOrderTopComponent.class, (String)"CreateOrderTopComponent.jLabel1.text"));
        this.userNameTextField.setText(NbBundle.getMessage(CreateOrderTopComponent.class, (String)"CreateOrderTopComponent.userNameTextField.text"));
        this.userNameTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateOrderTopComponent.this.userNameTextFieldActionPerformed(evt);
            }
        });
        this.userNameTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                CreateOrderTopComponent.this.userNameTextFieldFocusLost(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(CreateOrderTopComponent.class, (String)"CreateOrderTopComponent.jLabel2.text"));
        this.emailTextField.setText(NbBundle.getMessage(CreateOrderTopComponent.class, (String)"CreateOrderTopComponent.emailTextField.text"));
        this.emailTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateOrderTopComponent.this.emailTextFieldActionPerformed(evt);
            }
        });
        this.emailTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                CreateOrderTopComponent.this.emailTextFieldFocusLost(evt);
            }
        });
        this.nameTextField.setText(NbBundle.getMessage(CreateOrderTopComponent.class, (String)"CreateOrderTopComponent.nameTextField.text"));
        this.nameTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateOrderTopComponent.this.nameTextFieldActionPerformed(evt);
            }
        });
        this.nameTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                CreateOrderTopComponent.this.nameTextFieldFocusLost(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(CreateOrderTopComponent.class, (String)"CreateOrderTopComponent.jLabel3.text"));
        this.addressTextField.setText(NbBundle.getMessage(CreateOrderTopComponent.class, (String)"CreateOrderTopComponent.addressTextField.text"));
        this.addressTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateOrderTopComponent.this.addressTextFieldActionPerformed(evt);
            }
        });
        this.addressTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                CreateOrderTopComponent.this.addressTextFieldFocusLost(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(CreateOrderTopComponent.class, (String)"CreateOrderTopComponent.jLabel4.text"));
        this.cityTextField.setText(NbBundle.getMessage(CreateOrderTopComponent.class, (String)"CreateOrderTopComponent.cityTextField.text"));
        this.cityTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateOrderTopComponent.this.cityTextFieldActionPerformed(evt);
            }
        });
        this.cityTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                CreateOrderTopComponent.this.cityTextFieldFocusLost(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(CreateOrderTopComponent.class, (String)"CreateOrderTopComponent.jLabel5.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(CreateOrderTopComponent.class, (String)"CreateOrderTopComponent.jLabel6.text"));
        this.stateTextField.setText(NbBundle.getMessage(CreateOrderTopComponent.class, (String)"CreateOrderTopComponent.stateTextField.text"));
        this.stateTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateOrderTopComponent.this.stateTextFieldActionPerformed(evt);
            }
        });
        this.stateTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                CreateOrderTopComponent.this.stateTextFieldFocusLost(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(CreateOrderTopComponent.class, (String)"CreateOrderTopComponent.jLabel7.text"));
        this.countryTextField.setText(NbBundle.getMessage(CreateOrderTopComponent.class, (String)"CreateOrderTopComponent.countryTextField.text"));
        this.countryTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateOrderTopComponent.this.countryTextFieldActionPerformed(evt);
            }
        });
        this.countryTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                CreateOrderTopComponent.this.countryTextFieldFocusLost(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(CreateOrderTopComponent.class, (String)"CreateOrderTopComponent.jLabel8.text"));
        this.zipcodeTextField.setText(NbBundle.getMessage(CreateOrderTopComponent.class, (String)"CreateOrderTopComponent.zipcodeTextField.text"));
        this.zipcodeTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateOrderTopComponent.this.zipcodeTextFieldActionPerformed(evt);
            }
        });
        this.zipcodeTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                CreateOrderTopComponent.this.zipcodeTextFieldFocusLost(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.checkUsernameButton, (String)NbBundle.getMessage(CreateOrderTopComponent.class, (String)"CreateOrderTopComponent.checkUsernameButton.text"));
        this.checkUsernameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateOrderTopComponent.this.checkUsernameButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.checkEmailButton, (String)NbBundle.getMessage(CreateOrderTopComponent.class, (String)"CreateOrderTopComponent.checkEmailButton.text"));
        this.checkEmailButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateOrderTopComponent.this.checkEmailButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.userNameTextField, -2, 158, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkUsernameButton)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.emailTextField, -2, 158, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkEmailButton)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nameTextField, -2, 158, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addressTextField, -2, 158, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cityTextField, -2, 158, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stateTextField, -2, 158, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.zipcodeTextField, -2, 158, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.countryTextField, -2, 158, -2))).addContainerGap(71, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(0, this.jLabel1, this.jLabel2, this.jLabel3, this.jLabel4, this.jLabel5, this.jLabel6, this.jLabel7, this.jLabel8);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.userNameTextField, -2, -1, -2).addComponent(this.checkUsernameButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.emailTextField, -2, -1, -2).addComponent(this.checkEmailButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.nameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.addressTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.cityTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.stateTextField, -2, -1, -2)).addGap(4, 4, 4).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.zipcodeTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.countryTextField, -2, -1, -2)).addContainerGap(37, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(1, this.addressTextField, this.cityTextField, this.countryTextField, this.emailTextField, this.jLabel1, this.jLabel2, this.jLabel3, this.jLabel4, this.jLabel5, this.jLabel6, this.jLabel7, this.jLabel8, this.nameTextField, this.stateTextField, this.userNameTextField, this.zipcodeTextField);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(CreateOrderTopComponent.class, (String)"CreateOrderTopComponent.jPanel3.border.title")));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap().addComponent((Component)this.formattedCreateTable, -1, 966, Short.MAX_VALUE).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent((Component)this.formattedCreateTable, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(CreateOrderTopComponent.class, (String)"CreateOrderTopComponent.addButton.text"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateOrderTopComponent.this.addButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.deleteButton, (String)NbBundle.getMessage(CreateOrderTopComponent.class, (String)"CreateOrderTopComponent.deleteButton.text"));
        this.deleteButton.setEnabled(false);
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateOrderTopComponent.this.deleteButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.applyButton, (String)NbBundle.getMessage(CreateOrderTopComponent.class, (String)"CreateOrderTopComponent.applyButton.text"));
        this.applyButton.setEnabled(false);
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateOrderTopComponent.this.applyButtonActionPerformed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(CreateOrderTopComponent.class, (String)"CreateOrderTopComponent.jPanel2.border.title")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(CreateOrderTopComponent.class, (String)"CreateOrderTopComponent.jLabel9.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel10, (String)NbBundle.getMessage(CreateOrderTopComponent.class, (String)"CreateOrderTopComponent.jLabel10.text"));
        this.shippingCostTextField.setText(NbBundle.getMessage(CreateOrderTopComponent.class, (String)"CreateOrderTopComponent.shippingCostTextField.text"));
        this.shippingCostTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateOrderTopComponent.this.shippingCostTextFieldActionPerformed(evt);
            }
        });
        this.shippingCostTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                CreateOrderTopComponent.this.shippingCostTextFieldFocusLost(evt);
            }
        });
        this.shippingPaidTextField.setText(NbBundle.getMessage(CreateOrderTopComponent.class, (String)"CreateOrderTopComponent.shippingPaidTextField.text"));
        this.shippingPaidTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateOrderTopComponent.this.shippingPaidTextFieldActionPerformed(evt);
            }
        });
        this.shippingPaidTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                CreateOrderTopComponent.this.shippingPaidTextFieldFocusLost(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel11, (String)NbBundle.getMessage(CreateOrderTopComponent.class, (String)"CreateOrderTopComponent.jLabel11.text"));
        this.shippingMethodCombobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateOrderTopComponent.this.shippingMethodComboboxActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.shippingPaidTextField, -2, 158, -2)).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.shippingMethodCombobox, 0, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.shippingCostTextField, -2, 158, -2)))).addContainerGap(77, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(0, this.jLabel10, this.jLabel11, this.jLabel9);
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.shippingMethodCombobox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.shippingCostTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.shippingPaidTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(CreateOrderTopComponent.class, (String)"CreateOrderTopComponent.jPanel4.border.title")));
        this.orderCommentsTextArea.setColumns(20);
        this.orderCommentsTextArea.setRows(5);
        this.orderCommentsTextArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                CreateOrderTopComponent.this.orderCommentsTextAreaFocusLost(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.orderCommentsTextArea);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 314, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -2, 108, -2));
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(CreateOrderTopComponent.class, (String)"CreateOrderTopComponent.jPanel5.border.title")));
        this.orderStatusComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateOrderTopComponent.this.orderStatusComboBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup().addGap(55, 55, 55).addComponent(this.orderStatusComboBox, 0, 158, Short.MAX_VALUE).addGap(49, 49, 49)));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addGap(26, 26, 26).addComponent(this.orderStatusComboBox, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel6.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(CreateOrderTopComponent.class, (String)"CreateOrderTopComponent.jPanel6.border.title")));
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addGap(59, 59, 59).addComponent(this.companySelection, -2, 156, -2).addContainerGap(47, Short.MAX_VALUE)));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addGap(33, 33, 33).addComponent(this.companySelection, -2, -1, -2).addContainerGap(47, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel4, -2, -1, -2).addGroup(layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel5, -2, -1, -2).addComponent(this.jPanel6, -2, -1, -2))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.applyButton)).addComponent(this.jPanel3, GroupLayout.Alignment.LEADING, -2, -1, -2))).addGap(48, 48, 48)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addButton).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.deleteButton).addComponent(this.applyButton)))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel4, -2, -1, -2).addComponent(this.jPanel6, -2, -1, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addGap(38, 38, 38)));
    }

    private void userNameTextFieldActionPerformed(ActionEvent evt) {
        this.userNameTextField.setText(this.userNameTextField.getText().trim());
        if (this.userNameTextField.getText() != null && !this.userNameTextField.getText().trim().isEmpty()) {
            this.checkOrder();
            this.userNameTextField.setBackground(this.defaultTextField.getBackground());
        } else {
            this.userNameTextField.setBackground(Color.red);
        }
    }

    private void emailTextFieldActionPerformed(ActionEvent evt) {
        this.emailTextField.setText(this.emailTextField.getText().trim());
        if (this.emailTextField.getText() != null && this.emailTextField.getText().contains("@")) {
            this.checkOrder();
            this.emailTextField.setBackground(this.defaultTextField.getBackground());
        } else {
            this.emailTextField.setBackground(Color.red);
        }
    }

    private void nameTextFieldActionPerformed(ActionEvent evt) {
        this.nameTextField.setText(this.nameTextField.getText().trim());
        if (this.nameTextField.getText() != null) {
            this.checkOrder();
            this.nameTextField.setBackground(this.defaultTextField.getBackground());
        } else {
            this.nameTextField.setBackground(Color.red);
        }
    }

    private void addressTextFieldActionPerformed(ActionEvent evt) {
        this.addressTextField.setText(this.addressTextField.getText().trim());
        if (this.addressTextField.getText() != null) {
            this.checkOrder();
            this.addressTextField.setBackground(this.defaultTextField.getBackground());
        } else {
            this.addressTextField.setBackground(Color.red);
        }
    }

    private void cityTextFieldActionPerformed(ActionEvent evt) {
        this.cityTextField.setText(this.cityTextField.getText().trim());
        if (this.cityTextField.getText() != null) {
            this.checkOrder();
            this.cityTextField.setBackground(this.defaultTextField.getBackground());
        } else {
            this.cityTextField.setBackground(Color.red);
        }
    }

    private void stateTextFieldActionPerformed(ActionEvent evt) {
        this.stateTextField.setText(this.stateTextField.getText().trim());
        if (this.stateTextField.getText() != null) {
            this.checkOrder();
            this.stateTextField.setBackground(this.defaultTextField.getBackground());
        } else {
            this.stateTextField.setBackground(Color.red);
        }
    }

    private void countryTextFieldActionPerformed(ActionEvent evt) {
        this.countryTextField.setText(this.countryTextField.getText().trim());
        if (this.countryTextField.getText() != null) {
            this.checkOrder();
            this.countryTextField.setBackground(this.defaultTextField.getBackground());
        } else {
            this.countryTextField.setBackground(Color.red);
        }
    }

    private void zipcodeTextFieldActionPerformed(ActionEvent evt) {
        this.zipcodeTextField.setText(this.zipcodeTextField.getText().trim());
        if (this.zipcodeTextField.getText() != null) {
            this.checkOrder();
            this.zipcodeTextField.setBackground(this.defaultTextField.getBackground());
        } else {
            this.zipcodeTextField.setBackground(Color.red);
        }
    }

    private void shippingCostTextFieldActionPerformed(ActionEvent evt) {
        if (this.validateShipping(this.shippingCostTextField)) {
            this.checkOrder();
            this.shippingCostTextField.setBackground(this.defaultTextField.getBackground());
        } else {
            this.shippingCostTextField.setBackground(Color.red);
        }
    }

    private void shippingPaidTextFieldActionPerformed(ActionEvent evt) {
        if (this.validateShipping(this.shippingPaidTextField)) {
            this.checkOrder();
            this.shippingPaidTextField.setBackground(this.defaultTextField.getBackground());
        } else {
            this.shippingPaidTextField.setBackground(Color.red);
        }
    }

    private void userNameTextFieldFocusLost(FocusEvent evt) {
        this.userNameTextField.setText(this.userNameTextField.getText().trim());
        if (this.userNameTextField.getText() != null && !this.userNameTextField.getText().trim().isEmpty()) {
            this.checkOrder();
            this.userNameTextField.setBackground(this.defaultTextField.getBackground());
        } else {
            this.userNameTextField.setBackground(Color.red);
        }
    }

    private void emailTextFieldFocusLost(FocusEvent evt) {
        this.emailTextField.setText(this.emailTextField.getText().trim());
        if (this.emailTextField.getText() != null && this.emailTextField.getText().contains("@")) {
            this.checkOrder();
            this.emailTextField.setBackground(this.defaultTextField.getBackground());
        } else {
            this.emailTextField.setBackground(Color.red);
        }
    }

    private void nameTextFieldFocusLost(FocusEvent evt) {
        this.nameTextField.setText(this.nameTextField.getText().trim());
        if (this.nameTextField.getText() != null) {
            this.checkOrder();
            this.nameTextField.setBackground(this.defaultTextField.getBackground());
        } else {
            this.nameTextField.setBackground(Color.red);
        }
    }

    private void addressTextFieldFocusLost(FocusEvent evt) {
        this.addressTextField.setText(this.addressTextField.getText().trim());
        if (this.addressTextField.getText() != null) {
            this.checkOrder();
            this.addressTextField.setBackground(this.defaultTextField.getBackground());
        } else {
            this.addressTextField.setBackground(Color.red);
        }
    }

    private void cityTextFieldFocusLost(FocusEvent evt) {
        this.cityTextField.setText(this.cityTextField.getText().trim());
        if (this.cityTextField.getText() != null) {
            this.checkOrder();
            this.cityTextField.setBackground(this.defaultTextField.getBackground());
        } else {
            this.cityTextField.setBackground(Color.red);
        }
    }

    private void stateTextFieldFocusLost(FocusEvent evt) {
        this.stateTextField.setText(this.stateTextField.getText().trim());
        if (this.stateTextField.getText() != null) {
            this.checkOrder();
            this.stateTextField.setBackground(this.defaultTextField.getBackground());
        } else {
            this.stateTextField.setBackground(Color.red);
        }
    }

    private void zipcodeTextFieldFocusLost(FocusEvent evt) {
        this.zipcodeTextField.setText(this.zipcodeTextField.getText().trim());
        if (this.zipcodeTextField.getText() != null) {
            this.checkOrder();
            this.zipcodeTextField.setBackground(this.defaultTextField.getBackground());
        } else {
            this.zipcodeTextField.setBackground(Color.red);
        }
    }

    private void countryTextFieldFocusLost(FocusEvent evt) {
        this.countryTextField.setText(this.countryTextField.getText().trim());
        if (this.countryTextField.getText() != null) {
            this.checkOrder();
            this.countryTextField.setBackground(this.defaultTextField.getBackground());
        } else {
            this.countryTextField.setBackground(Color.red);
        }
    }

    private void shippingCostTextFieldFocusLost(FocusEvent evt) {
        if (this.validateShipping(this.shippingCostTextField)) {
            this.checkOrder();
            this.shippingCostTextField.setBackground(this.defaultTextField.getBackground());
        } else {
            this.shippingCostTextField.setBackground(Color.red);
        }
    }

    private void shippingPaidTextFieldFocusLost(FocusEvent evt) {
        if (this.validateShipping(this.shippingPaidTextField)) {
            this.checkOrder();
            this.shippingPaidTextField.setBackground(this.defaultTextField.getBackground());
        } else {
            this.shippingPaidTextField.setBackground(Color.red);
        }
    }

    private void orderCommentsTextAreaFocusLost(FocusEvent evt) {
        if (this.orderCommentsTextArea.getText() != null) {
            this.checkOrder();
            this.orderCommentsTextArea.setBackground(this.defaultTextField.getBackground());
        } else {
            this.orderCommentsTextArea.setBackground(Color.red);
        }
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this._disableListener = true;
        Object[] row = new Object[this.formattedCreateTable.getTableModel().getColumnCount()];
        row[((Integer)this.formattedCreateTable.getReverseColumnMap().get((Object)"Ref. Number")).intValue()] = "";
        row[((Integer)this.formattedCreateTable.getReverseColumnMap().get((Object)"Item SKU")).intValue()] = "";
        row[((Integer)this.formattedCreateTable.getReverseColumnMap().get((Object)"Item Name")).intValue()] = "";
        row[((Integer)this.formattedCreateTable.getReverseColumnMap().get((Object)"Wholesale $")).intValue()] = "0.00";
        row[((Integer)this.formattedCreateTable.getReverseColumnMap().get((Object)"Retail $")).intValue()] = "0.00";
        if (SubscriptionManager.getInstance().isInventoryActive()) {
            row[((Integer)this.formattedCreateTable.getReverseColumnMap().get((Object)"Inventory")).intValue()] = false;
        }
        this.formattedCreateTable.getTableModel().addRow(row);
        this._disableListener = false;
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        this._disableListener = true;
        int[] selectedRows = this.formattedCreateTable.getFormattedTable().getSelectedRows();
        for (int i = selectedRows.length - 1; i >= 0; --i) {
            int rowChanged = selectedRows[i];
            if (rowChanged == -1) continue;
            String itemName = this.formattedCreateTable.getValue(rowChanged, "Item SKU");
            Collection inventoryElements = LookupServicesUtil.getDBServices().getInventoryList(itemName, false, false, false, new String[0], false);
            Iterator iter = inventoryElements.iterator();
            boolean found = false;
            while (iter.hasNext() && !found) {
                ArrayList itemList = (ArrayList)iter.next();
                if (!((InventoryElement)itemList.get(0)).getItemID().toLowerCase().trim().equals(itemName)) continue;
                found = true;
                if (SubscriptionManager.getInstance().isInventoryActive()) {
                    this.formattedCreateTable.setValue((Object)false, rowChanged, "Inventory");
                }
                if (((InventoryElement)itemList.get(0)).getItemQuantity() < 0) {
                    ((InventoryElement)itemList.get(0)).setItemQuantity(((InventoryElement)itemList.get(0)).getItemQuantity() + 1);
                    LookupServicesUtil.getDBServices().setInventoryElement((InventoryElement)itemList.get(0));
                    continue;
                }
                boolean priceMatch = false;
                for (int j = 1; j < itemList.size(); ++j) {
                    if (((InventoryElement)itemList.get(j)).getItemCost() != Float.parseFloat(this.formattedCreateTable.getValue(rowChanged, "Wholesale $"))) continue;
                    priceMatch = true;
                    ((InventoryElement)itemList.get(j)).setItemQuantity(((InventoryElement)itemList.get(j)).getItemQuantity() + 1);
                    LookupServicesUtil.getDBServices().setInventoryElement((InventoryElement)itemList.get(j));
                    break;
                }
                if (priceMatch) continue;
                InventoryElement element = new InventoryElement();
                element.setItem(((InventoryElement)itemList.get(0)).getItem());
                element.setItemCost(Float.parseFloat(this.formattedCreateTable.getValue(rowChanged, "Wholesale $")));
                element.setItemID(itemName);
                element.setItemQuantity(1);
                element.setOosItem(false);
                LookupServicesUtil.getDBServices().setInventoryElement(element);
                ListenerManager.getInstance().notify((GenericListener)ListenerManager.INVENTORY_LIST_LISTENER);
            }
            this.formattedCreateTable.getTableModel().removeRow(this.formattedCreateTable.convertRow(rowChanged));
        }
        this._disableListener = false;
    }

    private void applyButtonActionPerformed(ActionEvent evt) {
        CompleteOrder completeOrder = new CompleteOrder();
        Order order = new Order();
        Customer customer = LookupServicesUtil.getDBServices().getCustomerByUsername(this.userNameTextField.getText().trim());
        if (null == customer) {
            customer = new Customer();
        }
        customer.setCustomerName(this.nameTextField.getText().trim());
        customer.setCustomerAddress(this.addressTextField.getText().trim());
        customer.setCustomerCity(this.cityTextField.getText().trim());
        customer.setCustomerCountry(this.countryTextField.getText().trim());
        customer.setCustomerEmail(this.emailTextField.getText().trim());
        customer.setCustomerUserName(this.userNameTextField.getText().trim());
        customer.setCustomerState(this.stateTextField.getText().trim());
        customer.setCustomerZipcode(this.zipcodeTextField.getText().trim());
        order.setCustomer(customer);
        order.setOrderComments(this.orderCommentsTextArea.getText().trim());
        order.setOrderDate(new Date(System.currentTimeMillis()));
        order.setOrderStatus(this._statusList.get(((String)this.orderStatusComboBox.getSelectedItem()).trim()));
        order.setShippingCost(Float.valueOf(this.shippingCostTextField.getText().trim()).floatValue());
        order.setShippingMethodName(((String)this.shippingMethodCombobox.getSelectedItem()).trim());
        order.setShippingPaid(Float.valueOf(this.shippingPaidTextField.getText().trim()).floatValue());
        float orderCost = 0.0f;
        ArrayList<OrderDetails> orderDetailsList = new ArrayList<OrderDetails>();
        if (this.formattedCreateTable.getFormattedTable().getRowCount() > 0) {
            for (int i = 0; i < this.formattedCreateTable.getFormattedTable().getRowCount(); ++i) {
                OrderDetails orderDetails = new OrderDetails();
                orderDetails.setSalesPrice(Float.parseFloat(this.formattedCreateTable.getValue(i, "Retail $")));
                orderCost += orderDetails.getSalesPrice();
                orderDetails.setItemID(this.formattedCreateTable.getValue(i, "Item SKU"));
                orderDetails.setOrderDescription(this.formattedCreateTable.getValue(i, "Item Name"));
                orderDetails.setOrderNumber(this.formattedCreateTable.getValue(i, "Ref. Number"));
                orderDetails.setItemCost(Float.parseFloat(this.formattedCreateTable.getValue(i, "Wholesale $")));
                if (SubscriptionManager.getInstance().isInventoryActive()) {
                    orderDetails.setInhouse(Boolean.parseBoolean(this.formattedCreateTable.getValue(i, "Inventory")));
                }
                if (LookupServicesUtil.getDBServices().getItemQuantity(orderDetails.getItemID(), true) < 0 && orderDetails.isInhouse()) {
                    orderDetails.setBackordered(true);
                }
                if (((String)this.orderStatusComboBox.getSelectedItem()).equals("Complete")) {
                    orderDetails.setShipDate(new Date(System.currentTimeMillis()));
                }
                orderDetails.setTransactionID(UUID.randomUUID().toString());
                orderDetailsList.add(orderDetails);
            }
        } else {
            OrderDetails orderDetails = new OrderDetails();
            orderDetails.setTransactionID(UUID.randomUUID().toString());
            orderDetailsList.add(orderDetails);
        }
        order.setOrderTotal(orderCost);
        String companySelected = Preferences.getInstance().getAccountPreferences().getCompanyDefaultCompany();
        if (this.companySelection != null && this.companySelection.getSelectedItem() != null && this.companySelection.getSelectedItem().toString() != null && !this.companySelection.getSelectedItem().toString().trim().isEmpty()) {
            companySelected = this.companySelection.getSelectedItem().toString().trim();
        }
        order.setPaypalAccount(companySelected);
        completeOrder.setOrder(order);
        completeOrder.setOrderDetails(orderDetailsList);
        LookupServicesUtil.getDBServices().updateOrder(completeOrder);
        this.clearAll();
        ListenerManager.getInstance().notify((GenericListener)ListenerManager.TRANSACTION_LISTENER);
    }

    private void checkUsernameButtonActionPerformed(ActionEvent evt) {
        Customer customer;
        if (null != this.userNameTextField.getText().trim() && null != (customer = LookupServicesUtil.getDBServices().getCustomerByUsername(this.userNameTextField.getText().trim()))) {
            this.addressTextField.setText(customer.getCustomerAddress().trim());
            this.cityTextField.setText(customer.getCustomerCity().trim());
            this.countryTextField.setText(customer.getCustomerCountry().trim());
            this.emailTextField.setText(customer.getCustomerEmail().trim());
            this.nameTextField.setText(customer.getCustomerName().trim());
            this.stateTextField.setText(customer.getCustomerState().trim());
            this.zipcodeTextField.setText(customer.getCustomerZipcode().trim());
            this.emailTextField.setBackground(this.defaultTextField.getBackground());
            this.userNameTextField.setBackground(this.defaultTextField.getBackground());
            this.checkOrder();
        }
    }

    private void checkEmailButtonActionPerformed(ActionEvent evt) {
        Customer customer;
        if (null != this.emailTextField.getText().trim() && null != (customer = LookupServicesUtil.getDBServices().getCustomerByEmail(this.emailTextField.getText().trim()))) {
            this.userNameTextField.setText(customer.getCustomerUserName().trim());
            this.addressTextField.setText(customer.getCustomerAddress().trim());
            this.cityTextField.setText(customer.getCustomerCity().trim());
            this.countryTextField.setText(customer.getCustomerCountry().trim());
            this.nameTextField.setText(customer.getCustomerName().trim());
            this.stateTextField.setText(customer.getCustomerState().trim());
            this.zipcodeTextField.setText(customer.getCustomerZipcode().trim());
            this.emailTextField.setBackground(this.defaultTextField.getBackground());
            this.userNameTextField.setBackground(this.defaultTextField.getBackground());
            this.checkOrder();
        }
    }

    private void shippingMethodComboboxActionPerformed(ActionEvent evt) {
        this.checkOrder();
    }

    private void orderStatusComboBoxActionPerformed(ActionEvent evt) {
        this.checkOrder();
    }

    public static synchronized CreateOrderTopComponent findInstance() {
        if (instance == null) {
            instance = new CreateOrderTopComponent();
        }
        return instance;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    Object readProperties(Properties p) {
        if (instance == null) {
            instance = this;
        }
        instance.readPropertiesImpl(p);
        return instance;
    }

    private void readPropertiesImpl(Properties p) {
        String version = p.getProperty("version");
    }

    private void checkOrder() {
        this.applyButton.setEnabled(this.addressTextField.getText() != null && this.cityTextField.getText() != null && this.stateTextField.getText() != null && this.zipcodeTextField.getText() != null && this.countryTextField.getText() != null && this.nameTextField.getText() != null && this.emailTextField.getText() != null && this.emailTextField.getText().contains("@") && this.orderCommentsTextArea.getText() != null && this.userNameTextField.getText() != null && !this.userNameTextField.getText().trim().isEmpty() && this.validateOrderDetails() && this.validateShipping(this.shippingCostTextField) && this.validateShipping(this.shippingPaidTextField));
    }

    private boolean validateShipping(JTextField field) {
        String text = field.getText();
        if (null != text) {
            if ((text = text.trim()).isEmpty()) {
                text = "0.00";
            }
            text = this.isDollarAmount(text);
            field.setText(text);
        }
        return text != null;
    }

    private boolean checkDollarAmount(int row, String column) {
        String amount = this.formattedCreateTable.getValue(row, column);
        if (null != amount) {
            if (amount.isEmpty()) {
                amount = "0.00";
            }
            amount = this.isDollarAmount(amount);
        }
        if (amount != null) {
            this.formattedCreateTable.setValue((Object)amount, row, column);
        }
        return amount != null;
    }

    private boolean validateOrderDetails() {
        this._disableListener = true;
        boolean valid = true;
        for (int i = 0; i < this.formattedCreateTable.getFormattedTable().getRowCount(); ++i) {
            if (!this.checkDollarAmount(i, "Wholesale $")) {
                valid = false;
            }
            if (this.checkDollarAmount(i, "Retail $")) continue;
            valid = false;
        }
        this._disableListener = false;
        return valid;
    }

    public String isDollarAmount(String input) {
        try {
            input = input.replace("$", "");
            input = input.trim();
            input = String.valueOf((float)MathParser.processEquation((String)input));
            Double.parseDouble(input);
            input = input.trim();
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
            input = null;
        }
        return input;
    }

    private void clearAll() {
        this._disableListener = true;
        this.formattedCreateTable.getTableModel().setRowCount(0);
        this.userNameTextField.setText("");
        this.emailTextField.setText("");
        this.nameTextField.setText("");
        this.addressTextField.setText("");
        this.cityTextField.setText("");
        this.stateTextField.setText("");
        this.countryTextField.setText("");
        this.zipcodeTextField.setText("");
        this.shippingCostTextField.setText("0.00");
        this.shippingPaidTextField.setText("0.00");
        this.shippingMethodCombobox.setSelectedIndex(0);
        this.orderCommentsTextArea.setText("");
        this.orderStatusComboBox.setSelectedItem("New");
        this._disableListener = false;
    }

    public void updateCreatedOrders() {
        this._itemIDSaved.clear();
        for (int i = 0; i < this.formattedCreateTable.getFormattedTable().getRowCount(); ++i) {
            this._itemIDSaved.put(this.formattedCreateTable.convertRow(i), this.formattedCreateTable.getValue(i, "Item SKU"));
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        block14: {
            block16: {
                block17: {
                    block21: {
                        Iterator iter;
                        String wholeSaleCost;
                        String itemName;
                        int rowChanged;
                        block18: {
                            block19: {
                                int quantity;
                                Item item;
                                block20: {
                                    Boolean inventory;
                                    block15: {
                                        if (this._disableListener || this.formattedCreateTable.getFormattedTable().getSelectedRow() < 0) break block14;
                                        this._disableListener = true;
                                        rowChanged = this.formattedCreateTable.getFormattedTable().getSelectedRow();
                                        itemName = this.formattedCreateTable.getValue(rowChanged, "Item SKU");
                                        wholeSaleCost = this.formattedCreateTable.getValue(rowChanged, "Wholesale $");
                                        inventory = SubscriptionManager.getInstance().isInventoryActive() && Boolean.parseBoolean(this.formattedCreateTable.getValue(rowChanged, "Inventory"));
                                        String value = null;
                                        if (e.getColumn() != ((Integer)this.formattedCreateTable.getReverseColumnMap().get("Item SKU")).intValue()) break block15;
                                        value = itemName;
                                        if (SubscriptionManager.getInstance().isInventoryActive() && inventory.booleanValue()) {
                                            value = this._itemIDSaved.get(this.formattedCreateTable.convertRow(rowChanged));
                                        }
                                        this.formattedCreateTable.setValue((Object)value, rowChanged, "Item SKU");
                                        break block16;
                                    }
                                    if (!SubscriptionManager.getInstance().isInventoryActive() || e.getColumn() != ((Integer)this.formattedCreateTable.getReverseColumnMap().get("Inventory")).intValue()) break block17;
                                    Collection inventoryElements = LookupServicesUtil.getDBServices().getInventoryList(itemName, false, false, false, new String[0], false);
                                    iter = inventoryElements.iterator();
                                    InventoryElement selectedInventoryItem = null;
                                    if (!inventory.booleanValue()) break block18;
                                    if (inventoryElements.isEmpty()) {
                                        JOptionPane.showMessageDialog(null, "No inventory found.");
                                    } else if (inventoryElements.size() != 1) {
                                        InventorySelectionForm inventorySelectionForm = new InventorySelectionForm(null, true, itemName);
                                        inventorySelectionForm.setTitle("Inventory Selection");
                                        inventorySelectionForm.setVisible(true);
                                        selectedInventoryItem = inventorySelectionForm.getSelectedItem();
                                    } else {
                                        for (ArrayList inventorySubset : inventoryElements) {
                                            for (InventoryElement inventoryElement : inventorySubset) {
                                                if (selectedInventoryItem == null) {
                                                    selectedInventoryItem = inventoryElement;
                                                }
                                                if (inventoryElement.getItemQuantity() <= 0 || selectedInventoryItem != null && !(selectedInventoryItem.getItemCost() > inventoryElement.getItemCost()) && selectedInventoryItem.getItemQuantity() > 0) continue;
                                                selectedInventoryItem = inventoryElement;
                                            }
                                        }
                                    }
                                    if (null == selectedInventoryItem) break block19;
                                    this.formattedCreateTable.setValue((Object)String.valueOf(selectedInventoryItem.getItemCost()), rowChanged, "Wholesale $");
                                    this.formattedCreateTable.setValue((Object)selectedInventoryItem.getItemID(), rowChanged, "Item SKU");
                                    this.formattedCreateTable.setValue((Object)inventory, rowChanged, "Inventory");
                                    item = LookupServicesUtil.getDBServices().getItem(selectedInventoryItem.getItemID());
                                    selectedInventoryItem.setItemQuantity(selectedInventoryItem.getItemQuantity() - 1);
                                    LookupServicesUtil.getDBServices().setInventoryElement(selectedInventoryItem);
                                    quantity = LookupServicesUtil.getDBServices().getItemQuantity(selectedInventoryItem.getItemID(), false);
                                    if (quantity != 1) break block20;
                                    JOptionPane.showMessageDialog((Component)((Object)this), "Only one of this item is currently left in stock.", "Low Stock Notification", 1);
                                    break block21;
                                }
                                if (quantity != 0) break block21;
                                if (item.isDiscontinued()) {
                                    JOptionPane.showMessageDialog((Component)((Object)this), "Discontinued Item - Last item sold, take auction down.", "Discontinued Notification", 1);
                                } else {
                                    JOptionPane.showMessageDialog((Component)((Object)this), "This order consumed the last item in stock, time to reorder.", "Out of Stock Notification", 1);
                                }
                                break block21;
                            }
                            this.formattedCreateTable.setValue((Object)false, rowChanged, "Inventory");
                            break block21;
                        }
                        boolean found = false;
                        while (iter.hasNext() && !found) {
                            ArrayList itemList = (ArrayList)iter.next();
                            if (!((InventoryElement)itemList.get(0)).getItemID().toLowerCase().trim().equals(itemName)) continue;
                            found = true;
                            this.formattedCreateTable.setValue((Object)false, rowChanged, "Inventory");
                            if (((InventoryElement)itemList.get(0)).getItemQuantity() < 0) {
                                ((InventoryElement)itemList.get(0)).setItemQuantity(((InventoryElement)itemList.get(0)).getItemQuantity() + 1);
                                LookupServicesUtil.getDBServices().setInventoryElement((InventoryElement)itemList.get(0));
                                continue;
                            }
                            boolean priceMatch = false;
                            for (int i = 1; i < itemList.size(); ++i) {
                                if (((InventoryElement)itemList.get(i)).getItemCost() != Float.parseFloat(wholeSaleCost)) continue;
                                priceMatch = true;
                                ((InventoryElement)itemList.get(i)).setItemQuantity(((InventoryElement)itemList.get(i)).getItemQuantity() + 1);
                                LookupServicesUtil.getDBServices().setInventoryElement((InventoryElement)itemList.get(i));
                                break;
                            }
                            if (priceMatch) continue;
                            InventoryElement element = new InventoryElement();
                            element.setItem(((InventoryElement)itemList.get(0)).getItem());
                            element.setItemCost(Float.parseFloat(wholeSaleCost));
                            element.setItemID(itemName);
                            element.setItemQuantity(1);
                            element.setOosItem(false);
                            LookupServicesUtil.getDBServices().setInventoryElement(element);
                        }
                    }
                    ListenerManager.getInstance().notify((GenericListener)ListenerManager.INVENTORY_LIST_LISTENER);
                    break block16;
                }
                if (e.getColumn() == ((Integer)this.formattedCreateTable.getReverseColumnMap().get("Wholesale $")).intValue() || e.getColumn() == ((Integer)this.formattedCreateTable.getReverseColumnMap().get("Retail $")).intValue()) {
                    this.checkOrder();
                }
            }
            this.updateCreatedOrders();
            this._disableListener = false;
        }
    }

    public void programClosed() {
        for (int i = 0; i < this.formattedCreateTable.getFormattedTable().getRowCount(); ++i) {
            boolean found = false;
            String itemName = this.formattedCreateTable.getValue(i, "Item SKU");
            Collection inventoryElements = LookupServicesUtil.getDBServices().getInventoryList(itemName, false, false, false, new String[0], false);
            Iterator iter = inventoryElements.iterator();
            while (iter.hasNext() && !found) {
                ArrayList itemList = (ArrayList)iter.next();
                if (!((InventoryElement)itemList.get(0)).getItemID().toLowerCase().trim().equals(itemName)) continue;
                found = true;
                if (((InventoryElement)itemList.get(0)).getItemQuantity() < 0) {
                    ((InventoryElement)itemList.get(0)).setItemQuantity(((InventoryElement)itemList.get(0)).getItemQuantity() + 1);
                    LookupServicesUtil.getDBServices().setInventoryElement((InventoryElement)itemList.get(0));
                    continue;
                }
                boolean priceMatch = false;
                for (int j = 1; j < itemList.size(); ++j) {
                    if (((InventoryElement)itemList.get(j)).getItemCost() != Float.valueOf(this.formattedCreateTable.getValue(i, "Wholesale $")).floatValue()) continue;
                    priceMatch = true;
                    ((InventoryElement)itemList.get(j)).setItemQuantity(((InventoryElement)itemList.get(j)).getItemQuantity() + 1);
                    LookupServicesUtil.getDBServices().setInventoryElement((InventoryElement)itemList.get(j));
                    break;
                }
                if (priceMatch) continue;
                InventoryElement element = new InventoryElement();
                element.setItem(((InventoryElement)itemList.get(0)).getItem());
                element.setItemCost(Float.valueOf(this.formattedCreateTable.getValue(i, "Wholesale $")).floatValue());
                element.setItemID(itemName);
                element.setItemQuantity(1);
                element.setOosItem(false);
                LookupServicesUtil.getDBServices().setInventoryElement(element);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.formattedCreateTable.getFormattedTable().getRowCount() != 0 && this.formattedCreateTable.getFormattedTable().getSelectedRow() != -1) {
            this.deleteButton.setEnabled(true);
        } else {
            this.deleteButton.setEnabled(false);
        }
    }

    class JTextFieldLimit
    extends PlainDocument {
        private int limit;

        JTextFieldLimit(int limit) {
            this.limit = limit;
        }

        JTextFieldLimit(int limit, boolean upper) {
            this.limit = limit;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (this.getLength() + str.length() <= this.limit) {
                super.insertString(offset, str, attr);
            }
        }
    }
}

