/*
 * Decompiled with CFR 0.152.
 */
package pnp.managers.ordermanager;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.openide.util.NbBundle;
import pnp.services.compare.InventoryComparator;
import pnp.services.constants.FrameConstants;
import pnp.services.datatypes.Distributor;
import pnp.services.datatypes.InventoryElement;
import pnp.services.datatypes.Item;
import pnp.services.datatypes.OrderDetails;
import pnp.services.listener.GenericListener;
import pnp.services.listenermanager.ListenerManager;
import pnp.services.preferencemanager.Preferences;
import pnp.services.util.LookupServicesUtil;
import pnp.services.util.MathParser;

public class InventorySelectionForm
extends JDialog {
    private JCheckBox addItemInhouseCheckBox;
    private JButton cancelButton;
    private JComboBox distributorComboBox;
    private JButton finishButton;
    private JTable inventorySelectionTable;
    private JTextField itemIdTextField;
    private JTextField itemNameTextField;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel9;
    private JScrollPane jScrollPane4;
    private JTextField locationTextField;
    private JButton newDistributorButton;
    private JTextField packedWeightTextField;
    private JTextField quantityTextField;
    private JCheckBox showAllCheckBox;
    private JButton submitItemButton;
    private JTextField weightTextField;
    private JTextField wholesaleCostTextField;
    private HashMap<Integer, Distributor> _distributorList;
    private HashMap<Integer, InventoryElement> _inventoryElements;
    private ArrayList<Integer> _inventoryMapping;
    private HashMap<String, Distributor> _distributorStringList;
    private InventoryElement _selectedItem;
    private int inventoryItemIDColumn = 0;
    private int inventoryItemNameColumn = 1;
    private int inventoryQuantityColumn = 2;
    private int inventoryWholesalePriceColumn = 3;
    private int inventoryWeightColumn = 4;
    private int inventoryPackedWeightColumn = 5;
    private int inventoryLocationColumn = 6;
    private int inventoryDistributorColumn = 7;
    private int inventoryInhouseColumn = 8;
    private String _itemName;

    public InventorySelectionForm(Frame parent, boolean modal, String itemName) {
        super(parent, modal);
        this.initComponents();
        this._itemName = itemName;
        this.init();
    }

    private void init() {
        this.inventoryItemIDColumn = this.inventorySelectionTable.getColumnModel().getColumnIndex("Item ID");
        this.inventoryItemNameColumn = this.inventorySelectionTable.getColumnModel().getColumnIndex("Item Name");
        this.inventoryQuantityColumn = this.inventorySelectionTable.getColumnModel().getColumnIndex("Quantity");
        this.inventoryWholesalePriceColumn = this.inventorySelectionTable.getColumnModel().getColumnIndex("Wholesale Price");
        this.inventoryWeightColumn = this.inventorySelectionTable.getColumnModel().getColumnIndex("Weight");
        this.inventoryPackedWeightColumn = this.inventorySelectionTable.getColumnModel().getColumnIndex("Packed Weight");
        this.inventoryLocationColumn = this.inventorySelectionTable.getColumnModel().getColumnIndex("Location");
        this.inventoryDistributorColumn = this.inventorySelectionTable.getColumnModel().getColumnIndex("Distributor");
        this.inventoryInhouseColumn = this.inventorySelectionTable.getColumnModel().getColumnIndex("Inventory");
        for (int i = 0; i < this.inventorySelectionTable.getColumnCount(); ++i) {
            this.inventorySelectionTable.setDefaultRenderer(this.inventorySelectionTable.getColumnClass(i), new CellColorRenderer());
        }
        TableColumn col = this.inventorySelectionTable.getColumnModel().getColumn(this.inventoryInhouseColumn);
        JCheckBox inhouseCheckBox = new JCheckBox();
        inhouseCheckBox.setHorizontalAlignment(0);
        col.setCellEditor(new DefaultCellEditor(inhouseCheckBox));
        col.setCellRenderer(new CheckBoxRenderer(false));
        this._selectedItem = null;
        this._distributorList = new HashMap();
        this._distributorStringList = new HashMap();
        this._inventoryMapping = new ArrayList();
        this._inventoryElements = new HashMap();
        Distributor[] distributors = LookupServicesUtil.getDBServices().getDistributors();
        for (int i = 0; i < distributors.length; ++i) {
            this._distributorStringList.put(distributors[i].getDistributorName(), distributors[i]);
            this._distributorList.put(distributors[i].getDistributorID(), distributors[i]);
            this.distributorComboBox.addItem(distributors[i].getDistributorName());
        }
        this.inventorySelectionTable.setShowGrid(false);
        this.updateInventoryList();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.finishButton = new JButton();
        this.showAllCheckBox = new JCheckBox();
        this.cancelButton = new JButton();
        this.jScrollPane4 = new JScrollPane();
        this.inventorySelectionTable = new JTable();
        this.jPanel9 = new JPanel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.distributorComboBox = new JComboBox();
        this.newDistributorButton = new JButton();
        this.itemNameTextField = new JTextField();
        this.itemIdTextField = new JTextField();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.wholesaleCostTextField = new JTextField();
        this.quantityTextField = new JTextField();
        this.weightTextField = new JTextField();
        this.submitItemButton = new JButton();
        this.addItemInhouseCheckBox = new JCheckBox();
        this.locationTextField = new JTextField();
        this.jLabel14 = new JLabel();
        this.jLabel1 = new JLabel();
        this.packedWeightTextField = new JTextField();
        this.setDefaultCloseOperation(2);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.jPanel1.border.title")));
        this.finishButton.setText(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.finishButton.text"));
        this.finishButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InventorySelectionForm.this.finishButtonActionPerformed(evt);
            }
        });
        this.showAllCheckBox.setText(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.showAllCheckBox.text"));
        this.showAllCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InventorySelectionForm.this.showAllCheckBoxActionPerformed(evt);
            }
        });
        this.cancelButton.setText(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.cancelButton.text"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InventorySelectionForm.this.cancelButtonActionPerformed(evt);
            }
        });
        this.inventorySelectionTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}}, new String[]{"Item ID", "Item Name", "Quantity", "Wholesale Price", "Weight", "Packed Weight", "Location", "Distributor", "Inventory"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, Boolean.class};
                this.canEdit = new boolean[]{false, false, false, false, false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.inventorySelectionTable.setColumnSelectionAllowed(true);
        this.inventorySelectionTable.setSelectionMode(0);
        this.jScrollPane4.setViewportView(this.inventorySelectionTable);
        this.inventorySelectionTable.getColumnModel().getSelectionModel().setSelectionMode(0);
        this.inventorySelectionTable.getColumnModel().getColumn(0).setHeaderValue(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.inventorySelectionTable.columnModel.title0"));
        this.inventorySelectionTable.getColumnModel().getColumn(1).setHeaderValue(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.inventorySelectionTable.columnModel.title1"));
        this.inventorySelectionTable.getColumnModel().getColumn(2).setHeaderValue(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.inventorySelectionTable.columnModel.title2"));
        this.inventorySelectionTable.getColumnModel().getColumn(3).setHeaderValue(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.inventorySelectionTable.columnModel.title3"));
        this.inventorySelectionTable.getColumnModel().getColumn(4).setHeaderValue(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.inventorySelectionTable.columnModel.title4"));
        this.inventorySelectionTable.getColumnModel().getColumn(5).setHeaderValue(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.inventorySelectionTable.columnModel.title8"));
        this.inventorySelectionTable.getColumnModel().getColumn(6).setHeaderValue(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.inventorySelectionTable.columnModel.title5"));
        this.inventorySelectionTable.getColumnModel().getColumn(7).setHeaderValue(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.inventorySelectionTable.columnModel.title6"));
        this.inventorySelectionTable.getColumnModel().getColumn(8).setHeaderValue(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.inventorySelectionTable.columnModel.title7"));
        this.jPanel9.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.jPanel9.border.title")));
        this.jLabel8.setText(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.jLabel8.text"));
        this.jLabel9.setText(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.jLabel9.text"));
        this.jLabel10.setText(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.jLabel10.text"));
        this.newDistributorButton.setText(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.newDistributorButton.text"));
        this.newDistributorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InventorySelectionForm.this.newDistributorButtonActionPerformed(evt);
            }
        });
        this.itemNameTextField.setText(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.itemNameTextField.text"));
        this.itemNameTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                InventorySelectionForm.this.itemNameTextFieldKeyReleased(evt);
            }
        });
        this.itemIdTextField.setText(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.itemIdTextField.text"));
        this.itemIdTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                InventorySelectionForm.this.itemIdTextFieldKeyReleased(evt);
            }
        });
        this.jLabel11.setText(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.jLabel11.text"));
        this.jLabel12.setText(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.jLabel12.text"));
        this.jLabel13.setText(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.jLabel13.text"));
        this.wholesaleCostTextField.setText(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.wholesaleCostTextField.text"));
        this.wholesaleCostTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                InventorySelectionForm.this.wholesaleCostTextFieldKeyReleased(evt);
            }
        });
        this.quantityTextField.setText(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.quantityTextField.text"));
        this.quantityTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                InventorySelectionForm.this.quantityTextFieldKeyReleased(evt);
            }
        });
        this.weightTextField.setText(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.weightTextField.text"));
        this.weightTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                InventorySelectionForm.this.weightTextFieldKeyReleased(evt);
            }
        });
        this.submitItemButton.setText(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.submitItemButton.text"));
        this.submitItemButton.setEnabled(false);
        this.submitItemButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InventorySelectionForm.this.submitItemButtonActionPerformed(evt);
            }
        });
        this.addItemInhouseCheckBox.setText(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.addItemInhouseCheckBox.text"));
        this.addItemInhouseCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InventorySelectionForm.this.addItemInhouseCheckBoxActionPerformed(evt);
            }
        });
        this.locationTextField.setText(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.locationTextField.text"));
        this.locationTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                InventorySelectionForm.this.locationTextFieldKeyReleased(evt);
            }
        });
        this.jLabel14.setText(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.jLabel14.text"));
        this.jLabel1.setText(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.jLabel1.text"));
        this.packedWeightTextField.setText(NbBundle.getMessage(InventorySelectionForm.class, (String)"InventorySelectionForm.packedWeightTextField.text"));
        this.packedWeightTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                InventorySelectionForm.this.packedWeightTextFieldKeyReleased(evt);
            }
        });
        GroupLayout jPanel9Layout = new GroupLayout(this.jPanel9);
        this.jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addContainerGap().addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel9Layout.createSequentialGroup().addComponent(this.jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.weightTextField, -2, 71, -2)).addGroup(jPanel9Layout.createSequentialGroup().addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel9Layout.createSequentialGroup().addComponent(this.jLabel14).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(jPanel9Layout.createSequentialGroup().addComponent(this.jLabel1).addGap(2, 2, 2))).addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.locationTextField, -1, 71, Short.MAX_VALUE).addComponent(this.packedWeightTextField)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.submitItemButton, -2, 88, -2)).addGroup(jPanel9Layout.createSequentialGroup().addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.distributorComboBox, -2, 104, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.newDistributorButton, -2, 24, -2)).addGroup(jPanel9Layout.createSequentialGroup().addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.itemIdTextField, -2, 71, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.addItemInhouseCheckBox)).addGroup(jPanel9Layout.createSequentialGroup().addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.quantityTextField, -2, 71, -2)).addGroup(jPanel9Layout.createSequentialGroup().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.itemNameTextField, -2, 181, -2)).addGroup(jPanel9Layout.createSequentialGroup().addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.wholesaleCostTextField, -2, 71, -2))).addContainerGap()));
        jPanel9Layout.linkSize(0, this.jLabel11, this.jLabel12, this.jLabel13, this.jLabel14, this.jLabel8, this.jLabel9);
        jPanel9Layout.setVerticalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.distributorComboBox, -2, -1, -2).addComponent(this.newDistributorButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.itemIdTextField, -2, -1, -2).addComponent(this.jLabel8).addComponent(this.addItemInhouseCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.itemNameTextField, -2, -1, -2).addComponent(this.jLabel9)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.wholesaleCostTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel12).addComponent(this.quantityTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.weightTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.packedWeightTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel14).addComponent(this.locationTextField, -2, -1, -2).addComponent(this.submitItemButton))));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap(867, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.finishButton).addGap(6, 6, 6)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.showAllCheckBox).addGap(210, 210, 210)).addComponent(this.jPanel9, GroupLayout.Alignment.TRAILING, -2, -1, -2)).addContainerGap()).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane4, -2, 832, -2).addContainerGap(310, Short.MAX_VALUE))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.showAllCheckBox).addGap(18, 18, 18).addComponent(this.jPanel9, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 130, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.finishButton).addComponent(this.cancelButton))).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane4, -1, 413, Short.MAX_VALUE))));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void finishButtonActionPerformed(ActionEvent evt) {
        if (this.inventorySelectionTable.getSelectedRow() != -1) {
            this._selectedItem = this._inventoryElements.get(this._inventoryMapping.get(this.inventorySelectionTable.getSelectedRow()));
        }
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this._selectedItem = null;
        this.setVisible(false);
    }

    private void newDistributorButtonActionPerformed(ActionEvent evt) {
        Preferences.getInstance().openTab(Preferences.Index.Distributor);
    }

    private void itemNameTextFieldKeyReleased(KeyEvent evt) {
        this.verifyItem();
    }

    private void itemIdTextFieldKeyReleased(KeyEvent evt) {
        this.verifyItem();
    }

    private void wholesaleCostTextFieldKeyReleased(KeyEvent evt) {
        this.verifyItem();
    }

    private void quantityTextFieldKeyReleased(KeyEvent evt) {
        this.verifyItem();
    }

    private void weightTextFieldKeyReleased(KeyEvent evt) {
        this.verifyItem();
    }

    private void submitItemButtonActionPerformed(ActionEvent evt) {
        int i;
        ArrayList<InventoryElement> elements = new ArrayList<InventoryElement>();
        Item item = new Item();
        item.setDistributorID(this._distributorStringList.get((String)this.distributorComboBox.getSelectedItem()).getDistributorID());
        item.setDropShipped(this.addItemInhouseCheckBox.isSelected());
        item.setItemID(this.itemIdTextField.getText());
        item.setItemName(this.itemNameTextField.getText());
        String amount = MathParser.isDollarAmount((String)this.weightTextField.getText().trim());
        if (null != amount) {
            item.setItemWeight(Float.valueOf(amount).floatValue());
        }
        if (null != (amount = MathParser.isDollarAmount((String)this.packedWeightTextField.getText().trim()))) {
            item.setPackedWeight(Float.valueOf(amount).floatValue());
        }
        item.setLocation(this.locationTextField.getText());
        InventoryElement element = new InventoryElement();
        element.setItem(item);
        amount = MathParser.isDollarAmount((String)this.wholesaleCostTextField.getText().trim());
        if (null != amount) {
            element.setItemCost(Float.valueOf(amount).floatValue());
        }
        element.setItemID(item.getItemID());
        amount = MathParser.isDollarAmount((String)this.quantityTextField.getText().trim());
        if (null != amount) {
            float quantity = Float.valueOf(amount).floatValue();
            element.setItemQuantity((int)quantity);
        }
        element.setOosItem(false);
        HashMap<String, OrderDetails> oosList = new HashMap<String, OrderDetails>();
        HashMap<String, InventoryElement> baseList = new HashMap<String, InventoryElement>();
        OrderDetails[] oosDetails = LookupServicesUtil.getDBServices().getOosOrderDetails();
        InventoryElement[] baseInventory = LookupServicesUtil.getDBServices().getOosInventory();
        for (i = 0; i < oosDetails.length; ++i) {
            oosList.put(oosDetails[i].getItemID(), oosDetails[i]);
        }
        for (i = 0; i < baseInventory.length; ++i) {
            baseList.put(baseInventory[i].getItemID(), baseInventory[i]);
        }
        if (oosList.containsKey(element.getItemID())) {
            OrderDetails orderDetails = (OrderDetails)oosList.get(element.getItemID());
            orderDetails.setBackordered(false);
            orderDetails.setItemCost(element.getItemCost());
            element.setItemQuantity(element.getItemQuantity() - 1);
            LookupServicesUtil.getDBServices().updateOosOrder(orderDetails);
        }
        if (!baseList.containsKey(item.getItemID())) {
            InventoryElement baseElement = new InventoryElement();
            baseElement.setItem(element.getItem());
            baseElement.setItemID(element.getItemID());
            baseElement.setItemQuantity(0);
            baseElement.setOosItem(true);
            baseElement.setItemCost(element.getItemCost());
            elements.add(baseElement);
        }
        elements.add(element);
        LookupServicesUtil.getDBServices().setInventoryElementChain(elements);
        LookupServicesUtil.getDBServices().setItem(item);
        this.addItemInhouseCheckBox.setSelected(false);
        this.itemIdTextField.setText("");
        this.itemNameTextField.setText("");
        this.wholesaleCostTextField.setText("");
        this.quantityTextField.setText("");
        this.quantityTextField.setText("");
        this.weightTextField.setText("");
        this.packedWeightTextField.setText("");
        this.locationTextField.setText("");
        this.submitItemButton.setEnabled(false);
        ListenerManager.getInstance().notify((GenericListener)ListenerManager.INVENTORY_LIST_LISTENER);
        this.updateInventoryList();
    }

    private void addItemInhouseCheckBoxActionPerformed(ActionEvent evt) {
        this.verifyItem();
    }

    private void locationTextFieldKeyReleased(KeyEvent evt) {
        this.verifyItem();
    }

    private void packedWeightTextFieldKeyReleased(KeyEvent evt) {
        this.verifyItem();
    }

    private void showAllCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void verifyItem() {
        boolean valid = true;
        if (this.itemIdTextField.getText().trim().equals("")) {
            valid = false;
        }
        if (this.itemNameTextField.getText().trim().equals("")) {
            valid = false;
        }
        if (null == MathParser.isDollarAmount((String)this.wholesaleCostTextField.getText().trim())) {
            valid = false;
        }
        if (null == MathParser.isDollarAmount((String)this.quantityTextField.getText().trim())) {
            valid = false;
        }
        if (null == MathParser.isDollarAmount((String)this.quantityTextField.getText().trim())) {
            valid = false;
        }
        if (null == MathParser.isDollarAmount((String)this.weightTextField.getText().trim())) {
            valid = false;
        }
        if (null == MathParser.isDollarAmount((String)this.packedWeightTextField.getText().trim())) {
            valid = false;
        }
        if (valid) {
            this.submitItemButton.setEnabled(true);
        } else {
            this.submitItemButton.setEnabled(false);
        }
    }

    public InventoryElement getSelectedItem() {
        return this._selectedItem;
    }

    private void updateInventoryList() {
        Object[] row;
        Collection inventoryList = this.showAllCheckBox.isSelected() ? LookupServicesUtil.getDBServices().getInventoryList() : LookupServicesUtil.getDBServices().getInventoryList(this._itemName, false, false, false, new String[0], false);
        DefaultTableModel tableModel = (DefaultTableModel)this.inventorySelectionTable.getModel();
        tableModel.setNumRows(0);
        Iterator iter = inventoryList.iterator();
        ArrayList<InventoryElement> prunedList = new ArrayList<InventoryElement>();
        while (iter.hasNext()) {
            boolean found = false;
            ArrayList inventoryItem = (ArrayList)iter.next();
            row = new Object[tableModel.getColumnCount()];
            InventoryElement inventoryElement = new InventoryElement();
            for (int i = 1; i < inventoryItem.size(); ++i) {
                InventoryElement tempElement = (InventoryElement)inventoryItem.get(i);
                if (tempElement.getItemQuantity() <= 0) continue;
                if (found) {
                    if (!(tempElement.getItemCost() < inventoryElement.getItemCost())) continue;
                    inventoryElement = tempElement;
                    continue;
                }
                inventoryElement = tempElement;
                found = true;
            }
            if (!found) {
                inventoryElement = (InventoryElement)inventoryItem.get(0);
            }
            prunedList.add(inventoryElement);
        }
        InventoryElement[] sortedList = prunedList.toArray(new InventoryElement[0]);
        Arrays.sort(sortedList, new InventoryComparator(InventoryComparator.ITEM_ID));
        for (int i = 0; i < sortedList.length; ++i) {
            row = new Object[tableModel.getColumnCount()];
            this._inventoryElements.put(sortedList[i].getInventoryID(), sortedList[i]);
            row[this.inventoryItemIDColumn] = sortedList[i].getItemID();
            Item item = LookupServicesUtil.getDBServices().getItem(sortedList[i].getItemID());
            if (null != item) {
                row[this.inventoryItemNameColumn] = item.getItemName();
                row[this.inventoryWeightColumn] = String.valueOf(item.getItemWeight());
                row[this.inventoryPackedWeightColumn] = String.valueOf(item.getPackedWeight());
                row[this.inventoryLocationColumn] = item.getLocation();
                row[this.inventoryInhouseColumn] = !item.isDropShipped();
                row[this.inventoryDistributorColumn] = this._distributorList.containsKey(item.getDistributorID()) ? this._distributorList.get(item.getDistributorID()).getDistributorName() : "";
            }
            row[this.inventoryQuantityColumn] = String.valueOf(sortedList[i].getItemQuantity());
            row[this.inventoryWholesalePriceColumn] = String.valueOf(sortedList[i].getItemCost());
            tableModel.addRow(row);
            this._inventoryMapping.add(sortedList[i].getInventoryID());
        }
    }

    private class CellColorRenderer
    extends DefaultTableCellRenderer {
        private CellColorRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (table.getSelectedRow() == row) {
                this.setBackground(new Color(FrameConstants.SELECTED_ROW));
                return c;
            }
            if (row % 2 == 0) {
                this.setBackground(new Color(FrameConstants.ROW_COLOR_1));
            } else {
                this.setBackground(new Color(FrameConstants.ROW_COLOR_2));
            }
            return c;
        }
    }

    private class CheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public CheckBoxRenderer(boolean value) {
            super("", value);
        }

        @Override
        public void updateUI() {
            super.updateUI();
        }

        @Override
        public void revalidate() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setSelected(value != null && (Boolean)value != false);
            this.setHorizontalAlignment(0);
            if (table.getSelectedRow() == row) {
                this.setBackground(new Color(FrameConstants.SELECTED_ROW));
                return this;
            }
            if (row % 2 == 0) {
                this.setBackground(new Color(FrameConstants.ROW_COLOR_1));
            } else {
                this.setBackground(new Color(FrameConstants.ROW_COLOR_2));
            }
            return this;
        }
    }
}

