/*
 * Decompiled with CFR 0.152.
 */
package pnp.managers.ordermanager;

import com.toedter.calendar.JDateChooser;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import pnp.managers.ordermanager.ActiveOrdersFormX;
import pnp.managers.ordermanager.InventorySelectionForm;
import pnp.managers.ordermanager.ToggleBox;
import pnp.managers.ordermanager.UpdateCustomFeeListForm;
import pnp.managers.paypalmanager.PaypalManagerTopComponent;
import pnp.services.authenticationmanager.SubscriptionManager;
import pnp.services.compare.CompleteOrderComparator;
import pnp.services.datatypes.AccountPreferences;
import pnp.services.datatypes.CompleteOrder;
import pnp.services.datatypes.CustomFee;
import pnp.services.datatypes.Distributor;
import pnp.services.datatypes.InventoryElement;
import pnp.services.datatypes.Item;
import pnp.services.datatypes.Order;
import pnp.services.datatypes.OrderDetails;
import pnp.services.datatypes.OrderStatus;
import pnp.services.datatypes.RMADetails;
import pnp.services.datatypes.RMAReason;
import pnp.services.datatypes.RMAStatus;
import pnp.services.datatypes.filefilters.PDFFielFilter;
import pnp.services.datatypes.filefilters.TextFileFilter;
import pnp.services.datatypes.webservices.Website;
import pnp.services.listener.ClosingListener;
import pnp.services.listener.CustomFeeListener;
import pnp.services.listener.EbayAccountListener;
import pnp.services.listener.GenericListener;
import pnp.services.listener.InvoiceProgressListener;
import pnp.services.listener.LoginListener;
import pnp.services.listener.OrderListListener;
import pnp.services.listener.UpdateStatusListener;
import pnp.services.listener.WebsiteListListener;
import pnp.services.listenermanager.ListenerManager;
import pnp.services.preferencemanager.Preferences;
import pnp.services.util.CreationTools;
import pnp.services.util.ErrorsUtil;
import pnp.services.util.FeeProcessor;
import pnp.services.util.LookupServicesUtil;
import pnp.services.util.MathParser;

@TopComponent.Description(preferredID="OrderManagerTopComponent", persistenceType=1)
public final class OrderManagerTopComponent
extends TopComponent
implements OrderListListener,
TableModelListener,
ListSelectionListener,
ClosingListener,
EbayAccountListener,
UpdateStatusListener,
WebsiteListListener,
CustomFeeListener,
InvoiceProgressListener,
LoginListener {
    private static OrderManagerTopComponent instance;
    private boolean _dataChanged;
    private String inventoryWarningMessage;
    private int currentProgress;
    private int totalProgress;
    private JCheckBox NIACheckbox;
    private JCheckBox OCCheckbox;
    private ActiveOrdersFormX activeOrdersFormX;
    private JCheckBox adminHoldCheckBox;
    private JCheckBox adminHoldSearchFilterCheckBox;
    private JButton applyChangesButton;
    private JLabel applyChangesLabel;
    private JButton applyCommentsButton;
    private JButton bulkInventoryButton;
    private JCheckBox canceledSearchFilterCheckBox;
    private JButton clearChangesButton;
    private JCheckBox completeSearchFilterCheckBox;
    private JButton createInvoiceButton;
    private JButton createRMAButton;
    private JTable customFeeTable;
    private JButton customerApplyCommentsButton;
    private JTextArea customerCommentsTextArea;
    private JPanel dateRangePanel;
    private JButton deleteButton;
    private JButton exportLabelsButton;
    private JCheckBox exportLabelsCheckBox;
    private JCheckBox exportLabelsSearchFilterCheckBox;
    private JPanel feePanel;
    private JPanel filterJPanel;
    private JDateChooser fromDateChooser;
    private JLabel inhouseWeightField;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel2;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel28;
    private JLabel jLabel29;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JTabbedPane jTabbedPane1;
    private JComboBox lastUpdateComboBox;
    private JButton mergeButton;
    private JCheckBox multiOrderCheckBox;
    private JCheckBox newFilterCheckBox;
    private JCheckBox newSearchFilterCheckBox;
    private JCheckBox npbFilterCheckBox;
    private JCheckBox npbSearchFilterCheckBox;
    private JComboBox numResults;
    private JCheckBox oosFilterCheckBox;
    private JCheckBox oosSearchFilterCheckBox;
    private JLabel orderAmount;
    private JTextArea orderCommentsTextArea;
    private JButton orderSplitButton;
    private JLabel paypalFeeLabel;
    private JCheckBox pendingECheckCheckBox;
    private JCheckBox pendingECheckSearchFilterCheckBox;
    private JCheckBox pendingFilterCheckBox;
    private JCheckBox pendingMOCheckBox;
    private JCheckBox pendingMOSearchFilterCheckBox;
    private JCheckBox pendingPrintCheckBox;
    private JCheckBox pendingPrintSearchFilterCheckBox;
    private JCheckBox pendingSearchFilterCheckBox;
    private JCheckBox pendingTrackingCheckBox;
    private JButton refreshAmazonOnlyButton;
    private JButton refreshListButton;
    private JProgressBar refreshProgressBar;
    private JLabel resultsShown;
    private JButton searchButton;
    private JTextField searchField;
    private JLabel shippingCostLabel;
    private JTextField shippingMethodTextField;
    private JComboBox sortComboBox;
    private JLabel startupLabel;
    private JLabel subtotalLabel;
    private JLabel timeStampLabel;
    private JDateChooser toDateChooser;
    private JLabel totalLabel;
    private JLabel totalWeightField;
    private JComboBox trackingCarrierTypeBox;
    private JTextField trackingIdTextField;
    private JButton unMergeButton;
    private JCheckBox updateAllTrackingCheckBox;
    private JButton updateCustomFeeListButton;
    private JButton updateTrackingButton;
    private JLabel usernameLabel;
    private JLabel wholesaleCostLabel;
    private HashMap<String, Website> _websiteList;
    private HashMap<String, ChangedCell> _validCellChanges;
    private HashMap<String, ChangedCell> _invalidCellChanges;
    private HashMap<Integer, Integer> _updatedOrders;
    private HashMap<String, OrderStatus> _statusList;
    private HashMap<String, Distributor> _distributorStringList;
    private ArrayList<CustomFee> _customFeeMapping;
    private JFileChooser _invoiceLocation;
    private JFileChooser _exportLocation;
    private ArrayList<OrderStatus> _statusFilters;
    private HashMap<String, String> _negativeProfit;
    private HashMap<Integer, CompleteOrder> _completeOrders;
    private ArrayList<Integer> _orderMapping;
    private boolean disableListener;
    private boolean exportingOrders;
    private int _currentRow = -1;
    private int _sortBy = 0;
    private boolean _commentBoxUpdated = false;
    private boolean _customerCommentBoxUpdated = false;
    private boolean _shippingMethodTextUpdated = false;
    private boolean _trackingTextUpdated = false;
    private boolean closing = false;
    private String startDate;
    private String endDate;
    private boolean currentStatus = true;

    public OrderManagerTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(OrderManagerTopComponent.class, (String)"CTL_OrderManagerTopComponent"));
        this.setToolTipText(NbBundle.getMessage(OrderManagerTopComponent.class, (String)"HINT_OrderManagerTopComponent"));
        this.LoginToggle();
        this.init();
    }

    private void instantiateVariables() {
        this.currentProgress = 0;
        this.totalProgress = 0;
        this.inventoryWarningMessage = "";
        this._statusFilters = new ArrayList();
        this._statusList = new HashMap();
        this._dataChanged = false;
        this.exportingOrders = false;
        this.fromDateChooser.setDateFormatString("MM/dd/yy");
        this.toDateChooser.setDateFormatString("MM/dd/yy");
        this._invoiceLocation = new JFileChooser();
        this._invoiceLocation.setFileFilter((FileFilter)new PDFFielFilter());
        this._exportLocation = new JFileChooser();
        this._exportLocation.setFileFilter((FileFilter)new TextFileFilter());
        this._sortBy = CompleteOrderComparator.ORDER_DATE;
        this._negativeProfit = new HashMap();
        this._completeOrders = new HashMap();
        this._customFeeMapping = new ArrayList();
        this._orderMapping = new ArrayList();
        this._updatedOrders = new HashMap();
        this._validCellChanges = new HashMap();
        this._invalidCellChanges = new HashMap();
        this._websiteList = new HashMap();
        this._distributorStringList = new HashMap();
        this.disableListener(false);
        Distributor[] distributors = LookupServicesUtil.getDBServices().getDistributors();
        for (int i = 0; i < distributors.length; ++i) {
            this._distributorStringList.put(distributors[i].getDistributorName(), distributors[i]);
        }
        this._statusList = LookupServicesUtil.getDBServices().getAvailableFilters();
        this.startupLabel.setText("IDLE");
        this.applyChangesLabel.setText("");
        this.refreshProgressBar.setVisible(false);
        this.refreshProgressBar.setMinimum(0);
        this.refreshProgressBar.setMaximum(100);
        if (!SubscriptionManager.getInstance().isInventoryActive()) {
            this.inhouseWeightField.setText("N/A");
        }
    }

    private void createTables() {
        this.activeOrdersFormX.init();
        this.activeOrdersFormX.setParent(this);
        this.activeOrdersFormX.getOrderDetails().getModel().addTableModelListener(this);
        this.activeOrdersFormX.getOrderDetails().getSelectionModel().addListSelectionListener(this);
        this.customFeeTable.setShowGrid(false);
    }

    private void doWork() {
        this.websiteListUpdated();
        this.customFeeListUpdated();
        this.filterAction(this.newFilterCheckBox.isSelected(), "New");
        this.updateDateRange();
        ListenerManager.getInstance().subscribe((GenericListener)this);
        ListenerManager.getInstance().notify((GenericListener)ListenerManager.TRANSACTION_LISTENER);
    }

    public void init() {
        this.instantiateVariables();
        this.createTables();
        this.doWork();
    }

    private void updateDateRange() {
        Date date = new Date();
        date.setDate(date.getDate() + 1);
        this.toDateChooser.setDate(date);
        date.setDate(date.getDate() - 1);
        date.setMonth(date.getMonth() - 3);
        this.fromDateChooser.setDate(date);
    }

    public void manageFilters() {
        String adminHold = "Admin Hold";
        String newFilter = "New";
        String pendingFilter = "Pending";
        String oosFilter = "OOS";
        String npbFilter = "NPB";
        String pendingPrint = "Pending Print";
        String pendingECheck = "Pending E-Check";
        String pendingMO = "Pending MO";
        String exportLabels = "Export Labels";
        HashMap filterQuantities = LookupServicesUtil.getDBServices().getFilterQuantities();
        for (OrderStatus status : filterQuantities.keySet()) {
            int quantity = (Integer)filterQuantities.get(status);
            if (status.getOrderStatusType().equalsIgnoreCase("Admin Hold")) {
                adminHold = adminHold + " [" + String.valueOf(quantity) + "]";
                continue;
            }
            if (status.getOrderStatusType().equalsIgnoreCase("Export Labels")) {
                exportLabels = exportLabels + " [" + String.valueOf(quantity) + "]";
                continue;
            }
            if (status.getOrderStatusType().equalsIgnoreCase("New")) {
                newFilter = newFilter + " [" + String.valueOf(quantity) + "]";
                continue;
            }
            if (status.getOrderStatusType().equalsIgnoreCase("NPB")) {
                npbFilter = npbFilter + " [" + String.valueOf(quantity) + "]";
                continue;
            }
            if (status.getOrderStatusType().equalsIgnoreCase("OOS")) {
                oosFilter = oosFilter + " [" + String.valueOf(quantity) + "]";
                continue;
            }
            if (status.getOrderStatusType().equalsIgnoreCase("Pending E-Check")) {
                pendingECheck = pendingECheck + " [" + String.valueOf(quantity) + "]";
                continue;
            }
            if (status.getOrderStatusType().equalsIgnoreCase("Pending MO")) {
                pendingMO = pendingMO + " [" + String.valueOf(quantity) + "]";
                continue;
            }
            if (status.getOrderStatusType().equalsIgnoreCase("Pending Print")) {
                pendingPrint = pendingPrint + " [" + String.valueOf(quantity) + "]";
                continue;
            }
            if (!status.getOrderStatusType().equalsIgnoreCase("Pending")) continue;
            pendingFilter = pendingFilter + " [" + String.valueOf(quantity) + "]";
        }
        this.adminHoldCheckBox.setText(adminHold);
        this.newFilterCheckBox.setText(newFilter);
        this.pendingFilterCheckBox.setText(pendingFilter);
        this.oosFilterCheckBox.setText(oosFilter);
        this.npbFilterCheckBox.setText(npbFilter);
        this.pendingPrintCheckBox.setText(pendingPrint);
        this.pendingECheckCheckBox.setText(pendingECheck);
        this.pendingMOCheckBox.setText(pendingMO);
        this.exportLabelsCheckBox.setText(exportLabels);
    }

    public void updateOrders() {
        this.valueChanged(null);
        this.disableListener(true);
        this.timeStampLabel.setText(LookupServicesUtil.getDBServices().getAccountPreferences().getEbayLastUpdateString());
        ArrayList orders = new ArrayList(LookupServicesUtil.getDBServices().getOrderList(false).values());
        Collections.sort(orders, new CompleteOrderComparator(this._sortBy));
        DefaultTableModel tableModel = (DefaultTableModel)this.activeOrdersFormX.getOrderDetails().getModel();
        this._orderMapping.clear();
        tableModel.setNumRows(0);
        int totalOrders = 0;
        Preferences.getInstance().getAccountPreferences().createPaypalMap();
        for (CompleteOrder completeOrder : orders) {
            try {
                completeOrder.setRowStart(tableModel.getRowCount());
                this._completeOrders.put(completeOrder.getOrder().getOrderID(), completeOrder);
                Object[] row = new Object[tableModel.getColumnCount()];
                row[this.activeOrdersFormX.getOrderIDColumn()] = completeOrder.getOrder().getOrderID();
                String paypalAccount = completeOrder.getOrder().getPaypalAccount();
                if (paypalAccount == null || paypalAccount.trim().isEmpty()) {
                    paypalAccount = Preferences.getInstance().getAccountPreferences().getCompanyDefaultCompany();
                }
                row[this.activeOrdersFormX.getPayPalAccountColumn()] = paypalAccount;
                row[this.activeOrdersFormX.getAddressColumn()] = completeOrder.getOrder().getCustomer().getCustomerAddress();
                row[this.activeOrdersFormX.getCityColumn()] = completeOrder.getOrder().getCustomer().getCustomerCity();
                row[this.activeOrdersFormX.getCountryColumn()] = completeOrder.getOrder().getCustomer().getCustomerCountry();
                row[this.activeOrdersFormX.getCustomerIDColumn()] = completeOrder.getOrder().getCustomer().getCustomerUserName();
                row[this.activeOrdersFormX.getEmailColumn()] = completeOrder.getOrder().getCustomer().getCustomerEmail();
                row[this.activeOrdersFormX.getNameColumn()] = completeOrder.getOrder().getCustomer().getCustomerName();
                row[this.activeOrdersFormX.getStateColumn()] = completeOrder.getOrder().getCustomer().getCustomerState();
                row[this.activeOrdersFormX.getZipcodeColumn()] = completeOrder.getOrder().getCustomer().getCustomerZipcode();
                row[this.activeOrdersFormX.getOrderDateColumn()] = completeOrder.getOrder().getOrderDate().toString();
                row[this.activeOrdersFormX.getOrderStatusColumn()] = completeOrder.getOrder().getOrderStatus().getOrderStatusType();
                row[this.activeOrdersFormX.getRetailCostColumn()] = String.valueOf(completeOrder.getOrder().getOrderTotal());
                row[this.activeOrdersFormX.getShCostColumn()] = String.valueOf(completeOrder.getOrder().getShippingCost());
                row[this.activeOrdersFormX.getShPaidColumn()] = String.valueOf(completeOrder.getOrder().getShippingPaid());
                boolean first = true;
                for (OrderDetails orderDetails : completeOrder.getOrderDetails()) {
                    ++totalOrders;
                    if (!first) {
                        row = new Object[tableModel.getColumnCount()];
                    }
                    if (null != orderDetails.getShipDate()) {
                        row[this.activeOrdersFormX.getShipDateColumn()] = orderDetails.getShipDate().toString();
                    }
                    row[this.activeOrdersFormX.getAccountNameColumn()] = orderDetails.getAccountName();
                    row[this.activeOrdersFormX.getEbaySiteColumn()] = orderDetails.getEbaySite();
                    row[this.activeOrdersFormX.getItemIDColumn()] = orderDetails.getItemID();
                    row[this.activeOrdersFormX.getItemNameColumn()] = orderDetails.getOrderDescription();
                    row[this.activeOrdersFormX.getRefNumberColumn()] = orderDetails.getOrderNumber();
                    row[this.activeOrdersFormX.getWholesaleCostColumn()] = String.valueOf(orderDetails.getItemCost());
                    if (null != orderDetails.getItemID() && !orderDetails.getItemID().equals("")) {
                        Item item = LookupServicesUtil.getDBServices().getItem(orderDetails.getItemID());
                        if (null != item) {
                            row[this.activeOrdersFormX.getShippingWeightColumn()] = String.valueOf(item.getItemWeight());
                            row[this.activeOrdersFormX.getPackedWeightColumn()] = String.valueOf(item.getPackedWeight());
                            row[this.activeOrdersFormX.getLocationColumn()] = String.valueOf(item.getLocation());
                        } else {
                            item = new Item();
                            item.setItemID(orderDetails.getItemID());
                            LookupServicesUtil.getDBServices().setItem(item);
                            row[this.activeOrdersFormX.getShippingWeightColumn()] = "0.0";
                            row[this.activeOrdersFormX.getPackedWeightColumn()] = "0.0";
                            row[this.activeOrdersFormX.getLocationColumn()] = "";
                        }
                    } else {
                        row[this.activeOrdersFormX.getShippingWeightColumn()] = "0.0";
                        row[this.activeOrdersFormX.getPackedWeightColumn()] = "0.0";
                        row[this.activeOrdersFormX.getLocationColumn()] = "";
                    }
                    row[this.activeOrdersFormX.getInhouseColumn()] = orderDetails.isInhouse();
                    row[this.activeOrdersFormX.getBackorderedColumn()] = orderDetails.isBackordered();
                    if (!orderDetails.isInhouse() && orderDetails.getEbayWeight() > 0.0f) {
                        row[this.activeOrdersFormX.getShippingWeightColumn()] = String.valueOf(orderDetails.getEbayWeight());
                    }
                    tableModel.addRow(row);
                    this._orderMapping.add(completeOrder.getOrder().getOrderID());
                    first = false;
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        this.resultsShown.setText(String.valueOf(totalOrders));
        this.disableListener(false);
        if (!LookupServicesUtil.getEbayServices().updatePending()) {
            this.startupLabel.setText("");
        }
        this.updateStatus();
    }

    public void disableListener(boolean disabled) {
        this.disableListener = disabled;
    }

    private void initComponents() {
        this.jScrollPane3 = new JScrollPane();
        this.jPanel4 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jLabel2 = new JLabel();
        this.feePanel = new JPanel();
        this.jLabel5 = new JLabel();
        this.paypalFeeLabel = new JLabel();
        this.jLabel11 = new JLabel();
        this.subtotalLabel = new JLabel();
        this.wholesaleCostLabel = new JLabel();
        this.jLabel17 = new JLabel();
        this.shippingCostLabel = new JLabel();
        this.jLabel25 = new JLabel();
        this.jLabel26 = new JLabel();
        this.totalLabel = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.jScrollPane4 = new JScrollPane();
        this.customFeeTable = new JTable();
        this.updateCustomFeeListButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.orderCommentsTextArea = new JTextArea();
        this.usernameLabel = new JLabel();
        this.jLabel6 = new JLabel();
        this.applyCommentsButton = new JButton();
        this.clearChangesButton = new JButton();
        this.exportLabelsButton = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.customerCommentsTextArea = new JTextArea();
        this.customerApplyCommentsButton = new JButton();
        this.jLabel23 = new JLabel();
        this.jLabel24 = new JLabel();
        this.orderAmount = new JLabel();
        this.createInvoiceButton = new JButton();
        this.jPanel8 = new JPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.filterJPanel = new JPanel();
        this.newFilterCheckBox = new JCheckBox();
        this.pendingFilterCheckBox = new JCheckBox();
        this.oosFilterCheckBox = new JCheckBox();
        this.exportLabelsCheckBox = new JCheckBox();
        this.pendingMOCheckBox = new JCheckBox();
        this.pendingECheckCheckBox = new JCheckBox();
        this.pendingPrintCheckBox = new JCheckBox();
        this.npbFilterCheckBox = new JCheckBox();
        this.adminHoldCheckBox = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.jSeparator3 = new JSeparator();
        this.pendingTrackingCheckBox = new JCheckBox();
        this.multiOrderCheckBox = new JCheckBox();
        this.NIACheckbox = new JCheckBox();
        this.OCCheckbox = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.searchField = new JTextField();
        this.searchButton = new JButton();
        this.jPanel5 = new JPanel();
        this.newSearchFilterCheckBox = new JCheckBox();
        this.pendingSearchFilterCheckBox = new JCheckBox();
        this.oosSearchFilterCheckBox = new JCheckBox();
        this.npbSearchFilterCheckBox = new JCheckBox();
        this.pendingPrintSearchFilterCheckBox = new JCheckBox();
        this.pendingECheckSearchFilterCheckBox = new JCheckBox();
        this.pendingMOSearchFilterCheckBox = new JCheckBox();
        this.completeSearchFilterCheckBox = new JCheckBox();
        this.canceledSearchFilterCheckBox = new JCheckBox();
        this.adminHoldSearchFilterCheckBox = new JCheckBox();
        this.exportLabelsSearchFilterCheckBox = new JCheckBox();
        this.dateRangePanel = new JPanel();
        this.jLabel18 = new JLabel();
        this.jLabel21 = new JLabel();
        this.fromDateChooser = new JDateChooser();
        this.toDateChooser = new JDateChooser();
        this.numResults = new JComboBox();
        this.jLabel27 = new JLabel();
        this.applyChangesButton = new JButton();
        this.jPanel2 = new JPanel();
        this.resultsShown = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel29 = new JLabel();
        this.jLabel28 = new JLabel();
        this.sortComboBox = new JComboBox();
        this.refreshProgressBar = new JProgressBar();
        this.jLabel1 = new JLabel();
        this.refreshListButton = new JButton();
        this.startupLabel = new JLabel();
        this.jLabel4 = new JLabel();
        this.timeStampLabel = new JLabel();
        this.lastUpdateComboBox = new JComboBox();
        this.applyChangesLabel = new JLabel();
        this.refreshAmazonOnlyButton = new JButton();
        this.jPanel7 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel12 = new JLabel();
        this.inhouseWeightField = new JLabel();
        this.totalWeightField = new JLabel();
        this.shippingMethodTextField = new JTextField();
        this.jLabel22 = new JLabel();
        this.trackingIdTextField = new JTextField();
        this.updateTrackingButton = new JButton();
        this.updateAllTrackingCheckBox = new JCheckBox();
        this.trackingCarrierTypeBox = new JComboBox();
        this.deleteButton = new JButton();
        this.mergeButton = new JButton();
        this.unMergeButton = new JButton();
        this.orderSplitButton = new JButton();
        this.createRMAButton = new JButton();
        this.bulkInventoryButton = new JButton();
        this.activeOrdersFormX = new ActiveOrdersFormX();
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.jLabel2.text"));
        this.feePanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.feePanel.border.title")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.jLabel5.text"));
        Mnemonics.setLocalizedText((JLabel)this.paypalFeeLabel, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.paypalFeeLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel11, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.jLabel11.text"));
        Mnemonics.setLocalizedText((JLabel)this.subtotalLabel, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.subtotalLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.wholesaleCostLabel, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.wholesaleCostLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel17, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.jLabel17.text"));
        Mnemonics.setLocalizedText((JLabel)this.shippingCostLabel, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.shippingCostLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel25, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.jLabel25.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel26, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.jLabel26.text"));
        Mnemonics.setLocalizedText((JLabel)this.totalLabel, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.totalLabel.text"));
        this.customFeeTable.setBackground(UIManager.getDefaults().getColor("Button.background"));
        this.customFeeTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Custom Fee/Site", "Fee Amount", "Profit"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.customFeeTable.setOpaque(false);
        this.customFeeTable.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane4.setViewportView(this.customFeeTable);
        this.customFeeTable.getColumnModel().getColumn(0).setHeaderValue(NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.customFeeTable.columnModel.title0"));
        this.customFeeTable.getColumnModel().getColumn(1).setHeaderValue(NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.customFeeTable.columnModel.title1"));
        this.customFeeTable.getColumnModel().getColumn(2).setHeaderValue(NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.customFeeTable.columnModel.title2_1"));
        Mnemonics.setLocalizedText((AbstractButton)this.updateCustomFeeListButton, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.updateCustomFeeListButton.text"));
        this.updateCustomFeeListButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.updateCustomFeeListButtonActionPerformed(evt);
            }
        });
        GroupLayout feePanelLayout = new GroupLayout(this.feePanel);
        this.feePanel.setLayout(feePanelLayout);
        feePanelLayout.setHorizontalGroup(feePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, feePanelLayout.createSequentialGroup().addComponent(this.jSeparator2).addContainerGap()).addGroup(feePanelLayout.createSequentialGroup().addContainerGap().addGroup(feePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(feePanelLayout.createSequentialGroup().addGroup(feePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(feePanelLayout.createSequentialGroup().addComponent(this.jLabel25, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.shippingCostLabel, -2, 58, -2)).addGroup(feePanelLayout.createSequentialGroup().addComponent(this.jLabel17, -2, 88, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.wholesaleCostLabel, -2, 58, -2)).addGroup(feePanelLayout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.paypalFeeLabel, -2, 58, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(feePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel11).addComponent(this.jLabel26)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(feePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.totalLabel, -2, 58, -2).addComponent(this.subtotalLabel, -2, 58, -2)).addGap(36, 36, 36)).addGroup(feePanelLayout.createSequentialGroup().addComponent(this.jScrollPane4, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.updateCustomFeeListButton, -2, 21, -2).addContainerGap()))));
        feePanelLayout.linkSize(0, this.jLabel17, this.jLabel25, this.jLabel5);
        feePanelLayout.linkSize(0, this.shippingCostLabel, this.wholesaleCostLabel);
        feePanelLayout.linkSize(0, this.jLabel11, this.jLabel26);
        feePanelLayout.setVerticalGroup(feePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(feePanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(feePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel17, -2, 14, -2).addComponent(this.wholesaleCostLabel).addComponent(this.totalLabel).addComponent(this.jLabel26)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(feePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel25).addComponent(this.shippingCostLabel).addComponent(this.jLabel11).addComponent(this.subtotalLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(feePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.paypalFeeLabel)).addGap(9, 9, 9).addComponent(this.jSeparator2, -2, -1, -2).addGap(7, 7, 7).addGroup(feePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.updateCustomFeeListButton).addComponent(this.jScrollPane4, -2, 84, -2))));
        feePanelLayout.linkSize(1, this.jLabel17, this.jLabel25, this.jLabel5, this.paypalFeeLabel, this.shippingCostLabel, this.wholesaleCostLabel);
        this.orderCommentsTextArea.setColumns(20);
        this.orderCommentsTextArea.setLineWrap(true);
        this.orderCommentsTextArea.setRows(5);
        this.orderCommentsTextArea.setWrapStyleWord(true);
        this.orderCommentsTextArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                OrderManagerTopComponent.this.orderCommentsTextAreaFocusLost(evt);
            }

            @Override
            public void focusGained(FocusEvent evt) {
                OrderManagerTopComponent.this.orderCommentsTextAreaFocusGained(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.orderCommentsTextArea);
        Mnemonics.setLocalizedText((JLabel)this.usernameLabel, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.usernameLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.jLabel6.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.applyCommentsButton, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.applyCommentsButton.text"));
        this.applyCommentsButton.setEnabled(false);
        this.applyCommentsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.applyCommentsButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.clearChangesButton, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.clearChangesButton.text"));
        this.clearChangesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.clearChangesButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.exportLabelsButton, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.exportLabelsButton.text"));
        this.exportLabelsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.exportLabelsButtonActionPerformed(evt);
            }
        });
        this.customerCommentsTextArea.setColumns(20);
        this.customerCommentsTextArea.setLineWrap(true);
        this.customerCommentsTextArea.setRows(5);
        this.customerCommentsTextArea.setWrapStyleWord(true);
        this.customerCommentsTextArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                OrderManagerTopComponent.this.customerCommentsTextAreaFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                OrderManagerTopComponent.this.customerCommentsTextAreaFocusLost(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.customerCommentsTextArea);
        Mnemonics.setLocalizedText((AbstractButton)this.customerApplyCommentsButton, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.customerApplyCommentsButton.text"));
        this.customerApplyCommentsButton.setEnabled(false);
        this.customerApplyCommentsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.customerApplyCommentsButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel23, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.jLabel23.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel24, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.jLabel24.text"));
        Mnemonics.setLocalizedText((JLabel)this.orderAmount, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.orderAmount.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.createInvoiceButton, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.createInvoiceButton.text"));
        this.createInvoiceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.createInvoiceButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.usernameLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel6).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jLabel24).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.orderAmount))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.feePanel, -2, 309, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel23).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jScrollPane2, -2, 226, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.customerApplyCommentsButton))).addGap(8, 8, 8).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 228, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.applyCommentsButton))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 90, Short.MAX_VALUE).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.clearChangesButton, GroupLayout.Alignment.TRAILING).addComponent(this.createInvoiceButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.exportLabelsButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel6Layout.linkSize(0, this.applyCommentsButton, this.customerApplyCommentsButton);
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.feePanel, -1, -1, Short.MAX_VALUE).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.usernameLabel).addGap(31, 31, 31).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel24).addComponent(this.orderAmount, -2, 12, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.customerApplyCommentsButton)).addGroup(jPanel6Layout.createSequentialGroup().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLabel23)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addComponent(this.jScrollPane2))).addGroup(GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.applyCommentsButton))).addContainerGap()).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.clearChangesButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.createInvoiceButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exportLabelsButton)))));
        this.jPanel8.setPreferredSize(new Dimension(1280, 241));
        this.jTabbedPane1.setMaximumSize(new Dimension(250, 500));
        this.filterJPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.filterJPanel.border.title")));
        Mnemonics.setLocalizedText((AbstractButton)this.newFilterCheckBox, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.newFilterCheckBox.text"));
        this.newFilterCheckBox.setHorizontalTextPosition(10);
        this.newFilterCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.newFilterCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.pendingFilterCheckBox, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.pendingFilterCheckBox.text"));
        this.pendingFilterCheckBox.setHorizontalTextPosition(10);
        this.pendingFilterCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.pendingFilterCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.oosFilterCheckBox, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.oosFilterCheckBox.text"));
        this.oosFilterCheckBox.setHorizontalTextPosition(10);
        this.oosFilterCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.oosFilterCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.exportLabelsCheckBox, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.exportLabelsCheckBox.text"));
        this.exportLabelsCheckBox.setHorizontalTextPosition(10);
        this.exportLabelsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.exportLabelsCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.pendingMOCheckBox, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.pendingMOCheckBox.text"));
        this.pendingMOCheckBox.setHorizontalTextPosition(10);
        this.pendingMOCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.pendingMOCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.pendingECheckCheckBox, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.pendingECheckCheckBox.text"));
        this.pendingECheckCheckBox.setHorizontalTextPosition(10);
        this.pendingECheckCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.pendingECheckCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.pendingPrintCheckBox, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.pendingPrintCheckBox.text"));
        this.pendingPrintCheckBox.setHorizontalTextPosition(10);
        this.pendingPrintCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.pendingPrintCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.npbFilterCheckBox, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.npbFilterCheckBox.text"));
        this.npbFilterCheckBox.setHorizontalTextPosition(10);
        this.npbFilterCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.npbFilterCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.adminHoldCheckBox, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.adminHoldCheckBox.text"));
        this.adminHoldCheckBox.setHorizontalTextPosition(10);
        this.adminHoldCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.adminHoldCheckBoxActionPerformed(evt);
            }
        });
        this.jSeparator1.setOrientation(1);
        this.jSeparator3.setOrientation(1);
        Mnemonics.setLocalizedText((AbstractButton)this.pendingTrackingCheckBox, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.pendingTrackingCheckBox.text"));
        this.pendingTrackingCheckBox.setHorizontalTextPosition(10);
        this.pendingTrackingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.pendingTrackingCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.multiOrderCheckBox, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.multiOrderCheckBox.text"));
        this.multiOrderCheckBox.setHorizontalTextPosition(10);
        this.multiOrderCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.multiOrderCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.NIACheckbox, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.NIACheckbox.text"));
        this.NIACheckbox.setHorizontalTextPosition(10);
        this.NIACheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.NIACheckboxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.OCCheckbox, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.OCCheckbox.text"));
        this.OCCheckbox.setHorizontalTextPosition(10);
        this.OCCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.OCCheckboxActionPerformed(evt);
            }
        });
        GroupLayout filterJPanelLayout = new GroupLayout(this.filterJPanel);
        this.filterJPanel.setLayout(filterJPanelLayout);
        filterJPanelLayout.setHorizontalGroup(filterJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filterJPanelLayout.createSequentialGroup().addGap(22, 22, 22).addGroup(filterJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.newFilterCheckBox, GroupLayout.Alignment.TRAILING).addComponent(this.pendingFilterCheckBox, GroupLayout.Alignment.TRAILING).addComponent(this.oosFilterCheckBox, GroupLayout.Alignment.TRAILING).addComponent(this.npbFilterCheckBox, GroupLayout.Alignment.TRAILING).addComponent(this.adminHoldCheckBox, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator3, -2, 2, -2).addGap(21, 21, 21).addGroup(filterJPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.pendingPrintCheckBox).addComponent(this.exportLabelsCheckBox).addComponent(this.pendingMOCheckBox).addComponent(this.pendingECheckCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 53, -2).addGroup(filterJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filterJPanelLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(filterJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.multiOrderCheckBox, GroupLayout.Alignment.TRAILING).addComponent(this.pendingTrackingCheckBox, GroupLayout.Alignment.TRAILING).addComponent(this.NIACheckbox, GroupLayout.Alignment.TRAILING)).addGap(59, 59, 59)).addGroup(filterJPanelLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.OCCheckbox).addContainerGap(-1, Short.MAX_VALUE)))));
        filterJPanelLayout.setVerticalGroup(filterJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filterJPanelLayout.createSequentialGroup().addContainerGap().addGroup(filterJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator3).addComponent(this.jSeparator1).addGroup(filterJPanelLayout.createSequentialGroup().addComponent(this.newFilterCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pendingFilterCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.oosFilterCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.npbFilterCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.adminHoldCheckBox).addContainerGap(28, Short.MAX_VALUE)).addGroup(filterJPanelLayout.createSequentialGroup().addGroup(filterJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filterJPanelLayout.createSequentialGroup().addGap(3, 3, 3).addComponent(this.pendingTrackingCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.multiOrderCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.NIACheckbox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.OCCheckbox)).addGroup(filterJPanelLayout.createSequentialGroup().addComponent(this.pendingPrintCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pendingECheckCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pendingMOCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exportLabelsCheckBox))).addGap(0, 45, Short.MAX_VALUE)))));
        this.jTabbedPane1.addTab(NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.filterJPanel.TabConstraints.tabTitle"), this.filterJPanel);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.jPanel1.border.title")));
        this.searchField.setText(NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.searchField.text"));
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OrderManagerTopComponent.this.searchFieldKeyReleased(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.searchButton, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.searchButton.text"));
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.searchButtonActionPerformed(evt);
            }
        });
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.jPanel5.border.title")));
        Mnemonics.setLocalizedText((AbstractButton)this.newSearchFilterCheckBox, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.newSearchFilterCheckBox.text"));
        this.newSearchFilterCheckBox.setHorizontalTextPosition(10);
        this.newSearchFilterCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.newSearchFilterCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.pendingSearchFilterCheckBox, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.pendingSearchFilterCheckBox.text"));
        this.pendingSearchFilterCheckBox.setHorizontalAlignment(11);
        this.pendingSearchFilterCheckBox.setHorizontalTextPosition(10);
        this.pendingSearchFilterCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.pendingSearchFilterCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.oosSearchFilterCheckBox, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.oosSearchFilterCheckBox.text"));
        this.oosSearchFilterCheckBox.setHorizontalTextPosition(10);
        this.oosSearchFilterCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.oosSearchFilterCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.npbSearchFilterCheckBox, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.npbSearchFilterCheckBox.text"));
        this.npbSearchFilterCheckBox.setHorizontalTextPosition(10);
        this.npbSearchFilterCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.npbSearchFilterCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.pendingPrintSearchFilterCheckBox, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.pendingPrintSearchFilterCheckBox.text"));
        this.pendingPrintSearchFilterCheckBox.setHorizontalAlignment(11);
        this.pendingPrintSearchFilterCheckBox.setHorizontalTextPosition(10);
        this.pendingPrintSearchFilterCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.pendingPrintSearchFilterCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.pendingECheckSearchFilterCheckBox, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.pendingECheckSearchFilterCheckBox.text"));
        this.pendingECheckSearchFilterCheckBox.setHorizontalAlignment(11);
        this.pendingECheckSearchFilterCheckBox.setHorizontalTextPosition(10);
        this.pendingECheckSearchFilterCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.pendingECheckSearchFilterCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.pendingMOSearchFilterCheckBox, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.pendingMOSearchFilterCheckBox.text"));
        this.pendingMOSearchFilterCheckBox.setHorizontalAlignment(11);
        this.pendingMOSearchFilterCheckBox.setHorizontalTextPosition(10);
        this.pendingMOSearchFilterCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.pendingMOSearchFilterCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.completeSearchFilterCheckBox, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.completeSearchFilterCheckBox.text"));
        this.completeSearchFilterCheckBox.setHorizontalAlignment(11);
        this.completeSearchFilterCheckBox.setHorizontalTextPosition(10);
        this.completeSearchFilterCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.completeSearchFilterCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.canceledSearchFilterCheckBox, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.canceledSearchFilterCheckBox.text"));
        this.canceledSearchFilterCheckBox.setHorizontalTextPosition(10);
        this.canceledSearchFilterCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.canceledSearchFilterCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.adminHoldSearchFilterCheckBox, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.adminHoldSearchFilterCheckBox.text"));
        this.adminHoldSearchFilterCheckBox.setHorizontalTextPosition(10);
        this.adminHoldSearchFilterCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.adminHoldSearchFilterCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.exportLabelsSearchFilterCheckBox, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.exportLabelsSearchFilterCheckBox.text"));
        this.exportLabelsSearchFilterCheckBox.setHorizontalTextPosition(10);
        this.exportLabelsSearchFilterCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.exportLabelsSearchFilterCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel5Layout.createSequentialGroup().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.newSearchFilterCheckBox, GroupLayout.Alignment.TRAILING).addComponent(this.pendingSearchFilterCheckBox, GroupLayout.Alignment.TRAILING).addComponent(this.oosSearchFilterCheckBox, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.canceledSearchFilterCheckBox).addComponent(this.completeSearchFilterCheckBox).addComponent(this.npbSearchFilterCheckBox))).addComponent(this.exportLabelsSearchFilterCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.pendingECheckSearchFilterCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.pendingMOSearchFilterCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.pendingPrintSearchFilterCheckBox, -1, -1, Short.MAX_VALUE)).addComponent(this.adminHoldSearchFilterCheckBox, GroupLayout.Alignment.TRAILING)).addGap(33, 33, 33)));
        jPanel5Layout.linkSize(0, this.pendingECheckSearchFilterCheckBox, this.pendingMOSearchFilterCheckBox);
        jPanel5Layout.linkSize(0, this.canceledSearchFilterCheckBox, this.completeSearchFilterCheckBox);
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.newSearchFilterCheckBox).addGroup(jPanel5Layout.createSequentialGroup().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pendingPrintSearchFilterCheckBox).addComponent(this.completeSearchFilterCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pendingSearchFilterCheckBox).addComponent(this.pendingECheckSearchFilterCheckBox).addComponent(this.npbSearchFilterCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pendingMOSearchFilterCheckBox).addComponent(this.oosSearchFilterCheckBox).addComponent(this.canceledSearchFilterCheckBox)))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.adminHoldSearchFilterCheckBox).addComponent(this.exportLabelsSearchFilterCheckBox)).addContainerGap(8, Short.MAX_VALUE)));
        this.dateRangePanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.dateRangePanel.border.title")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel18, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.jLabel18.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel21, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.jLabel21.text"));
        GroupLayout dateRangePanelLayout = new GroupLayout(this.dateRangePanel);
        this.dateRangePanel.setLayout(dateRangePanelLayout);
        dateRangePanelLayout.setHorizontalGroup(dateRangePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dateRangePanelLayout.createSequentialGroup().addComponent(this.jLabel18).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.fromDateChooser, -2, 112, -2)).addGroup(dateRangePanelLayout.createSequentialGroup().addComponent(this.jLabel21).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.toDateChooser, -1, -1, Short.MAX_VALUE)));
        dateRangePanelLayout.linkSize(0, this.jLabel18, this.jLabel21);
        dateRangePanelLayout.setVerticalGroup(dateRangePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dateRangePanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(dateRangePanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel18).addComponent((Component)this.fromDateChooser, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(dateRangePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel21).addComponent((Component)this.toDateChooser, -2, -1, -2))));
        dateRangePanelLayout.linkSize(1, new Component[]{this.jLabel21, this.toDateChooser});
        dateRangePanelLayout.linkSize(1, new Component[]{this.fromDateChooser, this.jLabel18});
        this.numResults.setModel(new DefaultComboBoxModel<String>(new String[]{"100", "200", "500"}));
        Mnemonics.setLocalizedText((JLabel)this.jLabel27, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.jLabel27.text"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jPanel5, -2, 280, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.dateRangePanel, -2, -1, -2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel27).addGap(18, 18, 18).addComponent(this.numResults, 0, 95, Short.MAX_VALUE)))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.searchField, -2, 293, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchButton))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchField, -2, -1, -2).addComponent(this.searchButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.dateRangePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.numResults, -2, -1, -2).addComponent(this.jLabel27)).addGap(0, 0, Short.MAX_VALUE)))));
        this.jTabbedPane1.addTab(NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.jPanel1.TabConstraints.tabTitle"), this.jPanel1);
        Mnemonics.setLocalizedText((AbstractButton)this.applyChangesButton, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.applyChangesButton.text"));
        this.applyChangesButton.setEnabled(false);
        this.applyChangesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.applyChangesButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.resultsShown, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.resultsShown.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.jLabel3.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel29, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.jLabel29.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel28, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.jLabel28.text"));
        this.sortComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Order Date", "Account Name", "Customer ID", "Name", "Email", "Country", "Ebay Site"}));
        this.sortComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.sortComboBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.jLabel1.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.refreshListButton, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.refreshListButton.text"));
        this.refreshListButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.refreshListButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.startupLabel, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.startupLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.jLabel4.text"));
        Mnemonics.setLocalizedText((JLabel)this.timeStampLabel, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.timeStampLabel.text"));
        this.lastUpdateComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Last Update", "1 Day", "2 Days", "7 Days"}));
        this.lastUpdateComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.lastUpdateComboBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.applyChangesLabel, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.applyChangesLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.refreshAmazonOnlyButton, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.refreshAmazonOnlyButton.text"));
        this.refreshAmazonOnlyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.refreshAmazonOnlyButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.timeStampLabel)).addComponent(this.refreshProgressBar, -2, -1, -2).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel28).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resultsShown)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.applyChangesLabel, -1, -1, Short.MAX_VALUE).addComponent(this.startupLabel, -1, -1, Short.MAX_VALUE))).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.refreshAmazonOnlyButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.sortComboBox, -2, -1, -2))).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.lastUpdateComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.jLabel29)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.refreshListButton)))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(0, this.jLabel1, this.jLabel3);
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.timeStampLabel)).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.startupLabel)).addGap(2, 2, 2).addComponent(this.applyChangesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.refreshProgressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel29).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lastUpdateComboBox, -2, -1, -2).addComponent(this.refreshListButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.refreshAmazonOnlyButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.sortComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel28).addComponent(this.resultsShown))));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.jPanel3.border.title")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.jLabel9.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel10, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.jLabel10.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel12, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.jLabel12.text"));
        Mnemonics.setLocalizedText((JLabel)this.inhouseWeightField, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.inhouseWeightField.text"));
        Mnemonics.setLocalizedText((JLabel)this.totalWeightField, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.totalWeightField.text"));
        this.shippingMethodTextField.setText(NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.shippingMethodTextField.text"));
        this.shippingMethodTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.shippingMethodTextFieldActionPerformed(evt);
            }
        });
        this.shippingMethodTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                OrderManagerTopComponent.this.shippingMethodTextFieldFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                OrderManagerTopComponent.this.shippingMethodTextFieldFocusLost(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel22, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.jLabel22.text"));
        this.trackingIdTextField.setText(NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.trackingIdTextField.text"));
        this.trackingIdTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.trackingIdTextFieldActionPerformed(evt);
            }
        });
        this.trackingIdTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                OrderManagerTopComponent.this.trackingIdTextFieldFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                OrderManagerTopComponent.this.trackingIdTextFieldFocusLost(evt);
            }
        });
        this.trackingIdTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                OrderManagerTopComponent.this.trackingIdTextFieldKeyTyped(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.updateTrackingButton, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.updateTrackingButton.text"));
        this.updateTrackingButton.setEnabled(false);
        this.updateTrackingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.updateTrackingButtonActionPerformed(evt);
            }
        });
        this.updateAllTrackingCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.updateAllTrackingCheckBox, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.updateAllTrackingCheckBox.text"));
        this.updateAllTrackingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.updateAllTrackingCheckBoxActionPerformed(evt);
            }
        });
        this.trackingCarrierTypeBox.setModel(new DefaultComboBoxModel<String>(new String[]{"USPS", "UPS", "UPS-MI"}));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.shippingMethodTextField, -2, 172, -2)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inhouseWeightField)).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel12).addComponent(this.jLabel22)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.totalWeightField).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.trackingCarrierTypeBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.updateTrackingButton)).addComponent(this.trackingIdTextField, GroupLayout.Alignment.LEADING, -2, 262, -2).addComponent(this.updateAllTrackingCheckBox))))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.linkSize(0, this.jLabel10, this.jLabel12, this.jLabel9);
        jPanel3Layout.linkSize(0, this.inhouseWeightField, this.totalWeightField);
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.shippingMethodTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.inhouseWeightField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel12).addComponent(this.totalWeightField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel22).addComponent(this.trackingIdTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.updateTrackingButton).addComponent(this.trackingCarrierTypeBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.updateAllTrackingCheckBox).addContainerGap()));
        Mnemonics.setLocalizedText((AbstractButton)this.deleteButton, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.deleteButton.text"));
        this.deleteButton.setEnabled(false);
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.deleteButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.mergeButton, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.mergeButton.text"));
        this.mergeButton.setEnabled(false);
        this.mergeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.mergeButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.unMergeButton, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.unMergeButton.text"));
        this.unMergeButton.setEnabled(false);
        this.unMergeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.unMergeButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.orderSplitButton, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.orderSplitButton.text"));
        this.orderSplitButton.setEnabled(false);
        this.orderSplitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.orderSplitButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.createRMAButton, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.createRMAButton.text"));
        this.createRMAButton.setEnabled(false);
        this.createRMAButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.createRMAButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.unMergeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mergeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.orderSplitButton).addGap(45, 45, 45).addComponent(this.createRMAButton).addGap(18, 18, 18).addComponent(this.deleteButton)).addComponent(this.jPanel3, -2, -1, -2)).addContainerGap()));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -2, -1, -2).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addGap(26, 26, 26).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.deleteButton).addComponent(this.createRMAButton))).addGroup(GroupLayout.Alignment.TRAILING, jPanel7Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.unMergeButton).addComponent(this.mergeButton).addComponent(this.orderSplitButton)))).addContainerGap()));
        Mnemonics.setLocalizedText((AbstractButton)this.bulkInventoryButton, (String)NbBundle.getMessage(OrderManagerTopComponent.class, (String)"OrderManagerTopComponent.bulkInventoryButton.text"));
        this.bulkInventoryButton.setEnabled(false);
        this.bulkInventoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerTopComponent.this.bulkInventoryButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel8Layout = new GroupLayout(this.jPanel8);
        this.jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel7, -2, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, -2, 484, -2).addGroup(GroupLayout.Alignment.TRAILING, jPanel8Layout.createSequentialGroup().addComponent(this.bulkInventoryButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.applyChangesButton))).addContainerGap()));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane1, -2, 201, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.applyChangesButton).addComponent(this.bulkInventoryButton))).addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel7, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE))).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.activeOrdersFormX, -1, -1, Short.MAX_VALUE).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jPanel8, -1, 1235, Short.MAX_VALUE).addContainerGap()).addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE))));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel8, -2, 252, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.activeOrdersFormX, -1, 162, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel6, -2, -1, -2).addContainerGap()));
        this.jScrollPane3.setViewportView(this.jPanel4);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane3).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane3).addContainerGap()));
    }

    private Date createRange(String selectedRange) {
        SimpleDateFormat dayFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat hourFormat = new SimpleDateFormat("HH:mm:ss");
        Date date = new Date();
        date.setHours(date.getHours() + 10);
        this.endDate = dayFormat.format(date) + "T" + hourFormat.format(date) + "Z";
        date.setHours(date.getHours() - 10);
        if (selectedRange.equalsIgnoreCase("1 Day")) {
            date.setDate(date.getDate() - 1);
        } else if (selectedRange.equalsIgnoreCase("2 Days")) {
            date.setDate(date.getDate() - 2);
        } else if (selectedRange.equalsIgnoreCase("7 Days")) {
            date.setDate(date.getDate() - 7);
        } else if (LookupServicesUtil.getDBServices().getAccountPreferences().getPaypalLastUpdate() == 0L) {
            date.setDate(date.getDate() - 5);
        } else {
            date = new Date(LookupServicesUtil.getDBServices().getAccountPreferences().getPaypalLastUpdate());
        }
        this.startDate = dayFormat.format(date) + "T" + hourFormat.format(date) + "Z";
        return date;
    }

    private void refreshListButtonActionPerformed(ActionEvent evt) {
        if (!LookupServicesUtil.getPaypalServices().updatePending() && !LookupServicesUtil.getEbayServices().updatePending()) {
            String systemTime = LookupServicesUtil.getEbayServices().getCurrentTime();
            if (null != systemTime && !systemTime.equals("UNKNOWN")) {
                this.timeStampLabel.setText(systemTime);
                this.startupLabel.setText("Updating... May take a while.");
                this.refreshProgressBar.setVisible(true);
                this.refreshProgressBar.setValue((int)LookupServicesUtil.getEbayServices().getUpdatePercentage());
                this.refreshProgressBar.setStringPainted(true);
                this.startupLabel.paintImmediately(this.startupLabel.getVisibleRect());
                if (SubscriptionManager.getInstance().isPaypalActive()) {
                    this.createRange((String)this.lastUpdateComboBox.getSelectedItem());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PaypalManagerTopComponent pmtc = PaypalManagerTopComponent.findInstance();
                            pmtc.open();
                        }
                    });
                    LookupServicesUtil.getPaypalServices().transactionSearch(this.startDate, this.endDate);
                } else {
                    JOptionPane.showMessageDialog(null, "Your susbcription to Paypal Manager has expired. Paypal Manager is unavailable for update.");
                }
                if (SubscriptionManager.getInstance().isWebsiteActive()) {
                    LookupServicesUtil.getRESTHandlerServices().getWebsiteTransactions();
                }
                if (!SubscriptionManager.getInstance().getEbayAccounts().isEmpty()) {
                    LookupServicesUtil.getEbayServices().refreshTransactions((String)this.lastUpdateComboBox.getSelectedItem());
                } else {
                    Preferences.getInstance().openTab(Preferences.Index.Ebay);
                }
                LookupServicesUtil.getEtsyServices().getTransactions(this.createRange(this.lastUpdateComboBox.getSelectedItem().toString()));
                LookupServicesUtil.getAmazonServices().refreshTransactions((String)this.lastUpdateComboBox.getSelectedItem());
                this.updateDateRange();
            }
        } else if (LookupServicesUtil.getEbayServices().updatePending()) {
            JOptionPane.showMessageDialog(null, "Refresh already underway, please wait until it is finished.");
        } else {
            JOptionPane.showMessageDialog(null, "Update already underway, please wait until it is finished.");
        }
    }

    private void mergeButtonActionPerformed(ActionEvent evt) {
        this.disableListener(true);
        ArrayList<CompleteOrder> completeOrders = new ArrayList<CompleteOrder>();
        boolean error = false;
        for (int row : this.activeOrdersFormX.getOrderDetails().getSelectedRows()) {
            if (((OrderDetails)this._completeOrders.get(this._orderMapping.get(row)).getOrderDetails().get(0)).getEbaySite().equals("Amazon")) {
                error = true;
                break;
            }
            if (completeOrders.contains(this._completeOrders.get(this._orderMapping.get(row)))) continue;
            completeOrders.add(this._completeOrders.get(this._orderMapping.get(row)));
        }
        if (!error) {
            LookupServicesUtil.getDBServices().mergeOrders(completeOrders);
            ListenerManager.getInstance().notify((GenericListener)ListenerManager.TRANSACTION_LISTENER);
        } else {
            JOptionPane.showMessageDialog(null, "Unable to Merge / Unmerge Amazon orders.");
            this.disableListener(false);
        }
    }

    private void applyChangesButtonActionPerformed(ActionEvent evt) {
        if (this._invalidCellChanges.isEmpty()) {
            this.disableListener(true);
            this.updateNeeded(false);
            Integer[] arr$ = this._updatedOrders.keySet().toArray(new Integer[0]);
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int orderID = arr$[i$];
                LookupServicesUtil.getDBServices().updateOrder(this._completeOrders.get(orderID));
            }
            this._updatedOrders.clear();
            this._validCellChanges.clear();
            this._currentRow = -1;
            this.startupLabel.setText("Successfully applied changes.");
            this.applyChangesLabel.setText("");
            DefaultTableModel tableModel = (DefaultTableModel)this.activeOrdersFormX.getOrderDetails().getModel();
            tableModel.fireTableDataChanged();
            this.disableListener(false);
            if (!this._negativeProfit.isEmpty() && LookupServicesUtil.getDBServices().getAccountPreferences().isGenNegativeNotification()) {
                String nameList = "";
                for (String orderNumbers : this._negativeProfit.keySet()) {
                    nameList = nameList + orderNumbers + " - " + this._negativeProfit.get(orderNumbers) + "\r\n";
                }
                JFrame frame = new JFrame();
                ToggleBox newToggle = new ToggleBox(null, true, "Some of the orders recently visited are not making any profit. The customer user names are listed below:\r\n" + nameList, 3);
                newToggle.setVisible(true);
            }
            this._negativeProfit.clear();
            ListenerManager.getInstance().notify((GenericListener)ListenerManager.TRANSACTION_LISTENER);
            this.cleanupView();
        } else {
            JOptionPane.showMessageDialog(null, "Please correct all errors before applying changes.");
        }
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        int[] rows;
        this.disableListener(true);
        for (int row : rows = this.activeOrdersFormX.getOrderDetails().getSelectedRows()) {
            int orderID = this._orderMapping.get(row);
            CompleteOrder completeOrder = this._completeOrders.get(orderID);
            if (((OrderDetails)completeOrder.getOrderDetails().get(0)).getEbaySite().equals("Amazon")) continue;
            OrderDetails detailsElement = (OrderDetails)completeOrder.getOrderDetails().get(row - completeOrder.getRowStart());
            if (detailsElement.isInhouse()) {
                Collection inventoryElements = LookupServicesUtil.getDBServices().getInventoryList(detailsElement.getItemID(), false, false, false, new String[0], false);
                Iterator iter = inventoryElements.iterator();
                boolean found = false;
                while (iter.hasNext() && !found) {
                    ArrayList itemList = (ArrayList)iter.next();
                    if (!((InventoryElement)itemList.get(0)).getItemID().toLowerCase().trim().equals(detailsElement.getItemID())) continue;
                    found = true;
                    if (((InventoryElement)itemList.get(0)).getItemQuantity() < 0) {
                        ((InventoryElement)itemList.get(0)).setItemQuantity(((InventoryElement)itemList.get(0)).getItemQuantity() + 1);
                        continue;
                    }
                    boolean priceMatch = false;
                    for (int i = 1; i < itemList.size(); ++i) {
                        if (((InventoryElement)itemList.get(i)).getItemCost() != detailsElement.getItemCost()) continue;
                        priceMatch = true;
                        ((InventoryElement)itemList.get(i)).setItemQuantity(((InventoryElement)itemList.get(i)).getItemQuantity() + 1);
                        LookupServicesUtil.getDBServices().setInventoryElement((InventoryElement)itemList.get(i));
                        break;
                    }
                    if (priceMatch) continue;
                    InventoryElement element = new InventoryElement();
                    element.setItem(((InventoryElement)itemList.get(0)).getItem());
                    element.setItemCost(detailsElement.getItemCost());
                    element.setItemID(detailsElement.getItemID());
                    element.setItemQuantity(1);
                    element.setOosItem(false);
                    LookupServicesUtil.getDBServices().setInventoryElement(element);
                }
                if (!found && !detailsElement.isBackordered()) {
                    InventoryElement oosElement = new InventoryElement();
                    InventoryElement element = new InventoryElement();
                    element.setItemCost(detailsElement.getItemCost());
                    element.setItemID(detailsElement.getItemID());
                    element.setItemQuantity(1);
                    element.setOosItem(false);
                    oosElement.setItemCost(detailsElement.getItemCost());
                    oosElement.setItemID(detailsElement.getItemID());
                    oosElement.setItemQuantity(0);
                    oosElement.setOosItem(true);
                    ArrayList<InventoryElement> elementChain = new ArrayList<InventoryElement>();
                    elementChain.add(oosElement);
                    elementChain.add(element);
                    Item item = LookupServicesUtil.getDBServices().getItem(element.getItemID());
                    if (null == item) {
                        item = new Item();
                        item.setDistributorID(this._distributorStringList.get("XR").getDistributorID());
                        item.setDropShipped(true);
                        item.setItemID(element.getItemID());
                        item.setItemName(detailsElement.getOrderDescription());
                        item.setDistributorProductID(element.getItemID());
                        LookupServicesUtil.getDBServices().setItem(item);
                    }
                    LookupServicesUtil.getDBServices().setInventoryElementChain(elementChain);
                }
            }
            LookupServicesUtil.getDBServices().deleteOrderDetail(completeOrder, (OrderDetails)completeOrder.getOrderDetails().get(row - completeOrder.getRowStart()));
        }
        ListenerManager.getInstance().notify((GenericListener)ListenerManager.INVENTORY_LIST_LISTENER);
        ListenerManager.getInstance().notify((GenericListener)ListenerManager.TRANSACTION_LISTENER);
    }

    private void sortComboBoxActionPerformed(ActionEvent evt) {
        if (this.sortComboBox.getSelectedItem().equals("Account Name")) {
            this._sortBy = CompleteOrderComparator.CUSTOMER_ACCOUNTNAME;
        } else if (this.sortComboBox.getSelectedItem().equals("Ebay Site")) {
            this._sortBy = CompleteOrderComparator.EBAY_SITE;
        } else if (this.sortComboBox.getSelectedItem().equals("Customer ID")) {
            this._sortBy = CompleteOrderComparator.CUSTOMER_ID;
        } else if (this.sortComboBox.getSelectedItem().equals("Name")) {
            this._sortBy = CompleteOrderComparator.CUSTOMER_NAME;
        } else if (this.sortComboBox.getSelectedItem().equals("Email")) {
            this._sortBy = CompleteOrderComparator.CUSTOMER_EMAIL;
        } else if (this.sortComboBox.getSelectedItem().equals("Order Date")) {
            this._sortBy = CompleteOrderComparator.ORDER_DATE;
        } else if (this.sortComboBox.getSelectedItem().equals("Country")) {
            this._sortBy = CompleteOrderComparator.COUNTRY;
        }
        ListenerManager.getInstance().notify((GenericListener)ListenerManager.TRANSACTION_LISTENER);
    }

    private void orderCommentsTextAreaFocusLost(FocusEvent evt) {
        this.updateCommentBox();
    }

    private void applyCommentsButtonActionPerformed(ActionEvent evt) {
        this.updateCommentBox();
        this.applyCommentsButton.setEnabled(false);
    }

    private void orderCommentsTextAreaFocusGained(FocusEvent evt) {
        this.applyCommentsButton.setEnabled(true);
        this._commentBoxUpdated = true;
    }

    private void shippingMethodTextFieldActionPerformed(ActionEvent evt) {
        this.updateShippingMethodField();
    }

    private void shippingMethodTextFieldFocusGained(FocusEvent evt) {
        this._shippingMethodTextUpdated = true;
    }

    private void shippingMethodTextFieldFocusLost(FocusEvent evt) {
        this.updateShippingMethodField();
    }

    private void clearChangesButtonActionPerformed(ActionEvent evt) {
        this._invalidCellChanges.clear();
        this.applyChangesLabel.setText("");
        if (!this._updatedOrders.isEmpty()) {
            Collection currentInventory = LookupServicesUtil.getDBServices().getInventoryList("", false, false, false, new String[0], false);
            HashMap<String, ArrayList> currentInventoryMap = new HashMap<String, ArrayList>();
            for (ArrayList inventoryElement : currentInventory) {
                currentInventoryMap.put(((InventoryElement)inventoryElement.get(0)).getItemID(), inventoryElement);
            }
            Integer[] arr$ = this._updatedOrders.keySet().toArray(new Integer[0]);
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int i;
                int orderID = arr$[i$];
                HashMap orderList = LookupServicesUtil.getDBServices().getOrderList(true);
                if (orderList == null || !orderList.containsKey(orderID) || this._completeOrders == null || !this._completeOrders.containsKey(orderID)) continue;
                ArrayList baseOrders = ((CompleteOrder)orderList.get(orderID)).getOrderDetails();
                ArrayList changedOrders = this._completeOrders.get(orderID).getOrderDetails();
                HashMap baseOrderMapping = new HashMap();
                for (i = 0; i < baseOrders.size(); ++i) {
                    baseOrderMapping.put(((OrderDetails)baseOrders.get(i)).getOrderDetailsID(), baseOrders.get(i));
                }
                for (i = 0; i < changedOrders.size(); ++i) {
                    ArrayList inventoryItem;
                    if (!baseOrderMapping.containsKey(((OrderDetails)changedOrders.get(i)).getOrderDetailsID()) || ((OrderDetails)baseOrderMapping.get(((OrderDetails)changedOrders.get(i)).getOrderDetailsID())).isInhouse() == ((OrderDetails)changedOrders.get(i)).isInhouse() || (inventoryItem = (ArrayList)currentInventoryMap.get(((OrderDetails)changedOrders.get(i)).getItemID())) == null) continue;
                    if (((OrderDetails)changedOrders.get(i)).isInhouse() && ((OrderDetails)changedOrders.get(i)).isBackordered()) {
                        ((InventoryElement)inventoryItem.get(0)).setItemQuantity(((InventoryElement)inventoryItem.get(0)).getItemQuantity() + 1);
                        continue;
                    }
                    if (!((OrderDetails)changedOrders.get(i)).isInhouse()) {
                        boolean found = false;
                        Iterator itemIter = inventoryItem.iterator();
                        boolean first = true;
                        while (itemIter.hasNext() && !found) {
                            InventoryElement element = (InventoryElement)itemIter.next();
                            if (!(first && itemIter.hasNext() || element.getItemCost() != ((OrderDetails)baseOrderMapping.get(((OrderDetails)changedOrders.get(i)).getOrderDetailsID())).getItemCost())) {
                                element.setItemQuantity(element.getItemQuantity() - 1);
                                LookupServicesUtil.getDBServices().setInventoryElement(element);
                                ListenerManager.getInstance().notify((GenericListener)ListenerManager.INVENTORY_LIST_LISTENER);
                                found = true;
                            }
                            first = false;
                        }
                        continue;
                    }
                    boolean priceMatch = false;
                    for (int j = 1; j < inventoryItem.size(); ++j) {
                        if (((InventoryElement)inventoryItem.get(j)).getItemCost() != ((OrderDetails)changedOrders.get(i)).getItemCost()) continue;
                        priceMatch = true;
                        ((InventoryElement)inventoryItem.get(j)).setItemQuantity(((InventoryElement)inventoryItem.get(j)).getItemQuantity() + 1);
                        LookupServicesUtil.getDBServices().setInventoryElement((InventoryElement)inventoryItem.get(j));
                        ListenerManager.getInstance().notify((GenericListener)ListenerManager.INVENTORY_LIST_LISTENER);
                        break;
                    }
                    if (priceMatch) continue;
                    InventoryElement element = new InventoryElement();
                    element.setItemID(((OrderDetails)changedOrders.get(i)).getItemID());
                    element.setItemCost(((OrderDetails)changedOrders.get(i)).getItemCost());
                    element.setItemQuantity(1);
                    element.setOosItem(false);
                    LookupServicesUtil.getDBServices().setInventoryElement(element);
                    ListenerManager.getInstance().notify((GenericListener)ListenerManager.INVENTORY_LIST_LISTENER);
                }
            }
            this.cleanupView();
            this.updateNeeded(false);
            ListenerManager.getInstance().notify((GenericListener)ListenerManager.TRANSACTION_LISTENER);
        }
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        if (null != this.searchField.getText()) {
            this.performSearch();
        }
    }

    private void searchFieldKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10 && null != this.searchField.getText() && !this.searchField.getText().trim().equals("") && this.searchButton.isEnabled()) {
            this.performSearch();
        }
    }

    private void newSearchFilterCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void pendingSearchFilterCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void oosSearchFilterCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void npbSearchFilterCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void pendingPrintSearchFilterCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void pendingMOSearchFilterCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void pendingECheckSearchFilterCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void completeSearchFilterCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void canceledSearchFilterCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void exportLabelsButtonActionPerformed(ActionEvent evt) {
        try {
            this.exportingOrders = true;
            this.disableListener(true);
            this.updateNeeded(true);
            this.applyChangesButton.setEnabled(false);
            this.clearChangesButton.setEnabled(false);
            this.activeOrdersFormX.getOrderDetails().setEnabled(false);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ExportService exportService = new ExportService();
                        exportService.init();
                    }
                    catch (Exception ex) {
                        ErrorsUtil.getInstance().logError(ex);
                    }
                }
            }).start();
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private void trackingIdTextFieldActionPerformed(ActionEvent evt) {
        if (null != this.trackingIdTextField.getText()) {
            boolean validString;
            this.trackingIdTextField.setText(this.trackingIdTextField.getText().trim());
            boolean bl = validString = !this.trackingIdTextField.getText().matches("^.*[^a-zA-Z0-9 ].*$");
            if (validString) {
                if (this.trackingIdTextField.getText().contains("1Z")) {
                    this.trackingCarrierTypeBox.setSelectedItem("UPS");
                }
                this.updateTrackingInformation(false);
            } else {
                this.trackingIdTextField.setText("");
            }
        }
    }

    private void trackingIdTextFieldFocusGained(FocusEvent evt) {
        this._trackingTextUpdated = true;
    }

    private void trackingIdTextFieldFocusLost(FocusEvent evt) {
        if (null != this.trackingIdTextField.getText()) {
            boolean validString;
            this.trackingIdTextField.setText(this.trackingIdTextField.getText().trim());
            boolean bl = validString = !this.trackingIdTextField.getText().matches("^.*[^a-zA-Z0-9 ].*$");
            if (validString) {
                if (this.trackingIdTextField.getText().contains("1Z")) {
                    this.trackingCarrierTypeBox.setSelectedItem("UPS");
                }
                this.updateTrackingInformation(false);
            } else {
                JOptionPane.showMessageDialog(null, "Tracking number can only contain alphanumeric characters");
                this.trackingIdTextField.setText("");
            }
        }
    }

    private void updateAllTrackingCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void updateTrackingButtonActionPerformed(ActionEvent evt) {
        if (null != this.trackingIdTextField.getText()) {
            boolean validString;
            this.trackingIdTextField.setText(this.trackingIdTextField.getText().trim());
            boolean bl = validString = !this.trackingIdTextField.getText().matches("^.*[^a-zA-Z0-9 ].*$");
            if (validString) {
                if (!this.updateAmazonTracking() && !this.updateEtsyTracking()) {
                    if (LookupServicesUtil.getDBServices().getAccountPreferences().isGenTrackingNotify()) {
                        JFrame frame = new JFrame();
                        ToggleBox newToggle = new ToggleBox((Frame)frame, true, "Please note that only orders linked to an eBay account will be pushed to eBay.\nTracking for orders which have been unmerged or created will need to be manually updated within eBay.", 1);
                        newToggle.setVisible(true);
                    }
                    this.updateTrackingInformation(true);
                }
            } else {
                JOptionPane.showMessageDialog(null, "Tracking number can only contain alphanumeric characters, please correct and try again.");
                this.trackingIdTextField.setText("");
            }
        }
    }

    private void orderSplitButtonActionPerformed(ActionEvent evt) {
        this.disableListener(true);
        HashMap splitList = new HashMap();
        boolean error = false;
        for (int row : this.activeOrdersFormX.getOrderDetails().getSelectedRows()) {
            CompleteOrder completeOrder = this._completeOrders.get(this._orderMapping.get(row));
            OrderDetails detail = (OrderDetails)completeOrder.getOrderDetails().get(row - completeOrder.getRowStart());
            if (!splitList.containsKey(completeOrder)) {
                ArrayList detailList = new ArrayList();
                splitList.put(completeOrder, detailList);
            }
            ((ArrayList)splitList.get(completeOrder)).add(detail);
        }
        if (!error) {
            LookupServicesUtil.getDBServices().splitOrders(splitList);
            ListenerManager.getInstance().notify((GenericListener)ListenerManager.TRANSACTION_LISTENER);
        } else {
            JOptionPane.showMessageDialog(null, "Unable to split Amazon orders.");
            this.disableListener(false);
        }
    }

    private void customerCommentsTextAreaFocusGained(FocusEvent evt) {
        this.customerApplyCommentsButton.setEnabled(true);
        this._customerCommentBoxUpdated = true;
    }

    private void customerCommentsTextAreaFocusLost(FocusEvent evt) {
        this.updateCustomerCommentBox();
    }

    private void customerApplyCommentsButtonActionPerformed(ActionEvent evt) {
        this.updateCustomerCommentBox();
        this.customerApplyCommentsButton.setEnabled(false);
    }

    private void unMergeButtonActionPerformed(ActionEvent evt) {
        if (LookupServicesUtil.getDBServices().getAccountPreferences().isGenUnmergeNotify()) {
            JFrame frame = new JFrame();
            ToggleBox newToggle = new ToggleBox((Frame)frame, true, "Unmerged items will have their shipping and handling value changed to 0.0", 2);
            newToggle.setVisible(true);
        }
        this.disableListener(true);
        boolean error = false;
        HashMap unmergeList = new HashMap();
        for (int row : this.activeOrdersFormX.getOrderDetails().getSelectedRows()) {
            CompleteOrder completeOrder = this._completeOrders.get(this._orderMapping.get(row));
            OrderDetails detail = (OrderDetails)completeOrder.getOrderDetails().get(row - completeOrder.getRowStart());
            if (detail.getEbaySite().equals("Amazon")) {
                error = true;
                break;
            }
            if (!unmergeList.containsKey(completeOrder)) {
                ArrayList detailList = new ArrayList();
                unmergeList.put(completeOrder, detailList);
            }
            ((ArrayList)unmergeList.get(completeOrder)).add(detail);
        }
        if (!error) {
            LookupServicesUtil.getDBServices().unmergeOrders(unmergeList);
            ListenerManager.getInstance().notify((GenericListener)ListenerManager.TRANSACTION_LISTENER);
        } else {
            JOptionPane.showMessageDialog(null, "Unable to Merge / Unmerge Amazon orders.");
            this.disableListener(false);
        }
    }

    private void updateCustomFeeListButtonActionPerformed(ActionEvent evt) {
        JFrame frame = new JFrame();
        UpdateCustomFeeListForm updateCustomFeeListForm = new UpdateCustomFeeListForm((Frame)frame, true);
        updateCustomFeeListForm.setTitle("Manage Custom Fees");
        updateCustomFeeListForm.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createInvoiceButtonActionPerformed(ActionEvent evt) {
        try {
            int[] rows = this.activeOrdersFormX.getOrderDetails().getSelectedRows();
            HashMap<Integer, Integer> invoiceMap = new HashMap<Integer, Integer>();
            if (rows != null && rows.length > 0) {
                ArrayList<CompleteOrder> invoiceList = new ArrayList<CompleteOrder>();
                for (int i = 0; i < rows.length; ++i) {
                    CompleteOrder completeOrder;
                    int completeOrderID;
                    if (this._orderMapping == null || this._orderMapping.size() < rows[i]) continue;
                    int orderMap = this._orderMapping.get(rows[i]);
                    if (this._completeOrders == null || !this._completeOrders.containsKey(orderMap) || invoiceMap.containsKey(completeOrderID = (completeOrder = this._completeOrders.get(orderMap)).getOrder().getOrderID())) continue;
                    invoiceMap.put(completeOrderID, completeOrderID);
                    invoiceList.add(completeOrder);
                }
                boolean success = false;
                if (this._invoiceLocation != null) {
                    String filename;
                    this._invoiceLocation.setDialogTitle("Save Invoice(s) As");
                    if (this._invoiceLocation.showSaveDialog((Component)((Object)this)) == 0 && this._invoiceLocation.getSelectedFile() != null && this._invoiceLocation.getSelectedFile().getPath() != null && (filename = this._invoiceLocation.getSelectedFile().getPath().trim()) != null && !filename.isEmpty()) {
                        if (!filename.toLowerCase().endsWith("pdf")) {
                            filename = filename.concat(".pdf");
                        }
                        success = true;
                        this.startupLabel.setText("Generating Invoices...");
                        this.refreshProgressBar.setVisible(true);
                        this.refreshProgressBar.setValue(0);
                        this.refreshProgressBar.setStringPainted(true);
                        LookupServicesUtil.getInvoiceGeneratorServices().generateInvoices(invoiceList, filename);
                    }
                }
                if (!success) {
                    JOptionPane.showMessageDialog(null, "The location selected is not suitable. Please try again.");
                }
            } else {
                JOptionPane.showMessageDialog(null, "Please select an order(s) before creating an invoice.");
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        finally {
            this.refreshProgressBar.setVisible(false);
            this.refreshProgressBar.setValue(100);
        }
    }

    private void createRMAButtonActionPerformed(ActionEvent evt) {
        int[] rows = this.activeOrdersFormX.getOrderDetails().getSelectedRows();
        ArrayList<RMADetails> rmaNumbers = new ArrayList<RMADetails>();
        for (int row : rows) {
            int orderID = this._orderMapping.get(row);
            CompleteOrder completeOrder = this._completeOrders.get(orderID);
            OrderDetails detailsElement = (OrderDetails)completeOrder.getOrderDetails().get(row - completeOrder.getRowStart());
            RMADetails rmaDetails = new RMADetails();
            rmaDetails.setCustomer(completeOrder.getOrder().getCustomer());
            rmaDetails.setCustomerUsername(completeOrder.getOrder().getCustomer().getCustomerUserName());
            rmaDetails.setOrderDetails(detailsElement);
            rmaDetails.setOrderDetailsID(detailsElement.getOrderDetailsID());
            rmaDetails.setReplacementTracking("");
            rmaDetails.setReturnTracking("");
            rmaDetails.setRmaComments("");
            rmaDetails.setRmaDate(new java.sql.Date(Calendar.getInstance().getTime().getTime()));
            rmaDetails.setRmaReasonID(((RMAReason)LookupServicesUtil.getDBServices().getAvailableRMAReasons().get("")).getRmaReasonID());
            rmaDetails.setRmaStatusID(((RMAStatus)LookupServicesUtil.getDBServices().getAvailableRMAStatuses().get("New RMA")).getRmaStatusID());
            rmaNumbers.add(LookupServicesUtil.getDBServices().updateRMA(rmaDetails));
        }
        if (rows.length > 0) {
            Iterator rmaIter = rmaNumbers.iterator();
            String rmaString = "";
            while (rmaIter.hasNext()) {
                RMADetails result = (RMADetails)rmaIter.next();
                rmaString = rmaString + "\n" + result.getCustomer().getCustomerUserName() + " - " + result.getOrderDetails().getItemID() + " - RMA # " + result.getRmaNumberID();
            }
            JOptionPane.showMessageDialog(null, "RMAs Created" + rmaString);
        }
        ListenerManager.getInstance().notify((GenericListener)ListenerManager.RMA_LISTENER);
    }

    private void adminHoldSearchFilterCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void trackingIdTextFieldKeyTyped(KeyEvent evt) {
        this.updateTrackingButton.setEnabled(SubscriptionManager.getInstance().isCurrent() && !SubscriptionManager.getInstance().getEbayAccounts().isEmpty());
    }

    private void toggleButtons(boolean enabled, boolean pendingTracking, boolean noInventory, boolean multiOrder) {
        this._statusFilters.clear();
        this.adminHoldCheckBox.setSelected(false);
        this.newFilterCheckBox.setSelected(false);
        this.pendingFilterCheckBox.setSelected(false);
        this.oosFilterCheckBox.setSelected(false);
        this.npbFilterCheckBox.setSelected(false);
        this.pendingPrintCheckBox.setSelected(false);
        this.pendingECheckCheckBox.setSelected(false);
        this.pendingMOCheckBox.setSelected(false);
        this.exportLabelsCheckBox.setSelected(false);
        this.pendingTrackingCheckBox.setSelected(pendingTracking && !enabled);
        this.multiOrderCheckBox.setSelected(multiOrder && !enabled);
        this.NIACheckbox.setSelected(false);
        this.OCCheckbox.setSelected(false);
        this.adminHoldCheckBox.setEnabled(enabled);
        this.newFilterCheckBox.setEnabled(enabled);
        this.pendingFilterCheckBox.setEnabled(enabled);
        this.oosFilterCheckBox.setEnabled(enabled);
        this.npbFilterCheckBox.setEnabled(enabled);
        this.pendingPrintCheckBox.setEnabled(enabled);
        this.pendingECheckCheckBox.setEnabled(enabled);
        this.pendingMOCheckBox.setEnabled(enabled);
        this.exportLabelsCheckBox.setEnabled(enabled);
        this.pendingTrackingCheckBox.setEnabled(pendingTracking || enabled);
        this.multiOrderCheckBox.setEnabled(multiOrder || enabled);
        this.NIACheckbox.setEnabled(enabled);
        this.OCCheckbox.setEnabled(enabled);
    }

    private void filterAction(boolean isSelected, String stringStatus) {
        this.disableListener(true);
        this.orderCommentsTextArea.setText("");
        this.customerCommentsTextArea.setText("");
        OrderStatus status = this._statusList.get(stringStatus);
        if (isSelected) {
            this._statusFilters.add(status);
        } else {
            this._statusFilters.remove(status);
        }
        LookupServicesUtil.getDBServices().setRefresh(false);
        LookupServicesUtil.getDBServices().setOrderFilters(this.getFilters());
    }

    private void newFilterCheckBoxActionPerformed(ActionEvent evt) {
        this.filterAction(this.newFilterCheckBox.isSelected(), "New");
    }

    private void pendingFilterCheckBoxActionPerformed(ActionEvent evt) {
        this.filterAction(this.pendingFilterCheckBox.isSelected(), "Pending");
    }

    private void oosFilterCheckBoxActionPerformed(ActionEvent evt) {
        this.filterAction(this.oosFilterCheckBox.isSelected(), "OOS");
    }

    private void npbFilterCheckBoxActionPerformed(ActionEvent evt) {
        this.filterAction(this.npbFilterCheckBox.isSelected(), "NPB");
    }

    private void adminHoldCheckBoxActionPerformed(ActionEvent evt) {
        this.filterAction(this.adminHoldCheckBox.isSelected(), "Admin Hold");
    }

    private void pendingPrintCheckBoxActionPerformed(ActionEvent evt) {
        this.filterAction(this.pendingPrintCheckBox.isSelected(), "Pending Print");
    }

    private void pendingECheckCheckBoxActionPerformed(ActionEvent evt) {
        this.filterAction(this.pendingECheckCheckBox.isSelected(), "Pending E-Check");
    }

    private void pendingMOCheckBoxActionPerformed(ActionEvent evt) {
        this.filterAction(this.pendingMOCheckBox.isSelected(), "Pending MO");
    }

    private void exportLabelsCheckBoxActionPerformed(ActionEvent evt) {
        this.filterAction(this.exportLabelsCheckBox.isSelected(), "Export Labels");
    }

    private void pendingTrackingCheckBoxActionPerformed(ActionEvent evt) {
        if (this.pendingTrackingCheckBox.isSelected()) {
            int result = JOptionPane.showConfirmDialog((Component)((Object)this), "To ensure accurate results make sure that you have refreshed recently. \n Would you still like to proceed?", "Confirm Refresh", 0);
            if (result == 0) {
                this.toggleButtons(false, true, false, false);
                LookupServicesUtil.getDBServices().setTrackingOverride(true);
            } else {
                this.pendingTrackingCheckBox.setSelected(false);
            }
        } else {
            this.toggleButtons(true, true, false, false);
            LookupServicesUtil.getDBServices().setTrackingOverride(false);
        }
    }

    private void multiOrderCheckBoxActionPerformed(ActionEvent evt) {
        this.disableListener(true);
        if (this.multiOrderCheckBox.isSelected()) {
            this.toggleButtons(false, false, false, true);
            LookupServicesUtil.getDBServices().setMultiOrders(true);
            this.sortComboBox.setSelectedItem("Customer ID");
        } else {
            this.toggleButtons(true, false, false, true);
            LookupServicesUtil.getDBServices().setMultiOrders(false);
            this.sortComboBox.setSelectedItem("Order Date");
        }
        this.disableListener(false);
    }

    private void exportLabelsSearchFilterCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void doBulkProgress() {
        this.currentProgress = 0;
        this.totalProgress = this.activeOrdersFormX.getOrderDetails().getSelectedRows().length;
        this.refreshProgressBar.setVisible(true);
        this.refreshProgressBar.setValue(0);
        this.refreshProgressBar.setString(this.currentProgress + " / " + this.totalProgress);
        this.refreshProgressBar.setStringPainted(true);
        this.startupLabel.setText("Bulk Inventory Update Underway..");
        this.startupLabel.paintImmediately(this.startupLabel.getVisibleRect());
    }

    private void updateBulkProgress() {
        this.refreshProgressBar.setVisible(true);
        ++this.currentProgress;
        if (this.totalProgress == 0) {
            this.currentProgress = 1;
            this.totalProgress = 1;
        }
        double progressUpdate = (double)this.currentProgress / (double)this.totalProgress;
        this.refreshProgressBar.setValue((int)(progressUpdate * 100.0));
        this.refreshProgressBar.setString(this.currentProgress + " / " + this.totalProgress);
        this.refreshProgressBar.setStringPainted(true);
        if (this.currentProgress >= this.totalProgress) {
            this.stopBulkProgress();
        }
    }

    private void stopBulkProgress() {
        this.currentProgress = 0;
        this.totalProgress = 0;
        this.refreshProgressBar.setVisible(false);
        this.refreshProgressBar.setValue(100);
        this.refreshProgressBar.setString("");
        this.startupLabel.setText("Data has been updated;");
        this.startupLabel.paintImmediately(this.startupLabel.getVisibleRect());
    }

    private void fixWholesalePricing() {
        boolean inUse = this.refreshProgressBar.isVisible();
        boolean creation = true;
        this.inventoryWarningMessage = "";
        this.disableListener(true);
        for (int row : this.activeOrdersFormX.getOrderDetails().getSelectedRows()) {
            if (inUse) {
                inUse = this.refreshProgressBar.isVisible();
            } else if (creation) {
                this.doBulkProgress();
                creation = false;
            }
            if (!creation) {
                this.updateBulkProgress();
            }
            CompleteOrder completeOrder = this._completeOrders.get(this._orderMapping.get(row));
            OrderDetails detail = (OrderDetails)completeOrder.getOrderDetails().get(row - completeOrder.getRowStart());
            this._updatedOrders.put(this._orderMapping.get(row), this._orderMapping.get(row));
            this.fixBulkInventory(detail, row);
        }
        this.createMessageAndLog();
        this.disableListener(false);
        this.updateNeeded(true);
        this.updateAdditionalDetails();
        this.stopBulkProgress();
    }

    private void testBulkInventory() {
        boolean inUse = this.refreshProgressBar.isVisible();
        boolean creation = true;
        this.inventoryWarningMessage = "";
        this.disableListener(true);
        for (int row : this.activeOrdersFormX.getOrderDetails().getSelectedRows()) {
            if (inUse) {
                inUse = this.refreshProgressBar.isVisible();
            } else if (creation) {
                this.doBulkProgress();
                creation = false;
            }
            if (!creation) {
                this.updateBulkProgress();
            }
            CompleteOrder completeOrder = this._completeOrders.get(this._orderMapping.get(row));
            OrderDetails detail = (OrderDetails)completeOrder.getOrderDetails().get(row - completeOrder.getRowStart());
            this._updatedOrders.put(this._orderMapping.get(row), this._orderMapping.get(row));
            this.updateInventoryStatus(detail, row);
        }
        this.createMessageAndLog();
        this.disableListener(false);
        this.updateNeeded(true);
        this.updateAdditionalDetails();
        this.stopBulkProgress();
    }

    private void bulkInventoryButtonActionPerformed(ActionEvent evt) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    OrderManagerTopComponent.this.testBulkInventory();
                }
                catch (Exception ex) {
                    ErrorsUtil.getInstance().logError(ex);
                }
            }
        }).start();
    }

    private void NIACheckboxActionPerformed(ActionEvent evt) {
        this.disableListener(true);
        if (this.NIACheckbox.isSelected()) {
            LookupServicesUtil.getDBServices().setNoInventory(true);
        } else {
            LookupServicesUtil.getDBServices().setNoInventory(false);
        }
        this.disableListener(false);
    }

    private void OCCheckboxActionPerformed(ActionEvent evt) {
        this.disableListener(true);
        if (this.OCCheckbox.isSelected()) {
            LookupServicesUtil.getDBServices().setOrderComments(true);
        } else {
            LookupServicesUtil.getDBServices().setOrderComments(false);
        }
        this.disableListener(false);
    }

    private void lastUpdateComboBoxActionPerformed(ActionEvent evt) {
    }

    private void refreshAmazonOnlyButtonActionPerformed(ActionEvent evt) {
        if (!LookupServicesUtil.getPaypalServices().updatePending() && !LookupServicesUtil.getEbayServices().updatePending()) {
            this.startupLabel.setText("Updating... May take a while.");
            this.refreshProgressBar.setVisible(true);
            this.refreshProgressBar.setValue((int)LookupServicesUtil.getEbayServices().getUpdatePercentage());
            this.refreshProgressBar.setStringPainted(true);
            this.startupLabel.paintImmediately(this.startupLabel.getVisibleRect());
            if (SubscriptionManager.getInstance().isWebsiteActive()) {
                LookupServicesUtil.getRESTHandlerServices().getWebsiteTransactions();
            }
            LookupServicesUtil.getEtsyServices().getTransactions(this.createRange(this.lastUpdateComboBox.getSelectedItem().toString()));
            LookupServicesUtil.getAmazonServices().refreshTransactions((String)this.lastUpdateComboBox.getSelectedItem());
            this.updateDateRange();
        } else if (LookupServicesUtil.getEbayServices().updatePending()) {
            JOptionPane.showMessageDialog(null, "Refresh already underway, please wait until it is finished.");
        } else {
            JOptionPane.showMessageDialog(null, "Update already underway, please wait until it is finished.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMessageAndLog() {
        JTextArea textField = new JTextArea();
        textField.setEditable(false);
        textField.setText(this.inventoryWarningMessage);
        File targetFile = null;
        int number = 1;
        if (!this.inventoryWarningMessage.trim().isEmpty()) {
            do {
                targetFile = CreationTools.createFileSpace(null, (String)"Logs", (String)("StockNotification" + number), (String)"txt");
                ++number;
            } while (targetFile == null || targetFile.exists());
            FileWriter writer = null;
            try {
                writer = new FileWriter(targetFile);
                textField.write(writer);
            }
            catch (Exception exp) {
                ErrorsUtil.getInstance().logError(exp);
            }
            finally {
                try {
                    writer.close();
                }
                catch (Exception ex) {
                    ErrorsUtil.getInstance().logError(ex);
                }
            }
            textField.setText("Log file saved under 'Logs'. ('StockNotification" + number + "')\n" + textField.getText());
            JOptionPane.showMessageDialog(null, textField);
        }
    }

    private void fixBulkInventory(OrderDetails detail, int rowChanged) {
        if (detail.isInhouse()) {
            String itemName = detail.getItemID();
            Collection inventoryElements = LookupServicesUtil.getDBServices().getInventoryList(itemName, false, false, false, new String[0], false);
            InventoryElement selectedInventoryItem = null;
            if (inventoryElements.size() == 1) {
                for (ArrayList inventorySubset : inventoryElements) {
                    for (InventoryElement inventoryElement : inventorySubset) {
                        if (selectedInventoryItem == null) {
                            selectedInventoryItem = inventoryElement;
                        }
                        if (inventoryElement.getItemQuantity() <= 0 || selectedInventoryItem != null && !(selectedInventoryItem.getItemCost() > inventoryElement.getItemCost()) && selectedInventoryItem.getItemQuantity() > 0) continue;
                        selectedInventoryItem = inventoryElement;
                    }
                }
            }
            if (null != selectedInventoryItem) {
                detail.setItemCost(selectedInventoryItem.getItemCost());
                TableModel tableData = this.activeOrdersFormX.getOrderDetails().getModel();
                tableData.setValueAt(String.valueOf(selectedInventoryItem.getItemCost()), rowChanged, this.activeOrdersFormX.getWholesaleCostColumn());
            }
        }
    }

    private void updateInventoryStatus(OrderDetails detail, int rowChanged) {
        if (!detail.isInhouse()) {
            Item item;
            String itemName = detail.getItemID();
            Collection inventoryElements = LookupServicesUtil.getDBServices().getInventoryList(itemName, false, false, false, new String[0], false);
            InventoryElement selectedInventoryItem = null;
            if (inventoryElements.size() == 1) {
                for (ArrayList inventorySubset : inventoryElements) {
                    for (InventoryElement inventoryElement : inventorySubset) {
                        if (selectedInventoryItem == null) {
                            selectedInventoryItem = inventoryElement;
                        }
                        if (inventoryElement.getItemQuantity() <= 0 || selectedInventoryItem != null && !(selectedInventoryItem.getItemCost() > inventoryElement.getItemCost()) && selectedInventoryItem.getItemQuantity() > 0) continue;
                        selectedInventoryItem = inventoryElement;
                    }
                }
            }
            if (null != selectedInventoryItem && (item = LookupServicesUtil.getDBServices().getItem(selectedInventoryItem.getItemID())) != null && !item.isDropShipped()) {
                detail.setItemCost(selectedInventoryItem.getItemCost());
                detail.setItemID(selectedInventoryItem.getItemID());
                detail.setBackordered(selectedInventoryItem.isOosItem());
                detail.setInhouse(true);
                TableModel tableData = this.activeOrdersFormX.getOrderDetails().getModel();
                tableData.setValueAt(true, rowChanged, this.activeOrdersFormX.getInhouseColumn());
                tableData.setValueAt(String.valueOf(selectedInventoryItem.getItemCost()), rowChanged, this.activeOrdersFormX.getWholesaleCostColumn());
                tableData.setValueAt(selectedInventoryItem.getItemID(), rowChanged, this.activeOrdersFormX.getItemIDColumn());
                tableData.setValueAt(selectedInventoryItem.isOosItem(), rowChanged, this.activeOrdersFormX.getBackorderedColumn());
                tableData.setValueAt(item.getLocation(), rowChanged, this.activeOrdersFormX.getLocationColumn());
                tableData.setValueAt(String.valueOf(item.getItemWeight()), rowChanged, this.activeOrdersFormX.getShippingWeightColumn());
                tableData.setValueAt(String.valueOf(item.getPackedWeight()), rowChanged, this.activeOrdersFormX.getPackedWeightColumn());
                selectedInventoryItem.setItemQuantity(selectedInventoryItem.getItemQuantity() - 1);
                LookupServicesUtil.getDBServices().setInventoryElement(selectedInventoryItem);
                int quantity = LookupServicesUtil.getDBServices().getItemQuantity(selectedInventoryItem.getItemID(), false);
                if (Preferences.getInstance().getAccountPreferences().getGenStockNotification() != AccountPreferences.NEVER) {
                    if (quantity <= Preferences.getInstance().getAccountPreferences().getGenStockNotification() && quantity > 0 && Preferences.getInstance().getAccountPreferences().getGenStockNotification() != 0) {
                        this.inventoryWarningMessage = this.inventoryWarningMessage + itemName + ": running low on stock, time to reorder.\n";
                    } else if (quantity == 0) {
                        this.inventoryWarningMessage = item.isDiscontinued() ? this.inventoryWarningMessage + itemName + ": consumed last item in stock. Item Discontinued, take auction down.\n" : this.inventoryWarningMessage + itemName + ": consumed last item in stock, time to reorder\n";
                    }
                }
            }
        }
    }

    private void updateCommentBox() {
        block13: {
            if (-1 != this._currentRow) {
                try {
                    CompleteOrder completeOrder = this._completeOrders.get(this._orderMapping.get(this._currentRow));
                    if (null == this.orderCommentsTextArea.getText()) break block13;
                    if (null != completeOrder.getOrder().getOrderComments()) {
                        if (!this.orderCommentsTextArea.getText().equals(completeOrder.getOrder().getOrderComments())) {
                            completeOrder.getOrder().setOrderComments(this.orderCommentsTextArea.getText());
                            this._updatedOrders.put(this._orderMapping.get(this._currentRow), this._orderMapping.get(this._currentRow));
                            this.updateNeeded(true);
                        }
                        break block13;
                    }
                    completeOrder.getOrder().setOrderComments(this.orderCommentsTextArea.getText());
                    this._updatedOrders.put(this._orderMapping.get(this._currentRow), this._orderMapping.get(this._currentRow));
                    this.updateNeeded(true);
                }
                catch (Exception ex) {
                    ErrorsUtil.getInstance().logError(ex);
                }
            } else if (this.activeOrdersFormX.getOrderDetails().getSelectedRow() != -1) {
                this._currentRow = this.activeOrdersFormX.getOrderDetails().getSelectedRow();
                try {
                    CompleteOrder completeOrder = this._completeOrders.get(this._orderMapping.get(this._currentRow));
                    if (null != this.orderCommentsTextArea.getText()) {
                        if (null != completeOrder.getOrder().getOrderComments()) {
                            if (!this.orderCommentsTextArea.getText().equals(completeOrder.getOrder().getOrderComments())) {
                                completeOrder.getOrder().setOrderComments(this.orderCommentsTextArea.getText());
                                this._updatedOrders.put(this._orderMapping.get(this._currentRow), this._orderMapping.get(this._currentRow));
                                this.updateNeeded(true);
                            }
                        } else {
                            completeOrder.getOrder().setOrderComments(this.orderCommentsTextArea.getText());
                            this._updatedOrders.put(this._orderMapping.get(this._currentRow), this._orderMapping.get(this._currentRow));
                            this.updateNeeded(true);
                        }
                    }
                }
                catch (Exception ex) {
                    ErrorsUtil.getInstance().logError(ex);
                }
            }
        }
        this._commentBoxUpdated = false;
    }

    private void updateShippingMethodField() {
        if (-1 != this._currentRow && !this._completeOrders.isEmpty() && !this._orderMapping.isEmpty()) {
            CompleteOrder completeOrder = this._completeOrders.get(this._orderMapping.get(this._currentRow));
            if (null != this.shippingMethodTextField.getText()) {
                if (null != completeOrder.getOrder().getShippingMethodName()) {
                    if (!this.shippingMethodTextField.getText().equals(completeOrder.getOrder().getShippingMethodName())) {
                        completeOrder.getOrder().setShippingMethodName(this.shippingMethodTextField.getText());
                        this._updatedOrders.put(this._orderMapping.get(this._currentRow), this._orderMapping.get(this._currentRow));
                        this.updateNeeded(true);
                    }
                } else {
                    completeOrder.getOrder().setShippingMethodName(this.shippingMethodTextField.getText());
                    this._updatedOrders.put(this._orderMapping.get(this._currentRow), this._orderMapping.get(this._currentRow));
                    this.updateNeeded(true);
                }
            }
        }
        this._shippingMethodTextUpdated = false;
    }

    private boolean updateAmazonTracking() {
        try {
            CompleteOrder completeOrder;
            if (-1 != this._currentRow && (completeOrder = this._completeOrders.get(this._orderMapping.get(this._currentRow))) != null && ((OrderDetails)completeOrder.getOrderDetails().get(0)).getEbaySite().equals("Amazon")) {
                HashMap<Integer, CompleteOrder> amazonOrderList = new HashMap<Integer, CompleteOrder>();
                amazonOrderList.put(completeOrder.getOrder().getOrderID(), completeOrder);
                LookupServicesUtil.getAmazonServices().updateTracking(amazonOrderList.values());
                return true;
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        return false;
    }

    private boolean updateEtsyTracking() {
        try {
            CompleteOrder completeOrder;
            if (-1 != this._currentRow && (completeOrder = this._completeOrders.get(this._orderMapping.get(this._currentRow))) != null) {
                OrderDetails detail;
                int offset = this._currentRow - completeOrder.getRowStart();
                if (completeOrder.getOrderDetails().size() >= offset && (detail = (OrderDetails)completeOrder.getOrderDetails().get(offset)).getEbaySite().equalsIgnoreCase("ETSY")) {
                    LookupServicesUtil.getEtsyServices().submitTracking(detail.getAccountName(), detail.getOrderNumber(), detail.getTrackingNumber(), detail.getCarrier());
                    return true;
                }
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        return false;
    }

    private void updateTrackingInformation(boolean updateEbay) {
        if (-1 != this._currentRow) {
            CompleteOrder completeOrder = this._completeOrders.get(this._orderMapping.get(this._currentRow));
            int offset = this._currentRow - completeOrder.getRowStart();
            if (null != this.trackingIdTextField.getText()) {
                if (this.updateAllTrackingCheckBox.isSelected() && updateEbay) {
                    for (int i = 0; i < completeOrder.getOrderDetails().size(); ++i) {
                        if (((OrderDetails)completeOrder.getOrderDetails().get(i)).isInhouse() == ((OrderDetails)completeOrder.getOrderDetails().get(offset)).isInhouse()) {
                            if (null != ((OrderDetails)completeOrder.getOrderDetails().get(i)).getTrackingNumber()) {
                                if (!((OrderDetails)completeOrder.getOrderDetails().get(i)).getTrackingNumber().equals(this.trackingIdTextField.getText())) {
                                    ((OrderDetails)completeOrder.getOrderDetails().get(i)).setTrackingNumber(this.trackingIdTextField.getText());
                                    ((OrderDetails)completeOrder.getOrderDetails().get(i)).setCarrier(this.trackingCarrierTypeBox.getSelectedItem().toString());
                                    this._updatedOrders.put(this._orderMapping.get(this._currentRow - offset + i), this._orderMapping.get(this._currentRow - offset + i));
                                    this.updateNeeded(true);
                                }
                            } else {
                                ((OrderDetails)completeOrder.getOrderDetails().get(i)).setTrackingNumber(this.trackingIdTextField.getText());
                                ((OrderDetails)completeOrder.getOrderDetails().get(i)).setCarrier(this.trackingCarrierTypeBox.getSelectedItem().toString());
                                this._updatedOrders.put(this._orderMapping.get(this._currentRow - offset + i), this._orderMapping.get(this._currentRow - offset + i));
                                this.updateNeeded(true);
                            }
                        }
                        if (((OrderDetails)completeOrder.getOrderDetails().get(i)).getAccountName().isEmpty()) continue;
                        boolean websiteAccount = false;
                        if (SubscriptionManager.getInstance().isWebsiteActive() && this._websiteList.containsKey(((OrderDetails)completeOrder.getOrderDetails().get(i)).getAccountName())) {
                            websiteAccount = true;
                            LookupServicesUtil.getRESTHandlerServices().updateOrder(this._websiteList.get(((OrderDetails)completeOrder.getOrderDetails().get(i)).getAccountName()).getWebsiteID(), (OrderDetails)completeOrder.getOrderDetails().get(i));
                        }
                        if (websiteAccount || LookupServicesUtil.getEbayServices().updateTracking((OrderDetails)completeOrder.getOrderDetails().get(i))) continue;
                        JOptionPane.showMessageDialog((Component)((Object)this), "Unable to push tracking to eBay, invalid/duplicate tracking number entered. ", "Update Tracking Notification", 1);
                    }
                } else {
                    if (!((OrderDetails)completeOrder.getOrderDetails().get(offset)).getTrackingNumber().equals(this.trackingIdTextField.getText())) {
                        ((OrderDetails)completeOrder.getOrderDetails().get(offset)).setTrackingNumber(this.trackingIdTextField.getText());
                        ((OrderDetails)completeOrder.getOrderDetails().get(offset)).setCarrier(this.trackingCarrierTypeBox.getSelectedItem().toString());
                        this._updatedOrders.put(this._orderMapping.get(this._currentRow), this._orderMapping.get(this._currentRow));
                        this.updateNeeded(true);
                    }
                    if (updateEbay && !((OrderDetails)completeOrder.getOrderDetails().get(offset)).getAccountName().isEmpty()) {
                        boolean websiteAccount = false;
                        if (SubscriptionManager.getInstance().isWebsiteActive() && this._websiteList.containsKey(((OrderDetails)completeOrder.getOrderDetails().get(offset)).getAccountName())) {
                            websiteAccount = true;
                            LookupServicesUtil.getRESTHandlerServices().updateOrder(this._websiteList.get(((OrderDetails)completeOrder.getOrderDetails().get(offset)).getAccountName()).getWebsiteID(), (OrderDetails)completeOrder.getOrderDetails().get(offset));
                        }
                        if (!websiteAccount && !LookupServicesUtil.getEbayServices().updateTracking((OrderDetails)completeOrder.getOrderDetails().get(offset))) {
                            JOptionPane.showMessageDialog((Component)((Object)this), "Unable to push tracking to eBay, invalid/duplicate tracking number entered. ", "Update Tracking Notification", 1);
                        }
                    }
                }
            }
        }
        this._trackingTextUpdated = false;
    }

    public static synchronized OrderManagerTopComponent findInstance() {
        if (instance == null) {
            instance = new OrderManagerTopComponent();
        }
        return instance;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    Object readProperties(Properties p) {
        if (instance == null) {
            instance = this;
        }
        instance.readPropertiesImpl(p);
        return instance;
    }

    private void readPropertiesImpl(Properties p) {
        String version = p.getProperty("version");
    }

    public void databaseUpdated() {
        if (!this.applyChangesButton.isEnabled() && !this.exportingOrders) {
            this.disableListener(true);
            this._negativeProfit.clear();
            this.cleanupView();
            this.updateOrders();
        }
    }

    private Integer[] getFilters() {
        Integer[] filters = new Integer[this._statusFilters.size()];
        int counter = 0;
        for (OrderStatus status : this._statusFilters) {
            filters[counter++] = status.getOrderStatusID();
        }
        return filters;
    }

    private Integer[] getFilters(ArrayList<OrderStatus> filter) {
        Integer[] filters = new Integer[filter.size()];
        int counter = 0;
        for (OrderStatus status : filter) {
            filters[counter++] = status.getOrderStatusID();
        }
        return filters;
    }

    public void recreateComboBox() {
        this.activeOrdersFormX.recreateComboBox();
        ListenerManager.getInstance().notify((GenericListener)ListenerManager.TRANSACTION_LISTENER);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e == null) {
            this.activeOrdersFormX.getOrderDetails().clearSelection();
        }
        if (this._commentBoxUpdated) {
            this.updateCommentBox();
        }
        if (this._customerCommentBoxUpdated) {
            this.updateCustomerCommentBox();
        }
        if (this._shippingMethodTextUpdated) {
            this.updateShippingMethodField();
        }
        if (this._trackingTextUpdated) {
            boolean validString;
            this.trackingIdTextField.setText(this.trackingIdTextField.getText().trim());
            boolean bl = validString = !this.trackingIdTextField.getText().matches("^.*[^a-zA-Z0-9 ].*$");
            if (validString) {
                if (this.trackingIdTextField.getText().contains("1Z")) {
                    this.trackingCarrierTypeBox.setSelectedItem("UPS");
                }
            } else {
                this.trackingIdTextField.setText("");
            }
            this.updateTrackingInformation(false);
        }
        this.handleButtons();
        this.updateAdditionalDetails();
        this.updateTrackingButton.setEnabled(this.trackingIdTextField.getText() != null && !this.trackingIdTextField.getText().isEmpty() && SubscriptionManager.getInstance().isCurrent() && !SubscriptionManager.getInstance().getEbayAccounts().isEmpty());
    }

    private boolean handleButtons() {
        if (this.activeOrdersFormX.getOrderDetails().getSelectedRow() == -1 || this._dataChanged) {
            this.unMergeButton.setEnabled(false);
            this.mergeButton.setEnabled(false);
            this.createRMAButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.createInvoiceButton.setEnabled(false);
            this.orderSplitButton.setEnabled(false);
            this.bulkInventoryButton.setEnabled(false);
            return false;
        }
        this.unMergeButton.setEnabled(true);
        this.mergeButton.setEnabled(true);
        this.createRMAButton.setEnabled(true);
        this.deleteButton.setEnabled(true);
        this.createInvoiceButton.setEnabled(true);
        this.orderSplitButton.setEnabled(true);
        this.bulkInventoryButton.setEnabled(true);
        return true;
    }

    public void updateAdditionalDetails() {
        if (!this.disableListener) {
            this._currentRow = this.activeOrdersFormX.getOrderDetails().getSelectedRow();
            if (this._currentRow != -1) {
                CompleteOrder completeOrder = this._completeOrders.get(this._orderMapping.get(this._currentRow));
                if (null != completeOrder.getOrder().getOrderComments()) {
                    this.orderCommentsTextArea.setText(completeOrder.getOrder().getOrderComments());
                }
                if (null != completeOrder.getOrder().getCustomer().getCustomerComments()) {
                    this.customerCommentsTextArea.setText(completeOrder.getOrder().getCustomer().getCustomerComments());
                }
                this.usernameLabel.setText(completeOrder.getOrder().getCustomer().getCustomerUserName());
                this.updateFees(this._orderMapping.get(this._currentRow));
                this.shippingMethodTextField.setText(completeOrder.getOrder().getShippingMethodName());
                float inhouseOrderWeight = 0.0f;
                float totalOrderWeight = 0.0f;
                for (OrderDetails orderDetails : completeOrder.getOrderDetails()) {
                    if (null == orderDetails.getItemID() || orderDetails.getItemID().equals("")) continue;
                    Item item = LookupServicesUtil.getDBServices().getItem(orderDetails.getItemID());
                    if (null != item) {
                        if (orderDetails.isInhouse()) {
                            inhouseOrderWeight += item.getItemWeight();
                            totalOrderWeight += item.getItemWeight();
                        } else {
                            totalOrderWeight += item.getItemWeight();
                        }
                    }
                    if (orderDetails.isInhouse() || !(orderDetails.getEbayWeight() > 0.0f)) continue;
                    if (null != item) {
                        totalOrderWeight -= item.getItemWeight();
                    }
                    totalOrderWeight += orderDetails.getEbayWeight();
                }
                if (SubscriptionManager.getInstance().isInventoryActive()) {
                    this.inhouseWeightField.setText(String.valueOf(inhouseOrderWeight));
                }
                this.totalWeightField.setText(String.valueOf(totalOrderWeight));
                try {
                    this.trackingIdTextField.setText(((OrderDetails)completeOrder.getOrderDetails().get(this._currentRow - completeOrder.getRowStart())).getTrackingNumber());
                    this.trackingCarrierTypeBox.setSelectedItem(((OrderDetails)completeOrder.getOrderDetails().get(this._currentRow - completeOrder.getRowStart())).getCarrier());
                }
                catch (Exception ex) {
                    ErrorsUtil.getInstance().logError(ex);
                    this.updateOrders();
                }
            } else {
                this.cleanupView();
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (!this.disableListener) {
            boolean valid;
            TableModel tableData;
            CompleteOrder completeOrder;
            int rowChanged;
            block135: {
                SimpleDateFormat df;
                this.disableListener(true);
                rowChanged = e.getFirstRow();
                this._updatedOrders.put(this._orderMapping.get(rowChanged), this._orderMapping.get(rowChanged));
                completeOrder = this._completeOrders.get(this._orderMapping.get(rowChanged));
                int offset = rowChanged - completeOrder.getRowStart();
                tableData = this.activeOrdersFormX.getOrderDetails().getModel();
                valid = true;
                if (e.getColumn() == this.activeOrdersFormX.getPayPalAccountColumn()) {
                    completeOrder.getOrder().setPaypalAccount(tableData.getValueAt(rowChanged, this.activeOrdersFormX.getPayPalAccountColumn()).toString());
                } else if (e.getColumn() == this.activeOrdersFormX.getAddressColumn()) {
                    completeOrder.getOrder().getCustomer().setCustomerAddress(tableData.getValueAt(rowChanged, this.activeOrdersFormX.getAddressColumn()).toString());
                } else if (e.getColumn() == this.activeOrdersFormX.getCityColumn()) {
                    completeOrder.getOrder().getCustomer().setCustomerCity(tableData.getValueAt(rowChanged, this.activeOrdersFormX.getCityColumn()).toString());
                } else if (e.getColumn() == this.activeOrdersFormX.getCountryColumn()) {
                    completeOrder.getOrder().getCustomer().setCustomerCountry(tableData.getValueAt(rowChanged, this.activeOrdersFormX.getCountryColumn()).toString());
                } else if (e.getColumn() == this.activeOrdersFormX.getCustomerIDColumn()) {
                    if (!tableData.getValueAt(rowChanged, this.activeOrdersFormX.getCustomerIDColumn()).equals(completeOrder.getOrder().getCustomer().getCustomerUserName())) {
                        tableData.setValueAt(completeOrder.getOrder().getCustomer().getCustomerUserName(), rowChanged, this.activeOrdersFormX.getCustomerIDColumn());
                    }
                } else if (e.getColumn() == this.activeOrdersFormX.getAccountNameColumn()) {
                    if (!tableData.getValueAt(rowChanged, this.activeOrdersFormX.getAccountNameColumn()).equals(((OrderDetails)completeOrder.getOrderDetails().get(offset)).getAccountName())) {
                        tableData.setValueAt(((OrderDetails)completeOrder.getOrderDetails().get(offset)).getAccountName(), rowChanged, this.activeOrdersFormX.getAccountNameColumn());
                    }
                } else if (e.getColumn() == this.activeOrdersFormX.getEbaySiteColumn()) {
                    ((OrderDetails)completeOrder.getOrderDetails().get(offset)).setEbaySite(tableData.getValueAt(rowChanged, this.activeOrdersFormX.getEbaySiteColumn()).toString());
                } else if (e.getColumn() == this.activeOrdersFormX.getEmailColumn()) {
                    completeOrder.getOrder().getCustomer().setCustomerEmail(tableData.getValueAt(rowChanged, this.activeOrdersFormX.getEmailColumn()).toString());
                } else if (e.getColumn() == this.activeOrdersFormX.getNameColumn()) {
                    completeOrder.getOrder().getCustomer().setCustomerName(tableData.getValueAt(rowChanged, this.activeOrdersFormX.getNameColumn()).toString());
                } else if (e.getColumn() == this.activeOrdersFormX.getStateColumn()) {
                    completeOrder.getOrder().getCustomer().setCustomerState(tableData.getValueAt(rowChanged, this.activeOrdersFormX.getStateColumn()).toString());
                } else if (e.getColumn() == this.activeOrdersFormX.getZipcodeColumn()) {
                    completeOrder.getOrder().getCustomer().setCustomerZipcode(tableData.getValueAt(rowChanged, this.activeOrdersFormX.getZipcodeColumn()).toString());
                } else if (e.getColumn() == this.activeOrdersFormX.getOrderDateColumn()) {
                    String date = tableData.getValueAt(rowChanged, this.activeOrdersFormX.getOrderDateColumn()).toString();
                    try {
                        java.sql.Date today;
                        if (date.contains("/") && date.length() == 8) {
                            df = new SimpleDateFormat("MM/dd/yy");
                            today = new java.sql.Date(df.parse(date).getTime());
                        } else if (date.contains("/") && date.length() == 10) {
                            df = new SimpleDateFormat("MM/dd/yyyy");
                            today = new java.sql.Date(df.parse(date).getTime());
                        } else if (date.length() == 10) {
                            today = java.sql.Date.valueOf(date);
                        } else {
                            throw new Exception();
                        }
                        completeOrder.getOrder().setOrderDate(today);
                    }
                    catch (Exception ex) {
                        ErrorsUtil.getInstance().logError(ex);
                        valid = false;
                    }
                } else if (e.getColumn() == this.activeOrdersFormX.getShipDateColumn()) {
                    String date = tableData.getValueAt(rowChanged, this.activeOrdersFormX.getShipDateColumn()).toString();
                    try {
                        java.sql.Date today;
                        if (tableData.getValueAt(rowChanged, this.activeOrdersFormX.getShipDateColumn()).toString().equals("")) {
                            if (null != ((OrderDetails)completeOrder.getOrderDetails().get(offset)).getShipDate()) {
                                tableData.setValueAt(((OrderDetails)completeOrder.getOrderDetails().get(offset)).getShipDate().toString(), rowChanged, this.activeOrdersFormX.getShipDateColumn());
                            }
                            break block135;
                        }
                        if (date.contains("/") && date.length() == 8) {
                            df = new SimpleDateFormat("MM/dd/yy");
                            today = new java.sql.Date(df.parse(date).getTime());
                            ((OrderDetails)completeOrder.getOrderDetails().get(offset)).setShipDate(today);
                            break block135;
                        }
                        if (date.contains("/") && date.length() == 10) {
                            df = new SimpleDateFormat("MM/dd/yyyy");
                            today = new java.sql.Date(df.parse(date).getTime());
                            ((OrderDetails)completeOrder.getOrderDetails().get(offset)).setShipDate(today);
                            break block135;
                        }
                        if (date.length() == 10) {
                            today = java.sql.Date.valueOf(date);
                            ((OrderDetails)completeOrder.getOrderDetails().get(offset)).setShipDate(today);
                            break block135;
                        }
                        throw new Exception();
                    }
                    catch (Exception ex) {
                        ErrorsUtil.getInstance().logError(ex);
                        valid = false;
                    }
                } else if (e.getColumn() == this.activeOrdersFormX.getRetailCostColumn()) {
                    if (!tableData.getValueAt(rowChanged, this.activeOrdersFormX.getRetailCostColumn()).toString().equals(String.valueOf(completeOrder.getOrder().getOrderTotal()))) {
                        if (tableData.getValueAt(rowChanged, this.activeOrdersFormX.getRetailCostColumn()).equals("")) {
                            tableData.setValueAt("0.00", rowChanged, this.activeOrdersFormX.getRetailCostColumn());
                        }
                        String amount = tableData.getValueAt(rowChanged, this.activeOrdersFormX.getRetailCostColumn()).toString();
                        if (null != (amount = MathParser.isDollarAmount((String)amount))) {
                            completeOrder.getOrder().setOrderTotal(Float.valueOf(amount).floatValue());
                            tableData.setValueAt(amount, rowChanged, this.activeOrdersFormX.getRetailCostColumn());
                        } else {
                            valid = false;
                        }
                    }
                } else if (e.getColumn() == this.activeOrdersFormX.getShCostColumn()) {
                    if (!tableData.getValueAt(rowChanged, this.activeOrdersFormX.getShCostColumn()).toString().equals(String.valueOf(completeOrder.getOrder().getShippingCost()))) {
                        if (tableData.getValueAt(rowChanged, this.activeOrdersFormX.getShCostColumn()).toString().equals("")) {
                            tableData.setValueAt("0.00", rowChanged, this.activeOrdersFormX.getShCostColumn());
                        }
                        String amount = tableData.getValueAt(rowChanged, this.activeOrdersFormX.getShCostColumn()).toString();
                        if (null != (amount = MathParser.isDollarAmount((String)amount))) {
                            completeOrder.getOrder().setShippingCost(Float.valueOf(amount).floatValue());
                            tableData.setValueAt(amount, rowChanged, this.activeOrdersFormX.getShCostColumn());
                        } else {
                            valid = false;
                        }
                    }
                } else if (e.getColumn() == this.activeOrdersFormX.getShPaidColumn()) {
                    if (!tableData.getValueAt(rowChanged, this.activeOrdersFormX.getShPaidColumn()).toString().equals(String.valueOf(completeOrder.getOrder().getShippingPaid()))) {
                        if (tableData.getValueAt(rowChanged, this.activeOrdersFormX.getShPaidColumn()).toString().equals("")) {
                            tableData.setValueAt("0.00", rowChanged, this.activeOrdersFormX.getShPaidColumn());
                        }
                        String amount = tableData.getValueAt(rowChanged, this.activeOrdersFormX.getShPaidColumn()).toString();
                        if (null != (amount = MathParser.isDollarAmount((String)amount))) {
                            completeOrder.getOrder().setShippingPaid(Float.valueOf(amount).floatValue());
                            tableData.setValueAt(amount, rowChanged, this.activeOrdersFormX.getShPaidColumn());
                        } else {
                            valid = false;
                        }
                    }
                } else if (e.getColumn() == this.activeOrdersFormX.getShippingWeightColumn()) {
                    Item item;
                    boolean inhouseValue = (Boolean)tableData.getValueAt(rowChanged, this.activeOrdersFormX.getInhouseColumn());
                    if (inhouseValue && null != (item = LookupServicesUtil.getDBServices().getItem(tableData.getValueAt(rowChanged, this.activeOrdersFormX.getItemIDColumn()).toString().toLowerCase().trim()))) {
                        String itemWeight = MathParser.isDollarAmount((String)tableData.getValueAt(rowChanged, this.activeOrdersFormX.getShippingWeightColumn()).toString());
                        if (null != itemWeight) {
                            item.setItemWeight(Float.valueOf(itemWeight).floatValue());
                            LookupServicesUtil.getDBServices().setItem(item);
                        } else {
                            valid = false;
                        }
                    }
                } else if (e.getColumn() == this.activeOrdersFormX.getPackedWeightColumn()) {
                    Item item = LookupServicesUtil.getDBServices().getItem(tableData.getValueAt(rowChanged, this.activeOrdersFormX.getItemIDColumn()).toString().toLowerCase().trim());
                    if (null != item) {
                        String itemWeight = MathParser.isDollarAmount((String)tableData.getValueAt(rowChanged, this.activeOrdersFormX.getPackedWeightColumn()).toString());
                        if (null != itemWeight) {
                            item.setPackedWeight(Float.valueOf(itemWeight).floatValue());
                            LookupServicesUtil.getDBServices().setItem(item);
                        } else {
                            valid = false;
                        }
                    }
                } else if (e.getColumn() == this.activeOrdersFormX.getLocationColumn()) {
                    Item item = LookupServicesUtil.getDBServices().getItem(tableData.getValueAt(rowChanged, this.activeOrdersFormX.getItemIDColumn()).toString().toLowerCase().trim());
                    if (null != item) {
                        String location = tableData.getValueAt(rowChanged, this.activeOrdersFormX.getLocationColumn()).toString();
                        if (null != location) {
                            item.setLocation(location);
                            LookupServicesUtil.getDBServices().setItem(item);
                        } else {
                            valid = false;
                        }
                    }
                } else if (e.getColumn() == this.activeOrdersFormX.getItemIDColumn()) {
                    String itemID = tableData.getValueAt(rowChanged, this.activeOrdersFormX.getItemIDColumn()).toString().toLowerCase().trim();
                    tableData.setValueAt(itemID, rowChanged, this.activeOrdersFormX.getItemIDColumn());
                    if (!((Boolean)tableData.getValueAt(rowChanged, this.activeOrdersFormX.getInhouseColumn())).booleanValue()) {
                        float ebayWeight = ((OrderDetails)completeOrder.getOrderDetails().get(offset)).getEbayWeight();
                        ((OrderDetails)completeOrder.getOrderDetails().get(offset)).setItemID(itemID);
                        Item item = LookupServicesUtil.getDBServices().getItem(itemID);
                        if (null != item) {
                            if (ebayWeight > 0.0f) {
                                tableData.setValueAt(String.valueOf(ebayWeight), rowChanged, this.activeOrdersFormX.getShippingWeightColumn());
                            } else {
                                tableData.setValueAt(String.valueOf(item.getItemWeight()), rowChanged, this.activeOrdersFormX.getShippingWeightColumn());
                            }
                            tableData.setValueAt(String.valueOf(item.getPackedWeight()), rowChanged, this.activeOrdersFormX.getPackedWeightColumn());
                            tableData.setValueAt(String.valueOf(item.getLocation()), rowChanged, this.activeOrdersFormX.getLocationColumn());
                        } else if (!itemID.equals("")) {
                            item = new Item();
                            item.setItemID(itemID);
                            String itemWeight = MathParser.isDollarAmount((String)tableData.getValueAt(rowChanged, this.activeOrdersFormX.getShippingWeightColumn()).toString());
                            String packedWeight = MathParser.isDollarAmount((String)tableData.getValueAt(rowChanged, this.activeOrdersFormX.getPackedWeightColumn()).toString());
                            if (null != itemWeight) {
                                item.setItemWeight(Float.valueOf(itemWeight).floatValue());
                            }
                            if (null != packedWeight) {
                                item.setPackedWeight(Float.valueOf(packedWeight).floatValue());
                            }
                            item.setLocation(tableData.getValueAt(rowChanged, this.activeOrdersFormX.getLocationColumn()).toString());
                            LookupServicesUtil.getDBServices().setItem(item);
                        }
                    } else {
                        tableData.setValueAt(((OrderDetails)completeOrder.getOrderDetails().get(offset)).copy().getItemID(), rowChanged, this.activeOrdersFormX.getItemIDColumn());
                    }
                } else if (e.getColumn() == this.activeOrdersFormX.getItemNameColumn()) {
                    ((OrderDetails)completeOrder.getOrderDetails().get(offset)).setOrderDescription(tableData.getValueAt(rowChanged, this.activeOrdersFormX.getItemNameColumn()).toString());
                } else if (e.getColumn() == this.activeOrdersFormX.getRefNumberColumn()) {
                    ((OrderDetails)completeOrder.getOrderDetails().get(offset)).setOrderNumber(tableData.getValueAt(rowChanged, this.activeOrdersFormX.getRefNumberColumn()).toString());
                } else if (e.getColumn() == this.activeOrdersFormX.getWholesaleCostColumn()) {
                    String wholeSaleCost = MathParser.isDollarAmount((String)tableData.getValueAt(rowChanged, this.activeOrdersFormX.getWholesaleCostColumn()).toString());
                    String itemCost = String.valueOf(((OrderDetails)completeOrder.getOrderDetails().get(offset)).getItemCost());
                    if (wholeSaleCost == null || wholeSaleCost.isEmpty()) {
                        wholeSaleCost = "0.00";
                    }
                    if (((Boolean)tableData.getValueAt(rowChanged, this.activeOrdersFormX.getInhouseColumn())).booleanValue()) {
                        if (!wholeSaleCost.equalsIgnoreCase(itemCost)) {
                            tableData.setValueAt(itemCost, rowChanged, this.activeOrdersFormX.getWholesaleCostColumn());
                        }
                    } else if (!wholeSaleCost.equalsIgnoreCase(itemCost)) {
                        ((OrderDetails)completeOrder.getOrderDetails().get(offset)).setItemCost(Float.valueOf(wholeSaleCost).floatValue());
                        tableData.setValueAt(wholeSaleCost, rowChanged, this.activeOrdersFormX.getWholesaleCostColumn());
                    }
                } else if (e.getColumn() == this.activeOrdersFormX.getInhouseColumn()) {
                    boolean inhouseValue = (Boolean)tableData.getValueAt(rowChanged, this.activeOrdersFormX.getInhouseColumn());
                    String itemName = ((OrderDetails)completeOrder.getOrderDetails().get(offset)).getItemID();
                    Collection inventoryElements = LookupServicesUtil.getDBServices().getInventoryList(itemName, false, false, false, new String[0], false);
                    Iterator iter = inventoryElements.iterator();
                    InventoryElement selectedInventoryItem = null;
                    if (inhouseValue) {
                        if (inventoryElements.isEmpty()) {
                            JOptionPane.showMessageDialog(null, "No inventory found.");
                        } else if (inventoryElements.size() != 1) {
                            InventorySelectionForm inventorySelectionForm = new InventorySelectionForm(null, true, itemName);
                            inventorySelectionForm.setTitle("Inventory Selection");
                            inventorySelectionForm.setVisible(true);
                            selectedInventoryItem = inventorySelectionForm.getSelectedItem();
                        } else {
                            for (ArrayList inventorySubset : inventoryElements) {
                                for (InventoryElement inventoryElement : inventorySubset) {
                                    if (selectedInventoryItem == null) {
                                        selectedInventoryItem = inventoryElement;
                                    }
                                    if (inventoryElement.getItemQuantity() <= 0 || selectedInventoryItem != null && !(selectedInventoryItem.getItemCost() > inventoryElement.getItemCost()) && selectedInventoryItem.getItemQuantity() > 0) continue;
                                    selectedInventoryItem = inventoryElement;
                                }
                            }
                        }
                        if (null != selectedInventoryItem) {
                            ((OrderDetails)completeOrder.getOrderDetails().get(offset)).setItemCost(selectedInventoryItem.getItemCost());
                            ((OrderDetails)completeOrder.getOrderDetails().get(offset)).setItemID(selectedInventoryItem.getItemID());
                            ((OrderDetails)completeOrder.getOrderDetails().get(offset)).setBackordered(selectedInventoryItem.isOosItem());
                            ((OrderDetails)completeOrder.getOrderDetails().get(offset)).setInhouse(inhouseValue);
                            tableData.setValueAt(String.valueOf(selectedInventoryItem.getItemCost()), rowChanged, this.activeOrdersFormX.getWholesaleCostColumn());
                            tableData.setValueAt(selectedInventoryItem.getItemID(), rowChanged, this.activeOrdersFormX.getItemIDColumn());
                            tableData.setValueAt(selectedInventoryItem.isOosItem(), rowChanged, this.activeOrdersFormX.getBackorderedColumn());
                            Item item = LookupServicesUtil.getDBServices().getItem(selectedInventoryItem.getItemID());
                            if (null != item) {
                                tableData.setValueAt(item.getLocation(), rowChanged, this.activeOrdersFormX.getLocationColumn());
                                tableData.setValueAt(String.valueOf(item.getItemWeight()), rowChanged, this.activeOrdersFormX.getShippingWeightColumn());
                                tableData.setValueAt(String.valueOf(item.getPackedWeight()), rowChanged, this.activeOrdersFormX.getPackedWeightColumn());
                            }
                            selectedInventoryItem.setItemQuantity(selectedInventoryItem.getItemQuantity() - 1);
                            LookupServicesUtil.getDBServices().setInventoryElement(selectedInventoryItem);
                            int quantity = LookupServicesUtil.getDBServices().getItemQuantity(selectedInventoryItem.getItemID(), false);
                            if (LookupServicesUtil.getDBServices().getAccountPreferences().getGenStockNotification() != AccountPreferences.NEVER) {
                                if (quantity <= LookupServicesUtil.getDBServices().getAccountPreferences().getGenStockNotification() && quantity > 0 && LookupServicesUtil.getDBServices().getAccountPreferences().getGenStockNotification() != 0) {
                                    JOptionPane.showMessageDialog((Component)((Object)this), "Item is running low on stock, time to reorder.", "Low Stock Notification", 1);
                                } else if (quantity == 0) {
                                    if (item.isDiscontinued()) {
                                        JOptionPane.showMessageDialog((Component)((Object)this), "Discontinued Item - Last item sold, take auction down.", "Discontinued Notification", 1);
                                    } else {
                                        JOptionPane.showMessageDialog((Component)((Object)this), "This order consumed the last item in stock, time to reorder.", "Out of Stock Notification", 1);
                                    }
                                }
                            }
                        } else {
                            tableData.setValueAt(((OrderDetails)completeOrder.getOrderDetails().get(offset)).isInhouse(), rowChanged, this.activeOrdersFormX.getInhouseColumn());
                        }
                    } else {
                        if (((OrderDetails)completeOrder.getOrderDetails().get(offset)).getEbayWeight() > 0.0f) {
                            tableData.setValueAt(Float.valueOf(((OrderDetails)completeOrder.getOrderDetails().get(offset)).getEbayWeight()), rowChanged, this.activeOrdersFormX.getShippingWeightColumn());
                        }
                        boolean found = false;
                        while (iter.hasNext() && !found) {
                            ArrayList itemList = (ArrayList)iter.next();
                            if (!((InventoryElement)itemList.get(0)).getItemID().toLowerCase().trim().equals(((OrderDetails)completeOrder.getOrderDetails().get(offset)).getItemID())) continue;
                            found = true;
                            ((OrderDetails)completeOrder.getOrderDetails().get(offset)).setInhouse(false);
                            if (((OrderDetails)completeOrder.getOrderDetails().get(offset)).isBackordered()) {
                                ((OrderDetails)completeOrder.getOrderDetails().get(offset)).setBackordered(false);
                                tableData.setValueAt(false, rowChanged, this.activeOrdersFormX.getBackorderedColumn());
                            }
                            if (((InventoryElement)itemList.get(0)).getItemQuantity() < 0) {
                                ((InventoryElement)itemList.get(0)).setItemQuantity(((InventoryElement)itemList.get(0)).getItemQuantity() + 1);
                                LookupServicesUtil.getDBServices().setInventoryElement((InventoryElement)itemList.get(0));
                                if (((OrderDetails)completeOrder.getOrderDetails().get(offset)).isBackordered()) continue;
                                this.manageOOSOrders(completeOrder, offset);
                                continue;
                            }
                            boolean priceMatch = false;
                            for (int i = 1; i < itemList.size(); ++i) {
                                if (((InventoryElement)itemList.get(i)).getItemCost() != ((OrderDetails)completeOrder.getOrderDetails().get(offset)).getItemCost()) continue;
                                priceMatch = true;
                                ((InventoryElement)itemList.get(i)).setItemQuantity(((InventoryElement)itemList.get(i)).getItemQuantity() + 1);
                                LookupServicesUtil.getDBServices().setInventoryElement((InventoryElement)itemList.get(i));
                                break;
                            }
                            if (priceMatch) continue;
                            InventoryElement element = new InventoryElement();
                            element.setItem(((InventoryElement)itemList.get(0)).getItem());
                            element.setItemCost(((OrderDetails)completeOrder.getOrderDetails().get(offset)).getItemCost());
                            element.setItemID(((OrderDetails)completeOrder.getOrderDetails().get(offset)).getItemID());
                            element.setItemQuantity(1);
                            element.setOosItem(false);
                            LookupServicesUtil.getDBServices().setInventoryElement(element);
                        }
                        if (!found && !((OrderDetails)completeOrder.getOrderDetails().get(offset)).isBackordered()) {
                            InventoryElement oosElement = new InventoryElement();
                            InventoryElement element = new InventoryElement();
                            element.setItemCost(((OrderDetails)completeOrder.getOrderDetails().get(offset)).getItemCost());
                            element.setItemID(((OrderDetails)completeOrder.getOrderDetails().get(offset)).getItemID());
                            element.setItemQuantity(1);
                            element.setOosItem(false);
                            oosElement.setItemCost(((OrderDetails)completeOrder.getOrderDetails().get(offset)).getItemCost());
                            oosElement.setItemID(((OrderDetails)completeOrder.getOrderDetails().get(offset)).getItemID());
                            oosElement.setItemQuantity(0);
                            oosElement.setOosItem(true);
                            ArrayList<InventoryElement> elementChain = new ArrayList<InventoryElement>();
                            elementChain.add(oosElement);
                            elementChain.add(element);
                            Item item = LookupServicesUtil.getDBServices().getItem(element.getItemID());
                            if (null == item) {
                                item = new Item();
                                item.setDistributorID(this._distributorStringList.get("XR").getDistributorID());
                                item.setDropShipped(true);
                                item.setItemID(element.getItemID());
                                item.setItemName(((OrderDetails)completeOrder.getOrderDetails().get(offset)).getOrderDescription());
                                item.setDistributorProductID(element.getItemID());
                                LookupServicesUtil.getDBServices().setItem(item);
                            }
                            LookupServicesUtil.getDBServices().setInventoryElementChain(elementChain);
                        }
                    }
                    ListenerManager.getInstance().notify((GenericListener)ListenerManager.INVENTORY_LIST_LISTENER);
                } else if (e.getColumn() == this.activeOrdersFormX.getBackorderedColumn()) {
                    tableData.setValueAt(((OrderDetails)completeOrder.getOrderDetails().get(offset)).isBackordered(), rowChanged, this.activeOrdersFormX.getBackorderedColumn());
                }
            }
            if (e.getColumn() != this.activeOrdersFormX.getCustomerIDColumn() && e.getColumn() != this.activeOrdersFormX.getAccountNameColumn() && e.getColumn() != this.activeOrdersFormX.getEbaySiteColumn()) {
                this.processUpdatedCell(e.getFirstRow(), e.getColumn(), valid);
            }
            if (e.getColumn() == this.activeOrdersFormX.getOrderStatusColumn()) {
                OrderStatus status = this._statusList.get(tableData.getValueAt(rowChanged, this.activeOrdersFormX.getOrderStatusColumn()).toString());
                completeOrder.getOrder().setOrderStatus(status);
                if (status.getOrderStatusID() == this._statusList.get("Complete").getOrderStatusID()) {
                    for (int i = 0; i < completeOrder.getOrderDetails().size(); ++i) {
                        OrderDetails orderDetails = (OrderDetails)completeOrder.getOrderDetails().get(i);
                        if (orderDetails.getShipDate() != null) continue;
                        orderDetails.setShipDate(new java.sql.Date(System.currentTimeMillis()));
                        tableData.setValueAt(orderDetails.getShipDate().toString(), completeOrder.getRowStart() + i, this.activeOrdersFormX.getShipDateColumn());
                    }
                } else if (status.getOrderStatusID() == this._statusList.get("New").getOrderStatusID()) {
                    completeOrder.getOrder().setOrderStatus(this._statusList.get("Pending"));
                    tableData.setValueAt("Pending", rowChanged, this.activeOrdersFormX.getOrderStatusColumn());
                }
            } else {
                OrderStatus status = this._statusList.get(tableData.getValueAt(completeOrder.getRowStart(), this.activeOrdersFormX.getOrderStatusColumn()).toString());
                if (status.getOrderStatusID() == this._statusList.get("New").getOrderStatusID()) {
                    completeOrder.getOrder().setOrderStatus(this._statusList.get("Pending"));
                    tableData.setValueAt("Pending", completeOrder.getRowStart(), this.activeOrdersFormX.getOrderStatusColumn());
                }
            }
            this.disableListener(false);
            this.updateAdditionalDetails();
            this.updateNeeded(true);
        }
    }

    private void processUpdatedCell(int row, int column, boolean valid) {
        if (valid) {
            this._validCellChanges.put(this.getUpdatedCellKey(row, column), new ChangedCell(row, column));
            this._invalidCellChanges.remove(this.getUpdatedCellKey(row, column));
        } else {
            this._invalidCellChanges.put(this.getUpdatedCellKey(row, column), new ChangedCell(row, column));
            this._validCellChanges.remove(this.getUpdatedCellKey(row, column));
        }
    }

    private void performSearch() {
        this.disableListener(true);
        this._statusFilters.clear();
        this.orderCommentsTextArea.setText("");
        this.customerCommentsTextArea.setText("");
        this.newFilterCheckBox.setSelected(false);
        this.npbFilterCheckBox.setSelected(false);
        this.oosFilterCheckBox.setSelected(false);
        this.pendingFilterCheckBox.setSelected(false);
        this.pendingECheckCheckBox.setSelected(false);
        this.pendingMOCheckBox.setSelected(false);
        this.exportLabelsCheckBox.setSelected(false);
        this.pendingPrintCheckBox.setSelected(false);
        this.pendingTrackingCheckBox.setSelected(false);
        if (this.multiOrderCheckBox.isSelected()) {
            this.sortComboBox.setSelectedItem("Order Date");
        }
        this.multiOrderCheckBox.setSelected(false);
        this.adminHoldCheckBox.setSelected(false);
        this.NIACheckbox.setSelected(false);
        this.OCCheckbox.setSelected(false);
        this.newFilterCheckBox.setEnabled(true);
        this.pendingFilterCheckBox.setEnabled(true);
        this.oosFilterCheckBox.setEnabled(true);
        this.npbFilterCheckBox.setEnabled(true);
        this.pendingPrintCheckBox.setEnabled(true);
        this.pendingECheckCheckBox.setEnabled(true);
        this.pendingMOCheckBox.setEnabled(true);
        this.exportLabelsCheckBox.setEnabled(true);
        this.multiOrderCheckBox.setEnabled(true);
        this.adminHoldCheckBox.setEnabled(true);
        this.pendingTrackingCheckBox.setEnabled(true);
        this.NIACheckbox.setEnabled(true);
        this.OCCheckbox.setEnabled(true);
        long searchFrom = 0L;
        long searchTo = 0L;
        ArrayList<OrderStatus> searchFilters = new ArrayList<OrderStatus>();
        if (null != this.fromDateChooser.getDate()) {
            searchFrom = this.fromDateChooser.getDate().getTime();
        }
        if (null != this.toDateChooser.getDate()) {
            searchTo = this.toDateChooser.getDate().getTime();
        }
        if (this.newSearchFilterCheckBox.isSelected()) {
            searchFilters.add(this._statusList.get("New"));
        }
        if (this.npbSearchFilterCheckBox.isSelected()) {
            searchFilters.add(this._statusList.get("NPB"));
        }
        if (this.oosSearchFilterCheckBox.isSelected()) {
            searchFilters.add(this._statusList.get("OOS"));
        }
        if (this.pendingECheckSearchFilterCheckBox.isSelected()) {
            searchFilters.add(this._statusList.get("Pending E-Check"));
        }
        if (this.pendingMOSearchFilterCheckBox.isSelected()) {
            searchFilters.add(this._statusList.get("Pending MO"));
        }
        if (this.pendingSearchFilterCheckBox.isSelected()) {
            searchFilters.add(this._statusList.get("Pending"));
        }
        if (this.pendingPrintSearchFilterCheckBox.isSelected()) {
            searchFilters.add(this._statusList.get("Pending Print"));
        }
        if (this.completeSearchFilterCheckBox.isSelected()) {
            searchFilters.add(this._statusList.get("Complete"));
        }
        if (this.canceledSearchFilterCheckBox.isSelected()) {
            searchFilters.add(this._statusList.get("Canceled"));
        }
        if (this.adminHoldSearchFilterCheckBox.isSelected()) {
            searchFilters.add(this._statusList.get("Admin Hold"));
        }
        if (this.exportLabelsSearchFilterCheckBox.isSelected()) {
            searchFilters.add(this._statusList.get("Export Labels"));
        }
        LookupServicesUtil.getDBServices().searchOrders(this.sanitize(this.searchField.getText()), searchFilters.toArray(new OrderStatus[0]), searchFrom, searchTo, (String)this.numResults.getSelectedItem());
    }

    public String getUpdatedCellKey(int row, int column) {
        return "Row" + row + "Column" + column;
    }

    public ChangedCell checkValidCell(int row, int column) {
        return this._validCellChanges.get(this.getUpdatedCellKey(row, column));
    }

    public ChangedCell checkInvalidCell(int row, int column) {
        return this._invalidCellChanges.get(this.getUpdatedCellKey(row, column));
    }

    public String sanitize(String uncleanString) {
        String sanitizedString;
        if (null != uncleanString) {
            sanitizedString = uncleanString.replace("'", "");
            sanitizedString = sanitizedString.replace("\"", "");
            sanitizedString = sanitizedString.replace("--", "");
            sanitizedString = sanitizedString.trim().toUpperCase();
        } else {
            sanitizedString = "";
        }
        return sanitizedString;
    }

    private void updateNeeded(boolean dataChanged) {
        this._dataChanged = dataChanged;
        if (dataChanged) {
            this.startupLabel.setText("Data has been updated;");
            this.applyChangesLabel.setText("apply changes when finished.");
        }
        this.unMergeButton.setEnabled(!dataChanged);
        this.mergeButton.setEnabled(!dataChanged);
        this.deleteButton.setEnabled(!dataChanged);
        this.createInvoiceButton.setEnabled(!dataChanged);
        ListenerManager.getInstance().notify((GenericListener)ListenerManager.EBAY_ACCOUNT_LISTENER);
        if (SubscriptionManager.getInstance().isCurrent() && !SubscriptionManager.getInstance().getEbayAccounts().isEmpty()) {
            this.refreshListButton.setEnabled(!dataChanged);
        }
        boolean checkBoxStatus = !dataChanged && !this.multiOrderCheckBox.isSelected() && !this.pendingTrackingCheckBox.isSelected();
        this.exportLabelsButton.setEnabled(!dataChanged);
        this.pendingPrintCheckBox.setEnabled(checkBoxStatus);
        this.pendingMOCheckBox.setEnabled(checkBoxStatus);
        this.pendingECheckCheckBox.setEnabled(checkBoxStatus);
        this.exportLabelsCheckBox.setEnabled(checkBoxStatus);
        this.oosFilterCheckBox.setEnabled(checkBoxStatus);
        this.npbFilterCheckBox.setEnabled(checkBoxStatus);
        this.pendingFilterCheckBox.setEnabled(checkBoxStatus);
        this.newFilterCheckBox.setEnabled(checkBoxStatus);
        this.adminHoldCheckBox.setEnabled(checkBoxStatus);
        this.pendingTrackingCheckBox.setEnabled(!dataChanged && !this.multiOrderCheckBox.isSelected());
        this.multiOrderCheckBox.setEnabled(!dataChanged && !this.pendingTrackingCheckBox.isSelected());
        this.NIACheckbox.setEnabled(checkBoxStatus);
        this.OCCheckbox.setEnabled(checkBoxStatus);
        this.searchButton.setEnabled(!dataChanged);
        this.sortComboBox.setEnabled(!dataChanged);
        this.applyChangesButton.setEnabled(dataChanged);
        this.orderSplitButton.setEnabled(!dataChanged);
        this.createRMAButton.setEnabled(!dataChanged);
        if (this.multiOrderCheckBox.isSelected()) {
            // empty if block
        }
    }

    private void updateFees(int orderID) {
        this.orderCommentsTextArea.setEnabled(true);
        this.customerCommentsTextArea.setEnabled(true);
        float feeTotal = 0.0f;
        float paypalfeeTotal = 0.0f;
        float adjustedTotal = 0.0f;
        float wholesaleCost = 0.0f;
        boolean international = false;
        boolean flag = false;
        int numOrders = 0;
        ArrayList orderDetails = this._completeOrders.get(orderID).getOrderDetails();
        numOrders = orderDetails.size();
        String customerName = this._completeOrders.get(orderID).getOrder().getCustomer().getCustomerName();
        String orderNumber = ((OrderDetails)orderDetails.get(0)).getOrderNumber();
        if (customerName.isEmpty()) {
            customerName = "InvalidName";
        }
        this.orderAmount.setText(String.valueOf(numOrders));
        for (OrderDetails orderDetail : orderDetails) {
            wholesaleCost += orderDetail.getItemCost();
        }
        this.wholesaleCostLabel.setText(String.valueOf(NumberFormat.getCurrencyInstance().format(wholesaleCost)));
        if (!(this._completeOrders.get(orderID).getOrder().getCustomer().getCustomerCountry().toLowerCase().equals("united states") || this._completeOrders.get(orderID).getOrder().getCustomer().getCustomerCountry().toLowerCase().equals("usa") || this._completeOrders.get(orderID).getOrder().getCustomer().getCustomerCountry().toLowerCase().equals("us"))) {
            international = true;
        }
        paypalfeeTotal = FeeProcessor.getPayPalFees((float)this._completeOrders.get(orderID).getOrder().getOrderTotal(), (float)this._completeOrders.get(orderID).getOrder().getShippingPaid(), (boolean)international);
        adjustedTotal = this._completeOrders.get(orderID).getOrder().getOrderTotal() - paypalfeeTotal + this._completeOrders.get(orderID).getOrder().getShippingPaid() - this._completeOrders.get(orderID).getOrder().getShippingCost() - wholesaleCost;
        if (adjustedTotal < 0.0f) {
            flag = true;
        }
        this.paypalFeeLabel.setText(String.valueOf(NumberFormat.getCurrencyInstance().format(paypalfeeTotal)));
        this.shippingCostLabel.setText(String.valueOf(NumberFormat.getCurrencyInstance().format(this._completeOrders.get(orderID).getOrder().getShippingCost())));
        this.subtotalLabel.setText(String.valueOf(NumberFormat.getCurrencyInstance().format(adjustedTotal)));
        this.totalLabel.setText(String.valueOf(NumberFormat.getCurrencyInstance().format((double)this._completeOrders.get(orderID).getOrder().getOrderTotal() + (double)this._completeOrders.get(orderID).getOrder().getShippingPaid())));
        for (int i = 0; i < this._customFeeMapping.size(); ++i) {
            feeTotal = (this._completeOrders.get(orderID).getOrder().getOrderTotal() + this._completeOrders.get(orderID).getOrder().getShippingPaid()) * (float)this._customFeeMapping.get(i).getFeePercentage() + (float)this._customFeeMapping.get(i).getFeeFlatCost();
            adjustedTotal = this._completeOrders.get(orderID).getOrder().getOrderTotal() - feeTotal - paypalfeeTotal + this._completeOrders.get(orderID).getOrder().getShippingPaid() - this._completeOrders.get(orderID).getOrder().getShippingCost() - wholesaleCost;
            if (adjustedTotal < 0.0f) {
                flag = true;
            }
            this.customFeeTable.setValueAt(NumberFormat.getCurrencyInstance().format(feeTotal), i, 1);
            this.customFeeTable.setValueAt(NumberFormat.getCurrencyInstance().format(adjustedTotal), i, 2);
        }
        if (flag) {
            this._negativeProfit.put(orderNumber, customerName);
        } else if (this._negativeProfit.containsKey(orderNumber)) {
            this._negativeProfit.remove(orderNumber);
        }
    }

    private void manageOOSOrders(CompleteOrder completeOrder, int offset) {
        OrderDetails orderDetails = (OrderDetails)completeOrder.getOrderDetails().get(offset);
        for (OrderDetails detail : LookupServicesUtil.getDBServices().getOosOrderDetails()) {
            if (!detail.getItemID().equalsIgnoreCase(orderDetails.getItemID())) continue;
            detail.setBackordered(false);
            LookupServicesUtil.getDBServices().updateOosOrder(detail);
            break;
        }
    }

    private void updateCustomerCommentBox() {
        block13: {
            if (-1 != this._currentRow) {
                try {
                    CompleteOrder completeOrder = this._completeOrders.get(this._orderMapping.get(this._currentRow));
                    if (null == this.customerCommentsTextArea.getText()) break block13;
                    if (null != completeOrder.getOrder().getCustomer().getCustomerComments()) {
                        if (!this.customerCommentsTextArea.getText().equals(completeOrder.getOrder().getCustomer().getCustomerComments())) {
                            completeOrder.getOrder().getCustomer().setCustomerComments(this.customerCommentsTextArea.getText());
                            this._updatedOrders.put(this._orderMapping.get(this._currentRow), this._orderMapping.get(this._currentRow));
                            this.updateNeeded(true);
                        }
                        break block13;
                    }
                    completeOrder.getOrder().getCustomer().setCustomerComments(this.customerCommentsTextArea.getText());
                    this._updatedOrders.put(this._orderMapping.get(this._currentRow), this._orderMapping.get(this._currentRow));
                    this.updateNeeded(true);
                }
                catch (Exception ex) {
                    ErrorsUtil.getInstance().logError(ex);
                }
            } else if (this.activeOrdersFormX.getOrderDetails().getSelectedRow() != -1) {
                this._currentRow = this.activeOrdersFormX.getOrderDetails().getSelectedRow();
                try {
                    CompleteOrder completeOrder = this._completeOrders.get(this._orderMapping.get(this._currentRow));
                    if (null != this.customerCommentsTextArea.getText()) {
                        if (null != completeOrder.getOrder().getCustomer().getCustomerComments()) {
                            if (!this.customerCommentsTextArea.getText().equals(completeOrder.getOrder().getCustomer().getCustomerComments())) {
                                completeOrder.getOrder().getCustomer().setCustomerComments(this.customerCommentsTextArea.getText());
                                this._updatedOrders.put(this._orderMapping.get(this._currentRow), this._orderMapping.get(this._currentRow));
                                this.updateNeeded(true);
                            }
                        } else {
                            completeOrder.getOrder().getCustomer().setCustomerComments(this.customerCommentsTextArea.getText());
                            this._updatedOrders.put(this._orderMapping.get(this._currentRow), this._orderMapping.get(this._currentRow));
                            this.updateNeeded(true);
                        }
                    }
                }
                catch (Exception ex) {
                    ErrorsUtil.getInstance().logError(ex);
                }
            }
        }
        this._customerCommentBoxUpdated = false;
    }

    public void websiteListUpdated() {
        this._websiteList.clear();
        Website[] websites = LookupServicesUtil.getDBServices().getWebsites();
        for (int i = 0; i < websites.length; ++i) {
            this._websiteList.put(websites[i].getWebsiteName(), websites[i]);
        }
    }

    public void eBayAccountChange() {
        if (SubscriptionManager.getInstance().isCurrent() && !SubscriptionManager.getInstance().getEbayAccounts().isEmpty()) {
            this.refreshListButton.setEnabled(true);
            this.updateTrackingButton.setEnabled(this.trackingIdTextField.getText() != null && !this.trackingIdTextField.getText().isEmpty());
        } else {
            this.refreshListButton.setEnabled(false);
            this.updateTrackingButton.setEnabled(false);
        }
    }

    public void programClosed() {
        Collection currentInventory = LookupServicesUtil.getDBServices().getInventoryList("", false, false, false, new String[0], false);
        HashMap<String, ArrayList> currentInventoryMap = new HashMap<String, ArrayList>();
        for (ArrayList inventoryElement : currentInventory) {
            currentInventoryMap.put(((InventoryElement)inventoryElement.get(0)).getItemID(), inventoryElement);
        }
        Integer[] arr$ = this._updatedOrders.keySet().toArray(new Integer[0]);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int i;
            int orderID = arr$[i$];
            ArrayList baseOrders = ((CompleteOrder)LookupServicesUtil.getDBServices().getOrderList(true).get(orderID)).getOrderDetails();
            ArrayList changedOrders = this._completeOrders.get(orderID).getOrderDetails();
            HashMap baseOrderMapping = new HashMap();
            for (i = 0; i < baseOrders.size(); ++i) {
                baseOrderMapping.put(((OrderDetails)baseOrders.get(i)).getOrderDetailsID(), baseOrders.get(i));
            }
            for (i = 0; i < changedOrders.size(); ++i) {
                ArrayList inventoryItem;
                if (!baseOrderMapping.containsKey(((OrderDetails)changedOrders.get(i)).getOrderDetailsID()) || ((OrderDetails)baseOrderMapping.get(((OrderDetails)changedOrders.get(i)).getOrderDetailsID())).isInhouse() == ((OrderDetails)changedOrders.get(i)).isInhouse() || (inventoryItem = (ArrayList)currentInventoryMap.get(((OrderDetails)changedOrders.get(i)).getItemID())) == null) continue;
                if (((OrderDetails)changedOrders.get(i)).isInhouse() && ((OrderDetails)changedOrders.get(i)).isBackordered()) {
                    ((InventoryElement)inventoryItem.get(0)).setItemQuantity(((InventoryElement)inventoryItem.get(0)).getItemQuantity() + 1);
                    continue;
                }
                if (!((OrderDetails)changedOrders.get(i)).isInhouse()) {
                    boolean found = false;
                    Iterator itemIter = inventoryItem.iterator();
                    if (itemIter.hasNext()) {
                        itemIter.next();
                    }
                    while (itemIter.hasNext() && !found) {
                        InventoryElement element = (InventoryElement)itemIter.next();
                        if (element.getItemCost() != ((OrderDetails)baseOrderMapping.get(((OrderDetails)changedOrders.get(i)).getOrderDetailsID())).getItemCost()) continue;
                        element.setItemQuantity(element.getItemQuantity() - 1);
                        LookupServicesUtil.getDBServices().setInventoryElement(element);
                        ListenerManager.getInstance().notify((GenericListener)ListenerManager.INVENTORY_LIST_LISTENER);
                        found = true;
                    }
                    continue;
                }
                boolean priceMatch = false;
                for (int j = 1; j < inventoryItem.size(); ++j) {
                    if (((InventoryElement)inventoryItem.get(j)).getItemCost() != ((OrderDetails)changedOrders.get(i)).getItemCost()) continue;
                    priceMatch = true;
                    ((InventoryElement)inventoryItem.get(j)).setItemQuantity(((InventoryElement)inventoryItem.get(j)).getItemQuantity() + 1);
                    LookupServicesUtil.getDBServices().setInventoryElement((InventoryElement)inventoryItem.get(j));
                    ListenerManager.getInstance().notify((GenericListener)ListenerManager.INVENTORY_LIST_LISTENER);
                    break;
                }
                if (priceMatch) continue;
                InventoryElement element = new InventoryElement();
                element.setItemID(((OrderDetails)changedOrders.get(i)).getItemID());
                element.setItemCost(((OrderDetails)changedOrders.get(i)).getItemCost());
                element.setItemQuantity(1);
                element.setOosItem(false);
                LookupServicesUtil.getDBServices().setInventoryElement(element);
                ListenerManager.getInstance().notify((GenericListener)ListenerManager.INVENTORY_LIST_LISTENER);
            }
        }
        this._updatedOrders.clear();
        this._validCellChanges.clear();
        this._currentRow = -1;
        this.updateNeeded(false);
        ListenerManager.getInstance().notify((GenericListener)ListenerManager.TRANSACTION_LISTENER);
    }

    public void updateStatus() {
        if (LookupServicesUtil.getEbayServices().updatePending()) {
            String systemTime;
            if (!this.startupLabel.getText().equalsIgnoreCase("Updating... May take a while.") && null != (systemTime = LookupServicesUtil.getEbayServices().getCurrentTime()) && !systemTime.equals("UNKNOWN")) {
                this.timeStampLabel.setText(systemTime);
                this.startupLabel.setText("Updating... May take a while.");
                this.refreshProgressBar.setVisible(true);
                this.refreshProgressBar.setValue((int)LookupServicesUtil.getEbayServices().getUpdatePercentage());
                this.refreshProgressBar.setStringPainted(true);
                this.startupLabel.paintImmediately(this.startupLabel.getVisibleRect());
                this.updateDateRange();
            }
            this.refreshProgressBar.setValue((int)LookupServicesUtil.getEbayServices().getUpdatePercentage());
        } else {
            this.startupLabel.setText("Refreshing Complete.");
            this.refreshProgressBar.setValue(100);
            this.refreshProgressBar.setVisible(false);
        }
    }

    public void updateProgress() {
        if (LookupServicesUtil.getInvoiceGeneratorServices().updatePending()) {
            this.refreshProgressBar.setValue(LookupServicesUtil.getInvoiceGeneratorServices().getUpdatePercentage());
        } else {
            this.startupLabel.setText("Invoice Generation Complete.");
            this.refreshProgressBar.setValue(100);
            this.refreshProgressBar.setVisible(false);
        }
    }

    public void customFeeListUpdated() {
        DefaultTableModel tableModel = (DefaultTableModel)this.customFeeTable.getModel();
        this._customFeeMapping.clear();
        tableModel.setNumRows(0);
        this._customFeeMapping = LookupServicesUtil.getDBServices().getCustomFeeList();
        for (CustomFee customFee : this._customFeeMapping) {
            try {
                Object[] row = new Object[tableModel.getColumnCount()];
                row[0] = customFee.getFeeName();
                row[1] = "$0.00";
                row[2] = "$0.00";
                tableModel.addRow(row);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        this.updateAdditionalDetails();
    }

    private void cleanupView() {
        this._updatedOrders.clear();
        this._validCellChanges.clear();
        this._currentRow = -1;
        this._negativeProfit.clear();
        this.orderCommentsTextArea.setText("");
        this.orderCommentsTextArea.setEnabled(false);
        this.customerCommentsTextArea.setText("");
        this.customerCommentsTextArea.setEnabled(false);
        this.wholesaleCostLabel.setText("$0.00");
        this.shippingCostLabel.setText("$0.00");
        this.paypalFeeLabel.setText("$0.00");
        this.totalLabel.setText("$0.00");
        this.subtotalLabel.setText("$0.00");
        for (int i = 0; i < this._customFeeMapping.size(); ++i) {
            this.customFeeTable.setValueAt("$0.00", i, 1);
            this.customFeeTable.setValueAt("$0.00", i, 2);
        }
        this.trackingIdTextField.setText("");
        this.trackingCarrierTypeBox.setSelectedItem("USPS");
        this.totalWeightField.setText("0.0");
        this.inhouseWeightField.setText("0.0");
        this.shippingMethodTextField.setText("");
        this.usernameLabel.setText("");
        this.orderAmount.setText("0");
    }

    public void LoginToggle() {
        if (SubscriptionManager.getInstance().isCurrent() && !SubscriptionManager.getInstance().getEbayAccounts().isEmpty()) {
            if (!this.currentStatus) {
                this.currentStatus = true;
                this.enableAll();
            }
        } else if (this.currentStatus) {
            this.currentStatus = false;
            this.disableAll();
        }
    }

    private void disablePanel(JPanel jPanel) {
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            jPanel.getComponent(i).setEnabled(false);
        }
    }

    private void enablePanel(JPanel jPanel) {
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            jPanel.getComponent(i).setEnabled(true);
        }
    }

    private void enableAll() {
        this.updateTrackingButton.setEnabled(this.trackingIdTextField.getText() != null && !this.trackingIdTextField.getText().isEmpty() && SubscriptionManager.getInstance().isCurrent() && !SubscriptionManager.getInstance().getEbayAccounts().isEmpty());
        this.refreshListButton.setEnabled(true);
    }

    public void disableAll() {
        this.updateTrackingButton.setEnabled(false);
        this.refreshListButton.setEnabled(false);
    }

    public class ExportService {
        public void init() {
            try {
                ArrayList statusFilters = new ArrayList();
                statusFilters.add(OrderManagerTopComponent.this._statusList.get("Export Labels"));
                LookupServicesUtil.getDBServices().setOrderFilters(OrderManagerTopComponent.this.getFilters(statusFilters));
                ArrayList orders = new ArrayList(LookupServicesUtil.getDBServices().getOrderList(false).values());
                Collections.sort(orders, new CompleteOrderComparator(CompleteOrderComparator.CUSTOMER_NAME));
                if (orders.size() > 0) {
                    OrderManagerTopComponent.this._exportLocation.setDialogTitle("Save Export List As");
                    int returnVal = OrderManagerTopComponent.this._exportLocation.showSaveDialog(null);
                    if (returnVal == 0) {
                        OrderManagerTopComponent.this.startupLabel.setText("Exporting Orders...");
                        OrderManagerTopComponent.this.refreshProgressBar.setVisible(true);
                        OrderManagerTopComponent.this.refreshProgressBar.setValue(0);
                        OrderManagerTopComponent.this.refreshProgressBar.setStringPainted(true);
                        String filename = OrderManagerTopComponent.this._exportLocation.getSelectedFile().getPath().trim();
                        if (!filename.toLowerCase().endsWith("txt")) {
                            filename = filename.concat(".txt");
                        }
                        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(filename));
                        String outputString = "Location\tItem ID\tItem Name\tCustomerName\tState\tComments";
                        bufferedWriter.write(outputString);
                        bufferedWriter.newLine();
                        boolean validEntry = false;
                        int itemNumber = 0;
                        ArrayList<CompleteOrder> invoiceList = new ArrayList<CompleteOrder>();
                        for (CompleteOrder completeOrder : orders) {
                            invoiceList.add(completeOrder);
                            for (OrderDetails details : completeOrder.getOrderDetails()) {
                                outputString = this.doOutput(validEntry, details, completeOrder.getOrder());
                                bufferedWriter.write(outputString);
                                bufferedWriter.newLine();
                                validEntry = true;
                            }
                            if (validEntry) {
                                for (OrderDetails detail : completeOrder.getOrderDetails()) {
                                    detail.setShipDate(new java.sql.Date(System.currentTimeMillis()));
                                }
                                completeOrder.getOrder().setOrderStatus((OrderStatus)OrderManagerTopComponent.this._statusList.get("Complete"));
                                float progress = (float)(++itemNumber) / (float)orders.size() * 100.0f;
                                OrderManagerTopComponent.this.refreshProgressBar.setValue((int)progress);
                                LookupServicesUtil.getDBServices().updateOrder(completeOrder);
                            }
                            validEntry = false;
                        }
                        bufferedWriter.close();
                        int result = JOptionPane.showConfirmDialog(null, "Exporting order list complete, would you also like to generate invoices?", "Generate Invoices", 0);
                        if (result == 0) {
                            OrderManagerTopComponent.this._invoiceLocation.setDialogTitle("Save Invoice(s) As");
                            returnVal = OrderManagerTopComponent.this._invoiceLocation.showSaveDialog(null);
                            if (returnVal == 0) {
                                OrderManagerTopComponent.this.startupLabel.setText("Generating Invoices...");
                                OrderManagerTopComponent.this.refreshProgressBar.setVisible(true);
                                OrderManagerTopComponent.this.refreshProgressBar.setValue(0);
                                OrderManagerTopComponent.this.refreshProgressBar.setStringPainted(true);
                                filename = OrderManagerTopComponent.this._invoiceLocation.getSelectedFile().getPath().trim();
                                if (!filename.toLowerCase().endsWith("pdf")) {
                                    filename = filename.concat(".pdf");
                                }
                                LookupServicesUtil.getInvoiceGeneratorServices().generateInvoices(invoiceList, filename);
                            }
                        }
                    }
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
            OrderManagerTopComponent.this.disableListener(false);
            OrderManagerTopComponent.this.updateNeeded(false);
            OrderManagerTopComponent.this.refreshProgressBar.setVisible(false);
            OrderManagerTopComponent.this.clearChangesButton.setEnabled(true);
            OrderManagerTopComponent.this.exportingOrders = false;
            OrderManagerTopComponent.this.activeOrdersFormX.getOrderDetails().setEnabled(true);
            ListenerManager.getInstance().notify((GenericListener)ListenerManager.TRANSACTION_LISTENER);
        }

        private String doOutput(boolean isValid, OrderDetails details, Order order) {
            Item item = LookupServicesUtil.getDBServices().getItem(details.getItemID());
            String outputString = item != null ? String.valueOf(item.getLocation()) + "\t" : "\t";
            if (!isValid) {
                outputString = outputString + details.getItemID() + "\t";
                outputString = outputString + details.getOrderDescription() + "\t";
                outputString = outputString + order.getCustomer().getCustomerName() + "\t";
                outputString = outputString + order.getCustomer().getCustomerState() + "\t";
                String[] comments = order.getOrderComments().replaceAll("\r", "-").replaceAll("\n", " ").split("TRANSACTION");
                outputString = outputString + comments[0];
            } else {
                outputString = outputString + details.getItemID() + "\t";
                outputString = outputString + details.getOrderDescription() + "\t\t\t";
            }
            return outputString;
        }
    }

    public class ChangedCell {
        private int row;
        private int column;

        public ChangedCell(int row, int column) {
            this.row = row;
            this.column = column;
        }

        public int getColumn() {
            return this.column;
        }

        public void setColumn(int column) {
            this.column = column;
        }

        public int getRow() {
            return this.row;
        }

        public void setRow(int row) {
            this.row = row;
        }
    }
}

