/*
 * Decompiled with CFR 0.152.
 */
package pnp.managers.ordermanager;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.openide.util.NbBundle;
import pnp.services.constants.FrameConstants;
import pnp.services.datatypes.CustomFee;
import pnp.services.util.LookupServicesUtil;
import pnp.services.util.MathParser;

public class UpdateCustomFeeListForm
extends JDialog {
    private JButton clearButton;
    private JButton deleteItemButton;
    private JList feeList;
    private JTextField feePercentageField;
    private JTextField flatFeeField;
    private JLabel jLabel10;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JTextField siteNameField;
    private JButton submitItemButton;
    private HashMap<String, CustomFee> _customFeeMap;

    public UpdateCustomFeeListForm(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.init();
    }

    private void init() {
        this._customFeeMap = new HashMap();
        this.siteNameField.setDocument(new JTextFieldLimit(32));
        this.updateFeeList();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel9 = new JPanel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.siteNameField = new JTextField();
        this.submitItemButton = new JButton();
        this.feePercentageField = new JTextField();
        this.flatFeeField = new JTextField();
        this.jLabel16 = new JLabel();
        this.jLabel17 = new JLabel();
        this.deleteItemButton = new JButton();
        this.clearButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.feeList = new JList(new DefaultListModel());
        this.setDefaultCloseOperation(2);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(UpdateCustomFeeListForm.class, (String)"UpdateCustomFeeListForm.jPanel1.border.title")));
        this.jPanel9.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(UpdateCustomFeeListForm.class, (String)"UpdateCustomFeeListForm.jPanel9.border.title")));
        this.jLabel8.setText(NbBundle.getMessage(UpdateCustomFeeListForm.class, (String)"UpdateCustomFeeListForm.jLabel8.text"));
        this.jLabel9.setText(NbBundle.getMessage(UpdateCustomFeeListForm.class, (String)"UpdateCustomFeeListForm.jLabel9.text"));
        this.jLabel10.setText(NbBundle.getMessage(UpdateCustomFeeListForm.class, (String)"UpdateCustomFeeListForm.jLabel10.text"));
        this.siteNameField.setText(NbBundle.getMessage(UpdateCustomFeeListForm.class, (String)"UpdateCustomFeeListForm.siteNameField.text"));
        this.siteNameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                UpdateCustomFeeListForm.this.siteNameFieldKeyReleased(evt);
            }
        });
        this.submitItemButton.setText(NbBundle.getMessage(UpdateCustomFeeListForm.class, (String)"UpdateCustomFeeListForm.submitItemButton.text"));
        this.submitItemButton.setEnabled(false);
        this.submitItemButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateCustomFeeListForm.this.submitItemButtonActionPerformed(evt);
            }
        });
        this.feePercentageField.setText(NbBundle.getMessage(UpdateCustomFeeListForm.class, (String)"UpdateCustomFeeListForm.feePercentageField.text"));
        this.feePercentageField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                UpdateCustomFeeListForm.this.feePercentageFieldFocusLost(evt);
            }
        });
        this.feePercentageField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                UpdateCustomFeeListForm.this.feePercentageFieldKeyReleased(evt);
            }
        });
        this.flatFeeField.setText(NbBundle.getMessage(UpdateCustomFeeListForm.class, (String)"UpdateCustomFeeListForm.flatFeeField.text"));
        this.flatFeeField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                UpdateCustomFeeListForm.this.flatFeeFieldFocusLost(evt);
            }
        });
        this.flatFeeField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                UpdateCustomFeeListForm.this.flatFeeFieldKeyReleased(evt);
            }
        });
        this.jLabel16.setText(NbBundle.getMessage(UpdateCustomFeeListForm.class, (String)"UpdateCustomFeeListForm.jLabel16.text"));
        this.jLabel17.setText(NbBundle.getMessage(UpdateCustomFeeListForm.class, (String)"UpdateCustomFeeListForm.jLabel17.text"));
        this.deleteItemButton.setText(NbBundle.getMessage(UpdateCustomFeeListForm.class, (String)"UpdateCustomFeeListForm.deleteItemButton.text"));
        this.deleteItemButton.setEnabled(false);
        this.deleteItemButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateCustomFeeListForm.this.deleteItemButtonActionPerformed(evt);
            }
        });
        this.clearButton.setText(NbBundle.getMessage(UpdateCustomFeeListForm.class, (String)"UpdateCustomFeeListForm.clearButton.text"));
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateCustomFeeListForm.this.clearButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel9Layout = new GroupLayout(this.jPanel9);
        this.jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addContainerGap().addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.siteNameField, -2, 116, -2)).addGroup(jPanel9Layout.createSequentialGroup().addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.feePercentageField, -2, 71, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel17)).addGroup(jPanel9Layout.createSequentialGroup().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.flatFeeField, -2, 71, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel16))).addContainerGap()).addGroup(jPanel9Layout.createSequentialGroup().addComponent(this.deleteItemButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 69, Short.MAX_VALUE).addComponent(this.clearButton, -2, 73, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.submitItemButton).addGap(4, 4, 4)))));
        jPanel9Layout.linkSize(0, this.jLabel10, this.jLabel8, this.jLabel9);
        jPanel9Layout.setVerticalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.siteNameField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.feePercentageField, -2, -1, -2).addComponent(this.jLabel17)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.flatFeeField, -2, -1, -2).addComponent(this.jLabel16)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 88, Short.MAX_VALUE).addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.deleteItemButton).addComponent(this.submitItemButton).addComponent(this.clearButton)).addContainerGap()));
        this.feeList.setSelectionMode(0);
        this.feeList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                UpdateCustomFeeListForm.this.feeListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.feeList);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 157, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel9, -1, -1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel9, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void siteNameFieldKeyReleased(KeyEvent evt) {
        this.verifyFee();
    }

    private void submitItemButtonActionPerformed(ActionEvent evt) {
        if (null != this.feeList.getSelectedValue()) {
            String feeName = (String)this.feeList.getSelectedValue();
            CustomFee fee = this._customFeeMap.get(feeName);
            fee.setFeeName(this.siteNameField.getText().trim());
            if (this.flatFeeField.getText().trim().isEmpty()) {
                fee.setFeeFlatCost(0.0);
            } else {
                fee.setFeeFlatCost(Double.valueOf(this.flatFeeField.getText()).doubleValue());
            }
            if (this.feePercentageField.getText().trim().isEmpty()) {
                fee.setFeePercentage(0.0);
            } else {
                fee.setFeePercentage(Double.valueOf(this.feePercentageField.getText().trim()) / 100.0);
            }
            LookupServicesUtil.getDBServices().updateCustomFee(fee);
        } else {
            CustomFee fee = new CustomFee();
            fee.setFeeName(this.siteNameField.getText().trim());
            if (this.flatFeeField.getText().trim().isEmpty()) {
                fee.setFeeFlatCost(0.0);
            } else {
                fee.setFeeFlatCost(Double.valueOf(this.flatFeeField.getText()).doubleValue());
            }
            if (this.feePercentageField.getText().trim().isEmpty()) {
                fee.setFeePercentage(0.0);
            } else {
                fee.setFeePercentage(Double.valueOf(this.feePercentageField.getText().trim()) / 100.0);
            }
            boolean valid = true;
            for (int i = 0; i < this.feeList.getModel().getSize(); ++i) {
                if (!this.feeList.getModel().getElementAt(i).toString().equals(fee.getFeeName())) continue;
                valid = false;
            }
            if (valid) {
                LookupServicesUtil.getDBServices().updateCustomFee(fee);
            } else {
                JOptionPane.showMessageDialog(null, "Duplicate fees not allowed, please edit original fee.");
            }
        }
        this.clearButtonActionPerformed(null);
        this.updateFeeList();
    }

    private void feePercentageFieldKeyReleased(KeyEvent evt) {
        this.verifyFee();
    }

    private void flatFeeFieldKeyReleased(KeyEvent evt) {
        this.verifyFee();
    }

    private void deleteItemButtonActionPerformed(ActionEvent evt) {
        if (null != this.feeList.getSelectedValue()) {
            String feeName = (String)this.feeList.getSelectedValue();
            CustomFee fee = this._customFeeMap.get(feeName);
            LookupServicesUtil.getDBServices().removeCustomFee(fee);
        }
        this.clearButtonActionPerformed(null);
        this.updateFeeList();
    }

    private void feeListValueChanged(ListSelectionEvent evt) {
        String feeName;
        CustomFee selectedFee;
        if (null != this.feeList.getSelectedValue() && null != (selectedFee = this._customFeeMap.get(feeName = (String)this.feeList.getSelectedValue()))) {
            this.siteNameField.setText(selectedFee.getFeeName());
            this.feePercentageField.setText(NumberFormat.getCurrencyInstance().format(selectedFee.getFeePercentage() * 100.0).substring(1));
            this.flatFeeField.setText(NumberFormat.getCurrencyInstance().format(selectedFee.getFeeFlatCost()).substring(1));
            this.submitItemButton.setEnabled(true);
            this.deleteItemButton.setEnabled(true);
        }
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        this.feeList.clearSelection();
        this.siteNameField.setText("");
        this.feePercentageField.setText("");
        this.flatFeeField.setText("");
        this.deleteItemButton.setEnabled(false);
        this.submitItemButton.setEnabled(false);
        this.flatFeeField.setForeground(Color.BLACK);
        this.feePercentageField.setForeground(Color.BLACK);
    }

    private void feePercentageFieldFocusLost(FocusEvent evt) {
        if (!this.feePercentageField.getText().trim().isEmpty() && null != MathParser.isDollarAmount((String)this.feePercentageField.getText().trim())) {
            this.feePercentageField.setText(NumberFormat.getCurrencyInstance().format(Double.valueOf(this.feePercentageField.getText().trim())).substring(1));
        } else if (this.feePercentageField.getText().trim().isEmpty()) {
            this.feePercentageField.setText("0.00");
        }
    }

    private void flatFeeFieldFocusLost(FocusEvent evt) {
        if (!this.flatFeeField.getText().trim().isEmpty() && null != MathParser.isDollarAmount((String)this.flatFeeField.getText().trim())) {
            this.flatFeeField.setText(NumberFormat.getCurrencyInstance().format(Double.valueOf(this.flatFeeField.getText().trim())).substring(1));
        } else if (this.flatFeeField.getText().trim().isEmpty()) {
            this.flatFeeField.setText("0.00");
        }
    }

    private void verifyFee() {
        boolean valid = true;
        if (this.siteNameField.getText().trim().equals("")) {
            valid = false;
        }
        if (!this.feePercentageField.getText().trim().isEmpty() && null == MathParser.isDollarAmount((String)this.feePercentageField.getText().trim())) {
            valid = false;
            this.feePercentageField.setForeground(Color.red);
        } else {
            this.feePercentageField.setForeground(Color.BLACK);
        }
        if (!this.flatFeeField.getText().trim().isEmpty() && null == MathParser.isDollarAmount((String)this.flatFeeField.getText().trim())) {
            valid = false;
            this.flatFeeField.setForeground(Color.red);
        } else {
            this.flatFeeField.setForeground(Color.BLACK);
        }
        if (valid) {
            this.submitItemButton.setEnabled(true);
        } else {
            this.submitItemButton.setEnabled(false);
        }
    }

    private void updateFeeList() {
        ((DefaultListModel)this.feeList.getModel()).clear();
        ArrayList customFeeList = null;
        customFeeList = LookupServicesUtil.getDBServices().getCustomFeeList();
        for (CustomFee fee : customFeeList) {
            ((DefaultListModel)this.feeList.getModel()).addElement(fee.getFeeName());
            this._customFeeMap.put(fee.getFeeName(), fee);
        }
    }

    class JTextFieldLimit
    extends PlainDocument {
        private int limit;

        JTextFieldLimit(int limit) {
            this.limit = limit;
        }

        JTextFieldLimit(int limit, boolean upper) {
            this.limit = limit;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (this.getLength() + str.length() <= this.limit) {
                super.insertString(offset, str, attr);
            }
        }
    }

    private class CellColorRenderer
    extends DefaultTableCellRenderer {
        private CellColorRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (table.getSelectedRow() == row) {
                this.setBackground(new Color(FrameConstants.SELECTED_ROW));
                return c;
            }
            if (row % 2 == 0) {
                this.setBackground(new Color(FrameConstants.ROW_COLOR_1));
            } else {
                this.setBackground(new Color(FrameConstants.ROW_COLOR_2));
            }
            return c;
        }
    }

    private class CheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public CheckBoxRenderer(boolean value) {
            super("", value);
        }

        @Override
        public void updateUI() {
            super.updateUI();
        }

        @Override
        public void revalidate() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setSelected(value != null && (Boolean)value != false);
            this.setHorizontalAlignment(0);
            if (table.getSelectedRow() == row) {
                this.setBackground(new Color(FrameConstants.SELECTED_ROW));
                return this;
            }
            if (row % 2 == 0) {
                this.setBackground(new Color(FrameConstants.ROW_COLOR_1));
            } else {
                this.setBackground(new Color(FrameConstants.ROW_COLOR_2));
            }
            return this;
        }
    }
}

