/*
 * Decompiled with CFR 0.152.
 */
package pnp.managers.paypalmanager;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import pnp.managers.paypalmanager.PaypalManagerTopComponent;
import pnp.services.datatypes.CompleteOrder;
import pnp.services.datatypes.EbayTransactions;
import pnp.services.datatypes.Item;
import pnp.services.datatypes.Order;
import pnp.services.datatypes.OrderDetails;
import pnp.services.datatypes.OrderStatus;
import pnp.services.datatypes.PaypalDetails;
import pnp.services.table.FormattedXTable;
import pnp.services.util.LookupServicesUtil;

public class OrderManagerSelectionForm
extends JDialog
implements ListSelectionListener {
    private PaypalDetails paypalDetail;
    private HashMap<Integer, CompleteOrder> _orderList;
    private HashMap<Integer, CompleteOrder> tableRows;
    private HashMap<String, OrderStatus> _statusList;
    private Set<CompleteOrder> _savedOrders;
    private boolean _multiLink;
    private ArrayList<OrderStatus> _statusFilters;
    private static OrderManagerSelectionForm _instance;
    private JCheckBox MOBox;
    private JCheckBox adminBox;
    private JButton cancelButton;
    private JCheckBox checkBox;
    private JButton clearButton;
    private JCheckBox completedBox;
    private JCheckBox exportBox;
    private FormattedXTable formattedOrderSelectionTable;
    private FormattedXTable formattedPaypalSelectionTable;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JButton linkButton;
    private JCheckBox newBox;
    private JCheckBox npbBox;
    private JCheckBox oosBox;
    private JCheckBox pendingBox;
    private JCheckBox printBox;
    private JButton removeAllButton;
    private JButton removeButton;
    private JButton saveButton;
    private JButton searchButton;
    private JTextField searchField;
    private JButton stopLinkButton;

    public static synchronized OrderManagerSelectionForm getInstance() {
        if (null == _instance) {
            _instance = new OrderManagerSelectionForm(null, true);
        }
        return _instance;
    }

    public OrderManagerSelectionForm(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.init();
    }

    private void init() {
        this.formattedPaypalSelectionTable.init(new String[]{"Paypal Transaction ID", "Email", "First Name", "Last Name", "Country Code", "Country", "Street1", "Street2", "City", "State", "Postal Code", "Transaction Type", "Payment Type", "Payment Date", "Gross Amount", "Payment Status", "Shipping Method", "Custom", "Memo", "Buyer ID", "Closing Date", "Multi Item", "Ebay Transaction ID", "Auction Name", "Quantity", "Cost", "Tax", "Currency Code", "Shipping Amount", "Linked"}, "PaypalSelection", new String[]{"Paypal Transaction ID", "Country", "Transaction Type", "Payment Type", "Payment Date", "Payment Status", "Custom", "Memo", "Closing Date", "Multi Item", "Currency Code", "Linked"});
        this.formattedPaypalSelectionTable.getFormattedTable().setSortable(false);
        this.formattedOrderSelectionTable.init(new String[]{"Order Status", "Order ID", "Order Date", "Ship Date", "Account Name", "Ebay Site", "Ref. Number", "Item SKU", "Item Name", "Customer ID", "Email", "Name", "Country", "Address", "City", "State", "Zipcode", "Retail $", "S/H Paid", "Wholesale $", "S/H Cost", "Weight", "Packed Weight", "Location", "Inventory", "Backordered"}, "OrderSelection", new String[]{"Order ID", "Ship Date", "Account Name", "Ebay Site", "Location", "Inventory", "Backordered"});
        this.formattedOrderSelectionTable.getFormattedTable().setSortable(false);
        this._orderList = new HashMap();
        this.tableRows = new HashMap();
        this._savedOrders = new HashSet<CompleteOrder>();
        this._statusFilters = new ArrayList();
        this._statusList = LookupServicesUtil.getDBServices().getAvailableFilters();
        this.formattedPaypalSelectionTable.loadSavedSettings();
        this.formattedOrderSelectionTable.loadSavedSettings();
        this.formattedOrderSelectionTable.getFormattedTable().getSelectionModel().addListSelectionListener(this);
    }

    private void startingFilters() {
        this._statusFilters.clear();
        this._statusFilters.add(this._statusList.get("New"));
        this._statusFilters.add(this._statusList.get("Admin Hold"));
        this._statusFilters.add(this._statusList.get("NPB"));
        this._statusFilters.add(this._statusList.get("OOS"));
        this._statusFilters.add(this._statusList.get("Pending"));
        this._statusFilters.add(this._statusList.get("Pending MO"));
        this._statusFilters.add(this._statusList.get("Pending E-Check"));
    }

    public void createLists(PaypalDetails paypalDetail, String title) {
        this.startingFilters();
        this.searchField.setText("");
        this._multiLink = true;
        this._orderList.clear();
        this._savedOrders.clear();
        this.paypalDetail = paypalDetail;
        this.fillPaypalTransactions();
        this.fillOrderTransactions();
        this.setTitle(title);
        this.setVisible(true);
    }

    public void fillPaypalTransactions() {
        this.formattedPaypalSelectionTable.getTableModel().setNumRows(0);
        Object[] row = new Object[this.formattedPaypalSelectionTable.getTableModel().getColumnCount()];
        row[((Integer)this.formattedPaypalSelectionTable.getReverseColumnMap().get((Object)"Paypal Transaction ID")).intValue()] = this.paypalDetail.getPaypalTransactionID();
        row[((Integer)this.formattedPaypalSelectionTable.getReverseColumnMap().get((Object)"Email")).intValue()] = this.paypalDetail.getEmail();
        row[((Integer)this.formattedPaypalSelectionTable.getReverseColumnMap().get((Object)"First Name")).intValue()] = this.paypalDetail.getFirstName();
        row[((Integer)this.formattedPaypalSelectionTable.getReverseColumnMap().get((Object)"Last Name")).intValue()] = this.paypalDetail.getLastName();
        row[((Integer)this.formattedPaypalSelectionTable.getReverseColumnMap().get((Object)"Country Code")).intValue()] = this.paypalDetail.getCountryCode();
        row[((Integer)this.formattedPaypalSelectionTable.getReverseColumnMap().get((Object)"Country")).intValue()] = this.paypalDetail.getCountryName();
        row[((Integer)this.formattedPaypalSelectionTable.getReverseColumnMap().get((Object)"Street1")).intValue()] = this.paypalDetail.getStreet1();
        row[((Integer)this.formattedPaypalSelectionTable.getReverseColumnMap().get((Object)"Street2")).intValue()] = this.paypalDetail.getStreet2();
        row[((Integer)this.formattedPaypalSelectionTable.getReverseColumnMap().get((Object)"City")).intValue()] = this.paypalDetail.getCityName();
        row[((Integer)this.formattedPaypalSelectionTable.getReverseColumnMap().get((Object)"State")).intValue()] = this.paypalDetail.getStateOrProvince();
        row[((Integer)this.formattedPaypalSelectionTable.getReverseColumnMap().get((Object)"Postal Code")).intValue()] = this.paypalDetail.getPostalCode();
        row[((Integer)this.formattedPaypalSelectionTable.getReverseColumnMap().get((Object)"Transaction Type")).intValue()] = this.paypalDetail.getTransactionType();
        row[((Integer)this.formattedPaypalSelectionTable.getReverseColumnMap().get((Object)"Payment Type")).intValue()] = this.paypalDetail.getPaymentType();
        row[((Integer)this.formattedPaypalSelectionTable.getReverseColumnMap().get((Object)"Payment Date")).intValue()] = this.paypalDetail.getPaymentDate();
        row[((Integer)this.formattedPaypalSelectionTable.getReverseColumnMap().get((Object)"Gross Amount")).intValue()] = this.paypalDetail.getGrossAmount();
        row[((Integer)this.formattedPaypalSelectionTable.getReverseColumnMap().get((Object)"Payment Status")).intValue()] = this.paypalDetail.getPaymentStatus();
        row[((Integer)this.formattedPaypalSelectionTable.getReverseColumnMap().get((Object)"Shipping Method")).intValue()] = this.paypalDetail.getShippingMethod();
        row[((Integer)this.formattedPaypalSelectionTable.getReverseColumnMap().get((Object)"Custom")).intValue()] = this.paypalDetail.getCustom();
        row[((Integer)this.formattedPaypalSelectionTable.getReverseColumnMap().get((Object)"Memo")).intValue()] = this.paypalDetail.getMemo();
        row[((Integer)this.formattedPaypalSelectionTable.getReverseColumnMap().get((Object)"Buyer ID")).intValue()] = this.paypalDetail.getBuyerID();
        row[((Integer)this.formattedPaypalSelectionTable.getReverseColumnMap().get((Object)"Closing Date")).intValue()] = this.paypalDetail.getClosingDate();
        row[((Integer)this.formattedPaypalSelectionTable.getReverseColumnMap().get((Object)"Multi Item")).intValue()] = this.paypalDetail.getMultiItem();
        row[((Integer)this.formattedPaypalSelectionTable.getReverseColumnMap().get((Object)"Linked")).intValue()] = this.paypalDetail.isLinked();
        row[((Integer)this.formattedPaypalSelectionTable.getReverseColumnMap().get((Object)"Tax")).intValue()] = this.paypalDetail.getTax();
        row[((Integer)this.formattedPaypalSelectionTable.getReverseColumnMap().get((Object)"Currency Code")).intValue()] = this.paypalDetail.getCurrencyCode();
        row[((Integer)this.formattedPaypalSelectionTable.getReverseColumnMap().get((Object)"Shipping Amount")).intValue()] = this.paypalDetail.getShippingAmount();
        boolean continuedTransaction = false;
        int detailNumber = 1;
        for (EbayTransactions newTransaction : this.paypalDetail.getEbayItems()) {
            if (continuedTransaction) {
                row[((Integer)this.formattedPaypalSelectionTable.getReverseColumnMap().get((Object)"Paypal Transaction ID")).intValue()] = this.paypalDetail.getPaypalTransactionID() + " - " + detailNumber;
                ++detailNumber;
            }
            row[((Integer)this.formattedPaypalSelectionTable.getReverseColumnMap().get((Object)"Linked")).intValue()] = this.paypalDetail.isLinked();
            row[((Integer)this.formattedPaypalSelectionTable.getReverseColumnMap().get((Object)"Ebay Transaction ID")).intValue()] = newTransaction.getEbayTransactionID();
            row[((Integer)this.formattedPaypalSelectionTable.getReverseColumnMap().get((Object)"Auction Name")).intValue()] = newTransaction.getAuctionName();
            row[((Integer)this.formattedPaypalSelectionTable.getReverseColumnMap().get((Object)"Quantity")).intValue()] = newTransaction.getQuantity();
            row[((Integer)this.formattedPaypalSelectionTable.getReverseColumnMap().get((Object)"Cost")).intValue()] = newTransaction.getCost();
            this.formattedPaypalSelectionTable.getTableModel().addRow(row);
            continuedTransaction = true;
        }
        if (this.paypalDetail.getEbayItems().isEmpty() && (this.paypalDetail.getEmail() == null || !this.paypalDetail.getEmail().equalsIgnoreCase("sales@plugnplaytoyz.com"))) {
            this.formattedPaypalSelectionTable.getTableModel().addRow(row);
        }
    }

    public void searchOrder(String searchTerm) {
        if (searchTerm != null && !searchTerm.trim().isEmpty()) {
            this._orderList = LookupServicesUtil.getDBServices().getOrders(searchTerm.trim(), new OrderStatus[0], 0L, 0L, "20");
        }
    }

    public void fillOrderTransactions() {
        this.tableRows.clear();
        LinkedHashSet<CompleteOrder> shownOrders = new LinkedHashSet<CompleteOrder>();
        shownOrders.addAll(this._savedOrders);
        shownOrders.addAll(this._orderList.values());
        HashSet<String> orderStatus = new HashSet<String>();
        for (OrderStatus status : this._statusFilters) {
            orderStatus.add(status.getOrderStatusType());
        }
        this.formattedOrderSelectionTable.getTableModel().setNumRows(0);
        for (CompleteOrder completeOrder : shownOrders) {
            Order order = completeOrder.getOrder();
            if (!orderStatus.contains(order.getOrderStatus().getOrderStatusType()) && !this._savedOrders.contains(completeOrder) && !orderStatus.isEmpty()) continue;
            Object[] row = new Object[this.formattedOrderSelectionTable.getTableModel().getColumnCount()];
            row[((Integer)this.formattedOrderSelectionTable.getReverseColumnMap().get((Object)"Order ID")).intValue()] = order.getOrderID();
            row[((Integer)this.formattedOrderSelectionTable.getReverseColumnMap().get((Object)"Address")).intValue()] = order.getCustomer().getCustomerAddress();
            row[((Integer)this.formattedOrderSelectionTable.getReverseColumnMap().get((Object)"City")).intValue()] = order.getCustomer().getCustomerCity();
            row[((Integer)this.formattedOrderSelectionTable.getReverseColumnMap().get((Object)"Country")).intValue()] = order.getCustomer().getCustomerCountry();
            row[((Integer)this.formattedOrderSelectionTable.getReverseColumnMap().get((Object)"Customer ID")).intValue()] = order.getCustomer().getCustomerUserName();
            row[((Integer)this.formattedOrderSelectionTable.getReverseColumnMap().get((Object)"Email")).intValue()] = order.getCustomer().getCustomerEmail();
            row[((Integer)this.formattedOrderSelectionTable.getReverseColumnMap().get((Object)"Name")).intValue()] = order.getCustomer().getCustomerName();
            row[((Integer)this.formattedOrderSelectionTable.getReverseColumnMap().get((Object)"State")).intValue()] = order.getCustomer().getCustomerState();
            row[((Integer)this.formattedOrderSelectionTable.getReverseColumnMap().get((Object)"Zipcode")).intValue()] = order.getCustomer().getCustomerZipcode();
            row[((Integer)this.formattedOrderSelectionTable.getReverseColumnMap().get((Object)"Order Date")).intValue()] = order.getOrderDate().toString();
            row[((Integer)this.formattedOrderSelectionTable.getReverseColumnMap().get((Object)"Order Status")).intValue()] = order.getOrderStatus().getOrderStatusType();
            row[((Integer)this.formattedOrderSelectionTable.getReverseColumnMap().get((Object)"Retail $")).intValue()] = String.valueOf(order.getOrderTotal());
            row[((Integer)this.formattedOrderSelectionTable.getReverseColumnMap().get((Object)"S/H Cost")).intValue()] = String.valueOf(order.getShippingCost());
            row[((Integer)this.formattedOrderSelectionTable.getReverseColumnMap().get((Object)"S/H Paid")).intValue()] = String.valueOf(order.getShippingPaid());
            boolean continuedTransaction = false;
            for (OrderDetails detail : completeOrder.getOrderDetails()) {
                Item item;
                if (continuedTransaction) {
                    row = new Object[this.formattedOrderSelectionTable.getTableModel().getColumnCount()];
                }
                if (null != detail.getShipDate()) {
                    row[((Integer)this.formattedOrderSelectionTable.getReverseColumnMap().get((Object)"Ship Date")).intValue()] = detail.getShipDate().toString();
                }
                row[((Integer)this.formattedOrderSelectionTable.getReverseColumnMap().get((Object)"Account Name")).intValue()] = detail.getAccountName();
                row[((Integer)this.formattedOrderSelectionTable.getReverseColumnMap().get((Object)"Ebay Site")).intValue()] = detail.getEbaySite();
                row[((Integer)this.formattedOrderSelectionTable.getReverseColumnMap().get((Object)"Item SKU")).intValue()] = detail.getItemID();
                row[((Integer)this.formattedOrderSelectionTable.getReverseColumnMap().get((Object)"Item Name")).intValue()] = detail.getOrderDescription();
                row[((Integer)this.formattedOrderSelectionTable.getReverseColumnMap().get((Object)"Ref. Number")).intValue()] = detail.getOrderNumber();
                row[((Integer)this.formattedOrderSelectionTable.getReverseColumnMap().get((Object)"Wholesale $")).intValue()] = String.valueOf(detail.getItemCost());
                row[((Integer)this.formattedOrderSelectionTable.getReverseColumnMap().get((Object)"Weight")).intValue()] = "0.0";
                row[((Integer)this.formattedOrderSelectionTable.getReverseColumnMap().get((Object)"Location")).intValue()] = "";
                if (null != detail.getItemID() && !detail.getItemID().isEmpty() && null != (item = LookupServicesUtil.getDBServices().getItem(detail.getItemID()))) {
                    row[((Integer)this.formattedOrderSelectionTable.getReverseColumnMap().get((Object)"Weight")).intValue()] = String.valueOf(item.getItemWeight());
                    row[((Integer)this.formattedOrderSelectionTable.getReverseColumnMap().get((Object)"Packed Weight")).intValue()] = String.valueOf(item.getPackedWeight());
                    row[((Integer)this.formattedOrderSelectionTable.getReverseColumnMap().get((Object)"Location")).intValue()] = String.valueOf(item.getLocation());
                }
                if (!detail.isInhouse() && detail.getEbayWeight() > 0.0f) {
                    row[((Integer)this.formattedOrderSelectionTable.getReverseColumnMap().get((Object)"Weight")).intValue()] = String.valueOf(detail.getEbayWeight());
                }
                row[((Integer)this.formattedOrderSelectionTable.getReverseColumnMap().get((Object)"Inventory")).intValue()] = detail.isInhouse();
                row[((Integer)this.formattedOrderSelectionTable.getReverseColumnMap().get((Object)"Backordered")).intValue()] = detail.isBackordered();
                continuedTransaction = true;
                this.tableRows.put(this.formattedOrderSelectionTable.getTableModel().getRowCount(), completeOrder);
                this.formattedOrderSelectionTable.getTableModel().addRow(row);
            }
        }
        this.formattedOrderSelectionTable.getRenderer().setTableRows(this.tableRows);
        this.valueChanged(null);
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.formattedPaypalSelectionTable = new FormattedXTable();
        this.removeAllButton = new JButton();
        this.removeButton = new JButton();
        this.saveButton = new JButton();
        this.searchField = new JTextField();
        this.searchButton = new JButton();
        this.jPanel1 = new JPanel();
        this.newBox = new JCheckBox();
        this.oosBox = new JCheckBox();
        this.pendingBox = new JCheckBox();
        this.completedBox = new JCheckBox();
        this.exportBox = new JCheckBox();
        this.checkBox = new JCheckBox();
        this.printBox = new JCheckBox();
        this.npbBox = new JCheckBox();
        this.adminBox = new JCheckBox();
        this.MOBox = new JCheckBox();
        this.clearButton = new JButton();
        this.formattedOrderSelectionTable = new FormattedXTable();
        this.cancelButton = new JButton();
        this.stopLinkButton = new JButton();
        this.linkButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(OrderManagerSelectionForm.class, (String)"OrderManagerSelectionForm.jPanel2.border.title")));
        Mnemonics.setLocalizedText((AbstractButton)this.removeAllButton, (String)NbBundle.getMessage(OrderManagerSelectionForm.class, (String)"OrderManagerSelectionForm.removeAllButton.text"));
        this.removeAllButton.setEnabled(false);
        this.removeAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerSelectionForm.this.removeAllButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(OrderManagerSelectionForm.class, (String)"OrderManagerSelectionForm.removeButton.text"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerSelectionForm.this.removeButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.saveButton, (String)NbBundle.getMessage(OrderManagerSelectionForm.class, (String)"OrderManagerSelectionForm.saveButton.text"));
        this.saveButton.setEnabled(false);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerSelectionForm.this.saveButtonActionPerformed(evt);
            }
        });
        this.searchField.setText(NbBundle.getMessage(OrderManagerSelectionForm.class, (String)"OrderManagerSelectionForm.searchField.text"));
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OrderManagerSelectionForm.this.searchFieldKeyReleased(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.searchButton, (String)NbBundle.getMessage(OrderManagerSelectionForm.class, (String)"OrderManagerSelectionForm.searchButton.text"));
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerSelectionForm.this.searchButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(OrderManagerSelectionForm.class, (String)"OrderManagerSelectionForm.jPanel1.border.title")));
        this.newBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.newBox, (String)NbBundle.getMessage(OrderManagerSelectionForm.class, (String)"OrderManagerSelectionForm.newBox.text"));
        this.newBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerSelectionForm.this.newBoxActionPerformed(evt);
            }
        });
        this.oosBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.oosBox, (String)NbBundle.getMessage(OrderManagerSelectionForm.class, (String)"OrderManagerSelectionForm.oosBox.text"));
        this.oosBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerSelectionForm.this.oosBoxActionPerformed(evt);
            }
        });
        this.pendingBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.pendingBox, (String)NbBundle.getMessage(OrderManagerSelectionForm.class, (String)"OrderManagerSelectionForm.pendingBox.text"));
        this.pendingBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerSelectionForm.this.pendingBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.completedBox, (String)NbBundle.getMessage(OrderManagerSelectionForm.class, (String)"OrderManagerSelectionForm.completedBox.text"));
        this.completedBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerSelectionForm.this.completedBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.exportBox, (String)NbBundle.getMessage(OrderManagerSelectionForm.class, (String)"OrderManagerSelectionForm.exportBox.text"));
        this.exportBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerSelectionForm.this.exportBoxActionPerformed(evt);
            }
        });
        this.checkBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.checkBox, (String)NbBundle.getMessage(OrderManagerSelectionForm.class, (String)"OrderManagerSelectionForm.checkBox.text"));
        this.checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerSelectionForm.this.checkBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.printBox, (String)NbBundle.getMessage(OrderManagerSelectionForm.class, (String)"OrderManagerSelectionForm.printBox.text"));
        this.printBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerSelectionForm.this.printBoxActionPerformed(evt);
            }
        });
        this.npbBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.npbBox, (String)NbBundle.getMessage(OrderManagerSelectionForm.class, (String)"OrderManagerSelectionForm.npbBox.text"));
        this.npbBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerSelectionForm.this.npbBoxActionPerformed(evt);
            }
        });
        this.adminBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.adminBox, (String)NbBundle.getMessage(OrderManagerSelectionForm.class, (String)"OrderManagerSelectionForm.adminBox.text"));
        this.adminBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerSelectionForm.this.adminBoxActionPerformed(evt);
            }
        });
        this.MOBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.MOBox, (String)NbBundle.getMessage(OrderManagerSelectionForm.class, (String)"OrderManagerSelectionForm.MOBox.text"));
        this.MOBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerSelectionForm.this.MOBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.exportBox).addComponent(this.pendingBox).addComponent(this.adminBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.MOBox).addComponent(this.checkBox).addComponent(this.printBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.completedBox).addComponent(this.oosBox).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.newBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.npbBox))).addContainerGap(87, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.newBox).addComponent(this.pendingBox).addComponent(this.MOBox).addComponent(this.npbBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.oosBox).addComponent(this.checkBox).addComponent(this.adminBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.completedBox).addComponent(this.exportBox).addComponent(this.printBox)).addContainerGap(-1, Short.MAX_VALUE)));
        Mnemonics.setLocalizedText((AbstractButton)this.clearButton, (String)NbBundle.getMessage(OrderManagerSelectionForm.class, (String)"OrderManagerSelectionForm.clearButton.text"));
        this.clearButton.setEnabled(false);
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerSelectionForm.this.clearButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)NbBundle.getMessage(OrderManagerSelectionForm.class, (String)"OrderManagerSelectionForm.cancelButton.text"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerSelectionForm.this.cancelButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.stopLinkButton, (String)NbBundle.getMessage(OrderManagerSelectionForm.class, (String)"OrderManagerSelectionForm.stopLinkButton.text"));
        this.stopLinkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerSelectionForm.this.stopLinkButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.linkButton, (String)NbBundle.getMessage(OrderManagerSelectionForm.class, (String)"OrderManagerSelectionForm.linkButton.text"));
        this.linkButton.setEnabled(false);
        this.linkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderManagerSelectionForm.this.linkButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.formattedOrderSelectionTable, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.linkButton).addGap(800, 800, 800).addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stopLinkButton)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.removeAllButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchField, -2, 142, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearButton).addGap(0, 0, Short.MAX_VALUE)).addComponent((Component)this.formattedPaypalSelectionTable, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent((Component)this.formattedPaypalSelectionTable, -2, 146, -2).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jPanel1, -2, -1, -2)).addGroup(jPanel2Layout.createSequentialGroup().addGap(34, 34, 34).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.removeAllButton).addComponent(this.removeButton).addComponent(this.saveButton).addComponent(this.searchField, -2, -1, -2).addComponent(this.searchButton))).addGroup(jPanel2Layout.createSequentialGroup().addGap(35, 35, 35).addComponent(this.clearButton))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.formattedOrderSelectionTable, -1, 221, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.linkButton).addComponent(this.cancelButton).addComponent(this.stopLinkButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void linkButtonActionPerformed(ActionEvent evt) {
        float epsilon = 0.001f;
        boolean link = true;
        float totalPrice = 0.0f;
        float paypalPrice = this.paypalDetail.getGrossAmount().floatValue() - this.paypalDetail.getTax().floatValue();
        if (this._savedOrders.isEmpty() && this.tableRows.size() == 1) {
            this._savedOrders.add(this.tableRows.get(0));
        }
        if (!this._savedOrders.isEmpty()) {
            for (CompleteOrder order : this._savedOrders) {
                totalPrice += order.getOrder().getOrderTotal() + order.getOrder().getShippingPaid();
            }
            if (Math.abs(totalPrice - paypalPrice) > epsilon) {
                boolean bl = link = 0 == JOptionPane.showConfirmDialog(null, "Total Price: " + totalPrice + "" + " does not equal Paypal Price: " + paypalPrice + "." + " Would you like to continue?", "Link Orders?", 0);
            }
            if (link) {
                if (this._savedOrders.size() > 1 && 0 == JOptionPane.showConfirmDialog(null, "Merge these transactions together?", "Merge Orders?", 0)) {
                    PaypalManagerTopComponent.findInstance().changeOrders(PaypalManagerTopComponent.findInstance().mergeOrders(this._savedOrders, this.paypalDetail), this.paypalDetail);
                } else {
                    for (CompleteOrder completeOrder : this._savedOrders) {
                        PaypalManagerTopComponent.findInstance().changeOrders(completeOrder, this.paypalDetail);
                    }
                }
                this.setVisible(false);
            }
        } else {
            JOptionPane.showMessageDialog(null, "No Saved Orders");
        }
    }

    private void searchFieldKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10 && !this.searchField.getText().isEmpty()) {
            this.searchOrder(this.searchField.getText());
            this.fillOrderTransactions();
        }
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        this._orderList.clear();
        this.searchField.setText("");
        this.fillOrderTransactions();
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        for (int row : this.formattedOrderSelectionTable.getFormattedTable().getSelectedRows()) {
            this._savedOrders.add(this.tableRows.get(this.formattedOrderSelectionTable.convertRow(row)));
        }
        this.formattedOrderSelectionTable.getRenderer().setSavedOrders(this._savedOrders);
        this.fillOrderTransactions();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        for (int row : this.formattedOrderSelectionTable.getFormattedTable().getSelectedRows()) {
            this._savedOrders.remove(this.tableRows.get(this.formattedOrderSelectionTable.convertRow(row)));
        }
        this.formattedOrderSelectionTable.getRenderer().setSavedOrders(this._savedOrders);
        this.fillOrderTransactions();
    }

    private void removeAllButtonActionPerformed(ActionEvent evt) {
        this._savedOrders.clear();
        this.formattedOrderSelectionTable.getRenderer().setSavedOrders(this._savedOrders);
        this.fillOrderTransactions();
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        if (!this.searchField.getText().isEmpty()) {
            this.searchOrder(this.searchField.getText());
            this.fillOrderTransactions();
        }
    }

    private void stopLinkButtonActionPerformed(ActionEvent evt) {
        this._multiLink = false;
        this.setVisible(false);
    }

    private void newBoxActionPerformed(ActionEvent evt) {
        if (this.newBox.isSelected()) {
            this._statusFilters.add(this._statusList.get("New"));
        } else {
            this._statusFilters.remove(this._statusList.get("New"));
        }
        this.fillOrderTransactions();
    }

    private void oosBoxActionPerformed(ActionEvent evt) {
        if (this.oosBox.isSelected()) {
            this._statusFilters.add(this._statusList.get("OOS"));
        } else {
            this._statusFilters.remove(this._statusList.get("OOS"));
        }
        this.fillOrderTransactions();
    }

    private void pendingBoxActionPerformed(ActionEvent evt) {
        if (this.pendingBox.isSelected()) {
            this._statusFilters.add(this._statusList.get("Pending"));
        } else {
            this._statusFilters.remove(this._statusList.get("Pending"));
        }
        this.fillOrderTransactions();
    }

    private void completedBoxActionPerformed(ActionEvent evt) {
        if (this.completedBox.isSelected()) {
            this._statusFilters.add(this._statusList.get("Complete"));
        } else {
            this._statusFilters.remove(this._statusList.get("Complete"));
        }
        this.fillOrderTransactions();
    }

    private void printBoxActionPerformed(ActionEvent evt) {
        if (this.printBox.isSelected()) {
            this._statusFilters.add(this._statusList.get("Pending Print"));
        } else {
            this._statusFilters.remove(this._statusList.get("Pending Print"));
        }
        this.fillOrderTransactions();
    }

    private void exportBoxActionPerformed(ActionEvent evt) {
        if (this.exportBox.isSelected()) {
            this._statusFilters.add(this._statusList.get("Export Labels"));
        } else {
            this._statusFilters.remove(this._statusList.get("Export Labels"));
        }
        this.fillOrderTransactions();
    }

    private void npbBoxActionPerformed(ActionEvent evt) {
        if (this.npbBox.isSelected()) {
            this._statusFilters.add(this._statusList.get("NPB"));
        } else {
            this._statusFilters.remove(this._statusList.get("NPB"));
        }
        this.fillOrderTransactions();
    }

    private void checkBoxActionPerformed(ActionEvent evt) {
        if (this.checkBox.isSelected()) {
            this._statusFilters.add(this._statusList.get("Pending E-Check"));
        } else {
            this._statusFilters.remove(this._statusList.get("Pending E-Check"));
        }
        this.fillOrderTransactions();
    }

    private void adminBoxActionPerformed(ActionEvent evt) {
        if (this.adminBox.isSelected()) {
            this._statusFilters.add(this._statusList.get("Admin Hold"));
        } else {
            this._statusFilters.remove(this._statusList.get("Admin Hold"));
        }
        this.fillOrderTransactions();
    }

    private void MOBoxActionPerformed(ActionEvent evt) {
        if (this.MOBox.isSelected()) {
            this._statusFilters.add(this._statusList.get("Pending MO"));
        } else {
            this._statusFilters.remove(this._statusList.get("Pending MO"));
        }
        this.fillOrderTransactions();
    }

    public boolean isMultiLink() {
        return this._multiLink;
    }

    public void setMultiLink(boolean _multiLink) {
        this._multiLink = _multiLink;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.removeAllButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.saveButton.setEnabled(false);
        this.clearButton.setEnabled(false);
        this.linkButton.setEnabled(false);
        if (this.tableRows != null && !this.tableRows.isEmpty()) {
            int row = this.formattedOrderSelectionTable.getFormattedTable().getSelectedRow();
            this.clearButton.setEnabled(true);
            if (this._savedOrders != null) {
                if (!this._savedOrders.isEmpty()) {
                    if (row >= 0 && row < this._savedOrders.size()) {
                        this.removeButton.setEnabled(true);
                    }
                    this.removeAllButton.setEnabled(true);
                    this.linkButton.setEnabled(true);
                }
                if (row >= this._savedOrders.size()) {
                    this.saveButton.setEnabled(true);
                }
            }
            if (this.tableRows.size() == 1) {
                this.formattedOrderSelectionTable.getFormattedTable().setRowSelectionInterval(0, 0);
                this.linkButton.setEnabled(true);
            }
        }
    }
}

