/*
 * Decompiled with CFR 0.152.
 */
package pnp.managers.paypalmanager;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import pnp.managers.paypalmanager.OrderManagerSelectionForm;
import pnp.services.authenticationmanager.SubscriptionManager;
import pnp.services.datatypes.CompleteOrder;
import pnp.services.datatypes.Customer;
import pnp.services.datatypes.EbayTransactions;
import pnp.services.datatypes.Order;
import pnp.services.datatypes.OrderDetails;
import pnp.services.datatypes.OrderStatus;
import pnp.services.datatypes.PaypalDetails;
import pnp.services.listener.GenericListener;
import pnp.services.listener.LoginListener;
import pnp.services.listener.PaypalProgressListener;
import pnp.services.listener.UpdateStatusListener;
import pnp.services.listenermanager.ListenerManager;
import pnp.services.preferencemanager.Preferences;
import pnp.services.table.FormattedXTable;
import pnp.services.util.ErrorsUtil;
import pnp.services.util.GenericFunctions;
import pnp.services.util.LookupServicesUtil;

@TopComponent.Description(preferredID="PaypalManagerTopComponent", persistenceType=1)
public final class PaypalManagerTopComponent
extends TopComponent
implements ListSelectionListener,
TableModelListener,
PaypalProgressListener,
LoginListener,
UpdateStatusListener {
    private static PaypalManagerTopComponent instance;
    private String startDate;
    private String endDate;
    private HashMap<String, OrderStatus> _statusList;
    private boolean linkPending;
    private int[] itemsProjected;
    private boolean _multiLink;
    boolean ctrlPressed;
    boolean cPressed;
    private boolean tableListener;
    private boolean skuListener;
    HashMap<String, PaypalDetails> detailList;
    private JButton createOrderButton;
    private JButton deleteButton;
    private JCheckBox exclusivePaypal;
    private JComboBox filter;
    private FormattedXTable formattedPaypalDetailsTable;
    private FormattedXTable formattedPaypalTable;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JButton linkButton;
    private JProgressBar linkProgressBar;
    private JButton manualLinkButton;
    private JProgressBar refreshProgressBar;
    private JButton searchButton;
    private JTextField searchField;
    private JButton updateButton;
    private JComboBox updateLength;
    private int totalProgress = 0;
    private int currentProgress = 0;
    private boolean currentStatus = true;

    public PaypalManagerTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(PaypalManagerTopComponent.class, (String)"CTL_PaypalManagerTopComponent"));
        this.setToolTipText(NbBundle.getMessage(PaypalManagerTopComponent.class, (String)"HINT_PaypalManagerTopComponent"));
        this.LoginToggle();
        this.init();
    }

    private void createTables() {
        this.formattedPaypalTable.init(new String[]{"Paypal Transaction ID", "Email", "First Name", "Last Name", "Country Code", "Country", "Street1", "Street2", "City", "State", "Postal Code", "Transaction Type", "Payment Type", "Payment Date", "Gross Amount", "Payment Status", "Shipping Method", "Custom", "Memo", "Buyer ID", "Closing Date", "Multi Item", "Tax", "Currency Code", "Shipping Amount", "Linked", "PayPal Account"}, "PaypalManager", new String[]{"Country", "Transaction Type", "Shipping Method", "Custom", "Memo", "Closing Date", "Multi Item", "Shipping Amount", "Currency Code", "Tax", "PayPal Account"});
        this.formattedPaypalDetailsTable.init(new String[]{"Ebay Transaction ID", "Auction Name", "Quantity", "Cost", "ReferenceNumber"}, "PaypalDetailsManager", null);
        this.formattedPaypalTable.createCheckBox("Linked");
        this.formattedPaypalTable.getTableModel().addTableModelListener(this);
        this.formattedPaypalTable.getFormattedTable().getSelectionModel().addListSelectionListener(this);
        this.formattedPaypalDetailsTable.getTableModel().addTableModelListener(new DetailModelListener());
    }

    private void instantiateVariables() {
        this.detailList = new HashMap();
        this._multiLink = true;
        this.linkPending = false;
        this.tableListener = true;
        this.skuListener = true;
        this.ctrlPressed = false;
        this.cPressed = false;
        this.itemsProjected = new int[2];
        this._statusList = LookupServicesUtil.getDBServices().getAvailableFilters();
        this.refreshProgressBar.setVisible(false);
        this.refreshProgressBar.setMinimum(0);
        this.refreshProgressBar.setMaximum(100);
        this.linkProgressBar.setVisible(false);
        this.linkProgressBar.setMinimum(0);
        this.linkProgressBar.setMaximum(100);
    }

    private void doWork() {
        this.updatePaypalOrders(null);
        this.formattedPaypalTable.loadSavedSettings();
        this.formattedPaypalDetailsTable.loadSavedSettings();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    OrderManagerSelectionForm.getInstance();
                }
                catch (Exception ex) {
                    ErrorsUtil.getInstance().logError(ex);
                }
            }
        }).start();
        ListenerManager.getInstance().subscribe((GenericListener)this);
    }

    public void init() {
        this.instantiateVariables();
        this.createTables();
        this.doWork();
    }

    private void createRange(String selectedRange) {
        SimpleDateFormat dayFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat hourFormat = new SimpleDateFormat("HH:mm:ss");
        java.util.Date date = new java.util.Date();
        date.setHours(date.getHours() + 10);
        this.endDate = dayFormat.format(date) + "T" + hourFormat.format(date) + "Z";
        date.setHours(date.getHours() - 10);
        if (selectedRange.equalsIgnoreCase("1 Day")) {
            date.setDate(date.getDate() - 1);
        } else if (selectedRange.equalsIgnoreCase("2 Days")) {
            date.setDate(date.getDate() - 2);
        } else if (selectedRange.equalsIgnoreCase("7 Days")) {
            date.setDate(date.getDate() - 7);
        } else if (LookupServicesUtil.getDBServices().getAccountPreferences().getPaypalLastUpdate() == 0L) {
            date.setDate(date.getDate() - 5);
        } else {
            date = new java.util.Date(LookupServicesUtil.getDBServices().getAccountPreferences().getPaypalLastUpdate());
        }
        this.startDate = dayFormat.format(date) + "T" + hourFormat.format(date) + "Z";
    }

    public void updatePaypalOrders(ArrayList<PaypalDetails> specificDetails) {
        this.valueChanged(null);
        this.tableListener = false;
        this.skuListener = false;
        this.detailList.clear();
        this.formattedPaypalTable.getTableModel().setNumRows(0);
        this.formattedPaypalDetailsTable.getTableModel().setNumRows(0);
        String format = "yyyy-MM-dd'T'HH:mm:ss'Z'";
        SimpleDateFormat sdf = new SimpleDateFormat(format, Locale.US);
        java.util.Date todayMinus30 = new java.util.Date();
        todayMinus30.setDate(todayMinus30.getDate() - 30);
        ArrayList details = specificDetails;
        if (details == null) {
            details = LookupServicesUtil.getDBServices().getPaypalDetails(this.filter.getSelectedItem().toString());
        }
        for (PaypalDetails newDetails : details) {
            if (this.detailList.containsKey(newDetails.getPaypalTransactionID())) continue;
            this.detailList.put(newDetails.getPaypalTransactionID(), newDetails);
            try {
                java.util.Date result = newDetails.getPaymentDate() == null || newDetails.getPaymentDate().isEmpty() ? new java.util.Date() : sdf.parse(newDetails.getPaymentDate());
                if (result.compareTo(todayMinus30) > 0) {
                    if (!(newDetails.getGrossAmount().floatValue() > 0.0f)) continue;
                    Object[] row = new Object[this.formattedPaypalTable.getTableModel().getColumnCount()];
                    row[((Integer)this.formattedPaypalTable.getReverseColumnMap().get((Object)"Paypal Transaction ID")).intValue()] = newDetails.getPaypalTransactionID();
                    row[((Integer)this.formattedPaypalTable.getReverseColumnMap().get((Object)"Email")).intValue()] = newDetails.getEmail();
                    row[((Integer)this.formattedPaypalTable.getReverseColumnMap().get((Object)"First Name")).intValue()] = newDetails.getFirstName();
                    row[((Integer)this.formattedPaypalTable.getReverseColumnMap().get((Object)"Last Name")).intValue()] = newDetails.getLastName();
                    row[((Integer)this.formattedPaypalTable.getReverseColumnMap().get((Object)"Country Code")).intValue()] = newDetails.getCountryCode();
                    row[((Integer)this.formattedPaypalTable.getReverseColumnMap().get((Object)"Country")).intValue()] = newDetails.getCountryName();
                    row[((Integer)this.formattedPaypalTable.getReverseColumnMap().get((Object)"Street1")).intValue()] = newDetails.getStreet1();
                    row[((Integer)this.formattedPaypalTable.getReverseColumnMap().get((Object)"Street2")).intValue()] = newDetails.getStreet2();
                    row[((Integer)this.formattedPaypalTable.getReverseColumnMap().get((Object)"City")).intValue()] = newDetails.getCityName();
                    row[((Integer)this.formattedPaypalTable.getReverseColumnMap().get((Object)"State")).intValue()] = newDetails.getStateOrProvince();
                    row[((Integer)this.formattedPaypalTable.getReverseColumnMap().get((Object)"Postal Code")).intValue()] = newDetails.getPostalCode();
                    row[((Integer)this.formattedPaypalTable.getReverseColumnMap().get((Object)"Transaction Type")).intValue()] = newDetails.getTransactionType();
                    row[((Integer)this.formattedPaypalTable.getReverseColumnMap().get((Object)"Payment Type")).intValue()] = newDetails.getPaymentType();
                    row[((Integer)this.formattedPaypalTable.getReverseColumnMap().get((Object)"Payment Date")).intValue()] = newDetails.getPaymentDate();
                    row[((Integer)this.formattedPaypalTable.getReverseColumnMap().get((Object)"Gross Amount")).intValue()] = newDetails.getGrossAmount();
                    row[((Integer)this.formattedPaypalTable.getReverseColumnMap().get((Object)"Payment Status")).intValue()] = newDetails.getPaymentStatus();
                    row[((Integer)this.formattedPaypalTable.getReverseColumnMap().get((Object)"Shipping Method")).intValue()] = newDetails.getShippingMethod();
                    row[((Integer)this.formattedPaypalTable.getReverseColumnMap().get((Object)"Custom")).intValue()] = newDetails.getCustom();
                    row[((Integer)this.formattedPaypalTable.getReverseColumnMap().get((Object)"Memo")).intValue()] = newDetails.getMemo();
                    row[((Integer)this.formattedPaypalTable.getReverseColumnMap().get((Object)"Buyer ID")).intValue()] = newDetails.getBuyerID();
                    row[((Integer)this.formattedPaypalTable.getReverseColumnMap().get((Object)"Closing Date")).intValue()] = newDetails.getClosingDate();
                    row[((Integer)this.formattedPaypalTable.getReverseColumnMap().get((Object)"Multi Item")).intValue()] = newDetails.getMultiItem();
                    row[((Integer)this.formattedPaypalTable.getReverseColumnMap().get((Object)"Linked")).intValue()] = newDetails.isLinked();
                    row[((Integer)this.formattedPaypalTable.getReverseColumnMap().get((Object)"Tax")).intValue()] = newDetails.getTax();
                    row[((Integer)this.formattedPaypalTable.getReverseColumnMap().get((Object)"Currency Code")).intValue()] = newDetails.getCurrencyCode();
                    row[((Integer)this.formattedPaypalTable.getReverseColumnMap().get((Object)"Shipping Amount")).intValue()] = newDetails.getShippingAmount();
                    row[((Integer)this.formattedPaypalTable.getReverseColumnMap().get((Object)"PayPal Account")).intValue()] = newDetails.getPaypalAccount();
                    if (!this.checkFilteredEmails(newDetails)) continue;
                    this.formattedPaypalTable.getTableModel().addRow(row);
                    continue;
                }
                LookupServicesUtil.getDBServices().deletePaypalTransaction(newDetails.getPaypalTransactionID());
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        this.linkButton.setEnabled(this.formattedPaypalTable.getFormattedTable().getRowCount() > 0 && SubscriptionManager.getInstance().isPaypalActive());
        this.skuListener = true;
        this.tableListener = true;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.formattedPaypalTable = new FormattedXTable();
        this.jPanel2 = new JPanel();
        this.updateLength = new JComboBox();
        this.updateButton = new JButton();
        this.refreshProgressBar = new JProgressBar();
        this.searchField = new JTextField();
        this.searchButton = new JButton();
        this.createOrderButton = new JButton();
        this.exclusivePaypal = new JCheckBox();
        this.filter = new JComboBox();
        this.jPanel3 = new JPanel();
        this.linkProgressBar = new JProgressBar();
        this.linkButton = new JButton();
        this.manualLinkButton = new JButton();
        this.deleteButton = new JButton();
        this.formattedPaypalDetailsTable = new FormattedXTable();
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(""));
        this.updateLength.setModel(new DefaultComboBoxModel<String>(new String[]{"Last Update", "1 Day", "2 Days", "7 Days"}));
        Mnemonics.setLocalizedText((AbstractButton)this.updateButton, (String)NbBundle.getMessage(PaypalManagerTopComponent.class, (String)"PaypalManagerTopComponent.updateButton.text"));
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PaypalManagerTopComponent.this.updateButtonActionPerformed(evt);
            }
        });
        this.searchField.setText(NbBundle.getMessage(PaypalManagerTopComponent.class, (String)"PaypalManagerTopComponent.searchField.text"));
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PaypalManagerTopComponent.this.searchFieldKeyReleased(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.searchButton, (String)NbBundle.getMessage(PaypalManagerTopComponent.class, (String)"PaypalManagerTopComponent.searchButton.text"));
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PaypalManagerTopComponent.this.searchButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.createOrderButton, (String)NbBundle.getMessage(PaypalManagerTopComponent.class, (String)"PaypalManagerTopComponent.createOrderButton.text"));
        this.createOrderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PaypalManagerTopComponent.this.createOrderButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.exclusivePaypal, (String)NbBundle.getMessage(PaypalManagerTopComponent.class, (String)"PaypalManagerTopComponent.exclusivePaypal.text"));
        this.filter.setModel(new DefaultComboBoxModel<String>(new String[]{"Unlinked", "Linked", "All"}));
        this.filter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PaypalManagerTopComponent.this.filterActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.updateLength, -2, 87, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.updateButton, -2, 87, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exclusivePaypal).addGap(121, 121, 121).addComponent(this.searchField, -2, 217, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 297, Short.MAX_VALUE).addComponent(this.createOrderButton)).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.refreshProgressBar, -2, 123, -2).addComponent(this.filter, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.updateLength, -2, -1, -2).addComponent(this.updateButton).addComponent(this.searchField, -2, -1, -2).addComponent(this.searchButton).addComponent(this.exclusivePaypal).addComponent(this.createOrderButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.refreshProgressBar, -2, 14, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.filter, -2, -1, -2)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(""));
        Mnemonics.setLocalizedText((AbstractButton)this.linkButton, (String)NbBundle.getMessage(PaypalManagerTopComponent.class, (String)"PaypalManagerTopComponent.linkButton.text"));
        this.linkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PaypalManagerTopComponent.this.linkButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.manualLinkButton, (String)NbBundle.getMessage(PaypalManagerTopComponent.class, (String)"PaypalManagerTopComponent.manualLinkButton.text"));
        this.manualLinkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PaypalManagerTopComponent.this.manualLinkButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.deleteButton, (String)NbBundle.getMessage(PaypalManagerTopComponent.class, (String)"PaypalManagerTopComponent.deleteButton.text"));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PaypalManagerTopComponent.this.deleteButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.linkProgressBar, -1, -1, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.linkButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.manualLinkButton))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 307, Short.MAX_VALUE).addComponent(this.deleteButton).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.deleteButton).addComponent(this.linkButton).addComponent(this.manualLinkButton)).addGap(18, 18, 18).addComponent(this.linkProgressBar, -2, 24, -2).addContainerGap(52, Short.MAX_VALUE)));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent((Component)this.formattedPaypalDetailsTable, -2, 582, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)).addComponent((Component)this.formattedPaypalTable, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.formattedPaypalTable, -1, 345, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent((Component)this.formattedPaypalDetailsTable, -2, 0, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
    }

    private void manualLinkButtonActionPerformed(ActionEvent evt) {
        this.tableListener = false;
        int currentSelected = 0;
        HashMap<String, String> orderCheck = new HashMap<String, String>();
        for (int row : this.formattedPaypalTable.getFormattedTable().getSelectedRows()) {
            String value = this.formattedPaypalTable.getValue(row, "Paypal Transaction ID");
            if (value == null || value.toString().isEmpty()) continue;
            if (value.toString().contains("-")) {
                value = value.toString().substring(0, value.toString().lastIndexOf("-"));
            }
            if (orderCheck.containsKey((value = value.toString().trim()).toString())) continue;
            orderCheck.put(value.toString(), value.toString());
        }
        int totalSelected = orderCheck.size();
        for (String transactionID : orderCheck.keySet()) {
            ++currentSelected;
            if (this.detailList.containsKey(transactionID)) {
                PaypalDetails detail;
                if (!this._multiLink || (detail = this.detailList.get(transactionID)).isLinked()) continue;
                String title = "Order Selection (" + currentSelected + " / " + totalSelected + ") " + "- " + detail.getFirstName() + " " + detail.getLastName();
                OrderManagerSelectionForm.getInstance().createLists(detail, title);
                this._multiLink = OrderManagerSelectionForm.getInstance().isMultiLink();
                continue;
            }
            JOptionPane.showMessageDialog(null, "Error retrieving paypal details");
        }
        this._multiLink = true;
        this.tableListener = true;
        this.updatePaypalOrders(null);
        ListenerManager.getInstance().notify((GenericListener)ListenerManager.TRANSACTION_LISTENER);
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        this.tableListener = false;
        HashSet<String> TransactionIDs = new HashSet<String>();
        for (int row : this.formattedPaypalTable.getFormattedTable().getSelectedRows()) {
            String value = this.formattedPaypalTable.getValue(row, "Paypal Transaction ID");
            if (value == null || value.toString().contains("-")) continue;
            TransactionIDs.add(value.toString());
        }
        for (String transactionID : TransactionIDs) {
            LookupServicesUtil.getDBServices().deletePaypalTransaction(transactionID);
        }
        this.tableListener = true;
        this.updatePaypalOrders(null);
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        if (!this.searchField.getText().isEmpty()) {
            this.updatePaypalOrders(LookupServicesUtil.getDBServices().searchPaypalOrders(this.searchField.getText().trim()));
        } else {
            this.updatePaypalOrders(null);
        }
    }

    private void searchFieldKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            if (!this.searchField.getText().isEmpty()) {
                this.updatePaypalOrders(LookupServicesUtil.getDBServices().searchPaypalOrders(this.searchField.getText().trim()));
            } else {
                this.updatePaypalOrders(null);
            }
        }
    }

    private void linkButtonActionPerformed(ActionEvent evt) {
        if (!this.isLinkPending()) {
            this.linkOrders();
        } else {
            JOptionPane.showMessageDialog(null, "Link already underway, please wait until it is finished.");
        }
    }

    private void updateButtonActionPerformed(ActionEvent evt) {
        if (!LookupServicesUtil.getPaypalServices().updatePending() && !LookupServicesUtil.getEbayServices().updatePending()) {
            this.createRange((String)this.updateLength.getSelectedItem());
            this.refreshProgressBar.setVisible(true);
            this.refreshProgressBar.setValue(0);
            this.refreshProgressBar.setString("Gathering first batch..");
            this.refreshProgressBar.setStringPainted(true);
            LookupServicesUtil.getPaypalServices().transactionSearch(this.startDate, this.endDate);
            if (!this.exclusivePaypal.isSelected()) {
                if (SubscriptionManager.getInstance().isWebsiteActive()) {
                    LookupServicesUtil.getRESTHandlerServices().getWebsiteTransactions();
                }
                if (SubscriptionManager.getInstance().isCurrent()) {
                    if (!SubscriptionManager.getInstance().getEbayAccounts().isEmpty()) {
                        LookupServicesUtil.getEbayServices().refreshTransactions((String)this.updateLength.getSelectedItem());
                    } else {
                        Preferences.getInstance().openTab(Preferences.Index.Ebay);
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "Your susbcription to Order Manager has expired. Order Manager is unavailable for refresh.");
                }
            }
        } else if (LookupServicesUtil.getPaypalServices().updatePending()) {
            JOptionPane.showMessageDialog(null, "Update already underway, please wait until it is finished.");
        } else {
            JOptionPane.showMessageDialog(null, "Refresh already underway, please wait until it is finished.");
        }
    }

    private void createOrder(PaypalDetails detail) {
        Customer customer = null;
        String userName = detail.getBuyerID();
        if (userName != null && !userName.isEmpty()) {
            customer = LookupServicesUtil.getDBServices().getCustomerByUsername(userName);
        }
        if (customer == null && ((customer = LookupServicesUtil.getDBServices().getCustomerByUsername(detail.getEmail())) != null || userName == null || userName.isEmpty())) {
            userName = detail.getEmail();
        }
        if (userName != null && !userName.isEmpty()) {
            if (customer == null) {
                customer = new Customer();
                customer.setCustomerAddress(detail.getStreet1() + " " + detail.getStreet2());
                customer.setCustomerCity(detail.getCityName());
                customer.setCustomerComments("");
                customer.setCustomerCountry(detail.getCountryName());
                customer.setCustomerEmail(detail.getEmail());
                customer.setCustomerName(detail.getFirstName() + " " + detail.getLastName());
                customer.setCustomerState(detail.getStateOrProvince());
                customer.setCustomerUserName(userName);
                customer.setCustomerZipcode(detail.getPostalCode());
            }
            CompleteOrder completeOrder = new CompleteOrder();
            Order order = new Order();
            ArrayList<OrderDetails> orderDetailsList = new ArrayList<OrderDetails>();
            order.setCustomer(customer);
            order.setOrderDate(new Date(System.currentTimeMillis()));
            order.setShippingCost(0.0f);
            order.setShippingPaid(detail.getShippingAmount().floatValue());
            order.setOrderTotal(detail.getGrossAmount().floatValue() - detail.getShippingAmount().floatValue());
            order.setShippingMethodName("Standard");
            order.setOrderComments("\nTRANSACTIONID: [" + detail.getPaypalTransactionID() + "] " + (detail.getMemo() == null || detail.getMemo().isEmpty() ? "" : "Notes: " + detail.getMemo()));
            order.setOrderStatus(this._statusList.get("Pending Print"));
            if (detail.getEbayItems() != null && !detail.getEbayItems().isEmpty()) {
                for (EbayTransactions transaction : detail.getEbayItems()) {
                    for (int i = 0; i < transaction.getQuantity(); ++i) {
                        OrderDetails orderDetails = new OrderDetails();
                        orderDetails.setSalesPrice(transaction.getCost().floatValue());
                        orderDetails.setOrderDescription(transaction.getAuctionName());
                        orderDetails.setOrderNumber(transaction.getReferenceNumber());
                        orderDetails.setTransactionID(transaction.getEbayTransactionID());
                        orderDetails.setAccountName("PAYPAL");
                        orderDetailsList.add(orderDetails);
                    }
                }
            } else {
                OrderDetails orderDetails = new OrderDetails();
                orderDetails.setTransactionID(UUID.randomUUID().toString());
                orderDetails.setAccountName("PAYPAL");
                orderDetailsList.add(orderDetails);
            }
            completeOrder.setOrder(order);
            completeOrder.setOrderDetails(orderDetailsList);
            LookupServicesUtil.getDBServices().updateOrder(completeOrder);
            detail.setBuyerID(userName);
            detail.setLinked(true);
            LookupServicesUtil.getDBServices().setPaypalLinked(detail);
            ListenerManager.getInstance().notify((GenericListener)ListenerManager.TRANSACTION_LISTENER);
            JOptionPane.showMessageDialog(null, "Order for: " + detail.getPaypalTransactionID() + " created.");
        } else {
            JOptionPane.showMessageDialog(null, "Not enough information to create an order for " + detail.getPaypalTransactionID() + ". Manual creation will be necessary.");
        }
    }

    private void createOrderButtonActionPerformed(ActionEvent evt) {
        for (int row : this.formattedPaypalTable.getFormattedTable().getSelectedRows()) {
            String value = this.formattedPaypalTable.getValue(row, "Paypal Transaction ID");
            PaypalDetails detail = this.detailList.get(value.toString());
            if (detail == null) continue;
            if (!detail.isLinked()) {
                this.createOrder(detail);
                continue;
            }
            JOptionPane.showMessageDialog(null, "Cannot create order for transaction: " + detail.getPaypalTransactionID() + ". Already linked.");
        }
        this.updatePaypalOrders(null);
    }

    private void filterActionPerformed(ActionEvent evt) {
        this.updatePaypalOrders(null);
    }

    private void doProgress(String opener, int max) {
        this.linkProgressBar.setVisible(true);
        this.linkProgressBar.setValue(0);
        this.linkProgressBar.setString(opener);
        this.linkProgressBar.setStringPainted(true);
        this.totalProgress = max;
        this.currentProgress = 0;
        this.linkPending = true;
    }

    private void updateProgress() {
        ++this.currentProgress;
        double progressUpdate = (double)this.currentProgress / (double)this.totalProgress;
        this.linkProgressBar.setValue((int)(progressUpdate * 100.0));
        this.linkProgressBar.setString(this.currentProgress + " / " + this.totalProgress);
        if (this.currentProgress == this.totalProgress) {
            this.stopProgress(false);
        }
    }

    private void stopProgress(boolean error) {
        if (error) {
            JOptionPane.showMessageDialog(null, "Something went wrong..");
        }
        this.linkPending = false;
        this.linkProgressBar.setValue(100);
        this.linkProgressBar.setString("Update Complete.");
        this.linkProgressBar.setVisible(false);
        this.updatePaypalOrders(null);
    }

    public void linkOrders() {
        this.tableListener = false;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    PaypalManagerTopComponent.this.linker();
                }
                catch (Exception ex) {
                    ErrorsUtil.getInstance().logError(ex);
                }
            }
        }).start();
        this.tableListener = true;
    }

    private ArrayList<PaypalDetails> disinfect(ArrayList<PaypalDetails> details) {
        ArrayList<PaypalDetails> disinfectedDetails = new ArrayList<PaypalDetails>();
        for (PaypalDetails detail : details) {
            if (detail.isLinked() || detail.getTransactionType().equalsIgnoreCase("send-money") || !detail.getPaymentStatus().equalsIgnoreCase("Completed") && !detail.getPaymentStatus().equalsIgnoreCase("Pending") || !this.checkFilteredEmails(detail)) continue;
            disinfectedDetails.add(detail);
        }
        return disinfectedDetails;
    }

    private void findUnlinkedOrders(HashMap<String, CompleteOrder> unlinkedOrders, HashMap<Integer, CompleteOrder> orders) {
        for (CompleteOrder completeOrder : orders.values()) {
            for (OrderDetails orderDetails : completeOrder.getOrderDetails()) {
                unlinkedOrders.put(orderDetails.getTransactionID(), completeOrder);
            }
        }
    }

    private boolean matchEbayTransactions(HashMap<String, CompleteOrder> unlinkedOrders, HashMap<String, CompleteOrder> unlinkedOrdersByReference, PaypalDetails detail) {
        float epsilon = 0.1f;
        boolean matchedTransaction = true;
        float totalPrice = 0.0f;
        float totalShipping = 0.0f;
        HashMap<CompleteOrder, CompleteOrder> matchedOrders = new HashMap<CompleteOrder, CompleteOrder>();
        if (detail.getEbayItems() != null && !detail.getEbayItems().isEmpty()) {
            for (EbayTransactions ebayTransaction : detail.getEbayItems()) {
                if (unlinkedOrders.containsKey(ebayTransaction.getEbayTransactionID())) {
                    matchedOrders.put(unlinkedOrders.get(ebayTransaction.getEbayTransactionID()), unlinkedOrders.get(ebayTransaction.getEbayTransactionID()));
                    continue;
                }
                if (ebayTransaction.getEbayTransactionID().equalsIgnoreCase(ebayTransaction.getReferenceNumber()) && unlinkedOrdersByReference.containsKey(ebayTransaction.getReferenceNumber())) {
                    matchedOrders.put(unlinkedOrdersByReference.get(ebayTransaction.getReferenceNumber()), unlinkedOrdersByReference.get(ebayTransaction.getReferenceNumber()));
                    continue;
                }
                matchedTransaction = false;
                break;
            }
        } else {
            matchedTransaction = false;
        }
        if (matchedTransaction) {
            for (CompleteOrder completeOrder : matchedOrders.keySet()) {
                totalPrice += completeOrder.getOrder().getOrderTotal();
                totalShipping += completeOrder.getOrder().getShippingPaid();
            }
            if (Math.abs(totalPrice + totalShipping - (detail.getGrossAmount().floatValue() - detail.getTax().floatValue())) > epsilon) {
                if (Math.abs(totalPrice - (detail.getGrossAmount().floatValue() - detail.getTax().floatValue() - detail.getShippingAmount().floatValue())) > epsilon) {
                    matchedTransaction = false;
                } else if (totalShipping - detail.getShippingAmount().floatValue() > epsilon) {
                    matchedTransaction = false;
                }
            }
        }
        if (matchedTransaction) {
            this.changeOrders(this.mergeOrders(matchedOrders.keySet(), detail), detail);
        }
        return matchedTransaction;
    }

    private String cleanseStreet(String street) {
        if (street != null) {
            street = street.toLowerCase();
            street = street.replace(",", "");
            street = street.replace(".", "");
            street = street.replace("street", "st");
            street = street.replace("lane", "ln");
            street = street.replace("drive", "dr");
            street = street.replace("road", "rd");
            street = street.replace("avenue", "ave");
            street = street.replace("apartment", "apt");
            street = street.replace("boulevard", "blvd");
            street = street.replace("east", "e");
            street = street.replace("south", "s");
            street = street.replace("north", "n");
            street = street.replace("west", "w");
            street = street.replace("suite", "ste");
            street = street.replace(" ", "");
        }
        return street;
    }

    public void changeOrders(CompleteOrder completeOrder, PaypalDetails detail) {
        detail.setLinked(true);
        LookupServicesUtil.getDBServices().setPaypalLinked(detail);
        String newComments = "\nTRANSACTIONID: [" + detail.getPaypalTransactionID() + "] " + (detail.getMemo() == null || detail.getMemo().isEmpty() ? "" : "Notes: " + detail.getMemo()) + (this.cleanseStreet(detail.getStreet1() + " " + detail.getStreet2()).equalsIgnoreCase(this.cleanseStreet(completeOrder.getOrder().getCustomer().getCustomerAddress())) ? "" : "\nPaypal Address: " + detail.getStreet1() + " " + detail.getStreet2() + ", " + detail.getCityName() + ", " + detail.getStateOrProvince() + " " + detail.getPostalCode());
        completeOrder.getOrder().setOrderComments(LookupServicesUtil.getDBServices().combineComments(completeOrder.getOrder().getOrderComments(), newComments));
        if (!completeOrder.getOrder().getOrderStatus().getOrderStatusType().equalsIgnoreCase("Complete")) {
            if (detail.getPaymentStatus().equalsIgnoreCase("Pending") && detail.getPaymentType().equalsIgnoreCase("echeck")) {
                completeOrder.getOrder().setOrderStatus(this._statusList.get("Pending E-Check"));
            } else if (detail.getPaymentStatus().equalsIgnoreCase("Completed") && !completeOrder.getOrder().getOrderStatus().getOrderStatusType().equalsIgnoreCase("Export Labels")) {
                completeOrder.getOrder().setOrderStatus(this._statusList.get("Pending Print"));
            }
        }
        if (completeOrder.getOrder().getShippingMethodName() == null || completeOrder.getOrder().getShippingMethodName().isEmpty()) {
            LookupServicesUtil.getEbayServices().refreshShipping(completeOrder);
        }
        if (completeOrder.getOrder().getShippingPaid() <= detail.getShippingAmount().floatValue()) {
            completeOrder.getOrder().setShippingPaid(detail.getShippingAmount().floatValue());
        }
        if (detail.getPaypalAccount() == null || detail.getPaypalAccount().trim().isEmpty()) {
            detail.setPaypalAccount("Default");
        }
        completeOrder.getOrder().setPaypalAccount(Preferences.getInstance().getAccountPreferences().getCompanyName(detail.getPaypalAccount().trim()));
        LookupServicesUtil.getDBServices().updateOrder(completeOrder);
    }

    public CompleteOrder mergeOrders(Set<CompleteOrder> matchedOrders, PaypalDetails detail) {
        CompleteOrder parentOrder = LookupServicesUtil.getDBServices().mergeOrders(new ArrayList<CompleteOrder>(matchedOrders));
        if (parentOrder.getOrder().getShippingPaid() < detail.getShippingAmount().floatValue()) {
            parentOrder.getOrder().setShippingPaid(detail.getShippingAmount().floatValue());
        }
        return parentOrder;
    }

    public HashMap<String, CompleteOrder> createUnlinkedOrderList() {
        java.util.Date date = new java.util.Date();
        Long endMilli = date.getTime();
        date.setDate(date.getDate() - 4);
        Long startMilli = date.getTime();
        HashMap<String, CompleteOrder> unlinkedOrders = new HashMap<String, CompleteOrder>();
        this.findUnlinkedOrders(unlinkedOrders, LookupServicesUtil.getDBServices().getBaseOrders());
        this.findUnlinkedOrders(unlinkedOrders, LookupServicesUtil.getDBServices().getCompletedOrders(startMilli.longValue(), endMilli.longValue()));
        return unlinkedOrders;
    }

    private HashMap<String, CompleteOrder> createUnlinkedOrderListByReference(HashMap<String, CompleteOrder> unlinkedOrders) {
        HashMap<String, CompleteOrder> unlinkedOrdersByReference = new HashMap<String, CompleteOrder>();
        for (CompleteOrder completeOrder : unlinkedOrders.values()) {
            for (OrderDetails orderDetails : completeOrder.getOrderDetails()) {
                unlinkedOrdersByReference.put(orderDetails.getOrderNumber(), completeOrder);
            }
        }
        return unlinkedOrdersByReference;
    }

    public void linker() {
        this.doProgress("Collecting paypal transactions..", 0);
        ArrayList<PaypalDetails> paypalDetails = this.disinfect(LookupServicesUtil.getDBServices().getPaypalDetails(FilterOptions.unlinked.name()));
        this.doProgress("Gathering unlinked orders..", paypalDetails.size());
        HashMap<String, CompleteOrder> unlinkedOrders = this.createUnlinkedOrderList();
        HashMap<String, CompleteOrder> unlinkedOrdersByReference = this.createUnlinkedOrderListByReference(unlinkedOrders);
        this.doProgress("Parsing list..", paypalDetails.size());
        for (PaypalDetails detail : paypalDetails) {
            this.matchEbayTransactions(unlinkedOrders, unlinkedOrdersByReference, detail);
            this.updateProgress();
        }
        if (paypalDetails.isEmpty()) {
            this.stopProgress(false);
        }
        LookupServicesUtil.getDBServices().getOrderList(false);
        ListenerManager.getInstance().notify((GenericListener)ListenerManager.TRANSACTION_LISTENER);
    }

    public static synchronized PaypalManagerTopComponent findInstance() {
        if (instance == null) {
            instance = new PaypalManagerTopComponent();
        }
        return instance;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    Object readProperties(Properties p) {
        if (instance == null) {
            instance = this;
        }
        instance.readPropertiesImpl(p);
        return instance;
    }

    private void readPropertiesImpl(Properties p) {
        String version = p.getProperty("version");
    }

    public boolean isLinkPending() {
        return this.linkPending;
    }

    public void setLinkPending(boolean linkPending) {
        this.linkPending = linkPending;
    }

    public int[] getItemsProjected() {
        return this.itemsProjected;
    }

    public void setItemsProjected(int[] itemsProjected) {
        this.itemsProjected = itemsProjected;
    }

    public void paypalProgressUpdate() {
        if (LookupServicesUtil.getPaypalServices().updatePending()) {
            int[] projection = LookupServicesUtil.getPaypalServices().getItemsProjected();
            if (projection[1] != 0) {
                double progressBarPercent = (double)projection[0] / (double)projection[1] * 100.0;
                this.refreshProgressBar.setValue((int)progressBarPercent);
                this.refreshProgressBar.setString(projection[0] + " / " + projection[1]);
                this.refreshProgressBar.setVisible(true);
                this.refreshProgressBar.setStringPainted(true);
            }
        } else {
            this.refreshProgressBar.setValue(100);
            this.refreshProgressBar.setString("Update Complete.");
            this.refreshProgressBar.setVisible(false);
            this.updatePaypalOrders(null);
        }
        this.autoLink();
    }

    private void autoLink() {
        if (LookupServicesUtil.getDBServices().getAccountPreferences().isPaypalAutoLink()) {
            int currProgress = 0;
            int currMax = 0;
            int paypalCurrent = 0;
            int paypalMax = 0;
            int ebayCurrent = (int)LookupServicesUtil.getEbayServices().getUpdatePercentage();
            if (LookupServicesUtil.getPaypalServices().getItemsProjected().length == 2) {
                paypalCurrent = LookupServicesUtil.getPaypalServices().getItemsProjected()[0];
                paypalMax = LookupServicesUtil.getPaypalServices().getItemsProjected()[1];
            }
            if (LookupServicesUtil.getEbayServices().updatePending() && LookupServicesUtil.getPaypalServices().updatePending()) {
                this.doProgress("Waiting on both updates to finish", paypalMax * 2);
                currProgress = paypalCurrent + (int)((double)paypalMax * ((double)ebayCurrent / 100.0));
                currMax = paypalMax * 2;
            } else if (LookupServicesUtil.getEbayServices().updatePending() && !LookupServicesUtil.getPaypalServices().updatePending()) {
                this.doProgress("Waiting on Order Manager to finish updating", 100);
                currProgress = ebayCurrent;
                currMax = 100;
            } else if (!LookupServicesUtil.getEbayServices().updatePending() && LookupServicesUtil.getPaypalServices().updatePending()) {
                this.doProgress("Waiting on Paypal Manager to finish updating", paypalMax);
                currProgress = paypalCurrent;
                currMax = paypalMax;
            }
            if (currMax != 0) {
                this.linkProgressBar.setValue((int)((double)currProgress / (double)currMax * 100.0));
            }
            if (!LookupServicesUtil.getEbayServices().updatePending() && !LookupServicesUtil.getPaypalServices().updatePending()) {
                this.linkOrders();
            }
        } else if (!this.linkProgressBar.getString().equalsIgnoreCase("Update Complete.")) {
            this.stopProgress(false);
        }
    }

    public boolean isMultiLink() {
        return this._multiLink;
    }

    public void setMultiLink(boolean _multiLink) {
        this._multiLink = _multiLink;
    }

    public void LoginToggle() {
        if (SubscriptionManager.getInstance().isPaypalActive()) {
            if (!this.currentStatus) {
                this.currentStatus = true;
                this.enableAll();
            }
        } else if (this.currentStatus) {
            this.currentStatus = false;
            this.disableAll();
        }
    }

    private void disablePanel(JPanel jPanel) {
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            jPanel.getComponent(i).setEnabled(false);
        }
    }

    private void enablePanel(JPanel jPanel) {
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            jPanel.getComponent(i).setEnabled(true);
        }
    }

    private void enableAll() {
        this.enablePanel(this.jPanel1);
        this.enablePanel(this.jPanel2);
        this.enablePanel(this.jPanel3);
        this.formattedPaypalTable.getFormattedTable().setEnabled(true);
        this.formattedPaypalDetailsTable.getFormattedTable().setEnabled(true);
    }

    public void disableAll() {
        this.disablePanel(this.jPanel1);
        this.disablePanel(this.jPanel2);
        this.disablePanel(this.jPanel3);
        this.formattedPaypalTable.getFormattedTable().setEnabled(false);
        this.formattedPaypalDetailsTable.getFormattedTable().setEnabled(false);
    }

    public void updateStatus() {
        this.autoLink();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.tableListener) {
            this.tableListener = false;
            try {
                int row = this.formattedPaypalTable.getFormattedTable().convertRowIndexToView(e.getFirstRow());
                String paypalTxnID = this.formattedPaypalTable.getValue(row, "Paypal Transaction ID");
                if (this.detailList.containsKey(paypalTxnID)) {
                    PaypalDetails paypalDetail = this.detailList.get(paypalTxnID);
                    this.revertRow(paypalDetail, row, paypalTxnID);
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
            this.tableListener = true;
        }
    }

    private void revertRow(PaypalDetails paypalDetail, int row, String paypalTxnID) {
        this.formattedPaypalTable.setValue((Object)paypalTxnID, row, "Paypal Transaction ID");
        this.formattedPaypalTable.setValue((Object)paypalDetail.getEmail(), row, "Email");
        this.formattedPaypalTable.setValue((Object)paypalDetail.getFirstName(), row, "First Name");
        this.formattedPaypalTable.setValue((Object)paypalDetail.getLastName(), row, "Last Name");
        this.formattedPaypalTable.setValue((Object)paypalDetail.getCountryCode(), row, "Country Code");
        this.formattedPaypalTable.setValue((Object)paypalDetail.getCountryName(), row, "Country");
        this.formattedPaypalTable.setValue((Object)paypalDetail.getStreet1(), row, "Street1");
        this.formattedPaypalTable.setValue((Object)paypalDetail.getStreet2(), row, "Street2");
        this.formattedPaypalTable.setValue((Object)paypalDetail.getCityName(), row, "City");
        this.formattedPaypalTable.setValue((Object)paypalDetail.getStateOrProvince(), row, "State");
        this.formattedPaypalTable.setValue((Object)paypalDetail.getPostalCode(), row, "Postal Code");
        this.formattedPaypalTable.setValue((Object)paypalDetail.getTransactionType(), row, "Transaction Type");
        this.formattedPaypalTable.setValue((Object)paypalDetail.getPaymentType(), row, "Payment Type");
        this.formattedPaypalTable.setValue((Object)paypalDetail.getPaymentDate(), row, "Payment Date");
        this.formattedPaypalTable.setValue((Object)paypalDetail.getGrossAmount(), row, "Gross Amount");
        this.formattedPaypalTable.setValue((Object)paypalDetail.getPaymentStatus(), row, "Payment Status");
        this.formattedPaypalTable.setValue((Object)paypalDetail.getShippingAmount(), row, "Shipping Method");
        this.formattedPaypalTable.setValue((Object)paypalDetail.getCustom(), row, "Custom");
        this.formattedPaypalTable.setValue((Object)paypalDetail.getMemo(), row, "Memo");
        this.formattedPaypalTable.setValue((Object)paypalDetail.getBuyerID(), row, "Buyer ID");
        this.formattedPaypalTable.setValue((Object)paypalDetail.getClosingDate(), row, "Closing Date");
        this.formattedPaypalTable.setValue((Object)paypalDetail.getMultiItem(), row, "Multi Item");
        this.formattedPaypalTable.setValue((Object)paypalDetail.isLinked(), row, "Linked");
        this.formattedPaypalTable.setValue((Object)paypalDetail.getTax(), row, "Tax");
        this.formattedPaypalTable.setValue((Object)paypalDetail.getCountryCode(), row, "Currency Code");
        this.formattedPaypalTable.setValue((Object)paypalDetail.getShippingAmount(), row, "Shipping Amount");
        this.formattedPaypalTable.setValue((Object)paypalDetail.getPaypalAccount(), row, "PayPal Account");
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.tableListener && (e == null || !e.getValueIsAdjusting())) {
            this.tableListener = false;
            if (e == null) {
                this.formattedPaypalTable.getFormattedTable().clearSelection();
            }
            this.handleValueChanged();
            this.tableListener = true;
        }
    }

    private boolean handleButtons() {
        if (this.formattedPaypalTable.getFormattedTable().getSelectedRow() == -1) {
            this.manualLinkButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.createOrderButton.setEnabled(false);
            return false;
        }
        this.manualLinkButton.setEnabled(true);
        this.deleteButton.setEnabled(true);
        this.createOrderButton.setEnabled(true);
        return true;
    }

    private void handleValueChanged() {
        try {
            PaypalDetails detail = null;
            if (this.handleButtons()) {
                String value = this.formattedPaypalTable.getValue(this.formattedPaypalTable.getFormattedTable().getSelectedRow(), "Paypal Transaction ID");
                detail = this.detailList.get(value.toString());
            }
            this.refreshExtraDetails(detail);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private void refreshExtraDetails(PaypalDetails details) {
        this.skuListener = false;
        Object[] row = new Object[this.formattedPaypalDetailsTable.getTableModel().getColumnCount()];
        this.formattedPaypalDetailsTable.getTableModel().setRowCount(0);
        if (details != null) {
            if (details.getEbayItems() != null) {
                for (EbayTransactions transaction : details.getEbayItems()) {
                    row[((Integer)this.formattedPaypalDetailsTable.getReverseColumnMap().get((Object)"Ebay Transaction ID")).intValue()] = transaction.getEbayTransactionID();
                    row[((Integer)this.formattedPaypalDetailsTable.getReverseColumnMap().get((Object)"Auction Name")).intValue()] = transaction.getAuctionName();
                    row[((Integer)this.formattedPaypalDetailsTable.getReverseColumnMap().get((Object)"Quantity")).intValue()] = transaction.getQuantity();
                    row[((Integer)this.formattedPaypalDetailsTable.getReverseColumnMap().get((Object)"Cost")).intValue()] = transaction.getCost();
                    row[((Integer)this.formattedPaypalDetailsTable.getReverseColumnMap().get((Object)"ReferenceNumber")).intValue()] = transaction.getReferenceNumber();
                    this.formattedPaypalDetailsTable.getTableModel().addRow(row);
                }
            }
            this.formattedPaypalDetailsTable.getFormattedTable().packAll();
        }
        this.skuListener = true;
    }

    private boolean checkFilteredEmails(PaypalDetails detail) {
        String emailAddress = GenericFunctions.getInstance().prepareString(detail.getEmail()).toLowerCase().replace(" ", "");
        if (!emailAddress.isEmpty()) {
            return !Preferences.getInstance().getAccountPreferences().getPaypalFilterList().contains(emailAddress);
        }
        return true;
    }

    public static enum FilterOptions {
        linked,
        unlinked,
        all;

    }

    private class DetailModelListener
    implements TableModelListener {
        private DetailModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (PaypalManagerTopComponent.this.skuListener) {
                PaypalManagerTopComponent.this.skuListener = false;
                PaypalManagerTopComponent.this.handleValueChanged();
                PaypalManagerTopComponent.this.skuListener = true;
            }
        }
    }
}

