/*
 * Decompiled with CFR 0.152.
 */
package pnp.managers.printmanager;

import StampsSDK.ArrayOfCustomsLine;
import StampsSDK.ContentTypeV2;
import StampsSDK.CustomsLine;
import StampsSDK.CustomsV2;
import StampsSDK.NonDeliveryOption;
import StampsSDK.ServiceType;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import pnp.services.datatypes.PrintDetails;
import pnp.services.datatypes.SKUDetails;
import pnp.services.preferencemanager.Preferences;
import pnp.services.table.CellColorRenderer;
import pnp.services.table.FormattedXTable;
import pnp.services.util.ErrorsUtil;
import pnp.services.util.MathParser;

public class CustomsForm
extends JDialog
implements TableModelListener {
    private CustomsV2 customs;
    private Preferences _preferences;
    private DefaultTableModel customsTableModel;
    private DefaultTableModel skuTableModel;
    private int maxLines;
    private HashMap<Integer, CustomsLine> customLines;
    private boolean tableListener;
    private boolean skuListener;
    private PrintDetails printDetails;
    private CellColorRenderer renderer;
    Object description;
    Object quantity;
    Object value;
    Object weight;
    Object country;
    Object tariff;
    private JButton addLineButton;
    private JTextField address1Field;
    private JTextField address2Field;
    private JLabel addressLabel;
    private JLabel addressLabel1;
    private JButton cancelButton;
    private JTextField cityField;
    private JComboBox contentComboBox;
    private JTextField countryField;
    private JCheckBox declaredWeightBox;
    private JTextField declaredWeightField;
    private JButton deleteLineButton;
    private JTextField emailField;
    private JButton finishButton;
    private JTextField firstNameField;
    private FormattedXTable formattedLineTable;
    private FormattedXTable formattedSkuTable;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JTextField lastNameField;
    private JComboBox nonDeliveryComboBox;
    private JLabel otherDescription;
    private JTextField otherField;
    private JTextField packageField;
    private JTextField packedWeightField;
    private JTextField postalField;
    private JTextField shippingField;
    private JTextField stateField;
    private JTextField weightField;

    public JTextField getDeclaredWeightField() {
        return this.declaredWeightField;
    }

    public JCheckBox getDeclaredWeightBox() {
        return this.declaredWeightBox;
    }

    public void setDeclaredWeightBox(JCheckBox declaredWeightBox) {
        this.declaredWeightBox = declaredWeightBox;
    }

    public void setDeclaredWeightField(JTextField declaredWeightField) {
        this.declaredWeightField = declaredWeightField;
    }

    private void init() {
        this.skuListener = true;
        this.description = null;
        this.quantity = null;
        this.value = null;
        this.weight = null;
        this.country = null;
        this.tariff = null;
        this._preferences = Preferences.getInstance();
        this.otherField.setVisible(false);
        this.otherDescription.setVisible(false);
        this.customLines = new HashMap();
        this.tableListener = true;
        this.maxLines = 5;
        if (!this.printDetails.getShipping().equals(ServiceType.US_FCI)) {
            this.maxLines = 30;
        }
        this.formattedLineTable.init(new String[]{"Description", "Quantity", "Value", "Weight", "Country of Origin", "HS Tariff Number"}, "CustomsTable", null);
        this.customsTableModel = this.formattedLineTable.getTableModel();
        this.customsTableModel.addTableModelListener(this);
        this.renderer = this.formattedLineTable.getRenderer();
        this.formattedSkuTable.init(new String[]{"Sku", "Account", "Reference Number", "Title", "Location", "Weight", "Packed Weight", "Price"}, "CustomsSkuTable", null);
        this.skuTableModel = this.formattedSkuTable.getTableModel();
        this.skuTableModel.addTableModelListener(new SKUModelListener());
        this.gatherCustomerInformation(this.printDetails);
        this.createItemTable(this.printDetails);
        this.formattedLineTable.loadSavedSettings();
        this.formattedSkuTable.loadSavedSettings();
    }

    public CustomsForm(Frame parent, boolean modal, CustomsV2 customs, PrintDetails printDetails) {
        super(parent, modal);
        this.initComponents();
        this.setTitle(printDetails.getCustomer() + " - Customs Form");
        this.customs = customs;
        this.printDetails = printDetails;
        this.init();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel4 = new JPanel();
        this.cancelButton = new JButton();
        this.finishButton = new JButton();
        this.jPanel5 = new JPanel();
        this.contentComboBox = new JComboBox();
        this.otherDescription = new JLabel();
        this.jLabel1 = new JLabel();
        this.otherField = new JTextField();
        this.jLabel9 = new JLabel();
        this.nonDeliveryComboBox = new JComboBox();
        this.jPanel6 = new JPanel();
        this.addLineButton = new JButton();
        this.deleteLineButton = new JButton();
        this.formattedLineTable = new FormattedXTable();
        this.declaredWeightField = new JTextField();
        this.declaredWeightBox = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.formattedSkuTable = new FormattedXTable();
        this.jPanel3 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.addressLabel1 = new JLabel();
        this.addressLabel = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.firstNameField = new JTextField();
        this.lastNameField = new JTextField();
        this.emailField = new JTextField();
        this.address1Field = new JTextField();
        this.countryField = new JTextField();
        this.address2Field = new JTextField();
        this.cityField = new JTextField();
        this.stateField = new JTextField();
        this.postalField = new JTextField();
        this.weightField = new JTextField();
        this.packedWeightField = new JTextField();
        this.shippingField = new JTextField();
        this.packageField = new JTextField();
        this.setDefaultCloseOperation(2);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.jPanel1.border.title")));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.jPanel4.border.title")));
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.cancelButton.text"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomsForm.this.cancelButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.finishButton, (String)NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.finishButton.text"));
        this.finishButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomsForm.this.finishButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.finishButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.cancelButton)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.finishButton)));
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.jPanel5.border.title")));
        this.contentComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"RETURNED_GOODS", "OTHER", "HUMANITARIAN_DONATION", "GIFT", "DOCUMENT", "DANGEROUS_GOODS", "COMMERCIAL_SAMPLE", "MERCHANDISE"}));
        this.contentComboBox.setSelectedIndex(7);
        this.contentComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomsForm.this.contentComboBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.otherDescription, (String)NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.otherDescription.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.jLabel1.text"));
        this.otherField.setText(NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.otherField.text"));
        this.otherField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                CustomsForm.this.otherFieldKeyTyped(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.jLabel9.text"));
        this.nonDeliveryComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Return", "Abandon", "Redirect"}));
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.otherDescription).addContainerGap(-1, Short.MAX_VALUE)).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jLabel1).addGap(49, 49, 49).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.otherField).addComponent(this.contentComboBox, -2, 129, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel9).addGap(18, 18, 18).addComponent(this.nonDeliveryComboBox, -2, 104, -2).addGap(151, 151, 151)))));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.contentComboBox, -2, -1, -2).addComponent(this.jLabel9).addComponent(this.nonDeliveryComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.otherDescription).addComponent(this.otherField, -2, -1, -2))));
        this.jPanel6.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.jPanel6.border.title")));
        Mnemonics.setLocalizedText((AbstractButton)this.addLineButton, (String)NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.addLineButton.text"));
        this.addLineButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomsForm.this.addLineButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.deleteLineButton, (String)NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.deleteLineButton.text"));
        this.deleteLineButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomsForm.this.deleteLineButtonActionPerformed(evt);
            }
        });
        this.declaredWeightField.setEditable(false);
        this.declaredWeightField.setText(NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.declaredWeightField.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.declaredWeightBox, (String)NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.declaredWeightBox.text"));
        this.declaredWeightBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomsForm.this.declaredWeightBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.formattedLineTable, -1, -1, Short.MAX_VALUE).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.addLineButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteLineButton).addGap(57, 57, 57).addComponent(this.declaredWeightBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.declaredWeightField, -2, 47, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addLineButton).addComponent(this.deleteLineButton).addComponent(this.declaredWeightField, -2, -1, -2).addComponent(this.declaredWeightBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.formattedLineTable, -1, 169, Short.MAX_VALUE).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.jPanel2.border.title")));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent((Component)this.formattedSkuTable, -1, 806, Short.MAX_VALUE).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.formattedSkuTable, -2, 127, -2));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.jPanel3.border.title")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.jLabel2.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.jLabel3.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.jLabel4.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.jLabel5.text"));
        Mnemonics.setLocalizedText((JLabel)this.addressLabel1, (String)NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.addressLabel1.text"));
        Mnemonics.setLocalizedText((JLabel)this.addressLabel, (String)NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.addressLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.jLabel8.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel10, (String)NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.jLabel10.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel11, (String)NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.jLabel11.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel12, (String)NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.jLabel12.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel13, (String)NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.jLabel13.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel14, (String)NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.jLabel14.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel15, (String)NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.jLabel15.text"));
        this.firstNameField.setEditable(false);
        this.firstNameField.setText(NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.firstNameField.text"));
        this.lastNameField.setEditable(false);
        this.lastNameField.setText(NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.lastNameField.text"));
        this.emailField.setEditable(false);
        this.emailField.setText(NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.emailField.text"));
        this.address1Field.setEditable(false);
        this.address1Field.setText(NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.address1Field.text"));
        this.countryField.setEditable(false);
        this.countryField.setText(NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.countryField.text"));
        this.address2Field.setEditable(false);
        this.address2Field.setText(NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.address2Field.text"));
        this.cityField.setEditable(false);
        this.cityField.setText(NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.cityField.text"));
        this.stateField.setEditable(false);
        this.stateField.setText(NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.stateField.text"));
        this.postalField.setEditable(false);
        this.postalField.setText(NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.postalField.text"));
        this.weightField.setEditable(false);
        this.weightField.setText(NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.weightField.text"));
        this.packedWeightField.setEditable(false);
        this.packedWeightField.setText(NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.packedWeightField.text"));
        this.shippingField.setEditable(false);
        this.shippingField.setText(NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.shippingField.text"));
        this.packageField.setEditable(false);
        this.packageField.setText(NbBundle.getMessage(CustomsForm.class, (String)"CustomsForm.packageField.text"));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.jLabel5).addComponent(this.addressLabel1).addComponent(this.addressLabel)).addGap(29, 29, 29).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.emailField, -2, 130, -2).addComponent(this.lastNameField, -2, 130, -2).addComponent(this.firstNameField, -2, 130, -2).addComponent(this.countryField, -2, 30, -2).addComponent(this.address1Field, -1, 200, Short.MAX_VALUE).addComponent(this.address2Field)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8).addComponent(this.jLabel10).addComponent(this.jLabel11)).addGap(32, 32, 32).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cityField, -1, 130, Short.MAX_VALUE).addComponent(this.postalField, -2, 80, -2).addComponent(this.stateField))).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel13).addComponent(this.jLabel12)).addGap(18, 18, 18).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.packedWeightField, -2, 40, -2).addComponent(this.weightField, -2, 40, -2))).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel14).addComponent(this.jLabel15)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.shippingField, -2, 80, -2).addComponent(this.packageField, -2, 80, -2)))).addGap(146, 146, 146)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.firstNameField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.lastNameField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.emailField, -2, -1, -2))).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.cityField, -2, -1, -2)).addGap(6, 6, 6).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.stateField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.postalField, -2, -1, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.countryField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addressLabel1).addComponent(this.address1Field, -2, -1, -2))).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel12).addComponent(this.weightField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.packedWeightField, -2, -1, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addressLabel).addComponent(this.address2Field, -2, -1, -2).addComponent(this.jLabel14).addComponent(this.shippingField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel15).addComponent(this.packageField, -2, -1, -2)).addContainerGap(14, Short.MAX_VALUE)));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel4, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel5, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.customs = null;
        this.setVisible(false);
    }

    private void contentComboBoxActionPerformed(ActionEvent evt) {
        if (this.contentComboBox.getSelectedItem().equals("OTHER")) {
            this.otherField.setVisible(true);
            this.otherDescription.setVisible(true);
        } else {
            this.otherField.setBackground(Color.white);
            this.otherField.setText("");
            this.otherField.setVisible(false);
            this.otherDescription.setVisible(false);
        }
    }

    private void finishButtonActionPerformed(ActionEvent evt) {
        this.renderer.setVerified(false);
        if (this.verifyContents()) {
            this.renderer.setVerified(true);
            double calculatedWeight = 0.0;
            ArrayOfCustomsLine customsLines = new ArrayOfCustomsLine();
            for (int i = 0; i < this.formattedLineTable.getFormattedTable().getRowCount(); ++i) {
                CustomsLine customsLine = new CustomsLine();
                this.grabTableData(i);
                customsLine.setCountryOfOrigin((String)this.country);
                customsLine.setHSTariffNumber((String)this.tariff);
                customsLine.setDescription(this.description.toString());
                customsLine.setQuantity(Double.parseDouble(this.quantity.toString()));
                customsLine.setValue(new BigDecimal(this.value.toString()));
                customsLine.setWeightOz(Double.valueOf(Double.parseDouble(this.weight.toString())));
                calculatedWeight += customsLine.getWeightOz().doubleValue();
                customsLines.getCustomsLine().add(customsLine);
            }
            Double baseWeight = this.printDetails.getWeight();
            if (this._preferences.getAccountPreferences().isStampsPackedWeight()) {
                baseWeight = this.printDetails.getPackedWeight();
            }
            double declaredWeight = 0.0;
            try {
                declaredWeight = Math.ceil((double)Math.round(Double.parseDouble(this.declaredWeightField.getText()) * 100.0) / 100.0);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
            this.declaredWeightField.setText(String.valueOf(declaredWeight));
            if (declaredWeight < calculatedWeight) {
                JOptionPane.showMessageDialog(null, "The declared weight cannot be less than the individual line items. Defaulting to calculated line item weight.");
                declaredWeight = Math.ceil((double)Math.round(calculatedWeight * 100.0) / 100.0);
                this.declaredWeightField.setText(String.valueOf(declaredWeight));
            }
            if (customsLines.getCustomsLine().size() > 0 && (Math.abs(baseWeight - declaredWeight) <= (double)0.001f || 0 == JOptionPane.showConfirmDialog(null, "Original weight: " + baseWeight + "\nNew Weight: " + declaredWeight + "\n" + "Would you like to continue with this new weight?", "Declared Weight", 0))) {
                this.customs.setContentType(ContentTypeV2.valueOf((String)((String)this.contentComboBox.getSelectedItem())));
                if (this.contentComboBox.getSelectedItem().equals("OTHER")) {
                    this.customs.setOtherDescribe(this.otherField.getText());
                }
                this.customs.setCustomsLines(customsLines);
                this.printDetails.setNonDelivery(NonDeliveryOption.fromValue((String)this.nonDeliveryComboBox.getSelectedItem().toString()));
                this.setVisible(false);
            } else {
                JOptionPane.showMessageDialog(null, "Customs forms are required to have at least one item.");
            }
        }
    }

    private void addLineButtonActionPerformed(ActionEvent evt) {
        this.addLine("", 1.0, BigDecimal.ZERO.doubleValue(), 1.0, null, null);
    }

    private void deleteLineButtonActionPerformed(ActionEvent evt) {
        this.deleteLine();
    }

    private void otherFieldKeyTyped(KeyEvent evt) {
        if (this.otherField.getText().length() > 19) {
            this.otherField.setText(this.otherField.getText().substring(0, 19));
        }
    }

    private void declaredWeightBoxActionPerformed(ActionEvent evt) {
        this.declaredWeightField.setEditable(this.declaredWeightBox.isSelected());
        this.getDeclaredValue();
    }

    private Object createDollarAmount(Object value) {
        if ((value = MathParser.isDollarAmount((String)value.toString())) != null) {
            value = Double.parseDouble(value.toString());
        }
        if (value == null) {
            value = Float.valueOf(0.0f);
        }
        return value;
    }

    private void cleanseValues() {
        if (null == this.description || this.description.toString().isEmpty()) {
            this.description = "";
        } else if (this.description.toString().length() > 50) {
            this.description = this.description.toString().substring(0, 50);
        }
        if (null == this.quantity || this.quantity.toString().isEmpty()) {
            this.quantity = 1.0;
        } else {
            try {
                this.quantity = this.createDollarAmount(this.quantity.toString());
                if (Double.parseDouble(this.quantity.toString()) < 1.0) {
                    this.quantity = 1.0;
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
                this.quantity = 1.0;
            }
        }
        if (null == this.value || this.value.toString().isEmpty()) {
            this.value = BigDecimal.ONE;
        } else {
            try {
                this.value = this.createDollarAmount(this.value.toString());
                this.value = Double.parseDouble(this.value.toString()) < 1.0 ? BigDecimal.ONE : new BigDecimal(this.value.toString());
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
                this.value = BigDecimal.ONE;
            }
        }
        if (null == this.weight || this.weight.toString().isEmpty()) {
            this.weight = 1.0;
        } else {
            try {
                this.weight = this.createDollarAmount(this.weight.toString());
                if (Double.parseDouble(this.weight.toString()) < 1.0) {
                    this.weight = 1.0;
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
                this.weight = 1.0;
            }
        }
        if (null == this.country || this.country.toString().isEmpty()) {
            this.country = null;
        }
        if (null == this.tariff || this.tariff.toString().isEmpty()) {
            this.tariff = null;
        }
        this.quantity = Math.ceil((double)Math.round(Double.parseDouble(this.quantity.toString()) * 100.0) / 100.0);
        this.weight = (double)Math.round(Double.parseDouble(this.weight.toString()) * 100.0) / 100.0;
        this.value = (double)Math.round(Double.parseDouble(this.value.toString()) * 100.0) / 100.0;
    }

    private void grabTableData(int row) {
        this.description = this.formattedLineTable.getValue(row, "Description");
        this.quantity = this.formattedLineTable.getValue(row, "Quantity");
        this.value = this.formattedLineTable.getValue(row, "Value");
        this.weight = this.formattedLineTable.getValue(row, "Weight");
        this.country = this.formattedLineTable.getValue(row, "Country of Origin");
        this.tariff = this.formattedLineTable.getValue(row, "HS Tariff Number");
    }

    private void setTableData(int row) {
        this.formattedLineTable.setValue(this.description, row, "Description");
        this.formattedLineTable.setValue(this.quantity, row, "Quantity");
        this.formattedLineTable.setValue(this.value, row, "Value");
        this.formattedLineTable.setValue((Object)Double.parseDouble(this.weight.toString()), row, "Weight");
        this.formattedLineTable.setValue(this.country, row, "Country of Origin");
        this.formattedLineTable.setValue(this.tariff, row, "HS Tariff Number");
    }

    private void getDeclaredValue() {
        if (!this.declaredWeightBox.isSelected()) {
            double declaredValue = 0.0;
            try {
                for (int i = 0; i < this.formattedLineTable.getFormattedTable().getRowCount(); ++i) {
                    declaredValue += Double.parseDouble(this.formattedLineTable.getValue(i, "Weight").toString());
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
                declaredValue = 0.0;
            }
            declaredValue = Math.ceil((double)Math.round(Double.parseDouble(String.valueOf(declaredValue)) * 100.0) / 100.0);
            this.declaredWeightField.setText(String.valueOf(declaredValue));
        }
    }

    private void handleTableChanged() {
        int row = this.formattedLineTable.getFormattedTable().getSelectedRow();
        if (row >= 0) {
            this.grabTableData(row);
            this.cleanseValues();
            this.setTableData(row);
            this.getDeclaredValue();
        }
    }

    public boolean verifyContents() {
        this.formattedLineTable.getFormattedTable().setEditingRow(-1);
        this.tableChanged(new TableModelEvent(this.customsTableModel));
        boolean verified = true;
        for (int i = 0; i < this.formattedLineTable.getFormattedTable().getRowCount(); ++i) {
            this.description = this.formattedLineTable.getValue(i, "Description");
            if (this.description != null && !this.description.toString().isEmpty()) continue;
            verified = false;
        }
        this.customsTableModel.fireTableDataChanged();
        return verified;
    }

    private void deleteLine() {
        this.tableListener = false;
        int[] selectedRows = this.formattedLineTable.getFormattedTable().getSelectedRows();
        for (int i = selectedRows.length - 1; i >= 0; --i) {
            this.customsTableModel.removeRow(this.formattedLineTable.convertRow(selectedRows[i]));
        }
        this.getDeclaredValue();
        this.tableListener = true;
    }

    public void addLine(String description, Double quantity, Double value, Double weight, String country, String tariff) {
        this.description = description;
        this.quantity = quantity;
        this.value = value;
        this.weight = weight;
        this.country = country;
        this.tariff = tariff;
        this.cleanseValues();
        if (this.customsTableModel.getRowCount() <= this.maxLines) {
            Object[] row = new Object[this.customsTableModel.getColumnCount()];
            row[((Integer)this.formattedLineTable.getReverseColumnMap().get((Object)"Description")).intValue()] = this.description;
            row[((Integer)this.formattedLineTable.getReverseColumnMap().get((Object)"Quantity")).intValue()] = this.quantity;
            row[((Integer)this.formattedLineTable.getReverseColumnMap().get((Object)"Value")).intValue()] = this.value;
            row[((Integer)this.formattedLineTable.getReverseColumnMap().get((Object)"Weight")).intValue()] = this.weight;
            row[((Integer)this.formattedLineTable.getReverseColumnMap().get((Object)"Country of Origin")).intValue()] = this.country;
            row[((Integer)this.formattedLineTable.getReverseColumnMap().get((Object)"HS Tariff Number")).intValue()] = this.tariff;
            this.customsTableModel.addRow(row);
            this.formattedLineTable.getFormattedTable().packAll();
        }
        this.getDeclaredValue();
    }

    private void gatherCustomerInformation(PrintDetails printDetail) {
        this.firstNameField.setText(printDetail.getFirstName());
        this.lastNameField.setText(printDetail.getLastName());
        this.emailField.setText(printDetail.getEmail());
        this.countryField.setText(printDetail.getCountryCode());
        this.address1Field.setText(printDetail.getStreet1());
        this.address2Field.setText(printDetail.getStreet2());
        this.cityField.setText(printDetail.getCity());
        this.stateField.setText(printDetail.getState());
        this.postalField.setText(printDetail.getPostalCode());
        this.weightField.setText(String.valueOf(printDetail.getWeight()));
        this.packedWeightField.setText(String.valueOf(printDetail.getPackedWeight()));
        this.shippingField.setText(printDetail.getShipping());
        this.packageField.setText(printDetail.getPackageType());
    }

    private void createItemTable(PrintDetails printDetail) {
        this.skuListener = false;
        this.skuTableModel.setRowCount(0);
        for (SKUDetails details : printDetail.getSkuDetails()) {
            Object[] row = new Object[this.skuTableModel.getColumnCount()];
            row[((Integer)this.formattedSkuTable.getReverseColumnMap().get((Object)"Account")).intValue()] = details.getAccount();
            row[((Integer)this.formattedSkuTable.getReverseColumnMap().get((Object)"Sku")).intValue()] = details.getSku();
            row[((Integer)this.formattedSkuTable.getReverseColumnMap().get((Object)"Reference Number")).intValue()] = details.getReferenceNumber();
            row[((Integer)this.formattedSkuTable.getReverseColumnMap().get((Object)"Title")).intValue()] = details.getTitle();
            row[((Integer)this.formattedSkuTable.getReverseColumnMap().get((Object)"Location")).intValue()] = details.getLocation();
            row[((Integer)this.formattedSkuTable.getReverseColumnMap().get((Object)"Weight")).intValue()] = details.getWeight();
            row[((Integer)this.formattedSkuTable.getReverseColumnMap().get((Object)"Packed Weight")).intValue()] = details.getPackedWeight();
            row[((Integer)this.formattedSkuTable.getReverseColumnMap().get((Object)"Price")).intValue()] = details.getPrice();
            this.skuTableModel.addRow(row);
        }
        this.formattedSkuTable.getFormattedTable().packAll();
        this.skuListener = true;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.tableListener) {
            this.tableListener = false;
            this.handleTableChanged();
            this.tableListener = true;
        }
    }

    private class SKUModelListener
    implements TableModelListener {
        private SKUModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (CustomsForm.this.skuListener) {
                CustomsForm.this.skuListener = false;
                CustomsForm.this.createItemTable(CustomsForm.this.printDetails);
                CustomsForm.this.skuListener = true;
            }
        }
    }
}

