/*
 * Decompiled with CFR 0.152.
 */
package pnp.managers.printmanager;

import StampsSDK.ServiceType;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.ByteArrayInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import org.apache.commons.codec.binary.Base64;
import pnp.services.datatypes.AccountPreferences;
import pnp.services.datatypes.CheckDetails;
import pnp.services.datatypes.PrintDetails;
import pnp.services.preferencemanager.Preferences;
import pnp.services.util.ErrorsUtil;

public class LabelPrinter
implements Printable {
    private PrintDetails detail1;
    private PrintDetails detail2;
    private ArrayList<String> detail1URL;
    private ArrayList<String> detail2URL;
    private final int verticalSpacing = 13;
    private final int totalVerticalSpacing = 460;
    private final int numLines = (int)Math.floor(35.0);
    private final int horizontalSpacing = 46;
    private final int firstPage = -300;
    private final int secondPage = -649;
    private boolean saveHelper = false;

    public boolean isSaveHelper() {
        return this.saveHelper;
    }

    public void setSaveHelper(boolean saveHelper) {
        this.saveHelper = saveHelper;
    }

    public void setDetail1URL(ArrayList<String> detail1URL) {
        this.detail1URL = detail1URL;
    }

    public void setDetail2URL(ArrayList<String> detail2URL) {
        this.detail2URL = detail2URL;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        try {
            boolean twoPages;
            boolean isDuplex = Preferences.getInstance().getAccountPreferences().getStampsPrintOptions().equalsIgnoreCase(AccountPreferences.DUPLEX) && !this.saveHelper;
            boolean isFullPage = Preferences.getInstance().getAccountPreferences().getStampsPageOptions().equalsIgnoreCase(AccountPreferences.FULLPAGE) && this.detail2 != null;
            String labelInstructions = this.sanitize(this.detail1.getLabelInstructions());
            String labelInstructions2 = "";
            if (isFullPage && this.detail2 != null) {
                labelInstructions2 = this.sanitize(this.detail2.getLabelInstructions());
            }
            int pageEnd = 1;
            boolean bl = twoPages = this.detail1URL.size() > 2 || this.detail1URL.size() == 2 && !this.detail1.getUrl().contains("ENDICIA");
            if (twoPages) {
                ++pageEnd;
            }
            if (isDuplex) {
                pageEnd *= 2;
            }
            if (pageIndex >= pageEnd) {
                return 1;
            }
            Graphics2D g2d = (Graphics2D)graphics;
            g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            ArrayList<BufferedImage> image1 = this.createImages(this.detail1, this.detail1URL);
            ArrayList<BufferedImage> image2 = this.createImages(this.detail2, this.detail2URL);
            if (pageIndex == 0) {
                this.handlePageZero(g2d, image1, image2, twoPages, isFullPage);
            }
            if (pageIndex == 1) {
                pageIndex = this.handlePageOne(g2d, labelInstructions, labelInstructions2, isFullPage, twoPages, isDuplex);
            }
            if (pageIndex == 2) {
                this.handlePageTwo(g2d, image1, twoPages);
            }
            if (pageIndex == 3) {
                this.handlePageThree(g2d, twoPages, labelInstructions);
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
            if (ex.getMessage().equalsIgnoreCase("Can't get input stream from URL!")) {
                JOptionPane.showMessageDialog(null, "The label URL has expired and no longer exists.\n You may reprint this label from your records if you chose to save the image files.\nIf no way of recovering the label remains, please void the label and purchase again");
            }
            throw new PrinterException();
        }
        return 0;
    }

    public void setDetail1(PrintDetails detail1) {
        this.detail1 = detail1;
    }

    public void setDetail2(PrintDetails detail2) {
        this.detail2 = detail2;
    }

    private void drawFirstImage(Graphics2D g2d, ArrayList<BufferedImage> image1, boolean twoPages, boolean isUPS, boolean isEndicia, boolean isStamps, boolean isInternationalLabelOne) {
        if (twoPages) {
            g2d.scale(0.29, 0.3);
        } else if (isUPS) {
            g2d.scale(0.8, 0.65);
            g2d.rotate(Math.toRadians(180.0));
            g2d.translate(-575, -450);
        } else if (isEndicia) {
            g2d.scale(0.39, 0.39);
            if (!isInternationalLabelOne) {
                g2d.rotate(Math.toRadians(90.0));
                g2d.translate(0, -1200);
            }
        } else if (isStamps) {
            g2d.scale(0.39, 0.39);
            if (!isInternationalLabelOne) {
                g2d.rotate(Math.toRadians(90.0));
                g2d.translate(0, -1200);
            } else {
                g2d.translate(-200, -126);
            }
        }
        g2d.drawRenderedImage(image1.get(0), null);
        if (image1.size() > 2) {
            g2d.translate(0, 1100);
            g2d.drawRenderedImage(image1.get(1), null);
        }
    }

    private void undoInReverseOrderDrawImageOne(Graphics2D g2d, boolean isUPSLabelOne, boolean isEndiciaLabelOne, boolean isStampsLabelOne, boolean isInternationalLabelOne) {
        if (isUPSLabelOne) {
            g2d.translate(575, 450);
            g2d.rotate(Math.toRadians(-180.0));
            g2d.scale(1.25, 1.538);
        } else if (isEndiciaLabelOne) {
            if (!isInternationalLabelOne) {
                g2d.translate(0, 1200);
                g2d.rotate(Math.toRadians(-90.0));
            }
            g2d.scale(2.564, 2.564);
        } else if (isStampsLabelOne) {
            if (!isInternationalLabelOne) {
                g2d.translate(0, 1200);
                g2d.rotate(Math.toRadians(-90.0));
            } else {
                g2d.translate(200, 126);
            }
            g2d.scale(2.564, 2.564);
        }
    }

    private void drawSecondImage(Graphics2D g2d, ArrayList<BufferedImage> image1, ArrayList<BufferedImage> image2, boolean twoPages, boolean isUPSLabelOne, boolean isEndiciaLabelOne, boolean isStampsLabelOne, boolean isInternationalLabelOne, boolean isUPSLabelTwo, boolean isEndiciaLabelTwo, boolean isStampsLabelTwo, boolean isInternationalLabelTwo, boolean isFullPage) {
        if (isFullPage && !twoPages) {
            this.undoInReverseOrderDrawImageOne(g2d, isUPSLabelOne, isEndiciaLabelOne, isStampsLabelOne, isInternationalLabelOne);
            if (isUPSLabelTwo) {
                g2d.scale(0.8, 0.65);
                g2d.rotate(Math.toRadians(180.0));
                g2d.translate(-575, -1000);
            } else if (isEndiciaLabelTwo) {
                g2d.scale(0.39, 0.39);
                if (!isInternationalLabelTwo) {
                    g2d.rotate(Math.toRadians(90.0));
                    g2d.translate(900, -1200);
                } else {
                    g2d.translate(50, 900);
                }
            } else if (isStampsLabelTwo) {
                g2d.scale(0.39, 0.39);
                if (!isInternationalLabelTwo) {
                    g2d.rotate(Math.toRadians(90.0));
                    g2d.translate(900, -1200);
                } else {
                    g2d.translate(-200, 768);
                }
            }
            g2d.drawRenderedImage(image2.get(0), null);
            if (image2.size() > 2) {
                g2d.drawRenderedImage(image2.get(1), null);
            }
        }
    }

    private void handlePageZero(Graphics2D g2d, ArrayList<BufferedImage> image1, ArrayList<BufferedImage> image2, boolean twoPages, boolean isFullPage) {
        boolean isUPSLabelOne = this.detail1.getUrl().contains("UPS: ");
        boolean isEndiciaLabelOne = this.detail1.getUrl().contains("ENDICIA");
        boolean isStampsLabelOne = !isUPSLabelOne && !isEndiciaLabelOne;
        boolean isInternationalLabelOne = !this.detail1.getCountryCode().equalsIgnoreCase("US") || this.detail1.getCity().equalsIgnoreCase("APO") || this.detail1.getCity().equalsIgnoreCase("FPO");
        boolean isInternationalLabelTwo = this.detail2 != null && (!this.detail2.getCountryCode().equalsIgnoreCase("US") || this.detail2.getCity().equalsIgnoreCase("APO") || this.detail2.getCity().equalsIgnoreCase("FPO"));
        boolean isUPSLabelTwo = this.detail2 != null && this.detail2.getUrl().contains("UPS: ");
        boolean isEndiciaLabelTwo = this.detail2 != null && this.detail2.getUrl().contains("ENDICIA");
        boolean isStampsLabelTwo = !isUPSLabelTwo && !isEndiciaLabelTwo;
        this.drawFirstImage(g2d, image1, twoPages, isUPSLabelOne, isEndiciaLabelOne, isStampsLabelOne, isInternationalLabelOne);
        this.drawSecondImage(g2d, image1, image2, twoPages, isUPSLabelOne, isEndiciaLabelOne, isStampsLabelOne, isInternationalLabelOne, isUPSLabelTwo, isEndiciaLabelTwo, isStampsLabelTwo, isInternationalLabelTwo, isFullPage);
    }

    private int handlePageOne(Graphics2D g2d, String labelInstructions, String labelInstructions2, boolean isFullPage, boolean twoPages, boolean isDuplex) {
        if (!isFullPage) {
            labelInstructions2 = "";
        }
        if (isDuplex) {
            g2d.rotate(Math.toRadians(-90.0));
            if (!twoPages) {
                this.handleImageCreation(labelInstructions, g2d, -300, true);
                this.handleImageCreation(labelInstructions2, g2d, -649, false);
            }
        } else {
            return 2;
        }
        return 1;
    }

    private void handlePageTwo(Graphics2D g2d, ArrayList<BufferedImage> image1, boolean twoPages) {
        if (twoPages) {
            g2d.scale(0.29, 0.3);
            if (image1.size() == 2) {
                g2d.drawRenderedImage(image1.get(1), null);
            } else {
                g2d.drawRenderedImage(image1.get(2), null);
                g2d.translate(0, 1100);
                g2d.drawRenderedImage(image1.get(3), null);
            }
        }
    }

    private void handlePageThree(Graphics2D g2d, boolean twoPages, String labelInstructions) {
        if (twoPages) {
            g2d.rotate(Math.toRadians(-90.0));
            this.handleImageCreation(labelInstructions, g2d, -649, true);
        }
    }

    private ArrayList<BufferedImage> createImages(PrintDetails detail, ArrayList<String> detailURL) {
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        if (detail != null && detailURL != null) {
            for (String imageString : detailURL) {
                try {
                    byte[] btDataFile;
                    Base64 imageBase;
                    BufferedImage image = null;
                    if (detail.getUrl().contains("ENDICIA")) {
                        imageBase = new Base64();
                        btDataFile = imageBase.decode(imageString);
                        image = this.scaleImage(ImageIO.read(new ByteArrayInputStream(btDataFile)), detail);
                    } else if (detail.getUrl().contains("UPS: ")) {
                        imageBase = new Base64();
                        btDataFile = imageBase.decode(imageString);
                        image = this.scaleImage(ImageIO.read(new ByteArrayInputStream(btDataFile)), detail);
                    } else {
                        image = ImageIO.read(new URL("https://" + imageString));
                    }
                    if (image == null) continue;
                    images.add(image);
                }
                catch (Exception ex) {
                    ErrorsUtil.getInstance().logError(ex);
                }
            }
        }
        return images;
    }

    public Set<String> parseTransactions(String comment) {
        HashSet<String> transactions = new HashSet<String>();
        if (comment != null) {
            comment = comment.trim();
            for (String split1 : comment.split("TRANSACTIONID: \\[")) {
                String[] split2 = split1.split("\\]");
                if (split2.length <= 0 || !split2[0].matches("[A-Z0-9]+")) continue;
                transactions.add(split2[0]);
            }
        }
        return transactions;
    }

    public String printTransactions(Set<String> transactions) {
        String orderComments = "";
        for (String transaction : transactions) {
            orderComments = orderComments + "\nTRANSACTIONID: [" + transaction + "]";
        }
        return orderComments;
    }

    public String[] parseOrderComments(String comments) {
        String[] parsedString = new String[]{"", ""};
        if (comments != null) {
            comments = comments.trim();
            String[] fullComments = comments.split("TRANSACTIONID: \\[[A-Z0-9]*\\]");
            int counter = 0;
            for (String comment : fullComments) {
                if (!(comment = comment.trim()).isEmpty()) {
                    if (counter != 0 && counter == fullComments.length - 1) {
                        parsedString[1] = comment;
                    } else {
                        parsedString[0] = parsedString[0] + comment + " ";
                    }
                }
                ++counter;
            }
            parsedString[0] = parsedString[0].trim();
        }
        return parsedString;
    }

    private ArrayList<String> parseItems(String comments) {
        ArrayList<String> itemList = new ArrayList<String>();
        if (comments != null) {
            for (String item : comments.split("\r\n")) {
                if ((item = item.trim()).isEmpty()) continue;
                if (item.length() > 46) {
                    item = item.substring(0, 46);
                }
                itemList.add(item);
            }
        }
        return itemList;
    }

    private ArrayList<String> createPrintableComments(String comments) {
        ArrayList<String> printableComments = new ArrayList<String>();
        if (comments != null && !(comments = comments.trim()).isEmpty()) {
            for (int i = 0; i < comments.length(); i += 46) {
                String comment;
                if (i + 46 <= comments.length()) {
                    comment = comments.substring(i, i + 46).trim();
                    if (comment.isEmpty()) continue;
                    printableComments.add(comment);
                    continue;
                }
                comment = comments.substring(i, comments.length()).trim();
                if (comment.isEmpty()) continue;
                printableComments.add(comment);
            }
        }
        return printableComments;
    }

    private ArrayList<String> createPrintableComments(HashMap<Integer, CheckDetails> checkList) {
        ArrayList<String> printableComments = new ArrayList<String>();
        for (CheckDetails detail : checkList.values()) {
            if (detail.getQuantityLeft() > 0) continue;
            if (detail.isDiscontinued()) {
                printableComments.add(detail.getItemID() + ": " + Preferences.getInstance().getAccountPreferences().getStampsDiscoWarning());
                continue;
            }
            printableComments.add(detail.getItemID() + ": " + Preferences.getInstance().getAccountPreferences().getStampsOOSWarning());
        }
        return printableComments;
    }

    private void handlePageGroup(Graphics2D g2d) {
        g2d.drawString("Group: " + this.detail1.getPrintID() + " - Page: " + this.detail1.getPrintPage(), -400, 460);
    }

    private void handleImageCreation(String labelInstructions, Graphics2D g2d, int page, boolean firstPage) {
        int line = 1;
        String[] instructions = labelInstructions.split("Order Comments:");
        String[] orderComments = new String[2];
        if (instructions.length > 1) {
            orderComments = this.parseOrderComments(instructions[1]);
        } else {
            orderComments[0] = "";
            orderComments[1] = "";
        }
        String shippingMethod = "";
        if (!orderComments[0].isEmpty()) {
            orderComments[0] = "Order Comments: " + orderComments[0];
        } else if (!orderComments[1].isEmpty()) {
            orderComments[1] = "Order Comments: " + orderComments[1];
        }
        ArrayList<String> visibleComments = this.createPrintableComments(orderComments[0]);
        ArrayList<String> invisibleComments = this.createPrintableComments(orderComments[1]);
        ArrayList<Object> warningMessages = new ArrayList();
        try {
            if (firstPage && this.detail1 != null && this.detail1.getOrderDetailsList() != null) {
                warningMessages = this.createPrintableComments(this.detail1.getOrderDetailsList());
            } else if (this.detail2 != null && this.detail2.getOrderDetailsList() != null) {
                warningMessages = this.createPrintableComments(this.detail2.getOrderDetailsList());
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        ArrayList<String> items = this.parseItems(instructions[0]);
        for (int i = 0; i < items.size() && line <= this.numLines; ++line, ++i) {
            if (i == 0) {
                g2d.drawString("Number of items: " + items.size() + "         [Group: " + this.detail1.getPrintID() + " - Page: " + this.detail1.getPrintPage() + "]", page, line * 13);
                line += 2;
                if (firstPage) {
                    g2d.drawString("Shipping Method: " + this.detail1.getShipping(), page, line * 13);
                } else {
                    g2d.drawString("Shipping Method: " + this.detail2.getShipping(), page, line * 13);
                }
                ++line;
                if (items.size() >= this.numLines - 3) {
                    g2d.drawString("This order has too many items, partial list shown", page, line * 13);
                    ++line;
                }
            }
            g2d.drawString(items.get(i), page, line * 13);
        }
        for (String string : visibleComments) {
            g2d.drawString(string, page, line * 13);
            ++line;
        }
        if (Preferences.getInstance().getAccountPreferences().isStampsComments()) {
            for (String string : invisibleComments) {
                g2d.drawString(string, page, line * 13);
                ++line;
            }
        }
        if (!warningMessages.isEmpty()) {
            g2d.drawString("-------------------------------", page, line++ * 13);
            g2d.drawString("-------WARNINGS-------", page, line++ * 13);
            g2d.drawString("-------------------------------", page, line++ * 13);
        }
        for (String string : warningMessages) {
            g2d.drawString(string, page, line * 13);
            ++line;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage scaleImage(BufferedImage img, PrintDetails detail) {
        int width = 1;
        int height = 1;
        if (detail.getShipping().equals(this.getServiceName(ServiceType.US_EMI)) || detail.getShipping().equals(this.getServiceName(ServiceType.US_PMI)) && detail.getCost() != 0.0) {
            width = 1800;
            height = 1000;
        } else if (detail.getShipping().equals(this.getServiceName(ServiceType.US_FCI)) || detail.getShipping().equals(this.getServiceName(ServiceType.US_PMI)) && detail.getCost() == 0.0) {
            width = 1200;
            height = 762;
        } else {
            width = 762;
            height = 1200;
        }
        int imgWidth = img.getWidth();
        int imgHeight = img.getHeight();
        if (imgWidth * height < imgHeight * width) {
            width = imgWidth * height / imgHeight;
        } else {
            height = imgHeight * width / imgWidth;
        }
        BufferedImage newImage = new BufferedImage(width, height, 1);
        Graphics2D g = newImage.createGraphics();
        try {
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g.clearRect(0, 0, width, height);
            g.drawImage(img, 0, 0, width, height, null);
        }
        finally {
            g.dispose();
        }
        return newImage;
    }

    private String sanitize(String uncleanString) {
        if (uncleanString != null) {
            uncleanString = uncleanString.replace("\u2022", ",");
            uncleanString = uncleanString.replace("\u201d", "in");
        }
        return uncleanString;
    }

    private String getServiceName(ServiceType serviceType) {
        String serviceString = "First Class";
        if (serviceType != null) {
            if (serviceType.equals((Object)ServiceType.US_FC)) {
                serviceString = "First Class";
            } else if (serviceType.equals((Object)ServiceType.US_FCI)) {
                serviceString = "Int. First Class";
            } else if (serviceType.equals((Object)ServiceType.US_EMI)) {
                serviceString = "Int. Express";
            } else if (serviceType.equals((Object)ServiceType.US_PMI)) {
                serviceString = "Int. Priority";
            } else if (serviceType.equals((Object)ServiceType.US_MM)) {
                serviceString = "Media Mail";
            } else if (serviceType.equals((Object)ServiceType.US_PM)) {
                serviceString = "Priority";
            } else if (serviceType.equals((Object)ServiceType.US_PS)) {
                serviceString = "Parcel Select";
            } else if (serviceType.equals((Object)ServiceType.US_XM)) {
                serviceString = "Express";
            }
        }
        return serviceString;
    }
}

