/*
 * Decompiled with CFR 0.152.
 */
package pnp.managers.printmanager;

import StampsSDK.PackageTypeV6;
import StampsSDK.ServiceType;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import pnp.services.datatypes.CheckDetails;
import pnp.services.datatypes.CompleteOrder;
import pnp.services.datatypes.OrderDetails;
import pnp.services.datatypes.PrintDetails;
import pnp.services.datatypes.RMADetails;
import pnp.services.datatypes.RMAReason;
import pnp.services.datatypes.RMAStatus;
import pnp.services.preferencemanager.Preferences;
import pnp.services.table.FormattedXTable;
import pnp.services.util.ErrorsUtil;
import pnp.services.util.LookupServicesUtil;

public class ReturnForm
extends JDialog
implements ListSelectionListener {
    private PrintDetails currentWorkingDetail;
    private HashMap<Integer, CompleteOrder> orderList;
    private HashMap<String, HashSet<RMADetails>> rmaList;
    private boolean skipThis = false;
    private JTextArea RMACommentsField;
    private JComboBox RMAReasonField;
    private JComboBox RMAStatusField;
    private JTextField addressField;
    private JCheckBox customWeightCheckBox;
    private JTextField customerEmail;
    private JTextField customerName;
    private JButton finalizeReturn;
    private FormattedXTable formattedReturnFormTable;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JComboBox packageType;
    private JComboBox shippingMethod;
    private JTextField userName;
    private JTextField weightField;

    public ReturnForm(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.init();
    }

    public HashMap<String, HashSet<RMADetails>> getRmaList() {
        return this.rmaList;
    }

    public void clearRMAList() {
        if (this.rmaList == null) {
            this.rmaList = new HashMap();
        } else {
            this.rmaList.clear();
        }
    }

    private void init() {
        this.rmaList = new HashMap();
        this.currentWorkingDetail = new PrintDetails();
        this.formattedReturnFormTable.init(new String[]{"Order Details ID", "Item ID", "Item Title", "Item Weight"}, "ReturnForm", null);
        this.formattedReturnFormTable.getFormattedTable().setEditable(false);
        this.formattedReturnFormTable.getFormattedTable().setShowGrid(true);
        this.buildComboBoxes();
        this.formattedReturnFormTable.getFormattedTable().getSelectionModel().addListSelectionListener(this);
        this.weightField.getDocument().addDocumentListener(new DocListener());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ReturnForm.this.skipThis = true;
            }
        });
    }

    private void buildComboBoxes() {
        this.RMAReasonField.removeAllItems();
        this.RMAStatusField.removeAllItems();
        this.shippingMethod.removeAllItems();
        this.packageType.removeAllItems();
        for (RMAReason reason : LookupServicesUtil.getDBServices().getAvailableRMAReasons().values()) {
            this.RMAReasonField.addItem(reason.getRmaReasonType());
        }
        for (RMAReason reason : LookupServicesUtil.getDBServices().getAvailableRMAStatuses().values()) {
            this.RMAStatusField.addItem(reason.getRmaStatusType());
        }
        ArrayList<String> packageItems = new ArrayList<String>();
        ArrayList<String> shippingItems = new ArrayList<String>();
        String[] shippingItemsStamps = new String[]{"First Class", "Priority", "Express", "Int. First Class", "Int. Express", "Int. Priority", "Media Mail", "Parcel Select"};
        shippingItems.addAll(Arrays.asList(shippingItemsStamps));
        for (PackageTypeV6 packageTypeV6 : PackageTypeV6.values()) {
            String name = packageTypeV6.value();
            if (name.equalsIgnoreCase("Flat Rate Box")) {
                name = "Med. Flat Rate Box";
            }
            packageItems.add(name);
        }
        this.populateComboBox(packageItems.toArray(new String[0]), this.packageType);
        this.populateComboBox(shippingItems.toArray(new String[0]), this.shippingMethod);
    }

    private void populateComboBox(String[] items, JComboBox box) {
        try {
            if (items != null && items.length != 0 && box != null) {
                box.removeAllItems();
                for (String item : items) {
                    box.addItem(item);
                }
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private void createForm() {
        try {
            this.customerName.setText(this.currentWorkingDetail.getFirstName() + " " + this.currentWorkingDetail.getLastName());
            this.customerEmail.setText(this.currentWorkingDetail.getEmail());
            this.userName.setText(this.currentWorkingDetail.getCustomer());
            this.addressField.setText(this.currentWorkingDetail.getStreet1());
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        this.RMAReasonField.setSelectedItem(((RMAReason)LookupServicesUtil.getDBServices().getAvailableRMAReasons().get("")).getRmaReasonType());
        this.RMAStatusField.setSelectedItem(((RMAStatus)LookupServicesUtil.getDBServices().getAvailableRMAStatuses().get("Returning")).getRmaStatusType());
        this.RMACommentsField.setText("");
        this.formattedReturnFormTable.getTableModel().setNumRows(0);
        Object[] row = new Object[this.formattedReturnFormTable.getTableModel().getColumnCount()];
        this.customWeightCheckBox.setSelected(false);
        this.weightField.setText(String.valueOf(this.currentWorkingDetail.getWeight()));
        this.shippingMethod.setSelectedItem(this.currentWorkingDetail.getShipping());
        this.packageType.setSelectedItem(this.currentWorkingDetail.getPackageType());
        this.orderList = LookupServicesUtil.getDBServices().getOrders(this.currentWorkingDetail.getParentOrderID(), null, 0L, 0L, "20");
        for (CheckDetails checkDetail : this.currentWorkingDetail.getOrderDetailsList().values()) {
            OrderDetails orderDetails = this.getOrderDetails(checkDetail.getOrderDetailsID());
            row[((Integer)this.formattedReturnFormTable.getReverseColumnMap().get((Object)"Order Details ID")).intValue()] = checkDetail.getOrderDetailsID();
            if (orderDetails != null) {
                row[((Integer)this.formattedReturnFormTable.getReverseColumnMap().get((Object)"Item ID")).intValue()] = orderDetails.getItemID();
                row[((Integer)this.formattedReturnFormTable.getReverseColumnMap().get((Object)"Item Title")).intValue()] = orderDetails.getOrderDescription();
            } else {
                row[((Integer)this.formattedReturnFormTable.getReverseColumnMap().get((Object)"Item ID")).intValue()] = "ITEM ID ERROR";
                row[((Integer)this.formattedReturnFormTable.getReverseColumnMap().get((Object)"Item Title")).intValue()] = "ITEM TITLE ERROR";
            }
            row[((Integer)this.formattedReturnFormTable.getReverseColumnMap().get((Object)"Item Weight")).intValue()] = Float.valueOf(checkDetail.getWeight());
            this.formattedReturnFormTable.getTableModel().addRow(row);
        }
        this.formattedReturnFormTable.getFormattedTable().selectAll();
    }

    private void finalizeReturn() {
        boolean finalize = true;
        try {
            for (int row : this.formattedReturnFormTable.getFormattedTable().getSelectedRows()) {
                this.createRMA(row);
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        if (this.formattedReturnFormTable.getFormattedTable().getSelectedRows() == null || this.formattedReturnFormTable.getFormattedTable().getSelectedRows().length == 0) {
            boolean bl = finalize = JOptionPane.showOptionDialog(null, "No RMA's will be created for this order. Press NO to go back.", "No RMA Warning", 0, 3, null, null, null) == 0;
        }
        if (finalize) {
            this.currentWorkingDetail.setWeight(Double.valueOf(this.weightField.getText()));
            this.currentWorkingDetail.setShipping(this.shippingMethod.getSelectedItem().toString());
            this.currentWorkingDetail.setPackageType(this.packageType.getSelectedItem().toString());
            LookupServicesUtil.getDBServices().insertPrintDetails(this.currentWorkingDetail);
            this.setVisible(false);
        }
    }

    private OrderDetails getOrderDetails(int checkOrderID) {
        OrderDetails orderDetails = null;
        if (this.orderList != null && !this.orderList.isEmpty() && this.orderList.containsKey(Integer.parseInt(this.currentWorkingDetail.getParentOrderID()))) {
            CompleteOrder order = this.orderList.get(Integer.parseInt(this.currentWorkingDetail.getParentOrderID()));
            for (OrderDetails listDetails : order.getOrderDetails()) {
                if (listDetails.getOrderDetailsID() != checkOrderID) continue;
                orderDetails = listDetails;
                break;
            }
        }
        return orderDetails;
    }

    private void createRMA(int row) {
        String orderDetailsID = this.formattedReturnFormTable.getValue(row, "Order Details ID");
        OrderDetails orderDetails = new OrderDetails();
        try {
            orderDetails = this.getOrderDetails(((CheckDetails)this.currentWorkingDetail.getOrderDetailsList().get(Integer.parseInt(orderDetailsID.toString()))).getOrderDetailsID());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        CompleteOrder order = this.orderList.get(Integer.parseInt(this.currentWorkingDetail.getParentOrderID()));
        RMADetails rmaDetails = new RMADetails();
        rmaDetails.setCustomer(order.getOrder().getCustomer());
        rmaDetails.setCustomerUsername(order.getOrder().getCustomer().getCustomerUserName());
        rmaDetails.setReplacementTracking("");
        rmaDetails.setReturnTracking(this.currentWorkingDetail.getTracking());
        rmaDetails.setRmaComments(this.RMACommentsField.getText());
        rmaDetails.setRmaDate(new Date(Calendar.getInstance().getTime().getTime()));
        rmaDetails.setRmaReasonID(((RMAReason)LookupServicesUtil.getDBServices().getAvailableRMAReasons().get(this.RMAReasonField.getSelectedItem().toString())).getRmaReasonID());
        rmaDetails.setRmaStatusID(((RMAStatus)LookupServicesUtil.getDBServices().getAvailableRMAStatuses().get(this.RMAStatusField.getSelectedItem().toString())).getRmaStatusID());
        rmaDetails.setOrderDetails(orderDetails);
        rmaDetails.setOrderDetailsID(orderDetails.getOrderDetailsID());
        rmaDetails = LookupServicesUtil.getDBServices().updateRMA(rmaDetails);
        if (!this.rmaList.containsKey(this.currentWorkingDetail.getOrderID())) {
            this.rmaList.put(this.currentWorkingDetail.getOrderID(), new HashSet());
        }
        this.rmaList.get(this.currentWorkingDetail.getOrderID()).add(rmaDetails);
    }

    public void setVisible(boolean b, PrintDetails detail) {
        this.skipThis = false;
        this.currentWorkingDetail = detail;
        this.createForm();
        super.setVisible(b);
    }

    public boolean isSkipThis() {
        return this.skipThis;
    }

    private void initComponents() {
        this.jPanel6 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.RMAStatusField = new JComboBox();
        this.jPanel4 = new JPanel();
        this.jLabel2 = new JLabel();
        this.RMAReasonField = new JComboBox();
        this.jPanel5 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.RMACommentsField = new JTextArea();
        this.jPanel9 = new JPanel();
        this.jLabel8 = new JLabel();
        this.customerName = new JTextField();
        this.jLabel9 = new JLabel();
        this.customerEmail = new JTextField();
        this.jLabel10 = new JLabel();
        this.userName = new JTextField();
        this.jLabel11 = new JLabel();
        this.addressField = new JTextField();
        this.jPanel7 = new JPanel();
        this.formattedReturnFormTable = new FormattedXTable();
        this.jLabel4 = new JLabel();
        this.weightField = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.shippingMethod = new JComboBox();
        this.packageType = new JComboBox();
        this.customWeightCheckBox = new JCheckBox();
        this.jPanel8 = new JPanel();
        this.finalizeReturn = new JButton();
        this.jLabel7 = new JLabel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        this.setDefaultCloseOperation(2);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ReturnForm.class, (String)"ReturnForm.jPanel1.border.title")));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ReturnForm.class, (String)"ReturnForm.jPanel2.border.title")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ReturnForm.class, (String)"ReturnForm.jLabel1.text"));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 83, Short.MAX_VALUE)).addComponent(this.RMAStatusField, 0, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.RMAStatusField, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ReturnForm.class, (String)"ReturnForm.jLabel2.text"));
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel2).addGap(0, 82, Short.MAX_VALUE)).addComponent(this.RMAReasonField, 0, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.RMAReasonField, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(ReturnForm.class, (String)"ReturnForm.jLabel3.text"));
        this.RMACommentsField.setColumns(20);
        this.RMACommentsField.setRows(5);
        this.jScrollPane1.setViewportView(this.RMACommentsField);
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jLabel3).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane1)).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3).addGap(7, 7, 7).addComponent(this.jScrollPane1, -1, 86, Short.MAX_VALUE).addContainerGap()));
        this.jPanel9.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ReturnForm.class, (String)"ReturnForm.jPanel9.border.title")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(ReturnForm.class, (String)"ReturnForm.jLabel8.text"));
        this.customerName.setEditable(false);
        this.customerName.setText(NbBundle.getMessage(ReturnForm.class, (String)"ReturnForm.customerName.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(ReturnForm.class, (String)"ReturnForm.jLabel9.text"));
        this.customerEmail.setEditable(false);
        this.customerEmail.setText(NbBundle.getMessage(ReturnForm.class, (String)"ReturnForm.customerEmail.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel10, (String)NbBundle.getMessage(ReturnForm.class, (String)"ReturnForm.jLabel10.text"));
        this.userName.setEditable(false);
        this.userName.setText(NbBundle.getMessage(ReturnForm.class, (String)"ReturnForm.userName.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel11, (String)NbBundle.getMessage(ReturnForm.class, (String)"ReturnForm.jLabel11.text"));
        this.addressField.setEditable(false);
        this.addressField.setText(NbBundle.getMessage(ReturnForm.class, (String)"ReturnForm.addressField.text"));
        GroupLayout jPanel9Layout = new GroupLayout(this.jPanel9);
        this.jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addContainerGap().addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8).addComponent(this.jLabel9).addComponent(this.jLabel10).addComponent(this.jLabel11)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.customerName).addComponent(this.customerEmail).addComponent(this.userName).addComponent(this.addressField)).addContainerGap()));
        jPanel9Layout.setVerticalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addContainerGap().addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.customerName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.customerEmail, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel10).addComponent(this.userName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel11).addComponent(this.addressField, -2, -1, -2)).addContainerGap()));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel9, -1, -1, Short.MAX_VALUE)).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE))).addComponent(this.jPanel9, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jPanel7.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ReturnForm.class, (String)"ReturnForm.jPanel7.border.title")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(ReturnForm.class, (String)"ReturnForm.jLabel4.text"));
        this.weightField.setText(NbBundle.getMessage(ReturnForm.class, (String)"ReturnForm.weightField.text"));
        this.weightField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ReturnForm.this.weightFieldKeyPressed(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                ReturnForm.this.weightFieldKeyTyped(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(ReturnForm.class, (String)"ReturnForm.jLabel5.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(ReturnForm.class, (String)"ReturnForm.jLabel6.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.customWeightCheckBox, (String)NbBundle.getMessage(ReturnForm.class, (String)"ReturnForm.customWeightCheckBox.text"));
        this.customWeightCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReturnForm.this.customWeightCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.formattedReturnFormTable, -1, 588, Short.MAX_VALUE).addGroup(jPanel7Layout.createSequentialGroup().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.jLabel4).addGap(65, 65, 65).addComponent(this.weightField)).addGroup(jPanel7Layout.createSequentialGroup().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel6)).addGap(20, 20, 20).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.shippingMethod, 0, 108, Short.MAX_VALUE).addComponent(this.packageType, 0, -1, Short.MAX_VALUE)))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.customWeightCheckBox).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.weightField, -2, -1, -2).addComponent(this.customWeightCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.shippingMethod, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.packageType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.formattedReturnFormTable, -1, 174, Short.MAX_VALUE).addContainerGap()));
        this.jPanel8.setBorder(BorderFactory.createTitledBorder(""));
        Mnemonics.setLocalizedText((AbstractButton)this.finalizeReturn, (String)NbBundle.getMessage(ReturnForm.class, (String)"ReturnForm.finalizeReturn.text"));
        this.finalizeReturn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReturnForm.this.finalizeReturnActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(ReturnForm.class, (String)"ReturnForm.jLabel7.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(ReturnForm.class, (String)"ReturnForm.jButton1.text"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReturnForm.this.jButton1ActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButton2, (String)NbBundle.getMessage(ReturnForm.class, (String)"ReturnForm.jButton2.text"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReturnForm.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout jPanel8Layout = new GroupLayout(this.jPanel8);
        this.jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addComponent(this.finalizeReturn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2).addContainerGap(11, Short.MAX_VALUE)));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.finalizeReturn).addComponent(this.jLabel7).addComponent(this.jButton1).addComponent(this.jButton2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel7, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel8, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel7, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel8, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void finalizeReturnActionPerformed(ActionEvent evt) {
        this.finalizeReturn();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.weightField.setText(String.valueOf(this.currentWorkingDetail.getWeight()));
        this.formattedReturnFormTable.getFormattedTable().clearSelection();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.createForm();
    }

    private void customWeightCheckBoxActionPerformed(ActionEvent evt) {
        if (!this.customWeightCheckBox.isSelected()) {
            this.calculateWeightField();
        }
    }

    private void weightFieldKeyPressed(KeyEvent evt) {
    }

    private void weightFieldKeyTyped(KeyEvent evt) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!this.customWeightCheckBox.isSelected()) {
            this.calculateWeightField();
        }
    }

    private void calculateWeightField() {
        float calculatedWeight = 0.0f;
        try {
            if (this.formattedReturnFormTable.getFormattedTable().getSelectedRows().length == 0) {
                this.weightField.setText(this.currentWorkingDetail.getWeight().toString());
            } else {
                for (int row : this.formattedReturnFormTable.getFormattedTable().getSelectedRows()) {
                    String weight = this.formattedReturnFormTable.getValue(row, "Item Weight");
                    if (weight == null || weight.toString().isEmpty()) continue;
                    try {
                        calculatedWeight += Float.valueOf(weight.toString()).floatValue();
                    }
                    catch (Exception ex) {
                        ErrorsUtil.getInstance().logError(ex, false);
                    }
                }
                if (calculatedWeight <= 0.0f) {
                    calculatedWeight = this.weightField.getText().equalsIgnoreCase("0") ? this.currentWorkingDetail.getWeight().floatValue() : Float.valueOf(this.weightField.getText()).floatValue();
                }
                this.weightField.setText(String.valueOf(calculatedWeight));
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        try {
            this.shippingMethod.setSelectedItem(this.getServiceName(this.findServiceType("First Class", !this.currentWorkingDetail.getCountryCode().equalsIgnoreCase("US"), Float.valueOf(this.weightField.getText()).floatValue())));
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex, false);
        }
    }

    private ServiceType findServiceType(String name, boolean international, double totalWeight) {
        ServiceType serviceType;
        if (international) {
            serviceType = totalWeight <= 64.0 ? ServiceType.US_FCI : ServiceType.US_PMI;
            if (name != null && !name.isEmpty()) {
                if (name.contains("Priority")) {
                    serviceType = ServiceType.US_PMI;
                } else if (name.contains("Express")) {
                    serviceType = ServiceType.US_EMI;
                }
            }
        } else {
            serviceType = totalWeight <= 13.0 || Preferences.getInstance().getAccountPreferences().isStampsCommercialPlus() && totalWeight <= 16.0 ? ServiceType.US_FC : ServiceType.US_PM;
            if (name != null && !name.isEmpty()) {
                if (name.contains("Media")) {
                    serviceType = ServiceType.US_MM;
                } else if (name.contains("Parcel")) {
                    serviceType = ServiceType.US_PS;
                } else if (name.contains("Priority")) {
                    serviceType = ServiceType.US_PM;
                } else if (name.contains("Express")) {
                    serviceType = ServiceType.US_XM;
                }
            }
        }
        return serviceType;
    }

    private String getServiceName(ServiceType serviceType) {
        String serviceString = "First Class";
        if (serviceType != null) {
            if (serviceType.equals((Object)ServiceType.US_FC)) {
                serviceString = "First Class";
            } else if (serviceType.equals((Object)ServiceType.US_FCI)) {
                serviceString = "Int. First Class";
            } else if (serviceType.equals((Object)ServiceType.US_EMI)) {
                serviceString = "Int. Express";
            } else if (serviceType.equals((Object)ServiceType.US_PMI)) {
                serviceString = "Int. Priority";
            } else if (serviceType.equals((Object)ServiceType.US_MM)) {
                serviceString = "Media Mail";
            } else if (serviceType.equals((Object)ServiceType.US_PM)) {
                serviceString = "Priority";
            } else if (serviceType.equals((Object)ServiceType.US_PS)) {
                serviceString = "Parcel Select";
            } else if (serviceType.equals((Object)ServiceType.US_XM)) {
                serviceString = "Express";
            }
        }
        return serviceString;
    }

    private class DocListener
    implements DocumentListener {
        private DocListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            try {
                float weight = Float.valueOf(ReturnForm.this.weightField.getText()).floatValue();
                ReturnForm.this.shippingMethod.setSelectedItem(ReturnForm.this.getServiceName(ReturnForm.this.findServiceType("First Class", !ReturnForm.this.currentWorkingDetail.getCountryCode().equalsIgnoreCase("US"), weight)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            try {
                float weight = Float.valueOf(ReturnForm.this.weightField.getText()).floatValue();
                ReturnForm.this.shippingMethod.setSelectedItem(ReturnForm.this.getServiceName(ReturnForm.this.findServiceType("First Class", !ReturnForm.this.currentWorkingDetail.getCountryCode().equalsIgnoreCase("US"), weight)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }
}

