/*
 * Decompiled with CFR 0.152.
 */
package pnp.managers.rmamanager;

import com.toedter.calendar.JDateChooser;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import pnp.services.datatypes.ChangedCell;
import pnp.services.datatypes.RMADetails;
import pnp.services.datatypes.RMAReason;
import pnp.services.datatypes.RMAStatus;
import pnp.services.listener.GenericListener;
import pnp.services.listener.RMAListListener;
import pnp.services.listenermanager.ListenerManager;
import pnp.services.table.FormattedXTable;
import pnp.services.util.ErrorsUtil;
import pnp.services.util.LookupServicesUtil;

@TopComponent.Description(preferredID="RmaManagerTopComponent", persistenceType=1)
public final class RmaManagerTopComponent
extends TopComponent
implements RMAListListener,
ListSelectionListener,
TableModelListener {
    private static RmaManagerTopComponent instance;
    private DefaultTableModel tableModel;
    private HashMap<String, RMADetails> RMAList;
    private JButton applyChangesButton;
    private JCheckBox changedMindCheckBox;
    private JButton clearChangesButton;
    private JPanel dateRangePanel;
    private JCheckBox defectiveCheckBox;
    private JButton deleteButton;
    private JCheckBox exchangingCheckBox;
    private FormattedXTable formattedRMATable;
    private JDateChooser fromDateChooser;
    private JLabel jLabel18;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane3;
    private JCheckBox newRmaCheckBox;
    private JCheckBox pendingResponseCheckBox;
    private JCheckBox refundedCheckBox;
    private JTextField replacementTrackingIdTextField;
    private JCheckBox reshippedCheckBox;
    private JCheckBox returnLabelCheckBox;
    private JCheckBox returnProcessedCheckBox;
    private JTextField returnTrackingIdTextField;
    private JCheckBox returningCheckBox;
    private JTextArea rmaCommentsTextArea;
    private JButton searchButton;
    private JTextField searchField;
    private JDateChooser toDateChooser;
    private JCheckBox wrongItemCheckBox;
    private JCheckBox wrongSizeCheckBox;
    private boolean replacementTrackingFieldUpdated;
    private boolean returnTrackingFieldUpdated;
    private boolean rmaCommentsUpdated;
    private boolean disableListener;
    private ArrayList<RMAStatus> _statusFilters;
    private HashMap<String, RMAStatus> _statusList;
    private ArrayList<RMAReason> _reasonFilters;
    private HashMap<String, RMAReason> _reasonList;
    private HashMap<Integer, RMADetails> _updatedRMAs;
    private HashMap<String, ChangedCell> _validCellChanges;
    private HashMap<String, ChangedCell> _invalidCellChanges;

    public RmaManagerTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(RmaManagerTopComponent.class, (String)"CTL_RmaManagerTopComponent"));
        this.setToolTipText(NbBundle.getMessage(RmaManagerTopComponent.class, (String)"HINT_RmaManagerTopComponent"));
        this.init();
    }

    public void init() {
        this.RMAList = new HashMap();
        this.disableListener = false;
        this._updatedRMAs = new HashMap();
        this._statusFilters = new ArrayList();
        this._statusList = LookupServicesUtil.getDBServices().getAvailableRMAStatuses();
        this._statusFilters.add(this._statusList.get("New RMA"));
        this._reasonFilters = new ArrayList();
        this._reasonList = LookupServicesUtil.getDBServices().getAvailableRMAReasons();
        this._validCellChanges = new HashMap();
        this._invalidCellChanges = new HashMap();
        Iterator<RMAStatus> rmaStatusIter = this._statusList.values().iterator();
        ArrayList<String> statusArray = new ArrayList<String>();
        while (rmaStatusIter.hasNext()) {
            statusArray.add(rmaStatusIter.next().getRmaStatusType());
        }
        Iterator<RMAReason> reasonIter = this._reasonList.values().iterator();
        ArrayList<String> reasonArray = new ArrayList<String>();
        while (reasonIter.hasNext()) {
            reasonArray.add(reasonIter.next().getRmaReasonType());
        }
        this.formattedRMATable.init(new String[]{"RMA Status", "RMA Reason", "RMA Number", "Order Ship Date", "RMA Date", "Customer ID", "Customer Email", "Item SKU", "Item Name"}, "RMAManager", null);
        this.tableModel = this.formattedRMATable.getTableModel();
        this.tableModel.addTableModelListener(this);
        this.formattedRMATable.getFormattedTable().getSelectionModel().addListSelectionListener(this);
        this.formattedRMATable.overwriteCellDefault("RMA Status", statusArray.toArray(new String[0]));
        this.formattedRMATable.overwriteCellDefault("RMA Reason", reasonArray.toArray(new String[0]));
        this.replacementTrackingFieldUpdated = false;
        this.returnTrackingFieldUpdated = false;
        this.rmaCommentsUpdated = false;
        LookupServicesUtil.getDBServices().getRMAList();
        this.formattedRMATable.loadSavedSettings();
        ListenerManager.getInstance().subscribe((GenericListener)this);
        ListenerManager.getInstance().notify((GenericListener)ListenerManager.RMA_LISTENER);
    }

    private void initComponents() {
        this.applyChangesButton = new JButton();
        this.jPanel4 = new JPanel();
        this.searchField = new JTextField();
        this.searchButton = new JButton();
        this.dateRangePanel = new JPanel();
        this.jLabel18 = new JLabel();
        this.jLabel21 = new JLabel();
        this.fromDateChooser = new JDateChooser();
        this.toDateChooser = new JDateChooser();
        this.jPanel2 = new JPanel();
        this.newRmaCheckBox = new JCheckBox();
        this.pendingResponseCheckBox = new JCheckBox();
        this.exchangingCheckBox = new JCheckBox();
        this.returningCheckBox = new JCheckBox();
        this.refundedCheckBox = new JCheckBox();
        this.reshippedCheckBox = new JCheckBox();
        this.returnProcessedCheckBox = new JCheckBox();
        this.returnLabelCheckBox = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.defectiveCheckBox = new JCheckBox();
        this.wrongItemCheckBox = new JCheckBox();
        this.changedMindCheckBox = new JCheckBox();
        this.wrongSizeCheckBox = new JCheckBox();
        this.jScrollPane3 = new JScrollPane();
        this.rmaCommentsTextArea = new JTextArea();
        this.jLabel23 = new JLabel();
        this.jLabel22 = new JLabel();
        this.returnTrackingIdTextField = new JTextField();
        this.jLabel24 = new JLabel();
        this.replacementTrackingIdTextField = new JTextField();
        this.deleteButton = new JButton();
        this.clearChangesButton = new JButton();
        this.formattedRMATable = new FormattedXTable();
        Mnemonics.setLocalizedText((AbstractButton)this.applyChangesButton, (String)NbBundle.getMessage(RmaManagerTopComponent.class, (String)"RmaManagerTopComponent.applyChangesButton.text"));
        this.applyChangesButton.setEnabled(false);
        this.applyChangesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmaManagerTopComponent.this.applyChangesButtonActionPerformed(evt);
            }
        });
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(RmaManagerTopComponent.class, (String)"RmaManagerTopComponent.jPanel4.border.title")));
        this.searchField.setText(NbBundle.getMessage(RmaManagerTopComponent.class, (String)"RmaManagerTopComponent.searchField.text"));
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                RmaManagerTopComponent.this.searchFieldKeyReleased(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.searchButton, (String)NbBundle.getMessage(RmaManagerTopComponent.class, (String)"RmaManagerTopComponent.searchButton.text"));
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmaManagerTopComponent.this.searchButtonActionPerformed(evt);
            }
        });
        this.dateRangePanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(RmaManagerTopComponent.class, (String)"RmaManagerTopComponent.dateRangePanel.border.title")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel18, (String)NbBundle.getMessage(RmaManagerTopComponent.class, (String)"RmaManagerTopComponent.jLabel18.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel21, (String)NbBundle.getMessage(RmaManagerTopComponent.class, (String)"RmaManagerTopComponent.jLabel21.text"));
        GroupLayout dateRangePanelLayout = new GroupLayout(this.dateRangePanel);
        this.dateRangePanel.setLayout(dateRangePanelLayout);
        dateRangePanelLayout.setHorizontalGroup(dateRangePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel18).addComponent((Component)this.fromDateChooser, -2, 112, -2).addComponent(this.jLabel21).addComponent((Component)this.toDateChooser, -1, -1, Short.MAX_VALUE));
        dateRangePanelLayout.linkSize(0, this.jLabel18, this.jLabel21);
        dateRangePanelLayout.setVerticalGroup(dateRangePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dateRangePanelLayout.createSequentialGroup().addComponent(this.jLabel18).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.fromDateChooser, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel21).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.toDateChooser, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(RmaManagerTopComponent.class, (String)"RmaManagerTopComponent.jPanel2.border.title")));
        this.newRmaCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.newRmaCheckBox, (String)NbBundle.getMessage(RmaManagerTopComponent.class, (String)"RmaManagerTopComponent.newRmaCheckBox.text"));
        this.newRmaCheckBox.setHorizontalTextPosition(10);
        this.newRmaCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmaManagerTopComponent.this.newRmaCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.pendingResponseCheckBox, (String)NbBundle.getMessage(RmaManagerTopComponent.class, (String)"RmaManagerTopComponent.pendingResponseCheckBox.text"));
        this.pendingResponseCheckBox.setHorizontalAlignment(11);
        this.pendingResponseCheckBox.setHorizontalTextPosition(10);
        this.pendingResponseCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmaManagerTopComponent.this.pendingResponseCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.exchangingCheckBox, (String)NbBundle.getMessage(RmaManagerTopComponent.class, (String)"RmaManagerTopComponent.exchangingCheckBox.text"));
        this.exchangingCheckBox.setHorizontalTextPosition(10);
        this.exchangingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmaManagerTopComponent.this.exchangingCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.returningCheckBox, (String)NbBundle.getMessage(RmaManagerTopComponent.class, (String)"RmaManagerTopComponent.returningCheckBox.text"));
        this.returningCheckBox.setHorizontalTextPosition(10);
        this.returningCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmaManagerTopComponent.this.returningCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.refundedCheckBox, (String)NbBundle.getMessage(RmaManagerTopComponent.class, (String)"RmaManagerTopComponent.refundedCheckBox.text"));
        this.refundedCheckBox.setHorizontalAlignment(11);
        this.refundedCheckBox.setHorizontalTextPosition(10);
        this.refundedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmaManagerTopComponent.this.refundedCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.reshippedCheckBox, (String)NbBundle.getMessage(RmaManagerTopComponent.class, (String)"RmaManagerTopComponent.reshippedCheckBox.text"));
        this.reshippedCheckBox.setHorizontalAlignment(11);
        this.reshippedCheckBox.setHorizontalTextPosition(10);
        this.reshippedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmaManagerTopComponent.this.reshippedCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.returnProcessedCheckBox, (String)NbBundle.getMessage(RmaManagerTopComponent.class, (String)"RmaManagerTopComponent.returnProcessedCheckBox.text"));
        this.returnProcessedCheckBox.setHorizontalAlignment(11);
        this.returnProcessedCheckBox.setHorizontalTextPosition(10);
        this.returnProcessedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmaManagerTopComponent.this.returnProcessedCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.returnLabelCheckBox, (String)NbBundle.getMessage(RmaManagerTopComponent.class, (String)"RmaManagerTopComponent.returnLabelCheckBox.text"));
        this.returnLabelCheckBox.setHorizontalAlignment(11);
        this.returnLabelCheckBox.setHorizontalTextPosition(10);
        this.returnLabelCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmaManagerTopComponent.this.returnLabelCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.newRmaCheckBox).addComponent(this.pendingResponseCheckBox).addComponent(this.exchangingCheckBox).addComponent(this.returningCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.returnLabelCheckBox).addComponent(this.reshippedCheckBox).addComponent(this.returnProcessedCheckBox).addComponent(this.refundedCheckBox)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.newRmaCheckBox).addComponent(this.returnLabelCheckBox, -2, 23, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pendingResponseCheckBox).addComponent(this.returnProcessedCheckBox)).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.exchangingCheckBox).addComponent(this.reshippedCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.returningCheckBox).addComponent(this.refundedCheckBox, GroupLayout.Alignment.TRAILING))));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(RmaManagerTopComponent.class, (String)"RmaManagerTopComponent.jPanel3.border.title")));
        Mnemonics.setLocalizedText((AbstractButton)this.defectiveCheckBox, (String)NbBundle.getMessage(RmaManagerTopComponent.class, (String)"RmaManagerTopComponent.defectiveCheckBox.text"));
        this.defectiveCheckBox.setHorizontalTextPosition(10);
        this.defectiveCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmaManagerTopComponent.this.defectiveCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.wrongItemCheckBox, (String)NbBundle.getMessage(RmaManagerTopComponent.class, (String)"RmaManagerTopComponent.wrongItemCheckBox.text"));
        this.wrongItemCheckBox.setHorizontalAlignment(11);
        this.wrongItemCheckBox.setHorizontalTextPosition(10);
        this.wrongItemCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmaManagerTopComponent.this.wrongItemCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.changedMindCheckBox, (String)NbBundle.getMessage(RmaManagerTopComponent.class, (String)"RmaManagerTopComponent.changedMindCheckBox.text"));
        this.changedMindCheckBox.setHorizontalTextPosition(10);
        this.changedMindCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmaManagerTopComponent.this.changedMindCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.wrongSizeCheckBox, (String)NbBundle.getMessage(RmaManagerTopComponent.class, (String)"RmaManagerTopComponent.wrongSizeCheckBox.text"));
        this.wrongSizeCheckBox.setHorizontalTextPosition(10);
        this.wrongSizeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmaManagerTopComponent.this.wrongSizeCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.defectiveCheckBox).addComponent(this.wrongItemCheckBox).addComponent(this.changedMindCheckBox).addComponent(this.wrongSizeCheckBox)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addComponent(this.defectiveCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.wrongItemCheckBox).addGap(0, 0, 0).addComponent(this.changedMindCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.wrongSizeCheckBox)));
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -2, -1, -2)).addComponent(this.searchField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dateRangePanel, -2, -1, -2).addComponent(this.searchButton))));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchField, -2, -1, -2).addComponent(this.searchButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.dateRangePanel, -2, 0, Short.MAX_VALUE)).addGap(28, 28, 28)));
        this.rmaCommentsTextArea.setColumns(20);
        this.rmaCommentsTextArea.setLineWrap(true);
        this.rmaCommentsTextArea.setRows(5);
        this.rmaCommentsTextArea.setWrapStyleWord(true);
        this.rmaCommentsTextArea.setEnabled(false);
        this.rmaCommentsTextArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                RmaManagerTopComponent.this.rmaCommentsTextAreaFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                RmaManagerTopComponent.this.rmaCommentsTextAreaFocusLost(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.rmaCommentsTextArea);
        Mnemonics.setLocalizedText((JLabel)this.jLabel23, (String)NbBundle.getMessage(RmaManagerTopComponent.class, (String)"RmaManagerTopComponent.jLabel23.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel22, (String)NbBundle.getMessage(RmaManagerTopComponent.class, (String)"RmaManagerTopComponent.jLabel22.text"));
        this.returnTrackingIdTextField.setText(NbBundle.getMessage(RmaManagerTopComponent.class, (String)"RmaManagerTopComponent.returnTrackingIdTextField.text"));
        this.returnTrackingIdTextField.setEnabled(false);
        this.returnTrackingIdTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmaManagerTopComponent.this.returnTrackingIdTextFieldActionPerformed(evt);
            }
        });
        this.returnTrackingIdTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                RmaManagerTopComponent.this.returnTrackingIdTextFieldFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                RmaManagerTopComponent.this.returnTrackingIdTextFieldFocusLost(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel24, (String)NbBundle.getMessage(RmaManagerTopComponent.class, (String)"RmaManagerTopComponent.jLabel24.text"));
        this.replacementTrackingIdTextField.setText(NbBundle.getMessage(RmaManagerTopComponent.class, (String)"RmaManagerTopComponent.replacementTrackingIdTextField.text"));
        this.replacementTrackingIdTextField.setEnabled(false);
        this.replacementTrackingIdTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmaManagerTopComponent.this.replacementTrackingIdTextFieldActionPerformed(evt);
            }
        });
        this.replacementTrackingIdTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                RmaManagerTopComponent.this.replacementTrackingIdTextFieldFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                RmaManagerTopComponent.this.replacementTrackingIdTextFieldFocusLost(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.deleteButton, (String)NbBundle.getMessage(RmaManagerTopComponent.class, (String)"RmaManagerTopComponent.deleteButton.text"));
        this.deleteButton.setEnabled(false);
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmaManagerTopComponent.this.deleteButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.clearChangesButton, (String)NbBundle.getMessage(RmaManagerTopComponent.class, (String)"RmaManagerTopComponent.clearChangesButton.text"));
        this.clearChangesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmaManagerTopComponent.this.clearChangesButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, -2, 301, -2).addComponent(this.jLabel23)).addGap(33, 33, 33).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel24).addComponent(this.replacementTrackingIdTextField, -2, 262, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel22).addComponent(this.returnTrackingIdTextField, -2, 262, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 27, Short.MAX_VALUE).addComponent(this.clearChangesButton))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.applyChangesButton)).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jPanel4, -2, -1, -2)).addComponent((Component)this.formattedRMATable, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel4, -2, 174, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.formattedRMATable, -1, 182, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel22).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.returnTrackingIdTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel24).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.replacementTrackingIdTextField, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.applyChangesButton).addComponent(this.deleteButton).addComponent(this.clearChangesButton)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel23).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -2, 126, -2))).addContainerGap()));
    }

    private void newRmaCheckBoxActionPerformed(ActionEvent evt) {
        this.disableListener(true);
        this.rmaCommentsTextArea.setText("");
        if (this.newRmaCheckBox.isSelected()) {
            this._statusFilters.add(this._statusList.get("New RMA"));
        } else {
            this._statusFilters.remove(this._statusList.get("New RMA"));
        }
        LookupServicesUtil.getDBServices().setRmaFilters(this.getStatuses(), this.getReasons());
    }

    private void exchangingCheckBoxActionPerformed(ActionEvent evt) {
        this.disableListener(true);
        this.rmaCommentsTextArea.setText("");
        if (this.exchangingCheckBox.isSelected()) {
            this._statusFilters.add(this._statusList.get("Exchanging"));
        } else {
            this._statusFilters.remove(this._statusList.get("Exchanging"));
        }
        LookupServicesUtil.getDBServices().setRmaFilters(this.getStatuses(), this.getReasons());
    }

    private void pendingResponseCheckBoxActionPerformed(ActionEvent evt) {
        this.disableListener(true);
        this.rmaCommentsTextArea.setText("");
        if (this.pendingResponseCheckBox.isSelected()) {
            this._statusFilters.add(this._statusList.get("Pending Response"));
        } else {
            this._statusFilters.remove(this._statusList.get("Pending Response"));
        }
        LookupServicesUtil.getDBServices().setRmaFilters(this.getStatuses(), this.getReasons());
    }

    private void returningCheckBoxActionPerformed(ActionEvent evt) {
        this.disableListener(true);
        this.rmaCommentsTextArea.setText("");
        if (this.returningCheckBox.isSelected()) {
            this._statusFilters.add(this._statusList.get("Returning"));
        } else {
            this._statusFilters.remove(this._statusList.get("Returning"));
        }
        LookupServicesUtil.getDBServices().setRmaFilters(this.getStatuses(), this.getReasons());
    }

    private void returnLabelCheckBoxActionPerformed(ActionEvent evt) {
        this.disableListener(true);
        this.rmaCommentsTextArea.setText("");
        if (this.returnLabelCheckBox.isSelected()) {
            this._statusFilters.add(this._statusList.get("Return Label Issued"));
        } else {
            this._statusFilters.remove(this._statusList.get("Return Label Issued"));
        }
        LookupServicesUtil.getDBServices().setRmaFilters(this.getStatuses(), this.getReasons());
    }

    private void reshippedCheckBoxActionPerformed(ActionEvent evt) {
        this.disableListener(true);
        this.rmaCommentsTextArea.setText("");
        if (this.reshippedCheckBox.isSelected()) {
            this._statusFilters.add(this._statusList.get("Reshipped"));
        } else {
            this._statusFilters.remove(this._statusList.get("Reshipped"));
        }
        LookupServicesUtil.getDBServices().setRmaFilters(this.getStatuses(), this.getReasons());
    }

    private void returnProcessedCheckBoxActionPerformed(ActionEvent evt) {
        this.disableListener(true);
        this.rmaCommentsTextArea.setText("");
        if (this.returnProcessedCheckBox.isSelected()) {
            this._statusFilters.add(this._statusList.get("Return Processed"));
        } else {
            this._statusFilters.remove(this._statusList.get("Return Processed"));
        }
        LookupServicesUtil.getDBServices().setRmaFilters(this.getStatuses(), this.getReasons());
    }

    private void refundedCheckBoxActionPerformed(ActionEvent evt) {
        this.disableListener(true);
        if (this.refundedCheckBox.isSelected()) {
            this._statusFilters.add(this._statusList.get("Refunded"));
        } else {
            this._statusFilters.remove(this._statusList.get("Refunded"));
        }
        LookupServicesUtil.getDBServices().setRmaFilters(this.getStatuses(), this.getReasons());
    }

    private void searchFieldKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10 && null != this.searchField.getText() && !this.searchField.getText().trim().equals("") && this.searchButton.isEnabled()) {
            this.performSearch();
        }
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        if (null != this.searchField.getText()) {
            this.performSearch();
        }
    }

    private void applyChangesButtonActionPerformed(ActionEvent evt) {
        if (this._invalidCellChanges.isEmpty()) {
            this.disableListener(true);
            this._validCellChanges.clear();
            this.rmaCommentsTextArea.setEnabled(false);
            this.replacementTrackingIdTextField.setEnabled(false);
            this.returnTrackingIdTextField.setEnabled(false);
            for (RMADetails rmaDetails : this._updatedRMAs.values()) {
                LookupServicesUtil.getDBServices().updateRMA(rmaDetails);
            }
            this._updatedRMAs.clear();
            this.updateNeeded(false);
            this.tableModel.fireTableDataChanged();
            this.formattedRMATable.getRenderer().setValidCellChanges(this._validCellChanges);
            this.formattedRMATable.getRenderer().setInvalidCellChanges(this._invalidCellChanges);
            this.disableListener(false);
            ListenerManager.getInstance().notify((GenericListener)ListenerManager.RMA_LISTENER);
        } else {
            JOptionPane.showMessageDialog(null, "Please correct all errors before applying changes.");
        }
    }

    private void defectiveCheckBoxActionPerformed(ActionEvent evt) {
        this.disableListener(true);
        this.rmaCommentsTextArea.setText("");
        if (this.defectiveCheckBox.isSelected()) {
            this._reasonFilters.add(this._reasonList.get("Defective"));
        } else {
            this._reasonFilters.remove(this._reasonList.get("Defective"));
        }
        LookupServicesUtil.getDBServices().setRmaFilters(this.getStatuses(), this.getReasons());
    }

    private void wrongItemCheckBoxActionPerformed(ActionEvent evt) {
        this.disableListener(true);
        this.rmaCommentsTextArea.setText("");
        if (this.wrongItemCheckBox.isSelected()) {
            this._reasonFilters.add(this._reasonList.get("Wrong Item"));
        } else {
            this._reasonFilters.remove(this._reasonList.get("Wrong Item"));
        }
        LookupServicesUtil.getDBServices().setRmaFilters(this.getStatuses(), this.getReasons());
    }

    private void changedMindCheckBoxActionPerformed(ActionEvent evt) {
        this.disableListener(true);
        this.rmaCommentsTextArea.setText("");
        if (this.changedMindCheckBox.isSelected()) {
            this._reasonFilters.add(this._reasonList.get("Changed Mind"));
        } else {
            this._reasonFilters.remove(this._reasonList.get("Changed Mind"));
        }
        LookupServicesUtil.getDBServices().setRmaFilters(this.getStatuses(), this.getReasons());
    }

    private void wrongSizeCheckBoxActionPerformed(ActionEvent evt) {
        this.disableListener(true);
        this.rmaCommentsTextArea.setText("");
        if (this.wrongSizeCheckBox.isSelected()) {
            this._reasonFilters.add(this._reasonList.get("Wrong Size"));
        } else {
            this._reasonFilters.remove(this._reasonList.get("Wrong Size"));
        }
        LookupServicesUtil.getDBServices().setRmaFilters(this.getStatuses(), this.getReasons());
    }

    private void rmaCommentsTextAreaFocusGained(FocusEvent evt) {
        this.rmaCommentsUpdated = true;
    }

    private void rmaCommentsTextAreaFocusLost(FocusEvent evt) {
        this.rmaCommentsUpdated();
    }

    private void returnTrackingIdTextFieldActionPerformed(ActionEvent evt) {
        this.returnTrackingUpdated();
    }

    private void returnTrackingIdTextFieldFocusLost(FocusEvent evt) {
        this.returnTrackingUpdated();
    }

    private void replacementTrackingIdTextFieldActionPerformed(ActionEvent evt) {
        this.replacementTrackingUpdated();
    }

    private void replacementTrackingIdTextFieldFocusLost(FocusEvent evt) {
        this.replacementTrackingUpdated();
    }

    private void returnTrackingIdTextFieldFocusGained(FocusEvent evt) {
        this.returnTrackingFieldUpdated = true;
    }

    private void replacementTrackingIdTextFieldFocusGained(FocusEvent evt) {
        this.replacementTrackingFieldUpdated = true;
    }

    private ArrayList<RMADetails> getRowDetails() {
        ArrayList<RMADetails> rmaList = new ArrayList<RMADetails>();
        try {
            for (int row : this.formattedRMATable.getFormattedTable().getSelectedRows()) {
                String value = this.formattedRMATable.getValue(row, "RMA Number");
                rmaList.add(this.RMAList.get(value.toString()));
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        return rmaList;
    }

    private RMADetails getSelectedDetail() {
        if (this.formattedRMATable.getFormattedTable().getSelectedRow() >= 0) {
            try {
                String value = this.formattedRMATable.getValue(this.formattedRMATable.getFormattedTable().getSelectedRow(), "RMA Number");
                RMADetails detail = this.RMAList.get(value.toString());
                return detail;
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return null;
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        this.disableListener(true);
        for (RMADetails detail : this.getRowDetails()) {
            LookupServicesUtil.getDBServices().deleteRMA(detail);
        }
        this.disableListener(false);
        ListenerManager.getInstance().notify((GenericListener)ListenerManager.RMA_LISTENER);
    }

    private void clearChangesButtonActionPerformed(ActionEvent evt) {
        this._invalidCellChanges.clear();
        this._updatedRMAs.clear();
        this._validCellChanges.clear();
        this.updateNeeded(false);
        ListenerManager.getInstance().notify((GenericListener)ListenerManager.RMA_LIST_LISTENER);
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    public static synchronized RmaManagerTopComponent getDefault() {
        if (instance == null) {
            instance = new RmaManagerTopComponent();
        }
        return instance;
    }

    public static synchronized RmaManagerTopComponent findInstance() {
        if (instance == null) {
            instance = new RmaManagerTopComponent();
        }
        return instance;
    }

    private void readPropertiesImpl(Properties p) {
        String version = p.getProperty("version");
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    public void disableListener(boolean disabled) {
        this.disableListener = disabled;
    }

    private Integer[] getStatuses() {
        Integer[] filters = new Integer[this._statusFilters.size()];
        int counter = 0;
        for (RMAStatus status : this._statusFilters) {
            filters[counter++] = status.getRmaStatusID();
        }
        return filters;
    }

    private Integer[] getReasons() {
        Integer[] filters = new Integer[this._reasonFilters.size()];
        int counter = 0;
        for (RMAReason reason : this._reasonFilters) {
            filters[counter++] = reason.getRmaReasonID();
        }
        return filters;
    }

    private void performSearch() {
        long searchFrom = 0L;
        long searchTo = 0L;
        if (null != this.fromDateChooser.getDate()) {
            searchFrom = this.fromDateChooser.getDate().getTime();
        }
        if (null != this.toDateChooser.getDate()) {
            searchTo = this.toDateChooser.getDate().getTime();
        }
        LookupServicesUtil.getDBServices().searchRMADetails(this.sanitize(this.searchField.getText()), searchFrom, searchTo);
    }

    public String sanitize(String uncleanString) {
        String sanitizedString;
        if (null != uncleanString) {
            sanitizedString = uncleanString.replace("'", "");
            sanitizedString = sanitizedString.replace("\"", "");
            sanitizedString = sanitizedString.replace("--", "");
            sanitizedString = sanitizedString.trim().toUpperCase();
        } else {
            sanitizedString = "";
        }
        return sanitizedString;
    }

    public void RMAListUpdated() {
        if (!this.applyChangesButton.isEnabled()) {
            this.rmaCommentsTextArea.setEnabled(false);
            this.replacementTrackingIdTextField.setEnabled(false);
            this.returnTrackingIdTextField.setEnabled(false);
            this.rmaCommentsTextArea.setText("");
            this.replacementTrackingIdTextField.setText("");
            this.returnTrackingIdTextField.setText("");
            this.disableListener(true);
            this.updateRMAs();
            this.disableListener(false);
        }
    }

    public void updateRMAs() {
        this.RMAList.clear();
        this.tableModel.setNumRows(0);
        for (RMADetails detail : LookupServicesUtil.getDBServices().getRMAList()) {
            this.RMAList.put(String.valueOf(detail.getRmaNumberID()), detail);
            Object[] row = new Object[this.tableModel.getColumnCount()];
            row[((Integer)this.formattedRMATable.getReverseColumnMap().get((Object)"RMA Status")).intValue()] = LookupServicesUtil.getDBServices().getRMAStatus(detail.getRmaStatusID()).getRmaStatusType();
            row[((Integer)this.formattedRMATable.getReverseColumnMap().get((Object)"RMA Reason")).intValue()] = LookupServicesUtil.getDBServices().getRMAReason(detail.getRmaReasonID()).getRmaReasonType();
            row[((Integer)this.formattedRMATable.getReverseColumnMap().get((Object)"RMA Number")).intValue()] = detail.getRmaNumberID();
            if (null != detail.getOrderDetails().getShipDate()) {
                row[((Integer)this.formattedRMATable.getReverseColumnMap().get((Object)"Order Ship Date")).intValue()] = detail.getOrderDetails().getShipDate().toString();
            }
            row[((Integer)this.formattedRMATable.getReverseColumnMap().get((Object)"RMA Date")).intValue()] = detail.getRmaDate().toString();
            row[((Integer)this.formattedRMATable.getReverseColumnMap().get((Object)"Customer ID")).intValue()] = detail.getCustomerUsername();
            row[((Integer)this.formattedRMATable.getReverseColumnMap().get((Object)"Customer Email")).intValue()] = detail.getCustomer().getCustomerEmail();
            row[((Integer)this.formattedRMATable.getReverseColumnMap().get((Object)"Item SKU")).intValue()] = detail.getOrderDetails().getItemID();
            row[((Integer)this.formattedRMATable.getReverseColumnMap().get((Object)"Item Name")).intValue()] = detail.getOrderDetails().getOrderDescription();
            this.tableModel.addRow(row);
        }
        this.formattedRMATable.getFormattedTable().packAll();
    }

    private void updateNeeded(boolean dataChanged) {
        this.searchButton.setEnabled(!dataChanged);
        this.applyChangesButton.setEnabled(dataChanged);
        this.deleteButton.setEnabled(!dataChanged && this.formattedRMATable.getFormattedTable().getSelectedRow() != -1 && !this.applyChangesButton.isEnabled());
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.returnTrackingFieldUpdated) {
            this.returnTrackingUpdated();
        }
        if (this.replacementTrackingFieldUpdated) {
            this.replacementTrackingUpdated();
        }
        if (this.rmaCommentsUpdated) {
            this.rmaCommentsUpdated();
        }
        this.updateAdditionalDetails();
        this.deleteButton.setEnabled(this.formattedRMATable.getFormattedTable().getSelectedRow() != -1 && !this.applyChangesButton.isEnabled());
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (!this.disableListener) {
            this.disableListener(true);
            int row = this.formattedRMATable.getFormattedTable().getSelectedRow();
            String value = this.formattedRMATable.getValue(row, "RMA Number");
            RMADetails rmaDetails = this.RMAList.get(value.toString());
            boolean valid = true;
            this._updatedRMAs.put(rmaDetails.getRmaNumberID(), rmaDetails);
            if (e.getColumn() == ((Integer)this.formattedRMATable.getReverseColumnMap().get("RMA Status")).intValue()) {
                RMAStatus status = this._statusList.get(this.formattedRMATable.getValue(row, e.getColumn()).toString());
                rmaDetails.setRmaStatusID(status.getRmaStatusID());
                this.processUpdatedCell(row, e.getColumn(), valid);
            } else if (e.getColumn() == ((Integer)this.formattedRMATable.getReverseColumnMap().get("RMA Reason")).intValue()) {
                RMAReason reason = this._reasonList.get(this.formattedRMATable.getValue(row, e.getColumn()).toString());
                rmaDetails.setRmaReasonID(reason.getRmaReasonID());
                this.processUpdatedCell(row, e.getColumn(), valid);
            } else if (e.getColumn() == ((Integer)this.formattedRMATable.getReverseColumnMap().get("RMA Date")).intValue()) {
                String date = this.formattedRMATable.getValue(row, e.getColumn()).toString();
                try {
                    Date today;
                    if (date.contains("/") && date.length() == 8) {
                        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yy");
                        today = new Date(df.parse(date).getTime());
                    } else if (date.contains("/") && date.length() == 10) {
                        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
                        today = new Date(df.parse(date).getTime());
                    } else if (date.length() == 10) {
                        today = Date.valueOf(date);
                    } else {
                        throw new Exception();
                    }
                    rmaDetails.setRmaDate(today);
                }
                catch (Exception ex) {
                    ErrorsUtil.getInstance().logError(ex);
                    valid = false;
                }
                this.processUpdatedCell(row, e.getColumn(), valid);
            }
            this.formattedRMATable.getRenderer().setValidCellChanges(this._validCellChanges);
            this.formattedRMATable.getRenderer().setInvalidCellChanges(this._invalidCellChanges);
            this.disableListener(false);
            this.updateAdditionalDetails();
            this.updateNeeded(true);
        }
    }

    private void processUpdatedCell(int row, int column, boolean valid) {
        if (valid) {
            this._validCellChanges.put(this.getUpdatedCellKey(row, column), new ChangedCell(row, column));
            this._invalidCellChanges.remove(this.getUpdatedCellKey(row, column));
        } else {
            this._invalidCellChanges.put(this.getUpdatedCellKey(row, column), new ChangedCell(row, column));
            this._validCellChanges.remove(this.getUpdatedCellKey(row, column));
        }
    }

    private String getUpdatedCellKey(int row, int column) {
        return "Row" + row + "Column" + column;
    }

    private ChangedCell checkValidCell(int row, int column) {
        return this._validCellChanges.get(this.getUpdatedCellKey(row, column));
    }

    private ChangedCell checkInvalidCell(int row, int column) {
        return this._invalidCellChanges.get(this.getUpdatedCellKey(row, column));
    }

    private void updateAdditionalDetails() {
        if (!this.disableListener) {
            this.rmaCommentsTextArea.setEnabled(true);
            this.replacementTrackingIdTextField.setEnabled(true);
            this.returnTrackingIdTextField.setEnabled(true);
            RMADetails rmaDetails = this.getSelectedDetail();
            if (rmaDetails != null) {
                if (null != rmaDetails.getRmaComments()) {
                    this.rmaCommentsTextArea.setText(rmaDetails.getRmaComments());
                }
                if (null != rmaDetails.getReplacementTracking()) {
                    this.replacementTrackingIdTextField.setText(rmaDetails.getReplacementTracking());
                }
                if (null != rmaDetails.getReturnTracking()) {
                    this.returnTrackingIdTextField.setText(rmaDetails.getReturnTracking());
                }
            }
        }
    }

    private void replacementTrackingUpdated() {
        RMADetails rmaDetails;
        if (null != this.replacementTrackingIdTextField.getText() && (rmaDetails = this.getSelectedDetail()) != null) {
            boolean validString;
            this.replacementTrackingIdTextField.setText(this.replacementTrackingIdTextField.getText().trim());
            boolean bl = validString = !this.replacementTrackingIdTextField.getText().matches("^.*[^a-zA-Z0-9 ].*$");
            if (!validString) {
                JOptionPane.showMessageDialog(null, "Tracking number can only contain alphanumeric characters");
                this.replacementTrackingIdTextField.setText("");
            }
            rmaDetails.setReplacementTracking(this.replacementTrackingIdTextField.getText());
            this._updatedRMAs.put(rmaDetails.getRmaNumberID(), rmaDetails);
            this.updateNeeded(true);
        }
        this.replacementTrackingFieldUpdated = false;
    }

    private void returnTrackingUpdated() {
        RMADetails rmaDetails;
        if (null != this.returnTrackingIdTextField.getText() && (rmaDetails = this.getSelectedDetail()) != null) {
            boolean validString;
            this.returnTrackingIdTextField.setText(this.returnTrackingIdTextField.getText().trim());
            boolean bl = validString = !this.returnTrackingIdTextField.getText().matches("^.*[^a-zA-Z0-9 ].*$");
            if (!validString) {
                JOptionPane.showMessageDialog(null, "Tracking number can only contain alphanumeric characters");
                this.returnTrackingIdTextField.setText("");
            }
            rmaDetails.setReturnTracking(this.returnTrackingIdTextField.getText());
            this._updatedRMAs.put(rmaDetails.getRmaNumberID(), rmaDetails);
            this.updateNeeded(true);
        }
        this.returnTrackingFieldUpdated = false;
    }

    private void rmaCommentsUpdated() {
        RMADetails rmaDetails;
        if (null != this.rmaCommentsTextArea.getText() && (rmaDetails = this.getSelectedDetail()) != null && !rmaDetails.getRmaComments().equals(this.rmaCommentsTextArea.getText())) {
            rmaDetails.setRmaComments(this.rmaCommentsTextArea.getText());
            this._updatedRMAs.put(rmaDetails.getRmaNumberID(), rmaDetails);
            this.updateNeeded(true);
        }
        this.rmaCommentsUpdated = false;
    }
}

