/*
 * Decompiled with CFR 0.152.
 */
package pnp.managers.website;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import pnp.services.datatypes.CategoryAssociation;
import pnp.services.datatypes.FeedContainer;
import pnp.services.listener.CategoryListListener;
import pnp.services.listener.GenericListener;
import pnp.services.listenermanager.ListenerManager;
import pnp.services.util.LookupServicesUtil;

public class AssociationManager
extends JDialog
implements CategoryListListener {
    private HashMap<String, Integer> categoryMap;
    private HashMap<String, FeedContainer> feeds;
    private HashMap<Integer, CategoryAssociation> associations;
    private boolean listener;
    private JList bingList;
    private JComboBox bingMainCategory;
    private JComboBox bingSubCategory;
    private JComboBox bingTertiaryCategory;
    private JComboBox categorySelector;
    private JButton createAssociationButton;
    private JList googleList;
    private JComboBox googleMainCategory;
    private JComboBox googleSubCategory;
    private JComboBox googleTertiaryCategory;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;

    public AssociationManager(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.init();
    }

    private void init() {
        this.listener = false;
        this.createVendorFeeds();
        this.fillOurCategories();
        this.listener = true;
        this.handleListAndComboCreation("Bing", this.bingMainCategory, this.bingSubCategory, this.bingTertiaryCategory, this.bingList, false);
        this.handleListAndComboCreation("Google", this.googleMainCategory, this.googleSubCategory, this.googleTertiaryCategory, this.googleList, false);
        this.categorySelector.setSelectedItem(this.categorySelector.getSelectedItem());
    }

    private void createVendorFeeds() {
        if (this.feeds == null) {
            this.feeds = new HashMap();
        } else {
            this.feeds.clear();
        }
        try {
            this.fillVendorCategories("Google", "googleCategories.txt", ">");
            this.fillVendorCategories("Bing", "bingCategories.txt", ">");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String[] readLines(String fileName) {
        ArrayList<String> allLines = new ArrayList<String>();
        try {
            String strLine;
            InputStream in = this.getClass().getResourceAsStream(fileName);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((strLine = br.readLine()) != null) {
                allLines.add(strLine.trim());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return allLines.toArray(new String[0]);
    }

    private void fillVendorCategories(String vendorName, String categoryFileLocation, String lineDelimiter) {
        HashMap mainHash = new HashMap();
        HashMap mainToSub = new HashMap();
        HashMap subHash = new HashMap();
        HashMap subToTert = new HashMap();
        HashMap tertHash = new HashMap();
        try {
            Object[] allLines = this.readLines(categoryFileLocation);
            Arrays.sort(allLines);
            for (Object line : allLines) {
                line = ((String)line).trim();
                String[] splitLines = ((String)line).split(lineDelimiter);
                String mainCategory = "";
                String subCategory = "";
                String tertCategory = "";
                if (splitLines.length >= 1) {
                    mainCategory = splitLines[0].trim();
                }
                if (splitLines.length >= 2) {
                    subCategory = splitLines[1].trim();
                }
                if (splitLines.length >= 3) {
                    tertCategory = splitLines[2].trim();
                }
                if (mainCategory.isEmpty()) continue;
                if (!mainHash.containsKey(mainCategory)) {
                    mainHash.put(mainCategory, new HashSet());
                }
                ((HashSet)mainHash.get(mainCategory)).add(line);
                if (subCategory.isEmpty()) continue;
                if (!subHash.containsKey(subCategory)) {
                    subHash.put(subCategory, new HashSet());
                }
                ((HashSet)subHash.get(subCategory)).add(line);
                if (!mainToSub.containsKey(mainCategory)) {
                    mainToSub.put(mainCategory, new HashSet());
                }
                ((HashSet)mainToSub.get(mainCategory)).add(subCategory);
                if (tertCategory.isEmpty()) continue;
                if (!tertHash.containsKey(tertCategory)) {
                    tertHash.put(tertCategory, new HashSet());
                }
                ((HashSet)tertHash.get(tertCategory)).add(line);
                if (!subToTert.containsKey(subCategory)) {
                    subToTert.put(subCategory, new HashSet());
                }
                ((HashSet)subToTert.get(subCategory)).add(tertCategory);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        FeedContainer container = new FeedContainer();
        container.setFeedName(vendorName);
        container.setMainHash(mainHash);
        container.setSubHash(subHash);
        container.setTertHash(tertHash);
        container.setMainToSub(mainToSub);
        container.setSubToTert(subToTert);
        this.feeds.put(vendorName, container);
    }

    @Override
    public void setVisible(boolean b) {
        this.fillOurCategories();
        super.setVisible(b);
    }

    private void fillOurCategories() {
        boolean originalListenerState = this.listener;
        this.listener = false;
        this.associations = LookupServicesUtil.getDBServices().getCategoryAssociations();
        if (this.categoryMap == null) {
            this.categoryMap = new HashMap();
        } else {
            this.categoryMap.clear();
        }
        Object[] categories = LookupServicesUtil.getDBServices().getCategories();
        Arrays.sort(categories);
        this.categorySelector.removeAllItems();
        for (Object category : categories) {
            this.categorySelector.addItem(category.getCategoryName());
            this.categoryMap.put(category.getCategoryName(), category.getCategoryID());
        }
        this.listener = true;
        this.categorySelector.setSelectedItem(this.categorySelector.getSelectedItem());
        this.listener = originalListenerState;
    }

    private void handleObjects() {
        boolean categorySelectorValid = this.categorySelector != null && this.categorySelector.getSelectedItem() != null && this.categorySelector.getSelectedItem().toString() != null && !this.categorySelector.getSelectedItem().toString().isEmpty();
        boolean googleMainValid = this.googleMainCategory != null && this.googleMainCategory.getSelectedItem() != null && this.googleMainCategory.getSelectedItem().toString() != null && !this.googleMainCategory.getSelectedItem().toString().isEmpty() && !this.googleMainCategory.getSelectedItem().toString().equalsIgnoreCase("All");
        boolean googleSubValid = this.googleSubCategory != null && this.googleSubCategory.getSelectedItem() != null && this.googleSubCategory.getSelectedItem().toString() != null && !this.googleSubCategory.getSelectedItem().toString().isEmpty() && !this.googleSubCategory.getSelectedItem().toString().equalsIgnoreCase("All");
        boolean bingMainValid = this.bingMainCategory != null && this.bingMainCategory.getSelectedItem() != null && this.bingMainCategory.getSelectedItem().toString() != null && !this.bingMainCategory.getSelectedItem().toString().isEmpty() && !this.bingMainCategory.getSelectedItem().toString().equalsIgnoreCase("All");
        boolean bingSubValid = this.bingSubCategory != null && this.bingSubCategory.getSelectedItem() != null && this.bingSubCategory.getSelectedItem().toString() != null && !this.bingSubCategory.getSelectedItem().toString().isEmpty() && !this.bingSubCategory.getSelectedItem().toString().equalsIgnoreCase("All");
        this.googleMainCategory.setEnabled(categorySelectorValid);
        this.googleSubCategory.setEnabled(googleMainValid);
        this.googleTertiaryCategory.setEnabled(googleMainValid && googleSubValid);
        this.bingMainCategory.setEnabled(categorySelectorValid);
        this.bingSubCategory.setEnabled(bingMainValid);
        this.bingTertiaryCategory.setEnabled(bingMainValid && bingSubValid);
        boolean googleListOrBingList = this.googleList.getSelectedValue() != null || this.bingList.getSelectedValue() != null;
        this.createAssociationButton.setEnabled(categorySelectorValid && googleListOrBingList);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.categorySelector = new JComboBox();
        this.jPanel3 = new JPanel();
        this.jPanel7 = new JPanel();
        this.googleTertiaryCategory = new JComboBox();
        this.jLabel3 = new JLabel();
        this.googleSubCategory = new JComboBox();
        this.jLabel2 = new JLabel();
        this.googleMainCategory = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jPanel8 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.googleList = new JList();
        this.jPanel4 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jLabel6 = new JLabel();
        this.bingMainCategory = new JComboBox();
        this.jLabel5 = new JLabel();
        this.bingSubCategory = new JComboBox();
        this.jLabel4 = new JLabel();
        this.bingTertiaryCategory = new JComboBox();
        this.jPanel6 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.bingList = new JList();
        this.createAssociationButton = new JButton();
        this.jButton1 = new JButton();
        this.setDefaultCloseOperation(2);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(AssociationManager.class, (String)"AssociationManager.jPanel1.border.title")));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(AssociationManager.class, (String)"AssociationManager.jPanel2.border.title")));
        this.categorySelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssociationManager.this.categorySelectorActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.categorySelector, 0, 237, Short.MAX_VALUE).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.categorySelector, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(AssociationManager.class, (String)"AssociationManager.jPanel3.border.title")));
        this.googleTertiaryCategory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssociationManager.this.googleTertiaryCategoryActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(AssociationManager.class, (String)"AssociationManager.jLabel3.text"));
        this.googleSubCategory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssociationManager.this.googleSubCategoryActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(AssociationManager.class, (String)"AssociationManager.jLabel2.text"));
        this.googleMainCategory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssociationManager.this.googleMainCategoryActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(AssociationManager.class, (String)"AssociationManager.jLabel1.text"));
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3).addGroup(jPanel7Layout.createSequentialGroup().addGap(10, 10, 10).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.googleMainCategory, 0, -1, Short.MAX_VALUE).addComponent(this.googleSubCategory, 0, -1, Short.MAX_VALUE).addComponent(this.googleTertiaryCategory, 0, 137, Short.MAX_VALUE)))).addContainerGap()));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.googleMainCategory, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.googleSubCategory, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.googleTertiaryCategory, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.googleList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                AssociationManager.this.googleListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.googleList);
        GroupLayout jPanel8Layout = new GroupLayout(this.jPanel8);
        this.jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1).addContainerGap()));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 293, Short.MAX_VALUE).addContainerGap()));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel7, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel8, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel8, -2, -1, -2).addComponent(this.jPanel7, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(AssociationManager.class, (String)"AssociationManager.jPanel4.border.title")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(AssociationManager.class, (String)"AssociationManager.jLabel6.text"));
        this.bingMainCategory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssociationManager.this.bingMainCategoryActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(AssociationManager.class, (String)"AssociationManager.jLabel5.text"));
        this.bingSubCategory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssociationManager.this.bingSubCategoryActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(AssociationManager.class, (String)"AssociationManager.jLabel4.text"));
        this.bingTertiaryCategory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssociationManager.this.bingTertiaryCategoryActionPerformed(evt);
            }
        });
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.jLabel5).addComponent(this.jLabel4).addGroup(jPanel5Layout.createSequentialGroup().addGap(10, 10, 10).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bingMainCategory, 0, -1, Short.MAX_VALUE).addComponent(this.bingSubCategory, 0, -1, Short.MAX_VALUE).addComponent(this.bingTertiaryCategory, 0, 137, Short.MAX_VALUE)))).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bingMainCategory, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bingSubCategory, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bingTertiaryCategory, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.bingList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                AssociationManager.this.bingListValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.bingList);
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2).addContainerGap()));
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE).addGap(2, 2, 2)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jPanel5, -2, -1, -2).addGap(0, 161, Short.MAX_VALUE)).addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        Mnemonics.setLocalizedText((AbstractButton)this.createAssociationButton, (String)NbBundle.getMessage(AssociationManager.class, (String)"AssociationManager.createAssociationButton.text"));
        this.createAssociationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssociationManager.this.createAssociationButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(AssociationManager.class, (String)"AssociationManager.jButton1.text"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssociationManager.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel4, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGap(242, 242, 242).addComponent(this.jPanel2, -2, -1, -2).addGap(0, 251, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.createAssociationButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton1))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.createAssociationButton).addComponent(this.jButton1))));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void handleListAndComboCreation(String vendorName, JComboBox mainCategory, JComboBox subCategory, JComboBox tertCategory, JList list, boolean selectedItem) {
        if (this.listener) {
            this.listener = false;
            if (!selectedItem) {
                FeedContainer container = this.feeds.get(vendorName);
                String mainCategoryString = "All";
                String subCategoryString = "All";
                String tertCategoryString = "All";
                if (mainCategory.getSelectedItem() != null) {
                    mainCategoryString = mainCategory.getSelectedItem().toString();
                }
                if (subCategory.getSelectedItem() != null) {
                    subCategoryString = subCategory.getSelectedItem().toString();
                }
                if (tertCategory.getSelectedItem() != null) {
                    tertCategoryString = tertCategory.getSelectedItem().toString();
                }
                if (subCategoryString.equalsIgnoreCase("All")) {
                    tertCategory.setSelectedItem("All");
                } else if (mainCategoryString.equalsIgnoreCase("All")) {
                    subCategory.setSelectedItem("All");
                    tertCategory.setSelectedItem("All");
                }
                Object[] listData = container.getFeeds(mainCategoryString, subCategoryString, tertCategoryString).toArray(new String[0]);
                Arrays.sort(listData);
                list.setListData(listData);
                this.developComboBoxes(vendorName, mainCategory, subCategory, tertCategory);
            }
            this.listener = true;
        }
        this.handleObjects();
    }

    private void developComboBoxes(String vendorName, JComboBox mainCategory, JComboBox subCategory, JComboBox tertCategory) {
        String mainCategoryString = "All";
        String subCategoryString = "All";
        String tertCategoryString = "All";
        if (mainCategory.getSelectedItem() != null) {
            mainCategoryString = mainCategory.getSelectedItem().toString();
        }
        if (subCategory.getSelectedItem() != null) {
            subCategoryString = subCategory.getSelectedItem().toString();
        }
        if (tertCategory.getSelectedItem() != null) {
            tertCategoryString = tertCategory.getSelectedItem().toString();
        }
        FeedContainer container = this.feeds.get(vendorName);
        HashSet mainCategories = new HashSet(container.getMainHash().keySet());
        HashSet subCategories = new HashSet();
        HashSet tertCategories = new HashSet();
        if (container.getMainToSub().containsKey(mainCategoryString)) {
            subCategories.addAll((Collection)container.getMainToSub().get(mainCategoryString));
        }
        if (container.getSubToTert().containsKey(subCategoryString)) {
            tertCategories.addAll((Collection)container.getSubToTert().get(subCategoryString));
        }
        Object[] mainCategoriesArray = mainCategories.toArray(new String[0]);
        Arrays.sort(mainCategoriesArray);
        Object[] subCategoriesArray = subCategories.toArray(new String[0]);
        Arrays.sort(subCategoriesArray);
        Object[] tertCategoriesArray = tertCategories.toArray(new String[0]);
        Arrays.sort(tertCategoriesArray);
        mainCategory.removeAllItems();
        subCategory.removeAllItems();
        tertCategory.removeAllItems();
        mainCategory.addItem("All");
        subCategory.addItem("All");
        tertCategory.addItem("All");
        for (Object category : mainCategoriesArray) {
            mainCategory.addItem(category);
        }
        for (Object category : subCategoriesArray) {
            subCategory.addItem(category);
        }
        for (Object category : tertCategoriesArray) {
            tertCategory.addItem(category);
        }
        mainCategory.setSelectedItem(mainCategoryString);
        subCategory.setSelectedItem(subCategoryString);
        tertCategory.setSelectedItem(tertCategoryString);
    }

    private void createAssociation() {
        String ourCategory = "";
        String bingCategory = "";
        String googleCategory = "";
        if (this.categorySelector.getSelectedItem() != null) {
            ourCategory = this.categorySelector.getSelectedItem().toString();
        }
        if (this.bingList.getSelectedValue() != null) {
            bingCategory = this.bingList.getSelectedValue().toString();
        }
        if (this.googleList.getSelectedValue() != null) {
            googleCategory = this.googleList.getSelectedValue().toString();
        }
        if (ourCategory != null && !ourCategory.isEmpty() && this.categoryMap.containsKey(ourCategory) && (googleCategory != null && !googleCategory.isEmpty() || bingCategory != null && !bingCategory.isEmpty())) {
            CategoryAssociation association = new CategoryAssociation();
            association.setBingCategoryName(bingCategory);
            association.setGoogleCategoryName(googleCategory);
            association.setCategoryID(this.categoryMap.get(ourCategory).intValue());
            LookupServicesUtil.getDBServices().updateCategoryAssociations(association);
            this.associations = LookupServicesUtil.getDBServices().getCategoryAssociations();
            ListenerManager.getInstance().notify((GenericListener)ListenerManager.WEBSITE_ITEM_LIST_LISTENER);
            JOptionPane.showMessageDialog(null, "Created association for: " + ourCategory);
        }
    }

    private void getAssociation() {
        this.googleList.clearSelection();
        this.bingList.clearSelection();
        if (this.associations != null && this.categorySelector.getSelectedItem() != null && this.categoryMap != null && this.categoryMap.containsKey(this.categorySelector.getSelectedItem().toString()) && this.associations.containsKey(this.categoryMap.get(this.categorySelector.getSelectedItem().toString()))) {
            CategoryAssociation association = this.associations.get(this.categoryMap.get(this.categorySelector.getSelectedItem().toString()));
            if (association.getBingCategoryName() != null && !association.getBingCategoryName().isEmpty()) {
                this.bingList.setSelectedValue(association.getBingCategoryName(), true);
            }
            if (association.getGoogleCategoryName() != null && !association.getGoogleCategoryName().isEmpty()) {
                this.googleList.setSelectedValue(association.getGoogleCategoryName(), true);
            }
        }
    }

    private void googleMainCategoryActionPerformed(ActionEvent evt) {
        this.handleListAndComboCreation("Google", this.googleMainCategory, this.googleSubCategory, this.googleTertiaryCategory, this.googleList, false);
    }

    private void googleSubCategoryActionPerformed(ActionEvent evt) {
        this.handleListAndComboCreation("Google", this.googleMainCategory, this.googleSubCategory, this.googleTertiaryCategory, this.googleList, false);
    }

    private void googleTertiaryCategoryActionPerformed(ActionEvent evt) {
        this.handleListAndComboCreation("Google", this.googleMainCategory, this.googleSubCategory, this.googleTertiaryCategory, this.googleList, false);
    }

    private void bingMainCategoryActionPerformed(ActionEvent evt) {
        this.handleListAndComboCreation("Bing", this.bingMainCategory, this.bingSubCategory, this.bingTertiaryCategory, this.bingList, false);
    }

    private void bingSubCategoryActionPerformed(ActionEvent evt) {
        this.handleListAndComboCreation("Bing", this.bingMainCategory, this.bingSubCategory, this.bingTertiaryCategory, this.bingList, false);
    }

    private void bingTertiaryCategoryActionPerformed(ActionEvent evt) {
        this.handleListAndComboCreation("Bing", this.bingMainCategory, this.bingSubCategory, this.bingTertiaryCategory, this.bingList, false);
    }

    private void bingListValueChanged(ListSelectionEvent evt) {
        this.handleListAndComboCreation("Bing", this.bingMainCategory, this.bingSubCategory, this.bingTertiaryCategory, this.bingList, true);
    }

    private void googleListValueChanged(ListSelectionEvent evt) {
        this.handleListAndComboCreation("Google", this.googleMainCategory, this.googleSubCategory, this.googleTertiaryCategory, this.googleList, true);
    }

    private void createAssociationButtonActionPerformed(ActionEvent evt) {
        this.createAssociation();
    }

    private void categorySelectorActionPerformed(ActionEvent evt) {
        this.getAssociation();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.bingMainCategory.setSelectedItem("All");
        this.googleMainCategory.setSelectedItem("All");
        this.categorySelector.setSelectedItem(this.categorySelector.getSelectedItem());
    }

    public void categoryListUpdated() {
        this.fillOurCategories();
    }

    public HashMap<Integer, CategoryAssociation> getAssociations() {
        return this.associations;
    }
}

