/*
 * Decompiled with CFR 0.152.
 */
package pnp.managers.website;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import pnp.services.datatypes.Category;
import pnp.services.datatypes.webservices.WebsiteProduct;
import pnp.services.listener.CategoryListListener;
import pnp.services.listener.GenericListener;
import pnp.services.listenermanager.ListenerManager;
import pnp.services.util.ErrorsUtil;
import pnp.services.util.GenericFunctions;
import pnp.services.util.LookupServicesUtil;

public class CategoryManager
extends JDialog
implements CategoryListListener {
    private boolean listener = false;
    private boolean textListener = false;
    private boolean selectedListener = false;
    private final HashMap<String, String> categoryList = new HashMap();
    private final HashMap<String, Boolean> categoryUsed = new HashMap();
    private final HashMap<Integer, String> categoryIDList = new HashMap();
    private final HashMap<String, Integer> reverseCategoryIDList = new HashMap();
    private HashMap<String, WebsiteProduct> websiteList = new HashMap();
    private String selectedCategory = "None";
    private String updatedCategory = "None";
    private JButton addButton;
    private JButton editButton;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JButton mergeButton;
    private JButton removeButton;
    private JComboBox selectedCategoryBox;
    private JComboBox updatedCategoryBox;
    private JTextField updatedCategoryField;

    public CategoryManager(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.init();
        ListenerManager.getInstance().subscribe((GenericListener)this);
    }

    private void init() {
        this.refreshCategories();
        this.handleButtons('a', false);
        this.listener = true;
        this.textListener = true;
        this.selectedListener = true;
    }

    public void setWebsiteList(HashMap<String, WebsiteProduct> websiteList) {
        this.websiteList = websiteList;
        this.refreshCategories();
    }

    private synchronized void refreshCategories() {
        try {
            this.listener = false;
            this.textListener = false;
            this.selectedListener = false;
            this.selectedCategoryBox.removeAllItems();
            this.updatedCategoryBox.removeAllItems();
            this.categoryList.clear();
            this.categoryIDList.clear();
            this.categoryUsed.clear();
            this.reverseCategoryIDList.clear();
            this.updatedCategoryField.setText("");
            Object[] categories = LookupServicesUtil.getDBServices().getCategories();
            Arrays.sort(categories);
            this.selectedCategoryBox.addItem("None");
            this.updatedCategoryBox.addItem("None");
            this.categoryList.put("none", "None");
            for (Object category : categories) {
                this.selectedCategoryBox.addItem(category.getCategoryName());
                this.updatedCategoryBox.addItem(category.getCategoryName());
                this.categoryIDList.put(category.getCategoryID(), category.getCategoryName());
                this.reverseCategoryIDList.put(category.getCategoryName(), category.getCategoryID());
                if (this.categoryList.containsKey(category.getCategoryName().toLowerCase().trim())) {
                    this.selectedCategory = category.getCategoryName();
                    this.updatedCategory = this.categoryList.get(category.getCategoryName().toLowerCase().trim());
                    this.mergeButtonActionPerformed(null);
                }
                this.categoryList.put(category.getCategoryName().toLowerCase().trim(), category.getCategoryName().trim());
            }
            for (WebsiteProduct product : this.websiteList.values()) {
                this.categoryUsed.put(this.categoryIDList.get(product.getWebsiteElement().getCategoryID()), true);
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        this.listener = true;
        this.textListener = true;
        this.selectedListener = true;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.selectedCategoryBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.updatedCategoryBox = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.updatedCategoryField = new JTextField();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.mergeButton = new JButton();
        this.editButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(CategoryManager.class, (String)"CategoryManager.jPanel1.border.title")));
        this.selectedCategoryBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CategoryManager.this.selectedCategoryBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(CategoryManager.class, (String)"CategoryManager.jLabel1.text"));
        this.updatedCategoryBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CategoryManager.this.updatedCategoryBoxActionPerformed(evt);
            }
        });
        this.updatedCategoryField.setText(NbBundle.getMessage(CategoryManager.class, (String)"CategoryManager.updatedCategoryField.text"));
        this.updatedCategoryField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                CategoryManager.this.updatedCategoryFieldKeyTyped(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(CategoryManager.class, (String)"CategoryManager.addButton.text"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CategoryManager.this.addButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(CategoryManager.class, (String)"CategoryManager.removeButton.text"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CategoryManager.this.removeButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.mergeButton, (String)NbBundle.getMessage(CategoryManager.class, (String)"CategoryManager.mergeButton.text"));
        this.mergeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CategoryManager.this.mergeButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.editButton, (String)NbBundle.getMessage(CategoryManager.class, (String)"CategoryManager.editButton.text"));
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CategoryManager.this.editButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selectedCategoryBox, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.updatedCategoryBox, 0, -1, Short.MAX_VALUE).addComponent(this.jSeparator1).addComponent(this.updatedCategoryField).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 52, Short.MAX_VALUE).addComponent(this.mergeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editButton))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addGap(11, 11, 11).addComponent(this.selectedCategoryBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.updatedCategoryBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.updatedCategoryField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addButton).addComponent(this.removeButton).addComponent(this.mergeButton).addComponent(this.editButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void updatedCategoryBoxActionPerformed(ActionEvent evt) {
        if (this.listener) {
            try {
                this.listener = false;
                this.textListener = false;
                if (this.updatedCategoryBox.getSelectedItem() != null && !this.updatedCategoryBox.getSelectedItem().toString().equalsIgnoreCase("None")) {
                    this.updatedCategoryField.setText(this.updatedCategoryBox.getSelectedItem().toString());
                }
                this.listener = true;
                this.textListener = true;
                this.handleButtons('a', false);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
    }

    private void updatedCategoryFieldKeyTyped(KeyEvent evt) {
        if (this.textListener) {
            try {
                this.textListener = false;
                this.listener = false;
                if (this.updatedCategoryField.getText() != null) {
                    String currentlyHeld = (this.updatedCategoryField.getText() + evt.getKeyChar()).toLowerCase();
                    if (this.categoryList.containsKey(currentlyHeld)) {
                        this.updatedCategoryBox.setSelectedItem(this.categoryList.get(currentlyHeld));
                    } else {
                        this.updatedCategoryBox.setSelectedItem("None");
                    }
                }
                this.listener = true;
                this.textListener = true;
                this.handleButtons(evt.getKeyChar(), true);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
    }

    private void getSelectedAndUpdated(char newChar, boolean useChar) {
        this.selectedCategory = "None";
        this.updatedCategory = "None";
        try {
            String actualUpdatedCategoryField = "None";
            if (this.updatedCategoryField.getText() != null) {
                actualUpdatedCategoryField = this.updatedCategoryField.getText().trim();
                if (useChar) {
                    actualUpdatedCategoryField = newChar == '\b' && actualUpdatedCategoryField.trim().isEmpty() ? "" : actualUpdatedCategoryField + newChar;
                }
            }
            if (this.selectedCategoryBox.getSelectedItem() != null) {
                this.selectedCategory = this.selectedCategoryBox.getSelectedItem().toString();
            }
            if (this.updatedCategoryBox.getSelectedItem() != null && !this.updatedCategoryBox.getSelectedItem().toString().equalsIgnoreCase("None")) {
                this.updatedCategory = this.updatedCategoryBox.getSelectedItem().toString();
            } else if (actualUpdatedCategoryField != null && !actualUpdatedCategoryField.isEmpty() && !actualUpdatedCategoryField.equalsIgnoreCase("None")) {
                this.updatedCategory = actualUpdatedCategoryField;
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private void handleButtons(char newChar, boolean useChar) {
        try {
            this.getSelectedAndUpdated(newChar, useChar);
            boolean addEnabled = !this.categoryList.containsKey(this.updatedCategory.toLowerCase());
            boolean removeEnabled = !this.selectedCategory.equalsIgnoreCase("None") && !this.categoryUsed.containsKey(this.selectedCategory);
            boolean mergeEnabled = !this.selectedCategory.equalsIgnoreCase("None") && !this.updatedCategory.equalsIgnoreCase("None") && !this.selectedCategory.equalsIgnoreCase(this.updatedCategory);
            boolean editEnabled = !this.selectedCategory.equalsIgnoreCase("None") && !this.updatedCategory.equalsIgnoreCase("None") && (!this.categoryList.containsKey(this.updatedCategory.toLowerCase()) || this.updatedCategory.toLowerCase().equalsIgnoreCase(this.selectedCategory));
            this.addButton.setEnabled(addEnabled);
            this.removeButton.setEnabled(removeEnabled);
            this.mergeButton.setEnabled(mergeEnabled);
            this.editButton.setEnabled(editEnabled);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private void selectedCategoryBoxActionPerformed(ActionEvent evt) {
        if (this.selectedListener) {
            this.handleButtons('a', false);
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        try {
            this.getSelectedAndUpdated('a', false);
            String currentSelectedCategory = this.selectedCategory;
            if (GenericFunctions.getInstance().createAcceptDialog("Remove Category", "Proceeding with this action will delete the category: " + currentSelectedCategory + ". Removal is only available when no website elements are using the specific category.")) {
                int categoryID = -1;
                if (this.reverseCategoryIDList.containsKey(currentSelectedCategory)) {
                    categoryID = this.reverseCategoryIDList.get(currentSelectedCategory);
                }
                if (categoryID != -1) {
                    LookupServicesUtil.getDBServices().removeCategory(categoryID);
                    ListenerManager.getInstance().notify((GenericListener)ListenerManager.CATEGORY_LIST_LISTENER);
                    ListenerManager.getInstance().notify((GenericListener)ListenerManager.WEBSITE_ITEM_LIST_LISTENER);
                    ListenerManager.getInstance().notify((GenericListener)ListenerManager.WEBSITE_LIST_LISTENER);
                    if (this.reverseCategoryIDList.containsKey(currentSelectedCategory)) {
                        categoryID = this.reverseCategoryIDList.get(currentSelectedCategory);
                    }
                    if (categoryID == -1) {
                        JOptionPane.showMessageDialog(null, currentSelectedCategory + " successfully deleted!");
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "Could not collect Category ID. Please restart and try again.");
                }
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private boolean uniqueCategory(String category) {
        return this.categoryList == null || !this.categoryList.containsKey(category.toLowerCase());
    }

    public String addCategory(String category) {
        String returnCategory = "";
        if (this.uniqueCategory(category)) {
            Category categoryContainer = new Category();
            categoryContainer.setCategoryName(category);
            LookupServicesUtil.getDBServices().updateCategory(categoryContainer);
            ListenerManager.getInstance().notify((GenericListener)ListenerManager.CATEGORY_LIST_LISTENER);
            ListenerManager.getInstance().notify((GenericListener)ListenerManager.WEBSITE_LIST_LISTENER);
        }
        if (!this.uniqueCategory(category)) {
            return this.categoryList.get(category.toLowerCase());
        }
        return "";
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        try {
            this.getSelectedAndUpdated('a', false);
            String currentUpdatedCategory = this.updatedCategory;
            Category category = new Category();
            category.setCategoryName(currentUpdatedCategory);
            if (this.uniqueCategory(this.updatedCategory)) {
                LookupServicesUtil.getDBServices().updateCategory(category);
                ListenerManager.getInstance().notify((GenericListener)ListenerManager.CATEGORY_LIST_LISTENER);
                ListenerManager.getInstance().notify((GenericListener)ListenerManager.WEBSITE_LIST_LISTENER);
                if (evt != null) {
                    if (this.reverseCategoryIDList.containsKey(currentUpdatedCategory)) {
                        JOptionPane.showMessageDialog(null, currentUpdatedCategory + " Successfully added!");
                    } else {
                        JOptionPane.showMessageDialog(null, currentUpdatedCategory + " failed to add.");
                    }
                }
            } else {
                JOptionPane.showMessageDialog(null, currentUpdatedCategory + " failed to add. Not unique.");
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        try {
            this.getSelectedAndUpdated('a', false);
            String currentSelectedCategory = this.selectedCategory;
            String currentUpdatedCategory = this.updatedCategoryField.getText().trim();
            Category category = new Category();
            category.setCategoryID(this.reverseCategoryIDList.get(currentSelectedCategory).intValue());
            category.setCategoryName(currentUpdatedCategory);
            LookupServicesUtil.getDBServices().updateCategory(category);
            ListenerManager.getInstance().notify((GenericListener)ListenerManager.CATEGORY_LIST_LISTENER);
            ListenerManager.getInstance().notify((GenericListener)ListenerManager.WEBSITE_ITEM_LIST_LISTENER);
            ListenerManager.getInstance().notify((GenericListener)ListenerManager.WEBSITE_LIST_LISTENER);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private void mergeButtonActionPerformed(ActionEvent evt) {
        try {
            if (evt != null) {
                this.getSelectedAndUpdated('a', false);
            }
            String currentSelectedCategory = this.selectedCategory;
            String currentUpdatedCategory = this.updatedCategory;
            if (GenericFunctions.getInstance().createAcceptDialog("Merge Category", "Proceeding with this action will forever replace the category: " + currentSelectedCategory + " - with the category: " + currentUpdatedCategory + ".\nThis process is irreversible, press no to cancel.")) {
                int selectedCategoryID = -1;
                if (this.reverseCategoryIDList.containsKey(currentSelectedCategory)) {
                    selectedCategoryID = this.reverseCategoryIDList.get(currentSelectedCategory);
                }
                int updatedCategoryID = -1;
                if (this.reverseCategoryIDList.containsKey(currentUpdatedCategory)) {
                    updatedCategoryID = this.reverseCategoryIDList.get(currentUpdatedCategory);
                }
                if (selectedCategoryID != -1) {
                    if (updatedCategoryID == -1) {
                        this.addButtonActionPerformed(null);
                        if (this.reverseCategoryIDList.containsKey(currentUpdatedCategory)) {
                            updatedCategoryID = this.reverseCategoryIDList.get(currentUpdatedCategory);
                        }
                    }
                    if (updatedCategoryID != -1) {
                        LookupServicesUtil.getDBServices().mergeCategory(selectedCategoryID, updatedCategoryID);
                        ListenerManager.getInstance().notify((GenericListener)ListenerManager.CATEGORY_LIST_LISTENER);
                        ListenerManager.getInstance().notify((GenericListener)ListenerManager.WEBSITE_ITEM_LIST_LISTENER);
                        ListenerManager.getInstance().notify((GenericListener)ListenerManager.WEBSITE_LIST_LISTENER);
                    } else {
                        JOptionPane.showMessageDialog(null, "Could not create new category: " + currentUpdatedCategory);
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "Could not collect Category ID. Please restart and try again.");
                }
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    public void categoryListUpdated() {
        this.refreshCategories();
    }
}

