/*
 * Decompiled with CFR 0.152.
 */
package pnp.managers.website;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.sql.Date;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import pnp.managers.website.AssociationManager;
import pnp.managers.website.CategoryManager;
import pnp.services.authenticationmanager.SubscriptionManager;
import pnp.services.datatypes.Category;
import pnp.services.datatypes.CategoryAssociation;
import pnp.services.datatypes.ChangedCell;
import pnp.services.datatypes.InventoryElement;
import pnp.services.datatypes.Item;
import pnp.services.datatypes.webservices.Website;
import pnp.services.datatypes.webservices.WebsiteCategories;
import pnp.services.datatypes.webservices.WebsiteElement;
import pnp.services.datatypes.webservices.WebsiteProduct;
import pnp.services.listener.CategoryListListener;
import pnp.services.listener.GenericListener;
import pnp.services.listener.InventoryListener;
import pnp.services.listener.LoginListener;
import pnp.services.listener.WebsiteItemListListener;
import pnp.services.listener.WebsiteListListener;
import pnp.services.listenermanager.ListenerManager;
import pnp.services.preferencemanager.Preferences;
import pnp.services.table.FormattedXTable;
import pnp.services.util.CreationTools;
import pnp.services.util.ErrorsUtil;
import pnp.services.util.GenericFunctions;
import pnp.services.util.LookupServicesUtil;
import pnp.services.util.MathParser;

@TopComponent.Description(preferredID="WebsiteManagerTopComponent", persistenceType=1)
public final class WebsiteManagerTopComponent
extends TopComponent
implements WebsiteItemListListener,
WebsiteListListener,
CategoryListListener,
TableModelListener,
ListSelectionListener,
InventoryListener,
LoginListener {
    private static WebsiteManagerTopComponent instance;
    private int currentProgress = 0;
    private int totalProgress = 0;
    private CategoryManager categoryManager = new CategoryManager(null, true);
    private AssociationManager associationManager = new AssociationManager(null, true);
    private HashSet<String> actualUpdatesNeeded;
    private JList activeCategoriesList;
    private JPanel activeCategoriesPanel;
    private JButton addAvailableCategory;
    private JButton addCategoryButton;
    private JButton applyButton;
    private JButton associationManagerButton;
    private JList availableCategoriesList;
    private JList availableCategoryList;
    private JScrollPane briefDescriptionPane;
    private JTextArea briefDescriptionTextArea;
    private JButton browseButton;
    private JButton categoryManagerButton;
    private JButton clearButton;
    private JButton createTemplateButton;
    private JList currentCategoryList;
    private JScrollPane descriptionPane;
    private JTextArea descriptionTextArea;
    private JButton disableSelectedButton;
    private JCheckBox disabledItemsFilter;
    private JButton enableSelectedButton;
    private JCheckBox enabledItemsCheckBox;
    private JCheckBox featuredItemsFilter;
    private JButton feedButton;
    private JTextField feedURL;
    private FormattedXTable formattedWebsiteTable;
    private JButton importButton;
    private JTextField importLocationTextField;
    private JComboBox importTypeComboBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel13;
    private JPanel jPanel14;
    private JPanel jPanel15;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JScrollPane keywordsPane;
    private JTextArea keywordsTextArea;
    private JPanel manageCategoriesPanel;
    private JPanel manageItemDataPanel;
    private JPanel manageWebsitesPanel;
    private JCheckBox missingCategoryFilter;
    private JCheckBox oosCheckBox;
    private JButton publishButton;
    private JProgressBar pushProgressBar;
    private JButton removeAvailableCategory;
    private JButton removeCategoryButton;
    private JButton searchButton;
    private JTextField searchTextField;
    private JComboBox websiteComboBox;
    private JButton websitePropertiesButton;
    private HashMap<String, ChangedCell> _validCellChanges;
    private HashMap<String, ChangedCell> _invalidCellChanges;
    private LinkedHashMap<Integer, Website> _websites;
    private LinkedHashMap<String, Website> _websiteStringList;
    private LinkedHashMap<Integer, Category> _categories;
    private LinkedHashMap<String, Category> _categoryStringList;
    private JFileChooser importLocation;
    private boolean disableListener;
    private boolean currentStatus = true;

    public WebsiteManagerTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"CTL_WebsiteManagerTopComponent"));
        this.setToolTipText(NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"HINT_WebsiteManagerTopComponent"));
        this.LoginToggle();
        this.init();
    }

    protected void componentShowing() {
        super.componentShowing();
        this.LoginToggle();
        if (SubscriptionManager.getInstance().isWebsiteActive()) {
            ListenerManager.getInstance().subscribe((GenericListener)this);
            this.inventoryListUpdated();
            this.websiteItemListUpdated();
            this.websiteListUpdated();
            this.categoryListUpdated();
        }
    }

    protected void componentHidden() {
        super.componentHidden();
        if (SubscriptionManager.getInstance().isWebsiteActive()) {
            ListenerManager.getInstance().unsubscribe((GenericListener)this);
        }
    }

    private void createTable() {
        this.formattedWebsiteTable.init(new String[]{"Item ID", "Item Name", "Quantity", "Our Price", "OEM", "Price Wholesale", "Price Retail", "Thumbnail", "Photo1", "Photo2", "Photo3", "Category", "Featured", "Gender", "Age Group", "Google Category", "Bing Category", "Enabled"}, "WebsiteManager", new String[]{"Gender", "Age Group", "Google Category", "Bing Category"});
        this.recreateCategoryList();
        this.formattedWebsiteTable.createCheckBox("Featured");
        this.formattedWebsiteTable.createCheckBox("Enabled");
        this.formattedWebsiteTable.getFormattedTable().setSortOrder((Object)"Item ID", SortOrder.DESCENDING);
        this.formattedWebsiteTable.getFormattedTable().getSelectionModel().addListSelectionListener(this);
        this.formattedWebsiteTable.getTableModel().addTableModelListener(this);
        this.formattedWebsiteTable.loadSavedSettings();
    }

    private void recreateCategoryList() {
        if (this._categoryStringList != null) {
            this.formattedWebsiteTable.overwriteCellDefault("Category", this._categoryStringList.keySet().toArray(new String[0]));
        }
    }

    public void init() {
        ListenerManager.getInstance().subscribe((GenericListener)this);
        this.actualUpdatesNeeded = new HashSet();
        this.importLocation = new JFileChooser();
        this.importLocation.setFileFilter(new TextFileFilter());
        this.disableListener(false);
        this._validCellChanges = new HashMap();
        this._invalidCellChanges = new HashMap();
        this._websites = new LinkedHashMap();
        this._categories = new LinkedHashMap();
        this._websiteStringList = new LinkedHashMap();
        this._categoryStringList = new LinkedHashMap();
        Object[] websites = LookupServicesUtil.getDBServices().getWebsites();
        Arrays.sort(websites);
        for (int i = 0; i < websites.length; ++i) {
            String webName = websites[i].getWebsiteName();
            if (webName == null || webName.isEmpty()) continue;
            this._websites.put(websites[i].getWebsiteID(), (Website)websites[i]);
            this._websiteStringList.put(webName, (Website)websites[i]);
            this.websiteComboBox.addItem(webName);
        }
        this.updateCategories();
        this.createTable();
        ListenerManager.getInstance().notify((GenericListener)ListenerManager.WEBSITE_ITEM_LIST_LISTENER);
        this.pushProgressBar.setVisible(false);
        this.pushProgressBar.setMinimum(0);
        this.pushProgressBar.setMaximum(100);
        ((DefaultListModel)this.availableCategoryList.getModel()).addElement("All");
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPanel14 = new JPanel();
        this.jPanel12 = new JPanel();
        this.jPanel9 = new JPanel();
        this.briefDescriptionPane = new JScrollPane();
        this.briefDescriptionTextArea = new JTextArea();
        this.jPanel10 = new JPanel();
        this.keywordsPane = new JScrollPane();
        this.keywordsTextArea = new JTextArea();
        this.jPanel11 = new JPanel();
        this.descriptionPane = new JScrollPane();
        this.descriptionTextArea = new JTextArea();
        this.jPanel13 = new JPanel();
        this.clearButton = new JButton();
        this.applyButton = new JButton();
        this.jPanel8 = new JPanel();
        this.formattedWebsiteTable = new FormattedXTable();
        this.jPanel4 = new JPanel();
        this.manageWebsitesPanel = new JPanel();
        this.websitePropertiesButton = new JButton();
        this.manageCategoriesPanel = new JPanel();
        this.categoryManagerButton = new JButton();
        this.manageItemDataPanel = new JPanel();
        this.jLabel4 = new JLabel();
        this.importTypeComboBox = new JComboBox();
        this.createTemplateButton = new JButton();
        this.jLabel5 = new JLabel();
        this.importLocationTextField = new JTextField();
        this.browseButton = new JButton();
        this.importButton = new JButton();
        this.activeCategoriesPanel = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.activeCategoriesList = new JList();
        this.addCategoryButton = new JButton();
        this.removeCategoryButton = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.availableCategoriesList = new JList();
        this.jLabel9 = new JLabel();
        this.websiteComboBox = new JComboBox();
        this.jPanel6 = new JPanel();
        this.disableSelectedButton = new JButton();
        this.enableSelectedButton = new JButton();
        this.jPanel5 = new JPanel();
        this.publishButton = new JButton();
        this.jPanel1 = new JPanel();
        this.pushProgressBar = new JProgressBar();
        this.jPanel2 = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.currentCategoryList = new JList();
        this.jScrollPane5 = new JScrollPane();
        this.availableCategoryList = new JList();
        this.addAvailableCategory = new JButton();
        this.removeAvailableCategory = new JButton();
        this.searchTextField = new JTextField();
        this.searchButton = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jPanel15 = new JPanel();
        this.enabledItemsCheckBox = new JCheckBox();
        this.oosCheckBox = new JCheckBox();
        this.disabledItemsFilter = new JCheckBox();
        this.featuredItemsFilter = new JCheckBox();
        this.missingCategoryFilter = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.feedButton = new JButton();
        this.feedURL = new JTextField();
        this.jLabel3 = new JLabel();
        this.associationManagerButton = new JButton();
        this.jPanel14.setBorder(BorderFactory.createTitledBorder(""));
        this.jPanel12.setBorder(BorderFactory.createTitledBorder(""));
        this.jPanel9.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.jPanel9.border.title")));
        this.briefDescriptionTextArea.setColumns(20);
        this.briefDescriptionTextArea.setLineWrap(true);
        this.briefDescriptionTextArea.setRows(5);
        this.briefDescriptionTextArea.setWrapStyleWord(true);
        this.briefDescriptionTextArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                WebsiteManagerTopComponent.this.briefDescriptionTextAreaFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                WebsiteManagerTopComponent.this.briefDescriptionTextAreaFocusLost(evt);
            }
        });
        this.briefDescriptionTextArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                WebsiteManagerTopComponent.this.briefDescriptionTextAreaKeyPressed(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                WebsiteManagerTopComponent.this.briefDescriptionTextAreaKeyTyped(evt);
            }
        });
        this.briefDescriptionPane.setViewportView(this.briefDescriptionTextArea);
        GroupLayout jPanel9Layout = new GroupLayout(this.jPanel9);
        this.jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addContainerGap().addComponent(this.briefDescriptionPane, -2, 478, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel9Layout.setVerticalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addContainerGap().addComponent(this.briefDescriptionPane).addContainerGap()));
        this.jPanel10.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.jPanel10.border.title")));
        this.keywordsTextArea.setColumns(20);
        this.keywordsTextArea.setLineWrap(true);
        this.keywordsTextArea.setRows(5);
        this.keywordsTextArea.setWrapStyleWord(true);
        this.keywordsTextArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                WebsiteManagerTopComponent.this.keywordsTextAreaFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                WebsiteManagerTopComponent.this.keywordsTextAreaFocusLost(evt);
            }
        });
        this.keywordsTextArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                WebsiteManagerTopComponent.this.keywordsTextAreaKeyPressed(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                WebsiteManagerTopComponent.this.keywordsTextAreaKeyTyped(evt);
            }
        });
        this.keywordsPane.setViewportView(this.keywordsTextArea);
        GroupLayout jPanel10Layout = new GroupLayout(this.jPanel10);
        this.jPanel10.setLayout(jPanel10Layout);
        jPanel10Layout.setHorizontalGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel10Layout.createSequentialGroup().addContainerGap().addComponent(this.keywordsPane, -1, 478, Short.MAX_VALUE).addContainerGap()));
        jPanel10Layout.setVerticalGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel10Layout.createSequentialGroup().addContainerGap().addComponent(this.keywordsPane).addContainerGap()));
        this.jPanel11.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.jPanel11.border.title")));
        this.descriptionTextArea.setColumns(20);
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setRows(5);
        this.descriptionTextArea.setWrapStyleWord(true);
        this.descriptionTextArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                WebsiteManagerTopComponent.this.descriptionTextAreaFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                WebsiteManagerTopComponent.this.descriptionTextAreaFocusLost(evt);
            }
        });
        this.descriptionTextArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                WebsiteManagerTopComponent.this.descriptionTextAreaKeyPressed(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                WebsiteManagerTopComponent.this.descriptionTextAreaKeyTyped(evt);
            }
        });
        this.descriptionPane.setViewportView(this.descriptionTextArea);
        GroupLayout jPanel11Layout = new GroupLayout(this.jPanel11);
        this.jPanel11.setLayout(jPanel11Layout);
        jPanel11Layout.setHorizontalGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel11Layout.createSequentialGroup().addContainerGap().addComponent(this.descriptionPane, -1, 436, Short.MAX_VALUE).addContainerGap()));
        jPanel11Layout.setVerticalGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel11Layout.createSequentialGroup().addContainerGap().addComponent(this.descriptionPane).addContainerGap()));
        this.jPanel13.setBorder(BorderFactory.createTitledBorder(""));
        Mnemonics.setLocalizedText((AbstractButton)this.clearButton, (String)NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.clearButton.text"));
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebsiteManagerTopComponent.this.clearButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.applyButton, (String)NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.applyButton.text"));
        this.applyButton.setEnabled(false);
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebsiteManagerTopComponent.this.applyButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel13Layout = new GroupLayout(this.jPanel13);
        this.jPanel13.setLayout(jPanel13Layout);
        jPanel13Layout.setHorizontalGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel13Layout.createSequentialGroup().addContainerGap().addComponent(this.clearButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.applyButton).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel13Layout.setVerticalGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel13Layout.createSequentialGroup().addContainerGap().addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.clearButton).addComponent(this.applyButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel12Layout = new GroupLayout(this.jPanel12);
        this.jPanel12.setLayout(jPanel12Layout);
        jPanel12Layout.setHorizontalGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel12Layout.createSequentialGroup().addContainerGap().addGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanel9, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel10, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel11, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jPanel13, -2, -1, -2).addContainerGap()));
        jPanel12Layout.setVerticalGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel12Layout.createSequentialGroup().addContainerGap().addGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel11, -1, -1, Short.MAX_VALUE).addGroup(jPanel12Layout.createSequentialGroup().addGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel13, -2, -1, -2).addGroup(jPanel12Layout.createSequentialGroup().addComponent(this.jPanel9, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel10, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        this.jPanel8.setBorder(BorderFactory.createTitledBorder(""));
        GroupLayout jPanel8Layout = new GroupLayout(this.jPanel8);
        this.jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addComponent((Component)this.formattedWebsiteTable, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addComponent((Component)this.formattedWebsiteTable, -1, 245, Short.MAX_VALUE).addContainerGap()));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(""));
        this.manageWebsitesPanel.setBorder(BorderFactory.createTitledBorder(null, NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.manageWebsitesPanel.border.title"), 0, 0, null, new Color(0, 0, 0)));
        Mnemonics.setLocalizedText((AbstractButton)this.websitePropertiesButton, (String)NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.websitePropertiesButton.text"));
        this.websitePropertiesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebsiteManagerTopComponent.this.websitePropertiesButtonActionPerformed(evt);
            }
        });
        GroupLayout manageWebsitesPanelLayout = new GroupLayout(this.manageWebsitesPanel);
        this.manageWebsitesPanel.setLayout(manageWebsitesPanelLayout);
        manageWebsitesPanelLayout.setHorizontalGroup(manageWebsitesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(manageWebsitesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.websitePropertiesButton, -2, 139, -2).addContainerGap(-1, Short.MAX_VALUE)));
        manageWebsitesPanelLayout.setVerticalGroup(manageWebsitesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.websitePropertiesButton, GroupLayout.Alignment.TRAILING));
        this.manageCategoriesPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.manageCategoriesPanel.border.title")));
        Mnemonics.setLocalizedText((AbstractButton)this.categoryManagerButton, (String)NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.categoryManagerButton.text"));
        this.categoryManagerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebsiteManagerTopComponent.this.categoryManagerButtonActionPerformed(evt);
            }
        });
        GroupLayout manageCategoriesPanelLayout = new GroupLayout(this.manageCategoriesPanel);
        this.manageCategoriesPanel.setLayout(manageCategoriesPanelLayout);
        manageCategoriesPanelLayout.setHorizontalGroup(manageCategoriesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, manageCategoriesPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.categoryManagerButton).addContainerGap()));
        manageCategoriesPanelLayout.setVerticalGroup(manageCategoriesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(manageCategoriesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.categoryManagerButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.manageItemDataPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.manageItemDataPanel.border.title")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.jLabel4.text"));
        this.importTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Tab Delimited"}));
        this.importTypeComboBox.setEnabled(false);
        this.importTypeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                WebsiteManagerTopComponent.this.importTypeComboBoxItemStateChanged(evt);
            }
        });
        this.importTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebsiteManagerTopComponent.this.importTypeComboBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.createTemplateButton, (String)NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.createTemplateButton.text"));
        this.createTemplateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebsiteManagerTopComponent.this.createTemplateButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.jLabel5.text"));
        this.importLocationTextField.setEditable(false);
        this.importLocationTextField.setText(NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.importLocationTextField.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.browseButton.text"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebsiteManagerTopComponent.this.browseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.importButton, (String)NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.importButton.text"));
        this.importButton.setEnabled(false);
        this.importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebsiteManagerTopComponent.this.importButtonActionPerformed(evt);
            }
        });
        GroupLayout manageItemDataPanelLayout = new GroupLayout(this.manageItemDataPanel);
        this.manageItemDataPanel.setLayout(manageItemDataPanelLayout);
        manageItemDataPanelLayout.setHorizontalGroup(manageItemDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(manageItemDataPanelLayout.createSequentialGroup().addContainerGap().addGroup(manageItemDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(manageItemDataPanelLayout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.importTypeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.createTemplateButton)).addGroup(manageItemDataPanelLayout.createSequentialGroup().addGroup(manageItemDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addGroup(manageItemDataPanelLayout.createSequentialGroup().addComponent(this.importLocationTextField, -2, 181, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.importButton))).addGap(0, 9, Short.MAX_VALUE))).addContainerGap()));
        manageItemDataPanelLayout.setVerticalGroup(manageItemDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(manageItemDataPanelLayout.createSequentialGroup().addContainerGap().addGroup(manageItemDataPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.importTypeComboBox, -2, -1, -2).addComponent(this.createTemplateButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(manageItemDataPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.importLocationTextField, -2, -1, -2).addComponent(this.browseButton).addComponent(this.importButton)).addContainerGap(15, Short.MAX_VALUE)));
        this.activeCategoriesPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.activeCategoriesPanel.border.title")));
        this.activeCategoriesList.setModel(new DefaultListModel());
        this.activeCategoriesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                WebsiteManagerTopComponent.this.activeCategoriesListValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.activeCategoriesList);
        Mnemonics.setLocalizedText((AbstractButton)this.addCategoryButton, (String)NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.addCategoryButton.text"));
        this.addCategoryButton.setEnabled(false);
        this.addCategoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebsiteManagerTopComponent.this.addCategoryButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeCategoryButton, (String)NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.removeCategoryButton.text"));
        this.removeCategoryButton.setEnabled(false);
        this.removeCategoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebsiteManagerTopComponent.this.removeCategoryButtonActionPerformed(evt);
            }
        });
        this.availableCategoriesList.setModel(new DefaultListModel());
        this.availableCategoriesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                WebsiteManagerTopComponent.this.availableCategoriesListValueChanged(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.availableCategoriesList);
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.jLabel9.text"));
        this.websiteComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebsiteManagerTopComponent.this.websiteComboBoxActionPerformed(evt);
            }
        });
        GroupLayout activeCategoriesPanelLayout = new GroupLayout(this.activeCategoriesPanel);
        this.activeCategoriesPanel.setLayout(activeCategoriesPanelLayout);
        activeCategoriesPanelLayout.setHorizontalGroup(activeCategoriesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, activeCategoriesPanelLayout.createSequentialGroup().addContainerGap().addGroup(activeCategoriesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, activeCategoriesPanelLayout.createSequentialGroup().addComponent(this.jScrollPane3, -1, 226, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(activeCategoriesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(activeCategoriesPanelLayout.createSequentialGroup().addComponent(this.addCategoryButton, -1, -1, Short.MAX_VALUE).addGap(2, 2, 2)).addComponent(this.removeCategoryButton, -1, -1, Short.MAX_VALUE))).addComponent(this.jLabel9)).addGroup(activeCategoriesPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(activeCategoriesPanelLayout.createSequentialGroup().addGap(31, 31, 31).addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE)).addComponent(this.websiteComboBox, -2, 140, -2)).addContainerGap()));
        activeCategoriesPanelLayout.setVerticalGroup(activeCategoriesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(activeCategoriesPanelLayout.createSequentialGroup().addGroup(activeCategoriesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.websiteComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(activeCategoriesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3).addGroup(activeCategoriesPanelLayout.createSequentialGroup().addComponent(this.addCategoryButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.removeCategoryButton).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane2)).addContainerGap()));
        Mnemonics.setLocalizedText((AbstractButton)this.disableSelectedButton, (String)NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.disableSelectedButton.text"));
        this.disableSelectedButton.setEnabled(false);
        this.disableSelectedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebsiteManagerTopComponent.this.disableSelectedButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.enableSelectedButton, (String)NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.enableSelectedButton.text"));
        this.enableSelectedButton.setEnabled(false);
        this.enableSelectedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebsiteManagerTopComponent.this.enableSelectedButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.disableSelectedButton, -2, 114, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.enableSelectedButton, -2, 114, -2).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.enableSelectedButton).addComponent(this.disableSelectedButton)).addContainerGap()));
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(""));
        Mnemonics.setLocalizedText((AbstractButton)this.publishButton, (String)NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.publishButton.text"));
        this.publishButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebsiteManagerTopComponent.this.publishButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.pushProgressBar, -2, 126, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.pushProgressBar, -2, -1, -2).addContainerGap()));
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.publishButton, -2, 146, -2).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jPanel1, -2, -1, -2).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.publishButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -2, -1, -2).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(""));
        this.currentCategoryList.setModel(new DefaultListModel());
        this.currentCategoryList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                WebsiteManagerTopComponent.this.currentCategoryListValueChanged(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.currentCategoryList);
        this.availableCategoryList.setModel(new DefaultListModel());
        this.availableCategoryList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                WebsiteManagerTopComponent.this.availableCategoryListValueChanged(evt);
            }
        });
        this.jScrollPane5.setViewportView(this.availableCategoryList);
        Mnemonics.setLocalizedText((AbstractButton)this.addAvailableCategory, (String)NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.addAvailableCategory.text"));
        this.addAvailableCategory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebsiteManagerTopComponent.this.addAvailableCategoryActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeAvailableCategory, (String)NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.removeAvailableCategory.text"));
        this.removeAvailableCategory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebsiteManagerTopComponent.this.removeAvailableCategoryActionPerformed(evt);
            }
        });
        this.searchTextField.setText(NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.searchTextField.text"));
        this.searchTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                WebsiteManagerTopComponent.this.searchTextFieldKeyReleased(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.searchButton, (String)NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.searchButton.text"));
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebsiteManagerTopComponent.this.searchButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.jLabel1.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.jLabel2.text"));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.searchTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchButton)).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jScrollPane5, -2, 130, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.removeAvailableCategory, -1, -1, Short.MAX_VALUE).addComponent(this.addAvailableCategory, -1, -1, Short.MAX_VALUE))).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jScrollPane4, -2, 130, -2)))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel2Layout.createSequentialGroup().addGap(28, 28, 28).addComponent(this.addAvailableCategory).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeAvailableCategory)).addComponent(this.jScrollPane4, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE).addComponent(this.jScrollPane5, GroupLayout.Alignment.TRAILING, -2, 117, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.searchTextField, -2, -1, -2).addComponent(this.searchButton)).addContainerGap()));
        this.jPanel15.setBorder(BorderFactory.createTitledBorder(""));
        Mnemonics.setLocalizedText((AbstractButton)this.enabledItemsCheckBox, (String)NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.enabledItemsCheckBox.text"));
        this.enabledItemsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebsiteManagerTopComponent.this.enabledItemsCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.oosCheckBox, (String)NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.oosCheckBox.text"));
        this.oosCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebsiteManagerTopComponent.this.oosCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.disabledItemsFilter, (String)NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.disabledItemsFilter.text"));
        this.disabledItemsFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebsiteManagerTopComponent.this.disabledItemsFilterActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.featuredItemsFilter, (String)NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.featuredItemsFilter.text"));
        this.featuredItemsFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebsiteManagerTopComponent.this.featuredItemsFilterActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.missingCategoryFilter, (String)NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.missingCategoryFilter.text"));
        this.missingCategoryFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebsiteManagerTopComponent.this.missingCategoryFilterActionPerformed(evt);
            }
        });
        GroupLayout jPanel15Layout = new GroupLayout(this.jPanel15);
        this.jPanel15.setLayout(jPanel15Layout);
        jPanel15Layout.setHorizontalGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel15Layout.createSequentialGroup().addContainerGap().addGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.enabledItemsCheckBox).addComponent(this.featuredItemsFilter).addComponent(this.disabledItemsFilter).addComponent(this.oosCheckBox).addComponent(this.missingCategoryFilter)).addContainerGap(85, Short.MAX_VALUE)));
        jPanel15Layout.setVerticalGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel15Layout.createSequentialGroup().addContainerGap().addComponent(this.enabledItemsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.disabledItemsFilter).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.oosCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.featuredItemsFilter).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.missingCategoryFilter)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.jPanel3.border.title")));
        Mnemonics.setLocalizedText((AbstractButton)this.feedButton, (String)NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.feedButton.text"));
        this.feedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebsiteManagerTopComponent.this.feedButtonActionPerformed(evt);
            }
        });
        this.feedURL.setText(NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.feedURL.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.jLabel3.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.associationManagerButton, (String)NbBundle.getMessage(WebsiteManagerTopComponent.class, (String)"WebsiteManagerTopComponent.associationManagerButton.text"));
        this.associationManagerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebsiteManagerTopComponent.this.associationManagerButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.feedURL).addComponent(this.feedButton, -1, -1, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addGap(45, 45, 45).addComponent(this.jLabel3).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.associationManagerButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addComponent(this.associationManagerButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.feedURL, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.feedButton).addContainerGap()));
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.manageWebsitesPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.manageCategoriesPanel, -2, -1, -2)).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.manageItemDataPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel5, -2, -1, -2)).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jPanel15, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGap(130, 264, Short.MAX_VALUE).addComponent(this.jPanel6, -2, -1, -2)).addComponent(this.activeCategoriesPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.manageItemDataPanel, -2, -1, -2).addComponent(this.jPanel5, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel15, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE))).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.activeCategoriesPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel6, -2, -1, -2)).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.manageWebsitesPanel, -2, -1, -2).addComponent(this.manageCategoriesPanel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        GroupLayout jPanel14Layout = new GroupLayout(this.jPanel14);
        this.jPanel14.setLayout(jPanel14Layout);
        jPanel14Layout.setHorizontalGroup(jPanel14Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel14Layout.createSequentialGroup().addContainerGap().addGroup(jPanel14Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel8, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel12, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel14Layout.setVerticalGroup(jPanel14Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel14Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel8, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel12, -2, -1, -2).addContainerGap()));
        this.jScrollPane1.setViewportView(this.jPanel14);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 1497, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 904, Short.MAX_VALUE).addContainerGap()));
    }

    private void enabledItemsCheckBoxActionPerformed(ActionEvent evt) {
        this.refreshNew(false);
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        this.performSearch();
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        this.actualUpdatesNeeded.clear();
        this._validCellChanges.clear();
        this._invalidCellChanges.clear();
        this.updateNeeded(false);
        ListenerManager.getInstance().notify((GenericListener)ListenerManager.WEBSITE_ITEM_LIST_LISTENER);
        this.briefDescriptionTextArea.setText("");
        this.keywordsTextArea.setText("");
        this.descriptionTextArea.setText("");
        this.formattedWebsiteTable.getRenderer().setValidCellChanges(this._validCellChanges);
        this.formattedWebsiteTable.getRenderer().setInvalidCellChanges(this._invalidCellChanges);
    }

    private void applyButtonActionPerformed(ActionEvent evt) {
        this.disableListener(true);
        if (this._invalidCellChanges.isEmpty()) {
            for (String itemID : this.actualUpdatesNeeded) {
                if (LookupServicesUtil.getDBServices().getWebsiteProductList().containsKey(itemID)) {
                    LookupServicesUtil.getDBServices().updateWebsiteElement(((WebsiteProduct)LookupServicesUtil.getDBServices().getWebsiteProductList().get(itemID)).getWebsiteElement());
                    continue;
                }
                JOptionPane.showMessageDialog(null, "Something weird happened...");
            }
            this.updateNeeded(false);
            this.actualUpdatesNeeded.clear();
            this._validCellChanges.clear();
        } else {
            this.formattedWebsiteTable.getRenderer().setValidCellChanges(this._validCellChanges);
            this.formattedWebsiteTable.getRenderer().setInvalidCellChanges(this._invalidCellChanges);
            JOptionPane.showMessageDialog(null, "Please correct all errors before applying changes.");
        }
        this.disableListener(false);
    }

    private void sortCategories() {
        Object[] currentList = ((DefaultListModel)this.activeCategoriesList.getModel()).toArray();
        Object[] availableList = ((DefaultListModel)this.availableCategoriesList.getModel()).toArray();
        ((DefaultListModel)this.availableCategoriesList.getModel()).clear();
        ((DefaultListModel)this.activeCategoriesList.getModel()).clear();
        Arrays.sort(currentList);
        Arrays.sort(availableList);
        for (Object obj : currentList) {
            ((DefaultListModel)this.activeCategoriesList.getModel()).addElement(obj);
        }
        for (Object obj : availableList) {
            ((DefaultListModel)this.availableCategoriesList.getModel()).addElement(obj);
        }
    }

    private void activeCategoriesListValueChanged(ListSelectionEvent evt) {
        if (!this.disableListener) {
            if (this.activeCategoriesList.isSelectionEmpty()) {
                this.removeCategoryButton.setEnabled(false);
            } else {
                this.removeCategoryButton.setEnabled(true);
            }
        }
    }

    private void addCategoryButtonActionPerformed(ActionEvent evt) {
        Object[] objectList = this.availableCategoriesList.getSelectedValues();
        for (int i = 0; i < objectList.length; ++i) {
            Object object = objectList[i];
            ((DefaultListModel)this.activeCategoriesList.getModel()).addElement(object);
            ((DefaultListModel)this.availableCategoriesList.getModel()).removeElement(object);
        }
        this.sortCategories();
        WebsiteCategories websiteCategories = new WebsiteCategories();
        for (int i = 0; i < ((DefaultListModel)this.activeCategoriesList.getModel()).size(); ++i) {
            websiteCategories.addCategory(Integer.valueOf(this._categoryStringList.get((String)((DefaultListModel)this.activeCategoriesList.getModel()).get(i)).getCategoryID()));
        }
        if (this._websiteStringList != null && this._websiteStringList.containsKey(this.websiteComboBox.getSelectedItem().toString())) {
            websiteCategories.setWebsiteID(this._websiteStringList.get(this.websiteComboBox.getSelectedItem().toString()).getWebsiteID());
            LookupServicesUtil.getDBServices().updateWebsiteCategories(websiteCategories);
        } else {
            JOptionPane.showMessageDialog(null, "Website list improperly updated. You may want to restart Gamut to continue.");
        }
    }

    private void removeCategoryButtonActionPerformed(ActionEvent evt) {
        Object[] objectList = this.activeCategoriesList.getSelectedValues();
        for (int i = 0; i < objectList.length; ++i) {
            Object object = objectList[i];
            ((DefaultListModel)this.availableCategoriesList.getModel()).addElement(object);
            ((DefaultListModel)this.activeCategoriesList.getModel()).removeElement(object);
        }
        this.sortCategories();
        WebsiteCategories websiteCategories = new WebsiteCategories();
        for (int i = 0; i < ((DefaultListModel)this.activeCategoriesList.getModel()).size(); ++i) {
            websiteCategories.addCategory(Integer.valueOf(this._categoryStringList.get((String)((DefaultListModel)this.activeCategoriesList.getModel()).get(i)).getCategoryID()));
        }
        websiteCategories.setWebsiteID(this._websiteStringList.get((String)this.websiteComboBox.getSelectedItem()).getWebsiteID());
        LookupServicesUtil.getDBServices().updateWebsiteCategories(websiteCategories);
    }

    private void availableCategoriesListValueChanged(ListSelectionEvent evt) {
        if (!this.disableListener) {
            if (this.availableCategoriesList.isSelectionEmpty()) {
                this.addCategoryButton.setEnabled(false);
            } else {
                this.addCategoryButton.setEnabled(true);
            }
        }
    }

    private void websiteComboBoxActionPerformed(ActionEvent evt) {
        block8: {
            this.disableListener(true);
            try {
                if (null == this.websiteComboBox.getSelectedItem()) break block8;
                ((DefaultListModel)this.availableCategoriesList.getModel()).clear();
                ((DefaultListModel)this.activeCategoriesList.getModel()).clear();
                WebsiteCategories[] websiteCategories = LookupServicesUtil.getDBServices().getWebsiteCategories();
                Object[] categories = LookupServicesUtil.getDBServices().getCategories();
                Arrays.sort(categories);
                HashMap<Integer, Integer> activeCategories = new HashMap<Integer, Integer>();
                boolean found = false;
                for (int i = 0; i < websiteCategories.length; ++i) {
                    if (!this._websiteStringList.containsKey((String)this.websiteComboBox.getSelectedItem()) || this._websiteStringList.get((String)this.websiteComboBox.getSelectedItem()).getWebsiteID() != websiteCategories[i].getWebsiteID()) continue;
                    found = true;
                    Iterator iter = websiteCategories[i].getCategories().iterator();
                    while (iter.hasNext()) {
                        int categoryID = (Integer)iter.next();
                        activeCategories.put(categoryID, categoryID);
                    }
                    for (int j = 0; j < categories.length; ++j) {
                        if (activeCategories.containsKey(categories[j].getCategoryID())) {
                            ((DefaultListModel)this.activeCategoriesList.getModel()).addElement(categories[j].getCategoryName());
                            this.removeCategoryButton.setEnabled(true);
                            continue;
                        }
                        ((DefaultListModel)this.availableCategoriesList.getModel()).addElement(categories[j].getCategoryName());
                        this.addCategoryButton.setEnabled(true);
                    }
                    break;
                }
                if (!found) {
                    this.addCategoryButton.setEnabled(SubscriptionManager.getInstance().isWebsiteActive());
                    for (int j = 0; j < categories.length; ++j) {
                        ((DefaultListModel)this.availableCategoriesList.getModel()).addElement(categories[j].getCategoryName());
                    }
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        this.disableListener(false);
    }

    private void websitePropertiesButtonActionPerformed(ActionEvent evt) {
        Preferences.getInstance().openTab(Preferences.Index.Website);
    }

    private void briefDescriptionTextAreaFocusGained(FocusEvent evt) {
        this.updateBriefDescription(null);
    }

    private void briefDescriptionTextAreaFocusLost(FocusEvent evt) {
        this.updateBriefDescription(null);
    }

    private void keywordsTextAreaFocusGained(FocusEvent evt) {
        this.updateKeywords(null);
    }

    private void keywordsTextAreaFocusLost(FocusEvent evt) {
        this.updateKeywords(null);
    }

    private void descriptionTextAreaFocusGained(FocusEvent evt) {
        this.updateDescription(null);
    }

    private void descriptionTextAreaFocusLost(FocusEvent evt) {
        this.updateDescription(null);
    }

    private void publishButtonActionPerformed(ActionEvent evt) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    WebsiteManagerTopComponent.this.doProgress();
                    WebsiteManagerTopComponent.this.disableListener(true);
                    WebsiteManagerTopComponent.this.refreshNew(false);
                    LookupServicesUtil.getRESTHandlerServices().updateWebsiteProducts();
                }
                catch (Exception ex) {
                    ErrorsUtil.getInstance().logError(ex);
                }
                finally {
                    WebsiteManagerTopComponent.this.stopProgress();
                    JOptionPane.showMessageDialog(null, "Push Complete");
                }
            }
        }).start();
    }

    private void announceProgress(String opener) {
        this.pushProgressBar.setVisible(true);
        this.pushProgressBar.setValue(0);
        this.pushProgressBar.setString(opener);
        this.pushProgressBar.setStringPainted(true);
    }

    private void denounceProgress() {
        this.pushProgressBar.setValue(100);
        this.pushProgressBar.setString("Update Complete.");
        this.pushProgressBar.setVisible(false);
    }

    private void stopProgress() {
        this.handleProgress(false);
    }

    private void handleProgress(boolean startProgress) {
        if (startProgress) {
            this.announceProgress("Pushing to websites..");
        } else {
            this.denounceProgress();
        }
        this.formattedWebsiteTable.getFormattedTable().clearSelection();
        this.publishButton.setEnabled(!startProgress);
        this.formattedWebsiteTable.setEnabled(!startProgress);
        this.searchButton.setEnabled(!startProgress);
        this.disableSelectedButton.setEnabled(false);
        this.enableSelectedButton.setEnabled(false);
    }

    private void doProgress() {
        this.handleProgress(true);
    }

    private void updateProgress() {
        ++this.currentProgress;
        if (this.totalProgress == 0) {
            this.currentProgress = 1;
            this.totalProgress = 1;
        }
        double progressUpdate = (double)this.currentProgress / (double)this.totalProgress;
        this.pushProgressBar.setValue((int)(progressUpdate * 100.0));
        this.pushProgressBar.setString(this.currentProgress + " / " + this.totalProgress);
        if (this.currentProgress == this.totalProgress) {
            this.denounceProgress();
        }
    }

    private void searchTextFieldKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10 && null != this.searchTextField.getText() && this.searchButton.isEnabled()) {
            this.performSearch();
        }
    }

    private void importTypeComboBoxItemStateChanged(ItemEvent evt) {
    }

    private void importTypeComboBoxActionPerformed(ActionEvent evt) {
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        int returnVal = this.importLocation.showOpenDialog((Component)((Object)this));
        if (returnVal == 0) {
            this.importLocationTextField.setText(this.importLocation.getSelectedFile().getName());
            this.importButton.setEnabled(true);
        }
    }

    private void createTemplateButtonActionPerformed(ActionEvent evt) {
        try {
            String filename = "ImportTemplate_Website_" + System.currentTimeMillis() + ".txt";
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(filename));
            String outputString = "Item ID\tItem Name\tOEM\tPrice Wholesale\tPrice Retail\tThumbnail\tPhoto1\tPhoto2\tPhoto3\tCategory\tBrief Description\tDescription\tKeywords\tGender\tAge Group\tEnabled";
            bufferedWriter.write(outputString);
            bufferedWriter.newLine();
            bufferedWriter.close();
            File cwd = new File(".");
            JOptionPane.showMessageDialog((Component)((Object)this), filename + " was created in " + cwd.getCanonicalPath());
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private void importButtonActionPerformed(ActionEvent evt) {
        String invoiceType = (String)this.importTypeComboBox.getSelectedItem();
        if (invoiceType.equals("Tab Delimited") && this.importLocation.getSelectedFile().getName().toLowerCase().trim().endsWith(".txt")) {
            this.updateImportList();
        } else if (invoiceType.equals("Tab Delimited")) {
            JOptionPane.showMessageDialog((Component)((Object)this), "The chosen file must be a tab delimited .txt file");
        }
        this.importButton.setEnabled(false);
    }

    private void enableSelectedButtonActionPerformed(ActionEvent evt) {
        for (int row : this.formattedWebsiteTable.getFormattedTable().getSelectedRows()) {
            WebsiteProduct currentProduct = this.getCurrentProduct(row);
            if (currentProduct.getWebsiteElement().isEnabled()) continue;
            currentProduct.getWebsiteElement().setEnabled(true);
            this.actualUpdatesNeeded.add(currentProduct.getItem().getItemID());
            this.formattedWebsiteTable.setValue((Object)true, row, "Enabled");
            this.updateNeeded(true);
        }
    }

    private void disableSelectedButtonActionPerformed(ActionEvent evt) {
        for (int row : this.formattedWebsiteTable.getFormattedTable().getSelectedRows()) {
            WebsiteProduct currentProduct = this.getCurrentProduct(row);
            if (!currentProduct.getWebsiteElement().isEnabled()) continue;
            currentProduct.getWebsiteElement().setEnabled(false);
            this.actualUpdatesNeeded.add(currentProduct.getItem().getItemID());
            this.formattedWebsiteTable.setValue((Object)false, row, "Enabled");
            this.updateNeeded(true);
        }
    }

    private void oosCheckBoxActionPerformed(ActionEvent evt) {
        this.refreshNew(false);
    }

    private void keywordsTextAreaKeyTyped(KeyEvent evt) {
        this.updateKeywords(evt);
    }

    private void briefDescriptionTextAreaKeyTyped(KeyEvent evt) {
        this.updateBriefDescription(evt);
    }

    private void descriptionTextAreaKeyTyped(KeyEvent evt) {
        this.updateDescription(evt);
    }

    private void briefDescriptionTextAreaKeyPressed(KeyEvent evt) {
    }

    private void keywordsTextAreaKeyPressed(KeyEvent evt) {
    }

    private void descriptionTextAreaKeyPressed(KeyEvent evt) {
    }

    private void disabledItemsFilterActionPerformed(ActionEvent evt) {
        if (!this.disableListener) {
            this.refreshNew(false);
        }
    }

    private void featuredItemsFilterActionPerformed(ActionEvent evt) {
        if (!this.disableListener) {
            this.refreshNew(false);
        }
    }

    private void missingCategoryFilterActionPerformed(ActionEvent evt) {
        if (!this.disableListener) {
            this.refreshNew(false);
        }
    }

    private void categoryManagerButtonActionPerformed(ActionEvent evt) {
        this.categoryManager.setVisible(true);
    }

    private void addAvailableCategoryActionPerformed(ActionEvent evt) {
        Object[] obj = this.availableCategoryList.getSelectedValues();
        for (int i = 0; i < obj.length; ++i) {
            ((DefaultListModel)this.currentCategoryList.getModel()).addElement(obj[i]);
            ((DefaultListModel)this.availableCategoryList.getModel()).removeElement(obj[i]);
        }
        this.sortCategorySelector();
        if (obj.length > 0) {
            this.refreshNew(false);
        }
    }

    private void sortCategorySelector() {
        Object[] currentList = ((DefaultListModel)this.currentCategoryList.getModel()).toArray();
        Object[] availableList = ((DefaultListModel)this.availableCategoryList.getModel()).toArray();
        ((DefaultListModel)this.availableCategoryList.getModel()).clear();
        ((DefaultListModel)this.currentCategoryList.getModel()).clear();
        Arrays.sort(currentList);
        Arrays.sort(availableList);
        boolean allLocation = false;
        for (Object obj : currentList) {
            if (!obj.toString().equalsIgnoreCase("All")) {
                ((DefaultListModel)this.currentCategoryList.getModel()).addElement(obj);
                continue;
            }
            if (!obj.toString().equalsIgnoreCase("All")) continue;
            allLocation = true;
        }
        for (Object obj : availableList) {
            if (obj.toString().equalsIgnoreCase("All")) continue;
            ((DefaultListModel)this.availableCategoryList.getModel()).addElement(obj);
        }
        if (allLocation) {
            ((DefaultListModel)this.currentCategoryList.getModel()).add(0, "All");
        } else {
            ((DefaultListModel)this.availableCategoryList.getModel()).add(0, "All");
        }
    }

    private void removeAvailableCategoryActionPerformed(ActionEvent evt) {
        Object[] obj = this.currentCategoryList.getSelectedValues();
        for (int i = 0; i < obj.length; ++i) {
            ((DefaultListModel)this.availableCategoryList.getModel()).addElement(obj[i]);
            ((DefaultListModel)this.currentCategoryList.getModel()).removeElement(obj[i]);
        }
        this.sortCategorySelector();
        if (obj.length > 0) {
            this.refreshNew(false);
        }
    }

    private void availableCategoryListValueChanged(ListSelectionEvent evt) {
        if (this.availableCategoryList.isSelectionEmpty()) {
            this.addAvailableCategory.setEnabled(false);
        } else {
            this.addAvailableCategory.setEnabled(true);
        }
    }

    private void currentCategoryListValueChanged(ListSelectionEvent evt) {
        if (this.currentCategoryList.isSelectionEmpty()) {
            this.removeAvailableCategory.setEnabled(false);
        } else {
            this.removeAvailableCategory.setEnabled(true);
        }
    }

    private void feedButtonActionPerformed(ActionEvent evt) {
        this.createFeeds();
    }

    private void associationManagerButtonActionPerformed(ActionEvent evt) {
        this.associationManager.setVisible(true);
    }

    private void createFeeds() {
        String[] feedSplit;
        String feedURLText = this.feedURL.getText();
        if (feedURLText != null && (feedSplit = feedURLText.split("/")).length >= 4) {
            feedURLText = "http://" + feedSplit[2] + "/" + feedSplit[3] + "/";
        }
        String googleFeed = "";
        String bingFeed = "";
        for (WebsiteProduct product : this.refreshNew(true)) {
            if (bingFeed.isEmpty()) {
                bingFeed = bingFeed + "Id,Title,Brand,ProductURL,Price,Description,ImageURL,SKU,Availability,Condition,ProductType,B_Category\r\n";
            }
            if (googleFeed.isEmpty()) {
                googleFeed = googleFeed + "id,item_group_id,title,description,google_product_category,product_type,link,image_link,condition,availability,price,brand,mpn,gender,age_group,size,color,tax,shipping\r\n";
            }
            googleFeed = googleFeed + this.addLineGoogleFeed(product, feedURLText);
            bingFeed = bingFeed + this.addLineBingFeed(product, feedURLText);
        }
        this.createIndividualFeed("Google Feed", googleFeed);
        this.createIndividualFeed("Bing Feed", bingFeed);
        JOptionPane.showMessageDialog(null, "Feed Creation Complete.");
    }

    private void createIndividualFeed(String feedName, String feedContents) {
        try {
            File targetFile = CreationTools.createFileSpace((String)"Feeds", (String)feedName, (String)"csv", (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
            PrintWriter pw = new PrintWriter(new FileOutputStream(targetFile, false));
            pw.append(feedContents);
            pw.flush();
            pw.close();
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private String sanitizeFeed(String item) {
        if (item == null) {
            item = "";
        }
        item = item.trim();
        item = item.replace(",", " ");
        item = item.replace("'", "");
        return item;
    }

    private String sizeHelper(String searchThrough) {
        String size = "";
        if (searchThrough.contains("small") || searchThrough.equalsIgnoreCase("s")) {
            size = "Small";
        } else if (searchThrough.contains("medium") || searchThrough.equalsIgnoreCase("m")) {
            size = "Medium";
        } else if (searchThrough.contains("large") || searchThrough.equalsIgnoreCase("l") || searchThrough.equalsIgnoreCase("lrg")) {
            size = "Large";
        } else if (searchThrough.contains("xlarge") || searchThrough.equalsIgnoreCase("xl")) {
            size = "XLarge";
        } else if (searchThrough.contains("2xl")) {
            size = "2XL";
        } else if (searchThrough.contains("3xl")) {
            size = "3XL";
        } else if (searchThrough.contains("4xl")) {
            size = "4XL";
        } else if (searchThrough.contains("5xl")) {
            size = "5XL";
        } else if (searchThrough.contains("6xl")) {
            size = "6XL";
        } else if (searchThrough.contains("16g") || searchThrough.contains("1.2mm")) {
            size = "16G (1.2mm)";
        } else if (searchThrough.contains("14g") || searchThrough.contains("1.6mm")) {
            size = "14G (1.6mm)";
        } else if (searchThrough.contains("12g") || searchThrough.contains("2mm")) {
            size = "12G (2mm)";
        } else if (searchThrough.contains("10g") || searchThrough.contains("2.5mm")) {
            size = "10G (2.5mm)";
        } else if (searchThrough.contains("8g") || searchThrough.contains("3mm")) {
            size = "8G (3mm)";
        } else if (searchThrough.contains("6g") || searchThrough.contains("4mm")) {
            size = "6G (4mm)";
        } else if (searchThrough.contains("4g") || searchThrough.contains("5mm")) {
            size = "4G (5mm)";
        } else if (searchThrough.contains("2g") || searchThrough.contains("6mm")) {
            size = "2G (6mm)";
        } else if (searchThrough.contains("00g") || searchThrough.contains("10mm")) {
            size = "00G (10mm)";
        } else if (searchThrough.contains("0g") || searchThrough.contains("8mm")) {
            size = "0G (8mm)";
        } else if (searchThrough.contains("1/2\"") || searchThrough.contains("12mm")) {
            size = "1/2\" (12mm)";
        } else if (searchThrough.contains("9/16\"") || searchThrough.contains("14mm")) {
            size = "9/16\" (14mm)";
        } else if (searchThrough.contains("5/8\"") || searchThrough.contains("16mm")) {
            size = "5/8\" (16mm)";
        } else if (searchThrough.contains("11/16\"") || searchThrough.contains("18mm")) {
            size = "11/16\" (18mm)";
        } else if (searchThrough.contains("13/16\"") || searchThrough.contains("20mm")) {
            size = "13/16\" (20mm)";
        } else if (searchThrough.contains("7/8\"") || searchThrough.contains("22mm")) {
            size = "7/8\" (22mm)";
        } else if (searchThrough.contains("1\"") || searchThrough.contains("25mm")) {
            size = "1\" (25mm)";
        }
        return size;
    }

    private String findSize(WebsiteProduct product) {
        String size = "";
        String itemID = GenericFunctions.getInstance().prepareString(product.getWebsiteElement().getItemID()).toLowerCase().replace(" ", "");
        String title = GenericFunctions.getInstance().prepareString(product.getItem().getItemName()).toLowerCase().replace(" ", "");
        String description = GenericFunctions.getInstance().prepareString(product.getWebsiteElement().getDescription()).toLowerCase().replace(" ", "");
        String brief = GenericFunctions.getInstance().prepareString(product.getWebsiteElement().getDescription()).toLowerCase().replace(" ", "");
        size = this.sizeHelper(itemID);
        if (size.isEmpty()) {
            size = this.sizeHelper(title);
        }
        if (size.isEmpty()) {
            size = this.sizeHelper(description);
        }
        if (size.isEmpty()) {
            size = this.sizeHelper(brief);
        }
        return size;
    }

    private String colorHelper(String searchThrough) {
        String color = "";
        if (searchThrough.contains("horn")) {
            color = "Buffalo Horn";
        } else if (searchThrough.contains("sawo")) {
            color = "Sawo Wood";
        } else if (searchThrough.contains("ebony")) {
            color = "Ebony Wood";
        } else if (searchThrough.contains("crocodile")) {
            color = "Crocodile Wood";
        } else if (searchThrough.contains("saba")) {
            color = "Saba Wood";
        } else if (searchThrough.contains("areng")) {
            color = "Black Areng Wood";
        } else if (searchThrough.contains("purple")) {
            color = "Purple";
        } else if (searchThrough.contains("blue")) {
            color = "Blue";
        } else if (searchThrough.contains("red")) {
            color = "Red";
        } else if (searchThrough.contains("green") || searchThrough.contains("grn")) {
            color = "Green";
        } else if (searchThrough.contains("yellow") || searchThrough.contains("ylw")) {
            color = "Yellow";
        } else if (searchThrough.contains("orange")) {
            color = "Orange";
        } else if (searchThrough.contains("black") || searchThrough.contains("blk")) {
            color = "Black";
        } else if (searchThrough.contains("white") || searchThrough.contains("wht")) {
            color = "White";
        } else if (searchThrough.contains("pink") || searchThrough.contains("pnk")) {
            color = "Pink";
        } else if (searchThrough.contains("gold") || searchThrough.contains("gld")) {
            color = "Gold";
        } else if (searchThrough.contains("silver") || searchThrough.contains("slv")) {
            color = "Silver";
        }
        return color;
    }

    private String findColor(WebsiteProduct product) {
        String color = "";
        String itemID = GenericFunctions.getInstance().prepareString(product.getWebsiteElement().getItemID()).toLowerCase().replace(" ", "");
        String title = GenericFunctions.getInstance().prepareString(product.getItem().getItemName()).toLowerCase().replace(" ", "");
        String description = GenericFunctions.getInstance().prepareString(product.getWebsiteElement().getDescription()).toLowerCase().replace(" ", "");
        String brief = GenericFunctions.getInstance().prepareString(product.getWebsiteElement().getDescription()).toLowerCase().replace(" ", "");
        color = this.colorHelper(itemID);
        if (color.isEmpty()) {
            color = this.colorHelper(title);
        }
        if (color.isEmpty()) {
            color = this.colorHelper(description);
        }
        if (color.isEmpty()) {
            color = this.colorHelper(brief);
        }
        return color;
    }

    private String findShipping(float itemWeight) {
        int ONE_POUND = 16;
        String firstClass = "US::First Class:";
        String priority = "US::Priority:";
        String dollarClass = " USD";
        String price = "";
        String fullShipping = "";
        if (itemWeight <= 3.0f) {
            price = "2.32";
        } else if (itemWeight <= 4.0f) {
            price = "2.50";
        } else if (itemWeight <= 5.0f) {
            price = "2.68";
        } else if (itemWeight <= 6.0f) {
            price = "2.86";
        } else if (itemWeight <= 7.0f) {
            price = "3.04";
        } else if (itemWeight <= 8.0f) {
            price = "3.22";
        } else if (itemWeight <= 9.0f) {
            price = "3.40";
        } else if (itemWeight <= 10.0f) {
            price = "3.58";
        } else if (itemWeight <= 11.0f) {
            price = "3.76";
        } else if (itemWeight <= 12.0f) {
            price = "3.94";
        } else if (itemWeight <= 13.0f) {
            price = "4.12";
        } else if (itemWeight <= (float)ONE_POUND) {
            price = "6.95";
        } else if (itemWeight <= (float)(ONE_POUND * 2)) {
            price = "11.25";
        } else if (itemWeight <= (float)(ONE_POUND * 3)) {
            price = "15.10";
        } else if (itemWeight <= (float)(ONE_POUND * 4)) {
            price = "18.15";
        } else if (itemWeight <= (float)(ONE_POUND * 5)) {
            price = "21.00";
        } else if (itemWeight <= (float)(ONE_POUND * 6)) {
            price = "23.70";
        } else if (itemWeight <= (float)(ONE_POUND * 7)) {
            price = "26.65";
        } else if (itemWeight <= (float)(ONE_POUND * 8)) {
            price = "29.85";
        } else if (itemWeight <= (float)(ONE_POUND * 9)) {
            price = "33.20";
        }
        fullShipping = itemWeight < (float)ONE_POUND ? firstClass : priority;
        return fullShipping + price + dollarClass;
    }

    private String addLineGoogleFeed(WebsiteProduct product, String baseURL) {
        String googleProductCategory = "";
        if (this.associationManager != null && this.associationManager.getAssociations() != null && this.associationManager.getAssociations().containsKey(product.getWebsiteElement().getCategoryID())) {
            googleProductCategory = this.associationManager.getAssociations().get(product.getWebsiteElement().getCategoryID()).getGoogleCategoryName();
        }
        String newLine = "";
        String commaDelimiter = ",";
        String[] skuSplit = product.getWebsiteElement().getItemID().split("_");
        String baseSKU = skuSplit[0];
        String restrictedDescription = product.getWebsiteElement().getDescription().split("<BR>")[0].split("<br>")[0];
        String categoryName = "Other";
        if (this._categories.containsKey(product.getWebsiteElement().getCategoryID()) && this._categories.get(product.getWebsiteElement().getCategoryID()).getCategoryName() != null && !this._categories.get(product.getWebsiteElement().getCategoryID()).getCategoryName().isEmpty()) {
            categoryName = this._categories.get(product.getWebsiteElement().getCategoryID()).getCategoryName();
        }
        newLine = newLine + this.sanitizeFeed(product.getWebsiteElement().getItemID()) + commaDelimiter;
        newLine = newLine + this.sanitizeFeed(baseSKU) + commaDelimiter;
        newLine = newLine + this.sanitizeFeed(product.getItem().getItemName()) + commaDelimiter;
        newLine = newLine + this.sanitizeFeed(product.getWebsiteElement().getBriefDescription() + " " + categoryName + " " + restrictedDescription) + commaDelimiter;
        newLine = newLine + this.sanitizeFeed(googleProductCategory) + commaDelimiter;
        newLine = newLine + this.sanitizeFeed(categoryName) + commaDelimiter;
        newLine = newLine + this.sanitizeFeed(baseURL + baseSKU) + commaDelimiter;
        newLine = newLine + this.sanitizeFeed(product.getWebsiteElement().getPhoto1()) + commaDelimiter;
        newLine = newLine + this.sanitizeFeed("new") + commaDelimiter;
        newLine = newLine + this.sanitizeFeed("in stock") + commaDelimiter;
        newLine = newLine + this.sanitizeFeed(new DecimalFormat("#.##").format(product.getWebsiteElement().getPriceRetail())) + commaDelimiter;
        newLine = newLine + this.sanitizeFeed(product.getWebsiteElement().getOem()) + commaDelimiter;
        newLine = newLine + this.sanitizeFeed(product.getWebsiteElement().getItemID()) + commaDelimiter;
        newLine = newLine + this.sanitizeFeed(product.getWebsiteElement().getGender()) + commaDelimiter;
        newLine = newLine + this.sanitizeFeed(product.getWebsiteElement().getAgeGroup()) + commaDelimiter;
        newLine = newLine + this.sanitizeFeed(this.findSize(product)) + commaDelimiter;
        newLine = newLine + this.sanitizeFeed(this.findColor(product)) + commaDelimiter;
        newLine = newLine + this.sanitizeFeed("US:FL:7:") + commaDelimiter;
        newLine = newLine + this.sanitizeFeed(this.findShipping(product.getItem().getItemWeight())) + commaDelimiter;
        newLine = newLine + "\r\n";
        return newLine;
    }

    private String addLineBingFeed(WebsiteProduct product, String baseURL) {
        String newLine = "";
        String bingCategory = "";
        if (product.getInventoryElement().getItemQuantity() > 0) {
            String commaDelimiter = ",";
            String baseSKU = product.getWebsiteElement().getItemID().split("_")[0];
            String restrictedDescription = product.getWebsiteElement().getDescription().split("<BR>")[0].split("<br>")[0];
            String categoryName = "Other";
            if (this._categories.containsKey(product.getWebsiteElement().getCategoryID()) && this._categories.get(product.getWebsiteElement().getCategoryID()).getCategoryName() != null && !this._categories.get(product.getWebsiteElement().getCategoryID()).getCategoryName().isEmpty()) {
                categoryName = this._categories.get(product.getWebsiteElement().getCategoryID()).getCategoryName();
            }
            newLine = newLine + this.sanitizeFeed(product.getWebsiteElement().getItemID()) + commaDelimiter;
            newLine = !baseSKU.equalsIgnoreCase(product.getWebsiteElement().getItemID()) ? newLine + this.sanitizeFeed(product.getWebsiteElement().getBriefDescription() + " " + product.getItem().getItemName()) + commaDelimiter : newLine + this.sanitizeFeed(product.getItem().getItemName()) + commaDelimiter;
            newLine = newLine + this.sanitizeFeed(product.getWebsiteElement().getOem()) + commaDelimiter;
            newLine = newLine + this.sanitizeFeed(baseURL + baseSKU) + commaDelimiter;
            newLine = newLine + this.sanitizeFeed(new DecimalFormat("#.##").format(product.getWebsiteElement().getPriceRetail())) + commaDelimiter;
            newLine = newLine + this.sanitizeFeed(product.getWebsiteElement().getBriefDescription() + " " + categoryName + " " + restrictedDescription) + commaDelimiter;
            newLine = newLine + this.sanitizeFeed(product.getWebsiteElement().getPhoto1()) + commaDelimiter;
            newLine = newLine + this.sanitizeFeed(product.getWebsiteElement().getItemID()) + commaDelimiter;
            newLine = newLine + this.sanitizeFeed("In Stock") + commaDelimiter;
            newLine = newLine + this.sanitizeFeed("New") + commaDelimiter;
            newLine = newLine + this.sanitizeFeed(categoryName) + commaDelimiter;
            if (this.associationManager != null && this.associationManager.getAssociations() != null && this.associationManager.getAssociations().containsKey(product.getWebsiteElement().getCategoryID())) {
                bingCategory = this.associationManager.getAssociations().get(product.getWebsiteElement().getCategoryID()).getBingCategoryName();
            }
            newLine = newLine + this.sanitizeFeed(bingCategory) + commaDelimiter;
            newLine = newLine + "\r\n";
        }
        return newLine;
    }

    private void updateImportList() {
        try {
            String orderLine;
            String filename = "WebsiteImportResults_" + System.currentTimeMillis() + ".txt";
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(filename));
            String outputString = "Importing Website Change List";
            bufferedWriter.write(outputString);
            bufferedWriter.newLine();
            FileInputStream fstream = new FileInputStream(this.importLocation.getSelectedFile());
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((orderLine = br.readLine()) != null && !orderLine.contains("Item ID")) {
            }
            Object[] categories = LookupServicesUtil.getDBServices().getCategories();
            Arrays.sort(categories);
            HashMap<String, Object> categoryMap = new HashMap<String, Object>();
            for (int i = 0; i < categories.length; ++i) {
                categoryMap.put(categories[i].getCategoryName(), categories[i]);
            }
            while ((orderLine = br.readLine()) != null) {
                try {
                    String result;
                    String[] tokenized = orderLine.split("\t");
                    int position = 0;
                    String itemID = tokenized[position++].trim().toLowerCase();
                    Item item = LookupServicesUtil.getDBServices().getItem(itemID);
                    if (null != item) {
                        if (position < tokenized.length && !(result = tokenized[position++].trim()).isEmpty()) {
                            item.setItemName(result);
                            LookupServicesUtil.getDBServices().setItem(item);
                        }
                    } else {
                        String sku = itemID.split("\\*")[0].trim();
                        item = LookupServicesUtil.getDBServices().getItem(sku);
                        if (null != item) {
                            item.setItemID(itemID);
                            ArrayList<InventoryElement> elements = new ArrayList<InventoryElement>();
                            InventoryElement element = new InventoryElement();
                            element.setStockDate(new Date(System.currentTimeMillis()));
                            element.setItemCost(0.0f);
                            element.setItemQuantity(10);
                            element.setItemID(itemID);
                            InventoryElement baseElement = new InventoryElement();
                            baseElement.setItem(element.getItem());
                            baseElement.setItemID(element.getItemID());
                            baseElement.setItemQuantity(0);
                            baseElement.setOosItem(true);
                            baseElement.setItemCost(0.0f);
                            elements.add(baseElement);
                            elements.add(element);
                            LookupServicesUtil.getDBServices().setInventoryElementChain(elements);
                            item.setItemName(tokenized[position++].trim());
                            LookupServicesUtil.getDBServices().setItem(item);
                        }
                    }
                    if (null != item) {
                        String ageGroup;
                        String gender;
                        WebsiteElement websiteElement;
                        if (LookupServicesUtil.getDBServices().getWebsiteProductList().containsKey(itemID)) {
                            websiteElement = ((WebsiteProduct)LookupServicesUtil.getDBServices().getWebsiteProductList().get(itemID)).getWebsiteElement();
                        } else {
                            websiteElement = new WebsiteElement();
                            websiteElement.setItemID(itemID);
                        }
                        if (position < tokenized.length && !(result = tokenized[position++].trim()).isEmpty()) {
                            websiteElement.setOem(result);
                        }
                        if (position < tokenized.length && !(result = tokenized[position++].trim()).isEmpty()) {
                            result = result.replace("$", "");
                            websiteElement.setPrice(Float.valueOf(result).floatValue());
                        }
                        if (position < tokenized.length && !(result = tokenized[position++].trim()).isEmpty()) {
                            result = result.replace("$", "");
                            websiteElement.setPriceRetail(Float.valueOf(result).floatValue());
                        }
                        if (position < tokenized.length && !(result = tokenized[position++].trim()).isEmpty() && result.startsWith("http://")) {
                            websiteElement.setThumbnail(result);
                        }
                        if (position < tokenized.length) {
                            if (!(result = tokenized[position++].trim()).isEmpty() && result.startsWith("http://")) {
                                websiteElement.setPhoto1(result);
                            } else if (result.trim().equalsIgnoreCase("DELETE")) {
                                websiteElement.setPhoto1("");
                            }
                        }
                        if (position < tokenized.length) {
                            if (!(result = tokenized[position++].trim()).isEmpty() && result.startsWith("http://")) {
                                websiteElement.setPhoto2(result);
                            } else if (result.trim().equalsIgnoreCase("DELETE")) {
                                websiteElement.setPhoto2("");
                            }
                        }
                        if (position < tokenized.length) {
                            if (!(result = tokenized[position++].trim()).isEmpty() && result.startsWith("http://")) {
                                websiteElement.setPhoto3(result);
                            } else if (result.trim().equalsIgnoreCase("DELETE")) {
                                websiteElement.setPhoto3("");
                            }
                        }
                        if (position < tokenized.length) {
                            String returnedCategory;
                            String categoryName;
                            if (categoryMap.containsKey(categoryName = tokenized[position++].trim())) {
                                websiteElement.setCategoryID(((Category)categoryMap.get(categoryName)).getCategoryID());
                            } else if (!categoryName.isEmpty() && (returnedCategory = this.categoryManager.addCategory(categoryName)) != null && !returnedCategory.isEmpty()) {
                                Category category = new Category();
                                category.setCategoryName(returnedCategory);
                                categoryMap.put(category.getCategoryName(), category);
                                websiteElement.setCategoryID(((Category)categoryMap.get(categoryName)).getCategoryID());
                            }
                        }
                        String briefDescription = "";
                        String description = "";
                        String keywords = "";
                        if (position < tokenized.length) {
                            briefDescription = tokenized[position++].trim();
                        }
                        if (position < tokenized.length) {
                            description = tokenized[position++].trim();
                        }
                        if (position < tokenized.length) {
                            keywords = tokenized[position++].trim();
                        }
                        if (position < tokenized.length && (gender = tokenized[position++].trim()) != null && !gender.trim().isEmpty()) {
                            websiteElement.setGender(gender);
                        }
                        if (position < tokenized.length && (ageGroup = tokenized[position++].trim()) != null && !ageGroup.trim().isEmpty()) {
                            websiteElement.setAgeGroup(ageGroup);
                        }
                        if (position < tokenized.length) {
                            String enabled;
                            if ((enabled = tokenized[position++].trim()).contains("TRUE")) {
                                websiteElement.setEnabled(true);
                            } else {
                                websiteElement.setEnabled(false);
                            }
                        }
                        if (null != description && !description.isEmpty()) {
                            description = this.encodeHTML(description);
                        } else if (websiteElement.getDescription().isEmpty()) {
                            description = null != briefDescription && !briefDescription.isEmpty() ? briefDescription : "";
                        }
                        if (null != briefDescription && !briefDescription.isEmpty()) {
                            briefDescription = this.encodeHTML(briefDescription);
                        } else if (null != description && !description.isEmpty() && websiteElement.getBriefDescription().isEmpty()) {
                            briefDescription = description.length() > 95 ? description.substring(0, 95) + "..." : description;
                            if (briefDescription.contains("....")) {
                                briefDescription = briefDescription.replaceAll("....", "...");
                            }
                        } else {
                            briefDescription = "";
                        }
                        if (!briefDescription.isEmpty()) {
                            websiteElement.setBriefDescription(briefDescription);
                        }
                        if (description != null && !description.isEmpty()) {
                            websiteElement.setDescription(description);
                        }
                        if (!keywords.isEmpty()) {
                            keywords = this.encodeHTML(keywords);
                            websiteElement.setKeywords(keywords);
                        }
                        LookupServicesUtil.getDBServices().updateWebsiteElement(websiteElement);
                        continue;
                    }
                    outputString = "Error Unknown Item: " + itemID;
                    bufferedWriter.write(outputString);
                    bufferedWriter.newLine();
                }
                catch (Exception ex) {
                    if (ex.getMessage().contains("0")) {
                        ErrorsUtil.getInstance().logError(ex, false);
                    } else {
                        ErrorsUtil.getInstance().logError(ex);
                    }
                    outputString = "Error Importing Following Line:";
                    bufferedWriter.write(outputString);
                    bufferedWriter.newLine();
                    bufferedWriter.write(orderLine);
                    bufferedWriter.newLine();
                }
            }
            br.close();
            in.close();
            bufferedWriter.close();
            fstream.close();
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        JOptionPane.showMessageDialog(null, "Import Complete.");
        ListenerManager.getInstance().notify((GenericListener)ListenerManager.WEBSITE_ITEM_LIST_LISTENER);
    }

    private String encodeHTML(String dirtyString) {
        StringBuffer out = new StringBuffer();
        if (dirtyString.startsWith("\"")) {
            dirtyString = dirtyString.replaceFirst("\"", "");
        }
        if (dirtyString.endsWith("\"")) {
            dirtyString = dirtyString.substring(0, dirtyString.length() - 1);
        }
        dirtyString = dirtyString.replace("\"\"", "\"");
        return dirtyString;
    }

    public static synchronized WebsiteManagerTopComponent findInstance() {
        if (instance == null) {
            instance = new WebsiteManagerTopComponent();
        }
        return instance;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    Object readProperties(Properties p) {
        if (instance == null) {
            instance = this;
        }
        instance.readPropertiesImpl(p);
        return instance;
    }

    private void readPropertiesImpl(Properties p) {
        String version = p.getProperty("version");
    }

    public void websiteItemListUpdated() {
        if (null != LookupServicesUtil.getDBServices() && !this.applyButton.isEnabled()) {
            LookupServicesUtil.getDBServices().refreshWebsiteProductList();
            this.refreshNew(false);
            this.categoryManager.setWebsiteList(LookupServicesUtil.getDBServices().getWebsiteProductList());
        }
    }

    public void websiteListUpdated() {
        if (null != LookupServicesUtil.getDBServices()) {
            this.disableListener(true);
            this.websiteComboBox.setSelectedIndex(0);
            this.websiteComboBox.removeAllItems();
            this.activeCategoriesList.clearSelection();
            this.availableCategoriesList.clearSelection();
            Object[] websites = LookupServicesUtil.getDBServices().getWebsites();
            Arrays.sort(websites);
            this._websites.clear();
            this._websiteStringList.clear();
            for (int i = 0; i < websites.length; ++i) {
                String webName = websites[i].getWebsiteName();
                if (webName == null || webName.isEmpty()) continue;
                this._websites.put(websites[i].getWebsiteID(), (Website)websites[i]);
                this._websiteStringList.put(webName, (Website)websites[i]);
                this.websiteComboBox.addItem(webName);
            }
            this.addCategoryButton.setEnabled(false);
            this.removeCategoryButton.setEnabled(false);
            this.disableListener(false);
        }
    }

    private void updateCategories() {
        this.disableListener(true);
        Object[] categories = LookupServicesUtil.getDBServices().getCategories();
        this._categories.clear();
        this._categoryStringList.clear();
        this.activeCategoriesList.clearSelection();
        this.availableCategoriesList.clearSelection();
        Arrays.sort(categories);
        ((DefaultListModel)this.availableCategoryList.getModel()).clear();
        ((DefaultListModel)this.currentCategoryList.getModel()).clear();
        ((DefaultListModel)this.availableCategoryList.getModel()).addElement("All");
        for (int i = 0; i < categories.length; ++i) {
            this._categories.put(categories[i].getCategoryID(), (Category)categories[i]);
            this._categoryStringList.put(categories[i].getCategoryName(), (Category)categories[i]);
            ((DefaultListModel)this.availableCategoryList.getModel()).addElement(categories[i].getCategoryName());
        }
        this.disableListener(false);
    }

    public void categoryListUpdated() {
        if (null != LookupServicesUtil.getDBServices()) {
            this.updateCategories();
            this.disableListener(true);
            this.websiteComboBox.setSelectedIndex(0);
            this.addCategoryButton.setEnabled(false);
            this.removeCategoryButton.setEnabled(false);
            this.recreateCategoryList();
            this.disableListener(false);
        }
    }

    public void inventoryListUpdated() {
        if (null != LookupServicesUtil.getDBServices()) {
            LookupServicesUtil.getDBServices().getInventoryList("", false, false, true, new ArrayList().toArray(new String[0]), false);
            this.refreshNew(false);
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (!this.disableListener) {
            this.disableListener(true);
            try {
                int row = this.formattedWebsiteTable.getFormattedTable().getSelectedRow();
                int column = this.formattedWebsiteTable.getFormattedTable().getSelectedColumn();
                int convertedRow = this.formattedWebsiteTable.convertRow(row);
                if (row != -1 && column != -1 && convertedRow != -1) {
                    String value = this.formattedWebsiteTable.getValue(row, column);
                    this.handleTableChanged(convertedRow, row, this.formattedWebsiteTable.convertColumn(column), value);
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
            this.disableListener(false);
            this.updateAdditionalDetails();
        }
    }

    private WebsiteProduct getCurrentProduct(int row) {
        String itemID;
        WebsiteProduct product = null;
        if (row >= 0 && !(itemID = GenericFunctions.getInstance().prepareString(this.formattedWebsiteTable.getValue(row, "Item ID"))).isEmpty() && LookupServicesUtil.getDBServices().getWebsiteProductList().containsKey(itemID)) {
            product = (WebsiteProduct)LookupServicesUtil.getDBServices().getWebsiteProductList().get(itemID);
        }
        return product;
    }

    private void handleTableChanged(int row, int originalRow, int column, Object value) {
        boolean valid = true;
        if (value == null) {
            value = "";
        }
        String valueAt = GenericFunctions.getInstance().prepareString(value.toString());
        WebsiteProduct currentProduct = this.getCurrentProduct(originalRow);
        if (currentProduct != null) {
            boolean processUpdates = true;
            if (column == (Integer)this.formattedWebsiteTable.getReverseColumnMap().get("Item ID")) {
                this.formattedWebsiteTable.setValue((Object)currentProduct.getItem().getItemID(), originalRow, "Item ID");
                processUpdates = false;
            } else if (column == (Integer)this.formattedWebsiteTable.getReverseColumnMap().get("Item Name")) {
                this.formattedWebsiteTable.setValue((Object)currentProduct.getItem().getItemName(), originalRow, "Item Name");
                processUpdates = false;
            } else if (column == (Integer)this.formattedWebsiteTable.getReverseColumnMap().get("Quantity")) {
                this.formattedWebsiteTable.setValue((Object)currentProduct.getInventoryElement().getItemQuantity(), originalRow, "Quantity");
                processUpdates = false;
            } else if (column == (Integer)this.formattedWebsiteTable.getReverseColumnMap().get("Our Price")) {
                this.formattedWebsiteTable.setValue((Object)Float.valueOf(currentProduct.getInventoryElement().getItemCost()), originalRow, "Our Price");
                processUpdates = false;
            } else if (column == (Integer)this.formattedWebsiteTable.getReverseColumnMap().get("OEM")) {
                currentProduct.getWebsiteElement().setOem(valueAt);
            } else if (column == (Integer)this.formattedWebsiteTable.getReverseColumnMap().get("Price Wholesale")) {
                String itemPrice = MathParser.isDollarAmount((String)valueAt);
                if (null != itemPrice) {
                    currentProduct.getWebsiteElement().setPrice(Float.valueOf(itemPrice).floatValue());
                } else {
                    valid = false;
                }
            } else if (column == (Integer)this.formattedWebsiteTable.getReverseColumnMap().get("Price Retail")) {
                String itemPrice = MathParser.isDollarAmount((String)valueAt);
                if (null != itemPrice) {
                    currentProduct.getWebsiteElement().setPriceRetail(Float.valueOf(itemPrice).floatValue());
                } else {
                    valid = false;
                }
            } else if (column == (Integer)this.formattedWebsiteTable.getReverseColumnMap().get("Thumbnail")) {
                try {
                    URL u = new URL(valueAt);
                    currentProduct.getWebsiteElement().setThumbnail(u.toURI().toURL().toString());
                }
                catch (Exception ex) {
                    ErrorsUtil.getInstance().logError(ex);
                    valid = false;
                }
            } else if (column == (Integer)this.formattedWebsiteTable.getReverseColumnMap().get("Photo1")) {
                if (!valueAt.isEmpty()) {
                    try {
                        URL u = new URL(valueAt);
                        currentProduct.getWebsiteElement().setPhoto1(u.toURI().toURL().toString());
                    }
                    catch (Exception ex) {
                        ErrorsUtil.getInstance().logError(ex);
                        valid = false;
                    }
                } else {
                    currentProduct.getWebsiteElement().setPhoto1("");
                }
            } else if (column == (Integer)this.formattedWebsiteTable.getReverseColumnMap().get("Photo2")) {
                if (!valueAt.isEmpty()) {
                    try {
                        URL u = new URL(valueAt);
                        currentProduct.getWebsiteElement().setPhoto2(u.toURI().toURL().toString());
                    }
                    catch (Exception ex) {
                        ErrorsUtil.getInstance().logError(ex);
                        valid = false;
                    }
                } else {
                    currentProduct.getWebsiteElement().setPhoto2("");
                }
            } else if (column == (Integer)this.formattedWebsiteTable.getReverseColumnMap().get("Photo3")) {
                if (!valueAt.isEmpty()) {
                    try {
                        URL u = new URL(valueAt);
                        currentProduct.getWebsiteElement().setPhoto3(u.toURI().toURL().toString());
                    }
                    catch (Exception ex) {
                        ErrorsUtil.getInstance().logError(ex);
                        valid = false;
                    }
                } else {
                    currentProduct.getWebsiteElement().setPhoto3("");
                }
            } else if (column == (Integer)this.formattedWebsiteTable.getReverseColumnMap().get("Category")) {
                if (this._categoryStringList.containsKey(valueAt)) {
                    currentProduct.getWebsiteElement().setCategoryID(this._categoryStringList.get(valueAt).getCategoryID());
                }
            } else if (column == (Integer)this.formattedWebsiteTable.getReverseColumnMap().get("Featured")) {
                currentProduct.getWebsiteElement().setFeatured(Boolean.parseBoolean(valueAt));
            } else if (column == (Integer)this.formattedWebsiteTable.getReverseColumnMap().get("Enabled")) {
                currentProduct.getWebsiteElement().setEnabled(Boolean.parseBoolean(valueAt));
            } else if (column == (Integer)this.formattedWebsiteTable.getReverseColumnMap().get("Gender")) {
                currentProduct.getWebsiteElement().setGender(valueAt);
            } else if (column == (Integer)this.formattedWebsiteTable.getReverseColumnMap().get("AgeGroup")) {
                currentProduct.getWebsiteElement().setAgeGroup(valueAt);
            }
            if (processUpdates) {
                this.actualUpdatesNeeded.add(currentProduct.getItem().getItemID());
                this.processUpdatedCell(row, column, valid);
                this.updateNeeded(true);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        this.updateAdditionalDetails();
        this.disableSelectedButton.setEnabled(this.formattedWebsiteTable.getFormattedTable().getSelectedRow() != -1);
        this.enableSelectedButton.setEnabled(this.formattedWebsiteTable.getFormattedTable().getSelectedRow() != -1);
    }

    private void updateBriefDescription(KeyEvent evt) {
        try {
            WebsiteProduct currentProduct;
            String changedValue = this.briefDescriptionTextArea.getText().trim();
            if (evt != null && evt.getKeyChar() != '\b') {
                changedValue = changedValue + evt.getKeyChar();
            }
            if ((currentProduct = this.getCurrentProduct(this.formattedWebsiteTable.getFormattedTable().getSelectedRow())) != null && !currentProduct.getWebsiteElement().getBriefDescription().equals(changedValue)) {
                currentProduct.getWebsiteElement().setBriefDescription(changedValue);
                this.updateNeeded(true);
                this.actualUpdatesNeeded.add(currentProduct.getItem().getItemID());
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private void updateDescription(KeyEvent evt) {
        try {
            WebsiteProduct currentProduct;
            String changedValue = this.descriptionTextArea.getText().trim();
            if (evt != null && evt.getKeyChar() != '\b') {
                changedValue = changedValue + evt.getKeyChar();
            }
            if ((currentProduct = this.getCurrentProduct(this.formattedWebsiteTable.getFormattedTable().getSelectedRow())) != null && !currentProduct.getWebsiteElement().getDescription().equals(changedValue)) {
                currentProduct.getWebsiteElement().setDescription(changedValue);
                this.updateNeeded(true);
                this.actualUpdatesNeeded.add(currentProduct.getItem().getItemID());
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private void updateKeywords(KeyEvent evt) {
        try {
            WebsiteProduct currentProduct;
            String changedValue = this.keywordsTextArea.getText().trim();
            if (evt != null && evt.getKeyChar() != '\b') {
                changedValue = changedValue + evt.getKeyChar();
            }
            if ((currentProduct = this.getCurrentProduct(this.formattedWebsiteTable.getFormattedTable().getSelectedRow())) != null && !currentProduct.getWebsiteElement().getKeywords().equals(changedValue)) {
                currentProduct.getWebsiteElement().setKeywords(changedValue);
                this.updateNeeded(true);
                this.actualUpdatesNeeded.add(currentProduct.getItem().getItemID());
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private void processUpdatedCell(int row, int column, boolean valid) {
        if (valid) {
            this._validCellChanges.put(this.getUpdatedCellKey(row, column), new ChangedCell(row, column));
            this._invalidCellChanges.remove(this.getUpdatedCellKey(row, column));
        } else {
            this._invalidCellChanges.put(this.getUpdatedCellKey(row, column), new ChangedCell(row, column));
            this._validCellChanges.remove(this.getUpdatedCellKey(row, column));
        }
        this.formattedWebsiteTable.getRenderer().setValidCellChanges(this._validCellChanges);
        this.formattedWebsiteTable.getRenderer().setInvalidCellChanges(this._invalidCellChanges);
    }

    public String getUpdatedCellKey(int row, int column) {
        return "Row" + row + "Column" + column;
    }

    public ChangedCell checkValidCell(int row, int column) {
        return this._validCellChanges.get(this.getUpdatedCellKey(row, column));
    }

    public ChangedCell checkInvalidCell(int row, int column) {
        return this._invalidCellChanges.get(this.getUpdatedCellKey(row, column));
    }

    public String sanitize(String uncleanString) {
        String sanitizedString;
        if (null != uncleanString) {
            sanitizedString = uncleanString.replace("'", "");
            sanitizedString = sanitizedString.replace("\"", "");
            sanitizedString = sanitizedString.replace("--", "");
            sanitizedString = sanitizedString.trim().toUpperCase();
        } else {
            sanitizedString = "";
        }
        return sanitizedString;
    }

    private void updateNeeded(boolean dataChanged) {
        this.applyButton.setEnabled(dataChanged);
        this.publishButton.setEnabled(!dataChanged);
        this.searchButton.setEnabled(!dataChanged);
    }

    private boolean checkFilters(boolean disabledItems, boolean featuredItems, boolean missingCategory, WebsiteElement websiteElement) {
        boolean categoryMatches = false;
        boolean fitsFilterCategory = false;
        String categoryName = "ALL";
        if (this._categories.containsKey(websiteElement.getCategoryID())) {
            categoryName = this._categories.get(websiteElement.getCategoryID()).getCategoryName();
        }
        if (categoryName != null && !categoryName.trim().isEmpty()) {
            categoryMatches = true;
        }
        if (disabledItems && !websiteElement.isEnabled()) {
            fitsFilterCategory = true;
        }
        if (featuredItems && websiteElement.isFeatured()) {
            fitsFilterCategory = true;
        }
        if (missingCategory && websiteElement.getCategoryID() == 0) {
            fitsFilterCategory = true;
        }
        if (!(disabledItems || featuredItems || missingCategory)) {
            fitsFilterCategory = true;
        }
        return categoryMatches && fitsFilterCategory;
    }

    private void performSearch() {
        this.refreshNew(false);
    }

    private void updateAdditionalDetails() {
        if (!this.disableListener) {
            WebsiteProduct product = this.getCurrentProduct(this.formattedWebsiteTable.getFormattedTable().getSelectedRow());
            if (product != null) {
                this.briefDescriptionTextArea.setText(product.getWebsiteElement().getBriefDescription());
                this.descriptionTextArea.setText(product.getWebsiteElement().getDescription());
                this.keywordsTextArea.setText(product.getWebsiteElement().getKeywords());
            } else {
                this.briefDescriptionTextArea.setText("");
                this.keywordsTextArea.setText("");
                this.descriptionTextArea.setText("");
            }
        }
    }

    public void disableListener(boolean disabled) {
        this.disableListener = disabled;
    }

    public void LoginToggle() {
        if (SubscriptionManager.getInstance().isWebsiteActive()) {
            if (!this.currentStatus) {
                this.currentStatus = true;
                this.enableAll();
            }
        } else if (this.currentStatus) {
            this.currentStatus = false;
            this.disableAll();
        }
    }

    private void disablePanel(JPanel jPanel) {
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            jPanel.getComponent(i).setEnabled(false);
        }
    }

    private void enablePanel(JPanel jPanel) {
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            jPanel.getComponent(i).setEnabled(true);
        }
    }

    private void disableAll() {
        this.disablePanel(this.jPanel4);
        this.disablePanel(this.jPanel5);
        this.disablePanel(this.jPanel6);
        this.disablePanel(this.jPanel8);
        this.disablePanel(this.jPanel9);
        this.disablePanel(this.jPanel10);
        this.disablePanel(this.jPanel11);
        this.disablePanel(this.jPanel12);
        this.disablePanel(this.jPanel13);
        this.disablePanel(this.jPanel14);
        this.disablePanel(this.manageWebsitesPanel);
        this.disablePanel(this.manageCategoriesPanel);
        this.disablePanel(this.activeCategoriesPanel);
        this.disablePanel(this.manageItemDataPanel);
        this.formattedWebsiteTable.setEnabled(false);
        this.availableCategoriesList.setEnabled(false);
        this.activeCategoriesList.setEnabled(false);
    }

    private void enableAll() {
        this.enablePanel(this.jPanel4);
        this.enablePanel(this.jPanel5);
        this.enablePanel(this.jPanel6);
        this.enablePanel(this.jPanel8);
        this.enablePanel(this.jPanel9);
        this.enablePanel(this.jPanel10);
        this.enablePanel(this.jPanel11);
        this.enablePanel(this.jPanel12);
        this.enablePanel(this.jPanel13);
        this.enablePanel(this.jPanel14);
        this.enablePanel(this.manageWebsitesPanel);
        this.enablePanel(this.manageCategoriesPanel);
        this.enablePanel(this.activeCategoriesPanel);
        this.enablePanel(this.manageItemDataPanel);
        this.formattedWebsiteTable.setEnabled(true);
        this.availableCategoriesList.setEnabled(true);
        this.activeCategoriesList.setEnabled(true);
        this.applyButton.setEnabled(false);
    }

    private boolean isValidSearch(WebsiteProduct product) {
        String searchString = GenericFunctions.getInstance().prepareString(this.searchTextField.getText()).toUpperCase();
        if (!searchString.isEmpty()) {
            boolean containsSearch = false;
            containsSearch = product.getWebsiteElement().getItemID().toUpperCase().contains(searchString);
            if (!containsSearch) {
                containsSearch = product.getWebsiteElement().getOem().toUpperCase().contains(searchString);
            }
            if (!containsSearch) {
                containsSearch = product.getWebsiteElement().getBriefDescription().toUpperCase().contains(searchString);
            }
            if (!containsSearch) {
                containsSearch = product.getWebsiteElement().getDescription().toUpperCase().contains(searchString);
            }
            if (!containsSearch) {
                containsSearch = product.getWebsiteElement().getKeywords().toUpperCase().contains(searchString);
            }
            try {
                if (!containsSearch) {
                    containsSearch = product.getItem().getItemName().toUpperCase().contains(searchString);
                }
                if (!containsSearch) {
                    containsSearch = product.getItem().getDistributorProductID().toUpperCase().contains(searchString);
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
            return containsSearch;
        }
        return true;
    }

    private HashSet<String> collectShownCategories() {
        HashSet<String> categories = new HashSet<String>();
        for (int i = 0; i < this.currentCategoryList.getModel().getSize(); ++i) {
            Object obj = this.currentCategoryList.getModel().getElementAt(i);
            categories.add(obj.toString());
        }
        return categories;
    }

    private HashSet<WebsiteProduct> refreshNew(boolean collectResults) {
        this.disableListener(true);
        HashSet<WebsiteProduct> feedProducts = new HashSet<WebsiteProduct>();
        this.formattedWebsiteTable.getTableModel().setNumRows(0);
        this.briefDescriptionTextArea.setText("");
        this.keywordsTextArea.setText("");
        this.descriptionTextArea.setText("");
        boolean onlyEnabled = this.enabledItemsCheckBox.isSelected();
        boolean onlyDisabled = this.disabledItemsFilter.isSelected();
        boolean onlyOOS = this.oosCheckBox.isSelected();
        boolean onlyFeatured = this.featuredItemsFilter.isSelected();
        boolean onlyMissingCategory = this.missingCategoryFilter.isSelected();
        HashSet<String> shownCategories = this.collectShownCategories();
        for (WebsiteProduct product : LookupServicesUtil.getDBServices().getWebsiteProductList().values()) {
            boolean isEnabled = product.getWebsiteElement().isEnabled();
            boolean isDisabled = !product.getWebsiteElement().isEnabled();
            boolean isFeatured = product.getWebsiteElement().isFeatured();
            boolean isMissingCategory = product.getWebsiteElement().getCategoryID() <= 0;
            boolean isOOS = product.getInventoryElement().isOosItem() || product.getInventoryElement().getItemQuantity() <= 0;
            String categoryName = "None";
            if (!isMissingCategory && this._categories != null && this._categories.containsKey(product.getWebsiteElement().getCategoryID())) {
                categoryName = this._categories.get(product.getWebsiteElement().getCategoryID()).getCategoryName();
            }
            if (((!onlyEnabled || !isEnabled) && onlyEnabled || (!onlyDisabled || !isDisabled) && onlyDisabled) && (!onlyEnabled || !onlyDisabled) || (!onlyOOS || !isOOS) && onlyOOS || (!onlyFeatured || !isFeatured) && onlyFeatured || (!onlyMissingCategory || !isMissingCategory) && onlyMissingCategory || !shownCategories.contains("All") && !shownCategories.contains(categoryName) && (!shownCategories.isEmpty() || this.searchTextField.getText() == null || this.searchTextField.getText().isEmpty()) || !this.isValidSearch(product)) continue;
            if (collectResults) {
                feedProducts.add(product);
            }
            this.addRow(product);
        }
        this.disableListener(false);
        return feedProducts;
    }

    private void addRow(WebsiteProduct product) {
        Object[] row = new Object[this.formattedWebsiteTable.getTableModel().getColumnCount()];
        row[((Integer)this.formattedWebsiteTable.getReverseColumnMap().get((Object)"Item ID")).intValue()] = product.getWebsiteElement().getItemID();
        row[((Integer)this.formattedWebsiteTable.getReverseColumnMap().get((Object)"Item Name")).intValue()] = product.getItem().getItemName();
        row[((Integer)this.formattedWebsiteTable.getReverseColumnMap().get((Object)"Quantity")).intValue()] = product.getInventoryElement().getItemQuantity();
        row[((Integer)this.formattedWebsiteTable.getReverseColumnMap().get((Object)"Our Price")).intValue()] = Float.valueOf(product.getInventoryElement().getItemCost());
        row[((Integer)this.formattedWebsiteTable.getReverseColumnMap().get((Object)"OEM")).intValue()] = product.getWebsiteElement().getOem();
        row[((Integer)this.formattedWebsiteTable.getReverseColumnMap().get((Object)"Price Wholesale")).intValue()] = Float.valueOf(product.getWebsiteElement().getPrice());
        row[((Integer)this.formattedWebsiteTable.getReverseColumnMap().get((Object)"Price Retail")).intValue()] = Float.valueOf(product.getWebsiteElement().getPriceRetail());
        row[((Integer)this.formattedWebsiteTable.getReverseColumnMap().get((Object)"Thumbnail")).intValue()] = product.getWebsiteElement().getThumbnail();
        row[((Integer)this.formattedWebsiteTable.getReverseColumnMap().get((Object)"Photo1")).intValue()] = product.getWebsiteElement().getPhoto1();
        row[((Integer)this.formattedWebsiteTable.getReverseColumnMap().get((Object)"Photo2")).intValue()] = product.getWebsiteElement().getPhoto2();
        row[((Integer)this.formattedWebsiteTable.getReverseColumnMap().get((Object)"Photo3")).intValue()] = product.getWebsiteElement().getPhoto3();
        row[((Integer)this.formattedWebsiteTable.getReverseColumnMap().get((Object)"Category")).intValue()] = this._categories != null && this._categories.containsKey(product.getWebsiteElement().getCategoryID()) ? this._categories.get(product.getWebsiteElement().getCategoryID()).getCategoryName() : "";
        row[((Integer)this.formattedWebsiteTable.getReverseColumnMap().get((Object)"Featured")).intValue()] = product.getWebsiteElement().isFeatured();
        row[((Integer)this.formattedWebsiteTable.getReverseColumnMap().get((Object)"Gender")).intValue()] = product.getWebsiteElement().getGender();
        row[((Integer)this.formattedWebsiteTable.getReverseColumnMap().get((Object)"Age Group")).intValue()] = product.getWebsiteElement().getAgeGroup();
        if (this.associationManager != null && this.associationManager.getAssociations() != null && this.associationManager.getAssociations().containsKey(product.getWebsiteElement().getCategoryID())) {
            CategoryAssociation association = this.associationManager.getAssociations().get(product.getWebsiteElement().getCategoryID());
            row[((Integer)this.formattedWebsiteTable.getReverseColumnMap().get((Object)"Google Category")).intValue()] = association.getGoogleCategoryName();
            row[((Integer)this.formattedWebsiteTable.getReverseColumnMap().get((Object)"Bing Category")).intValue()] = association.getBingCategoryName();
        }
        row[((Integer)this.formattedWebsiteTable.getReverseColumnMap().get((Object)"Enabled")).intValue()] = product.getWebsiteElement().isEnabled();
        this.formattedWebsiteTable.getTableModel().addRow(row);
    }

    private static class TextFileFilter
    extends FileFilter {
        @Override
        public boolean accept(File file) {
            return file.getName().toLowerCase().endsWith(".txt") || file.isDirectory();
        }

        @Override
        public String getDescription() {
            return "Text files (*.txt)";
        }
    }
}

