/*
 * Decompiled with CFR 0.152.
 */
package pnp.etsy;

import com.google.gson.Gson;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JOptionPane;
import oauth.signpost.OAuth;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.basic.DefaultOAuthConsumer;
import oauth.signpost.basic.DefaultOAuthProvider;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import pnp.etsy.datatypes.Country;
import pnp.etsy.datatypes.CountryResult;
import pnp.etsy.datatypes.Receipt;
import pnp.etsy.datatypes.ReceiptResult;
import pnp.etsy.datatypes.Result;
import pnp.etsy.datatypes.Shop;
import pnp.etsy.datatypes.ShopResult;
import pnp.etsy.datatypes.Transaction;
import pnp.etsy.datatypes.Variation;
import pnp.services.datatypes.EtsyAccount;
import pnp.services.datatypes.EtsyOrder;
import pnp.services.datatypes.EtsyTransaction;
import pnp.services.util.ErrorsUtil;
import pnp.services.util.GenericFunctions;
import pnp.services.util.LookupServicesUtil;

public class EtsyConnectionManager {
    private final String ETSY_REQUEST_TOKEN_URL = "https://openapi.etsy.com/v2/oauth/request_token";
    private final String ETSY_ACCESS_TOKEN_URL = "https://openapi.etsy.com/v2/oauth/access_token";
    private final String ETSY_AUTHORIZE_URL = "https://www.etsy.com/oauth/signin";
    private static final String POST = "POST";
    private static final String GET = "GET";
    public static final String APIKey = "l931q0s2za7pm1qetlmyuggk";
    public static final String APISecret = "xrxsdkhpyr";
    private final HashMap<Integer, String> countryMap = new HashMap();
    private static EtsyConnectionManager _instance;

    public static EtsyConnectionManager getInstance() {
        if (null == _instance) {
            _instance = new EtsyConnectionManager();
        }
        return _instance;
    }

    protected void getTransactions(Date earliestDate) {
        if (earliestDate == null) {
            earliestDate = new Date();
        }
        earliestDate.setDate(earliestDate.getDate() - 5);
        final Date dateThing = earliestDate;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    HashMap resultList = new HashMap();
                    ArrayList accounts = LookupServicesUtil.getDBServices().getEtsyAccounts();
                    if (accounts != null) {
                        for (EtsyAccount account : accounts) {
                            String oAuthToken = account.getToken();
                            String oAuthSecret = account.getTokenSecret();
                            String store = account.getEtsyStore();
                            String login = account.getEtsyLogin();
                            EtsyConnectionManager.this.getCountryIDS(oAuthToken, oAuthSecret);
                            String page = "1";
                            while (page != null) {
                                String url = "https://openapi.etsy.com/v2/shops/" + store + "/transactions?limit=50000&offset=0&page=" + page;
                                HttpURLConnection con = EtsyConnectionManager.this.getResponse(oAuthToken, oAuthSecret, EtsyConnectionManager.GET, url);
                                Transaction listingResponse = (Transaction)new Gson().fromJson(EtsyConnectionManager.this.createJSONFromResponse(con), Transaction.class);
                                page = EtsyConnectionManager.this.collectTransactionResults(oAuthToken, oAuthSecret, store, login, listingResponse, dateThing, resultList);
                            }
                        }
                    }
                    LookupServicesUtil.getDBServices().addEtsyOrders(resultList);
                }
                catch (Exception ex) {
                    ErrorsUtil.getInstance().logError(ex);
                }
            }
        }).start();
    }

    private EtsyAccount getSpecificAccount(String store) {
        EtsyAccount specificAccount = null;
        ArrayList accounts = LookupServicesUtil.getDBServices().getEtsyAccounts();
        for (EtsyAccount account : accounts) {
            if (!account.getEtsyStore().equalsIgnoreCase(store)) continue;
            specificAccount = account;
        }
        return specificAccount;
    }

    protected void submitTracking(String store, String receiptID, String trackingNumber, String carrier) {
        try {
            EtsyAccount specificAccount = this.getSpecificAccount(store);
            if (specificAccount != null) {
                carrier = carrier.toLowerCase().contains("ups") ? "ups" : "usps";
                String trackingURL = "https://openapi.etsy.com/v2/shops/" + store + "/receipts/" + receiptID + "/tracking";
                ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
                nameValuePairs.add((NameValuePair)new BasicNameValuePair("tracking_code", trackingNumber));
                nameValuePairs.add((NameValuePair)new BasicNameValuePair("carrier_name", carrier));
                nameValuePairs.add((NameValuePair)new BasicNameValuePair("send_bcc", "false"));
                this.handlePostRequest(specificAccount, trackingURL, nameValuePairs);
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private void handlePostRequest(EtsyAccount specificAccount, String trackingURL, ArrayList<NameValuePair> nameValuePairs) {
        try {
            boolean first = true;
            String append = "";
            for (NameValuePair pair : nameValuePairs) {
                if (!first) {
                    append = append + "&";
                }
                append = append + pair.getName() + "=" + pair.getValue();
                first = false;
            }
            trackingURL = trackingURL + "?" + append;
            OAuthConsumer consumer = this.getConsumer(specificAccount.getToken(), specificAccount.getTokenSecret());
            HttpURLConnection con = (HttpURLConnection)new URL(trackingURL).openConnection();
            con.setRequestMethod(POST);
            con.setChunkedStreamingMode(trackingURL.getBytes("UTF8").length);
            con.setDoOutput(true);
            consumer.sign(con);
            con.connect();
            String test = this.readRequest(con.getInputStream());
            this.sleepThread();
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    private String readRequest(InputStream inputStream) throws Exception {
        String inputLine;
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        return response.toString();
    }

    private EtsyOrder getReceipt(String oAuthToken, String oAuthSecret, String receiptID) {
        String url = "https://openapi.etsy.com/v2/receipts/" + receiptID;
        HttpURLConnection con = this.getResponse(oAuthToken, oAuthSecret, GET, url);
        return this.collectReceiptResults(con);
    }

    private String getShippingFromListing(String oAuthToken, String oAuthSecret, String listingID) {
        String shippingTemplateID = this.getListing(oAuthToken, oAuthSecret, listingID);
        if (shippingTemplateID != null) {
            return this.getShipping(oAuthToken, oAuthSecret, shippingTemplateID);
        }
        return null;
    }

    private String getShipping(String oAuthToken, String oAuthSecret, String shippingTemplateID) {
        String url = "https://openapi.etsy.com/v2/shipping/templates/" + shippingTemplateID;
        HttpURLConnection con = this.getResponse(oAuthToken, oAuthSecret, GET, url);
        Transaction listingResponse = (Transaction)new Gson().fromJson(this.createJSONFromResponse(con), Transaction.class);
        if (listingResponse != null && listingResponse.getResults() != null && listingResponse.getResults().size() == 1) {
            return listingResponse.getResults().get(0).getTitle();
        }
        return null;
    }

    private String getListing(String oAuthToken, String oAuthSecret, String listingID) {
        String url = "https://openapi.etsy.com/v2/listings/" + listingID;
        HttpURLConnection con = this.getResponse(oAuthToken, oAuthSecret, GET, url);
        Transaction listingResponse = (Transaction)new Gson().fromJson(this.createJSONFromResponse(con), Transaction.class);
        if (listingResponse != null && listingResponse.getResults() != null && listingResponse.getResults().size() == 1) {
            return listingResponse.getResults().get(0).getShipping_template_id();
        }
        return null;
    }

    private void getCountryIDS(String oAuthToken, String oAuthSecret) {
        if (this.countryMap.isEmpty()) {
            String url = "https://openapi.etsy.com/v2/countries";
            HttpURLConnection con = this.getResponse(oAuthToken, oAuthSecret, GET, url);
            this.collectCountryResults(con);
        }
    }

    private void collectCountryResults(HttpURLConnection con) {
        if (con != null) {
            Country countryResponse = (Country)new Gson().fromJson(this.createJSONFromResponse(con), Country.class);
            if (countryResponse != null) {
                for (CountryResult result : countryResponse.getResults()) {
                    this.countryMap.put(result.getCountry_id(), result.getWorld_bank_country_code());
                }
            } else {
                JOptionPane.showMessageDialog(null, "Malformed Response, This is most likely a server error from Etsy");
            }
        }
    }

    private EtsyOrder collectReceiptResults(HttpURLConnection con) {
        EtsyOrder etsyOrder = null;
        if (con != null) {
            Receipt receiptResponse = (Receipt)new Gson().fromJson(this.createJSONFromResponse(con), Receipt.class);
            if (receiptResponse != null) {
                if (receiptResponse.getResults() != null && receiptResponse.getResults().size() == 1) {
                    ReceiptResult result = receiptResponse.getResults().get(0);
                    String customerName = result.getName();
                    String street1 = result.getFirst_line();
                    String street2 = "";
                    if (result.getSecond_line() != null) {
                        street2 = result.getSecond_line().toString();
                    }
                    String city = result.getCity();
                    String state = result.getState();
                    String zip = result.getZip();
                    String countryName = "USA";
                    if (this.countryMap.containsKey(result.getCountry_id())) {
                        countryName = this.countryMap.get(result.getCountry_id());
                    }
                    Float totalPrice = this.getFloat(result.getTotal_price());
                    Float totalShipping = this.getFloat(result.getTotal_shipping_cost());
                    Float totalTax = this.getFloat(result.getTotal_tax_cost());
                    String customerEmail = result.getBuyer_email();
                    Float grandTotal = this.getFloat(result.getGrandtotal());
                    String sellerEmail = result.getSeller_email();
                    boolean paid = false;
                    if (result.getPayment_method().equals("cc")) {
                        paid = true;
                    }
                    etsyOrder = new EtsyOrder(customerName, street1, street2, city, state, zip, countryName, totalPrice, totalShipping, totalTax, customerEmail, grandTotal, sellerEmail, paid);
                }
            } else {
                JOptionPane.showMessageDialog(null, "Malformed Response, This is most likely a server error from Etsy");
            }
        }
        return etsyOrder;
    }

    private String collectTransactionResults(String oAuthToken, String oAuthSecret, String store, String login, Transaction listingResponse, Date earliestDate, HashMap<String, EtsyOrder> resultList) {
        if (listingResponse != null) {
            for (Result result : listingResponse.getResults()) {
                EtsyOrder etsyOrder;
                Date creationDate = this.createDateFromEpoch(result.getCreation_tsz());
                Date paidDate = this.createDateFromEpoch(result.getPaid_tsz());
                Date shippedDate = this.createDateFromEpoch(result.getShipped_tsz());
                if (creationDate.before(earliestDate) || shippedDate != null) continue;
                String receiptID = result.getReceipt_id();
                if (!resultList.containsKey(receiptID)) {
                    etsyOrder = this.getReceipt(oAuthToken, oAuthSecret, receiptID);
                    etsyOrder.setStoreName(store);
                    etsyOrder.setLoginName(login);
                } else {
                    etsyOrder = resultList.get(receiptID);
                }
                String transactionID = result.getTransaction_id();
                String title = result.getTitle();
                String description = result.getDescription();
                String ourUserID = result.getSeller_user_id();
                String theirUserID = result.getBuyer_user_id();
                Float price = this.getFloat(result.getPrice());
                String currencyCode = result.getCurrency_code();
                int quantity = this.getInteger(result.getQuantity());
                String imageListingID = result.getImage_listing_id();
                Float shippingCost = this.getFloat(result.getShipping_cost());
                String listingID = result.getListing_id();
                String itemSKU = this.createVariation((ArrayList)result.getVariations());
                EtsyTransaction etsyTransaction = new EtsyTransaction(transactionID, title, description, ourUserID, theirUserID, creationDate, paidDate, shippedDate, price, currencyCode, quantity, imageListingID, receiptID, shippingCost, listingID, itemSKU);
                etsyOrder.addTransaction(etsyTransaction);
                etsyOrder.setShippingMethod(this.getShippingFromListing(oAuthToken, oAuthSecret, listingID));
                resultList.put(receiptID, etsyOrder);
            }
            return listingResponse.getPagination().getNext_page();
        }
        return null;
    }

    private int getInteger(String number) {
        int newNumber = 1;
        if (number != null && !number.trim().isEmpty()) {
            try {
                newNumber = Integer.parseInt(number);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return newNumber;
    }

    private Float getFloat(String cost) {
        Float newCost = Float.valueOf(0.0f);
        if (cost != null && !cost.trim().isEmpty()) {
            try {
                newCost = Float.valueOf(Float.parseFloat(cost));
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return newCost;
    }

    private Date createDateFromEpoch(String epochDate) {
        Date newDate = null;
        if (epochDate != null && !epochDate.trim().isEmpty()) {
            try {
                long epochLong = Long.parseLong(epochDate.trim());
                long epochConversion = 1000L;
                newDate = new Date(epochLong * epochConversion);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return newDate;
    }

    private String createVariation(ArrayList<Variation> variations) {
        String[] splitSize;
        String size = "";
        String style = "";
        String color = "";
        String multiplier = "";
        String defaultVariationStyle = "";
        if (variations != null) {
            for (Variation variation : variations) {
                String formattedName = variation.getFormatted_name();
                String formattedValue = variation.getFormatted_value();
                if (formattedName.equalsIgnoreCase("Size")) {
                    size = formattedValue;
                    continue;
                }
                if (formattedName.equalsIgnoreCase("Style")) {
                    style = formattedValue;
                    continue;
                }
                if (formattedName.equalsIgnoreCase("Color")) {
                    color = formattedValue;
                    continue;
                }
                defaultVariationStyle = defaultVariationStyle + formattedName + " : " + formattedValue;
                if (variations.size() <= 1) continue;
                defaultVariationStyle = defaultVariationStyle + "|";
            }
        }
        color = color.replace(" ", "").toLowerCase();
        style = style.replace(" ", "").toLowerCase();
        if (!defaultVariationStyle.isEmpty()) {
            if (!style.isEmpty()) {
                defaultVariationStyle = defaultVariationStyle + style;
            }
            if (!size.isEmpty()) {
                defaultVariationStyle = defaultVariationStyle + size;
            }
            if (!color.isEmpty()) {
                defaultVariationStyle = defaultVariationStyle + color;
            }
            return defaultVariationStyle;
        }
        if (!color.isEmpty()) {
            return style + "_" + color;
        }
        if (size.replace(" ", "").isEmpty()) {
            return style;
        }
        int multiplierLocation = style.indexOf("*");
        if (multiplierLocation != -1) {
            try {
                multiplier = style.substring(multiplierLocation, style.length());
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
            try {
                style = style.substring(0, multiplierLocation);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        if ((splitSize = size.toLowerCase().split(" ")).length > 0) {
            size = splitSize[0].replace("mm", "");
        }
        size = size.replace(" ", "");
        return style + "_" + size + multiplier;
    }

    private boolean doOauth(OAuthConsumer consumer) {
        try {
            DefaultOAuthProvider provider = new DefaultOAuthProvider("https://openapi.etsy.com/v2/oauth/request_token?scope=transactions_r%20transactions_w%20listings_r", "https://openapi.etsy.com/v2/oauth/access_token", "https://www.etsy.com/oauth/signin");
            String authUrl = provider.retrieveRequestToken(consumer, "oob");
            authUrl = OAuth.addQueryParameters(authUrl, "oauth_consumer_key", APIKey, "application_name", "Gamut");
            Desktop.getDesktop().browse(new URI(authUrl));
            String pin = JOptionPane.showInputDialog(null, (Object)"Please input the Pin retrieved from Etsy");
            provider.retrieveAccessToken(consumer, pin);
            return true;
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
            return false;
        }
    }

    private String createJSONFromResponse(HttpURLConnection connection) {
        StringBuilder response = new StringBuilder();
        try {
            String inputLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        return response.toString();
    }

    private OAuthConsumer getConsumer(String oAuthToken, String oAuthSecret) {
        DefaultOAuthConsumer consumer = null;
        oAuthSecret = GenericFunctions.getInstance().prepareString(oAuthSecret);
        oAuthToken = GenericFunctions.getInstance().prepareString(oAuthToken);
        if (oAuthSecret.isEmpty() || oAuthToken.isEmpty()) {
            JOptionPane.showMessageDialog(null, "No elligible accounts were detected");
        } else {
            consumer = new DefaultOAuthConsumer(APIKey, APISecret);
            consumer.setTokenWithSecret(oAuthToken, oAuthSecret);
        }
        return consumer;
    }

    protected boolean registerOAuth() {
        DefaultOAuthConsumer consumer;
        if (!APIKey.isEmpty() && !APISecret.isEmpty() && this.doOauth(consumer = new DefaultOAuthConsumer(APIKey, APISecret))) {
            String token = GenericFunctions.getInstance().prepareString(consumer.getToken());
            String tokenSecret = GenericFunctions.getInstance().prepareString(consumer.getTokenSecret());
            if (!token.isEmpty() && !tokenSecret.isEmpty()) {
                this.getShops(token, tokenSecret);
                return true;
            }
            JOptionPane.showMessageDialog(null, "Problem Authorizing Account");
        }
        return false;
    }

    private void getShops(String OAuthToken, String OAuthSecret) {
        String url = "https://openapi.etsy.com/v2/users/__SELF__/shops";
        HttpURLConnection con = this.getResponse(OAuthToken, OAuthSecret, GET, url);
        Shop shopResponse = (Shop)new Gson().fromJson(this.createJSONFromResponse(con), Shop.class);
        if (shopResponse != null && shopResponse.getResults() != null) {
            for (ShopResult result : shopResponse.getResults()) {
                LookupServicesUtil.getDBServices().updateEtsyAccount(new EtsyAccount(result.getLogin_name(), result.getShop_name(), OAuthToken, OAuthSecret));
            }
        }
    }

    private HttpURLConnection getConnection(String GetPost, OAuthConsumer consumer, String url) {
        HttpURLConnection con = null;
        int tries = 0;
        try {
            do {
                URL obj = new URL(url);
                con = (HttpURLConnection)obj.openConnection();
                consumer.sign(con);
                con.setRequestMethod(GetPost);
                con.setRequestProperty("User-Agent", "Mozilla/5.0");
            } while (con.getResponseCode() != 200 && ++tries <= 3);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        return con;
    }

    private HttpURLConnection getResponse(String oAuthToken, String oAuthSecret, String GetPost, String url) {
        OAuthConsumer consumer = this.getConsumer(oAuthToken, oAuthSecret);
        if (consumer != null && consumer.getToken() != null && !consumer.getToken().trim().isEmpty() && consumer.getTokenSecret() != null && !consumer.getTokenSecret().trim().isEmpty()) {
            HttpURLConnection con = this.getConnection(GetPost, consumer, url);
            if (con != null) {
                this.sleepThread();
                return con;
            }
            JOptionPane.showMessageDialog(null, "Error: Connection aborted.");
        } else {
            JOptionPane.showMessageDialog(null, "Problem acquiring authentication. Please make sure you accepted our permissions.");
        }
        return null;
    }

    private void sleepThread() {
        try {
            Thread.sleep(200L);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }
}

