/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk;

import com.ebay.sdk.SdkException;
import com.ebay.soap.eBLBaseComponents.ErrorType;
import com.ebay.soap.eBLBaseComponents.SeverityCodeType;

public class ApiException
extends SdkException {
    private ErrorType[] errors;

    public ApiException() {
    }

    public ApiException(ErrorType[] errorTypeArray) {
        this.errors = errorTypeArray;
    }

    public ErrorType[] getErrors() {
        return this.errors;
    }

    public void setErrors(ErrorType[] errorTypeArray) {
        this.errors = errorTypeArray;
    }

    private int countErrors(String string) {
        int n = 0;
        for (int i = 0; i < this.errors.length; ++i) {
            SeverityCodeType severityCodeType = this.errors[i].getSeverityCode();
            if (severityCodeType == null || !severityCodeType.value().equals(string)) continue;
            ++n;
        }
        return n;
    }

    public int getSeverityErrorCount() {
        return this.countErrors(SeverityCodeType.ERROR.value());
    }

    public int getSeverityWarningCount() {
        return this.countErrors(SeverityCodeType.WARNING.value());
    }

    public String getMessage() {
        String string = "";
        if (this.errors != null) {
            for (int i = 0; i < this.errors.length; ++i) {
                String string2;
                if (i > 0) {
                    string = string + "\n";
                }
                if (!((string2 = this.errors[i].getLongMessage()) != null && string2.length() != 0 || (string2 = this.errors[i].getShortMessage()) != null && string2.length() != 0)) {
                    String string3 = this.errors[i].getErrorCode();
                    string2 = string3 != null ? string3 : "";
                }
                string = string + string2;
            }
        }
        return string;
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public boolean containsErrorCode(String string) {
        for (int i = 0; i < this.errors.length; ++i) {
            String string2 = this.errors[i].getErrorCode();
            if (string2 == null || !string2.equals(string)) continue;
            return true;
        }
        return false;
    }
}

