/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk;

import com.ebay.sdk.ApiContext;
import com.ebay.sdk.ApiCredential;
import com.ebay.sdk.SdkException;
import com.ebay.sdk.SiteIDUtil;
import com.ebay.sdk.util.XmlUtil;
import com.ebay.sdk.util.eBayUtil;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ApiSchemaBasedXmlPoster {
    private ApiContext apiContext;

    public ApiContext getApiContext() {
        return this.apiContext;
    }

    public void setApiContext(ApiContext apiContext) {
        this.apiContext = apiContext;
    }

    public String postXmlText(int n, String string) throws SAXException, IOException, ParserConfigurationException, TransformerException, SdkException {
        Document document = XmlUtil.createDom(string);
        Node node = document.getFirstChild();
        String string2 = node.getNodeName();
        String string3 = string2.substring(0, string2.length() - 7);
        if (string3.length() == 0) {
            throw new SdkException("No <Verb> found in request Xml.");
        }
        String string4 = XmlUtil.getChildStringByName(node, "Version", "");
        if (string4.length() == 0) {
            throw new SdkException("No <Version> found in request Xml.");
        }
        HttpURLConnection httpURLConnection = this.openConnection();
        httpURLConnection.setRequestProperty("X-EBAY-API-COMPATIBILITY-LEVEL", string4);
        httpURLConnection.setRequestProperty("X-EBAY-API-CALL-NAME", string3);
        httpURLConnection.setRequestProperty("X-EBAY-API-SITEID", String.valueOf(SiteIDUtil.toNumericalID(this.apiContext.getSite())));
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(httpURLConnection.getOutputStream());
        outputStreamWriter.write(string);
        outputStreamWriter.flush();
        outputStreamWriter.close();
        return eBayUtil.convertInputStreamToString(httpURLConnection.getInputStream());
    }

    private HttpURLConnection openConnection() throws MalformedURLException, IOException {
        ApiCredential apiCredential = this.apiContext.getApiCredential();
        URL uRL = new URL(this.apiContext.getApiServerUrl());
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setDoInput(true);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setRequestProperty("Content-Type", "text/xml");
        httpURLConnection.setRequestProperty("X-EBAY-API-COMPATIBILITY-LEVEL", this.apiContext.getWSDLVersion());
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setRequestMethod("POST");
        return httpURLConnection;
    }
}

