/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.handler;

import com.ebay.sdk.ApiAccount;
import com.ebay.sdk.ApiContext;
import com.ebay.sdk.ApiLogging;
import com.ebay.sdk.eBayAccount;
import com.ebay.sdk.handler.BaseHandler;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientAuthenticationHandler
extends BaseHandler<SOAPMessageContext>
implements SOAPHandler<SOAPMessageContext> {
    private final String HANDLER_NAME = "ClientAuthenticationHandler";
    private static final Logger log = LoggerFactory.getLogger(ClientAuthenticationHandler.class);

    public ClientAuthenticationHandler() {
        super.setHandlerName("ClientAuthenticationHandler");
    }

    public boolean handleMessage(SOAPMessageContext sOAPMessageContext) {
        boolean bl = (Boolean)sOAPMessageContext.get((Object)"javax.xml.ws.handler.message.outbound");
        if (bl) {
            ApiContext apiContext = (ApiContext)sOAPMessageContext.get((Object)"api_context");
            boolean bl2 = false;
            Object object = sOAPMessageContext.get((Object)"full_credentials");
            if (object != null) {
                bl2 = (Boolean)object;
            }
            boolean bl3 = false;
            object = sOAPMessageContext.get((Object)"api_account_only");
            if (object != null) {
                bl3 = (Boolean)object;
            }
            try {
                SOAPMessage sOAPMessage = sOAPMessageContext.getMessage();
                SOAPEnvelope sOAPEnvelope = sOAPMessage.getSOAPPart().getEnvelope();
                SOAPHeader sOAPHeader = sOAPEnvelope.getHeader();
                if (sOAPHeader == null) {
                    sOAPHeader = sOAPEnvelope.addHeader();
                }
                this.addSecurityHeader(sOAPHeader, apiContext, bl2, bl3);
            }
            catch (SOAPException sOAPException) {
                ApiLogging apiLogging = apiContext.getApiLogging();
                if (apiLogging != null && apiLogging.isLogExceptions()) {
                    log.error("ClientAuthenticationHandler : fail to add security headers.");
                    log.error(sOAPException.getMessage());
                }
                sOAPException.printStackTrace();
            }
        }
        return true;
    }

    private void addSecurityHeader(SOAPHeader sOAPHeader, ApiContext apiContext, boolean bl, boolean bl2) throws SOAPException {
        SOAPElement sOAPElement = sOAPHeader.addChildElement("RequesterCredentials", "ebl", "urn:ebay:apis:eBLBaseComponents");
        ((SOAPHeaderElement)sOAPElement).setMustUnderstand(false);
        sOAPElement.addNamespaceDeclaration("ebl", "urn:ebay:apis:eBLBaseComponents");
        String string = apiContext.getApiCredential().geteBayToken();
        if (bl) {
            SOAPElement sOAPElement2 = sOAPElement.addChildElement("Credentials", "ebl");
            ApiAccount apiAccount = apiContext.getApiCredential().getApiAccount();
            sOAPElement2.addChildElement("AppId", "ebl").addTextNode(apiAccount.getApplication());
            sOAPElement2.addChildElement("DevId", "ebl").addTextNode(apiAccount.getDeveloper());
            sOAPElement2.addChildElement("AuthCert", "ebl").addTextNode(apiAccount.getCertificate());
            sOAPElement.addChildElement("eBayAuthToken", "ebl").addTextNode(string);
            return;
        }
        if (bl2) {
            SOAPElement sOAPElement3 = sOAPElement.addChildElement("Credentials", "ebl");
            ApiAccount apiAccount = apiContext.getApiCredential().getApiAccount();
            sOAPElement3.addChildElement("AppId", "ebl").addTextNode(apiAccount.getApplication());
            sOAPElement3.addChildElement("DevId", "ebl").addTextNode(apiAccount.getDeveloper());
            sOAPElement3.addChildElement("AuthCert", "ebl").addTextNode(apiAccount.getCertificate());
            eBayAccount eBayAccount2 = apiContext.getApiCredential().geteBayAccount();
            if (eBayAccount2 != null && eBayAccount2.getUsername() != null) {
                sOAPElement3.addChildElement("Username", "ebl").addTextNode(eBayAccount2.getUsername());
            }
            return;
        }
        if (string == null || string.length() == 0) {
            SOAPElement sOAPElement4 = sOAPElement.addChildElement("Credentials", "ebl");
            ApiAccount apiAccount = apiContext.getApiCredential().getApiAccount();
            sOAPElement4.addChildElement("AppId", "ebl").addTextNode(apiAccount.getApplication());
            sOAPElement4.addChildElement("DevId", "ebl").addTextNode(apiAccount.getDeveloper());
            sOAPElement4.addChildElement("AuthCert", "ebl").addTextNode(apiAccount.getCertificate());
        } else {
            sOAPElement.addChildElement("eBayAuthToken", "ebl").addTextNode(string);
        }
    }

    public Set<QName> getHeaders() {
        return null;
    }
}

