/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.handler;

import com.ebay.sdk.ApiContext;
import com.ebay.sdk.ApiLogging;
import com.ebay.sdk.handler.BaseHandler;
import com.ebay.sdk.handler.HandlerUtil;
import java.util.Map;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.LogicalMessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPHeaderLoggingHandler
extends BaseHandler<LogicalMessageContext>
implements LogicalHandler<LogicalMessageContext> {
    private static final String HANDLER_NAME = "HTTPHeaderLoggingHandler";
    private static final Logger log = LoggerFactory.getLogger(HTTPHeaderLoggingHandler.class);

    public HTTPHeaderLoggingHandler() {
        super.setHandlerName(HANDLER_NAME);
    }

    public boolean handleMessage(LogicalMessageContext logicalMessageContext) {
        Boolean bl = (Boolean)logicalMessageContext.get((Object)"javax.xml.ws.handler.message.outbound");
        if (!bl.booleanValue()) {
            ApiContext apiContext = (ApiContext)logicalMessageContext.get((Object)"api_context");
            ApiLogging apiLogging = apiContext.getApiLogging();
            if (apiLogging == null || !apiLogging.isLogHTTPHeaders()) {
                return true;
            }
            Map map = (Map)logicalMessageContext.get((Object)"javax.xml.ws.http.request.headers");
            Map map2 = (Map)logicalMessageContext.get((Object)"javax.xml.ws.http.response.headers");
            log.info("---[HTTP Request Headers]---");
            if (map != null) {
                log.info(HandlerUtil.outputMap(map));
            } else {
                log.info("HTTP Request Headers is not available!");
            }
            log.info("---[HTTP Response Headers]---");
            if (map2 != null) {
                log.info(HandlerUtil.outputMap(map2));
            } else {
                log.info("HTTP Response Headers is not available!");
            }
        }
        return true;
    }
}

