/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.handler;

import com.ebay.sdk.ApiContext;
import com.ebay.sdk.ApiLogging;
import com.ebay.sdk.handler.BaseHandler;
import com.ebay.sdk.util.XmlUtil;
import java.text.MessageFormat;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPMessageLoggingHandler
extends BaseHandler<SOAPMessageContext>
implements SOAPHandler<SOAPMessageContext> {
    private static final String HANDLER_NAME = "SOAPMessageLoggingHandler";
    private static final Logger log = LoggerFactory.getLogger(SOAPMessageLoggingHandler.class);

    public SOAPMessageLoggingHandler() {
        super.setHandlerName(HANDLER_NAME);
    }

    public boolean handleMessage(SOAPMessageContext sOAPMessageContext) {
        Object object;
        ApiContext apiContext = (ApiContext)sOAPMessageContext.get((Object)"api_context");
        ApiLogging apiLogging = apiContext.getApiLogging();
        String string = null;
        try {
            object = sOAPMessageContext.getMessage();
            Source source = object.getSOAPPart().getContent();
            string = XmlUtil.getXmlStringFromSource(source);
        }
        catch (Exception exception) {
            if (apiLogging != null && apiLogging.isLogExceptions()) {
                log.error("SOAPMessageLoggingHandler : fail to get xml string from SOAP message");
                log.error(exception.getMessage());
            } else {
                exception.printStackTrace();
            }
            return true;
        }
        object = (Boolean)sOAPMessageContext.get((Object)"javax.xml.ws.handler.message.outbound");
        if (((Boolean)object).booleanValue()) {
            apiContext.setRequestXml(string);
            if (apiLogging != null && apiLogging.isLogSOAPMessages()) {
                this.logMessage("Request", string);
            }
        } else {
            apiContext.setResponseXml(string);
            if (apiLogging != null && apiLogging.isLogSOAPMessages()) {
                this.logMessage("Response", string);
            }
        }
        return true;
    }

    @Override
    public boolean handleFault(SOAPMessageContext sOAPMessageContext) {
        ApiContext apiContext = (ApiContext)sOAPMessageContext.get((Object)"api_context");
        ApiLogging apiLogging = apiContext.getApiLogging();
        String string = null;
        try {
            SOAPMessage sOAPMessage = sOAPMessageContext.getMessage();
            Source source = sOAPMessage.getSOAPPart().getContent();
            string = XmlUtil.getXmlStringFromSource(source);
        }
        catch (Exception exception) {
            if (apiLogging != null && apiLogging.isLogExceptions()) {
                log.error("SOAPMessageLoggingHandler : fail to get xml string from SOAP message");
                log.error(exception.getMessage());
            } else {
                exception.printStackTrace();
            }
            return true;
        }
        apiContext.setResponseXml(string);
        if (apiLogging != null && apiLogging.isLogSOAPMessages()) {
            this.logMessage("Response", string);
        }
        return true;
    }

    private void logMessage(String string, String string2) {
        String string3 = MessageFormat.format("{0} Message: Length={1}", string, new Integer(string2.length()));
        log.info(string3);
        log.info(string2);
    }

    public Set<QName> getHeaders() {
        return null;
    }
}

